//=============================================================================
// VisuStella MZ - Battle Core
// VisuMZ_1_BattleCore.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_1_BattleCore = true;

var VisuMZ = VisuMZ || {};
VisuMZ.BattleCore = VisuMZ.BattleCore || {};
VisuMZ.BattleCore.version = 1.86;

//=============================================================================
 /*:
 * @target MZ
 * @plugindesc [RPG Maker MZ] [Tier 1] [Version 1.86] [BattleCore]
 * @author VisuStella
 * @url http://www.yanfly.moe/wiki/Battle_Core_VisuStella_MZ
 * @orderAfter VisuMZ_0_CoreEngine
 *
 * @help
 * ============================================================================
 * Introduction
 * ============================================================================
 *
 * The Battle Core plugin revamps the battle engine provided by RPG Maker MZ to
 * become more flexible, streamlined, and support a variety of features. The
 * updated battle engine allows for custom Action Sequences, battle layout
 * styles, and a lot of control over the battle mechanics, too.
 *
 * Features include all (but not limited to) the following:
 * 
 * * Action Sequence Plugin Commands to give you full control over what happens
 *   during the course of a skill or item.
 * * Animated Sideview Battler support for enemies!
 * * Auto Battle options for party-wide and actor-only instances.
 * * Base Troop Events to quickly streamline events for all Troop events.
 * * Battle Command control to let you change which commands appear for actors.
 * * Battle Layout styles to change the way the battle scene looks.
 * * Casting animation support for skills.
 * * Critical Hit control over the success rate formula and damage multipliers.
 * * Custom target scopes added for skills and items.
 * * Damage formula control, including Damage Styles.
 * * Damage caps, both hard caps and soft caps.
 * * Damage traits such Armor Penetration/Reduction to bypass defenses.
 * * Elements & Status Menu Core support for traits.
 * * Multitude of JavaScript notetags and global Plugin Parameters to let you
 *   make a variety of effects across various instances during battle.
 * * Party Command window can be skipped/disabled entirely.
 * * Weather effects now show in battle.
 * * Streamlined Battle Log to remove redundant information and improve the
 *   flow of battle.
 * * Visual HP Gauges can be displayed above the heads of actors and/or enemies
 *   with a possible requirement for enemies to be defeated at least once first
 *   in order for them to show.
 *
 * ============================================================================
 * Requirements
 * ============================================================================
 *
 * This plugin is made for RPG Maker MZ. This will not work in other iterations
 * of RPG Maker.
 *
 * ------ Tier 1 ------
 *
 * This plugin is a Tier 1 plugin. Place it under other plugins of lower tier
 * value on your Plugin Manager list (ie: 0, 1, 2, 3, 4, 5). This is to ensure
 * that your plugins will have the best compatibility with the rest of the
 * VisuStella MZ library.
 *
 * ============================================================================
 * Major Changes
 * ============================================================================
 *
 * This plugin will overwrite some core parts of the RPG Maker MZ base code in
 * order to ensure the Battle Core plugin will work at full capacity. The
 * following are explanations of what has been changed.
 *
 * ---
 *
 * Action Sequences
 *
 * - Action sequences are now done either entirely by the Battle Log Window or
 * through common events if the <Custom Action Sequence> notetag is used.
 * In RPG Maker MZ by default, Action Sequences would be a mixture of using the
 * Battle Log Window, the Battle Manager, and the Battle Scene, making it hard
 * to fully grab control of the situation.
 *
 * ---
 *
 * Action Speed
 *
 * - Action speeds determine the turn order in the default battle system. The
 * AGI of a battle unit is also taken into consideration. However, the random
 * variance applied to the action speed system makes the turn order extremely
 * chaotic and hard for the player to determine. Thus, the random variance
 * aspect of it has been turned off. This can be reenabled by default through
 * Plugin Parameters => Mechanics Settings => Allow Random Speed?
 *
 * ---
 *
 * Animated Sideview Battler Support For Enemies
 *
 * - Enemies can now use Sideview Actor sprites for themselves! They will
 * behave like actors and can even carry their own set of weapons for physical
 * attacks. These must be set up using notetags. More information can be found
 * in the notetag section.
 *
 * - As the sprites are normally used for actors, some changes have been made
 * to Sprite_Actor to be able to support both actors and enemies. These changes
 * should have minimal impact on other plugins.
 *
 * ---
 *
 * Battle Sprite Updates
 *
 * - A lot of functions in Sprite_Battler, Sprite_Actor, and Sprite_Enemy have
 * been overwritten to make the new Action Sequence system added by this plugin
 * possible. These changes make it possible for the sprites to move anywhere on
 * the screen, jump, float, change visibility, and more.
 *
 * ---
 *
 * Change Battle Back in Battle
 * 
 * - By default, the Change Battle Back event command does not work in battle.
 * Any settings made to it will only reflect in the following battle. Now, if
 * the battle back event command is used during battle, it will reflect upon
 * any new changes immediately.
 *
 * ---
 *
 * Critical Hit - LUK Influence
 *
 * - The LUK Buffs now affect the critical hit rate based off how the formula
 * is now calculated. Each stack of a LUK Buff will double the critical hit
 * rate and compound upon that. That means a x1 LUK Buff stack will raise it by
 * x2, a x2 LUK Buff stack will raise the critical hit rate by x4, a x3 LUK
 * Buff Stack will raise the critical hit rate stack by x8, and so on.
 *
 * - LUK also plays a role in how much damage is dealt with critical hits. The
 * default critical hit multiplier has been reduced from x3 to x2. However, a
 * percentage of LUK will added on (based off the user's CRI rate) onto the
 * finalized critical damage. If the user's CRI rate is 4%, then 4% of the user
 * LUK value will also be added onto the damage.
 *
 * - This change can be altered through Plugin Parameters => Damage Settings =>
 * Critical Hits => JS: Rate Formula and JS: Damage Formula.
 *
 * ---
 * 
 * Damage Popups
 * 
 * - Damage popups are now formatted with + and - to determine healing and
 * damage. MP Damage will also include "MP" at the back. This is to make it
 * clearer what each colored variant of the damage popup means as well as help
 * color blind players read the on-screen data properly.
 * 
 * - Damage popups have also been rewritten to show all changed aspects instead
 * of just one. Previously with RPG Maker MZ, if an action would deal both HP
 * and MP damage, only one of them would show. Now, everything is separated and
 * both HP and MP changes will at a time.
 * 
 * ---
 * 
 * Dual Wielding
 * 
 * - Previously, RPG Maker MZ had "Dual Wielding" attack using both weapon
 * animations at once, with the combined ATK of each weapon. It's confusing to
 * look at and does not portray the nature of "Dual Wielding".
 * 
 * - Dual Wielding, or in the case of users adding in third and fourth weapons,
 * Multi Wielding is now changed. Each weapon is displayed individually, each
 * producing its own attack animation, showing each weapon type, and applying
 * only that weapon's ATK, Traits, and related effects. It is no longer a
 * combined effect to display everything at once like RPG Maker MZ default.
 * 
 * - If an actor has multiple weapon slots but some of them are unequipped,
 * then the action will treat the attack as a single attack. There will be no
 * barehanded attack to add on top of it. This is to match RPG Maker MZ's
 * decision to omit a second animation if the same scenario is applied.
 * 
 * ---
 *
 * Force Action
 *
 * - Previously, Forced Actions would interrupt the middle of an event to
 * perform an action. However, with the addition of more flexible Action
 * Sequences, the pre-existing Force Action system would not be able to exist
 * and would require being remade.
 *
 * - Forced Actions now are instead, added to a separate queue from the action
 * battler list. Whenever an action and/or common event is completed, then if
 * there's a Forced Action battler queued, then the Forced Action battler will
 * have its turn. This is the cleanest method available and avoids the most
 * conflicts possible.
 *
 * - This means if you planned to make cinematic sequences with Forced Actions,
 * you will need to account for the queued Force Actions. However, in the case
 * of battle cinematics, we would highly recommend that you use the newly added
 * Action Sequence Plugin Commands instead as those give you more control than
 * any Force Action ever could.
 *
 * ---
 *
 * Random Scope
 *
 * - The skill and item targeting scopes for Random Enemy, 2 Random Enemies,
 * 3 Random Enemies, 4 Random Enemies will now ignore TGR and utilize true
 * randomness.
 *
 * ---
 *
 * Spriteset_Battle Update
 *
 * - The spriteset now has extra containers to separate battlers (actors and
 * enemies), animations, and damage. This is to make actors and enemy battler
 * sprites more efficient to sort (if enabled), so that animations won't
 * interfere with and cover damage sprites, and to make sure damage sprites are
 * unaffected by screen tints in order to ensure the player will always have a
 * clear read on the information relaying sprites.
 *
 * ---
 * 
 * TPB/ATB Active Battle Actor Shifting
 * 
 * - Pressing cancel on the Actor Command Window no longer switches between
 * actors with a full TPB/ATB gauge before reaching the Party Command Window.
 * This is to accomplish a couple of things: 1) reduce the number of button
 * presses to reach the Party Command Window and 2) to prevent motion resets
 * and disrupting action sequences. If this feature is vital to your battle
 * system, we recommend that you do not use this plugin or any of the Battle
 * Core-required plugins.
 * 
 * ---
 *
 * Weather Displayed in Battle
 *
 * - Previously, weather has not been displayed in battle. This means that any
 * weather effects placed on the map do not transfer over to battle and causes
 * a huge disconnect for players. The Battle Core plugin will add weather
 * effects to match the map's weather conditions. Any changes made to weather
 * through event commands midway through battle will also be reflected.
 *
 * ---
 *
 * ============================================================================
 * Base Troops
 * ============================================================================
 *
 * Base Troops can be found, declared, and modified in the Plugin Parameters =>
 * Mechanics Settings => Base Troop ID's. All of the listed Troop ID's here
 * will have their page events replicated and placed under all other troops
 * found in the database.
 *
 * ---
 *
 * This means that if you have an event that runs on Turn 1 of a Base Troop,
 * then for every troop out there, that same event will also run on Turn 1,
 * as well. This is useful for those who wish to customize their battle system
 * further and to reduce the amount of work needed to copy/paste said event
 * pages into every database troop object manually.
 *
 * ---
 *
 * ============================================================================
 * Damage Styles
 * ============================================================================
 *
 * Damage Styles are a new feature added through the Battle Core plugin. When
 * using certain Battle Styles, you can completely ignore typing in the whole
 * damage formula inside the damage formula input box, and instead, insert
 * either a power amount or a multiplier depending on the Damage Style. The
 * plugin will then automatically calculate damage using that value factoring
 * in ATK, DEF, MAT, MDF values.
 *
 * ---
 *
 * Here is a list of the Damage Styles that come with this plugin by default.
 * You can add in your own and even edit them to your liking.
 * Or just remove them if you want.
 *
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 * Style          Use Formula As   PH/MA Disparity   Stat Scale   Damage Scale
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 * Standard       Formula          No                Varies       Varies
 * ArmorScaling   Formula          No                Varies       Varies
 * CT             Multiplier       Yes               Low          Normal
 * D4             Multiplier       No                High         Normal
 * DQ             Multiplier       No                Low          Low
 * FF7            Power            Yes               Low          High
 * FF8            Power            Yes               Medium       Normal
 * FF9            Power            Yes               Low          Normal
 * FF10           Power            Yes               Medium       High
 * MK             Multiplier       No                Medium       Low
 * MOBA           Multiplier       No                Medium       Normal
 * PKMN           Power            No                Low          Normal
 *
 * Use the above chart to figure out which Damage Style best fits your game,
 * if you plan on using them.
 *
 * The 'Standard' style is the same as the 'Manual' formula input, except that
 * it allows for the support of <Armor Penetration> and <Armor Reduction>
 * notetags.
 *
 * The 'Armor Scaling' style allows you to type in the base damage calculation
 * without the need to type in any defending modifiers.
 *
 * NOTE: While these are based off the damage formulas found in other games,
 * not all of them are exact replicas. Many of them are adapted for use in
 * RPG Maker MZ since not all RPG's use the same set of parameters and not all
 * external multipliers function the same way as RPG Maker MZ.
 * 
 * ---
 *
 * Style:
 * - This is what the Damage Style is.
 *
 * Use Formula As:
 * - This is what you insert into the formula box.
 * - Formula: Type in the formula for the action just as you would normally.
 * - Multiplier: Type in the multiplier for the action.
 *     Use float values. This means 250% is typed out as 2.50
 * - Power: Type in the power constant for the action.
 *     Use whole numbers. Type in something like 16 for a power constant.
 * 
 * PH/MA Disparity:
 * - Is there a disparity between how Physical Attacks and Magical Attacks
 *   are calculated?
 * - If yes, then physical attacks and magical attacks will have different
 *   formulas used.
 * - If no, then physical attacks and magical attacks will share similar
 *   formulas for how they're calculated.
 *
 * Stat Scale:
 * - How much should stats scale throughout the game?
 * - Low: Keep them under 100 for the best results.
 * - Medium: Numbers work from low to mid 400's for best results.
 * - High: The numbers really shine once they're higher.
 *
 * Damage Scale:
 * - How much does damage vary depending on small parameter changes?
 * - Low: Very little increase from parameter changes.
 * - Normal: Damage scales close to proportionally with parameter changes.
 * - High: Damage can boost itself drastically with parameter changes.
 *
 * ---
 *
 * To determine what kind of parameters are used for the Damage Styles, they
 * will depend on two things: the action's 'Hit Type' (ie Physical Attack,
 * Magical Attack, and Certain Hit) and the action's 'Damage Type' (ie. Damage,
 * Recovery, or Drain).
 *
 * Certain Hit tends to use whichever value is higher: ATK or MAT, and then
 * ignores the target's defense values. Use Certain Hits for 'True Damage'.
 *
 * Use the chart below to figure out everything else:
 * 
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 * Hit Type      Damage Type   Attacker Parameter   Defender Parameter
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 * Physical      Damage        ATK                  DEF
 * Magical       Damage        MAT                  MDF
 * Certain Hit   Damage        Larger (ATK, MAT)    -Ignores-
 * Physical      Recover       DEF                  -Ignores-
 * Magical       Recover       MDF                  -Ignores-
 * Certain Hit   Recover       Larger (ATK, MAT)    -Ignores-
 * Physical      Drain         ATK                  DEF
 * Magical       Drain         MAT                  MDF
 * Certain Hit   Drain         Larger (ATK, MAT)    -Ignores-
 *
 * These can be modified within the Plugin Parameters in the individual
 * Damage Styles themselves.
 *
 * ---
 *
 * Skills and Items can use different Damage Styles from the setting you've
 * selected in the Plugin Parameters. They can be altered to have different
 * Damage Styles through the usage of a notetag:
 *
 * <Damage Style: name>
 *
 * This will use whichever style is found in the Plugin Parameters.
 *
 * If "Manual" is used, then no style will be used and all calculations will be
 * made strictly based off the formula found inside the formula box.
 *
 * ---
 *
 * ============================================================================
 * VisuStella MZ Compatibility
 * ============================================================================
 *
 * While this plugin is compatible with the majority of the VisuStella MZ
 * plugin library, it is not compatible with specific plugins or specific
 * features. This section will highlight the main plugins/features that will
 * not be compatible with this plugin or put focus on how the make certain
 * features compatible.
 *
 * ---
 * 
 * VisuMZ_1_BattleCore
 * 
 * When using Action Sequences, Boost effects for damage, turn extensions,
 * analyze, etc. will not occur for anything other than the Action Sequence:
 * "MECH: Action Effect" in order to maintain controlled effects. However, if
 * you do want to apply bonuses for Boosts, utilize "MECH: Boost Store Data" to
 * store inside a variable how many times Boosts were used. This can be used
 * however which way you want it to as long as it is manageable through events
 * and Common Events.
 * 
 * ---
 *
 * ============================================================================
 * Notetags
 * ============================================================================
 *
 * The following are notetags that have been added through this plugin. These
 * notetags will not work with your game if this plugin is OFF or not present.
 * 
 * ---
 * 
 * === HP Gauge-Related Notetags ===
 * 
 * The following notetags allow you to set whether or not HP Gauges can be
 * displayed by enemies regardless of Plugin Parameter settings.
 * 
 * ---
 *
 * <Show HP Gauge>
 *
 * - Used for: Enemy Notetags
 * - Will always show the HP Gauge for the enemy regardless of the defeat
 *   requirement setting.
 * - This does not bypass the player's Options preferences.
 * - This does not bypass disabling enemy HP Gauges as a whole.
 * 
 * ---
 *
 * <Hide HP Gauge>
 *
 * - Used for: Enemy Notetags
 * - Will always hide the HP Gauge for the enemy regardless of the defeat
 *   requirement setting.
 * - This does not bypass the player's Options preferences.
 * 
 * ---
 * 
 * <Battle UI Offset: +x, +y>
 * <Battle UI Offset: -x, -y>
 * 
 * <Battle UI Offset X: +x>
 * <Battle UI Offset X: -x>
 * 
 * <Battle UI Offset Y: +y>
 * <Battle UI Offset Y: -y>
 * 
 * - Used for: Actor and Enemy Notetags
 * - Adjusts the offset of HP Gauges and State Icons above the heads of actors
 *   and enemies.
 * - Replace 'x' with a number value that offsets the x coordinate.
 * - Negative x values offset left. Positive x values offset right.
 * - Replace 'y' with a number value that offsets the y coordinate.
 * - Negative y values offset up. Positive x values offset down.
 * 
 * ---
 *
 * === Animation-Related Notetags ===
 *
 * The following notetags allow you to set animations to play at certain
 * instances and/or conditions.
 *
 * ---
 *
 * <Slip Animation: x>
 *
 * - Requires VisuMZ_0_CoreEngine!
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - During the phase at which the user regenerates HP, MP, or TP, this
 *   animation will play as long as the user is alive and visible.
 * - Replace 'x' with a number value representing the Animation ID to play.
 *
 * ---
 *
 * <Cast Animation: x>
 *
 * - Used for: Skill Notetags
 * - Plays a battle animation at the start of the skill.
 * - Replace 'x' with a number value representing the Animation ID to play.
 *
 * ---
 *
 * <Attack Animation: x>
 *
 * - Used for: Enemy Notetags
 * - Gives an enemy an attack animation to play for its basic attack.
 * - Replace 'x' with a number value representing the Animation ID to play.
 *
 * ---
 * 
 * <Under>
 * 
 * - Used for: Animation Name Tags
 * - If this tag is found in an animation's name, the animation will appear
 *   under battlers while in battle.
 * - This effect only applies to battlers in the battle scene.
 * - Under effect is NOT applied to status window portraits.
 * - Under effect is NOT applied to projectile animations.
 * 
 * ---
 *
 * === Battleback-Related Notetags ===
 *
 * You can apply these notetags to have some control over the battlebacks that
 * appear in different regions of the map for random or touch encounters.
 *
 * ---
 *
 * <Region x Battleback1: filename>
 * <Region x Battleback2: filename>
 * 
 * - Used for: Map Notetags
 * - If the player starts a battle while standing on 'x' region, then the
 *   'filename' battleback will be used.
 * - Replace 'x' with a number representing the region ID you wish to use.
 * - Replace 'filename' with the filename of the graphic to use. Do not insert
 *   any extensions. This means the file 'Castle1.png' will be only inserted
 *   as 'Castle1' without the '.png' at the end.
 * - *NOTE: This will override any specified battleback settings.
 *
 * ---
 *
 * === Battle Command-Related Notetags ===
 *
 * You can use notetags to change how the battle commands of playable
 * characters appear in battle as well as whether or not they can be used.
 *
 * ---
 *
 * <Seal Attack>
 * <Seal Guard>
 * <Seal Item>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Prevents specific battle commands from being able to be used.
 *
 * ---
 *
 * <Battle Commands>
 *  Attack
 *  Skills
 *  SType: x
 *  SType: name
 *  All Skills
 *  Skill: x
 *  Skill: name
 *  Guard
 *  Item
 *  Status
 *  Party
 *  Escape
 *  Auto Battle
 *  Combat Log
 *  Talk
 *  Weapon Swap
 * </Battle Commands>
 *
 * - Used for: Class Notetags
 * - Changes which commands appear in the Actor Command Window in battle.
 *   If this notetag is not used, then the default commands determined in
 *   Plugin Parameters => Actor Command Window => Command List will be used.
 * - Add/remove/modify entries as needed.
 *
 * - Attack 
 *   - Adds the basic attack command.
 * 
 * - Skills
 *   - Displays all the skill types available to the actor.
 * 
 * - SType: x
 * - Stype: name
 *   - Adds in a specific skill type.
 *   - Replace 'x' with the ID of the skill type.
 *   - Replace 'name' with the name of the skill type (without text codes).
 *
 * - All Skills
 *   - Adds all usable battle skills as individual actions.
 * 
 * - Skill: x
 * - Skill: name
 *   - Adds in a specific skill as a usable action.
 *   - Replace 'x' with the ID of the skill.
 *   - Replace 'name' with the name of the skill.
 * 
 * - Guard
 *   - Adds the basic guard command.
 * 
 * - Item
 *   - Adds the basic item command.
 * 
 * - Status
 *   - Adds a status command to view the current inputting actor's status.
 *
 * - Party
 *   - Requires VisuMZ_2_PartySystem.
 *   - Allows this actor to switch out with a different party member.
 * 
 * - Escape
 *   - Adds the escape command.
 * 
 * - Auto Battle
 *   - Adds the auto battle command.
 * 
 * - Combat Log
 *   - Requires VisuMZ_4_CombatLog.
 *   - Opens up the combat log.
 * 
 * - Talk
 *   - Requires VisuMZ_3_BattleCmdTalk!
 *   - Shows talk command if applicable.
 * 
 * - Weapon Swap
 *   - Requires VisuMZ_2_WeaponSwapSystem.
 *   - Swaps the current weapon.
 *
 * Example:
 *
 * <Battle Commands>
 *  Attack
 *  Skill: Heal
 *  Skills
 *  Guard
 *  Item
 *  Escape
 * </Battle Commands>
 *
 * ---
 *
 * <Command Text: x>
 *
 * - Used for: Skill Notetags
 * - When a skill is used in a <Battle Commands> notetag set, you can change
 *   the skill name text that appears to something else.
 * - Replace 'x' with the skill's name you want to shown in the Actor Battle
 *   Command window.
 * - Recommended Usage: Shorten skill names that are otherwise too big to fit
 *   inside of the Actor Battle Command window.
 *
 * ---
 *
 * <Command Icon: x>
 *
 * - Used for: Skill Notetags
 * - When a skill is used in a <Battle Commands> notetag set, you can change
 *   the skill icon that appears to something else.
 * - Replace 'x' with the ID of icon you want shown in the Actor Battle Command
 *   window to represent the skill.
 * 
 * ---
 * 
 * <Command Require Learn>
 * 
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not by whether the actor has
 *   learned the skill.
 * - Learning the skill is a requirement. Acquiring the skill through traits
 *   does not count as learning the skill.
 * 
 * ---
 * 
 * <Command Require Access>
 * 
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not by whether the actor has
 *   access to the skill.
 * - Having access to the skill can come through either learning the skill or
 *   temporarily acquiring it through trait objects.
 * 
 * ---
 * 
 * <Command Show Switch: x>
 * 
 * <Command Show All Switches: x,x,x>
 * <Command Show Any Switches: x,x,x>
 * 
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not through switches.
 * - Replace 'x' with the switch ID to determine the skill's visibility.
 * - If 'All' notetag variant is used, item will be hidden until all
 *   switches are ON. Then, it would be shown.
 * - If 'Any' notetag variant is used, item will be shown if any of the
 *   switches are ON. Otherwise, it would be hidden.
 * - This can be applied to Attack and Guard commands, too.
 * 
 * ---
 * 
 * <Command Hide Switch: x>
 * 
 * <Command Hide All Switches: x,x,x>
 * <Command Hide Any Switches: x,x,x>
 * 
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not through switches.
 * - Replace 'x' with the switch ID to determine the skill's visibility.
 * - If 'All' notetag variant is used, item will be shown until all
 *   switches are ON. Then, it would be hidden.
 * - If 'Any' notetag variant is used, item will be hidden if any of the
 *   switches are ON. Otherwise, it would be shown.
 * - This can be applied to Attack and Guard commands, too.
 * 
 * ---
 * 
 * <Battle Portrait: filename>
 *
 * - Used for: Actor
 * - This is used with the "Portrait" Battle Layout.
 * - Sets the battle portrait image for the actor to 'filename'.
 * - Replace 'filename' with a picture found within your game project's
 *   img/pictures/ folder. Filenames are case sensitive. Leave out the filename
 *   extension from the notetag.
 * - This will override any menu images used for battle only.
 * 
 * ---
 * 
 * <Battle Portrait Offset: +x, +y>
 * <Battle Portrait Offset: -x, -y>
 * 
 * <Battle Portrait Offset X: +x>
 * <Battle Portrait Offset X: -x>
 * 
 * <Battle Portrait Offset Y: +y>
 * <Battle Portrait Offset Y: -y>
 *
 * - Used for: Actor
 * - This is used with the "Portrait" and "Border" Battle Layouts.
 * - Offsets the X and Y coordinates for the battle portrait.
 * - Replace 'x' with a number value that offsets the x coordinate.
 * - Negative x values offset left. Positive x values offset right.
 * - Replace 'y' with a number value that offsets the y coordinate.
 * - Negative y values offset up. Positive x values offset down.
 * 
 * ---
 *
 * <Help Description>
 *  text
 *  text
 * </Help Description>
 *
 * - Used for: State Notetags
 * - Assigns a help description for the state that's displayed under the
 *   "Status" actor command.
 * - Replace 'text' with text you want displayed for the help window.
 * - This best works with one line for compatibility with other plugins.
 * - Insert %1 into the help description to show any data that would otherwise
 *   be shown as the state display, such as Absorption Barrier count.
 * - This is used as a common notetag between Battle Core's state descriptions
 *   and State Tooltips' state descriptions.
 * 
 * ---
 * 
 * <In-Battle Status Description>
 *  text
 *  text
 * </In-Battle Status Description>
 * - Assigns a help description for the state that's displayed under the
 *   "Status" actor command.
 * - Replace 'text' with text you want displayed for the help window.
 * - This best works with one line for compatibility with other plugins.
 * - Insert %1 into the help description to show any data that would otherwise
 *   be shown as the state display, such as Absorption Barrier count.
 * - The description used here will not be used for State Tooltips.
 * - If both <Help Description> and <In-Battle Status Description> notetags
 *   exist in the same state, priority will be given to this one for the
 *   In-Battle Status Window.
 *
 * ---
 * 
 * <Exclude From Status Listing>
 * 
 * - Used for: State Notetags
 * - Excludes the state from being displayed in the status listing.
 * 
 * ---
 * 
 * === JavaScript Notetag: Battle Command-Related ===
 *
 * The following are notetags made for users with JavaScript knowledge to
 * determine if skill-based battle commands are visible or hidden.
 * 
 * ---
 * 
 * <JS Command Visible>
 *  code
 *  code
 *  visible = code;
 * </JS Command Visible>
 * 
 * - Used for: Skill Notetags
 * - The 'visible' variable is the final returned variable to determine the
 *   skill's visibility in the Battle Command Window.
 * - Replace 'code' with JavaScript code to determine the skill's visibility in
 *   the Battle Command Window.
 * - The 'user' variable represents the user who will perform the skill.
 * - The 'skill' variable represents the skill to be used.
 * 
 * ---
 *
 * === Targeting-Related Notetags ===
 *
 * The following notetags are related to the targeting aspect of skills and
 * items and may adjust the scope of how certain skills/items work.
 *
 * ---
 *
 * <Always Hit>
 *
 * <Always Hit Rate: x%>
 *
 * - Used for: Skill, Item Notetags
 * - Causes the action to always hit or to always have a hit rate of exactly
 *   the marked x%.
 * - Replace 'x' with a number value representing the hit success percentage.
 *
 * ---
 *
 * <Repeat Hits: x>
 *
 * - Used for: Skill, Item Notetags
 * - Changes the number of hits the action will produce.
 * - Replace 'x' with a number value representing the number of hits to incur.
 *
 * ---
 *
 * <Target: x Random Any>
 *
 * - Used for: Skill, Item Notetags
 * - Makes the skill pick 'x' random targets when used.
 * - Targets can be both actors and enemies.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 * - Replace 'x' with a number value representing the number of random targets.
 *
 * ---
 *
 * <Target: x Random Enemies>
 *
 * - Used for: Skill, Item Notetags
 * - Makes the skill pick 'x' random targets when used.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 * - Targets are only enemies.
 * - Replace 'x' with a number value representing the number of random targets.
 *
 * ---
 *
 * <Target: x Random Allies>
 *
 * - Used for: Skill, Item Notetags
 * - Makes the skill pick 'x' random targets when used.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 * - Targets are only actors.
 * - Replace 'x' with a number value representing the number of random targets.
 *
 * ---
 *
 * <Target: All Allies But User>
 *
 * - Used for: Skill, Item Notetags
 * - Targets all allies with the exception of the user.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 *
 * ---
 * 
 * <Target: Ally or Enemy>
 * 
 * - Used for: Skill, Item Notetags
 * - Allows the player to target allies or enemies with the skill/item.
 *   - Keep in mind this does NOT allow you to select dead party members.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 * - Target selection emphasis will go to allies first.
 * - Ignored when used by enemies and will be treated as an ally scope.
 * - Auto-battle actors will also treat this action as an ally scope.
 * - For certain battle layouts in frontview, this will open the Actor Select
 *   window in order for Touch Input to be able to select actors.
 * 
 * ---
 * 
 * <Target: Enemy or Ally>
 * 
 * - Used for: Skill, Item Notetags
 * - Allows the player to target enemies or allies with the skill/item.
 *   - Keep in mind this does NOT allow you to select dead party members.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 * - Target selection emphasis will go to enemies first.
 * - Ignored when used by enemies and will be treated as an enemy scope.
 * - Auto-battle actors will also treat this action as an enemy scope.
 * - For certain battle layouts in frontview, this will open the Actor Select
 *   window in order for Touch Input to be able to select actors.
 * 
 * ---
 * 
 * <Single or Multiple Select>
 * 
 * - Used for: Skill, Item Notetags
 * - Requires an original scope that can select individual targets.
 * - This will allow the skill/item to be able to select either single targets
 *   or multiple targets at once.
 *   - In order to select "all enemies", the player must press the "Page Up"
 *     keyboard button or the visual on screen "All Enemies" button.
 *   - In order to select "all allies", the player must press the "Page Down"
 *     keyboard button or the visual on screen "All Allies" button.
 *   - Those wondering why this isn't regulated to a command left or right of
 *     the enemies and actors is because mouse controls and touch controls
 *     would not be able to select all enemies or all allies that way.
 *   - This can NOT be used with single dead ally scopes.
 * - If there is an enemy with Taunt or Provoke, the option to select
 *   "All Enemies" does not become possible.
 * - The enemy AI and Auto-Battle actor AI will NOT make use of the ability to
 *   toggle between single and multiple target scopes. They will only use the
 *   single target versions of these skills.
 * 
 * ---
 * 
 * <Disperse Damage>
 * 
 * - Used for: Skill, Item Notetags
 * - This will cause any damage dealt by this skill to be split equally amongst
 *   all targets of the skill including repeats.
 *   - For basic attacks, any damage reduction added attack trait totals will
 *     by reverted.
 * - This does NOT have to be used with <Single or Multiple Select> notetag and
 *   can be used by itself for an "All" scope, making the skill/item deal less
 *   damage if there's more enemies and more damage if there's less enemies.
 * 
 * ---
 * 
 * <Cannot Target User>
 * 
 * - Used for: Skill, Item Notetags
 * - This will cause the action to be unable to select the user as the target.
 * - This is not a targeting scope. Instead, it is used in addition to any
 *   other targeting scopes out there.
 * - When used with "All" scopes, the user is removed from the target pool.
 * - This is also applied outside of battle.
 * - If the user somehow enters the target pool, the user is then replaced by
 *   a random ally found in the party.
 * 
 * ---
 *
 * === JavaScript Notetag: Targeting-Related ===
 *
 * ---
 * 
 * <JS Accuracy>
 *  code
 *  code
 *  rate = code;
 * </JS Accuracy>
 * 
 * - Used for: Skill, Item Notetags
 * - Only applies during battle.
 * - The 'rate' variable is the final returned amount to determine the
 *   accuracy hit success rate.
 *   - Base value comes from Game_Action.itemHit
 *   - Skill/Item <JS Accuracy> runs
 *   - Then <JS Accuracy as User/Target> notetags run
 * - Replace 'code' with JavaScript code to determine the final 'rate' to be
 *   returned as the accuracy hit success rate.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 * - Works best with VisuMZ Core Engine's "Improved Accuracy" QoL formula in
 *   order to consolidate both HIT and EVA.
 * 
 * ---
 * 
 * <JS Accuracy as User>
 *  code
 *  code
 *  rate = code;
 * </JS Accuracy as User>
 * 
 * <JS Accuracy as Target>
 *  code
 *  code
 *  rate = code;
 * </JS Accuracy as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Only applies during battle.
 * - The 'rate' variable is the final returned amount to determine the
 *   accuracy hit success rate.
 *   - Base value comes from Game_Action.itemHit
 *   - Skill/Item <JS Accuracy> runs
 *   - Then <JS Accuracy as User/Target> notetags run
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 * 
 * ---
 * 
 * <JS Targets>
 *  code
 *  code
 *  targets = [code];
 * </JS Targets>
 *
 * - Used for: Skill, Item Notetags
 * - The 'targets' variable is an array that is returned to be used as a
 *   container for all the valid action targets.
 *   - This is NOT used for filtering out who the player can or cannot select.
 *   - This determines a final result.
 * - The 'targets' variable will include the original set of targets determined
 *   by the skill/item's original scale.
 * - If you wish to clear it out, simply do 'targets = []' first.
 * - Replace 'code' with JavaScript code to determine valid targets.
 *
 * ---
 *
 * === Damage-Related Notetags ===
 *
 * ---
 *
 * <Damage Style: name>
 *
 * - Used for: Skill, Item Notetags
 * - Replace 'name' with a Damage Style name to change the way calculations are
 *   made using the damage formula input box.
 * - Names can be found in Plugin Parameters => Damage Settings => Style List
 *
 * ---
 *
 * <Armor Reduction: x>
 * <Armor Reduction: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   reduction properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor reduction properties
 *   when calculating one's own armor.
 * - This applies to physical attacks.
 * - Use the 'x' notetag variant to determine a flat reduction value.
 * - Use the 'x%' notetag variant to determine a percentile reduction value.
 *
 * ---
 *
 * <Armor Penetration: x>
 * <Armor Penetration: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   penetration properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor penetration
 *   properties when calculating a target's armor.
 * - This applies to physical attacks.
 * - Use the 'x' notetag variant to determine a flat penetration value.
 * - Use the 'x%' notetag variant to determine a percentile penetration value.
 *
 * ---
 *
 * <Magic Reduction: x>
 * <Magic Reduction: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   reduction properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor reduction properties
 *   when calculating one's own armor.
 * - This applies to magical attacks.
 * - Use the 'x' notetag variant to determine a flat reduction value.
 * - Use the 'x%' notetag variant to determine a percentile reduction value.
 *
 * ---
 *
 * <Magic Penetration: x>
 * <Magic Penetration: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   penetration properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor penetration
 *   properties when calculating a target's armor.
 * - This applies to magical attacks.
 * - Use the 'x' notetag variant to determine a flat penetration value.
 * - Use the 'x%' notetag variant to determine a percentile penetration value.
 *
 * ---
 *
 * <Bypass Damage Cap>
 * 
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will cause the action to never have
 *   its damage capped.
 * - If used on trait objects, this will cause the affected unit to never have
 *   its damage capped.
 *
 * ---
 *
 * <Damage Cap: x>
 *
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will declare the hard damage cap to
 *   be the 'x' value.
 * - If used on trait objects, this will raise the affect unit's hard damage
 *   cap to 'x' value. If another trait object has a higher value, use that
 *   value instead.
 *
 * ---
 *
 * <Bypass Soft Damage Cap>
 *
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will cause the action to never have
 *   its damage scaled downward to the soft cap.
 * - If used on trait objects, this will cause the affected unit to never have
 *   its damage scaled downward to the soft cap.
 *
 * ---
 *
 * <Soft Damage Cap: +x%>
 * <Soft Damage Cap: -x%>
 *
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will increase/decrease the action's
 *   soft cap by x% where 'x' is a percentage value representing the increment
 *   changed by the hard cap value.
 * - If used on trait objects, this will raise the affect unit's soft damage
 *   limit by x% where 'x' is a percentage value representing the increment
 *   changed by the hard cap value.
 *
 * ---
 *
 * <Unblockable>
 *
 * - Used for: Skill, Item Notetags
 * - Using "Guard" against this skill will not reduce any damage.
 *
 * ---
 * 
 * <Popup Position: Head>
 * <Popup Position: Center>
 * <Popup Position: Base>
 * 
 * - Used for: Enemy Notetags
 * - Determines the popup starting position for this enemy.
 *   - Head makes the popups start at the top of the ennemy.
 *   - Center makes the popups start at the center of the ennemy.
 *   - Base makes the popups start at the bottom of the ennemy.
 * - If this notetag is not used, refer to the default Plugin Parameter setting
 *   found in Damage Settings.
 * 
 * ---
 * 
 * <Popup Offset X: +x>
 * <Popup Offset X: -x>
 * <Popup Offset Y: +y>
 * <Popup Offset Y: -y>
 * 
 * - Used for: Enemy Notetags
 * - Alters the popup x/y position offset for this enemy.
 * - Replace 'x' with a number representing the horizontal position x offset.
 *   - Negative: left. Positive: right.
 * - Replace 'y' with a number representing the vertical position y offset.
 *   - Negative: up. Positive: down.
 * - If these notetags are not used, refer to the default Plugin Parameter
 *   settings found in Damage Settings.
 * 
 * ---
 *
 * === Critical-Related Notetags ===
 *
 * The following notetags affect skill and item critical hit rates and the
 * critical damage multiplier.
 *
 * ---
 *
 * <Always Critical>
 *
 * - Used for: Skill, Item Notetags
 * - This skill/item will always land a critical hit regardless of the
 *   user's CRI parameter value.
 *
 * ---
 *
 * <Set Critical Rate: x%>
 *
 * - Used for: Skill, Item Notetags
 * - This skill/item will always have a x% change to land a critical hit
 *   regardless of user's CRI parameter value.
 * - Replace 'x' with a percerntage value representing the success rate.
 *
 * ---
 *
 * <Modify Critical Rate: x%>
 * <Modify Critical Rate: +x%>
 * <Modify Critical Rate: -x%>
 *
 * - Used for: Skill, Item Notetags
 * - Modifies the user's CRI parameter calculation for this skill/item.
 * - The 'x%' notetag variant will multiply the user's CRI parameter value
 *   for this skill/item.
 * - The '+x%' and '-x%' notetag variants will incremenetally increase/decrease
 *   the user's CRI parameter value for this skill/item.
 *
 * ---
 *
 * <Modify Critical Multiplier: x%>
 * <Modify Critical Multiplier: +x%>
 * <Modify Critical Multiplier: -x%>
 *
 * - Used for: Skill, Item Notetags
 * - These notetags determine the damage multiplier when a critical hit lands.
 * - The 'x%' notetag variant multiply the multiplier to that exact percentage.
 * - The '+x%' and '-x%' notetag variants will change the multiplier with an
 *   incremenetal rate for this skill/item.
 *
 * ---
 *
 * <Modify Critical Bonus Damage: x%>
 * <Modify Critical Bonus Damage: +x%>
 * <Modify Critical Bonus Damage: -x%>
 *
 * - Used for: Skill, Item Notetags
 * - These notetags determine the bonus damage added when a critical hit lands.
 * - The 'x%' notetag variant multiply the damage to that exact percentage.
 * - The '+x%' and '-x%' notetag variants will change the bonus damage with an
 *   incremenetal rate for this skill/item.
 *
 * ---
 *
 * === JavaScript Notetags: Critical-Related ===
 *
 * The following are notetags made for users with JavaScript knowledge to
 * determine how critical hit-related aspects are calculated.
 *
 * ---
 *
 * <JS Critical Rate>
 *  code
 *  code
 *  rate = code;
 * </JS Critical Rate>
 *
 * - Used for: Skill, Item Notetags
 * - The 'rate' variable is the final returned amount to determine the
 *   critical hit success rate.
 *   - Base value comes from Game_Action.itemCri
 *   - Skill/Item <JS Critical Rate> runs
 *   - Then <JS Critical Rate as User/Target> notetags run
 * - Replace 'code' with JavaScript code to determine the final 'rate' to be
 *   returned as the critical hit success rate.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Critical Rate as User>
 *  code
 *  code
 *  rate = code;
 * </JS Critical Rate as User>
 *
 * <JS Critical Rate as Target>
 *  code
 *  code
 *  rate = code;
 * </JS Critical Rate as Target>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Only applies during battle.
 * - The 'rate' variable is the final returned amount to determine the
 *   critical hit success rate.
 *   - Base value comes from Game_Action.itemCri
 *   - Skill/Item <JS Critical Rate> runs
 *   - Then <JS Critical Rate as User/Target> notetags run
 * - Replace 'code' with JavaScript code to determine the final 'rate' to be
 *   returned as the critical hit success rate.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Critical Damage>
 *  code
 *  code
 *  multiplier = code;
 *  bonusDamage = code;
 * </JS Critical Damage>
 *
 * - Used for: Skill, Item Notetags
 * - The 'multiplier' variable is returned later and used as the damage
 *   multiplier used to amplify the critical damage amount.
 * - The 'bonusDamage' variable is returned later and used as extra added
 *   damage for the critical damage amount.
 * - Replace 'code' with JavaScript code to determine how the 'multiplier' and
 *   'bonusDamage' variables are calculated.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 * 
 * === Life Steal-Related Notetags ===
 * 
 * ---
 * 
 * <HP Life Steal: x%>
 * <MP Life Steal: x%>
 * 
 * - Used for: Skill, Item Notetags
 * - Causes this skill/item to have Life Steal properties, allowing the user to
 *   take x% of the HP/MP Damage as recovered HP/MP.
 *   - HP Life Steal can only take HP from dealt HP damage.
 *   - MP Life Steal can only take MP from dealt MP damage.
 * - Replace 'x' with a number representing the percentage of the dealt damage
 *   used as HP/MP recovery.
 * - This cannot be used with skills/items with HP Drain/MP Drain. Life Steal
 *   is a different mechanic from HP Drain/MP Drain.
 * 
 * ---
 * 
 * <HP Life Steal Certain Hit: +x%>
 * <HP Life Steal Physical Hit: +x%>
 * <HP Life Steal Magical Hit: +x%>
 * 
 * <HP Life Steal Certain Hit: -x%>
 * <HP Life Steal Physical Hit: -x%>
 * <HP Life Steal Magical Hit: -x%>
 * 
 * <MP Life Steal Certain Hit: +x%>
 * <MP Life Steal Physical Hit: +x%>
 * <MP Life Steal Magical Hit: +x%>
 * 
 * <MP Life Steal Certain Hit: -x%>
 * <MP Life Steal Physical Hit: -x%>
 * <MP Life Steal Magical Hit: -x%>
 * 
 * - Used for: Used for: Actor, Class, Armor, Enemy, State Notetags
 * - The related battler's various trait properties can have passive life steal
 *   properties that will trigger upon using skills/items with matching hit
 *   types regardless of whether or not the skill/item innately has Life Steal.
 *   - Notetag variants with "Certain Hit" will only trigger from "Certain Hit"
 *     skill and item types. Same with "Physical" and "Magical" variants.
 *   - HP Life Steal can only take HP from dealt HP damage.
 *   - MP Life Steal can only take HP from dealt MP damage.
 * - Replace 'x' with a number representing the additive stacking percentage
 *   boost of the dealt damage used as HP/MP recovery. The effects will stack
 *   additively with other trait objects.
 * - This cannot be used with skills/items with HP Drain/MP Drain. Life Steal
 *   is a different mechanic from HP Drain/MP Drain.
 * 
 * ---
 * 
 * <Cancel Life Steal>
 * 
 * <Cancel HP Life Steal>
 * <Cancel MP Life Steal>
 * 
 * - Used for: Skill, Item Notetags
 * - Prevents this skill from allowing Life Steal effects to occur including
 *   the passive life steal calculators from the skill/item user.
 * - This does not affect HP Drain/MP Drain. Life Steal is a different mechanic
 *   from HP Drain/MP Drain.
 * 
 * ---
 * 
 * <Guard Life Steal>
 * 
 * <Guard HP Life Steal>
 * <Guard MP Life Steal>
 * 
 * - Used for: Used for: Actor, Class, Armor, Enemy, State Notetags
 * - If the related battler becomes the target of Life Steal, this will prevent
 *   the Life Steal effects from taking effect.
 * - This does not affect HP Drain/MP Drain. Life Steal is a different mechanic
 *   from HP Drain/MP Drain.
 * 
 * ---
 * 
 * <Disarm Life Steal>
 * 
 * <Disarm HP Life Steal>
 * <Disarm MP Life Steal>
 * 
 * - Used for: Used for: Actor, Class, Armor, Enemy, State Notetags
 * - Makes the related battler unable to HP/MP Life Steal regardless of the
 *   skill/item and its related properties like equipment.
 * - This does not prevent skills/items with innate Life Steal from being used.
 *   Only the Life Steal part of the skill/item will have no effect.
 * - This does not affect HP Drain/MP Drain. Life Steal is a different mechanic
 *   from HP Drain/MP Drain.
 * 
 * ---
 * 
 * <Negative Life Steal>
 * 
 * <Negative HP Life Steal>
 * <Negative MP Life Steal>
 * 
 * - Used for: Used for: Actor, Class, Armor, Enemy, State Notetags
 * - If the related battler becomes the target of Life Steal, this will invert
 *   the healing properties of Life Steal, causing the Life Steal user to
 *   instead take HP/MP damage.
 *   - This does NOT heal the target related battler.
 * - This does not prevent skills/items with innate Life Steal from being used.
 *   Only the Life Steal part of the skill/item will have no effect.
 * - This does not affect HP Drain/MP Drain. Life Steal is a different mechanic
 *   from HP Drain/MP Drain.
 * 
 * ---
 *
 * === Action Sequence-Related Notetags ===
 *
 * Action Sequences allow you full control over how a skill and/or item plays
 * through its course. These notetags give you control over various aspects of
 * those Action Sequences. More information is found in the Action Sequences
 * help section.
 *
 * ---
 *
 * <Custom Action Sequence>
 *
 * - Used for: Skill, Item Notetags
 * - Removes all automated Action Sequence parts from the skill.
 * - Everything Action Sequence-related will be done by Common Events.
 * - Insert Common Event(s) into the skill/item's effects list to make use of
 *   the Custom Action Sequences.
 * - This will prevent common events from loading in the Item Scene and Skill
 *   Scene when used outside of battle.
 *
 * ---
 * 
 * <Auto Action Sequence>
 * 
 * - Used for: Skill, Item Notetags
 * - If the Action Sequence Plugin Parameter "Auto Notetag" is enabled, this
 *   plugin will prevent custom action sequences from happening for the skill
 *   or item, and instead, use an Automatic Action Sequence instead.
 * - Ignore this if you have "Auto Notetag" disabled or set to false. By
 *   default, this setting is set to false. Please be aware of the changes
 *   you've made to your game before using it.
 * 
 * ---
 * 
 * <Bypass Auto Action Sequence>
 * 
 * - Used for: Skill, Item Notetags
 * - This notetag is used for the game devs that have the Action Sequence
 *   Plugin Parameter "Auto Notetag" on for applying <Custom Action Sequence>
 *   to everything.
 * - This will allow items and skills to be able to launch their common
 *   events from the menu scene regardless of the inherent restriction to
 *   prevent action sequence based skills/items with common events from
 *   launching.
 * - Ignore this if you have "Auto Notetag" disabled or set to false. By
 *   default, this setting is set to false. Please be aware of the changes
 *   you've made to your game before using it.
 * 
 * ---
 * 
 * <Common Event: name>
 *
 * - Used for: Skill, Item Notetags
 * - Battle only: calls forth a Common Event of a matching name.
 * - Replace 'name' with the name of a Common Event to call from when this
 *   skill/item is used in battle.
 *   - Remove any \I[x] in the name.
 * - Insert multiple notetags to call multiple Common Events in succession.
 * - This will occur after any Common Event Trait Effects for the skill/item's
 *   database entry.
 * - This is primarily used for users who are reorganizing around their Common
 *   Events and would still like to have their skills/items perform the correct
 *   Action Sequences in case the ID's are different.
 * 
 * ---
 *
 * <Display Icon: x>
 * <Display Text: string>
 *
 * - Used for: Skill, Item Notetags
 * - When displaying the skill/item name in the Action Sequence, determine the
 *   icon and/or text displayed.
 * - Replace 'x' with a number value representing the icon ID to be displayed.
 * - Replace 'string' with a text value representing the displayed name.
 *
 * ---
 * 
 * <Common Event Key: name>
 * <Common Event Keys: name, name, name>
 * 
 * <Common Event Keys>
 *  key
 *  key
 *  key
 * </Common Event Keys>
 * 
 * - Used for: Skill, Item Notetags
 * - Will generate Common Events for the skill/item with a corresponding key.
 * - Replace 'name' with the name of the Common Event's key that you want to
 *   reference. That key will be converted into a Common Event effect for the
 *   skill/item and be treated as an action sequence.
 *   - The notetag variants that use multiple keys will have the keys added in
 *     the order they are listed.
 *   - If keys do not reference any Common Events, no Common Events will be
 *     added for that key.
 * - To mark a Common Event with a key, insert inside a Common Event's name the
 *   [ and ] brackets around the text that will be used as the Common Event's
 *   key text.
 *   - For example, if Common Event's name is "Penta Slash [PENTA]", then the
 *     key used is "PENTA" without the quotes.
 *   - This key could then be referenced by <Common Event Key: PENTA> notetag.
 *   - Do not use commas (,) inside the key text as it will be automatically
 *     removed for the sake of consistency.
 * - This feature is made for make the process of sharing Action Sequences to
 *   become easier without needing to line up Common Event ID's.
 * 
 * ---
 *
 * === Animated Sideview Battler-Related Notetags ===
 *
 * Enemies can use Animated Sideview Actor graphics thanks to this plugin.
 * These notetags give you control over that aspect. Some of these also affect
 * actors in addition to enemies.
 *
 * ---
 *
 * <Sideview Battler: filename>
 *
 * <Sideview Battlers>
 *  filename: weight
 *  filename: weight
 *  filename: weight
 * </Sideview Battlers>
 *
 * - Used for: Enemy Notetags
 * - Replaces the enemy's battler graphic with an animated Sideview Actor
 *   graphic found in the img/sv_actors/ folder.
 * - Replace 'filename' with the filename of the graphic to use. Do not insert
 *   any extensions. This means the file 'Actor1_1.png' will be only inserted
 *   as 'Actor1_1' without the '.png' at the end.
 * - If the multiple notetag vaiant is used, then a random filename is selected
 *   from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'filename'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'filename' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Sideview Battlers>
 *  Actor1_1: 25
 *  Actor1_3: 10
 *  Actor1_5
 *  Actor1_7
 * </Sideview Battlers>
 *
 * ---
 *
 * <Sideview Anchor: x, y>
 *
 * - Used for: Actor, Enemy Notetags
 * - Sets the sprite anchor positions for the sideview sprite.
 * - Replace 'x' and 'y' with numbers depicting where the anchors should be for
 *   the sideview sprite.
 * - By default, the x and y anchors are 0.5 and 1.0.
 *
 * ---
 * 
 * <Sideview Home Offset: +x, +y>
 * <Sideview Home Offset: -x, -y>
 * 
 * - Used for: Actor, Class, Weapon, Armor, State Notetags
 * - Offsets the sideview actor sprite's home position by +/-x, +/-y.
 * - Replace 'x' and 'y' with numbers depicting how much to offset each of the
 *   coordinates by. For '0' values, use +0 or -0.
 * - This notetag will not work if you remove it from the JavaScript code in
 *   Plugin Parameters > Actor > JS:  Home Position
 * 
 * ---
 * 
 * <Sideview Weapon Offset: +x, +y>
 * <Sideview Weapon Offset: -x, -y>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy State Notetags
 * - Offsets the sideview weapon sprite's position by +/-x, +/-y.
 * - Replace 'x' and 'y' with numbers depicting how much to offset each of the
 *   coordinates by. For '0' values, use +0 or -0.
 * 
 * ---
 *
 * <Sideview Show Shadow>
 * <Sideview Hide Shadow>
 *
 * - Used for: Actor, Enemy Notetags
 * - Sets it so the sideview battler's shadow will be visible or hidden.
 *
 * ---
 * 
 * <Sideview Shadow Scale: x%>
 * <Sideview Shadow Scale: x.y>
 * 
 * - Used for: Actor, Enemy Notetags
 * - Adjusts the scaling size of the sideview battler's shadow.
 * - This affects both the X and Y scale.
 * 
 * ---
 * 
 * <Sideview Shadow Scale X: x%>
 * <Sideview Shadow Scale X: x.y>
 * 
 * <Sideview Shadow Scale Y: x%>
 * <Sideview Shadow Scale Y: x.y>
 * 
 * - Used for: Actor, Enemy Notetags
 * - Adjusts the scaling size of the sideview battler's shadow.
 * - These affect their respective X and Y scales separately.
 * 
 * ---
 *
 * <Sideview Collapse>
 * <Sideview No Collapse>
 *
 * - Used for: Enemy Notetags
 * - Either shows the collapse graphic or does not show the collapse graphic.
 * - Collapse graphic means the enemy will 'fade away' once it's defeated.
 * - No collapse graphic means the enemy's corpse will remain on the screen.
 *
 * ---
 *
 * <Sideview Idle Motion: name>
 *
 * <Sideview Idle Motions>
 *  name: weight
 *  name: weight
 *  name: weight
 * </Sideview Idle Motions>
 *
 * - Used for: Enemy Notetags
 * - Changes the default idle motion for the enemy.
 * - Replace 'name' with any of the following motion names:
 *   - 'walk', 'wait', 'chant', 'guard', 'damage', 'evade', 'thrust', 'swing',
 *     'missile', 'skill', 'spell', 'item', 'escape', 'victory', 'dying',
 *     'abnormal', 'sleep', 'dead'
 * - If the multiple notetag vaiant is used, then a random motion name is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'name'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'name' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Sideview Idle Motions>
 *  walk: 25
 *  wait: 50
 *  guard
 *  victory
 *  abnormal
 * </Sideview Idle Motions>
 *
 * ---
 *
 * <Sideview Size: width, height>
 *
 * - Used for: Enemy Notetags
 * - When using a sideview battler, its width and height will default to the
 *   setting made in Plugin Parameters => Enemy Settings => Size: Width/Height.
 * - This notetag lets you change that value to something else.
 * - Replace 'width' and 'height' with numbers representing how many pixels
 *   wide/tall the sprite will be treated as.
 * - This does NOT change the image size. This only changes the HITBOX size.
 *
 * ---
 *
 * <Sideview Weapon: weapontype>
 *
 * <Sideview Weapons>
 *  weapontype: weight
 *  weapontype: weight
 *  weapontype: weight
 * </Sideview Weapons>
 *
 * - Used for: Enemy Notetags
 * - Give your sideview enemies weapons to use.
 * - Replace 'weapontype' with the name of the weapon type found under the
 *   Database => Types => Weapon Types list (without text codes).
 * - If the multiple notetag vaiant is used, then a random weapon type is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the weapontype
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'weapontype' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Sideview Weapons>
 *  Dagger: 25
 *  Sword: 25
 *  Axe
 * </Sideview Weapons>
 *
 * ---
 *
 * <traitname Sideview Battler: filename>
 *
 * <traitname Sideview Battlers>
 *  filename: weight
 *  filename: weight
 *  filename: weight
 * </traitname Sideview Battlers>
 *
 * - Used for: Enemy Notetags
 * - Requires VisuMZ_1_ElementStatusCore
 * - Allows certain Trait Sets to cause battlers to have a unique appearance.
 * - Replace 'filename' with the filename of the graphic to use. Do not insert
 *   any extensions. This means the file 'Actor1_1.png' will be only inserted
 *   as 'Actor1_1' without the '.png' at the end.
 * - If the multiple notetag vaiant is used, then a random filename is selected
 *   from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'filename'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'filename' instead.
 * - Add/remove lines as you see fit.
 *
 * Examples:
 *
 * <Male Sideview Battlers>
 *  Actor1_1: 25
 *  Actor1_3: 10
 *  Actor1_5
 *  Actor1_7
 * </Male Sideview Battlers>
 *
 * <Female Sideview Battlers>
 *  Actor1_2: 25
 *  Actor1_4: 10
 *  Actor1_6
 *  Actor1_8
 * </Female Sideview Battlers>
 *
 * ---
 *
 * <traitname Sideview Idle Motion: name>
 *
 * <traitname Sideview Idle Motions>
 *  name: weight
 *  name: weight
 *  name: weight
 * </traitname Sideview Idle Motions>
 *
 * - Used for: Enemy Notetags
 * - Requires VisuMZ_1_ElementStatusCore
 * - Allows certain Trait Sets to cause battlers to have unique idle motions.
 * - Replace 'name' with any of the following motion names:
 *   - 'walk', 'wait', 'chant', 'guard', 'damage', 'evade', 'thrust', 'swing',
 *     'missile', 'skill', 'spell', 'item', 'escape', 'victory', 'dying',
 *     'abnormal', 'sleep', 'dead'
 * - If the multiple notetag vaiant is used, then a random motion name is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'name'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'name' instead.
 * - Add/remove lines as you see fit.
 *
 * Examples:
 *
 * <Jolly Sideview Idle Motions>
 *  wait: 25
 *  victory: 10
 *  walk
 * </Jolly Sideview Idle Motions>
 *
 * <Serious Sideview Idle Motions>
 *  walk: 25
 *  guard: 10
 *  wait
 * </Jolly Sideview Idle Motions>
 *
 * ---
 *
 * <traitname Sideview Weapon: weapontype>
 *
 * <traitname Sideview Weapons>
 *  weapontype: weight
 *  weapontype: weight
 *  weapontype: weight
 * </traitname Sideview Weapons>
 *
 * - Used for: Enemy Notetags
 * - Requires VisuMZ_1_ElementStatusCore
 * - Allows certain Trait Sets to cause battlers to have unique weapons.
 * - Replace 'weapontype' with the name of the weapon type found under the
 *   Database => Types => Weapon Types list (without text codes).
 * - If the multiple notetag vaiant is used, then a random weapon type is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the weapontype
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'weapontype' instead.
 * - Add/remove lines as you see fit.
 *
 * Examples:
 *
 * <Male Sideview Weapons>
 *  Dagger: 25
 *  Sword: 25
 *  Axe
 * </Male Sideview Weapons>
 *
 * <Female Sideview Weapons>
 *  Dagger: 25
 *  Spear: 25
 *  Cane
 * </Female Sideview Weapons>
 *
 * ---
 *
 * === Enemy-Related Notetags ===
 *
 * ---
 *
 * <Battler Sprite Cannot Move>
 *
 * - Used for: Enemy Notetags
 * - Prevents the enemy from being able to move, jump, and/or float due to
 *   Action Sequences. Useful for rooted enemies.
 *
 * ---
 * 
 * <Battler Sprite Grounded>
 *
 * - Used for: Enemy Notetags
 * - Prevents the enemy from being able to jumping and/or floating due to
 *   Action Sequences but still able to move. Useful for rooted enemies.
 * 
 * ---
 *
 * <Swap Enemies>
 *  name: weight
 *  name: weight
 *  name: weight
 * </Swap Enemies>
 *
 * - Used for: Enemy Notetags
 * - Causes this enemy database object to function as a randomizer for any of
 *   the listed enemies inside the notetag. When the enemy is loaded into the
 *   battle scene, the enemy is immediately replaced with one of the enemies
 *   listed. The randomization is based off the 'weight' given to each of the
 *   enemy 'names'.
 * - Replace 'name' with the database enemy of the enemy you wish to replace
 *   the enemy with.
 * - Replace 'weight' with a number value representing how often the 'name'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'name' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Swap Enemies>
 *  Bat: 50
 *  Slime: 25
 *  Orc
 *  Minotaur
 * </Swap Enemies>
 *
 * ---
 * 
 * <Aspect Name: name>
 * 
 * - Used for: Enemy Notetags
 * - Changes enemy's aspect name shown in the In-Battle Status and other
 *   supported plugin menus.
 *   - Requires <Aspect Description> in order to show.
 * - Replace 'name' with text for how enemy aspect should be renamed.
 * 
 * ---
 * 
 * <Aspect Color: color>
 * 
 * - Used for: Enemy Notetags
 * - Changes enemy's aspect name color shown in the In-Battle Status and other
 *   supported plugin menus.
 *   - Requires <Aspect Description> in order to show.
 * - Replace 'color' with either a number from 0 to 31 representing the text
 *   color or in the format of '#rrggbb' to custom pick a hex color.
 * 
 * ---
 * 
 * <Aspect Icon: x>
 * 
 * - Used for: Enemy Notetags
 * - Changes enemy's aspect icon shown in the In-Battle Status and other
 *   supported plugin menus.
 *   - Requires <Aspect Description> in order to show.
 * - Replace 'x' with a number representing the icon index used to represent
 *   the enemy aspect.
 * 
 * ---
 * 
 * <Aspect Description>
 *  text
 *  text
 * </Aspect Description>
 * 
 * - Used for: Enemy Notetags
 * - Changes enemy's aspect description shown in the In-Battle Status and other
 *   supported plugin menus.
 * - Replace 'text' with the text you would like to appear as a description for
 *   the enemy's aspect.
 * 
 * ---
 *
 * === JavaScript Notetags: Mechanics-Related ===
 *
 * These JavaScript notetags allow you to run code at specific instances during
 * battle provided that the unit has that code associated with them in a trait
 * object (actor, class, weapon, armor, enemy, or state). How you use these is
 * entirely up to you and will depend on your ability to understand the code
 * used and driven for each case.
 *
 * ---
 *
 * <JS Pre-Start Battle>
 *  code
 *  code
 *  code
 * </JS Pre-Start Battle>
 *
 * <JS Post-Start Battle>
 *  code
 *  code
 *  code
 * </JS Post-Start Battle>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of battle aimed at the function:
 *   BattleManager.startBattle()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Start Turn>
 *  code
 *  code
 *  code
 * </JS Pre-Start Turn>
 *
 * <JS Post-Start Turn>
 *  code
 *  code
 *  code
 * </JS Post-Start Turn>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of a turn aimed at the function:
 *   BattleManager.startTurn()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Start Action>
 *  code
 *  code
 *  code
 * </JS Pre-Start Action>
 *
 * <JS Post-Start Action>
 *  code
 *  code
 *  code
 * </JS Post-Start Action>
 * 
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of an action aimed at the function:
 *   BattleManager.startAction()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Apply>
 *  code
 *  code
 *  code
 * </JS Pre-Apply>
 * 
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code at the start of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Pre' runs before the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Pre-Apply as User>
 *  code
 *  code
 *  code
 * </JS Pre-Apply as User>
 *
 * <JS Pre-Apply as Target>
 *  code
 *  code
 *  code
 * </JS Pre-Apply as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Pre' runs before the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Pre-Damage>
 *  code
 *  code
 *  code
 * </JS Pre-Damage>
 * 
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code before damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Pre' runs before the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 * - The 'value' variable represents the damage being calculated up to this
 *   point (if any) and any changes made to the 'value' variable will reflect
 *   on the damage dealt/healed, too.
 *
 * ---
 *
 * <JS Pre-Damage as User>
 *  code
 *  code
 *  code
 * </JS Pre-Damage as User>
 *
 * <JS Pre-Damage as Target>
 *  code
 *  code
 *  code
 * </JS Pre-Damage as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code before damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Pre' runs before the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 * - The 'value' variable represents the damage being calculated up to this
 *   point (if any) and any changes made to the 'value' variable will reflect
 *   on the damage dealt/healed, too.
 *
 * ---
 *
 * <JS Post-Damage>
 *  code
 *  code
 *  code
 * </JS Post-Damage>
 * 
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code after damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Post' runs after the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 * - The 'value' variable represents the damage/healing that has been last
 *   dealt through this action.
 *
 * ---
 *
 * <JS Post-Damage as User>
 *  code
 *  code
 *  code
 * </JS Post-Damage as User>
 *
 * <JS Post-Damage as Target>
 *  code
 *  code
 *  code
 * </JS Post-Damage as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code after damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Post' runs after the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 * - The 'value' variable represents the damage/healing that has been last
 *   dealt through this action.
 *
 * ---
 *
 * <JS Post-Apply>
 *  code
 *  code
 *  code
 * </JS Post-Apply>
 * 
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code at the end of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Post' runs after the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Post-Apply as User>
 *  code
 *  code
 *  code
 * </JS Post-Apply as User>
 *
 * <JS Post-Apply as Target>
 *  code
 *  code
 *  code
 * </JS Post-Apply as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the end of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Post' runs after the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 *
 * ---
 *
 * <JS Pre-End Action>
 *  code
 *  code
 *  code
 * </JS Pre-End Action>
 *
 * <JS Post-End Action>
 *  code
 *  code
 *  code
 * </JS Post-End Action>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the end of an action aimed at the function:
 *   BattleManager.endAction()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-End Turn>
 *  code
 *  code
 *  code
 * </JS Pre-End Turn>
 *
 * <JS Post-End Turn>
 *  code
 *  code
 *  code
 * </JS Post-End Turn>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the end of a turn aimed at the function:
 *   Game_Battler.prototype.onTurnEnd()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Regenerate>
 *  code
 *  code
 *  code
 * </JS Pre-Regenerate>
 *
 * <JS Post-Regenerate>
 *  code
 *  code
 *  code
 * </JS Post-Regenerate>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when a unit regenerates HP/MP aimed at the function:
 *   Game_Battler.prototype.regenerateAll()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Battle Victory>
 *  code
 *  code
 *  code
 * </JS Battle Victory>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when a battle is won aimed at the function:
 *   BattleManager.processVictory()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Escape Success>
 *  code
 *  code
 *  code
 * </JS Escape Success>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when escaping succeeds aimed at the function:
 *   BattleManager.onEscapeSuccess()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Escape Failure>
 *  code
 *  code
 *  code
 * </JS Escape Failure>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when escaping fails aimed at the function:
 *   BattleManager.onEscapeFailure()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Battle Defeat>
 *  code
 *  code
 *  code
 * </JS Battle Defeat>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when a battle is lost aimed at the function:
 *   BattleManager.processDefeat()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-End Battle>
 *  code
 *  code
 *  code
 * </JS Pre-End Battle>
 *
 * <JS Post-End Battle>
 *  code
 *  code
 *  code
 * </JS Post-End Battle>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when the battle is over aimed at the function:
 *   BattleManager.endBattle()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 * 
 * === Battle Layout-Related Notetags ===
 * 
 * These tags will change the battle layout for a troop regardless of how the
 * plugin parameters are set up normally. Insert these tags in either the
 * noteboxes of maps or the names of troops for them to take effect. If both
 * are present for a specific battle, then priority goes to the setting found
 * in the troop name.
 * 
 * ---
 * 
 * <Layout: type>
 * <Battle Layout: type>
 * 
 * - Used for: Map Notetags, Troop Name Tags, and Troop Comment Tags
 * - Changes the battle layout style used for this specific map or battle.
 * - Replace 'type' with 'default', 'list', 'xp', 'portrait', or 'border'.
 * - Those with VisuMZ_3_FrontviewBattleUI can use 'frontview'.
 * - Those with VisuMZ_3_SideviewBattleUI can use 'sideview'.
 * - If using Troop Comment Tags, then as long as the tag appears in a comment
 *   found on any of the Troop's pages (even if they don't run), the tag will
 *   be considered in effect.
 * 
 * ---
 * 
 * === Troop Size Tags ===
 * 
 * ---
 * 
 * <Extend: x>
 * <Extend: x, x, x>
 * 
 * - Used for: Troop Name Tags and Troop Comment Tags
 * - Adds enemies from another troop to the current troop.
 * - Enemies from another troop will retain their database positions.
 * - Replace 'x' with the ID of the database troop entry you wish to add enemy
 *   members from.
 *   - Insert multiple x's to add from more troops.
 * - Extended troop members will be added in the order they're listed.
 * - Be cautious of how many enemies you add as too many will lag the battle
 *   system. We are not responsible for frame drops due to this.
 * 
 * ---
 * 
 * === Troop Comment Tags ===
 * 
 * Place these tags inside of a comment found in a troop page's event list.
 * 
 * ---
 * 
 * <Once Parallel When Start Battle>
 * 
 * - Used for: Troop Page Comment Tags
 * - Causes the troop page to immediately load the moment the battle scene
 *   begins to fade in (not after it fades in). This is faster than a turn 0
 *   condition troop page. Troop page conditions are ignored.
 * - This can be used for things like the Action Sequence Camera plugin, the
 *   Visual Battle Environment plugin, and/or initial battle poses and such in
 *   order to provide a near seamless battle transition experience.
 * - This does NOT trigger when coming out of the options menu or party menu.
 * - This WILL trigger when going from battle to battle nonstop via plugins
 *   like VisuStella MZ's Chain Battles.
 * - When actors are moving towards their home positions, it will take around
 *   30 frames by default. Use this information however you like.
 * 
 * ---
 *
 * ============================================================================
 * Action Sequence - Plugin Commands
 * ============================================================================
 *
 * Skills and items, when used in battle, have a pre-determined series of
 * actions to display to the player as a means of representing what's going on
 * with the action. For some game devs, this may not be enough and they would
 * like to get more involved with the actions themselves.
 *
 * Action Sequences, added through this plugin, enable this. To give a skill or
 * item a Custom Action Sequence, a couple of steps must be followed:
 *
 * ---
 *
 * 1. Insert the <Custom Action Sequence> notetag into the skill or item's
 *    notebox (or else this would not work as intended).
 * 2. Give that skill/item a Common Event through the Effects box. The selected
 *    Common Event will contain all the Action Sequence data.
 * 3. Create the Common Event with Action Sequence Plugin Commands and/or event
 *    commands to make the skill/item do what you want it to do.
 *
 * ---
 *
 * The Plugin Commands added through the Battle Core plugin focus entirely on
 * Action Sequences. However, despite the fact that they're made for skills and
 * items, some of these Action Sequence Plugin Commands can still be used for
 * regular Troop events and Common Events.
 *
 * ---
 *
 * === Action Sequence - Action Sets ===
 *
 * Action Sequence Action Sets are groups of commonly used
 * Action Sequence Commands put together for more efficient usage.
 *
 * ---
 *
 * ACSET: Setup Action Set
 * - The generic start to most actions.
 *
 *   Display Action:
 *   Immortal: On:
 *   Battle Step:
 *   Wait For Movement:
 *   Cast Animation:
 *   Wait For Animation:
 *   - Use this part of the action sequence?
 *
 * ---
 *
 * ACSET: All Targets Action Set
 * - Affects all targets simultaneously performing the following.
 *
 *   Dual/Multi Wield?
 *   - Add times struck based on weapon quantity equipped?
 * 
 *   Perform Action:
 *   Wait Count:
 *   Action Animation:
 *   Wait For Animation:
 *   Action Effect:
 *   Immortal: Off:
 *   - Use this part of the action sequence?
 *   - Insert values for the Wait Count(s).
 *
 * ---
 *
 * ACSET: Each Target Action Set
 * - Goes through each target one by one to perform the following.
 *
 *   Dual/Multi Wield?
 *   - Add times struck based on weapon quantity equipped?
 *
 *   Perform Action:
 *   Wait Count:
 *   Action Animation:
 *   Wait Count:
 *   Action Effect:
 *   Immortal: Off:
 *   - Use this part of the action sequence?
 *   - Insert values for the Wait Count(s).
 *
 * ---
 *
 * ACSET: Finish Action
 * - The generic ending to most actions.
 *
 *   Wait For New Line:
 *   Wait For Effects:
 *   Clear Battle Log:
 *   Home Reset:
 *   Wait For Movement:
 *   - Use this part of the action sequence?
 *
 * ---
 * 
 * === Action Sequences - Angle ===
 * 
 * These action sequences allow you to have control over the camera angle.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * ---
 *
 * ANGLE: Change Angle
 * - Changes the camera angle.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Angle:
 *   - Change the camera angle to this many degrees.
 *
 *   Duration:
 *   - Duration in frames to change camera angle.
 *
 *   Angle Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Angle?:
 *   - Wait for angle changes to complete before performing next command?
 *
 * ---
 *
 * ANGLE: Reset Angle
 * - Reset any angle settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Duration:
 *   - Duration in frames to reset camera angle.
 *
 *   Angle Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Angle?:
 *   - Wait for angle changes to complete before performing next command?
 *
 * ---
 *
 * ANGLE: Wait For Angle
 * - Waits for angle changes to complete before performing next command.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * === Action Sequences - Animations ===
 *
 * These Action Sequences are related to the 'Animations' that can be found in
 * the Animations tab of the Database.
 *
 * ---
 *
 * ANIM: Action Animation
 * - Plays the animation associated with the action.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Attack Animation
 * - Plays the animation associated with the user's weapon.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Attack Animation 2+
 * - Plays the animation associated with the user's other weapons.
 * - Plays nothing if there is no other weapon equipped.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 * 
 *   Slot:
 *   - Which weapon slot to get this data from?
 *   - Main-hand weapon is weapon slot 1.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 * 
 * ANIM: Balloon Animation
 * - Plays a balloon animation on target(s).
 * 
 *   Targets:
 *   - Select unit(s) to play the animation on.
 * 
 *   Balloon Type:
 *   - What kind of balloon should be played on target(s)?
 * 
 *   Wait for Completion:
 *   - Wait for balloon animation completion before continuing?
 * 
 * ---
 * 
 * ANIM: Balloon Icon (Single)
 * - Plays a balloon animation using an icon on target(s).
 * - Requires VisuMZ_4_IconBalloons!
 * 
 *   Targets:
 *   - Select unit(s) to play the animation on.
 * 
 *   Icon Index:
 *   - Insert the ID of the icon to show.
 *   - Tip: Right click > Insert Icon Index
 * 
 *   Wait for Completion:
 *   - Wait for balloon animation completion before continuing?
 * 
 * ---
 * 
 * ANIM: Balloon Icon (Range)
 * - Plays a balloon animation an icon range on target(s).
 * - Requires VisuMZ_4_IconBalloons!
 * 
 *   Targets:
 *   - Select unit(s) to play the animation on.
 * 
 *   Starting Icon Index:
 *   - Insert the ID of the icon to show.
 *   - Tip: Right click > Insert Icon Index
 * 
 *   Ending Icon Index:
 *   - Insert the ID of the icon to show.
 *   - Tip: Right click > Insert Icon Index
 * 
 *   Wait for Completion:
 *   - Wait for balloon animation completion before continuing?
 * 
 * ---
 * 
 * ANIM: Balloon Icon (Specific)
 * - Plays a balloon animation with specific icons on target(s).
 * - Requires VisuMZ_4_IconBalloons!
 * 
 *   Targets:
 *   - Select unit(s) to play the animation on.
 * 
 *   Icons:
 *   - Insert the ID(s) of the icon to show.
 *   - Tip: Right click > Insert Icon Index
 * 
 *   Wait for Completion:
 *   - Wait for balloon animation completion before continuing?
 * 
 * ---
 *
 * ANIM: Cast Animation
 * - Plays the cast animation associated with the action.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Change Battle Portrait
 * - Changes the battle portrait of the actor (if it's an actor).
 * - Can be used outside of battle/action sequences.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *   - Valid units can only be actors.
 *
 *   Filename:
 *   - Select the file to change the actor's portrait to.
 * 
 * ---
 *
 * ANIM: Change Battle Portrait (JS)
 * - Changes the battle portrait of the actor through JavaScript.
 * - Can be used outside of battle/action sequences.
 * 
 *   JS: Actor ID:
 *   - Enter which Actor ID to affect.
 *   - Uses JavaScript code.
 * 
 *   JS: Filename:
 *   - Enter the filename you wish to use.
 *   - Uses JavaScript code.
 * 
 * ---
 *
 * ANIM: Guard Animation
 * - Plays the animation associated with the user's guard action (if any).
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Item Animation
 * - Plays the animation associated with a specific item.
 * 
 *   Item ID:
 *   - Which item ID will the animation come from?
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Play at Coordinate
 * - Plays an animation on the screen at a specific x, y coordinate.
 * - Requires VisuMZ_0_CoreEngine!
 * 
 *   Animation ID:
 *   - Plays this animation.
 * 
 *   Coordinates:
 * 
 *     X:
 *     Y:
 *     - X/Y coordinate used for the animation.
 *       You may use JavaScript code.
 * 
 *   Mirror Animation?:
 *   - Mirror the animation?
 * 
 *   Mute Animation?:
 *   - Mute the animation?
 * 
 *   Wait for Completion?:
 *   - Wait the animation to finish before continuing?
 *
 * ---
 *
 * ANIM: Show Animation
 * - Plays the a specific animation on unit(s).
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Animation ID:
 *   - Select which animation to play on unit(s).
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Show Animation JS
 * - Plays the a specific animation on unit(s).
 * - Uses JavaScript to determine animation ID.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   JS: Animation ID:
 *   - Select which animation to play on unit(s).
 *   - Uses JavaScript to determine animation ID.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Skill Animation
 * - Plays the animation associated with a specific skill.
 * 
 *   Skill ID:
 *   - Which skill ID will the animation come from?
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Wait For Animation
 * - Causes the interpreter to wait for any animation(s) to finish.
 *
 * ---
 *
 * === Action Sequences - Battle Log ===
 *
 * These Action Sequences are related to the Battle Log Window, the window
 * found at the top of the battle screen.
 *
 * ---
 *
 * BTLOG: Add Text
 * - Adds a new line of text into the Battle Log.
 *
 *   Text:
 *   - Add this text into the Battle Log.
 *   - Text codes allowed.
 * 
 *   Copy to Combat Log?:
 *   - Copies text to the Combat Log.
 *   - Requires VisuMZ_4_CombatLog
 * 
 *     Combat Log Icon:
 *     - What icon would you like to bind to this entry?
 *     - Requires VisuMZ_4_CombatLog
 *
 * ---
 *
 * BTLOG: Clear Battle Log
 * - Clears all the text in the Battle Log.
 *
 * ---
 *
 * BTLOG: Display Action
 * - plays the current action in the Battle Log.
 *
 * ---
 *
 * BTLOG: Pop Base Line
 * - Removes the Battle Log's last added base line and  all text up to its
 *   former location.
 *
 * ---
 *
 * BTLOG: Push Base Line
 * - Adds a new base line to where the Battle Log currently is at.
 *
 * ---
 *
 * BTLOG: Refresh Battle Log
 * - Refreshes the Battle Log.
 *
 * ---
 *
 * BTLOG: UI Show/Hide
 * - Shows or hides the Battle UI (including the Battle Log).
 *
 *   Show/Hide?:
 *   - Shows/hides the Battle UI.
 *
 * ---
 *
 * BTLOG: Wait For Battle Log
 * - Causes the interpreter to wait for the Battle Log to finish.
 *
 * ---
 *
 * BTLOG: Wait For New Line
 * - Causes the interpreter to wait for a new line in the Battle Log.
 *
 * ---
 *
 * === Action Sequences - Camera ===
 *
 * These Action Sequences are battle camera-related.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * CAMERA: Clamp ON/OFF
 * - Turns battle camera clamping on/off.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Setting:
 *   - Turns camera clamping on/off.
 *
 * ---
 *
 * CAMERA: Focus Point
 * - Focus the battle camera on a certain point in the screen.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   X Coordinate:
 *   - Insert the point to focus the camera on.
 *   - You may use JavaScript code.
 *
 *   Y Coordinate:
 *   - Insert the point to focus the camera on.
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for camera focus change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Focus Target(s)
 * - Focus the battle camera on certain battler target(s).
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Targets:
 *   - Select unit(s) to focus the battle camera on.
 *
 *   Duration:
 *   - Duration in frames for camera focus change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Offset
 * - Offset the battle camera from the focus target.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Offset X:
 *   - How much to offset the camera X by.
 *   - Negative: left. Positive: right.
 *
 *   Offset Y:
 *   - How much to offset the camera Y by.
 *   - Negative: up. Positive: down.
 *
 *   Duration:
 *   - Duration in frames for offset change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Reset
 * - Reset the battle camera settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Reset Focus?:
 *   - Reset the focus point?
 *
 *   Reset Offset?:
 *   - Reset the camera offset?
 *
 *   Duration:
 *   - Duration in frames for reset change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Wait For Camera
 * - Waits for camera changes to complete before performing next command.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 * 
 * === Action Sequences - Cutins ===
 * 
 * Allows you to have control over Visual Cutin Effects.
 * Requires VisuMZ_3_VisualCutinEffect!
 * 
 * ---
 * 
 * CUTIN: Add Visual Cutin Effect
 * - Adds the Visual Cutin Effect using these desired settings.
 * - Only one of each cutin-style type can be present at a time.
 * - Requires VisuMZ_3_VisualCutinEffect!
 * 
 *   Basic Settings:
 * 
 *     Cutin Style Type:
 *     - What Visual Cutin Effect style type do you wish to use?
 *     - Only one of each cutin-style type can be present.
 *     - Refer to VisuMZ wiki for visuals on styles.
 * 
 *     Portrait Target:
 *     - Select unit(s) to grab the Visual Cutin Effect portrait data from.
 *     - First unit will be used to make portrait.
 * 
 *     Parallax Filename:
 *     - Pick a parallax to use for the Visual Cutin Effect.
 *     - Pick (None) to not use a parallax.
 * 
 *     Background Color:
 *     - Use #rrggbb for custom colors or regular numbers for text colors from
 *       the Window Skin.
 *
 *   Extra Settings:
 *   - Extra Plugin Command settings pertaining to this Visual Cutin Effect.
 *   - An explanation for these settings are found in the Visual Cutin Effect
 *     help file and documentation.
 *   - Extra parameters are added for Parallax Scroll Inversion when the target
 *     is an enemy.
 * 
 *   Wait for Entrance:
 *   - Wait until cutin entrance is finished before performing the next
 *     event command?
 * 
 * ---
 *
 * CUTIN: End Visual Cutin Effect (All)
 * - Ends all Visual Cutin Effects currently present.
 * - Requires VisuMZ_3_VisualCutinEffect!
 * 
 *   Wait for Exit:
 *   - Wait until cutin exit is finished before performing the next
 *     event command?
 *
 * ---
 *
 * CUTIN: End Visual Cutin Effect (Type)
 * - Ends the Visual Cutin Effect with the matching type.
 * - Requires VisuMZ_3_VisualCutinEffect!
 *
 *   Cutin Style Type:
 *   - What Visual Cutin Effect style type do you wish to end?
 * 
 *   Wait for Exit:
 *   - Wait until cutin exit is finished before performing the next
 *     event command?
 *
 * ---
 * 
 * CUTIN: Wait for Cutin Entrance
 * - Wait until all cutin entrances are finished before performing the next
 *   event command.
 * - Requires VisuMZ_3_VisualCutinEffect!
 * 
 * ---
 * 
 * CUTIN: Wait for Cutin Exit
 * - Wait until all cutin exits are finished before performing the next
 *   event command.
 * - Requires VisuMZ_3_VisualCutinEffect!
 * 
 * ---
 *
 * === Action Sequences - Dragonbones ===
 *
 * These Action Sequences are Dragonbones-related.
 * Requires VisuMZ_2_DragonbonesUnion!
 *
 * ---
 *
 * DB: Dragonbones Animation
 * - Causes the unit(s) to play a Dragonbones motion animation.
 * - Requires VisuMZ_2_DragonbonesUnion!
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion animation.
 *
 *   Motion Animation:
 *   - What is the name of the Dragonbones motion animation you wish to play?
 *
 * ---
 *
 * DB: Dragonbones Time Scale
 * - Causes the unit(s) to change their Dragonbones time scale.
 * - Requires VisuMZ_2_DragonbonesUnion!
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion animation.
 *
 *   Time Scale:
 *   - Change the value of the Dragonbones time scale to this.
 *
 * ---
 *
 * === Action Sequences - Elements ===
 *
 * These Action Sequences can change up the element(s) used for the action's
 * damage calculation midway through an action.
 *
 * They also require the VisuMZ_1_ElementStatusCore plugin to be present in
 * order for them to work.
 *
 * ---
 *
 * ELE: Add Elements
 * - Adds element(s) to be used when calculating damage.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 *   Elements:
 *   - Select which element ID to add onto the action.
 *   - Insert multiple element ID's to add multiple at once.
 *
 * ---
 *
 * ELE: Clear Element Changes
 * - Clears all element changes made through Action Sequences.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 * ---
 *
 * ELE: Force Elements
 * - Forces only specific element(s) when calculating damage.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 *   Elements:
 *   - Select which element ID to force in the action.
 *   - Insert multiple element ID's to force multiple at once.
 *
 * ---
 *
 * ELE: Null Element
 * - Forces no element to be used when calculating damage.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 * ---
 * 
 * === Action Sequences - Grid ===
 * 
 * These Action Sequences are Battle Grid System-related.
 * Requires VisuMZ_2_BattleGridSystem!
 * 
 * ---
 * 
 * GRID: Action Animation at Node
 * - Plays action animation at target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 * 
 *     Unit:
 *     - Which unit's Node do you want to play an animation on?
 * 
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to play an
 *       animation on.
 * 
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to play
 *       an animation on.
 * 
 *   Offset X:
 *   - Offsets the animation x position.
 *   - Negative: left. Positive: right.
 * 
 *   Offset Y:
 *   - Offsets the animation y position.
 *   - Negative: up. Positive: down.
 * 
 * ---
 *
 * GRID: Add Passive State(s) to Node
 * - Adds Passive State(s) at target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 *
 *   State ID(s):
 *   - Select which State ID(s) to add as a Passive State.
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 *
 *     Unit:
 *     - Which unit do you want to add the Passive State Node effect for?
 *
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to add a
 *       Passive State(s) to.
 *
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to add a
 *       Passive State(s) to.
 *
 * ---
 * 
 * GRID: Add Trigger to Node
 * - Adds Trigger to target node.
 * - Target node cannot have battler.
 * - Each node can only contain ONE trigger! 
 * - Otherwise, newly placed triggers will overwrite the old ones.
 * - Requires VisuMZ_2_BattleGridSystem!
 * 
 *   Skill ID:
 *   - Select which Skill ID(s) to add as the trigger.
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 * 
 *     Unit:
 *     - Which unit do you want to add the Trigger Node effect for?
 * 
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to add a
 *       Trigger to.
 * 
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to add a
 *       Trigger to.
 * 
 * ---
 * 
 * GRID: Add Trigger to Node JS
 * - Adds JS Trigger to target node.
 * - Target node cannot have battler.
 * - Each node can only contain ONE trigger! 
 * - Otherwise, newly placed triggers will overwrite the old ones.
 * - Requires VisuMZ_2_BattleGridSystem!
 * 
 *   JS: Skill ID:
 *   - Use JavaScript to determine what skill ID to add to this node.
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 * 
 *     Unit:
 *     - Which unit do you want to add the Trigger Node effect for?
 * 
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to add a
 *       Trigger to.
 * 
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to add a
 *       Trigger to.
 * 
 * ---
 * 
 * GRID: Animation ID at Node
 * - Plays specific animation ID at target node.
 * 
 *   Animation ID:
 *   - Play this animation at target node.
 * 
 *     Mirror?:
 *     - Mirror this animation?
 * 
 *     Mute?:
 *     - Mute this animation?
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 * 
 *     Unit:
 *     - Which unit's Node do you want to play an animation on?
 * 
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to play an
 *       animation on.
 * 
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to play
 *       an animation on.
 * 
 *   Offset X:
 *   - Offsets the animation x position.
 *   - Negative: left. Positive: right.
 * 
 *   Offset Y:
 *   - Offsets the animation y position.
 *   - Negative: up. Positive: down.
 * 
 * ---
 * 
 * GRID: Animation JS at Node
 * - Uses JS to calculate which animation to play at target node.
 * 
 *   JS: Animation ID:
 *   - Calculate which animation to play on unit(s).
 *   - Uses JavaScript to determine animation ID.
 * 
 *     Mirror?:
 *     - Mirror this animation?
 * 
 *     Mute?:
 *     - Mute this animation?
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 * 
 *     Unit:
 *     - Which unit's Node do you want to play an animation on?
 * 
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to play an
 *       animation on.
 * 
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to play
 *       an animation on.
 * 
 *   Offset X:
 *   - Offsets the animation x position.
 *   - Negative: left. Positive: right.
 * 
 *   Offset Y:
 *   - Offsets the animation y position.
 *   - Negative: up. Positive: down.
 * 
 * ---
 * 
 * GRID: Animation Type at Node
 * - Plays certain animation type at target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 * 
 *   Type:
 *   - What is the animation type you would like to play?
 *     - Attack
 *     - Guard
 *     - Item
 *     - Skill
 * 
 *     Slot (Attack Type):
 *     - Which weapon slot to get this data from?
 *     - Main-hand weapon is weapon slot 1.
 * 
 *     Item ID (Item Type):
 *     - Which item ID will the animation come from?
 * 
 *     Skill ID (Skill Type):
 *     - Which skill ID will the animation come from?
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 * 
 *     Unit:
 *     - Which unit's Node do you want to play an animation on?
 * 
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to play an
 *       animation on.
 * 
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to play
 *       an animation on.
 * 
 *   Offset X:
 *   - Offsets the animation x position.
 *   - Negative: left. Positive: right.
 * 
 *   Offset Y:
 *   - Offsets the animation y position.
 *   - Negative: up. Positive: down.
 * 
 * ---
 * 
 * GRID: Move Target(s) In Direction
 * - Moves target(s) in a specific direction to other Nodes.
 * - Requires VisuMZ_2_BattleGridSystem!
 * - This will bypass the "once per action" condition used for both the
 *   <rule Move User Node direction: x> & <rule Move Target Node direction: x>
 *   notetags as this is not a notetag effect.
 * 
 *   Targets:
 *   - Select unit(s) to move.
 * 
 *   Movement Type:
 *   - Select the Movement type rulings.
 *   - See VisuMZ_2_BattleGridSystem help file for details.
 * 
 *     Direction:
 *     - Select the movement direction.
 * 
 *     Distance:
 *     - The number of nodes to be moved.
 *     - You may use JavaScript code.
 * 
 *   Duration:
 *   - Input the number representing the frames used to move.
 * 
 *   Silent Change?:
 *   - Silent: Discreet changes shown. More apparent later.
 *   - Visual: Instant changes shown.
 * 
 * ---
 * 
 * GRID: Pull To Target Node
 * - Pulls battlers towards target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *
 *     Unit:
 *     - Which unit do you want to pull on?
 *
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to
 *       pull to.
 *
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to
 *       pull to.
 * 
 *   Strength:
 *   - Input the strength level of the pull.
 * 
 *   Duration:
 *   - Input the number representing the frames used to move.
 * 
 * ---
 * 
 * GRID: Push From Target Node
 * - Pushes battlers away from target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *
 *     Unit:
 *     - Which unit do you want to push from?
 *
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to
 *       push from.
 *
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to
 *       push from.
 * 
 *   Strength:
 *   - Input the strength level of the push.
 * 
 *   Duration:
 *   - Input the number representing the frames used to move.
 * 
 * ---
 *
 * GRID: Remove All Passive States from Node
 * - Removes all Passive State effects at target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 *
 *     Unit:
 *     - Which unit do you want to clear the Node for?
 *
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to clear
 *       Passive States from.
 *
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to clear
 *       Passive States from.
 *
 * ---
 *
 * GRID: Remove Passive State(s) from Node
 * - Remove Passive State(s) at target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 *
 *   State ID(s):
 *   - Select which State ID(s) to remove as a Passive State.
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 *
 *     Unit:
 *     - Which unit do you want to remove the Passive State Node effect for?
 *
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to remove
 *       a Passive State(s) from.
 *
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to remove
 *       a Passive State(s) from.
 *
 * ---
 * 
 * GRID: Remove Trigger from Node
 * - Removes Trigger at target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 * 
 *     Unit:
 *     - Which unit do you want to clear Triggers for?
 * 
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to clear
 *       Triggers from.
 * 
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to clear
 *       Triggers from.
 * 
 * ---
 * 
 * === Action Sequences - Horror Effects ===
 * 
 * These Action Sequences are Horror Effects-related.
 * Requires VisuMZ_2_HorrorEffects!
 * 
 * ---
 *
 * HORROR: Clear All Filters
 * - Clear all Horror Effects filters on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove Horror Effects for.
 *
 * ---
 *
 * HORROR: Glitch Create
 * - Creates the glitch effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to create the Horror Effect for.
 *
 *   Glitch Slices:
 *   - Glitch slices to be used with the target.
 *
 *   Glitch Offset:
 *   - Default offset value.
 *
 *   Glitch Animated?:
 *   - Animate the glitch effect?
 *
 *   Glitch Frequency:
 *   - If animated, how frequent to make the glitch effect?
 *   - Lower = often     Higher = rarer
 *
 *   Glitch Strength:
 *   - If animated, how strong is the glitch effect?
 *   - Lower = weaker     Higher = stronger
 *
 * ---
 *
 * HORROR: Glitch Remove
 * - Removes the glitch effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove the Horror Effect for.
 *
 * ---
 *
 * HORROR: Noise Create
 * - Creates the noise effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to create the Horror Effect for.
 *
 *   Noise Rate:
 *   - Noise rate to be used with the target.
 *
 *   Noise Animated:
 *   - Animate the noise for the target?
 *
 * ---
 *
 * HORROR: Noise Remove
 * - Removes the noise effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove the Horror Effect for.
 *
 * ---
 *
 * HORROR: TV Create
 * - Creates the TV effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to create the Horror Effect for.
 *
 *   TV Line Thickness:
 *   - Default TV line thickness
 *   - Lower = thinner     Higher = thicker
 *
 *   TV Corner Size:
 *   - Default TV line corner size
 *   - Lower = smaller     Higher = bigger
 *
 *   TV Animated:
 *   - Animate the TV?
 *
 *   TV Speed:
 *   - Speed used to animate the TV if animated
 *   - Lower = slower     Higher = faster
 *
 * ---
 *
 * HORROR: TV Remove
 * - Removes the TV effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove the Horror Effect for.
 *
 * ---
 * 
 * === Action Sequences - Impact ===
 * 
 * These Action Sequences are related to creating impact.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * ---
 *
 * IMPACT: Bizarro Inversion
 * - Swaps blue/red colors on the battlefield.
 * - Requires VisuMZ_3_ActSeqImpact!
 * - Created by Manu Gaming!
 *
 *   Bizarro?:
 *   - Enable Bizarro Inversion effect?
 *
 * ---
 *
 * IMPACT: Color Break
 * - Breaks the colors on the screen before reassembling.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Intensity:
 *   - What is the intensity of the color break effect?
 *
 *   Duration:
 *   - What is the duration of the color break effect?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Desaturation
 * - Desaturates all colors on the battlefield.
 * - Requires VisuMZ_3_ActSeqImpact!
 * - Created by Manu Gaming!
 *
 *   Desaturate?:
 *   - Enable Desaturation effect?
 *
 * ---
 *
 * IMPACT: Motion Blur Screen
 * - Creates a motion blur on the whole screen.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Angle:
 *   - Determine what angle to make the motion blur at.
 *
 *   Intensity Rate:
 *   - This determines intensity rate of the motion blur.
 *   - Use a number between 0 and 1.
 *
 *   Duration:
 *   - How many frames should the motion blur last?
 *   - What do you want to be its duration?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Motion Blur Target(s)
 * - Creates a motion blur on selected target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to create motion blur effects for.
 *
 *   Angle:
 *   - Determine what angle to make the motion blur at.
 *
 *   Intensity Rate:
 *   - This determines intensity rate of the motion blur.
 *   - Use a number between 0 and 1.
 *
 *   Duration:
 *   - How many frames should the motion blur last?
 *   - What do you want to be its duration?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Motion Trail Create
 * - Creates a motion trail effect for the target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to create motion trail effects for.
 *
 *   Delay:
 *   - How many frames to delay by when creating a motion trail?
 *   - The higher the delay, the less motion trails there are.
 *
 *   Duration:
 *   - How many frames should the motion trail last?
 *   - What do you want to be its duration?
 *
 *   Hue:
 *   - What do you want to be the hue for the motion trail?
 *
 *   Starting Opacity:
 *   - What starting opacity value do you want for the motion trail?
 *   - Opacity values decrease over time.
 *
 *   Tone:
 *   - What tone do you want for the motion trail?
 *   - Format: [Red, Green, Blue, Gray]
 *
 * ---
 *
 * IMPACT: Motion Trail Remove
 * - Removes the motion trail effect from the target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to clear motion trail effects for.
 *
 * ---
 *
 * IMPACT: Negative Inversion
 * - Inverts all the colors on the battlefield.
 * - Requires VisuMZ_3_ActSeqImpact!
 * - Created by Manu Gaming!
 *
 *   Negative?:
 *   - Enable Negative Inversion effect?
 *
 * ---
 *
 * IMPACT: Oversaturation
 * - Oversaturates colors on the battlefield.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Oversaturate?:
 *   - Enable Oversaturation effect?
 *
 * ---
 *
 * IMPACT: Shockwave at Point
 * - Creates a shockwave at the designated coordinates.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Point: X:
 *   Point: Y:
 *   - What x/y coordinate do you want to create a shockwave at?
 *   - You can use JavaScript code.
 *
 *   Amplitude:
 *   - What is the aplitude of the shockwave effect?
 *
 *   Wavelength:
 *   - What is the wavelength of the shockwave effect?
 *
 *   Duration:
 *   - What is the duration of the shockwave?
 *
 * ---
 *
 * IMPACT: Shockwave from Each Target(s)
 * - Creates a shockwave at each of the target(s) location(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to start a shockwave from.
 *
 *   Target Location:
 *   - Select which part target group to start a shockwave from.
 * 
 *     Offset X:
 *     Offset Y:
 *     - How much to offset the shockwave X/Y point by.
 *
 *   Amplitude:
 *   - What is the aplitude of the shockwave effect?
 *
 *   Wavelength:
 *   - What is the wavelength of the shockwave effect?
 *
 *   Duration:
 *   - What is the duration of the shockwave?
 *
 * ---
 *
 * IMPACT: Shockwave from Target(s) Center
 * - Creates a shockwave from the center of the target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to start a shockwave from.
 *
 *   Target Location:
 *   - Select which part target group to start a shockwave from.
 * 
 *     Offset X:
 *     Offset Y:
 *     - How much to offset the shockwave X/Y point by.
 *
 *   Amplitude:
 *   - What is the aplitude of the shockwave effect?
 *
 *   Wavelength:
 *   - What is the wavelength of the shockwave effect?
 *
 *   Duration:
 *   - What is the duration of the shockwave?
 *
 * ---
 *
 * IMPACT: Time Scale
 * - Adjust time to go faster or slower!
 * - Requires VisuMZ_3_ActSeqImpact!
 * - Created by Manu Gaming!
 *
 *   Scale:
 *   - Adjusts how fast/slow time goes.
 *   - 1.00 is normal. Lower is slower. Higher is faster.
 *
 * ---
 *
 * IMPACT: Time Stop
 * - Stops time for a set amount of milliseconds.
 * - Requires VisuMZ_3_ActSeqImpact!
 * - Created by Manu Gaming!
 *
 *   Milliseconds:
 *   - How many milliseconds should time stop for?
 *   - 1000 milliseconds = 1 second.
 *
 * ---
 *
 * IMPACT: Zoom Blur at Point
 * - Creates a zoom blur at the designated coordinates.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Point: X:
 *   Point: Y:
 *   - What x/y coordinate do you want to focus the zoom at?
 *   - You can use JavaScript code.
 *
 *   Zoom Strength:
 *   - What is the strength of the zoom effect?
 *   - Use a number between 0 and 1.
 *
 *   Visible Radius:
 *   - How much of a radius should be visible from the center?
 *
 *   Duration:
 *   - What is the duration of the zoom blur?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Zoom Blur at Target(s) Center
 * - Creates a zoom blur at the center of targets.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to start a zoom blur from.
 *
 *   Target Location:
 *   - Select which part target group to start a zoom blur from.
 * 
 *     Offset X:
 *     Offset Y:
 *     - How much to offset the zoom blur X/Y point by.
 *
 *   Zoom Strength:
 *   - What is the strength of the zoom effect?
 *   - Use a number between 0 and 1.
 *
 *   Visible Radius:
 *   - How much of a radius should be visible from the center?
 *
 *   Duration:
 *   - What is the duration of the zoom blur?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * === Action Sequences - Inject ===
 *
 * These Action Sequences are related to injecting sprite animations.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * ---
 * 
 * INJECT: Animation Begin
 * - Injects and plays a whole spritesheet animation.
 * - The spritesheet animation will play over the battler until it is finished.
 * - The battler's original sprite will be invisible until finished.
 * - Requires VisuMZ_3_ActSeqImpact!
 * 
 *   Targets:
 *   - Select unit(s) to inject the animation on.
 * 
 *   Filename:
 *   - Select the animation spritesheet file.
 *   - Located in the /img/sv_actors/ folder.
 * 
 *     Horizontal Cells:
 *     - How many horizontal cells (or columns) are there?
 * 
 *     Vertical Cells:
 *     - How many vertical cells (or rows) are there?
 * 
 *     Frame Delay:
 *     - How many frames are played inbetween cells?
 * 
 *     Smooth Bitmap?:
 *     - Smooth the spritesheet graphic?
 * 
 *   Offset:
 * 
 *     Offset X:
 *     - Offsets the X position of the injected animation.
 *     - Negative: left. Positive: right.
 * 
 *     Offset Y:
 *     - Offsets the Y position of the injected animation.
 *     - Negative: up. Positive: down.
 * 
 * ---
 * 
 * INJECT: Animation End
 * - Stops and ends any injected animations on target(s).
 * - Any inject animation will be prematurely terminated.
 * - Requires VisuMZ_3_ActSeqImpact!
 * 
 *   Targets:
 *   - Select unit(s) to stop injected animation(s).
 * 
 * ---
 * 
 * INJECT: Animation Pause/Resume
 * - Pauses/resumes any injected animations on target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 * 
 *   Targets:
 *   - Select unit(s) to pause/resume injected animation(s).
 * 
 *   Pause?:
 *   - Pause the injected animation?
 * 
 * ---
 * 
 * INJECT: Wait For Injected Animation
 * - Waits for injected animations to complete before performing next command.
 * - Requires VisuMZ_3_ActSeqImpact!
 * 
 * ---
 *
 * === Action Sequences - Mechanics ===
 *
 * These Action Sequences are related to various mechanics related to the
 * battle system.
 *
 * ---
 *
 * MECH: Action Effect
 * - Causes the unit(s) to take damage/healing from action and incurs any
 *   changes made such as buffs and states.
 *
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 *
 * ---
 * 
 * MECH: Active Chain Input Disable
 * - Disables input for Active Chain Skills at this time.
 * - Requires VisuMZ_3_ActiveChainSkills!
 * 
 * ---
 *
 * MECH: Add Buff/Debuff
 * - Adds buff(s)/debuff(s) to unit(s). 
 * - Determine which parameters are affected and their durations.
 *
 *   Targets:
 *   - Select unit(s) to receive the buff(s) and/or debuff(s).
 *
 *   Buff Parameters:
 *   - Select which parameter(s) to buff.
 *   - Insert a parameter multiple times to raise its stacks.
 *
 *   Debuff Parameters:
 *   - Select which parameter(s) to debuff.
 *   - Insert a parameter multiple times to raise its stacks.
 *
 *   Turns:
 *   - Number of turns to set the parameter(s) buffs to.
 *   - You may use JavaScript code.
 *
 * ---
 *
 * MECH: Add State
 * - Adds state(s) to unit(s).
 *
 *   Targets:
 *   - Select unit(s) to receive the buff(s).
 *
 *   States:
 *   - Select which state ID(s) to add to unit(s).
 *   - Insert multiple state ID's to add multiple at once.
 *
 * ---
 * 
 * MECH: Analyze Weakness
 * - Reveal elemental weakness(es) from target(s).
 * - Requires VisuMZ_3_WeaknessDisplay!
 * 
 *   Targets:
 *   - Select unit(s) to reveal elemental weaknesses for.
 * 
 *   Reveal:
 *   - How many elemental weaknesses do you wish to reveal?
 *   - You may use JavaScript code.
 * 
 * ---
 *
 * MECH: Armor Penetration
 * - Adds an extra layer of defensive penetration/reduction.
 * - You may use JavaScript code for any of these.
 *
 *   Armor/Magic Penetration:
 *
 *     Rate:
 *     - Penetrates an extra multiplier of armor by this value.
 *
 *     Flat:
 *     - Penetrates a flat amount of armor by this value.
 *
 *   Armor/Magic Reduction:
 *
 *     Rate:
 *     - Reduces an extra multiplier of armor by this value.
 *
 *     Flat:
 *     - Reduces a flat amount of armor by this value.
 *
 * ---
 * 
 * MECH: ATB Gauge
 * - Alters the ATB/TPB Gauges.
 * - Requires VisuMZ_2_BattleSystemATB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the ATB/TPB Gauges for.
 * 
 *   Charging:
 *   
 *     Charge Rate:
 *     - Changes made to the ATB Gauge if it is currently charging.
 * 
 *   Casting:
 *   
 *     Cast Rate:
 *     - Changes made to the ATB Gauge if it is currently casting.
 *   
 *     Interrupt?:
 *     - Interrupt the ATB Gauge if it is currently casting?
 * 
 * ---
 * 
 * MECH: Boost Points Change
 * - Changes Boost Points for target(s).
 * - Requires VisuMZ_3_BoostAction!
 * 
 *   Targets:
 *   - Select unit(s) to alter the Boost Points for.
 * 
 *   Alter Boost Points By:
 *   - Alters the unit(s) Boost Points.
 *   - Positive for gaining points. Negative for losing points.
 * 
 * ---
 * 
 * MECH: Boost Store Data
 * - Stores the number of Boosts used this action inside a variable.
 * - Requires VisuMZ_3_BoostAction!
 * 
 *   Variable ID:
 *   - Which variable do you want to store the data inside?
 * 
 * ---
 * 
 * MECH: Break Shield Change
 * - Changes Break Shields for target(s) if not Break Stunned.
 * - Requires VisuMZ_4_BreakShields!
 * 
 *   Targets:
 *   - Select unit(s) to alter the Break Shields for.
 * 
 *   Alter Break Shields By:
 *   - Alters the unit(s) Break Shields.
 *   - Positive for gaining shields. Negative for losing shields.
 * 
 * ---
 * 
 * MECH: Break Shield Reset
 * - Resets Break Shields for target(s) if not Break Stunned.
 * - Requires VisuMZ_4_BreakShields!
 * 
 *   Targets:
 *   - Select unit(s) to reset the Break Shields for.
 * 
 * ---
 * 
 * MECH: BTB Brave Points
 * - Alters the target(s) Brave Points to an exact value.
 * - Requires VisuMZ_2_BattleSystemBTB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the ATB/TPB Gauges for.
 * 
 *   Alter Brave Points By:
 *   - Alters the target(s) Brave Points.
 *   - Positive for gaining BP.
 *   - Negative for losing BP.
 * 
 * ---
 *
 * MECH: Collapse
 * - Causes the unit(s) to perform its collapse animation if the unit(s)
 *   has died.
 *
 *   Targets:
 *   - Select unit(s) to process a death collapse.
 *
 *   Force Death:
 *   - Force death even if the unit has not reached 0 HP?
 *   - This will remove immortality.
 *
 *   Wait For Effect?:
 *   - Wait for the collapse effect to complete before performing next command?
 *
 * ---
 * 
 * MECH: CTB Order
 * - Alters the CTB Turn Order.
 * - Requires VisuMZ_2_BattleSystemCTB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the CTB Turn Order for.
 * 
 *   Change Order By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 * 
 * ---
 * 
 * MECH: CTB Speed
 * - Alters the CTB Speed.
 * - Requires VisuMZ_2_BattleSystemCTB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the CTB Speed for.
 * 
 *   Charge Rate:
 *   - Changes made to the CTB Speed if it is currently charging.
 * 
 *   Cast Rate:
 *   - Changes made to the CTB Speed if it is currently casting.
 * 
 * ---
 * 
 * MECH: Custom Damage Formula
 * - Changes the current action's damage formula to custom.
 * - This will assume the MANUAL damage style.
 * 
 *   Formula:
 *   - Changes the current action's damage formula to custom.
 *   - Use 'default' to revert the damage formula.
 * 
 * ---
 *
 * MECH: Damage Popup
 * - Causes the unit(s) to display the current state of damage received
 *   or healed.
 *
 *   Targets:
 *   - Select unit(s) to prompt a damage popup.
 *
 * ---
 *
 * MECH: Dead Label Jump
 * - If the active battler is dead, jump to a specific label in the
 *   common event.
 *
 *   Jump To Label:
 *   - If the active battler is dead, jump to this specific label in the
 *     common event.
 *
 * ---
 * 
 * MECH: Emulate Attack Effect
 * - Emulate an "Action Effect" but using a the user's attack skill instead of
 *   the current action.
 * - Essentially lets you perform the mechanics of another action without
 *   having to use another action or needing to pay that action's costs.
 * 
 *   User(s):
 *   - Select unit(s) to perform the action's effects.
 * 
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 * 
 * ---
 * 
 * MECH: Emulate Guard Effect
 * - Emulate an "Action Effect" but using a the user's guard skill instead of
 *   the current action.
 * - Essentially lets you perform the mechanics of another action without
 *   having to use another action or needing to pay that action's costs.
 * 
 *   User(s):
 *   - Select unit(s) to perform the action's effects.
 * 
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 * 
 * ---
 * 
 * MECH: Emulate Item Effect
 * - Emulate an "Action Effect" but using a specific item instead of the
 *   current action.
 * - Essentially lets you perform the mechanics of another action without
 *   having to use another action or needing to pay that action's costs.
 * 
 *   Item ID:
 *   - Which item ID will be emulated?
 * 
 *   User(s):
 *   - Select unit(s) to perform the action's effects.
 * 
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 * 
 * ---
 * 
 * MECH: Emulate Skill Cost
 * - Pick a skill for target(s) to emulate paying the cost of.
 * - Lets you cause characters to perform paying the costs of a specific skill
 *   without needing to actually use them.
 * - This will include Skill Cooldowns and Limited Skill Uses.
 * 
 *   Skill ID:
 *   - Which skill ID will have its cost paid for?
 *   - Use 0 for current action's skill.
 * 
 *   User(s):
 *   - Select unit(s) to perform the action's effects.
 * 
 * ---
 * 
 * MECH: Emulate Skill Effect
 * - Emulate an "Action Effect" but using a specific skill instead of the
 *   current action.
 * - Essentially lets you perform the mechanics of another action without
 *   having to use another action or needing to pay that action's costs.
 * 
 *   Skill ID:
 *   - Which skill ID will be emulated?
 * 
 *   User(s):
 *   - Select unit(s) to perform the action's effects.
 * 
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 * 
 * ---
 *
 * MECH: Enemy Escape
 * - Causes the enemy unit(s) to escape.
 *
 *   Targets:
 *   - Select unit(s) to escape.
 *
 * ---
 *
 * MECH: ETB Energy Count
 * - Alters the subject team's available Energy Count.
 * - Requires VisuMZ_2_BattleSystemETB!
 *
 *   Energy Count:
 *   - Alters the subject team's available Energy Count.
 *   - Positive for gaining energy. Negative for losing energy.
 *
 * ---
 *
 * MECH: FTB Action Count
 * - Alters the subject team's available Action Count.
 * - Requires VisuMZ_2_BattleSystemFTB!
 *
 *   Action Count:
 *   - Alters the subject team's available Action Count.
 *   - Positive for gaining actions. Negative for losing actions.
 *
 * ---
 *
 * MECH: HP, MP, TP
 * - Alters the HP, MP, and TP values for unit(s).
 * - Positive values for healing. Negative values for damage.
 *
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 *
 *   HP, MP, TP:
 *
 *     Rate:
 *     - Changes made to the parameter based on rate.
 *     - Positive values for healing. Negative values for damage.
 *
 *     Flat:
 *     - Flat changes made to the parameter.
 *     - Positive values for healing. Negative values for damage.
 *
 *   Damage Popup?:
 *   - Display a damage popup after?
 *
 * ---
 *
 * MECH: Immortal
 * - Changes the immortal flag of targets. If immortal flag is removed and a
 *   unit would die, collapse that unit.
 *
 *   Targets:
 *   - Alter the immortal flag of these groups. If immortal flag is removed and
 *     a unit would die, collapse that unit.
 *
 *   Immortal:
 *   - Turn immortal flag for unit(s) on/off?
 *
 * ---
 *
 * MECH: Multipliers
 * - Changes the multipliers for the current action.
 * - You may use JavaScript code for any of these.
 *
 *   Critical Hit%:
 *
 *     Rate:
 *     - Affects chance to land a critical hit by this multiplier.
 *
 *     Flat:
 *     - Affects chance to land a critical hit by this flat bonus.
 *
 *   Critical Damage
 *
 *     Rate:
 *     - Affects critical damage by this multiplier.
 *
 *     Flat:
 *     - Affects critical damage by this flat bonus.
 *
 *   Damage/Healing
 *
 *     Rate:
 *     - Sets the damage/healing multiplier for current action.
 *
 *     Flat:
 *     - Sets the damage/healing bonus for current action.
 *
 *   Hit Rate
 *
 *     Rate:
 *     - Affects chance to connect attack by this multiplier.
 *
 *     Flat:
 *     - Affects chance to connect attack by this flat bonus.
 *
 * ---
 * 
 * MECH: Once Parallel
 * - Plays a Common Event parallel to the battle event once without repeating
 *   itself when done.
 * 
 *   Common Event ID:
 *   - The ID of the parallel Common Event to play.
 *   - Does NOT repeat itself when finished.
 *   - When exiting battle scene, all Once Parallels are cleared.
 *   - Once Parallels are not retained upon reentering the scene.
 *   - Once Parallels are not stored in memory and cannot be saved.
 * 
 * ---
 * 
 * MECH: OTB Order
 * - Alters the OTB Turn Order. Best used with single targets.
 * - Requires VisuMZ_2_BattleSystemOTB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the OTB Turn Order for.
 * 
 *   Current Turn By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 * 
 *   Next Turn By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 * 
 *   Follow Turn By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 * 
 * ---
 * 
 * MECH: PTB Alter Cost
 * - Alters the action's cost settings.
 * - Requires VisuMZ_2_BattleSystemPTB!
 * 
 *   Override?:
 *   - Overrides any 'permanent' settings for Changeability?
 * 
 *   Alter Changeability:
 *   - Allow the cost type and value to be changeable?
 * 
 *   Alter Cost Type:
 *   - Change the cost type to this scenario.
 *   - Use 'Unchanged' for no changes.
 * 
 *   Alter Cost Value:
 *   - What is the default action cost for this scenario?
 * 
 *   Priority:
 *   - What is this scenario's priority? Scenario outcomes with equal or lower
 *     priorities cannot override types and costs.
 * 
 * ---
 * 
 * MECH: PTB Conversion
 * - Converts full actions into half actions.
 * - Requires VisuMZ_2_BattleSystemPTB!
 * 
 *   Conversion Count:
 *   - Converts full actions into half actions.
 *   - If not enough, consume half actions.
 * 
 * ---
 * 
 * MECH: PTB Full/Half Action(s)
 * - Alters the subject team's available Full/Half Actions.
 * - Requires VisuMZ_2_BattleSystemPTB!
 * 
 *   Full Actions:
 *   - Alters the subject team's available Full Actions.
 *   - Positive for gaining. Negative for losing.
 * 
 *   Half Actions:
 *   - Alters the subject team's available Half Actions.
 *   - Positive for gaining. Negative for losing.
 * 
 * ---
 *
 * MECH: Remove Buff/Debuff
 * - Removes buff(s)/debuff(s) from unit(s). 
 * - Determine which parameters are removed.
 *
 *   Targets:
 *   - Select unit(s) to have the buff(s) and/or debuff(s) removed.
 *
 *   Buff Parameters:
 *   - Select which buffed parameter(s) to remove.
 *
 *   Debuff Parameters:
 *   - Select which debuffed parameter(s) to remove.
 *
 * ---
 *
 * MECH: Remove State
 * - Remove state(s) from unit(s).
 *
 *   Targets:
 *   - Select unit(s) to have states removed from.
 *
 *   States:
 *   - Select which state ID(s) to remove from unit(s).
 *   - Insert multiple state ID's to remove multiple at once.
 *
 * ---
 * 
 * MECH: State Turns Change By
 * - Changes target(s) state turns by an amount.
 * - Requires VisuMZ_1_SkillsStatesCore!
 * 
 *   Targets:
 *   - Select unit(s) to affect state turns for.
 * 
 *   State ID:
 *   - What is the ID of the state you wish to change turns for?
 *   - Only works on states that can have turns.
 * 
 *   Change Turns By:
 *   - How many turns should the state be changed to?
 *   - You may use JavaScript code.
 * 
 *   Auto-Add State?:
 *   - Automatically adds state if actor(s) does not have it applied?
 * 
 * ---
 * 
 * MECH: State Turns Change To
 * - Changes target(s) state turns to a specific value.
 * - Requires VisuMZ_1_SkillsStatesCore!
 * 
 *   Targets:
 *   - Select unit(s) to affect state turns for.
 * 
 *   State ID:
 *   - What is the ID of the state you wish to change turns for?
 *   - Only works on states that can have turns.
 * 
 *   Change Turns To:
 *   - How many turns should the state be changed to?
 *   - You may use JavaScript code.
 * 
 *   Auto-Add State?:
 *   - Automatically adds state if target(s) does not have it applied?
 * 
 * ---
 * 
 * MECH: STB Exploit Effect
 * - Utilize the STB Exploitation mechanics!
 * - Requires VisuMZ_2_BattleSystemSTB!
 * 
 *   Target(s) Exploited?:
 *   - Exploit the below targets?
 * 
 *     Targets:
 *     - Select unit(s) to become exploited.
 * 
 *     Force Exploitation:
 *     - Force the exploited status?
 * 
 *   User Exploiter?:
 *   - Allow the user to become the exploiter?
 * 
 *     Force Exploitation:
 *     - Force the exploiter status?
 * 
 * ---
 * 
 * MECH: STB Extra Action
 * - Adds an extra action for the currently active battler.
 * - Requires VisuMZ_2_BattleSystemSTB!
 * 
 *   Extra Actions:
 *   - How many extra actions should the active battler gain?
 *   - You may use JavaScript code.
 * 
 * ---
 * 
 * MECH: STB Remove Excess Actions
 * - Removes excess actions from the active battler.
 * - Requires VisuMZ_2_BattleSystemSTB!
 * 
 *   Remove Actions:
 *   - How many actions to remove from the active battler?
 *   - You may use JavaScript code.
 * 
 * ---
 * 
 * MECH: Swap Weapon
 * - Causes the unit(s) to swap their weapon for another.
 * - Requires VisuMZ_2_WeaponSwapSystem!
 * 
 *   Targets:
 *   - Select unit(s) to swap weapons for.
 * 
 *   Weapon Type ID:
 *   - Which weapon type to swap to?
 *   - This is NOT the weapon's ID.
 *   - It's the weapon TYPE.
 * 
 * ---
 * 
 * MECH: Text Popup
 * - Causes the unit(s) to display a text popup.
 * 
 *   Targets:
 *   - Select unit(s) to prompt a text popup.
 * 
 *   Text:
 *   - What text do you wish to display?
 * 
 *   Text Color:
 *   - Use #rrggbb for custom colors or regular numbers for text colors from
 *     the Window Skin.
 * 
 *   Flash Color:
 *   - Adjust the popup's flash color.
 *   - Format: [red, green, blue, alpha]
 * 
 *   Flash Duration:
 *   - What is the frame duration of the flash effect?
 * 
 * ---
 * 
 * MECH: Variable Popup
 * - Causes the unit(s) to display a popup using the data stored inside
 *   a variable.
 * 
 *   Targets:
 *   - Select unit(s) to prompt a text popup.
 * 
 *   Variable:
 *   - Get data from which variable to display as a popup?
 * 
 *   Digit Grouping:
 *   - Use digit grouping to separate numbers?
 *   - Requires VisuMZ_0_CoreEngine!
 * 
 *   Text Color:
 *   - Use #rrggbb for custom colors or regular numbers for text colors from
 *     the Window Skin.
 * 
 *   Flash Color:
 *   - Adjust the popup's flash color.
 *   - Format: [red, green, blue, alpha]
 * 
 *   Flash Duration:
 *   - What is the frame duration of the flash effect?
 * 
 * ---
 *
 * MECH: Wait For Effect
 * - Waits for the effects to complete before performing next command.
 *
 * ---
 *
 * === Action Sequences - Motion ===
 *
 * These Action Sequences allow you the ability to control the motions of
 * sideview sprites.
 *
 * ---
 * 
 * MOTION: Clear Freeze Frame
 * - Clears any freeze frames from the unit(s).
 * - Only applies to sprite sheets.
 * - Does NOT work with Dragonbones.
 * - Use "DB: Dragonbones Time Scale" instead.
 * 
 *   Targets:
 *   - Select which unit(s) to clear freeze frames for.
 * 
 * ---
 * 
 * MOTION: Freeze Motion Frame
 * - Forces a freeze frame instantly at the selected motion.
 * - Automatically clears with a new motion.
 * - Only applies to sprite sheets.
 * - Does NOT work with Dragonbones.
 * - Use "DB: Dragonbones Time Scale" instead.
 * 
 *   Targets:
 *   - Select which unit(s) to freeze motions for.
 * 
 *   Motion Type:
 *   - Freeze this motion for the unit(s).
 * 
 *   Frame Index:
 *   - Which frame do you want to freeze the motion on?
 *   - Frame index values start at 0.
 * 
 *   Show Weapon?:
 *   - If using 'attack', 'thrust', 'swing', or 'missile', display the
 *     weapon sprite?
 * 
 * ---
 *
 * MOTION: Motion Type
 * - Causes the unit(s) to play the selected motion.
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion.
 *
 *   Motion Type:
 *   - Play this motion for the unit(s).
 *
 *   Show Weapon?:
 *   - If using 'attack', 'thrust', 'swing', or 'missile', display the
 *     weapon sprite?
 *
 * ---
 *
 * MOTION: Perform Action
 * - Causes the unit(s) to play the proper motion based on the current action.
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion.
 *
 * ---
 *
 * MOTION: Refresh Motion
 * - Cancels any set motions unit(s) has to do and use their most natural
 *   motion at the moment.
 *
 *   Targets:
 *   - Select which unit(s) to refresh their motion state.
 *
 * ---
 *
 * MOTION: Wait By Motion Frame
 * - Creates a wait equal to the number of motion frames passing.
 * - Time is based on Plugin Parameters => Actors => Motion Speed.
 *
 *   Motion Frames to Wait?:
 *   - Each "frame" is equal to the value found in 
 *     Plugin Parameters => Actors => Motion Speed
 *
 * ---
 *
 * === Action Sequences - Movement ===
 *
 * These Action Sequences allow you the ability to control the sprites of
 * actors and enemies in battle.
 *
 * ---
 *
 * MOVE: Battle Step
 * - Causes the unit(s) to move forward past their home position to prepare
 *   for action.
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Change Home By Distance
 * - Change unit(s)'s home position by a distance from their current home
 *   position(s).
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change home position(s) for.
 *
 *   Distance Adjustment:
 *   - Makes adjustments to distance values to determine which direction to
 *     change by.
 *     - Normal - No adjustments made
 *     - Horizontal - Actors adjust left, Enemies adjust right
 *     - Vertical - Actors adjust Up, Enemies adjust down
 *     - Both - Applies both Horizontal and Vertical
 *
 *     Distance: X:
 *     - Horizontal distance to move.
 *     - You may use JavaScript code.
 *
 *     Distance: Y:
 *     - Vertical distance to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total change amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Change Home To JS Coordinates
 * - Change home position(s) to specified JS Coordinates.
 * - Sideview-only! Uses JavaScript!
 *
 *   Targets:
 *   - Select which unit(s) to change home position(s) for.
 *
 *   JS: Coordinates:
 *   - Code used to determine the coordinates for the target(s)'s new home
 *     position.
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total change amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Change Home To Point
 * - Change home position(s) to a target point on the screen.
 * - Sideview-only! Points based off Graphics.boxWidth/Height.
 *
 *   Targets:
 *   - Select which unit(s) to change home position(s) for.
 *
 *   Destination Point:
 *   - Select which point to face.
 *     - Center
 *     - Point X, Y
 *       - Replace 'x' and 'y' with coordinates
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total change amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Change Home To Target(s)
 * - Moves unit(s) to another unit(s) on the battle field.
 * - Sideview-only!
 *
 *   Targets (Moving):
 *   - Select which unit(s) to change home position(s) for.
 *
 *   Targets (Destination):
 *   - Select which unit(s) to change home position to.
 *
 *     Target Location:
 *     - Select which part target group to change home position to.
 *       - front head
 *       - front center
 *       - front base
 *       - middle head
 *       - middle center
 *       - middle base
 *       - back head
 *       - back center
 *       - back base
 *
 *     Melee Distance:
 *     - The melee distance away from the target location in addition to the
 *       battler's width.
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total change amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Face Direction
 * - Causes the unit(s) to face forward or backward.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change direction.
 *
 *   Direction:
 *   - Select which direction to face.
 *
 * ---
 *
 * MOVE: Face JS Coordinates
 * - Causes the unit(s) to face specified JS Coordinates.
 * - Sideview-only! Uses JavaScript!
 *
 *   Targets:
 *   - Select which unit(s) to change direction.
 *
 *   JS: Coordinates:
 *   - Code used to determine the coordinates for the target(s) to face
 *     towards.
 *
 *   Face Away From?:
 *   - Face away from the point instead?
 *
 * ---
 *
 * MOVE: Face Point
 * - Causes the unit(s) to face a point on the screen.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change direction.
 *
 *   Point:
 *   - Select which point to face.
 *     - Home
 *     - Center
 *     - Point X, Y
 *       - Replace 'x' and 'y' with coordinates
 *
 *   Face Away From?:
 *   - Face away from the point instead?
 *
 * ---
 *
 * MOVE: Face Target(s)
 * - Causes the unit(s) to face other targets on the screen.
 * - Sideview-only!
 *
 *   Targets (facing):
 *   - Select which unit(s) to change direction.
 *
 *   Targets (destination):
 *   - Select which unit(s) for the turning unit(s) to face.
 *
 *   Face Away From?:
 *   - Face away from the unit(s) instead?
 *
 * ---
 *
 * MOVE: Float
 * - Causes the unit(s) to float above the ground.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to make float.
 *
 *   Desired Height:
 *   - Vertical distance to float upward.
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total float amount.
 *
 *   Float Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Float?:
 *   - Wait for floating to complete before performing next command?
 *
 * ---
 *
 * MOVE: Home Reset
 * - Causes the unit(s) to move back to their home position(s) and face back to
 *   their original direction(s).
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Jump
 * - Causes the unit(s) to jump into the air.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to make jump.
 *
 *   Desired Height:
 *   - Max jump height to go above the ground
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total jump amount.
 *
 *   Wait For Jump?:
 *   - Wait for jumping to complete before performing next command?
 *
 * ---
 *
 * MOVE: Move Distance
 * - Moves unit(s) by a distance from their current position(s).
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Distance Adjustment:
 *   - Makes adjustments to distance values to determine which direction to
 *     move unit(s).
 *     - Normal - No adjustments made
 *     - Horizontal - Actors adjust left, Enemies adjust right
 *     - Vertical - Actors adjust Up, Enemies adjust down
 *     - Both - Applies both Horizontal and Vertical
 *
 *     Distance: X:
 *     - Horizontal distance to move.
 *     - You may use JavaScript code.
 *
 *     Distance: Y:
 *     - Vertical distance to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total movement amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Move To JS Coordinates
 * - Moves unit(s) to specified JS Coordinates.
 * - Sideview-only! Uses JavaScript!
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   JS: Coordinates:
 *   - Code used to determine the coordinates for the target(s) to move to.
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total movement amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Move To Point
 * - Moves unit(s) to a designated point on the screen.
 * - Sideview-only! Points based off Graphics.boxWidth/Height.
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Destination Point:
 *   - Select which point to face.
 *     - Home
 *     - Center
 *     - Point X, Y
 *       - Replace 'x' and 'y' with coordinates
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total movement amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Move To Target(s)
 * - Moves unit(s) to another unit(s) on the battle field.
 * - Sideview-only!
 *
 *   Targets (Moving):
 *   - Select which unit(s) to move.
 *
 *   Targets (Destination):
 *   - Select which unit(s) to move to.
 *
 *     Target Location:
 *     - Select which part target group to move to.
 *       - front head
 *       - front center
 *       - front base
 *       - middle head
 *       - middle center
 *       - middle base
 *       - back head
 *       - back center
 *       - back base
 *
 *     Melee Distance:
 *     - The melee distance away from the target location in addition to the
 *       battler's width.
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total movement amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Opacity
 * - Causes the unit(s) to change opacity.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change opacity.
 *
 *   Desired Opacity:
 *   - Change to this opacity value.
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for opacity change.
 *
 *   Opacity Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Opacity?:
 *   - Wait for opacity changes to complete before performing next command?
 *
 * ---
 *
 * MOVE: Scale/Grow/Shrink
 * - Causes the unit(s) to scale, grow, or shrink?.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change the scale of.
 *
 *   Scale X:
 *   Scale Y:
 *   - What target scale value do you want?
 *   - 1.0 is normal size.
 *
 *   Duration:
 *   - Duration in frames to scale for.
 *
 *   Scale Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Scale?:
 *   - Wait for scaling to complete before performing next command?
 *
 * ---
 *
 * MOVE: Skew/Distort
 * - Causes the unit(s) to skew.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to skew.
 *
 *   Skew X:
 *   Skew Y:
 *   - What variance to skew?
 *   - Use small values for the best results.
 *
 *   Duration:
 *   - Duration in frames to skew for.
 *
 *   Skew Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Skew?:
 *   - Wait for skew to complete before performing next command?
 *
 * ---
 *
 * MOVE: Spin/Rotate
 * - Causes the unit(s) to spin.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to spin.
 *
 *   Angle:
 *   - How many degrees to spin?
 *
 *   Duration:
 *   - Duration in frames to spin for.
 *
 *   Spin Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 * 
 *   Revert Angle on Finish:
 *   - Upon finishing the spin, revert the angle back to 0.
 *
 *   Wait For Spin?:
 *   - Wait for spin to complete before performing next command?
 *
 * ---
 *
 * MOVE: Wait For Float
 * - Waits for floating to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Jump
 * - Waits for jumping to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Movement
 * - Waits for movement to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Opacity
 * - Waits for opacity changes to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Scale
 * - Waits for scaling to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Skew
 * - Waits for skewing to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Spin
 * - Waits for spinning to complete before performing next command.
 *
 * ---
 * 
 * === Action Sequences - Projectiles ===
 * 
 * Create projectiles on the screen and fire them off at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 * 
 * ---
 *
 * PROJECTILE: Animation
 * - Create an animation projectile and fire it at a target.
 * - Requires VisuMZ_3_ActSeqProjectiles!
 *
 *   Coordinates:
 *
 *     Start Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should start from.
 *         - Target - Start from battler target(s)
 *         - Point - Start from a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) to start the projectile from.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile from.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to start the projectile at.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *     Goal Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should go to.
 *         - Target - Goal is battler target(s)
 *         - Point - Goal is a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) for projectile to go to.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile to.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to send the projectile to.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *   Settings:
 *
 *     Animation ID:
 *     - Determine which animation to use as a projectile.
 *
 *     Duration:
 *     - Duration for the projectile(s) to travel.
 *
 *     Wait For Projectile?:
 *     - Wait for projectile(s) to reach their destination before going onto
 *       the next command?
 * 
 *     Wait For Animation?:
 *     - Wait for animation to finish before going to the next command?
 *
 *     Extra Settings:
 *     - Add extra settings to the projectile?
 *
 *       Auto Angle?:
 *       - Automatically angle the projectile to tilt the direction
 *         it's moving?
 *
 *       Angle Offset:
 *       - Alter the projectile's tilt by this many degrees.
 *
 *       Arc Peak:
 *       - This is the height of the projectile's trajectory arc in pixels.
 *
 *       Easing:
 *       - Select which easing type to apply to the projectile's trajectory.
 *
 *       Spin Speed:
 *       - Determine how much angle the projectile spins per frame.
 *       - Does not work well with "Auto Angle".
 * 
 *     Effect Emulation:
 * 
 *       Action Effect?:
 *       - Emulate current Action Effect when projectile reaches target?
 *       - Only works with start and goal targets.
 * 
 *       Item Effect ID?:
 *       - Emulate an Item Effect when projectile reaches target?
 *       - Use 0 to not use.
 *       - Only works with start and goal targets.
 * 
 *       Skill Effect ID?:
 *       - Emulate a Skill Effect when projectile reaches target?
 *       - Use 0 to not use.
 *       - Only works with start and goal targets.
 * 
 *       Common Event ID:
 *       - Plays a Once Parallel Common Event upon reaching target.
 *       - Use 0 to not use.
 *       - Works regardless of start/goal targets.
 * 
 *     End Animation ID:
 *     - Plays an animation when projectile reaches target.
 *     - Use 0 to not use.
 *     - Requires VisuMZ_1_BattleCore v1.86+.
 *     - Requires VisuMZ_3_ActSeqProjectiles v1.09+.
 * 
 *       Mirror Animation:
 *       - Mirror the effect animation?
 *       - Requires VisuMZ_1_BattleCore v1.86+.
 *       - Requires VisuMZ_3_ActSeqProjectiles version 1.09+.
 * 
 *       Mute Animation:
 *       - Mute the effect animation?
 *       - Requires VisuMZ_1_BattleCore v1.86+.
 *       - Requires VisuMZ_3_ActSeqProjectiles version 1.09+.
 *     
 *
 * ---
 *
 * PROJECTILE: Icon
 * - Create an icon projectile and fire it at a target.
 * - Requires VisuMZ_3_ActSeqProjectiles!
 *
 *   Coordinates:
 *
 *     Start Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should start from.
 *         - Target - Start from battler target(s)
 *         - Point - Start from a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) to start the projectile from.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile from.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to start the projectile at.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *     Goal Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should go to.
 *         - Target - Goal is battler target(s)
 *         - Point - Goal is a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) for projectile to go to.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile to.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to send the projectile to.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *   Settings:
 *
 *     Icon:
 *     - Determine which icon to use as a projectile.
 *       - You may use JavaScript code.
 *
 *     Duration:
 *     - Duration for the projectile(s) to travel.
 *
 *     Wait For Projectile?:
 *     - Wait for projectile(s) to reach their destination before going onto
 *       the next command?
 *
 *     Extra Settings:
 *     - Add extra settings to the projectile?
 *
 *       Auto Angle?:
 *       - Automatically angle the projectile to tilt the direction
 *         it's moving?
 *
 *       Angle Offset:
 *       - Alter the projectile's tilt by this many degrees.
 *
 *       Arc Peak:
 *       - This is the height of the projectile's trajectory arc in pixels.
 *
 *       Blend Mode:
 *       - What kind of blend mode do you wish to apply to the projectile?
 *         - Normal
 *         - Additive
 *         - Multiply
 *         - Screen
 *
 *       Easing:
 *       - Select which easing type to apply to the projectile's trajectory.
 *
 *       Hue:
 *       - Adjust the hue of the projectile.
 *       - Insert a number between 0 and 360.
 *
 *       Scale:
 *       - Adjust the size scaling of the projectile.
 *       - Use decimals for exact control.
 *
 *       Spin Speed:
 *       - Determine how much angle the projectile spins per frame.
 *       - Does not work well with "Auto Angle".
 * 
 *     Effect Emulation:
 * 
 *       Action Effect?:
 *       - Emulate current Action Effect when projectile reaches target?
 *       - Only works with start and goal targets.
 * 
 *       Item Effect ID?:
 *       - Emulate an Item Effect when projectile reaches target?
 *       - Use 0 to not use.
 *       - Only works with start and goal targets.
 * 
 *       Skill Effect ID?:
 *       - Emulate a Skill Effect when projectile reaches target?
 *       - Use 0 to not use.
 *       - Only works with start and goal targets.
 * 
 *       Common Event ID:
 *       - Plays a Once Parallel Common Event upon reaching target.
 *       - Use 0 to not use.
 *       - Works regardless of start/goal targets.
 * 
 *     End Animation ID:
 *     - Plays an animation when projectile reaches target.
 *     - Use 0 to not use.
 *     - Requires VisuMZ_1_BattleCore v1.86+.
 *     - Requires VisuMZ_3_ActSeqProjectiles v1.09+.
 * 
 *       Mirror Animation:
 *       - Mirror the effect animation?
 *       - Requires VisuMZ_1_BattleCore v1.86+.
 *       - Requires VisuMZ_3_ActSeqProjectiles version 1.09+.
 * 
 *       Mute Animation:
 *       - Mute the effect animation?
 *       - Requires VisuMZ_1_BattleCore v1.86+.
 *       - Requires VisuMZ_3_ActSeqProjectiles version 1.09+.
 *
 * ---
 *
 * PROJECTILE: Picture
 * - Create a picture projectile and fire it at a target.
 * - Requires VisuMZ_3_ActSeqProjectiles!
 *
 *   Coordinates:
 *
 *     Start Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should start from.
 *         - Target - Start from battler target(s)
 *         - Point - Start from a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) to start the projectile from.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile from.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to start the projectile at.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *     Goal Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should go to.
 *         - Target - Goal is battler target(s)
 *         - Point - Goal is a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) for projectile to go to.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile to.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to send the projectile to.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *   Settings:
 *
 *     Picture Filename:
 *     - Determine which picture to use as a projectile.
 *
 *     Duration:
 *     - Duration for the projectile(s) to travel.
 *
 *     Wait For Projectile?:
 *     - Wait for projectile(s) to reach their destination before going onto
 *       the next command?
 *
 *     Extra Settings:
 *     - Add extra settings to the projectile?
 *
 *       Auto Angle?:
 *       - Automatically angle the projectile to tilt the direction
 *         it's moving?
 *
 *       Angle Offset:
 *       - Alter the projectile's tilt by this many degrees.
 *
 *       Arc Peak:
 *       - This is the height of the projectile's trajectory arc in pixels.
 *
 *       Blend Mode:
 *       - What kind of blend mode do you wish to apply to the projectile?
 *         - Normal
 *         - Additive
 *         - Multiply
 *         - Screen
 *
 *       Easing:
 *       - Select which easing type to apply to the projectile's trajectory.
 *
 *       Hue:
 *       - Adjust the hue of the projectile.
 *       - Insert a number between 0 and 360.
 *
 *       Scale:
 *       - Adjust the size scaling of the projectile.
 *       - Use decimals for exact control.
 *
 *       Spin Speed:
 *       - Determine how much angle the projectile spins per frame.
 *       - Does not work well with "Auto Angle".
 * 
 *     Effect Emulation:
 * 
 *       Action Effect?:
 *       - Emulate current Action Effect when projectile reaches target?
 *       - Only works with start and goal targets.
 * 
 *       Item Effect ID?:
 *       - Emulate an Item Effect when projectile reaches target?
 *       - Use 0 to not use.
 *       - Only works with start and goal targets.
 * 
 *       Skill Effect ID?:
 *       - Emulate a Skill Effect when projectile reaches target?
 *       - Use 0 to not use.
 *       - Only works with start and goal targets.
 * 
 *       Common Event ID:
 *       - Plays a Once Parallel Common Event upon reaching target.
 *       - Use 0 to not use.
 *       - Works regardless of start/goal targets.
 * 
 *     End Animation ID:
 *     - Plays an animation when projectile reaches target.
 *     - Use 0 to not use.
 *     - Requires VisuMZ_1_BattleCore v1.86+.
 *     - Requires VisuMZ_3_ActSeqProjectiles v1.09+.
 * 
 *       Mirror Animation:
 *       - Mirror the effect animation?
 *       - Requires VisuMZ_1_BattleCore v1.86+.
 *       - Requires VisuMZ_3_ActSeqProjectiles version 1.09+.
 * 
 *       Mute Animation:
 *       - Mute the effect animation?
 *       - Requires VisuMZ_1_BattleCore v1.86+.
 *       - Requires VisuMZ_3_ActSeqProjectiles version 1.09+.
 *
 * ---
 * 
 * === Action Sequences - Skew ===
 * 
 * These action sequences allow you to have control over the camera skew.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * ---
 *
 * SKEW: Change Skew
 * - Changes the camera skew.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Skew X:
 *   - Change the camera skew X to this value.
 *
 *   Skew Y:
 *   - Change the camera skew Y to this value.
 *
 *   Duration:
 *   - Duration in frames to change camera skew.
 *
 *   Skew Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Skew?:
 *   - Wait for skew changes to complete before performing next command?
 *
 * ---
 *
 * SKEW: Reset Skew
 * - Reset any skew settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Duration:
 *   - Duration in frames to reset camera skew.
 *
 *   Skew Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Skew?:
 *   - Wait for skew changes to complete before performing next command?
 *
 * ---
 *
 * SKEW: Wait For Skew
 * - Waits for skew changes to complete before performing next command.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * === Action Sequences - Target ===
 *
 * If using a manual target by target Action Sequence, these commands will give
 * you full control over its usage.
 *
 * ---
 *
 * TARGET: Current Index
 * - Sets the current index to this value.
 * - Then decide to jump to a label (optional).
 *
 *   Set Index To:
 *   - Sets current targeting index to this value.
 *   - 0 is the starting index of a target group.
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 *
 * TARGET: Next Target
 * - Moves index forward by 1 to select a new current target.
 * - Then decide to jump to a label (optional).
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 *
 * TARGET: Previous Target
 * - Moves index backward by 1 to select a new current target.
 * - Then decide to jump to a label (optional).
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 *
 * TARGET: Random Target
 * - Sets index randomly to determine new currernt target.
 * - Then decide to jump to a label (optional).
 *
 *   Force Random?:
 *   - Index cannot be its previous index amount after random.
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 * 
 * === Action Sequences - Voice ==
 * 
 * ---
 *
 * VOICE: Common Line
 * - Plays a common voice line from target battler(s).
 * - Requires VisuMZ_3_BattleVoices!
 *
 *   Speaker Target(s):
 *   - Select unit(s) to play voice lines from.
 *
 *   Voice Line:
 *   - What voice line do you wish to play?
 *
 * ---
 *
 * VOICE: Play Special Line
 * - Plays a special voice line from target battler(s).
 * - Requires VisuMZ_3_BattleVoices!
 *
 *   Speaker Target(s):
 *   - Select unit(s) to play voice lines from.
 *
 *   Voice Line Type:
 *   - What voice line type do you wish to play?
 *     - Action Name
 *     - Chant Line
 *     - Item Name
 *     - Skill Name
 *     - Spell Name
 *     - Unique Lines
 *
 *   Name / Letter:
 *   - What voice letter/name do you want to play?
 *
 * ---
 *
 * === Action Sequences - Weapon ===
 *
 * Allows for finer control over Dual/Multi Wielding actors.
 * Only works for Actors.
 *
 * ---
 *
 * WEAPON: Clear Weapon Slot
 * - Clears the active weapon slot (making others valid again).
 * - Only works for Actors.
 *
 *   Targets:
 *   - Select unit(s) to clear the active weapon slot for.
 *
 * ---
 *
 * WEAPON: Next Weapon Slot
 * - Goes to next active weapon slot (making others invalid).
 * - If next slot is weaponless, don't label jump.
 *
 *   Targets:
 *   - Select unit(s) to change the next active weapon slot for.
 *
 * ---
 *
 * WEAPON: Set Weapon Slot
 * - Sets the active weapon slot (making others invalid).
 * - Only works for Actors.
 *
 *   Targets:
 *   - Select unit(s) to change the active weapon slot for.
 *
 *   Weapon Slot ID:
 *   - Select weapon slot to make active (making others invalid).
 *   - Use 0 to clear and normalize. You may use JavaScript code.
 *
 * ---
 *
 * === Action Sequences - Zoom ===
 *
 * These Action Sequences are zoom-related.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * ZOOM: Change Scale
 * - Changes the zoom scale.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Scale:
 *   - The zoom scale to change to.
 *
 *   Duration:
 *   - Duration in frames to reset battle zoom.
 *
 *   Zoom Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Zoom?
 *   - Wait for zoom changes to complete before performing next command?
 *
 * ---
 *
 * ZOOM: Reset Zoom
 * - Reset any zoom settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Duration:
 *   - Duration in frames to reset battle zoom.
 *
 *   Zoom Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Zoom?
 *   - Wait for zoom changes to complete before performing next command?
 *
 * ---
 *
 * ZOOM: Wait For Zoom
 * - Waits for zoom changes to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Auto Battle Settings
 * ============================================================================
 *
 * These Plugin Parameter settings allow you to change the aspects added by
 * this plugin that support Auto Battle and the Auto Battle commands.
 *
 * Auto Battle commands can be added to the Party Command Window and/or Actor
 * Command Window. The one used by the Party Command Window will cause the
 * whole party to enter an Auto Battle state until stopped by a button input.
 * The command used by the Actor Command Window, however, will cause the actor
 * to select an action based off the Auto Battle A.I. once for the current turn
 * instead.
 *
 * ---
 *
 * Battle Display
 * 
 *   Message:
 *   - Message that's displayed when Auto Battle is on.
 *     Text codes allowed. %1 - OK button, %2 - Cancel button
 * 
 *   OK Button:
 *   - Text used to represent the OK button.
 *   - If VisuMZ_0_CoreEngine is present, ignore this.
 * 
 *   Cancel Button:
 *   - Text used to represent the Cancel button.
 *   - If VisuMZ_0_CoreEngine is present, ignore this.
 * 
 *   Background Type:
 *   - Select background type for Auto Battle window.
 *     - 0 - Window
 *     - 1 - Dim
 *     - 2 - Transparent
 * 
 *   JS: X, Y, W, H:
 *   - Code used to determine the dimensions for this window.
 *
 * ---
 *
 * Options
 * 
 *   Add Option?:
 *   - Add the Auto Battle options to the Options menu?
 * 
 *   Adjust Window Height:
 *   - Automatically adjust the options window height?
 * 
 *   Startup Name:
 *   - Command name of the option.
 * 
 *   Style Name:
 *   - Command name of the option.
 * 
 *   OFF:
 *   - Text displayed when Auto Battle Style is OFF.
 * 
 *   ON:
 *   - Text displayed when Auto Battle Style is ON.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Damage Settings
 * ============================================================================
 *
 * These Plugin Parameters add a variety of things to how damage is handled in
 * battle. These range from hard damage caps to soft damage caps to how damage
 * popups appear, how the formulas for various aspects are handled and more.
 *
 * Damage Styles are also a feature added through this plugin. More information
 * can be found in the help section above labeled 'Damage Styles'.
 *
 * ---
 *
 * Damage Styles
 * 
 *   Default Style:
 *   - Which Damage Style do you want to set as default?
 *   - Use 'Manual' to not use any styles at all.
 *     - The 'Manual' style will not support <Armor Penetration> notetags.
 *     - The 'Manual' style will not support <Armor Reduction> notetags.
 * 
 *   Style List:
 *   - A list of the damage styles available.
 *   - These are used to calculate base damage.
 * 
 *     Name:
 *     - Name of this Damage Style.
 *     -Used for notetags and such.
 * 
 *     JS: Formula:
 *     - The base formula for this Damage Style.
 * 
 *     Items & Equips Core:
 * 
 *       HP Damage:
 *       MP Damage:
 *       HP Recovery:
 *       MP Recovery:
 *       HP Drain:
 *       MP Drain:
 *       - Vocabulary used for this data entry.
 * 
 *       JS: Damage Display:
 *       - Code used the data displayed for this category.
 *
 * ---
 *
 * Damage Cap
 * 
 *   Enable Damage Cap?:
 *   - Put a maximum hard damage cap on how far damage can go?
 *   - This can be broken through the usage of notetags.
 * 
 *   Default Hard Cap:
 *   - The default hard damage cap used before applying damage.
 * 
 *   Enable Soft Cap?:
 *   - Soft caps ease in the damage values leading up to the  hard damage cap.
 *   - Requires hard Damage Cap enabled.
 * 
 *     Base Soft Cap Rate:
 *     - The default soft damage cap used before applying damage.
 * 
 *     Soft Scale Constant:
 *     - The default soft damage cap used before applying damage.
 *
 * ---
 *
 * Popups
 * 
 *   Popup Duration:
 *   - Adjusts how many frames a popup stays visible.
 * 
 *   Newest Popups Bottom:
 *   - Puts the newest popups at the bottom.
 * 
 *   End Battle Show?:
 *   - Show or hide popups upon victory or escape?
 *   - Used to hide battle-state removal popups.
 * 
 *   Offset X:
 *   Offset Y:
 *   - Sets how much to offset the sprites by horizontally/vertically.
 * 
 *   Shift X:
 *   Shift Y:
 *   - Sets how much to shift the sprites by horizontally/vertically.
 * 
 *   Shift Y:
 * 
 *   Critical Flash Color:
 *   - Adjust the popup's flash color.
 *   - Format: [red, green, blue, alpha]
 * 
 *   Critical Duration:
 *   - Adjusts how many frames a the flash lasts.
 *
 * ---
 *
 * Formulas
 * 
 *   JS: Overall Formula:
 *   - The overall formula used when calculating damage.
 * 
 *   JS: Variance Formula:
 *   - The formula used when damage variance.
 * 
 *   JS: Guard Formula:
 *   - The formula used when damage is guarded.
 *
 * ---
 *
 * Critical Hits
 * 
 *   JS: Rate Formula:
 *   - The formula used to calculate Critical Hit Rates.
 * 
 *   JS: Damage Formula:
 *   - The formula used to calculate Critical Hit Damage modification.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Mechanics Settings
 * ============================================================================
 *
 * Some of the base settings for the various mechanics found in the battle
 * system can be altered here in these Plugin Parameters. Most of these will
 * involve JavaScript code and require you to have to good understanding of
 * how the RPG Maker MZ code works before tampering with it.
 *
 * ---
 *
 * Action Speed
 * 
 *   Allow Random Speed?:
 *   - Allow speed to be randomized base off the user's AGI?
 * 
 *   Turn End Buffs Expire?:
 *   - Normally, buffs expire after all actions end.
 *   - But here, you can have buffs expire on turn end.
 * 
 *   JS: Calculate:
 *   - Code used to calculate action speed.
 *
 * ---
 *
 * Base Troop
 * 
 *   Base Troop ID's:
 *   - Select the Troop ID(s) to duplicate page events from for all
 *     other troops.
 *   - More information can be found in the dedicated Help section above.
 *
 * ---
 * 
 * Common Events (on Map)
 * 
 *   Pre-Battle Event:
 *   Post-Battle Event:
 *   Victory Event:
 *   Defeat Event:
 *   Escape Success Event:
 *   Escape Fail Event:
 *   - Queued Common Event to run upon meeting the condition.
 *   - Use to 0 to not run any Common Event at all.
 *   - "Post-Battle Event" will always run regardless.
 *   - If any events are running before the battle, they will continue running
 *     to the end first before the queued Common Events will run.
 *   - These common events only run on the map scene. They're not meant to run
 *     in the battle scene.
 *   - If the "Defeat Event" has a common event attached to it, then random
 *     encounters will be changed to allow defeat without being sent to the
 *     Game Over scene. Instead, the game will send the player to the map scene
 *     where the Defeat Event will run.
 *
 * ---
 *
 * Escape
 * 
 *   JS: Calc Escape Ratio:
 *   - Code used to calculate the escape success ratio.
 * 
 *   JS: Calc Escape Raise:
 *   - Code used to calculate how much the escape success ratio raises upon
 *     each failure.
 * 
 * ---
 * 
 * Switches
 * 
 *   Switch: Critical:
 *   - Turns switch ON if the action performs a critical hit.
 *   - Switch reverts to OFF whenever an action starts.
 *   - If multiple targets/hits are struck, as long as one hit lands a critical
 *     hit, then the switch will remain ON for the rest of the action.
 * 
 *   Switch: Miss/Evade:
 *   - Turns switch ON if the action misses/is evaded.
 *   - Switch reverts to OFF whenever an action starts.
 *   - If multiple targets/hits are struck, as long as one hit fails to land,
 *     then the switch will remain ON for the rest of the action.
 * 
 * ---
 * 
 * Variables
 * 
 *   Variable: Damage:
 *   - Variable records target damage during action.
 *   - Variable reverts to 0 whenever an action starts.
 *   - If multiple targets/hits are struck, the variable will record the total
 *     amount of damage done for the remainder of the action (unless manually
 *     reseting to 0 during an Action Sequence).
 * 
 *   Variable: Healing:
 *   - Variable records target healing during action.
 *   - Variable reverts to 0 whenever an action starts.
 *   - If multiple targets/hits are struck, the variable will record the total
 *     amount of healing done for the remainder of the action (unless manually
 *     reseting to 0 during an Action Sequence).
 * 
 * ---
 *
 * JS: Battle-Related
 * 
 *   JS: Pre-Start Battle:
 *   - Target function: BattleManager.startBattle()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Start Battle:
 *   - Target function: BattleManager.startBattle()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Battle Victory:
 *   - Target function: BattleManager.processVictory()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Escape Success:
 *   - Target function: BattleManager.onEscapeSuccess()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Escape Failure:
 *   - Target function: BattleManager.onEscapeFailure()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Battle Defeat:
 *   - Target function: BattleManager.processDefeat()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Pre-End Battle:
 *   - Target function: BattleManager.endBattle()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-End Battle:
 *   - Target function: BattleManager.endBattle()
 *   - JavaScript code occurs after function is run.
 *
 * ---
 *
 * JS: Turn-Related
 * 
 *   JS: Pre-Start Turn:
 *   - Target function: BattleManager.startTurn()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Start Turn:
 *   - Target function: BattleManager.startTurn()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Pre-End Turn:
 *   - Target function: Game_Battler.prototype.onTurnEnd()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-End Turn:
 *   - Target function: Game_Battler.prototype.onTurnEnd()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Pre-Regenerate:
 *   - Target function: Game_Battler.prototype.regenerateAll()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Regenerate:
 *   - Target function: Game_Battler.prototype.regenerateAll()
 *   - JavaScript code occurs after function is run.
 *
 * ---
 *
 * JS: Action-Related
 * 
 *   JS: Pre-Start Action:
 *   - Target function: BattleManager.startAction()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Start Action:
 *   - Target function: BattleManager.startAction()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Pre-Apply:
 *   - Target function: Game_Action.prototype.apply()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Pre-Damage:
 *   - Target function: Game_Action.prototype.executeDamage()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Damage:
 *   - Target function: Game_Action.prototype.executeDamage()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Post-Apply:
 *   - Target function: Game_Action.prototype.apply()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Pre-End Action:
 *   - Target function: BattleManager.endAction()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-End Action:
 *   - DescriTarget function: BattleManager.endAction()
 *   - JavaScript code occurs after function is run.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Battle Layout Settings
 * ============================================================================
 *
 * The Battle Layout Settings Plugin Parameter gives you control over the look,
 * style, and appearance of certain UI elements. These range from the way the
 * Battle Status Window presents its information to the way certain windows
 * like the Party Command Window and Actor Command Window appear.
 *
 * ---
 *
 * Battle Layout Style
 * - The style used for the battle layout.
 * 
 *   Default:
 *   - Shows actor faces in Battle Status.
 * 
 *   List:
 *   - Lists actors in Battle Status.
 * 
 *   XP:
 *   - Shows actor battlers in a stretched Battle Status.
 * 
 *   Portrait:
 *   - Shows portraits in a stretched Battle Status.
 * 
 *   Border:
 *   - Displays windows around the screen border.
 *
 * ---
 *
 * List Style
 * 
 *   Show Faces:
 *   - Shows faces in List Style?
 * 
 *   Command Window Width:
 *   - Determine the window width for the Party and Actor Command Windows.
 *   - Affects Default and List Battle Layout styles.
 *
 * ---
 *
 * XP Style
 * 
 *   Command Lines:
 *   - Number of action lines in the Actor Command Window for the XP Style.
 * 
 *   Sprite Height:
 *   - Default sprite height used when if the sprite's height has not been
 *     determined yet.
 * 
 *   Sprite Base Location:
 *   - Determine where the sprite is located on the Battle Status Window.
 *     - Above Name - Sprite is located above the name.
 *     - Bottom - Sprite is located at the bottom of the window.
 *     - Centered - Sprite is centered in the window.
 *     - Top - Sprite is located at the top of the window.
 *
 * ---
 *
 * Portrait Style
 * 
 *   Show Portraits?:
 *   - Requires VisuMZ_1_MainMenuCore.
 *   - Shows the actor's portrait instead of a face.
 * 
 *   Portrait Scaling:
 *   - If portraits are used, scale them by this much.
 *
 * ---
 *
 * Border Style
 * 
 *   Columns:
 *   - The total number of columns for Skill & Item Windows in the battle scene
 * 
 *   Show Portraits?:
 *   - Requires VisuMZ_1_MainMenuCore.
 *   - Shows the actor's portrait at the edge of the screen.
 * 
 *   Portrait Scaling:
 *   - If portraits are used, scale them by this much.
 *
 * ---
 *
 * Skill & Item Windows
 * 
 *   Middle Layout:
 *   - Shows the Skill & Item Windows in mid-screen?
 * 
 *   Columns:
 *   - The total number of columns for Skill & Item Windows in the battle scene
 *
 * ---
 * 
 * Status Window Elements
 * 
 *   Battler Name:
 *   Gauge 1 (HP):
 *   Gauge 2 (MP):
 *   Gauge 3 (TP):
 *   State Icon:
 *   TPB/ATB Gauge:
 * 
 *     Offset: X/Y:
 *     - Offset this Battle Status Window element's X/Y.
 *     - For X: Negative goes left. Positive goes right.
 *     - For Y: Negative goes up. Positive goes down.
 * 
 *   Window Skin:
 * 
 *     Filename:
 *     - Filename used for the Battle Status Window skin.
 *     - Leave this empty to use the default window skin.
 * 
 *     Hide Window Skin?:
 *     - Hide the window skin for the Battle Status Window?
 * 
 *   Selectable Background:
 * 
 *     Hide Selectable BG?:
 *     - Show/Hide the selectable background box for the Battle Status Window?
 * 
 *   Attachments:
 * 
 *     Back Attachment:
 * 
 *       Filename:
 *       - Filename used for an image to attach to the back of the Battle
 *         Status Window. Leave empty for none.
 * 
 *       Offset: X/Y:
 *       - Offset this Battle Status Window element's X/Y.
 *       - For X: Negative goes left. Positive goes right.
 *       - For Y: Negative goes up. Positive goes down.
 * 
 *     Front Attachment:
 * 
 *       Filename:
 *       - Filename used for an image to attach to the front of the Battle
 *         Status Window. Leave empty for none.
 * 
 * ---
 * 
 * UI Elements
 * 
 *   Anti-Tint UI?
 *   - Prevent UI Elements from being tinted?
 *   - This prevents UI Elements such as HP Gauges, Enemy Names, Battle Cursor,
 *     and Weakness Display from being affected by screen tint.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Battle Log Settings
 * ============================================================================
 *
 * These Plugin Parameters give you control over how the Battle Log Window, the
 * window shown at the top of the screen in the battle layout, appears, its
 * various properties, and which text will be displayed.
 *
 * The majority of the text has been disabled by default with this plugin to
 * make the flow of battle progress faster.
 *
 * ---
 *
 * General
 * 
 *   Back Color:
 *   - Use #rrggbb for a hex color.
 * 
 *   Max Lines:
 *   - Maximum number of lines to be displayed.
 * 
 *   Message Wait:
 *   - Number of frames for a usual message wait.
 * 
 *   Text Align:
 *   - Text alignment for the Window_BattleLog.
 * 
 *   JS: X, Y, W, H:
 *   - Code used to determine the dimensions for the battle log.
 *
 * ---
 *
 * Start Turn
 * 
 *   Show Start Turn?:
 *   - Display turn changes at the start of the turn?
 * 
 *   Start Turn Message:
 *   - Message displayed at turn start.
 *   - %1 - Turn Count
 * 
 *   Start Turn Wait:
 *   - Number of frames to wait after a turn started.
 *
 * ---
 *
 * Display Action
 * 
 *   Show Centered Action?:
 *   - Display a centered text of the action name?
 * 
 *   Show Skill Message 1?:
 *   - Display the 1st skill message?
 * 
 *   Show Skill Message 2?:
 *   - Display the 2nd skill message?
 * 
 *   Show Item Message?:
 *   - Display the item use message?
 *
 * ---
 *
 * Action Changes
 * 
 *   Show Counter?:
 *   - Display counter text?
 * 
 *     Wait Frames:
 *     - How many frames should the battle log wait after text?
 *     - 60 frames = 1 second.
 * 
 *   Show Reflect?:
 *   - Display magic reflection text?
 * 
 *     Wait Frames:
 *     - How many frames should the battle log wait after text?
 *     - 60 frames = 1 second.
 * 
 *   Show Substitute?:
 *   - Display substitute text?
 * 
 *     Wait Frames:
 *     - How many frames should the battle log wait after text?
 *     - 60 frames = 1 second.
 *
 * ---
 *
 * Action Results
 * 
 *   Show No Effect?:
 *   - Display no effect text?
 * 
 *   Show Critical?:
 *   - Display critical text?
 * 
 *   Show Miss/Evasion?:
 *   - Display miss/evasion text?
 * 
 *   Show HP Damage?:
 *   - Display HP Damage text?
 * 
 *   Show MP Damage?:
 *   - Display MP Damage text?
 * 
 *   Show TP Damage?:
 *   - Display TP Damage text?
 *
 * ---
 *
 * Display States
 * 
 *   Show Added States?:
 *   - Display added states text?
 * 
 *   Show Removed States?:
 *   - Display removed states text?
 * 
 *   Show Current States?:
 *   - Display the currently affected state text?
 * 
 *   Show Added Buffs?:
 *   - Display added buffs text?
 * 
 *   Show Added Debuffs?:
 *   - Display added debuffs text?
 * 
 *   Show Removed Buffs?:
 *   - Display removed de/buffs text?
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Battleback Scaling Settings
 * ============================================================================
 *
 * By default, the battlebacks in RPG Maker MZ scale as if the screen size is
 * a static 816x624 resolution, which isn't always the case. These settings
 * here allow you to dictate how you want the battlebacks to scale for the
 * whole game. These settings CANNOT be changed midgame or per battle.
 *
 * ---
 *
 * Settings
 * 
 *   Default Style:
 *   - The default scaling style used for battlebacks.
 *   - MZ (MZ's default style)
 *   - 1:1 (No Scaling)
 *   - Scale To Fit (Scale to screen size)
 *   - Scale Down (Scale Downward if Larger than Screen)
 *   - Scale Up (Scale Upward if Smaller than Screen)
 * 
 *   JS: 1:1:
 *   JS: Scale To Fit:
 *   JS: Scale Down:
 *   JS: Scale Up:
 *   - This code gives you control over the scaling for this style.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Party Command Window
 * ============================================================================
 *
 * These Plugin Parameters allow you control over how the Party Command Window
 * operates in the battle scene. You can turn disable it from appearing or make
 * it so that it doesn't 
 *
 * ---
 *
 * Command Window
 * 
 *   Style:
 *   - How do you wish to draw commands in the Party Command Window?
 *   - Text Only: Display only the text.
 *   - Icon Only: Display only the icon.
 *   - Icon + Text: Display the icon first, then the text.
 *   - Auto: Determine which is better to use based on the size of the cell.
 * 
 *   Text Align:
 *   - Text alignment for the Party Command Window.
 * 
 *   Fight Icon:
 *   - The icon used for the Fight command.
 * 
 *   Add Auto Battle?:
 *   - Add the "Auto Battle" command to the Command Window?
 * 
 *     Auto Battle Icon:
 *     - The icon used for the Auto Battle command.
 * 
 *     Auto Battle Text:
 *     - The text used for the Auto Battle command.
 * 
 *   Add Status?:
 *   - Add the "Status" command to the Command Window?
 * 
 *   Add Options?:
 *   - Add the "Options" command to the Command Window?
 * 
 *     Options Icon:
 *     - The icon used for the Options command.
 * 
 *     Active TPB Message:
 *     - Message that will be displayed when selecting options during the
 *       middle of an action.
 * 
 *   Escape Icon:
 *   - The icon used for the Escape command.
 *
 * ---
 *
 * Access
 * 
 *   Skip Party Command:
 *   - DTB: Skip Party Command selection on turn start.
 *   - TPB: Skip Party Command selection at battle start.
 * 
 *   Disable Party Command:
 *   - Disable the Party Command Window entirely?
 *
 * ---
 *
 * Help Window
 * 
 * The Help Window will only appear for 'Border' and 'Frontview Battle UI'
 * battle layouts. It does not appear for other battle layouts.
 * 
 *   Fight:
 *   - Text displayed when selecting a skill type.
 *   - %1 - Skill Type Name
 * 
 *   Auto Battle:
 *   - Text displayed when selecting the Auto Battle command.
 * 
 *   Options:
 *   - Text displayed when selecting the Options command.
 * 
 *   Escape:
 *   - Text displayed when selecting the escape command.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Actor Command Window
 * ============================================================================
 *
 * These Plugin Parameters allow you to change various aspects regarding the
 * Actor Command Window and how it operates in the battle scene. This ranges
 * from how it appears to the default battle commands given to all players
 * without a custom <Battle Commands> notetag.
 *
 * ---
 *
 * Command Window
 * 
 *   Style:
 *   - How do you wish to draw commands in the Actor Command Window?
 *   - Text Only: Display only the text.
 *   - Icon Only: Display only the icon.
 *   - Icon + Text: Display the icon first, then the text.
 *   - Auto: Determine which is better to use based on the size of the cell.
 * 
 *   Text Align:
 *   - Text alignment for the Actor Command Window.
 * 
 *   Item Icon:
 *   - The icon used for the Item command.
 * 
 *   Normal SType Icon:
 *   - Icon used for normal skill types that aren't assigned any icons.
 *   - Ignore if VisuMZ_1_SkillsStatesCore is installed.
 * 
 *   Magic SType Icon:
 *   - Icon used for magic skill types that aren't assigned any icons.
 *   - Ignore if VisuMZ_1_SkillsStatesCore is installed.
 *
 * ---
 *
 * Battle Commands
 * 
 *   Command List:
 *   - List of battle commands that appear by default if the <Battle Commands>
 *     notetag isn't present.
 *
 *     - Attack 
 *       - Adds the basic attack command.
 * 
 *     - Skills
 *       - Displays all the skill types available to the actor.
 * 
 *     - SType: x
 *     - Stype: name
 *       - Adds in a specific skill type.
 *       - Replace 'x' with the ID of the skill type.
 *       - Replace 'name' with the name of the skill type (without text codes).
 *
 *     - All Skills
 *       - Adds all usable battle skills as individual actions.
 * 
 *     - Skill: x
 *     - Skill: name
 *       - Adds in a specific skill as a usable action.
 *       - Replace 'x' with the ID of the skill.
 *       - Replace 'name' with the name of the skill.
 * 
 *     - Guard
 *       - Adds the basic guard command.
 * 
 *     - Item
 *       - Adds the basic item command.
 * 
 *     - Status
 *       - Adds the status command.
 * 
 *     - Escape
 *       - Adds the escape command.
 * 
 *     - Auto Battle
 *       - Adds the auto battle command.
 * 
 *     - Party
 *       - Requires VisuMZ_2_PartySystem!
 *       - Switches out the current actor for another.
 * 
 *     - Combat Log
 *       - Requires VisuMZ_4_CombatLog!
 *       - Shows combat log.
 * 
 *     - Talk
 *       - Requires VisuMZ_3_BattleCmdTalk!
 *       - Shows talk command if applicable.
 * 
 *     - Weapon Swap
 *       - Requires VisuMZ_2_WeaponSwapSystem!
 *       - Swaps current weapon for next one.
 * 
 *   Show Command Costs:
 *   - If a battle command has a resource cost, show it?
 *
 * ---
 *
 * Help Window
 * 
 * The Help Window will only appear for 'Border' and 'Frontview Battle UI'
 * battle layouts. It does not appear for other battle layouts.
 * 
 *   Skill Types:
 *   - Text displayed when selecting a skill type.
 *   - %1 - Skill Type Name
 * 
 *   Items:
 *   - Text displayed when selecting the item command.
 * 
 *   Escape:
 *   - Text displayed when selecting the escape command.
 * 
 *   Auto Battle:
 *   - Text displayed when selecting the Auto Battle command.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: In-Battle Status Window
 * ============================================================================
 *
 * Added with Battle Core version 1.84, this new window allows the player to
 * view the status of the current active party. If the actors have states and
 * buffs, the player can scroll through them and read about their effects
 * through the help window.
 * 
 * If you would like to manage which parameters can appear here, this can be
 * done through the VisuMZ_0_CoreEngine's "Parameter Settings" and adjust which
 * parameters are shown through "Extended Parameters". These settings will
 * reflect in the In-Battle Status window, too. Otherwise, the parameters that
 * will be shown will only be MaxHP, MaxMP, ATK, DEF, MAT, MDF, AGI, and LUK.
 * 
 * The In-Battle Status can also be used to view enemies (if the parameter is
 * enabled). To view enemies, players must scroll through all the actors before
 * viewing enemies. Enemies will have their battler graphic displayed. If the
 * enemy has a SV Battler graphic, that will be displayed instead. However, if
 * the enemy has a Dragonbones, then the database battler graphic is displayed
 * to match any of the turn order displays as those also use the same graphic.
 * 
 * Enemies will not display the current HP on their In-Battle Status gauges.
 * Instead, they will display what percentage their HP, MP, and/or TP is at.
 * This is primarily due to how gauges do not support large numbers well and
 * showing the percentage values are better for this scene.
 *
 * ---
 * 
 * General Settings
 * 
 *   Status Icon:
 *   - The icon used for the Status command.
 * 
 *   Status Graphic:
 *   - Choose how the actor graphic appears for In-Battle Status.
 * 
 *   Help Description:
 *   - Text displayed when selecting the Status command.
 * 
 * ---
 * 
 * Enemy Settings
 * 
 *   Allow View Enemies?:
 *   - Allows players to view enemy stats (even if limited)?
 * 
 *   Show Level?:
 *   - Shows the enemy's level in the In-Battle Status?
 * 
 *   Hidden Parameter:
 *   - The text that appears if a parameter value is hidden.
 * 
 *     Show Params Always:
 *     - Always show exact enemy parameter values.
 * 
 *     Show Battle Test:
 *     - Show exact enemy parameter values in battle test.
 * 
 *     Show If Defeated:
 *     - Show exact enemy parameter values if enemy has been defeated before.
 * 
 * ---
 * 
 * Page Buttons:
 * 
 *   Show Page Buttons?:
 *   - Shows page buttons to switch between actors?
 *   - Still requires Touch UI option to be on.
 * 
 *   Large UI Position?:
 *   - If using a large resolution, position the page buttons on which side?
 * 
 *  Offset X
 *  - Offsets the page buttons x position.
 *  - Negative: left. Positive: right.
 * 
 *  Offset Y
 *  - Offsets the page buttons y position.
 *  - Negative: up. Positive: down.
 * 
 * ---
 * 
 * Parameter Display
 * 
 *   Increased Value
 *   - How are increased parameter values displayed?
 *   - %1 - Parameter Value
 * 
 *   Decreased Value
 *   - How are increased parameter values displayed?
 *   - %1 - Parameter Value
 * 
 * ---
 * 
 * States Display
 * 
 *   Max Width
 *   - Maximum width of the states list display.
 * 
 *   List States?
 *   - Lists states in the states list display?
 * 
 *   List Buffs?
 *   - Lists buffs in the states list display?
 * 
 *   List Debuffs?
 *   - Lists debuffs in the states list display?
 * 
 *   Buffs/Debuffs Display:
 * 
 *     Buff Name Format
 *     - Text format used to represent buffs.
 *     - %1 - Parameter Name
 * 
 *     Debuff Name Format
 *     - Text format used to represent debuffs.
 *     - %1 - Parameter Name
 * 
 *   Normal State:
 * 
 *     Normal Icon
 *     - Icon used to represent normal state (unaffected by states, buffs, or
 *       debuffs).
 * 
 *     Normal Text
 *     - Text used to represent normal state (unaffected by states, buffs, or
 *       debuffs).
 * 
 * ---
 * 
 * Help Descriptions
 * 
 *   State Help Format:
 *   - Text format used for state help descriptions
 *   - %1 - Description; %2 - Turns/Actions Remaining
 * 
 *   Buff Help Format:
 *   - Text format used for Buff help descriptions
 *   - %1 - Param; %2 - Percent; %3 - Color; %4 - Turns
 * 
 *   Debuff Help Format:
 *   - Text format used for Debuff help descriptions
 *   - %1 - Param; %2 - Percent; %3 - Color; %4 - Turns
 * 
 *   Normal State:
 *   - Help description used to explain normal state (unaffected by states,
 *     buffs, or debuffs).
 * 
 *   Turns/Actions Left:
 * 
 *     Actions Format:
 *     - Text format used to represent actions remaining.
 *     - %1 - Actions; %2 - Color
 * 
 *     Turns Format:
 *     - Text format used to represent turns remaining.
 *     - %1 - Turns; %2 - Color
 * 
 *     Passive Text:
 *     - Text used to represent a passive.
 * 
 * ---
 * 
 * Window Settings
 * 
 *   Background Type:
 *   - Select background type for this window.
 * 
 *   JS: Draw Data:
 *   - Code used to draw battler data.
 * 
 *   JS: X, Y, W, H:
 *   - Code used to determine the dimensions for this window.
 * 
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Multi-Target Windows Settings
 * ============================================================================
 *
 * Action Sequence Plugin Parameters adjust how the Multi-Target Windows appear
 * in battle. These windows are visible when selecting an enemy or actor while
 * using a skill/item that has the <Single or Multiple Select> notetag.
 * 
 * Those wondering why this isn't regulated to a command left or right of the
 * enemies and actors is because mouse controls and touch controls would not be
 * able to select all enemies or all allies that way.
 *
 * ---
 * 
 * Properties
 * 
 *   Window Width:
 *   - What is the width used for the Multi-Target Window?
 * 
 *   Background Type:
 *   - Select background type for these windows.
 * 
 *   Show Button:
 *   - Shows the keyboard/controller button to press?
 *   - Requires VisuMZ_0_CoreEngine!
 * 
 * ---
 * 
 * Vocab
 * 
 *   All Actors:
 *   - What is the text used for the "All Actors" button?
 * 
 *   All Enemies:
 *   - What is the text used for the "All Enemies" button?
 * 
 * ---
 * 
 * Offsets > Actor Offsets
 * Offsets > Enemy Offsets
 * 
 *   Offset X:
 *   - Offsets the button's x position.
 *   - Negative: left. Positive: right.
 * 
 *   Offset Y:
 *   - Offsets the button's y position.
 *   - Negative: up. Positive: down.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Damage Combo Window Settings
 * ============================================================================
 * 
 * If enabled, this window will display updated information about the total
 * amount of hits performed and total damage/healing value executed for HP.
 * 
 * This only applies when HP damage is directly dealt through action effects.
 * It does NOT apply for MP damage, TP damage, states, regeneration, or event
 * commands.
 * 
 * If you would like to adjust the Damage Combo Window mid-action, you can use
 * the following script calls to do so:
 * 
 *     $comboWindowReset()
 *     - Resets the all values found in the damage combo window.
 * 
 *     $comboWindowIncreaseHits(x)
 *     - Increases the current hit counter in the combo window by 'x'.
 *     - Insert a number for 'x'.
 *     - Example: $comboWindowIncreaseHits(2)
 * 
 *     $comboWindowIncreaseDamage(x)
 *     - Increases the current total damage counter in the combo window by 'x'.
 *     - Insert a number for 'x'.
 *     - This will offset any healing added in the damage counter window.
 *     - Example: $comboWindowIncreaseDamage(100)
 * 
 *     $comboWindowIncreaseHealing(x)
 *     - Increases the current total heal counter in the combo window by 'x'.
 *     - Insert a number for 'x'.
 *     - This will offset any damage added in the damage counter window.
 *     - Example: $comboWindowIncreaseHealing(200)
 * 
 * ---
 * 
 * General Settings:
 * 
 *   Enable?:
 *   - Add the Combo Window to show in battle?
 * 
 * ---
 * 
 * Appearance Settings:
 * 
 *   Custom Font:
 *   - Insert the custom font face name here.
 *   - Use VisuMZ_1_MessageCore to register new fonts.
 * 
 *   Text Align:
 *   - Text alignment for this window?
 * 
 *   JS: Draw Data:
 *   - Code used to draw the data in this window.
 * 
 * ---
 * 
 * Vocabulary:
 * 
 *   Damage Combo Format:
 *   - Text format used to display total hits for damage.
 *   - %1 - Total Hits
 * 
 *   Healing Combo Format:
 *   - Text format used to display total hits for healing.
 *   - %1 - Total Hits
 * 
 *   Damage Total Format:
 *   - Text format used to display total value for damage.
 *   - %1 - Total Damage
 * 
 *   Healing Total Format:
 *   - Text format used to display total value for healing.
 *   - %1 - Total Healing
 * 
 * ---
 * 
 * Position Settings:
 * 
 *   Fade Shift X:
 *   - Shifts the windows x position when fading.
 *   - Negative: left. Positive: right.
 * 
 *   Fade Shift Y:
 *   - Shifts the windows y position when fading.
 *   - Negative: up. Positive: down.
 * 
 *   Offset X:
 *   - Offsets the windows x position.
 *   - Negative: left. Positive: right.
 * 
 *   Offset Y:
 *   - Offsets the windows y position.
 *   - Negative: up. Positive: down.
 * 
 *   JS: X, Y, W, H:
 *   - Code used to determine the dimensions for this window.
 * 
 * ---
 * 
 * Updating Settings:
 * 
 *   Number Roll Duration:
 *   - Frame duration to roll damage numbers.
 *   - 60 frames = 1 second.
 * 
 *   Minimum Stay Duration:
 *   - Frame duration to stay visible minimum. 
 *   - 60 frames = 1 second.
 * 
 *   Minimum Hit Visible:
 *   - Minimum hits before combo window becomes visible?
 * 
 *   Opacity Speed:
 *   - Opacity speed when fading in/out.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Actor Battler Settings
 * ============================================================================
 *
 * These Plugin Parameter settings adjust how the sideview battlers behave for
 * the actor sprites. Some of these settings are shared with enemies if they
 * use sideview battler graphics.
 *
 * ---
 *
 * Flinch
 * 
 *   Flinch Distance X:
 *   - The normal X distance when flinching.
 * 
 *   Flinch Distance Y:
 *   - The normal Y distance when flinching.
 * 
 *   Flinch Duration:
 *   - The number of frames for a flinch to complete.
 * 
 *   Shake Flinch:
 *   - Perform a shake flinch when taking damage?
 * 
 *     Max Duration:
 *     - Maximum duration a shake flinch can have.
 *     - This is reduced relative to the amount of damage taken.
 * 
 *     Max Power:
 *     - The power rating of a shake flinch at full damage.
 *     - This is reduced relative to the amount of damage taken.
 *
 * ---
 * 
 * Frontview Battlers
 * 
 *   Portrait Animations:
 * 
 *     Each Target:
 *     - Place animations on top for "Each Target" display types?
 *     - Does not apply to MV animations.
 * 
 *     Center of All:
 *     - Place animations on top for "Center of All" display types?
 *     - Does not apply to MV animations.
 * 
 *     Center of Screen:
 *     - Place animations on top for "Center of Screen" display types?
 *     - Does not apply to MV animations.
 * 
 * ---
 *
 * Sideview Battlers
 * 
 *   Anchor:
 * 
 *     Anchor: X:
 *     - Default X anchor for Sideview Battlers.
 * 
 *     Anchor: Y:
 *     - Default Y anchor for Sideview Battlers.
 * 
 *   Chant Style:
 *   - What determines the chant motion?
 *   - Hit type or skill type?
 * 
 *   Motion Speed:
 *   - The number of frames in between each motion.
 * 
 *   Position:
 * 
 *     Offset X:
 *     - Offsets X position where actor is positioned.
 *     - Negative values go left. Positive values go right.
 * 
 *     Offset Y:
 *     - Offsets Y position where actor is positioned.
 *     - Negative values go up. Positive values go down.
 * 
 *   Priority: Active:
 *   - Place the active actor on top of actor and enemy sprites.
 * 
 *   Priority: Actors:
 *   - Prioritize actors over enemies when placing sprites on top of each other
 * 
 *   Shadow Visible:
 *   - Show or hide the shadow for Sideview Battlers.
 * 
 *   Smooth Image:
 *   - Smooth out the battler images or pixelate them?
 * 
 *   State Overlay:
 * 
 *     Offset X:
 *     - Offsets X position for state overlay on actor.
 *     - Negative values go left. Positive values go right.
 * 
 *     Offset Y:
 *     - Offsets Y position for state overlay on actor.
 *     - Negative values go up. Positive values go down.
 * 
 *   JS: Home Position:
 *   - Code used to calculate the home position of actors.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Enemy Battler Settings
 * ============================================================================
 *
 * These Plugin Parameter settings adjust how enemies appear visually in the
 * battle scene. Some of these settings will override the settings used for
 * actors if used as sideview battlers. Other settings include changing up the
 * default attack animation for enemies, how the enemy select window functions,
 * and more.
 *
 * ---
 *
 * Visual
 * 
 *   Attack Animation:
 *   - Default attack animation used for enemies.
 *   - Use <Attack Animation: x> for custom animations.
 * 
 *   Emerge Text:
 *   - Show or hide the 'Enemy emerges!' text at the start of battle.
 * 
 *   Offset X:
 *   - Offsets X position where enemy is positioned.
 *   - Negative values go left. Positive values go right.
 * 
 *   Offset Y:
 *   - Offsets Y position where enemy is positioned.
 *   - Negative values go up. Positive values go down.
 * 
 *   Smooth Image:
 *   - Smooth out the battler images or pixelate them?
 *
 * ---
 *
 * Select Window
 * 
 *   Any: Last Selected:
 *   - Prioritize last selected enemy over front view or sideview settings?
 * 
 *   FV: Right Priority:
 *   - If using frontview, auto select the enemy furthest right.
 * 
 *   SV: Right Priority:
 *   - If using sideview, auto select the enemy furthest right.
 * 
 * ---
 * 
 * Name:
 * 
 *   Legacy Option:
 *   - Use the legacy version (window) or new version (sprite).
 *   - WARNING: Legacy version is no longer supported for bugs.
 *   - Not all settings available here in the Plugin Parameters will be
 *     available to the legacy version (ie Always Visible and Attach States).
 * 
 *   Font Size:
 *   - Font size used for enemy names.
 * 
 *   Name Position:
 * 
 *     Offset X:
 *     Offset Y:
 *     - Offset the enemy name's position by this much.
 *     - For X: Negative goes left. Positive goes right.
 *     - For Y: Negative goes up. Positive goes down.
 * 
 *   Name: Attach States:
 *   - Attach the enemy's state icon to the enemy name?
 * 
 *     Attach: Offset X:
 *     Attach: Offset Y:
 *     - How much to offset the attached icon's X/Y position by?
 *     - For X: Negative goes left. Positive goes right.
 *     - For Y: Negative goes up. Positive goes down.
 * 
 *   Name Visibility:
 * 
 *     Always Hidden:
 *     - Determines if the enemy name will always be visible.
 *     - Highest priority.
 * 
 *     Always Visible:
 *     - Determines if the enemy name will always be visible.
 *     - Medium priority.
 * 
 *     As Target:
 *     - Shows enemy name when enemy is a target.
 *     - Medium priority.
 * 
 *     By Selection?:
 *     - Determines the conditions for enemy name visibility.
 *     - Lowest priority.
 * 
 *     Temporary Visibility:
 *     - Number of frames enemy's name temporarily visible after taking an
 *       action effect in battle.
 *     - 60 frames = 1 second.
 *
 * ---
 *
 * Sideview Battlers
 * 
 *   Allow Collapse:
 *   - Causes defeated enemies with SV Battler graphics to "fade away"
 *     when defeated?
 * 
 *   Anchor: X:
 *   - Default X anchor for Sideview Battlers.
 *   - Use values between 0 and 1 to be safe.
 * 
 *   Anchor: Y:
 *   - Default Y anchor for Sideview Battlers.
 *   - Use values between 0 and 1 to be safe.
 * 
 *   Motion: Idle:
 *   - Sets default idle animation used by Sideview Battlers.
 * 
 *   Shadow Visible:
 *   - Show or hide the shadow for Sideview Battlers.
 * 
 *   Size: Width:
 *   - Default width for enemies that use Sideview Battlers.
 * 
 *   Size: Height:
 *   - Default height for enemies that use Sideview Battlers.
 * 
 *   Weapon Type:
 *   - Sets default weapon type used by Sideview Battlers.
 *   - Use 0 for Bare Hands.
 *
 * ---
 * 
 * Aspect Defaults
 * 
 *   Name Format:
 *   - Default name aspect format.
 *   - %1 - Original Enemy Name
 * 
 *   Name Color:
 *   - Use #rrggbb for custom colors or regular numbers for text colors from
 *     the Window Skin.
 * 
 *   Icon:
 *   - Default icon used for aspect.
 *   - Use <Aspect Icon: x> to change icon.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: HP Gauge Settings
 * ============================================================================
 *
 * Settings that adjust the visual HP Gauge displayed in battle.
 *
 * ---
 *
 * Show Gauges For
 * 
 *   Actors:
 *   - Show HP Gauges over the actor sprites' heads?
 *   - Requires SV Actors to be visible.
 * 
 *   Enemies:
 *   - Show HP Gauges over the enemy sprites' heads?
 *   - Can be bypassed with <Hide HP Gauge> notetag.
 * 
 *     Requires Defeat?:
 *     - Requires defeating the enemy once to show HP Gauge?
 *     - Can be bypassed with <Show HP Gauge> notetag.
 * 
 *       Battle Test Bypass?:
 *       - Bypass the defeat requirement in battle test?
 *
 * ---
 *
 * Settings
 * 
 *   Animation Duration:
 *   - How many frames should gauges animate themselves?
 *   - Default: 20 frames.
 * 
 *   Anchor X:
 *   Anchor Y:
 *   - Where do you want the HP Gauge sprite's anchor X/Y to be?
 *     Use values between 0 and 1 to be safe.
 * 
 *   Scale:
 *   - How large/small do you want the HP Gauge to be scaled?
 * 
 *   Offset X:
 *   Offset Y:
 *   - How many pixels to offset the HP Gauge's X/Y by?
 *
 * ---
 *
 * Options
 * 
 *   Add Option?:
 *   - Add the 'Show HP Gauge' option to the Options menu?
 * 
 *   Adjust Window Height:
 *   - Automatically adjust the options window height?
 * 
 *   Option Name:
 *   - Command name of the option.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Action Sequence Settings
 * ============================================================================
 *
 * Action Sequence Plugin Parameters allow you to decide if you want automatic
 * Action Sequences to be used for physical attacks, the default casting
 * animations used, how counters and reflects appear visually, and what the
 * default stepping distances are.
 *
 * ---
 *
 * Automatic Sequences
 * 
 *   Melee Single Target:
 *   - Allow this auto sequence for physical, single target actions?
 * 
 *   Melee Multi Target:
 *   - Allow this auto sequence for physical, multi-target actions?
 *
 * ---
 * 
 * Quality of Life
 * 
 *   Auto Notetag:
 *   - Automatically apply the <Custom Action Sequence> notetag effect to any
 *     item or skill that has a Common Event?
 *   - Any item or skill without a Common Event attached to it will use the
 *     Automatic Action Sequences instead.
 *   - The <Auto Action Sequence> notetag will disable this effect for that
 *     particular skill or item.
 * 
 * ---
 *
 * Cast Animations
 * 
 *   Certain Hit:
 *   - Cast animation for Certain Hit skills.
 * 
 *   Physical:
 *   - Cast animation for Physical skills.
 * 
 *   Magical:
 *   - Cast animation for Magical skills.
 *
 * ---
 *
 * Counter/Reflect
 * 
 *   Counter Back:
 *   - Play back the attack animation used?
 * 
 *   Reflect Animation:
 *   - Animation played when an action is reflected.
 * 
 *   Reflect Back:
 *   - Play back the attack animation used?
 *
 * ---
 *
 * Stepping
 * 
 *   Melee Distance:
 *   - Minimum distance in pixels for Movement Action Sequences.
 * 
 *   Step Distance X:
 *   - The normal X distance when stepping forward.
 * 
 *   Step Distance Y:
 *   - The normal Y distance when stepping forward.
 * 
 *   Step Duration:
 *   - The number of frames for a stepping action to complete.
 *
 * ---
 *
 * ============================================================================
 * Terms of Use
 * ============================================================================
 *
 * 1. These plugins may be used in free or commercial games provided that they
 * have been acquired through legitimate means at VisuStella.com and/or any
 * other official approved VisuStella sources. Exceptions and special
 * circumstances that may prohibit usage will be listed on VisuStella.com.
 * 
 * 2. All of the listed coders found in the Credits section of this plugin must
 * be given credit in your games or credited as a collective under the name:
 * "VisuStella".
 * 
 * 3. You may edit the source code to suit your needs, so long as you do not
 * claim the source code belongs to you. VisuStella also does not take
 * responsibility for the plugin if any changes have been made to the plugin's
 * code, nor does VisuStella take responsibility for user-provided custom code
 * used for custom control effects including advanced JavaScript notetags
 * and/or plugin parameters that allow custom JavaScript code.
 * 
 * 4. You may NOT redistribute these plugins nor take code from this plugin to
 * use as your own. These plugins and their code are only to be downloaded from
 * VisuStella.com and other official/approved VisuStella sources. A list of
 * official/approved sources can also be found on VisuStella.com.
 *
 * 5. VisuStella is not responsible for problems found in your game due to
 * unintended usage, incompatibility problems with plugins outside of the
 * VisuStella MZ library, plugin versions that aren't up to date, nor
 * responsible for the proper working of compatibility patches made by any
 * third parties. VisuStella is not responsible for errors caused by any
 * user-provided custom code used for custom control effects including advanced
 * JavaScript notetags and/or plugin parameters that allow JavaScript code.
 *
 * 6. If a compatibility patch needs to be made through a third party that is
 * unaffiliated with VisuStella that involves using code from the VisuStella MZ
 * library, contact must be made with a member from VisuStella and have it
 * approved. The patch would be placed on VisuStella.com as a free download
 * to the public. Such patches cannot be sold for monetary gain, including
 * commissions, crowdfunding, and/or donations.
 *
 * ============================================================================
 * Credits
 * ============================================================================
 * 
 * If you are using this plugin, credit the following people in your game:
 * 
 * Team VisuStella
 * * Yanfly
 * * Arisu
 * * Olivia
 * * Irina
 *
 * ============================================================================
 * Changelog
 * ============================================================================
 * 
 * Version 1.86: January 16, 2025
 * * Bug Fixes!
 * ** Fixed a bug where during Active TPB, actors were not showing damage
 *    motions. Fix made by Olivia.
 * ** Fixed a bug regarding the in-battle status requiring that the Main Menu
 *    Core to be installed when other plugins are also present. Fix by Olivia.
 * ** Fixed a bug where <Exclude From Status Listing> notetag was not working
 *    properly due to a documentation typo of <Exclude From Status List>. Both
 *    notetags should now work. Fix made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Added clarity for Plugin Parameters > Party Command Window Settings >
 *    Help Window
 * ** Added clarity for Plugin Parameters > Actor Command Window Settings >
 *    Help Window
 * *** The Help Window will only appear for 'Border' and 'Frontview Battle UI'
 *     battle layouts.
 * * New Features!
 * ** New notetag added by Irina:
 * *** <Under>
 * **** If this tag is found in an animation's name, the animation will appear
 *      under battlers while in battle.
 * ***** This effect only applies to battlers in the battle scene.
 * ***** Under effect is NOT applied to status window portraits.
 * ***** Under effect is NOT applied to projectile animations.
 * ** Added new Action Sequence Projectile settings:
 * *** Extra Settings > End Animation ID:
 * **** Plays an animation when projectile reaches target.
 * **** Requires VisuMZ_3_ActSeqProjectiles version 1.09+.
 * 
 * Version 1.85: October 17, 2024
 * * Bug Fixes!
 * ** Fixed a bug where the enemy name's visibility would remain after an
 *    action has taken place and before inputting is done. Fix made by Olivia.
 * ** Fixed a bug where the "Name Visibility As Target" plugin parameter did
 *    not work properly. Fix made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Updated <Help Description> notetag documentation:
 * *** This is used as a common notetag between Battle Core's state
 *     descriptions and State Tooltips' state descriptions.
 * * New Features!
 * ** New Notetag added by Olivia:
 * *** <In-Battle Status Description>
 * **** A prioritized help description used to separate from the common help
 *      description notetag shared with State Tooltips.
 * ** New Plugin Parameters added by Olivia:
 * *** Actor Battlers > Frontview > Portrait Animations > Each Target
 * *** Actor Battlers > Frontview > Portrait Animations > Center of All
 * *** Actor Battlers > Frontview > Portrait Animations > Center of Screen
 * **** Place animations on top or behind for these display types?
 * *** Battle Log > Action Changes > Show Counter? > Wait Frames
 * *** Battle Log > Action Changes > Show Reflect? > Wait Frames
 * *** Battle Log > Action Changes > Show Substitute? > Wait Frames
 * **** If devs allow the results of counters, reflects, and substitutes, there
 *      wasn't enough time before to allow the text to be visible on screen.
 *      You can now adjust how many frames are now visible if text is shown.
 * **** Default values are left at 0 as to not interrupt currently existing
 *      action sequences.
 * 
 * Version 1.84: September 19, 2024
 * * Bug Fixes!
 * ** Fixed a bug where Action Sequence "MOVE: Change Home By Distance" would
 *    also be affected by the actor and enemy position offsets. Fixed by Irina.
 * ** Fixed a bug where Action Sequence "MECH: STB Exploit Effect" caused a
 *    crash. Fix made by Arisu.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Command added by Arisu:
 * *** ANIM: Change Battle Portrait (JS)
 * **** Changes the battle portrait of the actor through JavaScript.
 * **** Can be used outside of battle/action sequences.
 * ** New Plugin Parameters added by Olivia:
 * *** Plugin Parameters > In-Battle Status Window
 * **** This new window allows the player to view the status of the current
 *      active party. If the actors have states and buffs, the player can
 *      scroll through them and read about their effects through the help
 *      window.
 * ** New Notetags added by Olivia:
 * *** <Help Description>
 * **** Assigns a help description for the state that's displayed under the
 *      new "Status" actor command.
 * *** <Exclude From Status Listing>
 * **** Excludes the state from being displayed in the status listing.
 * *** <Aspect Name: x>
 * *** <Aspect Icon: x>
 * *** <Aspect Color: x>
 * *** <Aspect Description>
 * **** Used to define enemy aspect that will show up in the In-Battle Status
 *      as well as other supported plugins.
 * *** <Popup Position: Head>
 * *** <Popup Position: Center>
 * *** <Popup Position: Base>
 * **** Changes the popup starting position for this enemy.
 * *** <Popup Offset X: +x>
 * *** <Popup Offset X: -x>
 * *** <Popup Offset Y: +y>
 * *** <Popup Offset Y: -y>
 * **** Changes the popup X/Y position offset for this enemy.
 * ** New Plugin Parameters added by Olivia:
 * *** Plugin Parameters > Party Command Window > Add Status?
 * **** Add the "Status" command to the Command Window? 
 * *** Plugin Parameters > Actor Command Window > Command List
 * **** Updated to have the "Status" command.
 * *** Plugin Parameters > In-Battle Status Window
 * **** Completely new! View the help file for more information.
 * *** Plugin Parameters > Enemy > Aspects
 * **** Used for the In-Battle Status as well as other supported plugins.
 * 
 * Version 1.83: May 16, 2024
 * * Bug Fixes!
 * ** Fixed a bug where sometimes, a battler in Active TPB would not refresh
 *    their motion after a state has been removed. Fix made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Fixed a typo with MP Life Steal notetag entry.
 * * Feature Updates!
 * ** Added fail safes for some plugin parameters in case users outright delete
 *    plugin parameter values without introducing something to replace them.
 *    Update made by Olivia.
 * * New Features!
 * ** New Action Sequence added by Olivia:
 * *** GRID: Add Trigger to Node JS
 * **** Adds JS Trigger to target node. Target node cannot have battler.
 * **** Requires VisuMZ_2_BattleGridSystem!
 * ** New notetags added by Olivia:
 * *** <JS Accuracy>
 * *** <JS Accuracy as User>
 * *** <JS Accuracy as Target>
 * **** Allows usage of JavaScript code to modify accuracy rates of actions in
 *      battle through skills, items, and trait objects.
 * *** <JS Critical Rate as User>
 * *** <JS Critical Rate as Target>
 * **** Allows usage of JavaScript code to modify critical rate of actions in
 *      battle through skills, items, and trait objects.
 * **** <JS Critical Rate> version already exists.
 * ** New Plugin Parameters added by Olivia
 * *** Plugin Parameters > Damage Combo Window
 * **** If enabled, this window will display updated information about the
 *      total amount of hits performed and total damage/healing value executed
 *      for HP.
 * *** Plugin Parameters > Actor Battler Settings > Sideview Battlers >
 *     State Overlay > Offset X/Y
 * **** Offsets X/Y position for state overlay on actor.
 * *** Plugin Parameters > Enemy Battler Settings > Name Visibility >
 *     As Target
 * **** Shows enemy name when enemy is a target.
 * *** Plugin Parameters > Enemy Battler Settings > Name Visibility >
 *     Temporary Visibility
 * **** Number of frames enemy's name temporarily visible after taking an
 *      action effect in battle.
 * 
 * Version 1.82: March 14, 2024
 * * Bug Fixes!
 * ** Home movement changes did not acknowledge actor and enemy offset X/Y
 *    positions. This should now be reflected properly. Fix made by Irina.
 * ** Fixed a bug where in active TPB/ATB, revived actors may not resume normal
 *    motions after collapsing. Fix made by Olivia.
 * 
 * Version 1.81: February 15, 2024
 * * Bug Fixes!
 * ** Fixed a bug that would cause active TPB inputting actors to not show
 *    their damage or evasion motions. Fix made by Olivia.
 * ** Fixed a bug that would cause a crash upon motion changes. Fix by Olivia.
 * ** Fixed an incorrect spelling of "Anger" for "ANIM: Balloon Animation" that
 *    prevented it from working properly.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequences added by Olivia:
 * *** ANIM: Show Animation JS
 * **** Plays the a specific animation on unit(s). Uses JavaScript to determine
 *      animation ID.
 * ** New Action Sequences added for future plugin: VisuMZ_2_BattleGridSystem
 * *** GRID: Action Animation at Node
 * *** GRID: Add Passive State(s) to Node
 * *** GRID: Add Trigger to Node
 * *** GRID: Animation ID at Node
 * *** GRID: Animation JS at Node
 * *** GRID: Animation Type at Node
 * *** GRID: Move Target(s) In Direction
 * *** GRID: Pull To Target Node
 * *** GRID: Push From Target Node
 * *** GRID: Remove All Passive States from Node
 * *** GRID: Remove Passive State(s) from Node
 * *** GRID: Remove Trigger from Node
 * *** GRID: Teleport To Node
 * *** GRID: Traverse To Node
 * **** Requires the future plugin VisuMZ_2_BattleGridSystem!
 * **** Read the help section for more information on these.
 * 
 * Version 1.80: January 18, 2024
 * * Bug Fixes!
 * ** Fixed a crash that would occur with <Disperse Damage> when used outside
 *    of battle. Fix made by Irina.
 * ** Fixed a crash that would occur with certain enemy graphics when images
 *    used for them would disappear. Fix made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequences added by Olivia:
 * *** ANIM: Guard Animation
 * *** ANIM: Item Animation
 * *** ANIM: Skill Animation
 * **** Plays the animation associated with the user's guard action (if any),
 *      or a specific item/skill.
 * *** MECH: Emulate Attack Effect
 * *** MECH: Emulate Guard Effect
 * *** MECH: Emulate Item Effect
 * *** MECH: Emulate Skill Effect
 * **** Emulate an "Action Effect" but using a the user's attack skill, guard
 *      skill, specific item, or specific skill instead of the current action.
 * **** Essentially lets you perform the mechanics of another action without
 *      having to use another action or needing to pay that action's costs.
 * *** MECH: Emulate Skill Cost
 * **** Pick a skill for target(s) to emulate paying the cost of.
 * **** Includes cooldowns and limited uses.
 * *** MECH: State Turns Change By
 * *** MECH: State Turns Change To
 * **** Changes target(s) state turns by an amount/to a certain value.
 * **** Requires VisuMZ_1_SkillsStatesCore!
 * *** Projectile action sequences have new Extra Features!
 * **** See v1.08 changes for VisuMZ_3_ActSeqProjectiles.
 * 
 * Version 1.79: December 14, 2023
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequences added by Arisu:
 * *** ANIM: Balloon Animation
 * **** Plays a balloon animation on target(s).
 * *** ANIM: Balloon Icon (Single)
 * *** ANIM: Balloon Icon (Range)
 * *** ANIM: Balloon Icon (Specific)
 * **** Plays a balloon animation using an icon on target(s).
 * **** Requires VisuMZ_4_IconBalloons!
 * 
 * Version 1.78: October 12, 2023
 * * Bug Fixes!
 * ** Fixed a bug that is caused by using the actor escape command not escaping
 *    properly in battle and causing a freeze. Fix made by Olivia.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameter added by Olivia:
 * *** Parameters > Mechanics > Turn End Buffs Expire?
 * **** Normally, buffs expire after all actions end.
 * **** But here, you can have buffs expire on turn end.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.77: August 17, 2023
 * * Bug Fixes!
 * ** Fixed a bug where for TPB, actions aimed at dead targets would not
 *    redirect to suitable targets. Fix made by Olivia.
 * ** Fixed a bug where dual wielding would not use a weapon if it was equipped
 *    in the second weapon slot if the first weapon slot was empty. Fix made
 *    by Olivia.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * ** Added compatibility for VisuStella MZ Battle Voices Action Sequences.
 * * Documentation Update!
 * ** Help file updated for new features.
 * 
 * Version 1.76: July 13, 2023
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequences added by Olivia and sponsored by NSG:
 * *** MOVE: Change Home To JS Coordinates
 * **** Change home position(s) to specified JS Coordinates. Sideview-only!
 *      Uses JS!
 * *** MOVE: Face JS Coordinates
 * **** Causes the unit(s) to face specified JS Coordinates. Sideview-only!
 *      Uses JS!
 * *** MOVE: Move To JS Coordinates
 * **** Moves unit(s) to specified JS Coordinates. Sideview-only! Uses JS!
 * 
 * Version 1.75: March 16, 2023
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New notetags added by Olivia and sponsored by Anon:
 * *** <HP Life Steal: x%>
 * *** <MP Life Steal: x%>
 * *** <HP Life Steal hitType: +/-x%>
 * *** <MP Life Steal hitType: +/-x%>
 * *** <Cancel Life Steal>
 * *** <Guard Life Steal>
 * *** <Disarm Life Steal>
 * *** <Negative Life Steal>
 * **** Life Steal properties involving HP/MP are now added. They will restore
 *      a portion of the dealt HP/MP damage to the target.
 * **** This is a different mechanic from Drain HP/Drain MP and cannot be used
 *      together to prevent clashing.
 * **** Read the help file for more information.
 * 
 * Version 1.74: February 16, 2023
 * * Bug Fixes!
 * ** Fixed a bug that would cause a crash if your basic attack skill somehow
 *    manages to target neither an enemy nor an actor. Fix made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Auto-action sequence for jumping forward and attacking is now reinstated
 *    so that it's only disabled when the target and user are on the same side.
 *    If there is no target, a jump still occurs for visual player feedback.
 *    Update made by Olivia.
 * * New Features!
 * ** New notetag effect added by Olivia and sponsored by AndyL:
 * *** <Cannot Target User>
 * **** This will cause the action to be unable to select the user as target.
 * **** This is not a targeting scope. Instead, it is used in addition to any
 *      other targeting scopes out there.
 * 
 * Version 1.73: January 20, 2023
 * * Bug Fixes!
 * ** Active TPB custom action sequences will no longer play differently due to
 *    queued inputting actors causing motion refreshes. Fix made by Arisu.
 * ** Corrected and updated Anti-Tint UI animation offsets for MV animations.
 *    Fix made by Irina.
 * ** Fixed a problem with Sideview Battlers not working properly. Fix made
 *    by Irina.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Help file updated for to add the following text to the <Target: x>
 *    notetag entries in order to avoid confusion.
 * *** This will overwrite the existing database scope and ignore the
 *     database's existing scope in favor of this.
 * * Feature Update!
 * ** <Extend: x> Troop Name Tag is now also usable as a Troop Comment Tag.
 * ** Action Sequence targeting has been updated with two new types "special"
 *    and "special x", to be used for future plugins.
 * * New Features!
 * ** New Notetags added by Irina and sponsored by AndyL:
 * *** <Target: Ally or Enemy>
 * *** <Target: Enemy or Ally>
 * **** Allows the player to target allies or enemies with the skill/item.
 * **** See help file for more information.
 * *** <Single or Multiple Select>
 * **** This will allow the skill/item to be able to select either single
 *      targets or multiple targets at once.
 * **** See help file for more information.
 * *** <Disperse Damage>
 * **** This will cause any damage dealt by this skill to be split equally
 *      amongst all targets of the skill including repeats.
 * ** New Plugin Parameters added by Irina and sponsored by AndyL:
 * *** Plugin Parameters > Multi-Target Windows
 * **** Settings that alter the Multi-Target Windows in battle.
 * 
 * Version 1.72: December 15, 2022
 * * Bug Fixes!
 * ** Fixed a transformation of a sideview enemy to a static enemy and back not
 *    working properly. Fix made by Irina.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Feature!
 * ** New Plugin Parameter added by Irina!
 * *** Plugin Parameters > HP Gauges > Settings > Animation Duration
 * **** How many frames should gauges animate themselves? Default: 20 frames.
 * ** New Plugin Parameters added by Yanfly!
 * *** Plugin Parameters > Actor Battler Settings > Shake Flinch
 * *** Plugin Parameters > Actor Battler Settings > Shake Flinch > Max Power
 * *** Plugin Parameters > Actor Battler Settings > Shake Flinch > Max Duration
 * **** These new plugin parameters will cause targets that take HP damage to
 *      shake (in addition to a regular flinch) to provide better visual
 *      feedback to the player.
 * **** Shake Flinch will be kept disabled by default and only turned on when
 *      you want it to be.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.71: November 10, 2022
 * ** Fixed a problem with repeating animations from Visual State Effects
 *    causing softlocks. Fix made by Olivia.
 * 
 * Version 1.70: October 6, 2022
 * * Bug Fixes!
 * ** Fixed a problem with the "Border" style where if a battle portrait
 *    changed midway through the battle, the portrait shown didn't actually
 *    update properly. Fix made by Irina.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequence added by Olivia:
 * *** MECH: Active Chain Input Disable
 * **** Disables input for Active Chain Skills at this time.
 * **** Requires VisuMZ_3_ActiveChainSkills!
 * ** New Plugin Parameter added by Olivia and sponsored by Anon:
 * *** Plugin Parameters > Damage Settings > Popups > End Battle Show?
 * **** Show or hide popups upon victory or escape?
 * **** Used to hide battle-state removal popups.
 * 
 * Version 1.69: September 7, 2022
 * * Compatibility Update!
 * ** Better compatibility with VisuMZ Active Chain Skills.
 * ** Compatibility will be seen with VisuMZ_3_ActiveChainSkills version 1.02.
 * * Documentation Update!
 * ** Added notes to the following Action Sequences:
 * *** MOTION: Clear Freeze Frame and MOTION: Freeze Motion Frame
 * **** Only applies to sprite sheets.
 * **** Does NOT work with Dragonbones.
 * **** Use "DB: Dragonbones Time Scale" instead.
 * * Feature Update!
 * ** Reduced MV Animation misalignment when Screen Resolution does not match
 *    the UI Area Resolution. Update by Arisu.
 * ** Command Remember will now remember the locations of single skills. Update
 *    made by Olivia.
 * 
 * Version 1.68: August 4, 2022
 * * Feature Update!
 * ** Damage popups are now automatically cleared upon starting battles. This
 *    is to ensure that, if for some reason, residual damage popup requests
 *    will not be retained. Update made by Olivia.
 * 
 * Version 1.67: July 28, 2022
 * * Feature Updates!
 * ** Rounding window coordinates have been added for for 'XP' and 'Portrait'
 *    styles when window sizes happen to land on non-divisible numbers. Update
 *    made by Irina.
 * ** Enemy name position rounding is now enforced. Update made by Irina.
 * 
 * Version 1.66: July 14, 2022
 * * Bug Fixes!
 * ** Fixed a bug that caused the various Battleback Scaling JS custom plugin
 *    parameters to not work properly. Fix made by Irina.
 * 
 * Version 1.65: July 7, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Updates!
 * ** Automatic action motions for HP and MP Recovery (Certain Hit type) will
 *    now use the "skill" cast SV animation instead of attack animation to
 *    better match the default RPG Maker MZ cast animation. Update by Olivia.
 * * New Features!
 * ** New troop name tag added by Olivia:
 * *** <Extend: x> and <Extend: x, x, x>
 * **** Adds enemies from another troop to the current troop.
 * **** Enemies from another troop will retain their database positions.
 * **** Extended troop members will be added in the order they're listed.
 * **** Be cautious of how many enemies you add as too many will lag the battle
 *      system. We are not responsible for frame drops due to this.
 * 
 * Version 1.64: June 16, 2022
 * * Bug Fixes!
 * ** "All Skills" battle command should now work with the updated version of
 *    VisuMZ Skills & States Core. Fix madde by Olivia.
 * * Compatibility Update
 * ** Plugins should be more compatible with one another.
 * 
 * Version 1.63: May 26, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** HP Gauge sprite now properly synchs with battler location.
 * * New Features!
 * ** New Action Sequence Effects added by Irina and sponsored by MirageV:
 * *** INJECT action sequence series
 * **** See the Action Sequence Impact changelog for details.
 * 
 * Version 1.62: April 22, 2022
 * * Bug Fixes!
 * ** RPG Maker MZ Bug Fix!
 * *** Battle Forced End Action Crash
 * **** Depending on various circumstances, currently active battlers can be
 *      cleared from the battle system at will due to a number of reasons.
 *      However, if it just so happens that the targets are cleared, too, with
 *      actions remaining, then a crash will follow up. This plugin will
 *      prevent that change. Fix made by Olivia.
 * 
 * Version 1.61: April 14, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Impact Effects added by Irina and collaborating with Manu Gaming!
 * *** Impact: Bizarro Inversion
 * *** Impact: Desaturation
 * *** Impact: Negative Inversion
 * *** Impact: Oversaturation
 * *** Impact: Time Scale
 * *** Impact: Time Stop
 * 
 * Version 1.60: April 7, 2022
 * * Bug Fixes!
 * ** <Bypass Soft Damage Cap> notetag should no longer cause crashes. Fix made
 *    by Olivia.
 * * Feature Update!
 * ** Removed one of the forced log window clear events that have made log
 *    window messages impossible to utilize for certain settings. Update made
 *    by Olivia.
 * 
 * Version 1.59: March 31, 2022
 * * Bug Fixes!
 * ** Escape failure will no longer trigger Post-Battle Common Events. Fix
 *    made by Arisu.
 * 
 * Version 1.58: March 24, 2022
 * * Documentation Update:
 * ** Added extra clarity to <Sideview Size: width, height> notetag:
 * *** This does NOT change the image size. This only changes the HITBOX size.
 * * Feature Update!
 * ** Added failsafes to prevent battlers from moving to non-finite coordinates
 *    if calculations are made for non-existent targets. Updated by Olivia.
 * ** Regeneration timing for TPB-based battle systems will now occur based on
 *    individual turn counts instead of global turn counts for initial turn 0
 *    checks. Updated by Olivia.
 * 
 * Version 1.57: February 17, 2022
 * * Feature Update!
 * ** Adjusted the offset properties for the anti-tint UI container to properly
 *    match the UI offsets if the anti-tint were to be off. Update by Irina.
 * 
 * Version 1.56: February 10, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Once Parallels for battle now operate outside of the battle process.
 *    Update made by Olivia.
 * * New Features!
 * ** New Troop Page comment tag added by Olivia and sponsored by Puddor:
 * *** <Once Parallel When Start Battle>
 * **** Causes the troop page to immediately run the moment the battle scene
 *      begins to fade in (not after it fades in). This is faster than a turn 0
 *      condition troop page. Troop page conditions are ignored.
 * **** This can be used for things like the Action Sequence Camera plugin, the
 *      Visual Battle Environment plugin, and/or initial battle poses and such
 *      in order to provide a near seamless battle transition experience.
 * **** This does NOT trigger when coming out of the options menu or party
 *      menu screens.
 * **** This WILL trigger when going from battle to battle nonstop via plugins
 *      like VisuStella MZ's Chain Battles.
 * **** When actors are moving towards their home positions, it will take
 *      around 30 frames by default. Use this information however you like.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.55: January 27 2022
 * * Compatibility Update!
 * ** RPG Maker MV animations with front view should now play in the correct
 *    area against actor faces. Update made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Animations now play on top of all actor faces/portraits regardless of the
 *    battle layout style. Update made by Olivia.
 * * New Features!
 * ** New notetag added by Arisu.
 * *** <Bypass Auto Action Sequence>
 * **** This notetag is used for the game devs that have the Action Sequence
 *      Plugin Parameter "Auto Notetag" on for applying the notetag
 *      <Custom Action Sequence> to every skill and item with common events.
 * **** This will allow items and skills to be able to launch their common
 *      events from the menu scene regardless of the inherent restriction to
 *      prevent action sequence based skills/items with common events from
 *      launching.
 * **** Ignore this if you have "Auto Notetag" disabled or set to false. By
 *      default, this setting is set to false. Please be aware of the changes
 *      you've made to your game before using it.
 * 
 * Version 1.54: January 13, 2022
 * * Bug Fixes!
 * ** RPG Maker MZ Bug Fix!
 * *** Overly-Protective Substitute
 * *** When an ally with critical health is being targeted by a friendly non-
 *     Certain Hit skill (such as a heal or buff) and another ally has the
 *     substitute state, the other ally would "protect" the originally targeted
 *     ally and take the heal or buff.
 * *** The new changed behavior is that now, substitute will not trigger for
 *     any actions whose scope targets allies.
 * *** Fix made by Olivia.
 * 
 * Version 1.53: December 30, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Help file updated for updated features.
 * * New Features!
 * ** New Plugin Parameter added by Olivia:
 * *** Plugin Parameters > Battle Layout > UI Elements > Anti-Tint UI?
 * **** Prevent UI Elements from being tinted?
 * **** This prevents UI Elements such as HP Gauges, Enemy Names, Battle
 *      Cursor, and Weakness Display from being affected by screen tint.
 * * Updated Feature!
 * ** Updated Plugin Command "PROJECTILE: Animation" by Arisu!
 * *** New Parameter: Wait For Animation?
 * **** Wait for animation to finish before going to the next command?
 * 
 * Version 1.52: December 16, 2021
 * * Compatibility Update!
 * ** RPG Maker MZ 1.4.0 compatibility update!
 * *** MV Animations played on screen level will now show up properly in the
 *     center of the screen.
 * 
 * Version 1.51: December 9, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequence Plugin Commands added by Arisu:
 * *** MOVE: Change Home By Distance
 * *** MOVE: Change Home To Point
 * *** MOVE: Change Home To Target(s)
 * **** These Plugin Commands allow you to adjust the home position of
 *      battlers in sideview battle.
 * **** This is sideview only!
 * **** This does NOT work with front view!
 * **** For those wondering, going to the options screen, party screen, etc.
 *      won't reset the home positions like regular movement changes do.
 * **** Merry Christmas, Harold-gang!
 * 
 * Version 1.50: November 4, 2021
 * * Bug Fixes!
 * ** <Seal Attack> and <Seal Guard> should no longer be bypassed by
 *    auto-battle status. Fix made by Yanfly.
 * 
 * Version 1.49: October 28, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Action Sequence: MOTION: Freeze Motion Frame will now only show weapons
 *    when using a motion that is named either "attack", "thrust", "swing", or
 *    "missile". Update made by Irina.
 * ** Fail safe added to prevent Scene_Battle going into unsupported scenes
 *    like Scene_Equip and Scene_Skill. Update made by Olivia.
 * * New Feature!
 * ** New Action Sequence Plugin Command added by Arisu and sponsored by Anon:
 * *** MECH: Once Parallel
 * **** Plays a Common Event parallel to the battle event once without
 *      repeating itself when done.
 * **** When exiting battle scene, all Once Parallels are cleared.
 * **** Once Parallels are not retained upon reentering the scene.
 * **** Once Parallels are not stored in memory and cannot be saved.
 * 
 * Version 1.48: October 21, 2021
 * * Feature Update!
 * ** Animations are now played on top of battlers in the Front View XP Battle
 *    Layout appearance. Update made by Irina.
 * ** Battle Log, if decided to be shown, now updates faster. Update by Irina.
 * ** Default Critical Damage Bonus increase is now updated to account for
 *    HP Healing and MP Recovery. To update this, create a new project, with
 *    the newest version of Battle Core installed. Copy over the Plugin
 *    Parameters for the Damage Settings > Critical Hits > JS: Damage Formula
 *    to your own project's version. Update made by Irina.
 * 
 * Version 1.47: October 14, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Feature Update!
 * ** Back attachment sprites are now automatically updated with sprite
 *    battlers to be shifted towards the very back.
 * 
 * Version 1.46: September 23, 2021
 * * Bug Fixes!
 * ** Fixed problem with skills and items without action sequences preventing
 *    actions from occurring. Fix made by Yanfly.
 * 
 * Version 1.45: September 17, 2021
 * * Bug Fixes!
 * ** <JS Pre-End Action> and <JS Post-End Action> effects now have multiple
 *    checks to make sure that they don't launch multiple times when a battler
 *    without actions has a turn after one that does. Fix made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequence notetags added by Yanfly and Arisu:
 * *** <Common Event Key: name>
 * *** <Common Event Keys: name, name, name>
 * *** <Common Event Keys>
 *      key
 *      key
 *      key
 *     </Common Event Keys>
 * **** Will generate Common Events for the skill/item with a corresponding
 *      key.
 * **** More information will be explained inside of the help file.
 * **** This feature is made for make the process of sharing Action Sequences
 *      to become easier without needing to line up Common Event ID's.
 * 
 * Version 1.44: August 20, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequence added by Irina and sponsored by Anon.
 * *** "ANIM: Play at Coordinate"
 * **** Plays an animation on the screen at a specific x, y coordinate even if
 *      there is no sprite attached.
 * **** Requires VisuMZ_0_CoreEngine!
 * 
 * Version 1.43: July 23, 2021
 * * Feature Update!
 * ** Immortality now works different with instant death mechanics. Skill
 *    effects that apply instant death or attack states that apply instant
 *    death will now trigger a flag instead of cancelling immortality. The
 *    flag will remain until immortality is manually cancelled via Action
 *    Sequence and then proc the death effect. This way, animations can remain
 *    to the end with instant death mechanics in mind. This does not affect
 *    script calls.
 * 
 * Version 1.42: July 16, 2021
 * * Bug Fixes!
 * ** Added another fail safe for empty common events used for pre-battle
 *    common events. Fix made by Olivia.
 * 
 * Version 1.41: July 2, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Added entries to <Battle Command> notetags and Plugin Parameters for
 *    "Party", "Combat Log", and "Weapon Swap" which weren't updated before.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * * New Features!
 * ** New Action Sequence added by Arisu:
 * *** MECH: Enemy Escape
 * **** Causes the enemy unit(s) to escape.
 * 
 * Version 1.40: June 25, 2021
 * * Bug Fixes!
 * ** Transformations from static enemies to and from animated SV enemies
 *    should no longer show both sprites. Fix made by Irina.
 * * Compatibility Update
 * ** Compatibility update with RPG Maker MZ 1.3.0+.
 * 
 * Version 1.39: June 18, 2021
 * * Bug Fixes!
 * ** MOVE: Home Reset should no longer trigger an end action function and
 *    cause plugins such as "Boost Action" to malfunction. Fix made by Olivia.
 * * Compatibility Update
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for updated features.
 * * Feature Update!
 * ** <Battle Layout: x> Troop Name tags can now work with comment tags. Update
 *    made by Irina.
 * ** Random encounter lists are now better shuffled for more variety with how
 *    the RNG seed works. Update made by Arisu.
 * 
 * Version 1.38: June 11, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Updates!
 * ** Location calculations will now be based off the a battler's base position
 *    in order for animations, popups, and other aspects to line up properly
 *    when scaled. Update made by Irina.
 * ** Plugin Parameters for Enemy Battler Settings > Name have been rearranged
 *    for better organization. Update by Olivia.
 * * New Features!
 * ** New Notetags added by Olivia and sponsored by NSG:
 * *** <Sideview Shadow Scale X: x%>
 * *** <Sideview Shadow Scale X: x.y>
 * *** <Sideview Shadow Scale Y: x%>
 * *** <Sideview Shadow Scale Y: x.y>
 * **** These new notetags allow you to adjust the X and Y scale of the SV
 *      shadow sprite separately.
 * ** New Plugin Parameters added by Olivia and sponsored by NSG:
 * *** Enemy Battler Settings > Name > Name Visibility > Always Hidden
 * *** Enemy Battler Settings > Name > Name Visibility > By Selection?
 * **** Choose to have the names always hidden or by selection.
 * **** These are adjusted on a priority list.
 * 
 * Version 1.37: May 21, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New notetags added by Olivia.
 * *** <Command Require Learn>
 * *** <Command Require Access>
 * **** These two commands determine the visibility of a battle command by
 *      whether or not the skill has been learned or accessible.
 * * Feature Update!
 * ** For those using TPB, each battler's regeneration phase will no longer
 *    tick multiple times in a single frame to prevent irregularities. Update
 *    made by Olivia.
 * 
 * Version 1.36: May 14, 2021
 * * Bug Fixes!
 * ** Reversed an HP/MP regeneration bug that was incorrectly reported for TPB.
 *    Fix made by Olivia.
 * * Documentation Update
 * ** Added "TPB/ATB Active Battle Actor Shifting" to Major Changes section:
 * *** This change has been active since the start of this plugin. It was not
 *     documented until now.
 * *** Pressing cancel on the Actor Command Window no longer switches between
 *     actors with a full TPB/ATB gauge before reaching the Party Command
 *     Window. This is to accomplish a couple of things: 1) reduce the number
 *     of button presses to reach the Party Command Window and 2) to prevent
 *     motion resets and disrupting action sequences. If this feature is vital
 *     to your battle system, we recommend that you do not use this plugin or
 *     any of the Battle Core-required plugins.
 * ** Feature Updates
 * *** Distortion sprite Y calculations will now be rounded upward for better
 *     visuals and prevent odd pixelation effects. Update made by Irina.
 * 
 * Version 1.35: May 7, 2021
 * * Bug Fixes!
 * ** Pre-Battle Common Events without a wait command at the end should no
 *    longer lock up by coincidentally pressing the menu key at the same time.
 *    Fix made by Olivia.
 * * Feature Update!
 * ** Added an extra check for TPB-based battle systems to not run turn end
 *    functions when it's not actually the actual turn end timing. Update made
 *    by Olivia.
 * ** "Damage Styles" plugin parameters are now moved to the top of the
 *    Damage Settings category. This should make it easier to acknowledge the
 *    existence of and not have it be an unknown entity. Update made by Irina.
 * 
 * Version 1.34: April 23, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Uses a better algorithm for determining shadow positioning. Update made
 *    by Olivia.
 * * New Features!
 * ** New additions made for Projectile action sequences.
 * ** "Start Location" and "Goal Location" now have "Target Location" parameter
 *    to determine which part of the target's body to send the projectile from
 *    or towards. Added by Olivia.
 * ** Requires VisuMZ_1_BattleCore version 1.34 to have affect.
 * 
 * Version 1.33: April 9, 2021
 * * Bug Fixes!
 * ** Skill costs should now be displayed on battle commands again. Bug fix
 *    made by Olivia.
 * ** Pre-Battle Common Events should no longer cause stalling when used with
 *    specific event commands. Bug fix made by Olivia.
 * * Compatibility Update!
 * ** Added "Weapon Swap" to the list of battle commands that can be added.
 * * Documentation Update!
 * ** Added "Weapon Swap" and "Combat Log" to the list of <Battle Commands> in
 *    the notetags section.
 * ** Help file updated for new features.
 * * New Features!
 * ** New notetags added by Olivia:
 * *** <Sideview Shadow Scale: x%> and <Sideview Shadow Scale: x.y>
 * **** Used for: Actor, Enemy Notetags
 * **** Adjusts the scaling size of the sideview battler's shadow.
 * 
 * Version 1.32: April 2, 2021
 * * Feature Update!
 * ** Sideview battler sprites when using front view will now factor in the
 *    window padding and appear properly centered to their focus point. Update
 *    made by Olivia.
 * 
 * Version 1.31: March 26, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Added "VisuStella MZ Compatibility" section for detailed compatibility
 *    explanations with the VisuMZ_3_BoostAction plugin.
 * 
 * Version 1.30: March 19, 2021
 * * Documentation Update!
 * ** Help file updated for updated features.
 * * Feature Update!
 * ** <JS Targets> is now updated to include the default set of targets
 *    selected by the skill/item's original scope. Update made by Yanfly.
 * *** If you wish to clear it out, simply do 'targets = []' first.
 * 
 * Version 1.29: March 12, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameter added by Olivia:
 * *** Plugin Parameters > Enemy Battler Settings > Name > Legacy Option
 * **** Use the legacy version (window) or new version (sprite).
 * **** WARNING: Legacy version is no longer supported for bugs.
 * **** Not all settings available here in the Plugin Parameters will be
 *      available to the legacy version (ie Always Visible and Attach States).
 * 
 * Version 1.28: March 5, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameters added by Arisu:
 * *** Plugin Parameters > Actor Command > Show Command Costs
 * **** If you don't want to show skill costs for your commands in the Actor
 *      Command Window, you can now hide them.
 * ** New Plugin Parameters added by Irina:
 * *** Plugin Parameters > Battle Layout Settings > Status Window Elements
 * *** Battle Layout Settings > Status Window Elements > Battler Name
 * *** Battle Layout Settings > Status Window Elements > Gauge 1 (HP)
 * *** Battle Layout Settings > Status Window Elements > Gauge 2 (MP)
 * *** Battle Layout Settings > Status Window Elements > Gauge 3 (TP)
 * *** Battle Layout Settings > Status Window Elements > State Icon
 * *** Battle Layout Settings > Status Window Elements > TPB/ATB Gauge
 * **** These new Plugin Parameters allow you to offset the positions of the
 *      various Battle Status Window elements. Their base positions will be
 *      calculated by the Battle Layout used and then offset from there.
 * *** Battle Layout Settings > Status Window Elements > Window Skin
 * **** These settings allow you to set a specific window skin for the
 *      Battle Status Window or hide it from view completely.
 * *** Battle Layout Settings > Status Window Elements > Selectable Background
 * **** This option allows you to hide the black box that comes with the
 *      majority of selectable elements found in RPG Maker MZ in case it does
 *      not fit with how you want the Battle Status Window to look.
 * *** Battle Layout Settings > Status Window Elements > Back Attachment
 * *** Battle Layout Settings > Status Window Elements > Front Attachment
 * **** These settings allow you to attach images to the back/front of the
 *      Battle Status Window from the img/system/ folder.
 * **** You may offset X and Y positions for them as well.
 * ** New Plugin Parameters added by Olivia:
 * *** Plugin Parameters > Enemy Settings > Name: Always Visible
 * **** Determines if the enemy name will always be visible.
 * *** Plugin Parameters > Enemy Settings > Name: Attach States
 * **** Attach the enemy's state icon to the enemy name?
 * *** Plugin Parameters > Enemy Settings > Attach: Offset X/Y
 * **** Offset the attached state icon's position.
 * * Feature Update!
 * ** Switched drawing enemy names on the screen from window to sprite to
 *    reduce lag and for better screen positioning accuracy especially during
 *    screen zooming. Update by Olivia.
 * 
 * Version 1.27: February 26, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameters added by Irina and sponsored by AndyL:
 * *** Plugin Parameters > Mechanics Settings > Switches > Switch: Critical
 * *** Plugin Parameters > Mechanics Settings > Switches > Switch: Miss/Evade
 * **** Turns Switches ON if the action performs a critical hit, misses, or is
 *      evaded at any point.
 * **** Switch reverts to OFF whenever an action starts.
 * **** If multiple targets/hits are struck, as long as one hit respectively
 *      lands a critical hit, fails to land, then the switch will remain ON for
 *      the rest of the action.
 * *** Plugin Parameters > Mechanics Settings > Variables > Variable: Damage
 * *** Plugin Parameters > Mechanics Settings > Variables > Variable: Healing
 * **** Variable records target damage/healing during action.
 * **** Variable reverts to 0 whenever an action starts.
 * **** If multiple targets/hits are struck, the variable will record the total
 *      amount of damage/healing done for the remainder of the action (unless
 *      manually reseting to 0 during an Action Sequence).
 * 
 * Version 1.26: February 19, 2021
 * * Bug Fixes!
 * ** Battles with branching event paths found within a conditional branch or
 *    choice tree will no longer be skipped over. Fix made by Arisu.
 * * Compatibility Update
 * ** Returning to the battle scene from the options scene in a Tpb-base battle
 *    system now links the current actor. Update by Irina.
 * 
 * Version 1.25: February 5, 2021
 * * Compatibility Update
 * ** Added compatibility update with VisuStella MZ Skills and States Core's
 *    Plugin Parameter > State Settings > Action End Update
 * * Feature Update!
 * ** <Common Event: name> notetag no longer requires <Custom Action Sequence>
 *    notetag if the Plugin Parameter: Auto Notetag is enabled.
 * 
 * Version 1.24: January 29, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** MOVE: Move To Point and MOVE: Move To Target(s) Action Sequences'
 *    "Offset Adjustment" normal setting will now factor in Offset X and
 *    Offset Y positions unlike before where it cancels them. Update by Irina.
 * * New Features!
 * ** New notetag added by Arisu:
 * *** <Common Event: name>
 * **** Battle only: calls forth a Common Event of a matching name.
 * **** This is primarily used for users who are reorganizing around their
 *      Common Events and would still like to have their skills/items perform
 *      the correct Action Sequences in case the ID's are different.
 * 
 * Version 1.23: January 22, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** ACSET: All Targets Action Set and ACSET: Each Target Action Set updated
 * *** New parameter added: Dual/Multi Wield?
 * **** Add times struck based on weapon quantity equipped?
 * * New Features!
 * ** Dual Wielding now functions differently. Made by Olivia.
 * *** Previously, RPG Maker MZ had "Dual Wielding" attack using both weapon
 *     animations at once, with the combined ATK of each weapon. It's confusing
 *     to look at and does not portray the nature of "Dual Wielding".
 * *** Dual Wielding, or in the case of users adding in third and fourth
 *     weapons, Multi Wielding is now changed. Each weapon is displayed
 *     individually, each producing its own attack animation, showing each
 *     weapon type, and applying only that weapon's ATK, Traits, and related
 *     effects. It is no longer a combined effect to display everything at once
 *     like RPG Maker MZ default.
 * *** If an actor has multiple weapon slots but some of them are unequipped,
 *     then the action will treat the attack as a single attack. There will be
 *     no barehanded attack to add on top of it. This is to match RPG Maker
 *     MZ's decision to omit a second animation if the same scenario is
 *     applied.
 * ** New Action Sequence Plugin Commands added by Yanfly
 * *** ANIM: Attack Animation 2+
 * **** Plays the animation associated with the user's 2nd weapon.
 *      Plays nothing if there is no 2nd weapon equipped.
 * ** New Action Sequence Plugin Commands added by Olivia
 * *** WEAPON: Clear Weapon Slot
 * *** WEAPON: Next Weapon Slot
 * *** WEAPON: Set Weapon Slot
 * **** These are Action Sequence Plugin Commands for devs who want finer
 *      control over Dual/Multi Wielding weapons.
 * 
 * Version 1.22: January 15, 2021
 * * Compatibility Update
 * ** Compatibility with "All Skills" Actor Command should now work with the
 *    Skills & States Core hide skill notetags.
 * 
 * Version 1.21: January 8, 2021
 * * Bug Fixes!
 * ** "MOVE: Home Reset" Plugin Command Action Sequence should work properly.
 *    Fix made by Yanfly.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** New Notetag snuck in by Arisu
 * *** <Auto Action Sequence>
 * **** Used for those who have the "Auto Notetag" Plugin Parameter enabled and
 *      just want to use an automatic Action Sequence instead.
 * ** New Plugin Parameter snuck in by Arisu!
 * *** Plugin Parameters > Action Sequences > Quality of Life > Auto Notetag
 * **** Automatically apply the <Custom Action Sequence> notetag effect to any
 *      item or skill that has a Common Event?
 * **** Any item or skill without a Common Event attached to it will use the
 *      Automatic Action Sequences instead.
 * **** The <Auto Action Sequence> notetag will disable this effect for that
 *      particular skill or item.
 * ** Arisu, you're going to be responsible for any bugs these may cause.
 * *** Bring it!!!!
 * **** And handling any bug report emails that are sent because this was
 *      turned on by accident.
 * ***** Please read the documentation, guys!
 * 
 * Version 1.20: January 1, 2021
 * * Bug Fixes!
 * ** For TPB Active or ATB Active, inputting actors that have received damage
 *    will return back to place after flinching. Fix made by Yanfly.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** New notetags added by Yanfly:
 * *** <Battle Portrait Offset: +x, +y>
 * *** <Battle Portrait Offset X: +x>
 * *** <Battle Portrait Offset Y: +y>
 * **** This is used with the "Portrait" and "Border" Battle Layouts.
 * **** Offsets the X and Y coordinates for the battle portrait.
 * 
 * Version 1.19: December 25, 2020
 * * Bug Fixes!
 * ** Removing a state from a Sideview Enemy during the middle of their a non-
 *    looping motion will no longer reset their motion to neutral.
 *    Fix made by Yanfly.
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** Added documentation for updated feature(s)!
 * * Feature Update!
 * ** Action Sequence "PROJECTILE: Icon" now supports code for the "Icon"
 *    parameter. Update made by Yanfly.
 * 
 * Version 1.18: December 18, 2020
 * * Bug Fixes!
 * ** For TPB Active or ATB Active, inputting actors will no longer step back
 *    after an enemy's action is finished. Fix made by Yanfly and Shiro.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** Action Sequence "BTLOG: Add Text" is updated for the convenience of a new
 *    option to quickly copy the displayed text to the VisuStella MZ Combat Log
 *    if that plugin is installed. Added by Yanfly.
 * 
 * Version 1.17: December 11, 2020
 * * Bug Fixes!
 * ** Common Events in TPB Active that cause forced actions will no longer
 *    cause currently inputting actors that match the forced action battler to
 *    crash the game. Fix made by Yanfly and Shiro.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * Feature Update!
 * ** Action Sequence Impact Action Sequences "Shockwave from Each Target(s)",
 *    "Shockwave from Target(s) Center", and "Zoom Blur at Target(s) Center"
 *    now have "Offset X" and "Offset Y" plugin parameters. Added by Yanfly.
 * ** Action Sequence "MOVE: Move To Target(s)" is now changed so that if the
 *    "Melee Distance" value is set to 0, battlers will no longer stand a half
 *    body distance away. Added by Yanfly.
 * 
 * Version 1.16: December 4, 2020
 * * Bug Fixes!
 * ** Bug fixes made for the RPG Maker MZ base code. If a battler has no
 *    actions, then their action speed will not be Infinity. Fix by Olivia.
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.15: November 29, 2020
 * * Bug Fixes!
 * ** Completely replacing the whole party at once will no longer cause the
 *    battle system to crash. Fix made by Olivia.
 * ** Pre-Battle Common Events will no longer cancel out any win/lose branches.
 *    Fix made by Arisu.
 * * Feature Update!
 * ** Custom Action Sequences will no longer close the Actor Command Input
 *    window unless absolutely necessary (like for Show Message events) during
 *    Active TPB/ATB. Change made by Arisu.
 * 
 * Version 1.14: November 22, 2020
 * * Feature Update!
 * ** Natural Miss and Evasion motions now have flinch distance.
 *    Added by Yanfly.
 * 
 * Version 1.13: November 15, 2020
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.12: November 8, 2020
 * * Bug Fixes!
 * ** Failsafes added to prevent common events from running if they're empty.
 *    Fix made by Irina.
 * ** Skip Party Command will now work properly with TPB-based battle systems.
 *    Fix made by Yanfly.
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** In preparation for upcoming VisuStella MZ plugins.
 * 
 * Version 1.11: November 1, 2020
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** Added clarity for the Plugin Parameters for the Common Events settings
 *    found in the mechanics section. The common events are only meant to run
 *    in the map scene and not for the battle scene. Update made by Irina.
 * * Feature Update!
 * ** The Plugin Parameter for Mechanics, Common Events (on Map), Defeat Event
 *    now has updated functionality. If this has a common event attached to it,
 *    then losing to random encounters will no longer send the player to the
 *    Game Over scene, but instead, send the player back to the map scene,
 *    where the Defeat Common Event will run. Update made by Irina.
 * 
 * Version 1.10: October 25, 2020
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** New Action Sequence Plugin Command added by Olivia:
 * *** MECH: Custom Damage Formula
 * **** Changes the current action's damage formula to custom.
 *      This will assume the MANUAL damage style.
 * ** New Notetag added by Irina:
 * ** New Plugin Parameters added by Irina:
 * *** Plugin Parameters > Battleback Scaling Settings
 * **** These settings allow you to adjust how battlebacks scale to the screen
 *      in the game.
 * *** <Battler Sprite Grounded>
 * **** Prevents the enemy from being able to jumping and/or floating due to
 *      Action Sequences but still able to move. Useful for rooted enemies.
 * 
 * Version 1.09: October 18, 2020
 * * Bug Fixes!
 * ** Exiting out of the Options menu scene or Party menu scene will no longer
 *    cause party members to reset their starting position. Fix made by Arisu
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * ** There was a documentation error with <JS Pre-Regenerate> and
 *    <JS Post-Regenerate>. Fix made by Yanfly.
 * *** Before, these were written as <JS Pre-Regenerate Turn> and
 *     <JS Post-Regenerate Turn>. The "Turn" part of the notetag has been
 *     removed in the documentation.
 * * Feature Update!
 * ** Damage sprites on actors are now centered relative to the actor's anchor.
 *    Change made by Yanfly.
 * * New Features!
 * ** New Action Sequence Plugin Command added by Yanfly:
 * *** MECH: Variable Popup
 * **** Causes the unit(s) to display a popup using the data stored inside
 *      a variable.
 * 
 * Version 1.08: October 11, 2020
 * * Bug Fixes!
 * ** Dead party members at the start of battle no longer start offscreen.
 *    Fix made by Arisu.
 * ** Removed party members from battle no longer count as moving battlers.
 *    Fix made by Yanfly.
 * ** Using specific motions should now have the weapons showing and not
 *    showing properly. Fix made by Yanfly.
 * 
 * Version 1.07: October 4, 2020
 * * Bug Fixes!
 * ** Adding and removing actors will now refresh the battle status display.
 *    Fix made by Irina.
 * ** Adding new states that would change the affected battler's state motion
 *    will automatically refresh the battler's motion. Fix made by Irina.
 * ** Boss Collapse animation fixed and will sink into the ground.
 *    Fix made by Irina.
 * ** Failsafes added for certain animation types. Fix made by Yanfly.
 * ** Freeze Motion for thrust, swing, and missile animations will now show the
 *    weapons properly. Fix made by Yanfly.
 * ** The Guard command will no longer display the costs of the Attack command.
 *    Fix made by Irina.
 * * Documentation Update!
 * ** Updated help file for newly added plugin parameters.
 * * Feature Updates!
 * ** When using the Change Battleback event command in battle, the game client
 *    will wait until both battlebacks are loaded before changing the both of
 *    them so that the appearance is synched together. Change made by Yanfly.
 * * New Features!
 * ** New plugin parameters added by Irina!
 * *** Plugin Parameters > Actor Battler Settings > Chant Style
 * **** What determines the chant motion? Hit type or skill type?
 * 
 * Version 1.06: September 27, 2020
 * * Bug Fixes!
 * ** Enemy Battler Plugin Parameter "Shadow Visible" should now work again.
 *    Fix made by Irina.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins. Added by Yanfly.
 * * Documentation Update!
 * ** Updated the help file for all the new plugin parameters.
 * * Feature Update!
 * ** Action Sequence "MECH: HP, MP, TP" will now automatically collapse an
 *    enemy if it has been killed by the effect.
 * ** All battle systems for front view will now have damage popups appear
 *    in front of the status window instead of just the Portrait battle layout.
 *    Update made by Yanfly.
 * * New Features!
 * ** New Action Sequence Plugin Commands from Irina!
 * *** MOTION: Clear Freeze Frame
 * *** MOTION: Freeze Motion Frame
 * **** You can freeze a battler's sprite's motion with a specific frame.
 * ** New notetags for Maps and name tags for Troops added by Yanfly!
 * *** <Battle Layout: type> to change the battle layout style used for
 *     specific maps and/or troops.
 * ** New plugin parameters added by Yanfly!
 * *** Plugin Parameters > Battle Layout Settings > Command Window Width
 * **** This plugin parameter lets you adjust the window width for Party and
 *      Actor Command windows in the Default and List Battle Layout styles.
 * *** Plugin Parameters > Enemy Battler Settings > Name: Offset X
 * *** Plugin Parameters > Enemy Battler Settings > Name: Offset Y
 * **** These plugin parameters allow you to offset the position of the enemy
 *      name positions on the screen by a specific amount.
 * 
 * Version 1.05: September 20, 2020
 * * Bug Fixes!
 * ** Actors now use their casting or charging animations again during TPB/ATB.
 *    Fix made by Yanfly.
 * ** Defeat requirement for enemies will no longer crash the game if turned on
 *    after creating
 * ** Escaping animation no longer has actors stay in place. Fixed by Yanfly.
 * ** Failsafes added for newly added weapon types that have not been adjusted
 *    in the Database > System 2 tab. Fixed by Irina.
 * ** Shadows now appear under the actor sprites. Fix made by Yanfly.
 * ** Victory during TPB will no longer cancel the victory animations of
 *    actors that will have their turn after. Fixed by Yanfly.
 * * Documentation Update!
 * ** All Anchor Plugin Parameter descriptions now state to use values between
 *    0 and 1 to be safe. Update made by Yanfly.
 * * Feature Update!
 * ** During Active TPB / ATB, canceling out of the actor command window will
 *    go directly into the party window without having to sort through all of
 *    the available active actors.
 * ** Going from the Party Command Window's Fight command will immediately
 *    return back to the actor command window that was canceled from.
 * * New Features!
 * ** Action Sequence Plugin Command "MOVE: Spin/Rotate" has been updated.
 * *** A new parameter has been added: "Revert Angle on Finish"
 * *** Added by Yanfly.
 * ** New plugin parameters have been added to Damage Settings.
 * *** Appear Position: Selects where you want popups to appear relative to the
 *     battler. Head, Center, Base. Added by Yanfly.
 * *** Offset X: Sets how much to offset the sprites by vertically.
 *     Added by Yanfly.
 * *** Offset Y: Sets how much to offset the sprites by horizontally.
 *     Added by Yanfly.
 * ** New plugin parameters have been added to Actor Battler Settings.
 * *** Priority: Active - Place the active actor on top of actor and
 *     enemy sprites. Added by Yanfly.
 * *** Priority: Actors - Prioritize actors over enemies when placing 
 *     sprites on top of each other. Added by Yanfly.
 * 
 * Version 1.04: September 13, 2020
 * * Bug Fixes!
 * ** Active Battler Sprites now remain on top and won't be hidden behind
 *    other sprites for better visual clarity. Fix made by Arisu.
 * ** Collapsing battlers will now show the dead motion properly. Fix made by
 *    Olivia.
 * ** Dead battlers can no longer be given immortality. Fix made by Olivia.
 * ** Going into the Options menu with no battleback set will no longer set a
 *    battle snapshot.
 * ** HP Gauges for Sideview Enemies are no longer flipped! Fix made by Yanfly.
 * ** Moving a dead battler would no longer reset their animation. Fix made by
 *    Olivia.
 * ** Pre-Battle Common Events now work with events instead of just random
 *    encounters. Fix made by Yanfly.
 * ** Sideview Enemy shadows no longer twitch. Fix made by Irina.
 * * Documentation Updates!
 * ** Added further explanations for Anchor X and Anchor Y plugin parameters.
 *    This is because there's a lot of confusion for users who aren't familiar
 *    with how sprites work. Added by Irina.
 * ** <Magic Reduction: x> notetag updated to say magical damage instead of
 *    physical damage. Fix made by Yanfly.
 * * New Features!
 * ** Additional Action Sequence Plugin Commands have been added in preparation
 *    of upcoming plugins! Additions made by Irina.
 * *** Action Sequences - Angle (for VisuMZ_3_ActSeqCamera)
 * *** Action Sequences - Camera (for VisuMZ_3_ActSeqCamera)
 * *** Action Sequences - Skew (for VisuMZ_3_ActSeqCamera)
 * *** Action Sequences - Zoom (for VisuMZ_3_ActSeqCamera)
 * ** Additional Action Sequence Plugin Commands have been made available now
 *    and added to Battle Core! Additions made by Irina.
 * *** MOVE: Scale/Grow/Shrink
 * *** MOVE: Skew/Distort
 * *** MOVE: Spin/Rotate
 * *** MOVE: Wait For Scale
 * *** MOVE: Wait For Skew
 * *** MOVE: Wait For Spin
 * ** Plugin Parameters Additions. Additions made by Irina.
 * *** Plugin Params > Actor Battler Settings > Offset X
 * *** Plugin Params > Actor Battler Settings > Offset Y
 * *** Plugin Params > Actor Battler Settings > Smooth Image
 * *** Plugin Params > Enemy Battler Settings > Offset X
 * *** Plugin Params > Enemy Battler Settings > Offset Y
 * *** Plugin Params > Enemy Battler Settings > Smooth Image
 * 
 * Version 1.03: September 6, 2020
 * * Bug Fixes!
 * ** Animated Battlers will refresh their motions from the death motion once
 *    they're revived instead of waiting for their next input phase. Fix made
 *    by Yanfly.
 * ** Battle Log speed sometimes went by too fast for certain enabled messages.
 *    Wait timers are now added to them, like state results, buff results, and
 *    debuff results. Fix made by Yanfly.
 * ** Boss Collapse animation now works properly. Fix made by Yanfly.
 * ** Freeze fix for TPB (Wait) if multiple actors get a turn at the same time.
 *    Fix made by Olivia.
 * ** Pressing cancel on a target window after selecting a single skill no
 *    longer causes the status window to twitch.
 * ** Sideview Enemies had a split frame of being visible if they were to start
 *    off hidden in battle. Fix made by Shaz.
 * * Compatibility Update:
 * ** Battle Core's Sprite_Damage.setup() function is now separated fro the
 *    default to allow for better compatibility. Made by Yanfly.
 * * Documentation Update:
 * ** Inserted more information for "Damage Popups" under "Major Changes"
 * * New Features!
 * ** <Magic Penetration: x>, <Magic Penetration: x%> notetags added.
 * ** <Magic Reduction: x>, <Magic Reduction: x%> notetags added.
 * ** <Battle UI Offset: +x, +y>, <Battle UI Offset X: +x>, and
 *    <Battle UI Offset Y: +y> notetags added for adjusting the positions of
 *    HP Gauges and State Icons.
 * *** Notetags added by Yanfly.
 * 
 * Version 1.02: August 30, 2020
 * * Bug Fixes!
 * ** Failsafes added for parsing battle targets. Fix made by Yanfly.
 * ** Immortality is no longer ignored by skills/items with the Normal Attack
 *    state effect. Fix made by Yanfly.
 * ** Miss and Evasion sound effects work again! Fix made by Yanfly.
 * ** Selecting "Escape" from the Actor Command Window will now have the
 *    Inputting Battler show its escape motion. Fix made by Yanfly.
 * ** Wait for Movement now applies to SV Enemies. Fix made by Yanfly.
 * * New Features!
 * ** Plugin Command "ACSET: Finish Action" now has an option to turn off the
 *    Immortality of targets. Feature added by Yanfly.
 * * Optimization Update
 * ** Uses less resources when making checks for Pre-Battle Battle Start events
 * 
 * Version 1.01: August 23, 2020
 * * Bug Fixes!
 * ** Plugin Parameters > Damage Settings > Damage Formats are now fixed.
 *    Fix made by Olivia.
 * ** TPB Battle System with Disable Party Command fixed. Fix made by Olivia.
 * ** States now show in list format if faces are disabled. Fix made by Yanfly.
 * ** The default damage styles were missing the 'v' variable to allow for
 *    variable data input. These are back now. Fix made by Yanfly.
 * *** Users updating from version 1.00 will need to fix this problem by either
 *     removing the plugin from the Plugin Manager list and reinstalling it, or
 *     going to Plugin Parameters > Damage Settings > Style List > the style
 *     you want, and adding "const v = $gameVariables._data;" to JS: Formula
 * * New Notetags Added:
 * ** <Command Show Switch: x> added by Olivia
 * ** <Command Show All Switches: x,x,x> added by Olivia
 * ** <Command Show Any Switches: x,x,x> added by Olivia
 * ** <Command Hide Switch: x> added by Olivia
 * ** <Command Hide All Switches: x,x,x> added by Olivia
 * ** <Command Hide Any Switches: x,x,x> added by Olivia
 * ** <JS Command Visible> added by Olivia
 *
 * Version 1.00: August 20, 2020
 * * Finished Plugin!
 *
 * ============================================================================
 * End of Helpfile
 * ============================================================================
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceStart
 * @text -
 * @desc The following are Action Sequences commands/sets.
 * These Plugin Commands only work in battle.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakSet
 * @text Action Sequence - Action Sets
 * @desc Action Sequence Action Sets are groups of commonly used
 * Action Sequence Commands put together for more efficient usage.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_SetupAction
 * @text ACSET: Setup Action Set
 * @desc The generic start to most actions.
 * 
 * @arg DisplayAction:eval
 * @text Display Action
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ApplyImmortal:eval
 * @text Immortal: On
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ActionStart:eval
 * @text Battle Step
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg CastAnimation:eval
 * @text Cast Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_WholeActionSet
 * @text ACSET: All Targets Action Set
 * @desc Affects all targets simultaneously performing the following.
 * 
 * @arg DualWield:eval
 * @text Dual/Multi Wield?
 * @type boolean
 * @on Apply
 * @off Don't
 * @desc Add times struck based on weapon quantity equipped?
 * @default false
 * 
 * @arg PerformAction:eval
 * @text Perform Action
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitCount:eval
 * @text Wait Count
 * @desc How many frames should the action sequence wait?
 * You may use JavaScript code.
 * @default Sprite_Battler._motionSpeed
 * 
 * @arg ActionAnimation:eval
 * @text Action Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ActionEffect:eval
 * @text Action Effect
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ApplyImmortal:eval
 * @text Immortal: Off
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_TargetActionSet
 * @text ACSET: Each Target Action Set
 * @desc Goes through each target one by one to perform the following.
 * 
 * @arg DualWield:eval
 * @text Dual/Multi Wield?
 * @type boolean
 * @on Apply
 * @off Don't
 * @desc Add times struck based on weapon quantity equipped?
 * @default false
 * 
 * @arg PerformAction:eval
 * @text Perform Action
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitCount1:eval
 * @text Wait Count
 * @desc How many frames should the action sequence wait?
 * You may use JavaScript code.
 * @default Sprite_Battler._motionSpeed
 * 
 * @arg ActionAnimation:eval
 * @text Action Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitCount2:eval
 * @text Wait Count
 * @desc How many frames should the action sequence wait?
 * You may use JavaScript code.
 * @default Sprite_Battler._motionSpeed * 2
 * 
 * @arg ActionEffect:eval
 * @text Action Effect
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ApplyImmortal:eval
 * @text Immortal: Off
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_FinishAction
 * @text ACSET: Finish Action
 * @desc The generic ending to most actions.
 * 
 * @arg ApplyImmortal:eval
 * @text Immortal: Off
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForNewLine:eval
 * @text Wait For New Line
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForEffect:eval
 * @text Wait For Effects
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ClearBattleLog:eval
 * @text Clear Battle Log
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ActionEnd:eval
 * @text Home Reset
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceAngle
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakAngle
 * @text Action Sequences - Angle
 * @desc Allows you to have control over the camera angle.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_ChangeAngle
 * @text ANGLE: Change Angle
 * @desc Changes the camera angle.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Angle:eval
 * @text Angle
 * @desc Change the camera angle to this many degrees.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to change camera angle.
 * @default 60
 *
 * @arg EasingType:str
 * @text Angle Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForAngle:eval
 * @text Wait For Angle?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for angle changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Angle_Reset
 * @text ANGLE: Reset Angle
 * @desc Reset any angle settings.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to reset camera angle.
 * @default 60
 *
 * @arg EasingType:str
 * @text Angle Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForAngle:eval
 * @text Wait For Angle?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for angle changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Angle_WaitForAngle
 * @text ANGLE: Wait For Angle
 * @desc Waits for angle changes to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceAnimation
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakAnimation
 * @text Action Sequences - Animations
 * @desc These Action Sequences are related to the 'Animations' that
 * can be found in the Animations tab of the Database.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ActionAnimation
 * @text ANIM: Action Animation
 * @desc Plays the animation associated with the action.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_AttackAnimation
 * @text ANIM: Attack Animation
 * @desc Plays the animation associated with the user's 1st weapon.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_AttackAnimation2
 * @text ANIM: Attack Animation 2+
 * @desc Plays the animation associated with the user's other weapons.
 * Plays nothing if there is no other weapon equipped.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Slot:eval
 * @text Slot
 * @desc Which weapon slot to get this data from?
 * Main-hand weapon is weapon slot 1.
 * @default 2
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default true
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_BalloonAnimation
 * @text ANIM: Balloon Animation
 * @desc Plays a balloon animation on target(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["user"]
 *
 * @arg Balloon:str
 * @text Balloon Type
 * @type select
 * @option Exclamation
 * @option Question
 * @option Music Note
 * @option Heart
 * @option Anger
 * @option Sweat
 * @option Frustration
 * @option Silence
 * @option Light Bulb
 * @option Zzz
 * @option User-defined 1
 * @option User-defined 2
 * @option User-defined 3
 * @option User-defined 4
 * @option User-defined 5
 * @desc What kind of balloon should be played on target(s)?
 * @default Exclamation
 *
 * @arg WaitComplete:eval
 * @text Wait for Completion
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait for balloon animation completion before continuing?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_BalloonIcon
 * @text ANIM: Balloon Icon (Single)
 * @desc Plays a balloon animation using an icon on target(s).
 * Requires VisuMZ_4_IconBalloons!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["user"]
 *
 * @arg IconIndex:num
 * @text Icon Index
 * @desc Insert the ID of the icon to show.
 * Tip: Right click > Insert Icon Index
 * @default 0
 *
 * @arg WaitComplete:eval
 * @text Wait for Completion
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait for balloon animation completion before continuing?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_BalloonIconRange
 * @text ANIM: Balloon Icon (Range)
 * @desc Plays a balloon animation an icon range on target(s).
 * Requires VisuMZ_4_IconBalloons!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["user"]
 *
 * @arg startIcon:num
 * @text Starting Icon Index
 * @desc Insert the ID of the icon to show.
 * Tip: Right click > Insert Icon Index
 * @default 0
 *
 * @arg endIcon:num
 * @text Ending Icon Index
 * @desc Insert the ID of the icon to show.
 * Tip: Right click > Insert Icon Index
 * @default 0
 *
 * @arg WaitComplete:eval
 * @text Wait for Completion
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait for balloon animation completion before continuing?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_BalloonIconSpecific
 * @text ANIM: Balloon Icon (Specific)
 * @desc Plays a balloon animation with specific icons on target(s).
 * Requires VisuMZ_4_IconBalloons!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["user"]
 *
 * @arg icons:arraynum
 * @text Icons
 * @type string[]
 * @desc Insert the ID(s) of the icon to show.
 * Tip: Right click > Insert Icon Index
 * @default []
 *
 * @arg WaitComplete:eval
 * @text Wait for Completion
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait for balloon animation completion before continuing?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_CastAnimation
 * @text ANIM: Cast Animation
 * @desc Plays the cast animation associated with the action.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["user"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ChangeBattlePortrait
 * @text ANIM: Change Battle Portrait
 * @desc Changes the battle portrait of the actor (if it's an actor).
 * Can be used outside of battle/action sequences.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to change the portraits for.
 * Valid units can only be actors.
 * @default ["user"]
 * 
 * @arg Filename:str
 * @text Filename
 * @type file
 * @dir img/pictures/
 * @desc Select the file to change the actor's portrait to.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ChangeBattlePortrait_JS
 * @text ANIM: Change Battle Portrait (JS)
 * @desc Changes the battle portrait of the actor through JavaScript.
 * Can be used outside of battle/action sequences.
 *
 * @arg ActorJS:func
 * @text JS: Actor ID
 * @type note
 * @desc Enter which Actor ID to affect.
 * Uses JavaScript code.
 * @default "// Get Actor ID here.\nlet actorID = 0;\nactorID = $gameParty.members()[0].actorId();\n\n// Return Actor ID\nreturn actorID;"
 *
 * @arg FilenameJS:func
 * @text JS: Filename
 * @type note
 * @desc Enter the filename you wish to use.
 * Uses JavaScript code.
 * @default "// Get Filename here.\nlet filename = 'Actor1_';\nfilename += String(Math.randomInt(8) + 1);\n\n// Return Filename\nreturn filename;"
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_GuardAnimation
 * @text ANIM: Guard Animation
 * @desc Plays the animation associated with the user's guard action (if any).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ItemAnimation
 * @text ANIM: Item Animation
 * @desc Plays the animation associated with a specific item.
 * 
 * @arg ItemID:eval
 * @text Item ID
 * @type item
 * @desc Which item ID will the animation come from?
 * @default 7
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_PlayAtCoordinate
 * @text ANIM: Play at Coordinate
 * @desc Plays an animation on the screen at a specific x, y coordinate.
 * Requires VisuMZ_0_CoreEngine!
 *
 * @arg AnimationID:num
 * @text Animation ID
 * @parent Animation
 * @type animation
 * @desc Plays this animation.
 * @default 1
 * 
 * @arg Coordinates
 *
 * @arg pointX:eval
 * @text X
 * @parent Coordinates
 * @desc X coordinate used for the animation.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 *
 * @arg pointY:eval
 * @text Y
 * @parent Coordinates
 * @desc Y coordinate used for the animation.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 *
 * @arg Mirror:eval
 * @text Mirror Animation?
 * @parent Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 *
 * @arg Mute:eval
 * @text Mute Animation?
 * @parent Animation
 * @type boolean
 * @on Mute
 * @off Normal
 * @desc Mute the animation?
 * @default false
 *
 * @arg WaitComplete:eval
 * @text Wait for Completion?
 * @parent Animation
 * @type boolean
 * @on Wait
 * @off Normal
 * @desc Wait the animation to finish before continuing?
 * @default false
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ShowAnimation
 * @text ANIM: Show Animation
 * @desc Plays the a specific animation on unit(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg AnimationID:num
 * @text Animation ID
 * @type animation
 * @desc Select which animation to play on unit(s).
 * @default 1
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ShowAnimationJS
 * @text ANIM: Show Animation JS
 * @desc Plays the a specific animation on unit(s).
 * Uses JavaScript to determine animation ID.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg AnimationID:eval
 * @text JS: Animation ID
 * @desc Select which animation to play on unit(s).
 * Uses JavaScript to determine animation ID.
 * @default 1
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_SkillAnimation
 * @text ANIM: Skill Animation
 * @desc Plays the animation associated with a specific skill.
 * 
 * @arg SkillID:eval
 * @text Skill ID
 * @type skill
 * @desc Which skill ID will the animation come from?
 * @default 99
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_WaitForAnimation
 * @text ANIM: Wait For Animation
 * @desc Causes the interpreter to wait for any animation(s) to finish.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceBattleLog
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakBattleLog
 * @text Action Sequences - Battle Log
 * @desc These Action Sequences are related to the Battle Log Window,
 * the window found at the top of the battle screen.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_AddText
 * @text BTLOG: Add Text
 * @desc Adds a new line of text into the Battle Log.
 * 
 * @arg Text:str
 * @text Text
 * @desc Add this text into the Battle Log.
 * Text codes allowed.
 * @default Insert text here.
 * 
 * @arg CopyCombatLog:eval
 * @text Copy to Combat Log?
 * @type boolean
 * @on Copy Text
 * @off Don't Copy
 * @desc Copies text to the Combat Log.
 * Requires VisuMZ_4_CombatLog
 * @default true
 *
 * @arg CombatLogIcon:num
 * @text Combat Log Icon
 * @parent CopyCombatLog:eval
 * @desc What icon would you like to bind to this entry?
 * Requires VisuMZ_4_CombatLog
 * @default 87
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_Clear
 * @text BTLOG: Clear Battle Log
 * @desc Clears all the text in the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_DisplayAction
 * @text BTLOG: Display Action
 * @desc Displays the current action in the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_PopBaseLine
 * @text BTLOG: Pop Base Line
 * @desc Removes the Battle Log's last added base line and 
 * all text up to its former location.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_PushBaseLine
 * @text BTLOG: Push Base Line
 * @desc Adds a new base line to where the Battle Log currently is at.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_Refresh
 * @text BTLOG: Refresh Battle Log
 * @desc Refreshes the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_UI
 * @text BTLOG: UI Show/Hide
 * @desc Shows or hides the Battle UI (including the Battle Log).
 * 
 * @arg ShowHide:eval
 * @text Show/Hide?
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Shows/hides the Battle UI.
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_WaitForBattleLog
 * @text BTLOG: Wait For Battle Log
 * @desc Causes the interpreter to wait for the Battle Log to finish.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_WaitForNewLine
 * @text BTLOG: Wait For New Line
 * @desc Causes the interpreter to wait for a new line in the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceCamera
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakCamera
 * @text Action Sequences - Camera
 * @desc Allows you to have control over the camera.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_Clamp
 * @text CAMERA: Clamp ON/OFF
 * @desc Turns battle camera clamping on/off.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Setting:eval
 * @text ON/OFF
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Turns camera clamping on/off.
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_FocusPoint
 * @text CAMERA: Focus Point
 * @desc Focus the battle camera on a certain point in the screen.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg FocusX:eval
 * @text X Coordinate
 * @desc Insert the point to focus the camera on.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @arg FocusY:eval
 * @text Y Coordinate
 * @desc Insert the point to focus the camera on.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for camera focus change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_FocusTarget
 * @text CAMERA: Focus Target(s)
 * @desc Focus the battle camera on certain battler target(s).
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to focus the battle camera on.
 * @default ["user"]
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for camera focus change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_Offset
 * @text CAMERA: Offset
 * @desc Offset the battle camera from the focus target.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg OffsetX:eval
 * @text Offset X
 * @desc How much to offset the camera X by.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @arg OffsetY:eval
 * @text Offset Y
 * @desc How much to offset the camera Y by.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for offset change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_Reset
 * @text CAMERA: Reset
 * @desc Reset the battle camera settings.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg ResetFocus:eval
 * @text Reset Focus?
 * @type boolean
 * @on On
 * @off Off
 * @desc Reset the focus point?
 * @default true
 * 
 * @arg ResetOffset:eval
 * @text Reset Offset?
 * @type boolean
 * @on On
 * @off Off
 * @desc Reset the camera offset?
 * @default true
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for reset change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_WaitForCamera
 * @text CAMERA: Wait For Camera
 * @desc Waits for camera to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceCutin
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakCutin
 * @text Action Sequences - Cutins
 * @desc Allows you to have control over Visual Cutin Effects.
 * Requires VisuMZ_3_VisualCutinEffect!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Cutin_AddVisualCutinEffect
 * @text CUTIN: Add Visual Cutin Effect
 * @desc Adds the Visual Cutin Effect using these desired settings.
 * Requires VisuMZ_3_VisualCutinEffect!
 * 
 * @arg Basic
 * @text Basic Settings
 * 
 * @arg type:str
 * @text Cutin Style Type
 * @parent Basic
 * @type select
 * @option -
 * @option Whole
 * @option -
 * @option Showcase
 * @option -
 * @option LeftHorzSpan
 * @option CenterHorzSpan
 * @option RightHorzSpan
 * @option -
 * @option LeftHorzSlash
 * @option RightHorzSlash
 * @option -
 * @option LeftVertSlash
 * @option RightVertSlash
 * @option -
 * @option LeftMajor
 * @option RightMajor
 * @option -
 * @option LeftMinor
 * @option CenterMinor
 * @option RightMinor
 * @option -
 * @option LeftDiamond
 * @option CenterDiamond
 * @option RightDiamond
 * @option -
 * @option LeftGemstone
 * @option CenterGemstone
 * @option RightGemstone
 * @option -
 * @option TopLeftQuad
 * @option TopRightQuad
 * @option BottomLeftQuad
 * @option BottomRightQuad
 * @option -
 * @option TopLeftCorner
 * @option TopRightCorner
 * @option BottomLeftCorner
 * @option BottomRightCorner
 * @option -
 * @option Row1stThird
 * @option Row2ndThird
 * @option Row3rdThird
 * @option -
 * @option Row1stFourth
 * @option Row2ndFourth
 * @option Row3rdFourth
 * @option Row4thFourth
 * @option -
 * @option Row1stFifth
 * @option Row2ndFifth
 * @option Row3rdFifth
 * @option Row4thFifth
 * @option Row5thFifth
 * @option -
 * @option Col1stThird
 * @option Col2ndThird
 * @option Col3rdThird
 * @option -
 * @option Col1stFourth
 * @option Col2ndFourth
 * @option Col3rdFourth
 * @option Col4thFourth
 * @option -
 * @option Col1stFifth
 * @option Col2ndFifth
 * @option Col3rdFifth
 * @option Col4thFifth
 * @option Col5thFifth
 * @option -
 * @option SixPack1
 * @option SixPack2
 * @option SixPack3
 * @option SixPack4
 * @option SixPack5
 * @option SixPack6
 * @option -
 * @option EightPack1
 * @option EightPack2
 * @option EightPack3
 * @option EightPack4
 * @option EightPack5
 * @option EightPack6
 * @option EightPack7
 * @option EightPack8
 * @option -
 * @option TwelvePack1
 * @option TwelvePack2
 * @option TwelvePack3
 * @option TwelvePack4
 * @option TwelvePack5
 * @option TwelvePack6
 * @option TwelvePack7
 * @option TwelvePack8
 * @option TwelvePack9
 * @option TwelvePack10
 * @option TwelvePack11
 * @option TwelvePack12
 * @option -
 * @desc What Visual Cutin Effect style type do you wish to use?
 * Only one of each cutin-style type can be present.
 * @default CenterHorzSpan
 * 
 * @arg Targets:arraystr
 * @text Portrait Target
 * @parent Basic
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to grab the Visual Cutin Effect portrait
 * data from. First unit will be used to make portrait.
 * @default ["user"]
 *
 * @arg parallaxFilename:str
 * @text Parallax Filename
 * @parent Basic
 * @type file
 * @dir img/parallaxes/
 * @require 1
 * @desc Pick a parallax to use for the Visual Cutin Effect.
 * Pick (None) to not use a parallax.
 * @default >>>ATTENTION<<<
 *
 * @arg bgColor:str
 * @text Background Color
 * @parent Basic
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default #888888
 *
 * @arg ExtraSettings:struct
 * @text Extra Settings
 * @type struct<VisualCutinEffect>
 * @desc Extra Plugin Command settings pertaining to this Visual Cutin Effect.
 * @default {}
 * 
 * @arg WaitForEntrance:eval
 * @text Wait For Entrance
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait until cutin entrance is finished before performing
 * the next event command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Cutin_EndVisualCutinEffectAll
 * @text CUTIN: End Visual Cutin Effect (All)
 * @desc Ends all Visual Cutin Effects currently present.
 * Requires VisuMZ_3_VisualCutinEffect!
 * 
 * @arg WaitForExit:eval
 * @text Wait For Exit
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait until cutin exit is finished before performing
 * the next event command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Cutin_EndVisualCutinEffectType
 * @text CUTIN: End Visual Cutin Effect (Type)
 * @desc Ends the Visual Cutin Effect with the matching type.
 * Requires VisuMZ_3_VisualCutinEffect!
 * 
 * @arg type:str
 * @text Cutin Style Type
 * @type select
 * @option -
 * @option Whole
 * @option -
 * @option Showcase
 * @option -
 * @option LeftHorzSpan
 * @option CenterHorzSpan
 * @option RightHorzSpan
 * @option -
 * @option LeftHorzSlash
 * @option RightHorzSlash
 * @option -
 * @option LeftVertSlash
 * @option RightVertSlash
 * @option -
 * @option LeftMajor
 * @option RightMajor
 * @option -
 * @option LeftMinor
 * @option CenterMinor
 * @option RightMinor
 * @option -
 * @option LeftDiamond
 * @option CenterDiamond
 * @option RightDiamond
 * @option -
 * @option LeftGemstone
 * @option CenterGemstone
 * @option RightGemstone
 * @option -
 * @option TopLeftQuad
 * @option TopRightQuad
 * @option BottomLeftQuad
 * @option BottomRightQuad
 * @option -
 * @option TopLeftCorner
 * @option TopRightCorner
 * @option BottomLeftCorner
 * @option BottomRightCorner
 * @option -
 * @option Row1stThird
 * @option Row2ndThird
 * @option Row3rdThird
 * @option -
 * @option Row1stFourth
 * @option Row2ndFourth
 * @option Row3rdFourth
 * @option Row4thFourth
 * @option -
 * @option Row1stFifth
 * @option Row2ndFifth
 * @option Row3rdFifth
 * @option Row4thFifth
 * @option Row5thFifth
 * @option -
 * @option Col1stThird
 * @option Col2ndThird
 * @option Col3rdThird
 * @option -
 * @option Col1stFourth
 * @option Col2ndFourth
 * @option Col3rdFourth
 * @option Col4thFourth
 * @option -
 * @option Col1stFifth
 * @option Col2ndFifth
 * @option Col3rdFifth
 * @option Col4thFifth
 * @option Col5thFifth
 * @option -
 * @option SixPack1
 * @option SixPack2
 * @option SixPack3
 * @option SixPack4
 * @option SixPack5
 * @option SixPack6
 * @option -
 * @option EightPack1
 * @option EightPack2
 * @option EightPack3
 * @option EightPack4
 * @option EightPack5
 * @option EightPack6
 * @option EightPack7
 * @option EightPack8
 * @option -
 * @option TwelvePack1
 * @option TwelvePack2
 * @option TwelvePack3
 * @option TwelvePack4
 * @option TwelvePack5
 * @option TwelvePack6
 * @option TwelvePack7
 * @option TwelvePack8
 * @option TwelvePack9
 * @option TwelvePack10
 * @option TwelvePack11
 * @option TwelvePack12
 * @option -
 * @desc What Visual Cutin Effect style type do you wish to end?
 * @default CenterHorzSpan
 * 
 * @arg WaitForExit:eval
 * @text Wait For Exit
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait until cutin exit is finished before performing
 * the next event command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Cutin_WaitForEntrance
 * @text CUTIN: Wait for Cutin Entrance
 * @desc Wait until all cutin entrances are finished before performing the next event command. Requires VisuMZ_3_VisualCutinEffect!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Cutin_WaitForExit
 * @text CUTIN: Wait for Cutin Exit
 * @desc Wait until all cutin exits are finished before performing the next event command. Requires VisuMZ_3_VisualCutinEffect!
 *
 * @ --------------------------------------------------------------------------
 *
 *
 * @command ActionSequenceSpaceDragonbones
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreaDragonbones
 * @text Action Sequences - Dragonbones
 * @desc These Action Sequences are Dragonbones-related.
 * Requires VisuMZ_2_DragonbonesUnion!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_DB_DragonbonesMotionAni
 * @text DB: Dragonbones Animation
 * @desc Causes the unit(s) to play a Dragonbones motion animation.
 * Requires VisuMZ_2_DragonbonesUnion!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to perform a motion animation.
 * @default ["user"]
 *
 * @arg MotionAni:str
 * @text Motion Animation
 * @desc What is the name of the Dragonbones motion animation you wish to play?
 * @default attack
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_DB_DragonbonesTimeScale
 * @text DB: Dragonbones Time Scale
 * @desc Causes the unit(s) to change their Dragonbones time scale.
 * Requires VisuMZ_2_DragonbonesUnion!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to perform a motion animation.
 * @default ["user"]
 *
 * @arg TimeScale:num
 * @text Time Scale
 * @desc Change the value of the Dragonbones time scale to this.
 * @default 1.0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceElements
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakElements
 * @text Action Sequences - Elements
 * @desc These Action Sequences are related to elements.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_AddElements
 * @text ELE: Add Elements
 * @desc Adds element(s) to be used when calculating damage.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @arg Elements:arraynum
 * @text Elements
 * @type number[]
 * @min 1
 * @max 99
 * @desc Select which element ID to add onto the action.
 * Insert multiple element ID's to add multiple at once.
 * @default ["1"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_Clear
 * @text ELE: Clear Element Changes
 * @desc Clears all element changes made through Action Sequences.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_ForceElements
 * @text ELE: Force Elements
 * @desc Forces only specific element(s) when calculating damage.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @arg Elements:arraynum
 * @text Elements
 * @type number[]
 * @min 1
 * @max 99
 * @desc Select which element ID to force in the action.
 * Insert multiple element ID's to force multiple at once.
 * @default ["1"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_NullElements
 * @text ELE: Null Element
 * @desc Forces no element to be used when calculating damage.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceGrid
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakGrid
 * @text Action Sequences - Grid
 * @desc These Action Sequences are Battle Grid System-related.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_ActionAnimationAtNode
 * @text GRID: Action Animation at Node
 * @desc Plays action animation at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit's Node do you want to play an animation on?
 * @default Enemy
 *
 * @arg Rank:num
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Rank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg Flank:num
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Flank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg OffsetX:num
 * @text Offset X
 * @desc Offsets the animation x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @arg OffsetY:num
 * @text Offset Y
 * @desc Offsets the animation y position.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_AddPassiveStatesToNode
 * @text GRID: Add Passive State(s) to Node
 * @desc Adds Passive State(s) at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg StateIDs:arraynum
 * @text State ID(s)
 * @type state[]
 * @desc Select which State ID(s) to add as a Passive State.
 * @default []
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to add the Passive State Node
 * effect for?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to add a Passive State(s) to.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to add a Passive State(s) to.
 * @default 1
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_AddTriggerToNode
 * @text GRID: Add Trigger to Node
 * @desc Adds Trigger to target node. Target node cannot have battler.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg SkillID:num
 * @text Skill ID
 * @type skill
 * @desc Select which Skill ID(s) to add as the trigger.
 * @default 1
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to add the Trigger Node
 * effect for?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to add a Trigger to.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to add a Trigger to.
 * @default 1
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_AddTriggerToNodeJS
 * @text GRID: Add Trigger to Node JS
 * @desc Adds Trigger to target node. Target node cannot have battler.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg SkillID:eval
 * @text JS: Skill ID
 * @desc Use JavaScript to determine what skill ID to add to this node.
 * @default 1
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to add the Trigger Node
 * effect for?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to add a Trigger to.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to add a Trigger to.
 * @default 1
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_AnimationIDAtNode
 * @text GRID: Animation ID at Node
 * @desc Plays specific animation ID at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg AnimationID:num
 * @text Animation ID
 * @type animation
 * @desc Play this animation at target node.
 * @default 1
 *
 * @arg Mirror:eval
 * @text Mirror?
 * @parent AnimationID:num
 * @type boolean
 * @on Mirror Animation
 * @off Don't Mirror
 * @desc Mirror this animation?
 * @default false
 *
 * @arg Mute:eval
 * @text Mute?
 * @parent AnimationID:num
 * @type boolean
 * @on Mute Animation
 * @off Don't Mute
 * @desc Mute this animation?
 * @default false
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit's Node do you want to play an animation on?
 * @default Enemy
 *
 * @arg Rank:num
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Rank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg Flank:num
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Flank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg OffsetX:num
 * @text Offset X
 * @desc Offsets the animation x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @arg OffsetY:num
 * @text Offset Y
 * @desc Offsets the animation y position.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_AnimationJsAtNode
 * @text GRID: Animation JS at Node
 * @desc Uses JS to calculate which animation to play at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 * 
 * @arg AnimationID:eval
 * @text JS: Animation ID
 * @desc Calculate which animation to play on unit(s).
 * Uses JavaScript to determine animation ID.
 * @default 1
 *
 * @arg Mirror:eval
 * @text Mirror?
 * @parent AnimationID:eval
 * @type boolean
 * @on Mirror Animation
 * @off Don't Mirror
 * @desc Mirror this animation?
 * @default false
 *
 * @arg Mute:eval
 * @text Mute?
 * @parent AnimationID:eval
 * @type boolean
 * @on Mute Animation
 * @off Don't Mute
 * @desc Mute this animation?
 * @default false
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit's Node do you want to play an animation on?
 * @default Enemy
 *
 * @arg Rank:num
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Rank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg Flank:num
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Flank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg OffsetX:num
 * @text Offset X
 * @desc Offsets the animation x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @arg OffsetY:num
 * @text Offset Y
 * @desc Offsets the animation y position.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_AnimationTypeAtNode
 * @text GRID: Animation Type at Node
 * @desc Plays certain animation type at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg Type:str
 * @text Animation Type
 * @type select
 * @option Attack
 * @option Guard
 * @option Item
 * @option Skill
 * @desc What is the animation type you would like to play?
 * @default Attack
 * 
 * @arg Slot:eval
 * @text Slot (Attack Type)
 * @parent Type:str
 * @desc Which weapon slot to get this data from?
 * Main-hand weapon is weapon slot 1.
 * @default 1
 * 
 * @arg ItemID:num
 * @text Item ID (Item Type)
 * @parent Type:str
 * @type item
 * @desc Which item ID will the animation come from?
 * @default 7
 * 
 * @arg SkillID:num
 * @text Skill ID (Skill Type)
 * @parent Type:str
 * @type skill
 * @desc Which skill ID will the animation come from?
 * @default 99
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit's Node do you want to play an animation on?
 * @default Enemy
 *
 * @arg Rank:num
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Rank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg Flank:num
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Flank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg OffsetX:num
 * @text Offset X
 * @desc Offsets the animation x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @arg OffsetY:num
 * @text Offset Y
 * @desc Offsets the animation y position.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_MoveTargetsInDirection
 * @text GRID: Move Target(s) In Direction
 * @desc Moves target(s) in a specific direction to other Nodes.
 * Requires VisuMZ_2_BattleGridSystem!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to move.
 * @default ["all targets"]
 * 
 * @arg MoveType:str
 * @text Movement Type
 * @type select
 * @option -
 * @option Exact
 * @option -
 * @option Mid
 * @option -
 * @option Switch
 * @option Switch Mid
 * @option -
 * @option Crash
 * @option Crash Mid
 * @option -
 * @desc Select the Movement type rulings.
 * See VisuMZ_2_BattleGridSystem help file for details.
 * @default Mid
 * 
 * @arg Direction:str
 * @text Direction
 * @parent MoveType:str
 * @type select
 * @option -
 * @option Upward
 * @option Downward
 * @option -
 * @option Up-Forward
 * @option Forward
 * @option Down-Forward
 * @option -
 * @option Up-Backward
 * @option Backward
 * @option Down-Backward
 * @option -
 * @option Up-Leftward
 * @option Leftward
 * @option Down-Leftward
 * @option -
 * @option Up-Rightward
 * @option Rightward
 * @option Down-Rightward
 * @option -
 * @desc Select the movement direction.
 * @default Backward
 *
 * @arg Distance:eval
 * @text Distance
 * @parent MoveType:str
 * @desc The number of nodes to be moved.
 * You may use JavaScript code.
 * @default 1
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Input the number representing the frames used to move.
 * @default 12
 *
 * @arg SilentMove:eval
 * @text Silent Change?
 * @type boolean
 * @on Silent
 * @off Visual
 * @desc Silent: Discreet changes shown. More apparent later.
 * Visual: Instant changes shown.
 * @default false
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_PullToTargetNode
 * @text GRID: Pull To Target Node
 * @desc Pulls battlers towards target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to pull on?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to pull to.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to pull to.
 * @default 1
 *
 * @arg Strength:eval
 * @text Strength
 * @desc Input the strength level of the pull.
 * @default 1
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Input the number representing the frames used to move.
 * @default 12
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_PushFromTargetNode
 * @text GRID: Push From Target Node
 * @desc Pushes battlers away from target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to push from?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to push from.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to push from.
 * @default 1
 *
 * @arg Strength:eval
 * @text Strength
 * @desc Input the strength level of the push.
 * @default 1
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Input the number representing the frames used to move.
 * @default 12
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_ClearPassiveStatesFromNode
 * @text GRID: Remove All Passive States from Node
 * @desc Removes all all Passive State effects at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to clear the Node for?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to clear Passive States from.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to clear Passive States from.
 * @default 1
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_RemovePassiveStatesFromNode
 * @text GRID: Remove Passive State(s) from Node
 * @desc Remove Passive State(s) at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg StateIDs:arraynum
 * @text State ID(s)
 * @type state[]
 * @desc Select which State ID(s) to remove as a Passive State.
 * @default []
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to remove the Passive State Node
 * effect for?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to remove a Passive State(s) from.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to remove a Passive State(s) from.
 * @default 1
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_RemoveTriggerFromNode
 * @text GRID: Remove Trigger from Node
 * @desc Removes Trigger from target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to clear Triggers for?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to clear Triggers from.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to clear Triggers from.
 * @default 1
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_TeleportToNode
 * @text GRID: Teleport To Node
 * @desc Teleports user/random opponent to target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to teleport to?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to teleport to.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to teleport.
 * @default 1
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_TraverseToNode
 * @text GRID: Traverse To Node
 * @desc Traverses user/random opponent to target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to traverse to?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to traverse to.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to traverse.
 * @default 1
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Input the number representing the frames used to move.
 * @default 12
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceHorror
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakHorror
 * @text Action Sequences - Horror Effects
 * @desc These Action Sequences are Horror Effects-related.
 * Requires VisuMZ_2_HorrorEffects!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_Clear
 * @text HORROR: Clear All Filters
 * @desc Clear all Horror Effects filters on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to remove Horror Effects for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_GlitchCreate
 * @text HORROR: Glitch Create
 * @desc Creates the glitch effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create the Horror Effect for.
 * @default ["user"]
 *
 * @arg slices:num
 * @text Glitch Slices
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc Glitch slices to be used with the target.
 * @default 10
 *
 * @arg offset:num
 * @text Glitch Offset
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc Default offset value.
 * @default 100
 *
 * @arg animated:eval
 * @text Glitch Animated?
 * @parent FilterGlitch
 * @type boolean
 * @on Animate
 * @off Static
 * @desc Animate the glitch effect?
 * @default true
 *
 * @arg aniFrequency:num
 * @text Glitch Frequency
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc If animated, how frequent to make the glitch effect?
 * Lower = often     Higher = rarer
 * @default 300
 *
 * @arg aniStrength:num
 * @text Glitch Strength
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc If animated, how strong is the glitch effect?
 * Lower = weaker     Higher = stronger
 * @default 30
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_GlitchRemove
 * @text HORROR: Glitch Remove
 * @desc Removes the glitch effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to remove the Horror Effect for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_NoiseCreate
 * @text HORROR: Noise Create
 * @desc Creates the noise effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create the Horror Effect for.
 * @default ["user"]
 *
 * @arg noise:num
 * @text Noise Rate
 * @parent FilterNoise
 * @desc Noise rate to be used with the target.
 * @default 0.3
 *
 * @arg animated:eval
 * @text Noise Animated
 * @parent FilterNoise
 * @type boolean
 * @on Animate
 * @off Static
 * @desc Animate the noise for the target?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_NoiseRemove
 * @text HORROR: Noise Remove
 * @desc Removes the noise effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to remove the Horror Effect for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_TVCreate
 * @text HORROR: TV Create
 * @desc Creates the TV effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create the Horror Effect for.
 * @default ["user"]
 *
 * @arg lineWidth:num
 * @text TV Line Thickness
 * @parent FilterTV
 * @type number
 * @min 1
 * @desc Default TV line thickness
 * Lower = thinner     Higher = thicker
 * @default 5
 *
 * @arg vignetting:num
 * @text TV Corner Size
 * @parent FilterTV
 * @desc Default TV line corner size
 * Lower = smaller     Higher = bigger
 * @default 0.3
 *
 * @arg animated:eval
 * @text TV Animated
 * @parent FilterTV
 * @type boolean
 * @on Animate
 * @off Static
 * @desc Animate the TV?
 * @default true
 *
 * @arg aniSpeed:num
 * @text TV Speed
 * @parent FilterTV
 * @desc Speed used to animate the TV if animated
 * Lower = slower     Higher = faster
 * @default 0.25
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_TVRemove
 * @text HORROR: TV Remove
 * @desc Removes the TV effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to remove the Horror Effect for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceImpact
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakImpact
 * @text Action Sequences - Impact
 * @desc These Action Sequences are related to creating impact.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_BlueRedInvert
 * @text IMPACT: Bizarro Inversion
 * @desc Swaps blue/red colors on the battlefield.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @arg Enable:eval
 * @text Bizarro?
 * @type boolean
 * @on Enable / Bizarro
 * @off Disable / Normal
 * @desc Enable Bizarro Inversion effect?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ColorBreak
 * @text IMPACT: Color Break
 * @desc Breaks the colors on the screen before reassembling.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Intensity:eval
 * @text Intensity
 * @desc What is the intensity of the color break effect?
 * @default 60
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the color break effect?
 * @default 60
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default OutBack
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_Desaturate
 * @text IMPACT: Desaturation
 * @desc Desaturates all colors on the battlefield.
 * Requires VisuMZ_3_ActSeqImpact! Created by Manu Gaming!
 *
 * @arg Enable:eval
 * @text Desaturate?
 * @type boolean
 * @on Enable / Desaturate
 * @off Disable / Normal
 * @desc Enable Desaturation effect?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionBlurScreen
 * @text IMPACT: Motion Blur Screen
 * @desc Creates a motion blur on the whole screen.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @arg Angle:eval
 * @text Angle
 * @desc Determine what angle to make the motion blur at.
 * @default Math.randomInt(360)
 *
 * @arg Rate:eval
 * @text Intensity Rate
 * @desc This determines intensity rate of the motion blur.
 * Use a number between 0 and 1.
 * @default 0.1
 *
 * @arg Duration:num
 * @text Duration
 * @type number
 * @min 1
 * @desc How many frames should the motion blur last?
 * What do you want to be its duration?
 * @default 30
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default InOutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionBlurTarget
 * @text IMPACT: Motion Blur Target(s)
 * @desc Creates a motion blur on selected target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create motion blur effects for.
 * @default ["user"]
 *
 * @arg Angle:eval
 * @text Angle
 * @desc Determine what angle to make the motion blur at.
 * @default Math.randomInt(360)
 *
 * @arg Rate:eval
 * @text Intensity Rate
 * @desc This determines intensity rate of the motion blur.
 * Use a number between 0 and 1.
 * @default 0.5
 *
 * @arg Duration:num
 * @text Duration
 * @type number
 * @min 1
 * @desc How many frames should the motion blur last?
 * What do you want to be its duration?
 * @default 30
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default InOutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionTrailCreate
 * @text IMPACT: Motion Trail Create
 * @desc Creates a motion trail effect for the target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create motion trail effects for.
 * @default ["user"]
 *
 * @arg delay:num
 * @text Delay
 * @type number
 * @min 1
 * @desc How many frames to delay by when creating a motion trail?
 * The higher the delay, the less after images there are.
 * @default 1
 *
 * @arg duration:num
 * @text Duration
 * @type number
 * @min 1
 * @desc How many frames should the motion trail last?
 * What do you want to be its duration?
 * @default 30
 *
 * @arg hue:num
 * @text Hue
 * @type number
 * @min 0
 * @max 360
 * @desc What do you want to be the hue for the motion trail?
 * @default 0
 *
 * @arg opacityStart:num
 * @text Starting Opacity
 * @type number
 * @min 0
 * @max 255
 * @desc What starting opacity value do you want for the motion
 * trail? Opacity values decrease over time.
 * @default 200
 *
 * @arg tone:eval
 * @text Tone
 * @desc What tone do you want for the motion trail?
 * Format: [Red, Green, Blue, Gray]
 * @default [0, 0, 0, 0]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionTrailRemove
 * @text IMPACT: Motion Trail Remove
 * @desc Removes the motion trail effect from the target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to clear motion trail effects for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_Negative
 * @text IMPACT: Negative Inversion
 * @desc Inverts all the colors on the battlefield.
 * Requires VisuMZ_3_ActSeqImpact! Created by Manu Gaming!
 *
 * @arg Enable:eval
 * @text Negative?
 * @type boolean
 * @on Enable / Negative
 * @off Disable / Normal
 * @desc Enable negative inversion effect?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_Oversaturate
 * @text IMPACT: Oversaturation
 * @desc Oversaturates colors on the battlefield.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @arg Enable:eval
 * @text Oversaturate?
 * @type boolean
 * @on Enable / Oversaturate
 * @off Disable / Normal
 * @desc Enable Oversaturation effect?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ShockwavePoint
 * @text IMPACT: Shockwave at Point
 * @desc Creates a shockwave at the designated coordinates.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Coordinates
 * 
 * @arg X:eval
 * @text Point: X
 * @parent Coordinates
 * @desc What x coordinate do you want to create a shockwave at?
 * You can use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @arg Y:eval
 * @text Point: Y
 * @parent Coordinates
 * @desc What y coordinate do you want to create a shockwave at?
 * You can use JavaScript code.
 * @default (Graphics.height - 200) / 2
 * 
 * @arg Amp:eval
 * @text Amplitude
 * @desc What is the aplitude of the shockwave effect?
 * @default 30
 * 
 * @arg Wave:eval
 * @text Wavelength
 * @desc What is the wavelength of the shockwave effect?
 * @default 160
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the shockwave?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ShockwaveEachTargets
 * @text IMPACT: Shockwave from Each Target(s)
 * @desc Creates a shockwave at each of the target(s) location(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to start a shockwave from.
 * @default ["all targets"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to start a shockwave from.
 * @default middle center
 * 
 * @arg OffsetX:eval
 * @text Offset X
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave X point by.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @arg OffsetY:eval
 * @text Offset Y
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave Y point by.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @arg Amp:eval
 * @text Amplitude
 * @desc What is the aplitude of the shockwave effect?
 * @default 30
 * 
 * @arg Wave:eval
 * @text Wavelength
 * @desc What is the wavelength of the shockwave effect?
 * @default 160
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the shockwave?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ShockwaveCenterTargets
 * @text IMPACT: Shockwave from Target(s) Center
 * @desc Creates a shockwave from the center of the target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to start a shockwave from.
 * @default ["all targets"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to start a shockwave from.
 * @default middle center
 * 
 * @arg OffsetX:eval
 * @text Offset X
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave X point by.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @arg OffsetY:eval
 * @text Offset Y
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave Y point by.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @arg Amp:eval
 * @text Amplitude
 * @desc What is the aplitude of the shockwave effect?
 * @default 30
 * 
 * @arg Wave:eval
 * @text Wavelength
 * @desc What is the wavelength of the shockwave effect?
 * @default 160
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the shockwave?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_TimeScale
 * @text IMPACT: Time Scale
 * @desc Adjust time to go faster or slower!
 * Requires VisuMZ_3_ActSeqImpact! Created by Manu Gaming!
 * 
 * @arg Scale:eval
 * @text Scale
 * @desc Adjusts how fast/slow time goes.
 * 1.00 is normal. Lower is slower. Higher is faster.
 * @default 1.00
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_TimeStop
 * @text IMPACT: Time Stop
 * @desc Stops time for a set amount of milliseconds.
 * Requires VisuMZ_3_ActSeqImpact! Created by Manu Gaming!
 * 
 * @arg ms:eval
 * @text Milliseconds
 * @desc How many milliseconds should time stop for?
 * 1000 milliseconds = 1 second.
 * @default 1000
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ZoomBlurPoint
 * @text IMPACT: Zoom Blur at Point
 * @desc Creates a zoom blur at the designated coordinates.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Coordinates
 * 
 * @arg X:eval
 * @text Point: X
 * @parent Coordinates
 * @desc What x coordinate do you want to focus the zoom at?
 * You can use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @arg Y:eval
 * @text Point: Y
 * @parent Coordinates
 * @desc What y coordinate do you want to focus the zoom at?
 * You can use JavaScript code.
 * @default (Graphics.height - 200) / 2
 * 
 * @arg Strength:eval
 * @text Zoom Strength
 * @desc What is the strength of the zoom effect?
 * Use a number between 0 and 1.
 * @default 0.5
 * 
 * @arg Radius:eval
 * @text Visible Radius
 * @desc How much of a radius should be visible from the center?
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the zoom blur?
 * @default 60
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default OutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ZoomBlurTargetCenter
 * @text IMPACT: Zoom Blur at Target(s) Center
 * @desc Creates a zoom blur at the center of targets.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to start a zoom blur from.
 * @default ["user"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to start a zoom blur from.
 * @default middle center
 * 
 * @arg OffsetX:eval
 * @text Offset X
 * @parent TargetLocation:str
 * @desc How much to offset the zoom blur X point by.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @arg OffsetY:eval
 * @text Offset Y
 * @parent TargetLocation:str
 * @desc How much to offset the zoom blur Y point by.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @arg Strength:eval
 * @text Zoom Strength
 * @desc What is the strength of the zoom effect?
 * Use a number between 0 and 1.
 * @default 0.5
 * 
 * @arg Radius:eval
 * @text Visible Radius
 * @desc How much of a radius should be visible from the center?
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the zoom blur?
 * @default 60
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default OutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceInject
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakInject
 * @text Action Sequences - Inject
 * @desc These Action Sequences are related to injected animations.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Inject_AnimationStart
 * @text INJECT: Animation Begin
 * @desc Injects and plays a whole spritesheet animation.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to inject the animation on.
 * @default ["user"]
 * 
 * @arg Filename:str
 * @text Filename
 * @type file
 * @dir img/sv_actors/
 * @desc Select the animation spritesheet file.
 * Located in the /img/sv_actors/ folder.
 * @default Untitled
 *
 * @arg horzCells:num
 * @text Horizontal Cells
 * @parent Filename:str
 * @type number
 * @min 1
 * @desc How many horizontal cells (or columns) are there?
 * @default 1
 *
 * @arg vertCells:num
 * @text Vertical Cells
 * @parent Filename:str
 * @type number
 * @min 1
 * @desc How many vertical cells (or rows) are there?
 * @default 1
 *
 * @arg frameDelay:num
 * @text Frame Delay
 * @parent Filename:str
 * @type number
 * @min 1
 * @desc How many frames are played inbetween cells?
 * @default 1
 *
 * @arg smooth:eval
 * @text Smooth Bitmap?
 * @parent Filename:str
 * @type boolean
 * @on Smooth
 * @off Pixelated
 * @desc Smooth the spritesheet graphic?
 * @default false
 * 
 * @arg Offset
 *
 * @arg offsetX:eval
 * @text Offset X
 * @parent Offset
 * @desc Offsets the X position of the injected animation.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @arg offsetY:eval
 * @text Offset Y
 * @parent Offset
 * @desc Offsets the Y position of the injected animation.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Inject_AnimationEnd
 * @text INJECT: Animation End
 * @desc Stops and ends any injected animations on target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to stop injected animation(s).
 * @default ["user"]
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Inject_AnimationPauseResume
 * @text INJECT: Animation Pause/Resume
 * @desc Pauses/resumes any injected animations on target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to pause injected animation(s).
 * @default ["user"]
 *
 * @arg pause:eval
 * @text Pause?
 * @parent Filename:str
 * @type boolean
 * @on Pause
 * @off Resume
 * @desc Pause the injected animation?
 * @default true
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Inject_WaitForInjectAni
 * @text INJECT: Wait For Injected Animation
 * @desc Waits for injected animations to complete before performing
 * next command. Requires VisuMZ_3_ActSeqImpact!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceMechanics
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakMechanics
 * @text Action Sequences - Mechanics
 * @desc These Action Sequences are related to various mechanics
 * related to the battle system.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_ActionEffect
 * @text MECH: Action Effect
 * @desc Causes the unit(s) to take damage/healing from action and
 * incurs any changes made such as buffs and states.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_ActiveChainInputDisable
 * @text MECH: Active Chain Input Disable
 * @desc Disables input for Active Chain Skills at this time.
 * Requires VisuMZ_3_ActiveChainSkills!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AddBuffDebuff
 * @text MECH: Add Buff/Debuff
 * @desc Adds buff(s)/debuff(s) to unit(s). 
 * Determine which parameters are affected and their durations.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the buff(s) and/or debuff(s).
 * @default ["user"]
 * 
 * @arg Buffs:arraystr
 * @text Buff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which parameter(s) to buff.
 * Insert a parameter multiple times to raise its stacks.
 * @default ["ATK"]
 *
 * @arg Debuffs:arraystr
 * @text Debuff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which parameter(s) to debuff.
 * Insert a parameter multiple times to raise its stacks.
 * @default ["DEF"]
 * 
 * @arg Turns:eval
 * @text Turns
 * @desc Number of turns to set the parameter(s) buffs to.
 * You may use JavaScript code.
 * @default 5
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AddState
 * @text MECH: Add State
 * @desc Adds state(s) to unit(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the buff(s).
 * @default ["user"]
 * 
 * @arg States:arraynum
 * @text States
 * @type state[]
 * @desc Select which state ID(s) to add to unit(s).
 * Insert multiple state ID's to add multiple at once.
 * @default ["4"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AnalyzeWeakness
 * @text MECH: Analyze Weakness
 * @desc Reveal elemental weakness(es) from target(s).
 * Requires VisuMZ_3_WeaknessDisplay!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to reveal elemental weaknesses for.
 * @default ["all targets"]
 * 
 * @arg Reveal:eval
 * @text Reveal
 * @desc How many elemental weaknesses do you wish to reveal?
 * You may use JavaScript code.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_ArmorPenetration
 * @text MECH: Armor Penetration
 * @desc Adds an extra layer of defensive penetration/reduction.
 * You may use JavaScript code for any of these.
 *
 * @arg ArmorPenetration
 * @text Armor/Magic Penetration
 * 
 * @arg ArPenRate:eval
 * @text Rate
 * @parent ArmorPenetration
 * @desc Penetrates an extra multiplier of armor by this value.
 * @default 0.00
 * 
 * @arg ArPenFlat:eval
 * @text Flat
 * @parent ArmorPenetration
 * @desc Penetrates a flat amount of armor by this value.
 * @default 0
 *
 * @arg ArmorReduction
 * @text Armor/Magic Reduction
 * 
 * @arg ArRedRate:eval
 * @text Rate
 * @parent ArmorReduction
 * @desc Reduces an extra multiplier of armor by this value.
 * @default 0.00
 * 
 * @arg ArRedFlat:eval
 * @text Flat
 * @parent ArmorReduction
 * @desc Reduces a flat amount of armor by this value.
 * @default 0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AtbGauge
 * @text MECH: ATB Gauge
 * @desc Alters the ATB/TPB Gauges.
 * Requires VisuMZ_2_BattleSystemATB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the ATB/TPB Gauges for.
 * @default ["all targets"]
 *
 * @arg Charging
 * 
 * @arg ChargeRate:eval
 * @text Charge Rate
 * @parent Charging
 * @desc Changes made to the ATB Gauge if it is currently charging.
 * @default -0.00
 * 
 * @arg Casting
 * 
 * @arg CastRate:eval
 * @text Cast Rate
 * @parent Casting
 * @desc Changes made to the ATB Gauge if it is currently casting.
 * @default -0.00
 * 
 * @arg Interrupt:eval
 * @text Interrupt?
 * @parent Casting
 * @type boolean
 * @on Interrupt
 * @off Don't Interrupt
 * @desc Interrupt the ATB Gauge if it is currently casting?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BoostPointsChange
 * @text MECH: Boost Points Change
 * @desc Changes Boost Points for target(s).
 * Requires VisuMZ_3_BoostAction!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the Boost Points for.
 * @default ["user"]
 * 
 * @arg BoostPoints:eval
 * @text Alter Boost Points By
 * @desc Alters the unit(s) Boost Points.
 * Positive for gaining points. Negative for losing points.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BoostPointsStoreData
 * @text MECH: Boost Store Data
 * @desc Stores the number of Boosts used this action inside a variable.
 * Requires VisuMZ_3_BoostAction!
 * 
 * @arg VariableID:num
 * @text Variable ID
 * @type variable
 * @desc Which variable do you want to store the data inside?
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BreakShieldChange
 * @text MECH: Break Shield Change
 * @desc Changes Break Shields for target(s) if not Break Stunned.
 * Requires VisuMZ_4_BreakShields!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the Break Shields for.
 * @default ["all targets"]
 * 
 * @arg BreakShields:eval
 * @text Alter Break Shields By
 * @desc Alters the unit(s) Break Shields.
 * Positive for gaining shields. Negative for losing shields.
 * @default -1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BreakShieldReset
 * @text MECH: Break Shield Reset
 * @desc Resets Break Shields for target(s) if not Break Stunned.
 * Requires VisuMZ_4_BreakShields!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to reset the Break Shields for.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BtbGain
 * @text MECH: BTB Brave Points
 * @desc Alters the target(s) Brave Points to an exact value.
 * Requires VisuMZ_2_BattleSystemBTB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the ATB/TPB Gauges for.
 * @default ["all targets"]
 * 
 * @arg BravePoints:eval
 * @text Alter Brave Points By
 * @desc Alters the target(s) Brave Points.
 * Positive for gaining BP. Negative for losing BP.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_Collapse
 * @text MECH: Collapse
 * @desc Causes the unit(s) to perform its collapse animation
 * if the unit(s) has died.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to process a death collapse.
 * @default ["all targets"]
 * 
 * @arg ForceDeath:eval
 * @text Force Death
 * @type boolean
 * @on On
 * @off Off
 * @desc Force death even if the unit has not reached 0 HP?
 * This will remove immortality.
 * @default false
 * 
 * @arg WaitForEffect:eval
 * @text Wait For Effect?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for the collapse effect to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_CtbOrder
 * @text MECH: CTB Order
 * @desc Alters the CTB Turn Order.
 * Requires VisuMZ_2_BattleSystemCTB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the CTB Turn Order for.
 * @default ["all targets"]
 *
 * @arg ChangeOrderBy:eval
 * @text Change Order By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_CtbSpeed
 * @text MECH: CTB Speed
 * @desc Alters the CTB Speed.
 * Requires VisuMZ_2_BattleSystemCTB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the CTB Speed for.
 * @default ["all targets"]
 *
 * @arg ChargeRate:eval
 * @text Charge Rate
 * @parent Charging
 * @desc Changes made to the CTB Speed if it is currently charging.
 * @default -0.00
 * 
 * @arg CastRate:eval
 * @text Cast Rate
 * @parent Casting
 * @desc Changes made to the CTB Speed if it is currently casting.
 * @default -0.00
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_CustomDmgFormula
 * @text MECH: Custom Damage Formula
 * @desc Changes the current action's damage formula to custom.
 * This will assume the MANUAL damage style.
 * 
 * @arg Formula:str
 * @text Formula
 * @desc Changes the current action's damage formula to custom.
 * Use 'default' to revert the damage formula.
 * @default default
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_DamagePopup
 * @text MECH: Damage Popup
 * @desc Causes the unit(s) to display the current state of
 * damage received or healed.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to prompt a damage popup.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_DeathBreak
 * @text MECH: Dead Label Jump
 * @desc If the active battler is dead, jump to a specific label in the common event.
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If the active battler is dead, jump to this specific label in the common event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EmulateAttackEffect
 * @text MECH: Emulate Attack Effect
 * @desc Emulate an "Action Effect" but using a the user's
 * attack skill instead of the current action.
 * 
 * @arg Users:arraystr
 * @text User(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to perform the action's effects.
 * @default ["user"]
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EmulateGuardEffect
 * @text MECH: Emulate Guard Effect
 * @desc Emulate an "Action Effect" but using a the user's
 * guard skill instead of the current action.
 * 
 * @arg Users:arraystr
 * @text User(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to perform the action's effects.
 * @default ["user"]
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EmulateItemEffect
 * @text MECH: Emulate Item Effect
 * @desc Emulate an "Action Effect" but using a specific item
 * instead of the current action.
 * 
 * @arg ItemID:eval
 * @text Item ID
 * @type item
 * @desc Which item ID will be emulated?
 * @default 7
 * 
 * @arg Users:arraystr
 * @text User(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to perform the action's effects.
 * @default ["user"]
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EmulateSkillCost
 * @text MECH: Emulate Skill Cost
 * @desc Pick a skill for target(s) to emulate paying the cost of.
 * Includes cooldowns and limited uses.
 * 
 * @arg SkillID:eval
 * @text Skill ID
 * @type skill
 * @desc Which skill ID will have its cost paid for?
 * Use 0 for current action's skill.
 * @default 0
 * 
 * @arg Users:arraystr
 * @text User(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to perform the action's effects.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EmulateSkillEffect
 * @text MECH: Emulate Skill Effect
 * @desc Emulate an "Action Effect" but using a specific skill
 * instead of the current action.
 * 
 * @arg SkillID:eval
 * @text Skill ID
 * @type skill
 * @desc Which skill ID will be emulated?
 * @default 99
 * 
 * @arg Users:arraystr
 * @text User(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to perform the action's effects.
 * @default ["user"]
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EnemyEscape
 * @text MECH: Enemy Escape
 * @desc Causes the enemy unit(s) to escape.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to escape.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EtbAction
 * @text MECH: ETB Energy Count
 * @desc Alters the subject team's available Energy Count.
 * Requires VisuMZ_2_BattleSystemETB!
 * 
 * @arg ActionCount:eval
 * @text Energy Count
 * @desc Alters the subject team's available Energy Count.
 * Positive for gaining energy. Negative for losing energy.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_FtbAction
 * @text MECH: FTB Action Count
 * @desc Alters the subject team's available Action Count.
 * Requires VisuMZ_2_BattleSystemFTB!
 * 
 * @arg ActionCount:eval
 * @text Action Count
 * @desc Alters the subject team's available Action Count.
 * Positive for gaining actions. Negative for losing actions.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_HpMpTp
 * @text MECH: HP, MP, TP
 * @desc Alters the HP, MP, and TP values for unit(s).
 * Positive values for healing. Negative values for damage.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["user"]
 *
 * @arg HP
 * 
 * @arg HP_Rate:eval
 * @text HP Rate
 * @parent HP
 * @desc Changes made to HP based on rate.
 * Positive values for healing. Negative values for damage.
 * @default +0.00
 * 
 * @arg HP_Flat:eval
 * @text HP Flat
 * @parent HP
 * @desc Flat changes made to HP.
 * Positive values for healing. Negative values for damage.
 * @default +0
 * 
 * @arg MP
 * 
 * @arg MP_Rate:eval
 * @text MP Rate
 * @parent MP
 * @desc Changes made to MP based on rate.
 * Positive values for healing. Negative values for damage.
 * @default +0.00
 * 
 * @arg MP_Flat:eval
 * @text MP Flat
 * @parent MP
 * @desc Flat changes made to MP.
 * Positive values for healing. Negative values for damage.
 * @default +0
 *
 * @arg TP
 * 
 * @arg TP_Rate:eval
 * @text TP Rate
 * @parent TP
 * @desc Changes made to TP based on rate.
 * Positive values for healing. Negative values for damage.
 * @default +0.00
 * 
 * @arg TP_Flat:eval
 * @text TP Flat
 * @parent TP
 * @desc Flat changes made to TP.
 * Positive values for healing. Negative values for damage.
 * @default +0
 * 
 * @arg ShowPopup:eval
 * @text Damage Popup?
 * @type boolean
 * @on On
 * @off Off
 * @desc Display a damage popup after?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_Immortal
 * @text MECH: Immortal
 * @desc Changes the immortal flag of targets. If immortal flag is
 * removed and a unit would die, collapse that unit.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Alter the immortal flag of these groups. If immortal flag
 * is removed and a unit would die, collapse that unit.
 * @default ["user","all targets"]
 * 
 * @arg Immortal:eval
 * @text Immortal
 * @type boolean
 * @on On
 * @off Off
 * @desc Turn immortal flag for unit(s) on/off?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_Multipliers
 * @text MECH: Multipliers
 * @desc Changes the multipliers for the current action.
 * You may use JavaScript code for any of these.
 *
 * @arg CriticalHit
 * @text Critical Hit%
 * 
 * @arg CriticalHitRate:eval
 * @text Rate
 * @parent CriticalHit
 * @desc Affects chance to land a critical hit by this multiplier.
 * @default 1.00
 * 
 * @arg CriticalHitFlat:eval
 * @text Flat
 * @parent CriticalHit
 * @desc Affects chance to land a critical hit by this flat bonus.
 * @default +0.00
 *
 * @arg CriticalDmg
 * @text Critical Damage
 * 
 * @arg CriticalDmgRate:eval
 * @text Rate
 * @parent CriticalDmg
 * @desc Affects critical damage by this multiplier.
 * @default 1.00
 * 
 * @arg CriticalDmgFlat:eval
 * @text Flat
 * @parent CriticalDmg
 * @desc Affects critical damage by this flat bonus.
 * @default +0.00
 *
 * @arg Damage
 * @text Damage/Healing
 * 
 * @arg DamageRate:eval
 * @text Rate
 * @parent Damage
 * @desc Sets the damage/healing multiplier for current action.
 * @default 1.00
 * 
 * @arg DamageFlat:eval
 * @text Flat
 * @parent Damage
 * @desc Sets the damage/healing bonus for current action.
 * @default +0.00
 *
 * @arg HitRate
 * @text Hit Rate
 * 
 * @arg HitRate:eval
 * @text Rate
 * @parent HitRate
 * @desc Affects chance to connect attack by this multiplier.
 * @default 1.00
 * 
 * @arg HitFlat:eval
 * @text Flat
 * @parent HitRate
 * @desc Affects chance to connect attack by this flat bonus.
 * @default +0.00
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_OnceParallel
 * @text MECH: Once Parallel
 * @desc Plays a Common Event parallel to the battle event once
 * without repeating itself when done.
 *
 * @arg CommonEventID:num
 * @text Common Event ID
 * @type common_event
 * @desc The ID of the parallel Common Event to play.
 * Does NOT repeat itself when finished.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_OtbOrder
 * @text MECH: OTB Order
 * @desc Alters the OTB Turn Order. Best used with single targets.
 * Requires VisuMZ_2_BattleSystemOTB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the OTB Turn Order for.
 * @default ["all targets"]
 *
 * @arg CurrentTurn:eval
 * @text Current Turn By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +0
 *
 * @arg NextTurn:eval
 * @text Next Turn By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +1
 *
 * @arg FollowTurn:eval
 * @text Follow Turn By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_PtbAlterCost
 * @text MECH: PTB Alter Cost
 * @desc Alters the action's cost settings.
 * Requires VisuMZ_2_BattleSystemPTB!
 *
 * @arg Override:eval
 * @text Override?
 * @type boolean
 * @on Override Permanent
 * @off Require Temporary
 * @desc Overrides any 'permanent' settings for Changeability?
 * @default false
 *
 * @arg alterChange:str
 * @text Alter Changeability
 * @type select
 * @option Unchanged - Cost type is unchanged after this effect
 * @value unchanged
 * @option Permanent - Cost type can no longer be changed after
 * @value permanent
 * @option Temporary - Cost type can still be changed after
 * @value temporary
 * @desc Allow the cost type and value to be changeable?
 * @default unchanged
 *
 * @arg alterType:str
 * @text Alter Cost Type
 * @type select
 * @option Unchanged - No changes are made
 * @value unchanged
 * @option Consume - Removes half, otherwise consumes full
 * @value consume
 * @option Convert - Converts full => half, otherwise consumes half
 * @value convert
 * @option Compress - Consumes half, otherwise converts full => half
 * @value compress
 * @desc Change the cost type to this scenario.
 * Use 'Unchanged' for no changes.
 * @default convert
 *
 * @arg alterCost:eval
 * @text Alter Cost Value
 * @desc What is the default action cost for this scenario?
 * @default +0
 *
 * @arg alterPriority:eval
 * @text Priority
 * @desc What is this scenario's priority? Scenario outcomes with
 * equal or lower priorities cannot override types and costs.
 * @default 50
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_PtbConvert
 * @text MECH: PTB Conversion
 * @desc Converts full actions into half actions.
 * Requires VisuMZ_2_BattleSystemPTB!
 * 
 * @arg ConvertCount:eval
 * @text Conversion Count
 * @desc Converts full actions into half actions.
 * If not enough, consume half actions.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_PtbFullHalfAction
 * @text MECH: PTB Full/Half Action(s)
 * @desc Alters the subject team's available Full/Half Actions.
 * Requires VisuMZ_2_BattleSystemPTB!
 * 
 * @arg FullActions:eval
 * @text Full Actions
 * @desc Alters the subject team's available Full Actions.
 * Positive for gaining. Negative for losing.
 * @default +0
 * 
 * @arg HalfActions:eval
 * @text Half Actions
 * @desc Alters the subject team's available Half Actions.
 * Positive for gaining. Negative for losing.
 * @default +0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_RemoveBuffDebuff
 * @text MECH: Remove Buff/Debuff
 * @desc Removes buff(s)/debuff(s) from unit(s). 
 * Determine which parameters are removed.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to have the buff(s) and/or debuff(s) removed.
 * @default ["user"]
 * 
 * @arg Buffs:arraystr
 * @text Buff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which buffed parameter(s) to remove.
 * @default ["MaxHP","MaxMP","ATK","DEF","MAT","MDF","AGI","LUK"]
 *
 * @arg Debuffs:arraystr
 * @text Debuff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which debuffed parameter(s) to remove.
 * @default ["MaxHP","MaxMP","ATK","DEF","MAT","MDF","AGI","LUK"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_RemoveState
 * @text MECH: Remove State
 * @desc Remove state(s) from unit(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to have states removed from.
 * @default ["user"]
 * 
 * @arg States:arraynum
 * @text States
 * @type state[]
 * @desc Select which state ID(s) to remove from unit(s).
 * Insert multiple state ID's to remove multiple at once.
 * @default ["4"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StateTurnsChangeBy
 * @text MECH: State Turns Change By
 * @desc Changes target(s) state turns by an amount.
 * Requires VisuMZ_1_SkillsStatesCore!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to affect state turns for.
 * @default ["all targets"]
 *
 * @arg StateID:num
 * @text State ID
 * @type state
 * @desc What is the ID of the state you wish to change turns for?
 * Only works on states that can have turns.
 * @default 5
 *
 * @arg Turns:eval
 * @text Change Turns By
 * @desc How many turns should the state be changed to?
 * You may use JavaScript code.
 * @default +1
 *
 * @arg AutoAddState:eval
 * @text Auto-Add State?
 * @type boolean
 * @on Auto-Add
 * @off Don't Add
 * @desc Automatically adds state if actor(s) does not have it applied?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StateTurnsChangeTo
 * @text MECH: State Turns Change To
 * @desc Changes target(s) state turns to a specific value.
 * Requires VisuMZ_1_SkillsStatesCore!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to affect state turns for.
 * @default ["all targets"]
 *
 * @arg StateID:num
 * @text State ID
 * @type state
 * @desc What is the ID of the state you wish to change turns for?
 * Only works on states that can have turns.
 * @default 5
 *
 * @arg Turns:eval
 * @text Change Turns To
 * @desc How many turns should the state be changed to?
 * You may use JavaScript code.
 * @default 10
 *
 * @arg AutoAddState:eval
 * @text Auto-Add State?
 * @type boolean
 * @on Auto-Add
 * @off Don't Add
 * @desc Automatically adds state if target(s) does not have it applied?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StbExploit
 * @text MECH: STB Exploit Effect
 * @desc Utilize the STB Exploitation mechanics!
 * Requires VisuMZ_2_BattleSystemSTB!
 * 
 * @arg Exploited:eval
 * @text Target(s) Exploited?
 * @type boolean
 * @on Exploit
 * @off Don't
 * @desc Exploit the below targets?
 * @default true
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to become exploited.
 * @default ["all targets"]
 * 
 * @arg ForceExploited:eval
 * @text Force Exploitation
 * @type boolean
 * @on Force
 * @off Don't
 * @desc Force the exploited status?
 * @default false
 * 
 * @arg Exploiter:eval
 * @text User Exploiter?
 * @type boolean
 * @on Exploit
 * @off Don't
 * @desc Allow the user to become the exploiter?
 * @default true
 * 
 * @arg ForceExploited:eval
 * @text Force Exploitation
 * @type boolean
 * @on Force
 * @off Don't
 * @desc Force the exploiter status?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StbExtraAction
 * @text MECH: STB Extra Action
 * @desc Adds an extra action for the currently active battler.
 * Requires VisuMZ_2_BattleSystemSTB!
 * 
 * @arg Actions:eval
 * @text Extra Actions
 * @parent Charging
 * @desc How many extra actions should the active battler gain?
 * You may use JavaScript code.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StbRemoveExcessActions
 * @text MECH: STB Remove Excess Actions
 * @desc Removes excess actions from the active battler.
 * Requires VisuMZ_2_BattleSystemSTB!
 * 
 * @arg Actions:eval
 * @text Remove Actions
 * @parent Charging
 * @desc How many actions to remove from the active battler?
 * You may use JavaScript code.
 * @default 99
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_SwapWeapon
 * @text MECH: Swap Weapon
 * @desc Causes the unit(s) to swap their weapon for another.
 * Requires VisuMZ_2_WeaponSwapSystem!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to swap weapons for.
 * @default ["user"]
 * 
 * @arg WeaponTypeID:eval
 * @text Weapon Type ID
 * @desc Which weapon type to swap to?
 * This is NOT the weapon's ID. It's the weapon TYPE.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_TextPopup
 * @text MECH: Text Popup
 * @desc Causes the unit(s) to display a text popup.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to prompt a text popup.
 * @default ["target"]
 * 
 * @arg Text:str
 * @text Text
 * @desc What text do you wish to display?
 * @default Text
 * 
 * @arg TextColor:str
 * @text Text Color
 * @parent Text:str
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default #ffffff
 *
 * @arg FlashColor:eval
 * @text Flash Color
 * @parent Popups
 * @desc Adjust the popup's flash color.
 * Format: [red, green, blue, alpha]
 * @default [255, 0, 0, 160]
 * 
 * @arg FlashDuration:num
 * @text Flash Duration
 * @parent FlashColor:eval
 * @type number
 * @desc What is the frame duration of the flash effect?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_VariablePopup
 * @text MECH: Variable Popup
 * @desc Causes the unit(s) to display a popup using the data
 * stored inside a variable.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to prompt a text popup.
 * @default ["target"]
 * 
 * @arg Variable:num
 * @text Variable ID
 * @type variable
 * @desc Get data from which variable to display as a popup?
 * @default 1
 * 
 * @arg DigitGrouping:eval
 * @text Digit Grouping
 * @parent Variable:num
 * @type boolean
 * @on Group Digits
 * @off Don't Group
 * @desc Use digit grouping to separate numbers?
 * Requires VisuMZ_0_CoreEngine!
 * @default true
 * 
 * @arg TextColor:str
 * @text Text Color
 * @parent Variable:num
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default #ffffff
 *
 * @arg FlashColor:eval
 * @text Flash Color
 * @parent Popups
 * @desc Adjust the popup's flash color.
 * Format: [red, green, blue, alpha]
 * @default [0, 0, 0, 0]
 * 
 * @arg FlashDuration:num
 * @text Flash Duration
 * @parent FlashColor:eval
 * @type number
 * @desc What is the frame duration of the flash effect?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_WaitForEffect
 * @text MECH: Wait For Effect
 * @desc Waits for the effects to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceMotion
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakMotion
 * @text Action Sequences - Motion
 * @desc These Action Sequences allow you the ability to control
 * the motions of sideview sprites.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_ClearFreezeFrame
 * @text MOTION: Clear Freeze Frame
 * @desc Clears any freeze frames from the unit(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to clear freeze frames for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_FreezeMotionFrame
 * @text MOTION: Freeze Motion Frame
 * @desc Forces a freeze frame instantly at the selected motion.
 * Automatically clears with a new motion.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to freeze motions for.
 * @default ["user"]
 *
 * @arg MotionType:str
 * @text Motion Type
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option attack
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Freeze this motion for the unit(s).
 * @default attack
 * 
 * @arg Frame:num
 * @text Frame Index
 * @desc Which frame do you want to freeze the motion on?
 * Frame index values start at 0.
 * @default 2
 *
 * @arg ShowWeapon:eval
 * @text Show Weapon?
 * @type combo
 * @type boolean
 * @on Show
 * @off Hide
 * @desc If using 'attack', 'thrust', 'swing', or 'missile',
 * display the weapon sprite?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_MotionType
 * @text MOTION: Motion Type
 * @desc Causes the unit(s) to play the selected motion.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to perform a motion.
 * @default ["user"]
 *
 * @arg MotionType:str
 * @text Motion Type
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option attack
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default attack
 *
 * @arg ShowWeapon:eval
 * @text Show Weapon?
 * @type combo
 * @type boolean
 * @on Show
 * @off Hide
 * @desc If using 'attack', 'thrust', 'swing', or 'missile',
 * display the weapon sprite?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_PerformAction
 * @text MOTION: Perform Action
 * @desc Causes the unit(s) to play the proper motion based
 * on the current action.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to perform a motion.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_RefreshMotion
 * @text MOTION: Refresh Motion
 * @desc Cancels any set motions unit(s) has to do and use
 * their most natural motion at the moment.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to refresh their motion state.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_WaitMotionFrame
 * @text MOTION: Wait By Motion Frame
 * @desc Creates a wait equal to the number of motion frames passing.
 * Time is based on Plugin Parameters => Actors => Motion Speed.
 *
 * @arg MotionFrameWait:num
 * @text Motion Frames to Wait?
 * @type number
 * @min 1
 * @desc Each "frame" is equal to the value found in
 * Plugin Parameters => Actors => Motion Speed
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceMovement
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakMovement
 * @text Action Sequences - Movement
 * @desc These Action Sequences allow you the ability to control
 * the sprites of actors and enemies in battle.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_BattleStep
 * @text MOVE: Battle Step
 * @desc Causes the unit(s) to move forward past their home position
 * to prepare for action.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeMoveBy
 * @text MOVE: Change Home By Distance
 * @desc Change unit(s)'s home position by a distance from their
 * current home position(s). Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change home position(s) for.
 * @default ["user"]
 *
 * @arg DistanceAdjust:str
 * @text Distance Adjustment
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to distance values to determine
 * which direction to change by.
 * @default horz
 * 
 * @arg DistanceX:eval
 * @text Distance: X
 * @parent DistanceAdjust:str
 * @desc Horizontal distance to change home by.
 * You may use JavaScript code.
 * @default 48
 * 
 * @arg DistanceY:eval
 * @text Distance: Y
 * @parent DistanceAdjust:str
 * @desc Vertical distance to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total change amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeMoveToJsPoint
 * @text MOVE: Change Home To JS Coordinates
 * @desc Change home position(s) to specified JS Coordinates.
 * Sideview-only! Uses JavaScript!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change home position(s) for.
 * @default ["user"]
 *
 * @arg DestinationJS:func
 * @text JS: Coordinates
 * @type note
 * @desc Code used to determine the coordinates for the
 * target(s)'s new home position.
 * @default "// Declare Variables\nconst target = arguments[0];\nlet goalX = 0;\nlet goalY = 0;\n\n// Calculations\ngoalX = Graphics.width / 2;\ngoalY = Graphics.height / 2;\n\n// Return Data\nreturn new Point(goalX, goalY);"
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Destination:str
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total change amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeMoveToPoint
 * @text MOVE: Change Home To Point
 * @desc Change home position(s) to a target point on the screen.
 * Sideview-only! Points based off Graphics.boxWidth/Height.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change home position(s) for.
 * @default ["user"]
 * 
 * @arg Destination:str
 * @text Destination Point
 * @type combo
 * @option center
 * @option point x, y
 * @desc Select which point to face.
 * Replace 'x' and 'y' with coordinates
 * @default center
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Destination:str
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total change amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeMoveToTarget
 * @text MOVE: Change Home To Target(s)
 * @desc Moves unit(s) to another unit(s) on the battle field.
 * Sideview-only!
 * 
 * @arg Targets1:arraystr
 * @text Targets (Moving)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change home position(s) for.
 * @default ["user"]
 * 
 * @arg Targets2:arraystr
 * @text Targets (Destination)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change home position to.
 * @default ["all targets"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to change home position to.
 * @default front base
 * 
 * @arg MeleeDistance:eval
 * @text Melee Distance
 * @parent TargetLocation:str
 * @desc The melee distance away from the target location
 * in addition to the battler's width.
 * @default 24
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Targets2:arraystr
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total change amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_FaceDirection
 * @text MOVE: Face Direction
 * @desc Causes the unit(s) to face forward or backward.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change direction.
 * @default ["user"]
 * 
 * @arg Direction:str
 * @text Direction
 * @type combo
 * @option forward
 * @option backward
 * @option random
 * @desc Select which direction to face.
 * @default forward
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_FaceJsPoint
 * @text MOVE: Face JS Coordinates
 * @desc Causes the unit(s) to face specified JS Coordinates.
 * Sideview-only! Uses JavaScript!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change direction.
 * @default ["user"]
 *
 * @arg PointJS:func
 * @text JS: Coordinates
 * @type note
 * @desc Code used to determine the coordinates for the
 * target(s) to face towards.
 * @default "// Declare Variables\nconst target = arguments[0];\nlet goalX = 0;\nlet goalY = 0;\n\n// Calculations\ngoalX = Graphics.width / 2;\ngoalY = Graphics.height / 2;\n\n// Return Data\nreturn new Point(goalX, goalY);"
 * 
 * @arg FaceAway:eval
 * @text Face Away From?
 * @type boolean
 * @on Turn Away
 * @off Face Directly
 * @desc Face away from the point instead?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_FacePoint
 * @text MOVE: Face Point
 * @desc Causes the unit(s) to face a point on the screen.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change direction.
 * @default ["user"]
 * 
 * @arg Point:str
 * @text Point
 * @type combo
 * @option home
 * @option center
 * @option point x, y
 * @desc Select which point to face.
 * Replace 'x' and 'y' with coordinates
 * @default home
 * 
 * @arg FaceAway:eval
 * @text Face Away From?
 * @type boolean
 * @on Turn Away
 * @off Face Directly
 * @desc Face away from the point instead?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_FaceTarget
 * @text MOVE: Face Target(s)
 * @desc Causes the unit(s) to face other targets on the screen.
 * Sideview-only!
 * 
 * @arg Targets1:arraystr
 * @text Targets (facing)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change direction.
 * @default ["user"]
 * 
 * @arg Targets2:arraystr
 * @text Targets (destination)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) for the turning unit(s) to face.
 * @default ["current target"]
 * 
 * @arg FaceAway:eval
 * @text Face Away From?
 * @type boolean
 * @on Turn Away
 * @off Face Directly
 * @desc Face away from the unit(s) instead?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Float
 * @text MOVE: Float
 * @desc Causes the unit(s) to float above the ground.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to make float.
 * @default ["user"]
 * 
 * @arg Height:eval
 * @text Desired Height
 * @desc Vertical distance to float upward.
 * You may use JavaScript code.
 * @default 100
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total float amount.
 * @default 12
 *
 * @arg EasingType:str
 * @text Float Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg WaitForFloat:eval
 * @text Wait For Float?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for floating to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeReset
 * @text MOVE: Home Reset
 * @desc Causes the unit(s) to move back to their home position(s)
 * and face back to their original direction(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["alive battlers"]
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Jump
 * @text MOVE: Jump
 * @desc Causes the unit(s) to jump into the air.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to make jump.
 * @default ["user"]
 * 
 * @arg Height:eval
 * @text Desired Height
 * @desc Max jump height to go above the ground
 * You may use JavaScript code.
 * @default 100
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total jump amount.
 * @default 12
 * 
 * @arg WaitForJump:eval
 * @text Wait For Jump?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for jumping to complete before performing next command?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_MoveBy
 * @text MOVE: Move Distance
 * @desc Moves unit(s) by a distance from their current position(s).
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 *
 * @arg DistanceAdjust:str
 * @text Distance Adjustment
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to distance values to determine
 * which direction to move unit(s).
 * @default horz
 * 
 * @arg DistanceX:eval
 * @text Distance: X
 * @parent DistanceAdjust:str
 * @desc Horizontal distance to move.
 * You may use JavaScript code.
 * @default 48
 * 
 * @arg DistanceY:eval
 * @text Distance: Y
 * @parent DistanceAdjust:str
 * @desc Vertical distance to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total movement amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_MoveToJsPoint
 * @text MOVE: Move To JS Coordinates
 * @desc Moves unit(s) to specified JS Coordinates.
 * Sideview-only! Uses JavaScript!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 *
 * @arg DestinationJS:func
 * @text JS: Coordinates
 * @type note
 * @desc Code used to determine the coordinates for the
 * target(s) to move to.
 * @default "// Declare Variables\nconst target = arguments[0];\nlet goalX = 0;\nlet goalY = 0;\n\n// Calculations\ngoalX = Graphics.width / 2;\ngoalY = Graphics.height / 2;\n\n// Return Data\nreturn new Point(goalX, goalY);"
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Destination:str
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total movement amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_MoveToPoint
 * @text MOVE: Move To Point
 * @desc Moves unit(s) to a designated point on the screen.
 * Sideview-only! Points based off Graphics.boxWidth/Height.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 * 
 * @arg Destination:str
 * @text Destination Point
 * @type combo
 * @option home
 * @option center
 * @option point x, y
 * @desc Select which point to face.
 * Replace 'x' and 'y' with coordinates
 * @default home
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Destination:str
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total movement amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_MoveToTarget
 * @text MOVE: Move To Target(s)
 * @desc Moves unit(s) to another unit(s) on the battle field.
 * Sideview-only!
 * 
 * @arg Targets1:arraystr
 * @text Targets (Moving)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 * 
 * @arg Targets2:arraystr
 * @text Targets (Destination)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move to.
 * @default ["all targets"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to move to.
 * @default front base
 * 
 * @arg MeleeDistance:eval
 * @text Melee Distance
 * @parent TargetLocation:str
 * @desc The melee distance away from the target location
 * in addition to the battler's width.
 * @default 24
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Targets2:arraystr
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total movement amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Opacity
 * @text MOVE: Opacity
 * @desc Causes the unit(s) to change opacity.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change opacity.
 * @default ["user"]
 * 
 * @arg Opacity:eval
 * @text Desired Opacity
 * @desc Change to this opacity value.
 * You may use JavaScript code.
 * @default 255
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for opacity change.
 * @default 12
 *
 * @arg EasingType:str
 * @text Opacity Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg WaitForOpacity:eval
 * @text Wait For Opacity?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for opacity changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Scale
 * @text MOVE: Scale/Grow/Shrink
 * @desc Causes the unit(s) to scale, grow, or shrink?.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change the scale of.
 * @default ["user"]
 * 
 * @arg ScaleX:eval
 * @text Scale X
 * @desc What target scale value do you want?
 * 1.0 is normal size.
 * @default 1.00
 * 
 * @arg ScaleY:eval
 * @text Scale Y
 * @desc What target scale value do you want?
 * 1.0 is normal size.
 * @default 1.00
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to scale for.
 * @default 12
 *
 * @arg EasingType:str
 * @text Scale Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg WaitForScale:eval
 * @text Wait For Scale?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for scaling to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Skew
 * @text MOVE: Skew/Distort
 * @desc Causes the unit(s) to skew.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to skew.
 * @default ["user"]
 * 
 * @arg SkewX:eval
 * @text Skew X
 * @desc X variance to skew?
 * Use small values for the best results.
 * @default 0.00
 * 
 * @arg SkewY:eval
 * @text Skew Y
 * @desc Y variance to skew?
 * Use small values for the best results.
 * @default 0.00
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to skew for.
 * @default 12
 *
 * @arg EasingType:str
 * @text Skew Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg WaitForSkew:eval
 * @text Wait For Skew?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for skew to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Spin
 * @text MOVE: Spin/Rotate
 * @desc Causes the unit(s) to spin.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to spin.
 * @default ["user"]
 * 
 * @arg Angle:eval
 * @text Angle
 * @desc How many degrees to spin?
 * @default 360
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to spin for.
 * @default 12
 *
 * @arg EasingType:str
 * @text Spin Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg RevertAngle:eval
 * @text Revert Angle on Finish
 * @type boolean
 * @on Revert
 * @off Don't
 * @desc Revert angle after spinning?
 * @default true
 * 
 * @arg WaitForSpin:eval
 * @text Wait For Spin?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for spin to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForFloat
 * @text MOVE: Wait For Float
 * @desc Waits for floating to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForJump
 * @text MOVE: Wait For Jump
 * @desc Waits for jumping to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForMovement
 * @text MOVE: Wait For Movement
 * @desc Waits for movement to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForOpacity
 * @text MOVE: Wait For Opacity
 * @desc Waits for opacity changes to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForScale
 * @text MOVE: Wait For Scale
 * @desc Waits for scaling to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForSkew
 * @text MOVE: Wait For Skew
 * @desc Waits for skewing to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForSpin
 * @text MOVE: Wait For Spin
 * @desc Waits for spinning to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceProjectile
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakProjectile
 * @text Action Sequences - Projectiles
 * @desc Create projectiles on the screen and fire them off at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Projectile_Animation
 * @text PROJECTILE: Animation
 * @desc Create an animation projectile and fire it at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 * 
 * @arg Coordinates
 *
 * @arg Start:struct
 * @text Start Location
 * @parent Coordinates
 * @type struct<ProjectileStart>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"user\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 *
 * @arg Goal:struct
 * @text Goal Location
 * @parent Coordinates
 * @type struct<ProjectileGoal>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"all targets\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 * 
 * @arg Settings
 *
 * @arg AnimationID:num
 * @text Animation ID
 * @parent Settings
 * @type animation
 * @desc Determine which animation to use as a projectile.
 * @default 77
 * 
 * @arg Duration:eval
 * @text Duration
 * @parent Settings
 * @desc Duration for the projectile(s) to travel.
 * @default 20
 * 
 * @arg WaitForProjectile:eval
 * @text Wait For Projectile?
 * @parent Settings
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for projectile(s) to reach their destination before
 * going onto the next command?
 * @default true
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @parent Settings
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to finish before going to the next command?
 * @default false
 * 
 * @arg Extra:struct
 * @text Extra Settings
 * @type struct<ProjectileExAni>
 * @desc Add extra settings to the projectile?
 * @default {"AutoAngle:eval":"true","AngleOffset:eval":"+0","Arc:eval":"0","EasingType:str":"Linear","Spin:eval":"+0.0"}
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Projectile_Icon
 * @text PROJECTILE: Icon
 * @desc Create an icon projectile and fire it at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 * 
 * @arg Coordinates
 *
 * @arg Start:struct
 * @text Start Location
 * @parent Coordinates
 * @type struct<ProjectileStart>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"user\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 *
 * @arg Goal:struct
 * @text Goal Location
 * @parent Coordinates
 * @type struct<ProjectileGoal>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"all targets\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 * 
 * @arg Settings
 *
 * @arg Icon:eval
 * @text Icon Index
 * @parent Settings
 * @desc Determine which icon to use as a projectile.
 * You may use JavaScript code.
 * @default 118
 * 
 * @arg Duration:eval
 * @text Duration
 * @parent Settings
 * @desc Duration for the projectile(s) to travel.
 * @default 20
 * 
 * @arg WaitForProjectile:eval
 * @text Wait For Projectile?
 * @parent Settings
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for projectile(s) to reach their destination before
 * going onto the next command?
 * @default true
 * 
 * @arg Extra:struct
 * @text Extra Settings
 * @type struct<ProjectileExtra>
 * @desc Add extra settings to the projectile?
 * @default {"AutoAngle:eval":"true","AngleOffset:eval":"+0","Arc:eval":"0","BlendMode:num":"0","EasingType:str":"Linear","Hue:eval":"0","Scale:eval":"1.0","Spin:eval":"+0.0"}
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Projectile_Picture
 * @text PROJECTILE: Picture
 * @desc Create a picture projectile and fire it at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 * 
 * @arg Coordinates
 *
 * @arg Start:struct
 * @text Start Location
 * @parent Coordinates
 * @type struct<ProjectileStart>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"user\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 *
 * @arg Goal:struct
 * @text Goal Location
 * @parent Coordinates
 * @type struct<ProjectileGoal>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"all targets\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 * 
 * @arg Settings
 *
 * @arg Picture:str
 * @text Picture Filename
 * @parent Settings
 * @type file
 * @dir img/pictures/
 * @desc Determine which picture to use as a projectile.
 * @default Untitled
 * 
 * @arg Duration:eval
 * @text Duration
 * @parent Settings
 * @desc Duration for the projectile(s) to travel.
 * @default 20
 * 
 * @arg WaitForProjectile:eval
 * @text Wait For Projectile?
 * @parent Settings
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for projectile(s) to reach their destination before
 * going onto the next command?
 * @default true
 * 
 * @arg Extra:struct
 * @text Extra Settings
 * @type struct<ProjectileExtra>
 * @desc Add extra settings to the projectile?
 * @default {"AutoAngle:eval":"true","AngleOffset:eval":"+0","Arc:eval":"0","BlendMode:num":"0","EasingType:str":"Linear","Hue:eval":"0","Scale:eval":"1.0","Spin:eval":"+0.0"}
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceSkew
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakSkew
 * @text Action Sequences - Skew
 * @desc Allows you to have control over the camera skew.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_ChangeSkew
 * @text SKEW: Change Skew
 * @desc Changes the camera skew.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg SkewX:eval
 * @text Skew X
 * @desc Change the camera skew X to this value.
 * @default 0
 * 
 * @arg SkewY:eval
 * @text Skew Y
 * @desc Change the camera skew Y to this value.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to change camera skew.
 * @default 60
 *
 * @arg EasingType:str
 * @text Skew Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForSkew:eval
 * @text Wait For Skew?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for skew changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Skew_Reset
 * @text SKEW: Reset Skew
 * @desc Reset any skew settings.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to reset camera skew.
 * @default 60
 *
 * @arg EasingType:str
 * @text Skew Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForSkew:eval
 * @text Wait For Skew?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for skew changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Skew_WaitForSkew
 * @text SKEW: Wait For Skew
 * @desc Waits for skew changes to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceTarget
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakTarget
 * @text Action Sequences - Target
 * @desc If using a manual target by target Action Sequence,
 * these commands will give you full control over its usage.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_CurrentIndex
 * @text TARGET: Current Index
 * @desc Sets the current index to this value.
 * Then decide to jump to a label (optional).
 * 
 * @arg Index:eval
 * @text Set Index To
 * @desc Sets current targeting index to this value.
 * 0 is the starting index of a target group.
 * @default 0
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_NextTarget
 * @text TARGET: Next Target
 * @desc Moves index forward by 1 to select a new current target.
 * Then decide to jump to a label (optional).
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_PrevTarget
 * @text TARGET: Previous Target
 * @desc Moves index backward by 1 to select a new current target.
 * Then decide to jump to a label (optional).
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_RandTarget
 * @text TARGET: Random Target
 * @desc Sets index randomly to determine new currernt target.
 * Then decide to jump to a label (optional).
 * 
 * @arg ForceRandom:eval
 * @text Force Random?
 * @type boolean
 * @on On
 * @off Off
 * @desc Index cannot be its previous index amount after random.
 * @default false
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceVoice
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakVoice
 * @text Action Sequences - Voice
 * @desc Allows you to play battle voices.
 * Requires VisuMZ_3_BattleVoices!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleVoice_PlayCommonLine
 * @text VOICE: Play Common Line
 * @desc Plays a common voice line from target battler(s).
 * Requires VisuMZ_3_BattleVoices!
 * 
 * @arg Targets:arraystr
 * @text Speaker Target(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play voice lines from.
 * @default ["user"]
 *
 * @arg VoiceLine:str
 * @text Voice Line
 * @type select
 * @option -
 * @value -
 * @option ---Battle Phase---
 * @value -
 * @option On Battle Start
 * @value BattleStart
 * @option On Battle Input
 * @value BattleInput
 * @option On Battle Victory
 * @value BattleVictory
 * @option Victory => Level Up
 * @value BattleVictoryLevelUp
 * @option Escape => Success
 * @value BattleEscapeSuccess
 * @option Escape => Failure
 * @value BattleEscapeFailure
 * @option -
 * @value -
 * @option ---On Action Start---
 * @value -
 * @option Basic Action => Regular Attack
 * @value ActionStartBasicAttack
 * @option Basic Action => Regular Guard
 * @value ActionStartBasicGuard
 * @option Skill Usage For Allies => Certain Hit
 * @value ActionStartSkillAllyCertainHit
 * @option Skill Usage For Allies => Physical
 * @value ActionStartSkillAllyPhysical
 * @option Skill Usage For Allies => Magical
 * @value ActionStartSkillAllyMagical
 * @option Skill Usage For Enemies => Certain Hit
 * @value ActionStartSkillEnemyCertainHit
 * @option Skill Usage For Enemies => Physical
 * @value ActionStartSkillEnemyPhysical
 * @option Skill Usage For Enemies => Magical
 * @value ActionStartSkillEnemyMagical
 * @option Item Usage For Allies
 * @value ActionStartItemAlly
 * @option Item Usage For Enemies
 * @value ActionStartItemEnemy
 * @option -
 * @value -
 * @option ---Perform Action---
 * @value -
 * @option Basic Action => Attack Motion
 * @value PerformActionBasicAttack
 * @option Basic Action => Critical Action
 * @value PerformActionCritical
 * @option Basic Action => Defeat Opponent
 * @value PerformActionDefeatFoe
 * @option Basic Action => Missed Action
 * @value PerformActionMiss
 * @option Skill Usage => Certain Hit
 * @value PerformActionSkillCertainHit
 * @option Skill Usage => Physical
 * @value PerformActionSkillPhysical
 * @option Skill Usage => Magical
 * @value PerformActionSkillMagical
 * @option -
 * @value -
 * @option ---On HP Change---
 * @value -
 * @option Life State => On Death
 * @value HpChangeDeath
 * @option Life State => On Revive
 * @value HpChangeRevive
 * @option On Damage => Damage <= 0%
 * @value HpChangeDamageNone
 * @option On Damage => Damage < 25%
 * @value HpChangeDamageLight
 * @option On Damage => Damage < 50%
 * @value HpChangeDamageMedium
 * @option On Damage => Damage >= 50%
 * @value HpChangeDamageHeavy
 * @option On Damage => Guarding Damage
 * @value HpChangeDamageGuard
 * @option On Recovery => Recovery < 25%
 * @value HpChangeRecoverLight
 * @option On Recovery => Recovery < 50%
 * @value HpChangeRecoverMedium
 * @option On Recovery => Recovery >= 50%
 * @value HpChangeRecoverHeavy
 * @option -
 * @value -
 * @option ---On Action Result---
 * @value -
 * @option On Miss/Evasion
 * @value ActionResultEvasion
 * @option On Magic Evasion
 * @value ActionResultMagicEvasion
 * @option On Counter
 * @value ActionResultCounter
 * @option On Reflection
 * @value ActionResultReflection
 * @option On Substitute
 * @value ActionResultSubstitute
 * @option -
 * @value -
 * @option ---Buff/Debuff Related---
 * @value -
 * @option On Buff Apply
 * @value BuffAdd
 * @option On Buff Remove
 * @value BuffRemove
 * @option On Debuff Apply
 * @value DebuffAdd
 * @option On Debuff Remove
 * @value DebuffRemove
 * @option -
 * @value -
 * @option ---State Related---
 * @value -
 * @option Positive States => On State Apply
 * @value StatePositiveAdd
 * @option Positive States => text On State Remove
 * @value StatePositiveRemove
 * @option Negative States => On State Apply
 * @value StateNegativeAdd
 * @option Negative States => On State Remove
 * @value StateNegativeRemove
 * @option Neutral States => On State Apply
 * @value StateNeutralAdd
 * @option Neutral States => On State Remove
 * @value StateNeutralRemove
 * @option -
 * @value -
 * @option ---Miscellaneous---
 * @value -
 * @option Voice Preview
 * @value CharaCreatePreview
 * @option -
 * @value -
 * @desc What voice line do you wish to play?
 * @default ActionStartBasicAttack
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleVoice_PlaySpecialLine
 * @text VOICE: Play Special Line
 * @desc Plays a special voice line from target battler(s).
 * Requires VisuMZ_3_BattleVoices!
 * 
 * @arg Targets:arraystr
 * @text Speaker Target(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play voice lines from.
 * @default ["user"]
 *
 * @arg VoiceLineType:str
 * @text Voice Line Type
 * @type select
 * @option Action Name
 * @value ActionName
 * @option Chant Line
 * @value ChantLine
 * @option Item Name
 * @value ItemName
 * @option Skill Name
 * @value SkillName
 * @option Spell Name
 * @value SpellName
 * @option Unique Lines
 * @value UniqueLine
 * @desc What voice line type do you wish to play?
 * @default ActionName
 *
 * @arg Letter:str
 * @text Name / Letter
 * @type select
 * @option A
 * @option B
 * @option C
 * @option D
 * @option E
 * @option F
 * @option G
 * @option H
 * @option I
 * @option J
 * @option K
 * @option L
 * @option M
 * @option N
 * @option O
 * @option P
 * @option Q
 * @option R
 * @option S
 * @option T
 * @option U
 * @option V
 * @option W
 * @option X
 * @option Y
 * @option Z
 * @desc What voice letter/name do you want to play?
 * @default A
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceWeapon
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakWeapon
 * @text Action Sequences - Weapon
 * @desc Allows for finer control over Dual/Multi Wielding actors.
 * Only works for Actors.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Weapon_ClearActiveWeapon
 * @text WEAPON: Clear Weapon Slot
 * @desc Clears the active weapon slot (making others valid again).
 * Only works for Actors.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @desc Select unit(s) to clear the active weapon slot for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Weapon_NextActiveWeapon
 * @text WEAPON: Next Weapon Slot
 * @desc Goes to next active weapon slot (making others invalid).
 * If next slot is weaponless, don't label jump.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @desc Select unit(s) to change the next active weapon slot for.
 * @default ["user"]
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a weapon is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Weapon_SetActiveWeapon
 * @text WEAPON: Set Weapon Slot
 * @desc Sets the active weapon slot (making others invalid).
 * Only works for Actors.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @desc Select unit(s) to change the active weapon slot for.
 * @default ["user"]
 * 
 * @arg SlotID:eval
 * @text Weapon Slot ID
 * @desc Select weapon slot to make active (making others invalid).
 * Use 0 to clear and normalize. You may use JavaScript code.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceZoom
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakZoom
 * @text Action Sequences - Zoom
 * @desc Allows you to have control over the screen zoom.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Zoom_Scale
 * @text ZOOM: Change Scale
 * @desc Changes the zoom scale.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Scale:eval
 * @text Scale
 * @desc The zoom scale to change to.
 * @default 1.0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to change battle zoom.
 * @default 60
 *
 * @arg EasingType:str
 * @text Zoom Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForZoom:eval
 * @text Wait For Zoom?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for zoom changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Zoom_Reset
 * @text ZOOM: Reset Zoom
 * @desc Reset any zoom settings.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to reset battle zoom.
 * @default 60
 *
 * @arg EasingType:str
 * @text Zoom Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForZoom:eval
 * @text Wait For Zoom?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for zoom changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Zoom_WaitForZoom
 * @text ZOOM: Wait For Zoom
 * @desc Waits for zoom to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceEnd
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @ ==========================================================================
 * @ Plugin Parameters
 * @ ==========================================================================
 *
 * @param BreakHead
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param BattleCore
 * @default Plugin Parameters
 *
 * @param ATTENTION
 * @default READ THE HELP FILE
 *
 * @param BreakSettings
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param AutoBattle:struct
 * @text Auto Battle Settings
 * @type struct<AutoBattle>
 * @desc Settings pertaining to Auto Battle.
 * @default {"BattleDisplay":"","AutoBattleMsg:str":"Press %1 or %2 to stop Auto Battle","AutoBattleOK:str":"OK","AutoBattleCancel:str":"Cancel","AutoBattleBgType:num":"1","AutoBattleRect:func":"\"const width = Graphics.width;\\nconst height = this.calcWindowHeight(1, false);\\nconst x = 0;\\nconst y = (Graphics.height - height) / 2;\\nreturn new Rectangle(x, y, width, height);\"","Options":"","AddOption:eval":"true","AdjustRect:eval":"true","StartName:str":"Auto Battle Start","StyleName:str":"Auto Battle Style","StyleOFF:str":"Attack","StyleON:str":"Skills"}
 *
 * @param Damage:struct
 * @text Damage Settings
 * @type struct<Damage>
 * @desc Settings pertaining to damage calculations.
 * @default {"DamageStyles":"","DefaultDamageStyle:str":"Standard","DamageStyleList:arraystruct":"[\"{\\\"Name:str\\\":\\\"Standard\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Declare Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Replace Formula\\\\\\\\nlet formula = item.damage.formula;\\\\\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 0)';\\\\\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nlet value = Math.max(eval(formula), 0);\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"return this.getItemDamageAmountTextOriginal();\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"Armor Scaling\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Declare Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Replace Formula\\\\\\\\nlet formula = item.damage.formula;\\\\\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 1)';\\\\\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nlet value = Math.max(eval(formula), 0);\\\\\\\\n\\\\\\\\n// Apply Defender's Defense Parameter\\\\\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\\\\\n\\\\\\\\n    // Calculate Base Armor\\\\\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\\\\\n\\\\\\\\n    // Apply Armor to Damage\\\\\\\\n    if (armor >= 0) {\\\\\\\\n        value *= 100 / (100 + armor);\\\\\\\\n    } else {\\\\\\\\n        value *= 2 - (100 / (100 - armor));\\\\\\\\n    }\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"return this.getItemDamageAmountTextOriginal();\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"CT\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet value = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\\\\\nlet attackStat = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat =  a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nattackStat = (attackStat * 1.75) + (level ** 2 / 45.5);\\\\\\\\nvalue = attackStat * 4;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= Math.max(256 - armor, 0) / 256;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= Math.max(102.4 - armor, 0) / 128;\\\\\\\\n}\\\\\\\\nvalue *= multiplier;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"D4\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nlet stat = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    stat = a.def;\\\\\\\\n    armor = 0;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    stat = a.mdf;\\\\\\\\n    armor = 0;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage \\\\\\\\nlet value = 1.5 * Math.max(2 * stat * multiplier - armor, 1) * multiplier / 5;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"DQ\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nlet multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\nif (this.isCertainHit()) {\\\\\\\\n    let value = multiplier * Math.max(a.atk, a.mat);\\\\\\\\n    return (isNaN(value) ? 0 : value) * sign;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Get Primary Stats\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(b, armor);\\\\\\\\nlet stat = 1;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    stat = a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    stat = a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Check for Recovery\\\\\\\\nif (this.isRecover()) {\\\\\\\\n    let value = stat * multiplier * sign;\\\\\\\\n    return isNaN(value) ? 0 : value;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nlet value = 0;\\\\\\\\nif (stat < ((2 + armor) / 2)) {\\\\\\\\n    // Plink Damage\\\\\\\\n    let baseline = Math.max(stat - ((12 * (armor - stat + 1)) / stat), 5);\\\\\\\\n    value = baseline / 3;\\\\\\\\n} else {\\\\\\\\n    // Normal Damage\\\\\\\\n    let baseline = Math.max(stat - (armor / 2), 1);\\\\\\\\n    value = baseline / 2;\\\\\\\\n}\\\\\\\\nvalue *= multiplier;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF7\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Power\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare base Damage\\\\\\\\nlet baseDamage = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    baseDamage = a.atk + ((a.atk + level) / 32) * ((a.atk * level) / 32);\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    baseDamage = 6 * (a.mat + level);\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    baseDamage = 6 * (a.def + level);\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    baseDamage = 6 * (a.mdf + level);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Final Damage\\\\\\\\nlet value = baseDamage;\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nif (this.isRecover()) {\\\\\\\\n    value += 22 * power;\\\\\\\\n} else {\\\\\\\\n    value = (power * Math.max(512 - armor, 1) * baseDamage) / (16 * 512);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF8\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Power\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Damage\\\\\\\\nlet Value = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = a.atk ** 2 / 16 + a.atk;\\\\\\\\n    value *= Math.max(265 - armor, 1) / 256;\\\\\\\\n    value *= power / 16;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = a.mat + power;\\\\\\\\n    value *= Math.max(265 - armor, 1) / 4;\\\\\\\\n    value *= power / 256;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value = (power + a.def) * power / 2;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value = (power + a.mdf) * power / 2;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF9\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Damage Constant\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\nif (this.isCertainHit()) {\\\\\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Declare Main Stats\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(b, armor);\\\\\\\\nlet stat = 1;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    stat = a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    stat = a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Declare Base Damage\\\\\\\\nlet baseDamage = power;\\\\\\\\nif (this.isPhysical()) {\\\\\\\\n    baseDamage += stat;\\\\\\\\n}\\\\\\\\nif (this.isDamage() || this.isDrain()) {\\\\\\\\n    baseDamage -= armor;\\\\\\\\n    baseDamage = Math.max(1, baseDamage);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Declare Bonus Damage\\\\\\\\nlet bonusDamage = stat + (((a.level || a.luk) + stat) / 8);\\\\\\\\n\\\\\\\\n// Declare Final Damage\\\\\\\\nlet value = baseDamage * bonusDamage * sign;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF10\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Damage Constant\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\nif (this.isCertainHit()) {\\\\\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Create Damage Offense Value\\\\\\\\nlet value = power;\\\\\\\\n\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = (((a.atk ** 3) / 32) + 32) * power / 16;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = power * ((a.mat ** 2 / 6) + power) / 4;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value = power * ((a.def + power) / 2);\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value = power * ((a.mdf + power) / 2);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Apply Damage Defense Value\\\\\\\\nif (this.isDamage() || this.isDrain()) {\\\\\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\n    armor = this.applyArmorModifiers(b, armor);\\\\\\\\n    armor = Math.max(armor, 1);\\\\\\\\n    value *= ((((armor - 280.4) ** 2) / 110) / 16) / 730;\\\\\\\\n    value *= (730 - (armor * 51 - (armor ** 2) / 11) / 10) / 730;\\\\\\\\n} else if (this.isRecover()) {\\\\\\\\n    value *= -1;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"MK\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nconst denominator = Math.max(200 + armor, 1);\\\\\\\\n\\\\\\\\n// Calculate Damage \\\\\\\\nlet value = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = 200 * a.atk / denominator;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = 200 * a.mat / denominator;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value = 200 * a.def / 200;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value = 200 * a.mdf / 200;\\\\\\\\n}\\\\\\\\nvalue *= multiplier;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"MOBA\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Damage Value\\\\\\\\nlet value = Math.max(eval(item.damage.formula), 0) * sign;\\\\\\\\n\\\\\\\\n// Apply Attacker's Offense Parameter\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value *= a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value *= a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Apply Defender's Defense Parameter\\\\\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\\\\\n\\\\\\\\n    // Calculate Base Armor\\\\\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\\\\\n\\\\\\\\n    // Apply Armor to Damage\\\\\\\\n    if (armor >= 0) {\\\\\\\\n        value *= 100 / (100 + armor);\\\\\\\\n    } else {\\\\\\\\n        value *= 2 - (100 / (100 - armor));\\\\\\\\n    }\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"PKMN\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Power\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet value = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\\\\\nlet attackStat = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat =  a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nvalue = (((((2 * level) / 5) + 2) * power * (attackStat / armor)) / 50) + 2;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\"]","Cap":"","EnableDamageCap:eval":"false","DefaultHardCap:num":"9999","EnableSoftCap:eval":"false","DefaultSoftCap:num":"0.80","DefaultSoftScaler:num":"0.1275","Popups":"","PopupDuration:num":"128","NewPopupBottom:eval":"true","PopupPosition:str":"base","PopupOffsetX:num":"0","PopupOffsetY:num":"0","PopupShiftX:num":"8","PopupShiftY:num":"-28","hpDamageFmt:str":"-%1","hpHealingFmt:str":"+%1","mpDamageFmt:str":"-%1 %2","mpHealingFmt:str":"+%1 %2","CriticalColor:eval":"[255, 0, 0, 160]","CriticalDuration:num":"128","Formulas":"","OverallFormulaJS:func":"\"// Declare Constants\\nconst target = arguments[0];\\nconst critical = arguments[1];\\nconst item = this.item();\\n\\n// Get Base Damage\\nconst baseValue = this.evalDamageFormula(target);\\n\\n// Calculate Element Modifiers\\nlet value = baseValue * this.calcElementRate(target);\\n\\n// Calculate Physical and Magical Modifiers\\nif (this.isPhysical()) {\\n    value *= target.pdr;\\n}\\nif (this.isMagical()) {\\n    value *= target.mdr;\\n}\\n\\n// Apply Healing Modifiers\\nif (baseValue < 0) {\\n    value *= target.rec;\\n}\\n\\n// Apply Critical Modifiers\\nif (critical) {\\n    value = this.applyCritical(value);\\n}\\n\\n// Apply Variance and Guard Modifiers\\nvalue = this.applyVariance(value, item.damage.variance);\\nvalue = this.applyGuard(value, target);\\n\\n// Finalize Damage\\nvalue = Math.round(value);\\nreturn value;\"","VarianceFormulaJS:func":"\"// Declare Constants\\nconst damage = arguments[0];\\nconst variance = arguments[1];\\n\\n// Calculate Variance\\nconst amp = Math.floor(Math.max((Math.abs(damage) * variance) / 100, 0));\\nconst v = Math.randomInt(amp + 1) + Math.randomInt(amp + 1) - amp;\\n\\n// Return Damage\\nreturn damage >= 0 ? damage + v : damage - v;\"","GuardFormulaJS:func":"\"// Declare Constants\\nconst damage = arguments[0];\\nconst target = arguments[1];\\n\\n// Return Damage Early\\nconst note = this.item().note;\\nif (note.match(/<UNBLOCKABLE>/i)) return damage;\\nif (!target.isGuard()) return damage;\\nif (damage < 0) return damage;\\n\\n// Declare Guard Rate\\nlet guardRate = 0.5;\\nguardRate /= target.grd;\\n\\n// Return Damage\\nreturn damage * guardRate;\"","Critical":"","CriticalHitRateJS:func":"\"// Declare Constants\\nconst user = this.subject();\\nconst target = arguments[0];\\n\\n// Create Base Critical Rate\\nlet rate = this.subject().cri * (1 - target.cev);\\n\\n// Apply Notetags\\nconst note = this.item().note;\\nif (note.match(/<ALWAYS CRITICAL>/i)) {\\n    return 1;\\n}\\nif (note.match(/<SET CRITICAL RATE:[ ](\\\\d+)([%％])>/i)) {\\n    return Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL RATE:[ ](\\\\d+)([%％])>/i)) {\\n    rate *= Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL RATE:[ ]([\\\\+\\\\-]\\\\d+)([%％])>/i)) {\\n    rate += Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<JS CRITICAL RATE>\\\\s*([\\\\s\\\\S]*)\\\\s*<\\\\/JS CRITICAL RATE>/i)) {\\n    const code = String(RegExp.$1);\\n    try {\\n        eval(code);\\n    } catch (e) {\\n        if ($gameTemp.isPlaytest()) console.log(e);\\n    }\\n}\\n\\n// Apply LUK Buffs/Debuffs\\nconst lukStack = this.subject().buff(7);\\nrate *= 2 ** lukStack;\\n\\n// Return Rate\\nreturn rate;\"","CriticalHitMultiplier:func":"\"// Declare Constants\\nconst user = this.subject();\\nlet damage = arguments[0];\\nlet multiplier = 2.0;\\nlet bonusDamage = this.subject().luk * this.subject().cri;\\nif (this.isHpRecover() || this.isMpRecover()) {\\n    bonusDamage *= -1;\\n}\\n\\n// Apply Notetags\\nconst note = this.item().note;\\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ](\\\\d+)([%％])>/i)) {\\n    multiplier = Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ]([\\\\+\\\\-]\\\\d+)([%％])>/i)) {\\n    multiplier += Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ](\\\\d+)([%％])>/i)) {\\n    bonusDamage *= Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ]([\\\\+\\\\-]\\\\d+)([%％])>/i)) {\\n    bonusDamage += bonusDamage * (RegExp.$1) / 100;\\n}\\nif (note.match(/<JS CRITICAL DAMAGE>\\\\s*([\\\\s\\\\S]*)\\\\s*<\\\\/JS CRITICAL DAMAGE>/i)) {\\n    const code = String(RegExp.$1);\\n    try {\\n        eval(code);\\n    } catch (e) {\\n        if ($gameTemp.isPlaytest()) console.log(e);\\n    }\\n}\\n\\n// Return Damage\\nreturn damage * multiplier + bonusDamage;\""}
 *
 * @param Mechanics:struct
 * @text Mechanics Settings
 * @type struct<Mechanics>
 * @desc Settings pertaining to various game mechanics.
 * @default {"ActionSpeed":"","AllowRandomSpeed:eval":"false","CalcActionSpeedJS:func":"\"// Declare Constants\\nconst agi = this.subject().agi;\\n\\n// Create Speed\\nlet speed = agi;\\nif (this.allowRandomSpeed()) {\\n    speed += Math.randomInt(Math.floor(5 + agi / 4));\\n}\\nif (this.item()) {\\n    speed += this.item().speed;\\n}\\nif (this.isAttack()) {\\n    speed += this.subject().attackSpeed();\\n}\\n\\n// Return Speed\\nreturn speed;\"","BaseTroop":"","BaseTroopIDs:arraynum":"[\"1\"]","CommonEvents":"","BattleStartEvent:num":"0","BattleEndEvent:num":"0","VictoryEvent:num":"0","DefeatEvent:num":"0","EscapeSuccessEvent:num":"0","EscapeFailEvent:num":"0","Escape":"","CalcEscapeRatioJS:func":"\"// Calculate Escape Ratio\\nlet ratio = 0.5;\\nratio *= $gameParty.agility();\\nratio /= $gameTroop.agility();\\n\\n// Return Ratio\\nreturn ratio;\"","CalcEscapeRaiseJS:func":"\"// Calculate Escape Ratio\\nlet value = 0.1;\\nvalue += $gameParty.aliveMembers().length;\\n\\n// Return Value\\nreturn value;\"","BattleJS":"","PreStartBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostStartBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","BattleVictoryJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","EscapeSuccessJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","EscapeFailureJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","BattleDefeatJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PreEndBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostEndBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","TurnJS":"","PreStartTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostStartTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PreEndTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostEndTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PreRegenerateJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostRegenerateJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","ActionJS":"","PreStartActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\"","PostStartActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\"","PreApplyJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PreDamageJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PostDamageJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PostApplyJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PreEndActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\"","PostEndActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\""}
 *
 * @param CmdWindows
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param BattleLayout:struct
 * @text Battle Layout Settings
 * @type struct<BattleLayout>
 * @desc Settings that adjust how the battle layout appears.
 * @default {"Style:str":"default","ListStyle":"","ShowFacesListStyle:eval":"true","CommandWidth:num":"192","XPStyle":"","XPActorCommandLines:num":"4","XPActorDefaultHeight:num":"64","XPSpriteYLocation:str":"name","PotraitStyle":"","ShowPortraits:eval":"true","PortraitScale:num":"0.5","BorderStyle":"","SkillItemBorderCols:num":"1","ShowPortraitsBorderStyle:eval":"true","PortraitScaleBorderStyle:num":"1.25","SkillItemWindows":"","SkillItemMiddleLayout:eval":"false","SkillItemStandardCols:num":"2"}
 *
 * @param BattleLog:struct
 * @text Battle Log Settings
 * @type struct<BattleLog>
 * @desc Settings that adjust how Window_BattleLog behaves.
 * @default {"General":"","BackColor:str":"#000000","MaxLines:num":"10","MessageWait:num":"16","TextAlign:str":"center","BattleLogRectJS:func":"\"const wx = 0;\\nconst wy = 0;\\nconst ww = Graphics.boxWidth;\\nconst wh = this.calcWindowHeight(10, false);\\nreturn new Rectangle(wx, wy, ww, wh);\"","StartTurn":"","StartTurnShow:eval":"true","StartTurnMsg:str":"Turn %1","StartTurnWait:num":"40","DisplayAction":"","ActionCenteredName:eval":"true","ActionSkillMsg1:eval":"false","ActionSkillMsg2:eval":"true","ActionItemMsg:eval":"false","ActionChanges":"","ShowCounter:eval":"true","ShowReflect:eval":"true","ShowSubstitute:eval":"true","ActionResults":"","ShowFailure:eval":"false","ShowCritical:eval":"false","ShowMissEvasion:eval":"false","ShowHpDmg:eval":"false","ShowMpDmg:eval":"false","ShowTpDmg:eval":"false","DisplayStates":"","ShowAddedState:eval":"false","ShowRemovedState:eval":"false","ShowCurrentState:eval":"false","ShowAddedBuff:eval":"false","ShowAddedDebuff:eval":"false","ShowRemovedBuff:eval":"false"}
 *
 * @param BattlebackScale:struct
 * @text Battleback Scaling
 * @type struct<Battleback>
 * @desc Settings that adjust how battlebacks scale.
 * @default {"DefaultStyle:str":"MZ","jsOneForOne:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst scale = 1.0;\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = 0;\\nthis.y = 0;\"","jsScaleToFit:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst ratioX = this.width / this.bitmap.width;\\nconst ratioY = this.height / this.bitmap.height;\\nconst scale = Math.max(ratioX, ratioY);\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = (Graphics.width - this.width) / 2;\\nthis.y = Graphics.height - this.height;\"","jsScaleDown:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst ratioX = Math.min(1, this.width / this.bitmap.width);\\nconst ratioY = Math.min(1, this.height / this.bitmap.height);\\nconst scale = Math.max(ratioX, ratioY);\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = (Graphics.width - this.width) / 2;\\nthis.y = Graphics.height - this.height;\"","jsScale Up:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst ratioX = Math.max(1, this.width / this.bitmap.width);\\nconst ratioY = Math.max(1, this.height / this.bitmap.height);\\nconst scale = Math.max(ratioX, ratioY);\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = (Graphics.width - this.width) / 2;\\nthis.y = Graphics.height - this.height;\""}
 *
 * @param PartyCmd:struct
 * @text Party Command Window
 * @type struct<PartyCmd>
 * @desc Settings that alter the Party Command Window in battle.
 * @default {"Cmd":"","CmdStyle:str":"auto","CmdTextAlign:str":"left","CmdIconFight:num":"76","CommandAddAutoBattle:eval":"true","CmdIconAutoBattle:num":"78","CmdTextAutoBattle:str":"Auto","CommandAddOptions:eval":"true","CmdIconOptions:num":"83","ActiveTpbOptionsMessage:str":"Options Menu queued after action is complete.","CmdIconEscape:num":"82","Access":"","SkipPartyCmd:eval":"true","DisablePartyCmd:eval":"false","HelpWindow":"","HelpFight:str":"Select actions to fight.","HelpAutoBattle:str":"Sets party to Auto Battle mode.","HelpOptions:str":"Opens up the Options Menu.","HelpEscape:str":"Attempt to escape the battle."}
 *
 * @param ActorCmd:struct
 * @text Actor Command Window
 * @type struct<ActorCmd>
 * @desc Settings that alter the Actor Command Window in battle.
 * @default {"Cmd":"","CmdStyle:str":"auto","CmdTextAlign:str":"left","CmdIconItem:num":"176","IconStypeNorm:num":"78","IconStypeMagic:num":"79","BattleCmd":"","BattleCmdList:arraystr":"[\"attack\",\"skills\",\"guard\",\"item\",\"escape\"]","ShowCosts:eval":"true","HelpWindow":"","HelpSkillType:str":"Opens up a list of skills under the \\C[16]%1\\C[0] category.","HelpItem:str":"Opens up a list of items that you can use.","HelpEscape:str":"Attempt to escape the battle.","HelpAutoBattle:str":"Automatically choose an action suitable for combat.","HelpParty:str":"Automatically choose an action suitable for combat."}
 *
 * @param InBattleStatus:struct
 * @text In-Battle Status Window
 * @type struct<InBattleStatus>
 * @desc Settings that alter the In-Battle Status window accessed
 * through the "Status" command.
 * @default {"General":"","CmdIconStatus:num":"87","StatusGraphic:str":"face","HelpStatus:str":"View battle member status.","Enemy":"","enemyStatus:eval":"true","enemyShowLevel:eval":"true","enemyHiddenParameter:str":"???","enemyShowParametersAlways:eval":"false","enemyShowParametersIfBattleTest:eval":"true","enemyShowParametersIfDefeated:eval":"true","PageButtons":"","pageOffsetX:num":"+0","pageOffsetY:num":"+0","pageButtons:eval":"true","Parameters":"","buffValueFmt:str":"▲%1","debuffValueFmt:str":"▼%1","States":"","statesMaxWidth:num":"384","drawStates:eval":"true","drawBuffs:eval":"true","drawDebuffs:eval":"true","BuffsDebuffs":"","buffNameFmt:str":"%1▲","debuffNameFmt:str":"%1▼","NormalState":"","normalIcon:num":"84","normalText:str":"Normal","HelpDesc":"","stateHelpFmt:json":"\"%1 %2\"","buffHelpFmt:json":"\"Increases %1 to %3%2\\\\C[0]. %4\"","debuffHelpFmt:json":"\"Decreases %1 to %3%2\\\\C[0]. %4\"","normalHelp:json":"\"Status is currently normal.\"","TurnHelpDesc":"","actionsFmt:str":"\\C[6](Actions %2%1\\C[6])\\C[0]","TurnsFmt:str":"\\C[5](Turns %2%1\\C[5])\\C[0]","passiveText:str":"\\C[4](Passive)\\C[0]","Window":"","StatusWindow_BgType:num":"0","StatusWindow_DrawJS:func":"\"{ // Draw Face and Simple Status\\n    const x = this.colSpacing() / 2;\\n    const h = ImageManager.faceHeight;\\n    const y = h / 2 - this.lineHeight() * 1.5;\\n    this.drawActorGraphic(this._battler, x + 1, 0, ImageManager.faceWidth, h);\\n    this.drawActorSimpleStatus(this._battler, x + 180, y);\\n}\\n{ // Draw Actor Parameters\\n    let maxWidth = this.drawingAreaWidth();\\n    let x1 = 0;\\n    let x2 = Math.ceil(this.drawingAreaWidth() / 2);\\n\\n    let counter = 0;\\n    const params = this.displayedParams();\\n\\n    let px = x1;\\n    const availableHeight = this.innerHeight - ImageManager.faceHeight;\\n    const paramHeight = Math.ceil(params.length / 2) * this.lineHeight();\\n    let py = Math.ceil((availableHeight - paramHeight) / 2) + ImageManager.faceHeight;\\n    let pw = Math.floor(maxWidth / 2);\\n\\n    if (this._statesWindow.y !== 0) {\\n        this._statesWindow.y = py;\\n    }\\n\\n    for (const param of params) {\\n        this.drawDarkRect(px, py, pw, this.lineHeight());\\n        this.drawParamData(param, px, py, pw);\\n        counter++;\\n        if (counter % 2 === 0) {\\n            px = x1;\\n            py += this.lineHeight();\\n        } else {\\n            px = x2;\\n        }\\n    }\\n}\"","StatusWindow_RectJS:func":"\"const wx = Graphics.boxWidth > 1000 ? 120 : 0;\\nconst wy = this._helpWindow.y + this._helpWindow.height;\\nconst ww = Graphics.boxWidth - (wx * 2);\\nconst wh = Graphics.boxHeight - wy - this.windowAreaHeight();\\nreturn new Rectangle(wx, wy, ww, wh);\""}
 * 
 * @param MultiTarget:struct
 * @text Multi-Target Windows
 * @type struct<MultiTarget>
 * @desc Settings that alter the Multi-Target Windows in battle.
 * @default {"Properties":"","WindowWidth:num":"280","BgType:num":"2","ShowButton:eval":"true","Vocab":"","AllActorsText:str":"All Allies","AllEnemiesText:str":"All Enemies","Offsets":"","ActorOffsets":"","ActorOffsetX:num":"+0","ActorOffsetY:num":"+0","EnemyOffsets":"","EnemyOffsetX:num":"+0","EnemyOffsetY:num":"+0"}
 * 
 * @param ComboWindow:struct
 * @text Damage Combo Window
 * @type struct<ComboWindow>
 * @desc Settings that alter the damage/healing combo window displayed in battle.
 * @default {"General":"","Enable:eval":"true","Appearance":"","CustomFontFace:str":"Arial","TextAlign:str":"left","ComboWindow_DrawJS:func":"\"// Declare Coordinates\\nlet x = 0;\\nlet y = 0;\\n\\n// Hit Text\\nconst hitText = this.hitText();\\nconst hitTextSize = this.textSizeEx(hitText);\\nif (this.textAlignment() === 'right') {\\n    x = this.innerWidth - this.itemPadding() - hitTextSize.width;\\n} else if (this.textAlignment() === 'center') {\\n    x = Math.floor((this.innerWidth - hitTextSize.width) / 2);\\n} else {\\n    x = this.itemPadding();\\n}\\nthis.drawTextEx(hitText, x, y);\\n\\n// New Line\\ny += Math.ceil(this.lineHeight() * 2/3);\\n\\n// Damage Text\\nconst dmgText = this.damageText();\\nconst dmgTextSize = this.textSizeEx(dmgText);\\nif (this.textAlignment() === 'right') {\\n    x = this.innerWidth - this.itemPadding() - dmgTextSize.width;\\n} else if (this.textAlignment() === 'center') {\\n    x = Math.floor((this.innerWidth - dmgTextSize.width) / 2);\\n} else {\\n    x = this.itemPadding();\\n}\\nthis.drawTextEx(dmgText, x, y);\"","Vocab":"","hitsDmgFmt:str":"\\C[6]%1\\} \\C[4]Hit Combo\\C[0]\\{","hitsHealFmt:str":"\\C[6]%1\\} \\C[4]Heal Combo\\C[0]\\{","totalDmgFmt:str":"\\}\\C[21]Total Damage: \\{\\C[0]%1","totalHealFmt:str":"\\}\\C[21]Total Healing: \\{\\C[24]+%1\\C[0]","Position":"","fadeShiftX:num":"-2","fadeShiftY:num":"+0","PosOffsetX:num":"+0","PosOffsetY:num":"+0","ComboWindow_RectJS:func":"\"const ww = Math.ceil(Graphics.width / 4);\\nconst wh = this.calcWindowHeight(2, true);\\nconst wx = 0 + this.comboWindowOffsetX();\\nconst wy = Math.round(Graphics.boxHeight * 1 / 3) + this.comboWindowOffsetY();\\nreturn new Rectangle(wx, wy, ww, wh);\"","Update":"","updateDuration:num":"20","minimumStayDuration:num":"40","minimumHits:num":"1","opacitySpeed:num":"16"}
 *
 * @param VisualBreak
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param Actor:struct
 * @text Actor Battler Settings
 * @type struct<Actor>
 * @desc Settings that alter various properties for actors.
 * @default {"Flinch":"","FlinchDistanceX:num":"12","FlinchDistanceY:num":"0","FlinchDuration:num":"6","SvBattlers":"","AnchorX:num":"0.5","AnchorY:num":"1.0","ChantStyle:eval":"true","OffsetX:num":"0","OffsetY:num":"0","MotionSpeed:num":"12","PrioritySortActive:eval":"true","PrioritySortActors:eval":"false","Shadow:eval":"true","SmoothImage:eval":"true","HomePosJS:func":"\"// Declare Constants\\nconst sprite = this;\\nconst actor = this._actor;\\nconst index = arguments[0];\\n\\n// Make Calculations\\nlet x = Math.round((Graphics.width / 2) + 192)\\nx -= Math.floor((Graphics.width - Graphics.boxWidth) / 2);\\nx += index * 32;\\nlet y = (Graphics.height - 200) - ($gameParty.maxBattleMembers() * 48);\\ny -= Math.floor((Graphics.height - Graphics.boxHeight) / 2);\\ny += index * 48;\\n\\n// Home Position Offsets\\nconst offsetNote = /<SIDEVIEW HOME OFFSET:[ ]([\\\\+\\\\-]\\\\d+),[ ]([\\\\+\\\\-]\\\\d+)>/i;\\nconst xOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$1) : 0));\\nconst yOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$2) : 0));\\nx = xOffsets.reduce((r, offset) => r + offset, x);\\ny = yOffsets.reduce((r, offset) => r + offset, y);\\n\\n// Set Home Position\\nthis.setHome(x, y);\""}
 *
 * @param Enemy:struct
 * @text Enemy Battler Settings
 * @type struct<Enemy>
 * @desc Settings that alter various properties for enemies.
 * @default {"Visual":"","AttackAnimation:num":"1","EmergeText:eval":"false","OffsetX:num":"0","OffsetY:num":"0","SmoothImage:eval":"true","SelectWindow":"","FrontViewSelect:eval":"false","SideviewSelect:eval":"true","NameFontSize:num":"22","SvBattlers":"","AllowCollapse:eval":"false","AnchorX:num":"0.5","AnchorY:num":"1.0","MotionIdle:str":"walk","Shadow:eval":"true","Width:num":"64","Height:num":"64","WtypeId:num":"0"}
 *
 * @param HpGauge:struct
 * @text HP Gauge Settings
 * @type struct<HpGauge>
 * @desc Settings that adjust the visual HP Gauge displayed in battle.
 * @default {"Display":"","ShowActorGauge:eval":"false","ShowEnemyGauge:eval":"true","RequiresDefeat:eval":"false","BTestBypass:eval":"true","Settings":"","AnchorX:num":"0.5","AnchorY:num":"1.0","Scale:num":"0.5","OffsetX:num":"0","OffsetY:num":"-3","Options":"","AddHpGaugeOption:eval":"true","AdjustRect:eval":"true","Name:str":"Show HP Gauge"}
 *
 * @param ActionSequence:struct
 * @text Action Sequence Settings
 * @type struct<ActionSequence>
 * @desc Settings that adjust how certain Action Sequences work.
 * @default {"AutoSequences":"","AutoMeleeSolo:eval":"true","AutoMeleeAoE:eval":"true","CastAnimations":"","CastCertain:num":"120","CastPhysical:num":"52","CastMagical:num":"51","CounterReflection":"","CounterPlayback:eval":"true","ReflectAnimation:num":"53","ReflectPlayback:eval":"true","Stepping":"","MeleeDistance:num":"24","StepDistanceX:num":"48","StepDistanceY:num":"0","StepDuration:num":"12"}
 *
 * @param BreakEnd1
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param End Of
 * @default Plugin Parameters
 *
 * @param BreakEnd2
 * @text --------------------------
 * @default ----------------------------------
 *
 */
/* ----------------------------------------------------------------------------
 * Auto Battle Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~AutoBattle:
 *
 * @param BattleDisplay
 * @text Battle Display
 *
 * @param AutoBattleMsg:str
 * @text Message
 * @parent BattleDisplay
 * @desc Message that's displayed when Auto Battle is on.
 * Text codes allowed. %1 - OK button, %2 - Cancel button
 * @default Press %1 or %2 to stop Auto Battle
 *
 * @param AutoBattleOK:str
 * @text OK Button
 * @parent BattleDisplay
 * @desc Text used to represent the OK button.
 * If VisuMZ_0_CoreEngine is present, ignore this.
 * @default OK
 *
 * @param AutoBattleCancel:str
 * @text Cancel Button
 * @parent BattleDisplay
 * @desc Text used to represent the Cancel button.
 * If VisuMZ_0_CoreEngine is present, ignore this.
 * @default Cancel
 *
 * @param AutoBattleBgType:num
 * @text Background Type
 * @parent BattleDisplay
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for Auto Battle window.
 * @default 1
 *
 * @param AutoBattleRect:func
 * @text JS: X, Y, W, H
 * @parent BattleDisplay
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const width = Graphics.width;\nconst height = this.calcWindowHeight(1, false);\nconst x = 0;\nconst y = (Graphics.height - height) / 2;\nreturn new Rectangle(x, y, width, height);"
 *
 * @param Options
 *
 * @param AddOption:eval
 * @text Add Option?
 * @parent Options
 * @type boolean
 * @on Add
 * @off Don't Add
 * @desc Add the Auto Battle options to the Options menu?
 * @default true
 *
 * @param AdjustRect:eval
 * @text Adjust Window Height
 * @parent Options
 * @type boolean
 * @on Adjust
 * @off Don't
 * @desc Automatically adjust the options window height?
 * @default true
 *
 * @param StartName:str
 * @text Startup Name
 * @parent Options
 * @desc Command name of the option.
 * @default Auto Battle Start
 *
 * @param StyleName:str
 * @text Style Name
 * @parent Options
 * @desc Command name of the option.
 * @default Auto Battle Style
 *
 * @param StyleOFF:str
 * @text OFF
 * @parent StyleName:str
 * @desc Text displayed when Auto Battle Style is OFF.
 * @default Attack
 *
 * @param StyleON:str
 * @text ON
 * @parent StyleName:str
 * @desc Text displayed when Auto Battle Style is ON.
 * @default Skills
 *
 */
/* ----------------------------------------------------------------------------
 * Damage Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Damage:
 *
 * @param DamageStyles
 * @text Damage Styles
 *
 * @param DefaultDamageStyle:str
 * @text Default Style
 * @parent DamageStyles
 * @desc Which Damage Style do you want to set as default?
 * Use 'Manual' to not use any styles at all.
 * @default Standard
 *
 * @param DamageStyleList:arraystruct
 * @text Style List
 * @parent DamageStyles
 * @type struct<DamageStyle>[]
 * @desc A list of the damage styles available.
 * These are used to calculate base damage.
 * @default ["{\"Name:str\":\"Standard\",\"Formula:func\":\"\\\"// Declare Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Replace Formula\\\\nlet formula = item.damage.formula;\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 0)';\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\n}\\\\n\\\\n// Calculate Damage\\\\nlet value = Math.max(eval(formula), 0);\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"return this.getItemDamageAmountTextOriginal();\\\"\"}","{\"Name:str\":\"Armor Scaling\",\"Formula:func\":\"\\\"// Declare Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Replace Formula\\\\nlet formula = item.damage.formula;\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 1)';\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\n}\\\\n\\\\n// Calculate Damage\\\\nlet value = Math.max(eval(formula), 0);\\\\n\\\\n// Apply Defender's Defense Parameter\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\n\\\\n    // Calculate Base Armor\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\n\\\\n    // Apply Armor to Damage\\\\n    if (armor >= 0) {\\\\n        value *= 100 / (100 + armor);\\\\n    } else {\\\\n        value *= 2 - (100 / (100 - armor));\\\\n    }\\\\n}\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"return this.getItemDamageAmountTextOriginal();\\\"\"}","{\"Name:str\":\"CT\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet value = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\nlet attackStat = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat =  a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    attackStat =  a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    attackStat =  a.mdf;\\\\n}\\\\n\\\\n// Calculate Damage\\\\nattackStat = (attackStat * 1.75) + (level ** 2 / 45.5);\\\\nvalue = attackStat * 4;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= Math.max(256 - armor, 0) / 256;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= Math.max(102.4 - armor, 0) / 128;\\\\n}\\\\nvalue *= multiplier;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"D4\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nlet stat = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    stat = a.def;\\\\n    armor = 0;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    stat = a.mdf;\\\\n    armor = 0;\\\\n}\\\\n\\\\n// Calculate Damage \\\\nlet value = 1.5 * Math.max(2 * stat * multiplier - armor, 1) * multiplier / 5;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"DQ\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nlet multiplier = Math.max(eval(item.damage.formula), 0);\\\\nif (this.isCertainHit()) {\\\\n    let value = multiplier * Math.max(a.atk, a.mat);\\\\n    return (isNaN(value) ? 0 : value) * sign;\\\\n}\\\\n\\\\n// Get Primary Stats\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(b, armor);\\\\nlet stat = 1;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    stat = a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    stat = a.mdf;\\\\n}\\\\n\\\\n// Check for Recovery\\\\nif (this.isRecover()) {\\\\n    let value = stat * multiplier * sign;\\\\n    return isNaN(value) ? 0 : value;\\\\n}\\\\n\\\\n// Calculate Damage\\\\nlet value = 0;\\\\nif (stat < ((2 + armor) / 2)) {\\\\n    // Plink Damage\\\\n    let baseline = Math.max(stat - ((12 * (armor - stat + 1)) / stat), 5);\\\\n    value = baseline / 3;\\\\n} else {\\\\n    // Normal Damage\\\\n    let baseline = Math.max(stat - (armor / 2), 1);\\\\n    value = baseline / 2;\\\\n}\\\\nvalue *= multiplier;\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF7\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Power\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare base Damage\\\\nlet baseDamage = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    baseDamage = a.atk + ((a.atk + level) / 32) * ((a.atk * level) / 32);\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    baseDamage = 6 * (a.mat + level);\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    baseDamage = 6 * (a.def + level);\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    baseDamage = 6 * (a.mdf + level);\\\\n}\\\\n\\\\n// Calculate Final Damage\\\\nlet value = baseDamage;\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nif (this.isRecover()) {\\\\n    value += 22 * power;\\\\n} else {\\\\n    value = (power * Math.max(512 - armor, 1) * baseDamage) / (16 * 512);\\\\n}\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF8\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Power\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Damage\\\\nlet Value = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value = a.atk ** 2 / 16 + a.atk;\\\\n    value *= Math.max(265 - armor, 1) / 256;\\\\n    value *= power / 16;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value = a.mat + power;\\\\n    value *= Math.max(265 - armor, 1) / 4;\\\\n    value *= power / 256;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value = (power + a.def) * power / 2;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value = (power + a.mdf) * power / 2;\\\\n}\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF9\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Damage Constant\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\nif (this.isCertainHit()) {\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\n}\\\\n\\\\n// Declare Main Stats\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(b, armor);\\\\nlet stat = 1;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    stat = a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    stat = a.mdf;\\\\n}\\\\n\\\\n// Declare Base Damage\\\\nlet baseDamage = power;\\\\nif (this.isPhysical()) {\\\\n    baseDamage += stat;\\\\n}\\\\nif (this.isDamage() || this.isDrain()) {\\\\n    baseDamage -= armor;\\\\n    baseDamage = Math.max(1, baseDamage);\\\\n}\\\\n\\\\n// Declare Bonus Damage\\\\nlet bonusDamage = stat + (((a.level || a.luk) + stat) / 8);\\\\n\\\\n// Declare Final Damage\\\\nlet value = baseDamage * bonusDamage * sign;\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF10\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Damage Constant\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\nif (this.isCertainHit()) {\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\n}\\\\n\\\\n// Create Damage Offense Value\\\\nlet value = power;\\\\n\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value = (((a.atk ** 3) / 32) + 32) * power / 16;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value = power * ((a.mat ** 2 / 6) + power) / 4;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value = power * ((a.def + power) / 2);\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value = power * ((a.mdf + power) / 2);\\\\n}\\\\n\\\\n// Apply Damage Defense Value\\\\nif (this.isDamage() || this.isDrain()) {\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\n    armor = this.applyArmorModifiers(b, armor);\\\\n    armor = Math.max(armor, 1);\\\\n    value *= ((((armor - 280.4) ** 2) / 110) / 16) / 730;\\\\n    value *= (730 - (armor * 51 - (armor ** 2) / 11) / 10) / 730;\\\\n} else if (this.isRecover()) {\\\\n    value *= -1;\\\\n}\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"MK\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nconst denominator = Math.max(200 + armor, 1);\\\\n\\\\n// Calculate Damage \\\\nlet value = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value = 200 * a.atk / denominator;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value = 200 * a.mat / denominator;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value = 200 * a.def / 200;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value = 200 * a.mdf / 200;\\\\n}\\\\nvalue *= multiplier;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"MOBA\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Damage Value\\\\nlet value = Math.max(eval(item.damage.formula), 0) * sign;\\\\n\\\\n// Apply Attacker's Offense Parameter\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value *= a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value *= a.mdf;\\\\n}\\\\n\\\\n// Apply Defender's Defense Parameter\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\n\\\\n    // Calculate Base Armor\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\n\\\\n    // Apply Armor to Damage\\\\n    if (armor >= 0) {\\\\n        value *= 100 / (100 + armor);\\\\n    } else {\\\\n        value *= 2 - (100 / (100 - armor));\\\\n    }\\\\n}\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"PKMN\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Power\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet value = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\nlet attackStat = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat =  a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    attackStat =  a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    attackStat =  a.mdf;\\\\n}\\\\n\\\\n// Calculate Damage\\\\nvalue = (((((2 * level) / 5) + 2) * power * (attackStat / armor)) / 50) + 2;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}"]
 *
 * @param Cap
 * @text Damage Cap
 *
 * @param EnableDamageCap:eval
 * @text Enable Damage Cap?
 * @parent Cap
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Put a maximum hard damage cap on how far damage can go?
 * This can be broken through the usage of notetags.
 * @default false
 *
 * @param DefaultHardCap:num
 * @text Default Hard Cap
 * @parent EnableDamageCap:eval
 * @type number
 * @min 1
 * @desc The default hard damage cap used before applying damage.
 * @default 9999
 *
 * @param EnableSoftCap:eval
 * @text Enable Soft Cap?
 * @parent Cap
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Soft caps ease in the damage values leading up to the 
 * hard damage cap. Requires hard Damage Cap enabled.
 * @default false
 *
 * @param DefaultSoftCap:num
 * @text Base Soft Cap Rate
 * @parent EnableSoftCap:eval
 * @desc The default soft damage cap used before applying damage.
 * @default 0.80
 *
 * @param DefaultSoftScaler:num
 * @text Soft Scale Constant
 * @parent EnableSoftCap:eval
 * @desc The default soft damage cap used before applying damage.
 * @default 0.1275
 *
 * @param Popups
 *
 * @param PopupDuration:num
 * @text Popup Duration
 * @parent Popups
 * @type number
 * @min 1
 * @desc Adjusts how many frames a popup stays visible.
 * @default 128
 *
 * @param NewPopupBottom:eval
 * @text Newest Popups Bottom
 * @parent Popups
 * @type boolean
 * @on Bottom
 * @off Top
 * @desc Puts the newest popups at the bottom.
 * @default true
 *
 * @param PopupPosition:str
 * @text Appear Position
 * @parent Popups
 * @type select
 * @option Head - At the top of the battler.
 * @value head
 * @option Center - At the center of the battler.
 * @value center
 * @option Base - At the foot of the battler.
 * @value base
 * @desc Selects where you want popups to appear relative to the battler.
 * @default base
 *
 * @param EndBattlePopups:eval
 * @text End Battle Show?
 * @parent Popups
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show or hide popups upon victory or escape?
 * Used to hide battle-state removal popups.
 * @default true
 *
 * @param PopupOffsetX:num
 * @text Offset X
 * @parent Popups
 * @desc Sets how much to offset the sprites by horizontally.
 * Negative values go left. Positive values go right.
 * @default 0
 *
 * @param PopupOffsetY:num
 * @text Offset Y
 * @parent Popups
 * @desc Sets how much to offset the sprites by vertically.
 * Negative values go up. Positive values go down.
 * @default 0
 *
 * @param PopupShiftX:num
 * @text Shift X
 * @parent Popups
 * @desc Sets how much to shift the sprites by horizontally.
 * Negative values go left. Positive values go right.
 * @default 8
 *
 * @param PopupShiftY:num
 * @text Shift Y
 * @parent Popups
 * @desc Sets how much to shift the sprites by vertically.
 * Negative values go up. Positive values go down.
 * @default -28
 *
 * @param hpDamageFmt:str
 * @text HP Damage Format
 * @parent Popups
 * @desc Determines HP damage format for popup.
 * %1 - Value, %2 - HP Text
 * @default -%1
 *
 * @param hpHealingFmt:str
 * @text HP Healing Format
 * @parent Popups
 * @desc Determines HP healing format for popup.
 * %1 - Value, %2 - HP Text
 * @default +%1
 *
 * @param mpDamageFmt:str
 * @text MP Damage Format
 * @parent Popups
 * @desc Determines MP damage format for popup.
 * %1 - Value, %2 - MP Text
 * @default -%1 %2
 *
 * @param mpHealingFmt:str
 * @text MP Healing Format
 * @parent Popups
 * @desc Determines MP healing format for popup.
 * %1 - Value, %2 - MP Text
 * @default +%1 %2
 *
 * @param CriticalColor:eval
 * @text Critical Flash Color
 * @parent Popups
 * @desc Adjust the popup's flash color.
 * Format: [red, green, blue, alpha]
 * @default [255, 0, 0, 160]
 *
 * @param CriticalDuration:num
 * @text Critical Duration
 * @parent Popups
 * @type number
 * @min 1
 * @desc Adjusts how many frames a the flash lasts.
 * @default 128
 *
 * @param Formulas
 *
 * @param OverallFormulaJS:func
 * @text JS: Overall Formula
 * @parent Formulas
 * @type note
 * @desc The overall formula used when calculating damage.
 * @default "// Declare Constants\nconst target = arguments[0];\nconst critical = arguments[1];\nconst item = this.item();\n\n// Get Base Damage\nconst baseValue = this.evalDamageFormula(target);\n\n// Calculate Element Modifiers\nlet value = baseValue * this.calcElementRate(target);\n\n// Calculate Physical and Magical Modifiers\nif (this.isPhysical()) {\n    value *= target.pdr;\n}\nif (this.isMagical()) {\n    value *= target.mdr;\n}\n\n// Apply Healing Modifiers\nif (baseValue < 0) {\n    value *= target.rec;\n}\n\n// Apply Critical Modifiers\nif (critical) {\n    value = this.applyCritical(value);\n}\n\n// Apply Variance and Guard Modifiers\nvalue = this.applyVariance(value, item.damage.variance);\nvalue = this.applyGuard(value, target);\n\n// Finalize Damage\nvalue = Math.round(value);\nreturn value;"
 *
 * @param VarianceFormulaJS:func
 * @text JS: Variance Formula
 * @parent Formulas
 * @type note
 * @desc The formula used when damage variance.
 * @default "// Declare Constants\nconst damage = arguments[0];\nconst variance = arguments[1];\n\n// Calculate Variance\nconst amp = Math.floor(Math.max((Math.abs(damage) * variance) / 100, 0));\nconst v = Math.randomInt(amp + 1) + Math.randomInt(amp + 1) - amp;\n\n// Return Damage\nreturn damage >= 0 ? damage + v : damage - v;"
 *
 * @param GuardFormulaJS:func
 * @text JS: Guard Formula
 * @parent Formulas
 * @type note
 * @desc The formula used when damage is guarded.
 * @default "// Declare Constants\nconst damage = arguments[0];\nconst target = arguments[1];\n\n// Return Damage Early\nconst note = this.item().note;\nif (note.match(/<UNBLOCKABLE>/i)) return damage;\nif (!target.isGuard()) return damage;\nif (damage < 0) return damage;\n\n// Declare Guard Rate\nlet guardRate = 0.5;\nguardRate /= target.grd;\n\n// Return Damage\nreturn damage * guardRate;"
 *
 * @param Critical
 * @text Critical Hits
 *
 * @param CriticalHitRateJS:func
 * @text JS: Rate Formula
 * @parent Critical
 * @type note
 * @desc The formula used to calculate Critical Hit Rates.
 * @default "// Declare Constants\nconst user = this.subject();\nconst target = arguments[0];\n\n// Create Base Critical Rate\nlet rate = this.subject().cri * (1 - target.cev);\n\n// Apply Notetags\nconst note = this.item().note;\nif (note.match(/<ALWAYS CRITICAL>/i)) {\n    return 1;\n}\nif (note.match(/<SET CRITICAL RATE:[ ](\\d+)([%％])>/i)) {\n    return Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL RATE:[ ](\\d+)([%％])>/i)) {\n    rate *= Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL RATE:[ ]([\\+\\-]\\d+)([%％])>/i)) {\n    rate += Number(RegExp.$1) / 100;\n}\nif (note.match(/<JS CRITICAL RATE>\\s*([\\s\\S]*)\\s*<\\/JS CRITICAL RATE>/i)) {\n    const code = String(RegExp.$1);\n    try {\n        eval(code);\n    } catch (e) {\n        if ($gameTemp.isPlaytest()) console.log(e);\n    }\n}\n\n// Apply LUK Buffs/Debuffs\nconst lukStack = this.subject().buff(7);\nrate *= 2 ** lukStack;\n\n// Return Rate\nreturn rate;"
 *
 * @param CriticalHitMultiplier:func
 * @text JS: Damage Formula
 * @parent Critical
 * @type note
 * @desc The formula used to calculate Critical Hit Damage modification.
 * @default "// Declare Constants\nconst user = this.subject();\nlet damage = arguments[0];\nlet multiplier = 2.0;\nlet bonusDamage = this.subject().luk * this.subject().cri;\n\n// Apply Notetags\nconst note = this.item().note;\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ](\\d+)([%％])>/i)) {\n    multiplier = Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ]([\\+\\-]\\d+)([%％])>/i)) {\n    multiplier += Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ](\\d+)([%％])>/i)) {\n    bonusDamage *= Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ]([\\+\\-]\\d+)([%％])>/i)) {\n    bonusDamage += bonusDamage * (RegExp.$1) / 100;\n}\nif (note.match(/<JS CRITICAL DAMAGE>\\s*([\\s\\S]*)\\s*<\\/JS CRITICAL DAMAGE>/i)) {\n    const code = String(RegExp.$1);\n    try {\n        eval(code);\n    } catch (e) {\n        if ($gameTemp.isPlaytest()) console.log(e);\n    }\n}\n\n// Return Damage\nreturn damage * multiplier + bonusDamage;"
 *
 */
/* ----------------------------------------------------------------------------
 * Damage Formula Style
 * ----------------------------------------------------------------------------
 */
/*~struct~DamageStyle:
 *
 * @param Name:str
 * @text Name
 * @desc Name of this Damage Style.
 * Used for notetags and such.
 * @default Untitled
 *
 * @param Formula:func
 * @text JS: Formula
 * @parent Name:str
 * @type note
 * @desc The base formula for this Damage Style.
 * @default "// Define Constants\nconst item = this.item();\nconst a = this.subject();\nconst b = target;\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\n\n// Create Damage Value\nlet value = Math.max(eval(item.damage.formula), 0) * sign;\n\n// Return Value\nreturn isNaN(value) ? 0 : value;"
 *
 * @param ItemsEquipsCore
 * @text Items & Equips Core
 *
 * @param DamageType
 * @text Damage Label
 * @parent ItemsEquipsCore
 *
 * @param DamageType1:str
 * @text HP Damage
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Damage Multiplier
 *
 * @param DamageType2:str
 * @text MP Damage
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Damage Multiplier
 *
 * @param DamageType3:str
 * @text HP Recovery
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Recovery Multiplier
 *
 * @param DamageType4:str
 * @text MP Recovery
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Recovery Multiplier
 *
 * @param DamageType5:str
 * @text HP Drain
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Drain Multiplier
 *
 * @param DamageType6:str
 * @text MP Drain
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Drain Multiplier
 *
 * @param DamageDisplay:func
 * @text JS: Damage Display
 * @parent ItemsEquipsCore
 * @type note
 * @desc Code used the data displayed for this category.
 * @default "// Define Constants\nconst item = this._item;\nconst formula = item.damage.formula;\nconst a = this._tempActorA;\nconst b = this._tempActorB;\nconst user = a;\nconst target = b;\n\n// Return Value\ntry {\n    const value = Math.max(eval(formula), 0);\n    return '%1%'.format(Math.round(value * 100));\n} catch (e) {\n    if ($gameTemp.isPlaytest()) {\n        console.log('Damage Formula Error for %1'.format(this._item.name));\n    }\n    return '?????';\n}"
 *
 */
/* ----------------------------------------------------------------------------
 * Mechanics Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Mechanics:
 *
 * @param ActionSpeed
 * @text Action Speed
 *
 * @param AllowRandomSpeed:eval
 * @text Allow Random Speed?
 * @parent ActionSpeed
 * @type boolean
 * @on Allow
 * @off Disable
 * @desc Allow speed to be randomized base off the user's AGI?
 * @default false
 *
 * @param SyncBuffExpire:eval
 * @text Turn End Buffs Expire
 * @parent ActionSpeed
 * @type boolean
 * @on Expire
 * @off Don't Expire
 * @desc Normally, buffs expire after all actions end.
 * But here, you can have buffs expire on turn end.
 * @default false
 *
 * @param CalcActionSpeedJS:func
 * @text JS: Calculate
 * @parent ActionSpeed
 * @type note
 * @desc Code used to calculate action speed.
 * @default "// Declare Constants\nconst agi = this.subject().agi;\n\n// Create Speed\nlet speed = agi;\nif (this.allowRandomSpeed()) {\n    speed += Math.randomInt(Math.floor(5 + agi / 4));\n}\nif (this.item()) {\n    speed += this.item().speed;\n}\nif (this.isAttack()) {\n    speed += this.subject().attackSpeed();\n}\n\n// Return Speed\nreturn speed;"
 *
 * @param BaseTroop
 * @text Base Troop
 *
 * @param BaseTroopIDs:arraynum
 * @text Base Troop ID's
 * @parent BaseTroop
 * @type troop[]
 * @desc Select the Troop ID(s) to duplicate page events from for all other troops.
 * @default ["1"]
 *
 * @param CommonEvents
 * @text Common Events (on Map)
 *
 * @param BattleStartEvent:num
 * @text Pre-Battle Event
 * @parent CommonEvents
 * @type common_event
 * @desc Common Event to run before each battle on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param BattleEndEvent:num
 * @text Post-Battle Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run after each battle on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param VictoryEvent:num
 * @text Victory Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon victory on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param DefeatEvent:num
 * @text Defeat Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon defeat on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param EscapeSuccessEvent:num
 * @text Escape Success Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon escape success on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param EscapeFailEvent:num
 * @text Escape Fail Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon escape failure on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param Escape
 *
 * @param CalcEscapeRatioJS:func
 * @text JS: Calc Escape Ratio
 * @parent Escape
 * @type note
 * @desc Code used to calculate the escape success ratio.
 * @default "// Calculate Escape Ratio\nlet ratio = 0.5;\nratio *= $gameParty.agility();\nratio /= $gameTroop.agility();\n\n// Return Ratio\nreturn ratio;"
 *
 * @param CalcEscapeRaiseJS:func
 * @text JS: Calc Escape Raise
 * @parent Escape
 * @type note
 * @desc Code used to calculate how much the escape success ratio raises upon each failure.
 * @default "// Calculate Escape Ratio\nlet value = 0.1;\nvalue += $gameParty.aliveMembers().length;\n\n// Return Value\nreturn value;"
 *
 * @param Switches
 *
 * @param SwitchCritical:num
 * @text Switch: Critical
 * @parent Switches
 * @type switch
 * @desc Turns switch ON if the action performs a critical hit.
 * Switch reverts to OFF whenever an action starts.
 * @default 0
 *
 * @param SwitchMissEvade:num
 * @text Switch: Miss/Evade
 * @parent Switches
 * @type switch
 * @desc Turns switch ON if the action misses/is evaded.
 * Switch reverts to OFF whenever an action starts.
 * @default 0
 *
 * @param Variables
 *
 * @param VariableDmg:num
 * @text Variable: Damage
 * @parent Variables
 * @type variable
 * @desc Variable records target damage during action.
 * Variable reverts to 0 whenever an action starts.
 * @default 0
 *
 * @param VariableHeal:num
 * @text Variable: Healing
 * @parent Variables
 * @type variable
 * @desc Variable records target healing during action.
 * Variable reverts to 0 whenever an action starts.
 * @default 0
 *
 * @param BattleJS
 * @text JS: Battle-Related
 * 
 * @param PreStartBattleJS:func
 * @text JS: Pre-Start Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.startBattle()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostStartBattleJS:func
 * @text JS: Post-Start Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.startBattle()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 * 
 * @param BattleVictoryJS:func
 * @text JS: Battle Victory
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.processVictory()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param EscapeSuccessJS:func
 * @text JS: Escape Success
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.onEscapeSuccess()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param EscapeFailureJS:func
 * @text JS: Escape Failure
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.onEscapeFailure()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 * 
 * @param BattleDefeatJS:func
 * @text JS: Battle Defeat
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.processDefeat()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 * 
 * @param PreEndBattleJS:func
 * @text JS: Pre-End Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.endBattle()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostEndBattleJS:func
 * @text JS: Post-End Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.endBattle()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param TurnJS
 * @text JS: Turn-Related
 *
 * @param PreStartTurnJS:func
 * @text JS: Pre-Start Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: BattleManager.startTurn()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostStartTurnJS:func
 * @text JS: Post-Start Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: BattleManager.startTurn()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PreEndTurnJS:func
 * @text JS: Pre-End Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.onTurnEnd()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostEndTurnJS:func
 * @text JS: Post-End Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.onTurnEnd()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PreRegenerateJS:func
 * @text JS: Pre-Regenerate
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.regenerateAll()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostRegenerateJS:func
 * @text JS: Post-Regenerate
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.regenerateAll()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param ActionJS
 * @text JS: Action-Related
 *
 * @param PreStartActionJS:func
 * @text JS: Pre-Start Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.startAction()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 * @param PostStartActionJS:func
 * @text JS: Post-Start Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.startAction()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 * @param PreApplyJS:func
 * @text JS: Pre-Apply
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.apply()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PreDamageJS:func
 * @text JS: Pre-Damage
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.executeDamage()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PostDamageJS:func
 * @text JS: Post-Damage
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.executeDamage()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PostApplyJS:func
 * @text JS: Post-Apply
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.apply()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PreEndActionJS:func
 * @text JS: Pre-End Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.endAction()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 * @param PostEndActionJS:func
 * @text JS: Post-End Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.endAction()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 */
/* ----------------------------------------------------------------------------
 * Battle Layout Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~BattleLayout:
 *
 * @param Style:str
 * @text Battle Layout Style
 * @type select
 * @option Default - Shows actor faces in Battle Status.
 * @value default
 * @option List - Lists actors in Battle Status.
 * @value list
 * @option XP - Shows actor battlers in a stretched Battle Status.
 * @value xp
 * @option Portrait - Shows portraits in a stretched Battle Status.
 * @value portrait
 * @option Border - Displays windows around the screen border.
 * @value border
 * @option Frontview Battle UI - Requires VisuMZ_3_FrontviewBattleUI
 * @value frontview_ui
 * @option Sideview Battle UI - Requires VisuMZ_3_SideviewBattleUI
 * @value sideview_ui
 * @desc The style used for the battle layout.
 * @default default
 *
 * @param ListStyle
 * @text List Style
 * @parent Style:str
 *
 * @param ShowFacesListStyle:eval
 * @text Show Faces
 * @parent ListStyle
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Shows faces in List Style?
 * @default true
 *
 * @param CommandWidth:num
 * @text Command Window Width
 * @parent ListStyle
 * @type number
 * @min 1
 * @desc Determine the window width for the Party and Actor Command
 * Windows. Affects Default and List Battle Layout styles.
 * @default 192
 *
 * @param XPStyle
 * @text XP Style
 * @parent Style:str
 *
 * @param XPActorCommandLines:num
 * @text Command Lines
 * @parent XPStyle
 * @type number
 * @min 1
 * @desc Number of action lines in the Actor Command Window for the XP Style.
 * @default 4
 *
 * @param XPActorDefaultHeight:num
 * @text Sprite Height
 * @parent XPStyle
 * @type number
 * @min 1
 * @desc Default sprite height used when if the sprite's height has not been determined yet.
 * @default 64
 *
 * @param XPSpriteYLocation:str
 * @text Sprite Base Location
 * @parent XPStyle
 * @type select
 * @option Above Name - Sprite is located above the name.
 * @value name
 * @option Bottom - Sprite is located at the bottom of the window.
 * @value bottom
 * @option Centered - Sprite is centered in the window.
 * @value center
 * @option Top - Sprite is located at the top of the window.
 * @value top
 * @desc Determine where the sprite is located on the Battle Status Window.
 * @default name
 *
 * @param PotraitStyle
 * @text Portrait Style
 * @parent Style:str
 *
 * @param ShowPortraits:eval
 * @text Show Portraits?
 * @parent PotraitStyle
 * @type boolean
 * @on Portraits
 * @off Faces
 * @desc Requires VisuMZ_1_MainMenuCore.
 * Shows the actor's portrait instead of a face.
 * @default true
 *
 * @param PortraitScale:num
 * @text Portrait Scaling
 * @parent PotraitStyle
 * @desc If portraits are used, scale them by this much.
 * @default 0.5
 *
 * @param BorderStyle
 * @text Border Style
 * @parent Style:str
 *
 * @param SkillItemBorderCols:num
 * @text Columns
 * @parent BorderStyle
 * @type number
 * @min 1
 * @desc The total number of columns for Skill & Item Windows
 * in the battle scene.
 * @default 1
 *
 * @param ShowPortraitsBorderStyle:eval
 * @text Show Portraits?
 * @parent BorderStyle
 * @type boolean
 * @on Portraits
 * @off Faces
 * @desc Requires VisuMZ_1_MainMenuCore.
 * Shows the actor's portrait at the edge of the screen.
 * @default true
 *
 * @param PortraitScaleBorderStyle:num
 * @text Portrait Scaling
 * @parent BorderStyle
 * @desc If portraits are used, scale them by this much.
 * @default 1.0
 *
 * @param SkillItemWindows
 * @text Skill & Item Windows
 *
 * @param SkillItemMiddleLayout:eval
 * @text Middle Layout
 * @parent SkillItemWindows
 * @type boolean
 * @on Middle
 * @off Bottom
 * @desc Shows the Skill & Item Windows in mid-screen?
 * @default false
 *
 * @param SkillItemStandardCols:num
 * @text Columns
 * @parent SkillItemWindows
 * @type number
 * @min 1
 * @desc The total number of columns for Skill & Item Windows
 * in the battle scene.
 * @default 2
 *
 * @param StatusWindow
 * @text Status Window Elements
 *
 * @param StatusWindowName
 * @text Battler Name
 * @parent StatusWindow
 *
 * @param NameOffsetX:num
 * @text Offset: X
 * @parent StatusWindowName
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param NameOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowName
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowHpGauge
 * @text Gauge 1 (HP)
 * @parent StatusWindow
 *
 * @param HpGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowHpGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param HpGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowHpGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowMpGauge
 * @text Gauge 2 (MP)
 * @parent StatusWindow
 *
 * @param MpGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowMpGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param MpGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowMpGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowTpGauge
 * @text Gauge 3 (TP)
 * @parent StatusWindow
 *
 * @param TpGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowTpGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param TpGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowTpGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowStateIcon
 * @text State Icon
 * @parent StatusWindow
 *
 * @param StateIconOffsetX:num
 * @text Offset: X
 * @parent StatusWindowStateIcon
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param StateIconOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowStateIcon
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowTpbGauge
 * @text TPB/ATB Gauge
 * @parent StatusWindow
 *
 * @param TpbGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowTpbGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param TpbGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowTpbGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowSkin
 * @text Window Skin
 * @parent StatusWindow
 *
 * @param StatusWindowSkinFilename:str
 * @text Filename
 * @parent StatusWindowSkin
 * @type file
 * @dir img/system/
 * @desc Filename used for the Battle Status Window skin.
 * Leave this empty to use the default window skin.
 * @default 
 *
 * @param StatusWindowSkinHide:eval
 * @text Hide Window Skin?
 * @parent StatusWindowSkin
 * @type boolean
 * @on No Window Skin
 * @off Default Skin
 * @desc Show/Hide the window skin for the Battle Status Window?
 * @default false
 *
 * @param StatusWindowSelectBack
 * @text Selectable Background
 * @parent StatusWindow
 *
 * @param StatusWindowSelectableBackHide:eval
 * @text Hide Selectable BG?
 * @parent StatusWindowSelectBack
 * @type boolean
 * @on No Selectable BG
 * @off Default Selectable BG
 * @desc Show/Hide the selectable background box for the Battle Status Window?
 * @default false
 *
 * @param StatusWindowAttachments
 * @text Attachments
 * @parent StatusWindow
 *
 * @param StatusWindowBackAttachment
 * @text Back Attachment
 * @parent StatusWindowAttachments
 *
 * @param StatusWindowAttachmentBack:str
 * @text Filename
 * @parent StatusWindowBackAttachment
 * @type file
 * @dir img/system/
 * @desc Filename used for an image to attach to the back of the
 * Battle Status Window. Leave empty for none.
 * @default 
 *
 * @param StatusWindowAttachmentBackOffsetX:num
 * @text Offset: X
 * @parent StatusWindowBackAttachment
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param StatusWindowAttachmentBackOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowBackAttachment
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowFrontAttachment
 * @text Front Attachment
 * @parent StatusWindowAttachments
 *
 * @param StatusWindowAttachmentFront:str
 * @text Filename
 * @parent StatusWindowFrontAttachment
 * @type file
 * @dir img/system/
 * @desc Filename used for an image to attach to the front of the
 * Battle Status Window. Leave empty for none.
 * @default 
 *
 * @param StatusWindowAttachmentFrontOffsetX:num
 * @text Offset: X
 * @parent StatusWindowFrontAttachment
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param StatusWindowAttachmentFrontOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowFrontAttachment
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param UiElements
 * @text UI Elements
 *
 * @param AntiTintUiElements:eval
 * @text Anti-Tint UI?
 * @parent UiElements
 * @type boolean
 * @on Prevent Tint
 * @off Allow Tint
 * @desc Prevent UI Elements from being tinted?
 * @default true
 *
 */
/* ----------------------------------------------------------------------------
 * Battle Log Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~BattleLog:
 *
 * @param General
 *
 * @param BackColor:str
 * @text Back Color
 * @parent General
 * @desc Use #rrggbb for a hex color.
 * @default #000000
 *
 * @param MaxLines:num
 * @text Max Lines
 * @parent General
 * @type number
 * @min 1
 * @desc Maximum number of lines to be displayed.
 * @default 10
 *
 * @param MessageWait:num
 * @text Message Wait
 * @parent General
 * @type number
 * @min 1
 * @desc Number of frames for a usual message wait.
 * @default 16
 *
 * @param TextAlign:str
 * @text Text Align
 * @parent General
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Window_BattleLog.
 * @default center
 *
 * @param BattleLogRectJS:func
 * @text JS: X, Y, W, H
 * @parent General
 * @type note
 * @desc Code used to determine the dimensions for the battle log.
 * @default "const wx = 0;\nconst wy = 0;\nconst ww = Graphics.boxWidth;\nconst wh = this.calcWindowHeight(10, false);\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param StartTurn
 * @text Start Turn
 *
 * @param StartTurnShow:eval
 * @text Show Start Turn?
 * @parent StartTurn
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display turn changes at the start of the turn?
 * @default false
 *
 * @param StartTurnMsg:str
 * @text Start Turn Message
 * @parent StartTurn
 * @desc Message displayed at turn start.
 * %1 - Turn Count
 * @default Turn %1
 *
 * @param StartTurnWait:num
 * @text Start Turn Wait
 * @parent StartTurn
 * @type number
 * @min 1
 * @desc Number of frames to wait after a turn started.
 * @default 40
 *
 * @param DisplayAction
 * @text Display Action
 *
 * @param ActionCenteredName:eval
 * @text Show Centered Action?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display a centered text of the action name?
 * @default true
 *
 * @param ActionSkillMsg1:eval
 * @text Show Skill Message 1?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the 1st skill message?
 * @default false
 *
 * @param ActionSkillMsg2:eval
 * @text Show Skill Message 2?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the 2nd skill message?
 * @default true
 *
 * @param ActionItemMsg:eval
 * @text Show Item Message?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the item use message?
 * @default false
 *
 * @param ActionChanges
 * @text Action Changes
 *
 * @param ShowCounter:eval
 * @text Show Counter?
 * @parent ActionChanges
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display counter text?
 * @default true
 *
 * @param ShowCounterWait:eval
 * @text Wait Frames
 * @parent ShowCounter:eval
 * @type number
 * @desc How many frames should the battle log wait after text?
 * 60 frames = 1 second.
 * @default 0
 *
 * @param ShowReflect:eval
 * @text Show Reflect?
 * @parent ActionChanges
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display magic reflection text?
 * @default true
 *
 * @param ShowReflectWait:eval
 * @text Wait Frames
 * @parent ShowReflect:eval
 * @type number
 * @desc How many frames should the battle log wait after text?
 * 60 frames = 1 second.
 * @default 0
 *
 * @param ShowSubstitute:eval
 * @text Show Substitute?
 * @parent ActionChanges
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display substitute text?
 * @default true
 *
 * @param ShowSubstituteWait:eval
 * @text Wait Frames
 * @parent ShowSubstitute:eval
 * @type number
 * @desc How many frames should the battle log wait after text?
 * 60 frames = 1 second.
 * @default 0
 *
 * @param ActionResults
 * @text Action Results
 *
 * @param ShowFailure:eval
 * @text Show No Effect?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display no effect text?
 * @default false
 *
 * @param ShowCritical:eval
 * @text Show Critical?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display critical text?
 * @default false
 *
 * @param ShowMissEvasion:eval
 * @text Show Miss/Evasion?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display miss/evasion text?
 * @default false
 *
 * @param ShowHpDmg:eval
 * @text Show HP Damage?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display HP Damage text?
 * @default false
 *
 * @param ShowMpDmg:eval
 * @text Show MP Damage?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display MP Damage text?
 * @default false
 *
 * @param ShowTpDmg:eval
 * @text Show TP Damage?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display TP Damage text?
 * @default false
 *
 * @param DisplayStates
 * @text Display States
 *
 * @param ShowAddedState:eval
 * @text Show Added States?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display added states text?
 * @default false
 *
 * @param ShowRemovedState:eval
 * @text Show Removed States?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display removed states text?
 * @default false
 *
 * @param ShowCurrentState:eval
 * @text Show Current States?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the currently affected state text?
 * @default false
 *
 * @param ShowAddedBuff:eval
 * @text Show Added Buffs?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display added buffs text?
 * @default false
 *
 * @param ShowAddedDebuff:eval
 * @text Show Added Debuffs?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display added debuffs text?
 * @default false
 *
 * @param ShowRemovedBuff:eval
 * @text Show Removed Buffs?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display removed de/buffs text?
 * @default false
 *
 */
/* ----------------------------------------------------------------------------
 * Battleback Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Battleback:
 *
 * @param DefaultStyle:str
 * @text Default Style
 * @type select
 * @option MZ (MZ's default style)
 * @value MZ
 * @option 1:1 (No Scaling)
 * @value 1:1
 * @option Scale To Fit (Scale to screen size)
 * @value ScaleToFit
 * @option Scale Down (Scale Downward if Larger than Screen)
 * @value ScaleDown
 * @option Scale Up (Scale Upward if Smaller than Screen)
 * @value ScaleUp
 * @desc The default scaling style used for battlebacks.
 * @default MZ
 *
 * @param jsOneForOne:func
 * @text JS: 1:1
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst scale = 1.0;\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = 0;\nthis.y = 0;"
 *
 * @param jsScaleToFit:func
 * @text JS: Scale To Fit
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst ratioX = this.width / this.bitmap.width;\nconst ratioY = this.height / this.bitmap.height;\nconst scale = Math.max(ratioX, ratioY);\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = (Graphics.width - this.width) / 2;\nthis.y = Graphics.height - this.height;"
 *
 * @param jsScaleDown:func
 * @text JS: Scale Down
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst ratioX = Math.min(1, this.width / this.bitmap.width);\nconst ratioY = Math.min(1, this.height / this.bitmap.height);\nconst scale = Math.max(ratioX, ratioY);\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = (Graphics.width - this.width) / 2;\nthis.y = Graphics.height - this.height;"
 *
 * @param jsScaleUp:func
 * @text JS: Scale Up
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst ratioX = Math.max(1, this.width / this.bitmap.width);\nconst ratioY = Math.max(1, this.height / this.bitmap.height);\nconst scale = Math.max(ratioX, ratioY);\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = (Graphics.width - this.width) / 2;\nthis.y = Graphics.height - this.height;"
 *
 */
/* ----------------------------------------------------------------------------
 * Party Command Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~PartyCmd:
 *
 * @param Cmd
 * @text Command Window
 *
 * @param CmdStyle:str
 * @text Style
 * @parent Cmd
 * @type select
 * @option Text Only
 * @value text
 * @option Icon Only
 * @value icon
 * @option Icon + Text
 * @value iconText
 * @option Automatic
 * @value auto
 * @desc How do you wish to draw commands in the Party Command Window?
 * @default auto
 *
 * @param CmdTextAlign:str
 * @text Text Align
 * @parent Cmd
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Party Command Window.
 * @default left
 *
 * @param CmdIconFight:num
 * @text Fight Icon
 * @parent Cmd
 * @desc The icon used for the Fight command.
 * @default 76
 *
 * @param CommandAddAutoBattle:eval
 * @text Add Auto Battle?
 * @parent Cmd
 * @type boolean
 * @on Add
 * @off Don't
 * @desc Add the "Auto Battle" command to the Command Window?
 * @default true
 *
 * @param CmdIconAutoBattle:num
 * @text Auto Battle Icon
 * @parent CommandAddAutoBattle:eval
 * @desc The icon used for the Auto Battle command.
 * @default 78
 *
 * @param CmdTextAutoBattle:str
 * @text Auto Battle Text
 * @parent CommandAddAutoBattle:eval
 * @desc The text used for the Auto Battle command.
 * @default Auto
 *
 * @param CommandAddStatus:eval
 * @text Add Status?
 * @parent Cmd
 * @type boolean
 * @on Add
 * @off Don't
 * @desc Add the "Status" command to the Command Window?
 * @default true
 *
 * @param CmdIconStatus:num
 * @text Status Icon
 * @parent CommandAddStatus:eval
 * @desc The icon used for the Status command.
 * @default 87
 *
 * @param CommandAddOptions:eval
 * @text Add Options?
 * @parent Cmd
 * @type boolean
 * @on Add
 * @off Don't
 * @desc Add the "Options" command to the Command Window?
 * @default true
 *
 * @param CmdIconOptions:num
 * @text Options Icon
 * @parent CommandAddOptions:eval
 * @desc The icon used for the Options command.
 * @default 83
 *
 * @param ActiveTpbOptionsMessage:str
 * @text Active TPB Message
 * @parent CommandAddOptions:eval
 * @desc Message that will be displayed when selecting options during the middle of an action.
 * @default Options Menu queued after action is complete.
 *
 * @param CmdIconEscape:num
 * @text Escape Icon
 * @parent Cmd
 * @desc The icon used for the Escape command.
 * @default 82
 *
 * @param Access
 *
 * @param SkipPartyCmd:eval
 * @text Skip Party Command
 * @parent Access
 * @type boolean
 * @on Skip
 * @off Don't
 * @desc DTB: Skip Party Command selection on turn start.
 * TPB: Skip Party Command selection at battle start.
 * @default true
 *
 * @param DisablePartyCmd:eval
 * @text Disable Party Command
 * @parent Access
 * @type boolean
 * @on Disable
 * @off Don't
 * @desc Disable the Party Command Window entirely?
 * @default false
 *
 * @param HelpWindow
 * @text Help Window
 *
 * @param HelpFight:str
 * @text Fight
 * @parent HelpWindow
 * @desc Text displayed when selecting a skill type.
 * %1 - Skill Type Name
 * @default Select actions to fight.
 *
 * @param HelpAutoBattle:str
 * @text Auto Battle
 * @parent HelpWindow
 * @desc Text displayed when selecting the Auto Battle command.
 * @default Sets party to Auto Battle mode.
 *
 * @param HelpOptions:str
 * @text Options
 * @parent HelpWindow
 * @desc Text displayed when selecting the Options command.
 * @default Opens up the Options Menu.
 *
 * @param HelpEscape:str
 * @text Escape
 * @parent HelpWindow
 * @desc Text displayed when selecting the escape command.
 * @default Attempt to escape the battle.
 *
 */
/* ----------------------------------------------------------------------------
 * Actor Command Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ActorCmd:
 *
 * @param Cmd
 * @text Command Window
 *
 * @param CmdStyle:str
 * @text Style
 * @parent Cmd
 * @type select
 * @option Text Only
 * @value text
 * @option Icon Only
 * @value icon
 * @option Icon + Text
 * @value iconText
 * @option Automatic
 * @value auto
 * @desc How do you wish to draw commands in the Actor Command Window?
 * @default auto
 *
 * @param CmdTextAlign:str
 * @text Text Align
 * @parent Cmd
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Actor Command Window.
 * @default left
 *
 * @param CmdIconItem:num
 * @text Item Icon
 * @parent Cmd
 * @desc The icon used for the Item command.
 * @default 176
 *
 * @param IconStypeNorm:num
 * @text Normal SType Icon
 * @parent Cmd
 * @desc Icon used for normal skill types that aren't assigned any
 * icons. Ignore if VisuMZ_1_SkillsStatesCore is installed.
 * @default 78
 *
 * @param IconStypeMagic:num
 * @text Magic SType Icon
 * @parent Cmd
 * @desc Icon used for magic skill types that aren't assigned any
 * icons. Ignore if VisuMZ_1_SkillsStatesCore is installed.
 * @default 79
 *
 * @param BattleCmd
 * @text Battle Commands
 *
 * @param BattleCmdList:arraystr
 * @text Command List
 * @parent BattleCmd
 * @type combo[]
 * @option attack
 * @option skills
 * @option guard
 * @option item
 * @option status
 * @option party
 * @option escape
 * @option auto battle
 * @option stypes
 * @option stype: x
 * @option stype: name
 * @option all skills
 * @option skill: x
 * @option skill: name
 * @option combat log
 * @option talk
 * @option weapon swap
 * @desc List of battle commands that appear by default
 * if the <Battle Commands> notetag isn't present.
 * @default ["attack","skills","guard","party","item"]
 *
 * @param ShowCosts:eval
 * @text Show Command Costs
 * @parent BattleCmd
 * @type boolean
 * @on Show Costs
 * @off Hide Costs
 * @desc If a battle command has a resource cost, show it?
 * @default true
 *
 * @param HelpWindow
 * @text Help Window
 *
 * @param HelpSkillType:str
 * @text Skill Types
 * @parent HelpWindow
 * @desc Text displayed when selecting a skill type.
 * %1 - Skill Type Name
 * @default Opens up a list of skills under the \C[16]%1\C[0] category.
 *
 * @param HelpItem:str
 * @text Items
 * @parent HelpWindow
 * @desc Text displayed when selecting the item command.
 * @default Opens up a list of items that you can use.
 *
 * @param HelpEscape:str
 * @text Escape
 * @parent HelpWindow
 * @desc Text displayed when selecting the escape command.
 * @default Attempt to escape the battle.
 *
 * @param HelpAutoBattle:str
 * @text Auto Battle
 * @parent HelpWindow
 * @desc Text displayed when selecting the Auto Battle command.
 * @default Automatically choose an action suitable for combat.
 *
 * @param HelpParty:str
 * @text Party
 * @parent HelpWindow
 * @desc Text displayed when selecting the Party command.
 * Requires 
 * @default Automatically choose an action suitable for combat.
 *
 */
/* ----------------------------------------------------------------------------
 * In_Battle Status Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~InBattleStatus:
 *
 * @param General
 * @text General Settings
 *
 * @param CmdIconStatus:num
 * @text Status Icon
 * @parent General
 * @desc The icon used for the Status command.
 * @default 87
 *
 * @param StatusGraphic:str
 * @text Status Graphic
 * @parent General
 * @type select
 * @option None
 * @value none
 * @option Face
 * @value face
 * @option Map Sprite
 * @value sprite
 * @option Sideview Battler
 * @value svbattler
 * @desc Choose how the actor graphic appears for In-Battle Status.
 * @default face
 *
 * @param HelpStatus:str
 * @text Help Description
 * @parent General
 * @desc Text displayed when selecting the Status command.
 * @default View battle member status.
 *
 * @param Enemy
 * @text Enemy Settings
 *
 * @param enemyStatus:eval
 * @text Allow View Enemies?
 * @parent Enemy
 * @type boolean
 * @on Allow
 * @off Forbid
 * @desc Allows players to view enemy stats (even if limited)?
 * @default true
 *
 * @param enemyShowLevel:eval
 * @text Show Level?
 * @parent Enemy
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Shows the enemy's level in the In-Battle Status?
 * @default true
 *
 * @param enemyHiddenParameter:str
 * @text Hidden Parameter
 * @parent Enemy
 * @desc The text that appears if a parameter value is hidden.
 * @default ???
 *
 * @param enemyShowParametersAlways:eval
 * @text Show Params Always
 * @parent enemyHiddenParameter:str
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Always show exact enemy parameter values.
 * @default false
 *
 * @param enemyShowParametersIfBattleTest:eval
 * @text Show Battle Test
 * @parent enemyHiddenParameter:str
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show exact enemy parameter values in battle test.
 * @default true
 *
 * @param enemyShowParametersIfDefeated:eval
 * @text Show If Defeated
 * @parent enemyHiddenParameter:str
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show exact enemy parameter values if enemy has been defeated before.
 * @default true
 *
 * @param PageButtons
 * @text Page Buttons
 *
 * @param pageButtons:eval
 * @text Show Page Buttons?
 * @parent PageButtons
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Shows page buttons to switch between actors?
 * Still requires Touch UI option to be on.
 * @default true
 *
 * @param pageButtonPosition:str
 * @text Large UI Position?
 * @parent pageButtons:eval
 * @type select
 * @option left
 * @option right
 * @desc If using a large resolution, position the page buttons on which side?
 * @default left
 *
 * @param pageOffsetX:num
 * @text Offset X
 * @parent PageButtons
 * @desc Offsets the page buttons x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param pageOffsetY:num
 * @text Offset Y
 * @parent PageButtons
 * @desc Offsets the page buttons y position.
 * Negative: up. Positive: down.
 * @default +0
 *
 * @param Parameters
 * @text Parameter Display
 *
 * @param buffValueFmt:str
 * @text Increased Value
 * @parent Parameters
 * @desc How are increased parameter values displayed?
 * %1 - Parameter Value
 * @default ▲%1
 *
 * @param debuffValueFmt:str
 * @text Decreased Value
 * @parent Parameters
 * @desc How are increased parameter values displayed?
 * %1 - Parameter Value
 * @default ▼%1
 *
 * @param States
 * @text States Display
 *
 * @param statesMaxWidth:num
 * @text Max Width
 * @parent States
 * @desc Maximum width of the states list display.
 * @default 384
 *
 * @param drawStates:eval
 * @text List States?
 * @parent States
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Lists states in the states list display?
 * @default true
 *
 * @param drawBuffs:eval
 * @text List Buffs?
 * @parent States
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Lists buffs in the states list display?
 * @default true
 *
 * @param drawDebuffs:eval
 * @text List Debuffs?
 * @parent States
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Lists debuffs in the states list display?
 * @default true
 *
 * @param BuffsDebuffs
 * @text Buffs/Debuffs Display
 * @parent States
 *
 * @param buffNameFmt:str
 * @text Buff Name Format
 * @parent BuffsDebuffs
 * @desc Text format used to represent buffs.
 * %1 - Parameter Name
 * @default %1▲
 *
 * @param debuffNameFmt:str
 * @text Debuff Name Format
 * @parent BuffsDebuffs
 * @desc Text format used to represent debuffs.
 * %1 - Parameter Name
 * @default %1▼
 *
 * @param NormalState
 * @text Normal State
 * @parent States
 *
 * @param normalIcon:num
 * @text Normal Icon
 * @parent NormalState
 * @desc Icon used to represent normal state (unaffected by states, buffs, or debuffs).
 * @default 84
 *
 * @param normalText:str
 * @text Normal Text
 * @parent NormalState
 * @desc Text used to represent normal state (unaffected by states, buffs, or debuffs).
 * @default Normal
 *
 * @param HelpDesc
 * @text Help Descriptions
 *
 * @param stateHelpFmt:json
 * @text State Help Format
 * @parent HelpDesc
 * @type note
 * @desc Text format used for state help descriptions
 * %1 - Description; %2 - Turns/Actions Remaining
 * @default "%1 %2"
 *
 * @param buffHelpFmt:json
 * @text Buff Help Format
 * @parent HelpDesc
 * @type note
 * @desc Text format used for Buff help descriptions
 * %1 - Param; %2 - Percent; %3 - Color; %4 - Turns
 * @default "Increases %1 to %3%2\\C[0]. %4"
 *
 * @param debuffHelpFmt:json
 * @text Debuff Help Format
 * @parent HelpDesc
 * @type note
 * @desc Text format used for Debuff help descriptions
 * %1 - Param; %2 - Percent; %3 - Color; %4 - Turns
 * @default "Decreases %1 to %3%2\\C[0]. %4"
 *
 * @param normalHelp:json
 * @text Normal State
 * @parent HelpDesc
 * @type note
 * @desc Help description used to explain normal state (unaffected by states, buffs, or debuffs).
 * @default "Status is currently normal."
 *
 * @param TurnHelpDesc
 * @text Turns/Actions Left
 * @parent HelpDesc
 *
 * @param actionsFmt:str
 * @text Actions Format
 * @parent TurnHelpDesc
 * @desc Text format used to represent actions remaining.
 * %1 - Actions; %2 - Color
 * @default \C[6](Actions %2%1\C[6])\C[0]
 *
 * @param TurnsFmt:str
 * @text Turns Format
 * @parent TurnHelpDesc
 * @desc Text format used to represent turns remaining.
 * %1 - Turns; %2 - Color
 * @default \C[5](Turns %2%1\C[5])\C[0]
 *
 * @param passiveText:str
 * @text Passive Text
 * @parent TurnHelpDesc
 * @desc Text used to represent a passive.
 * @default \C[4](Passive)\C[0]
 *
 * @param Window
 * @text Window Settings
 *
 * @param StatusWindow_BgType:num
 * @text Background Type
 * @parent Window
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param StatusWindow_DrawJS:func
 * @text JS: Draw Data
 * @parent Window
 * @type note
 * @desc Code used to draw battler data.
 * @default "{ // Draw Face and Simple Status\n    const x = this.colSpacing() / 2;\n    const h = ImageManager.faceHeight;\n    const y = h / 2 - this.lineHeight() * 1.5;\n    this.drawActorGraphic(this._battler, x + 1, 0, ImageManager.faceWidth, h);\n    this.drawActorSimpleStatus(this._battler, x + 180, y);\n}\n{ // Draw Actor Parameters\n    let maxWidth = this.drawingAreaWidth();\n    let x1 = 0;\n    let x2 = Math.ceil(this.drawingAreaWidth() / 2);\n\n    let counter = 0;\n    const params = this.displayedParams();\n\n    let px = x1;\n    const availableHeight = this.innerHeight - ImageManager.faceHeight;\n    const paramHeight = Math.ceil(params.length / 2) * this.lineHeight();\n    let py = Math.ceil((availableHeight - paramHeight) / 2) + ImageManager.faceHeight;\n    let pw = Math.floor(maxWidth / 2);\n\n    if (this._statesWindow.y !== 0) {\n        this._statesWindow.y = py;\n    }\n\n    for (const param of params) {\n        this.drawDarkRect(px, py, pw, this.lineHeight());\n        this.drawParamData(param, px, py, pw);\n        counter++;\n        if (counter % 2 === 0) {\n            px = x1;\n            py += this.lineHeight();\n        } else {\n            px = x2;\n        }\n    }\n}"
 *
 * @param StatusWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent Window
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const wx = Graphics.boxWidth > 1000 ? 120 : 0;\nconst wy = this._helpWindow.y + this._helpWindow.height;\nconst ww = Graphics.boxWidth - (wx * 2);\nconst wh = Graphics.boxHeight - wy - this.windowAreaHeight();\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 */
/* ----------------------------------------------------------------------------
 * Multi-Target Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~MultiTarget:
 *
 * @param Properties
 * 
 * @param WindowWidth:num
 * @text Window Width
 * @parent Properties
 * @type number
 * @min 1
 * @desc What is the width used for the Multi-Target Window?
 * @default 280
 *
 * @param BgType:num
 * @text Background Type
 * @parent Properties
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for these windows.
 * @default 2
 *
 * @param ShowButton:eval
 * @text Show Button
 * @parent Properties
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Shows the keyboard/controller button to press?
 * Requires VisuMZ_0_CoreEngine!
 * @default true
 * 
 * @param Vocab
 *
 * @param AllActorsText:str
 * @text All Actors
 * @parent Vocab
 * @desc What is the text used for the "All Actors" button?
 * @default All Allies
 *
 * @param AllEnemiesText:str
 * @text All Enemies
 * @parent Vocab
 * @desc What is the text used for the "All Enemies" button?
 * @default All Enemies
 * 
 * @param Offsets
 * 
 * @param ActorOffsets
 * @text Actor Offsets
 * @parent Offsets
 *
 * @param ActorOffsetX:num
 * @text Offset X
 * @parent ActorOffsets
 * @desc Offsets the button's x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param ActorOffsetY:num
 * @text Offset Y
 * @parent ActorOffsets
 * @desc Offsets the button's y position.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @param EnemyOffsets
 * @text Enemy Offsets
 * @parent Offsets
 *
 * @param EnemyOffsetX:num
 * @text Offset X
 * @parent EnemyOffsets
 * @desc Offsets the button's x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param EnemyOffsetY:num
 * @text Offset Y
 * @parent EnemyOffsets
 * @desc Offsets the button's y position.
 * Negative: up. Positive: down.
 * @default +0
 *
 */
/* ----------------------------------------------------------------------------
 * Combo Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ComboWindow:
 *
 * @param General
 * @text General Settings
 *
 * @param Enable:eval
 * @text Enable?
 * @parent General
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Add the Combo Window to show in battle?
 * @default true
 *
 * @param Appearance
 * @text Appearance Settings
 *
 * @param CustomFontFace:str
 * @text Custom Font
 * @parent Appearance
 * @desc Insert the custom font face name here.
 * Use VisuMZ_1_MessageCore to register new fonts.
 * @default Arial
 *
 * @param TextAlign:str
 * @text Text Align
 * @parent Appearance
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for this window?
 * @default left
 *
 * @param ComboWindow_DrawJS:func
 * @text JS: Draw Data
 * @parent Appearance
 * @type note
 * @desc Code used to draw the data in this window.
 * @default ""
 * 
 * @param Vocab
 * @text Vocabulary
 *
 * @param hitsDmgFmt:str
 * @text Damage Combo Format
 * @parent Vocab
 * @desc Text format used to display total hits for damage.
 * %1 - Total Hits
 * @default \C[6]%1\} \C[4]Hit Combo\C[0]\{
 *
 * @param hitsHealFmt:str
 * @text Healing Combo Format
 * @parent Vocab
 * @desc Text format used to display total hits for healing.
 * %1 - Total Hits
 * @default \C[6]%1\} \C[4]Heal Combo\C[0]\{
 *
 * @param totalDmgFmt:str
 * @text Damage Total Format
 * @parent Vocab
 * @desc Text format used to display total value for damage.
 * %1 - Total Damage
 * @default \}\C[21]Total Damage: \{\C[0]%1
 *
 * @param totalHealFmt:str
 * @text Healing Total Format
 * @parent Vocab
 * @desc Text format used to display total value for healing.
 * %1 - Total Healing
 * @default \}\C[21]Total Healing: \{\C[24]+%1\C[0]
 *
 * @param Position
 * @text Position Settings
 *
 * @param fadeShiftX:num
 * @text Fade Shift X
 * @parent Position
 * @desc Shifts the windows x position when fading.
 * Negative: left. Positive: right.
 * @default -2
 *
 * @param fadeShiftY:num
 * @text Fade Shift Y
 * @parent Position
 * @desc Shifts the windows y position when fading.
 * Negative: up. Positive: down.
 * @default +0
 *
 * @param PosOffsetX:num
 * @text Offset X
 * @parent Position
 * @desc Offsets the windows x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param PosOffsetY:num
 * @text Offset Y
 * @parent Position
 * @desc Offsets the windows y position.
 * Negative: up. Positive: down.
 * @default +0
 *
 * @param ComboWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent Position
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const ww = Math.ceil(Graphics.width / 4);\nconst wh = this.calcWindowHeight(2, true);\nconst wx = 0 + this.comboWindowOffsetX();\nconst wy = Math.round(Graphics.boxHeight * 1 / 3) + this.comboWindowOffsetY();\nreturn new Rectangle(wx, wy, ww, wh);"
 * 
 * @param Update
 * @text Updating Settings
 *
 * @param updateDuration:num
 * @text Number Roll Duration
 * @parent Update
 * @type number
 * @min 1
 * @desc Frame duration to roll damage numbers.
 * 60 frames = 1 second.
 * @default 20
 *
 * @param minimumStayDuration:num
 * @text Minimum Stay Duration
 * @parent Update
 * @type number
 * @desc Frame duration to stay visible minimum.
 * 60 frames = 1 second.
 * @default 40
 *
 * @param minimumHits:num
 * @text Minimum Hit Visible
 * @parent Update
 * @type number
 * @min 1
 * @desc Minimum hits before combo window becomes visible?
 * @default 1
 *
 * @param opacitySpeed:num
 * @text Opacity Speed
 * @parent Update
 * @type number
 * @min 1
 * @desc Opacity speed when fading in/out.
 * @default 16
 *
 */
/* ----------------------------------------------------------------------------
 * Actor Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Actor:
 *
 * @param Flinch
 *
 * @param FlinchDistanceX:num
 * @text Flinch Distance X
 * @parent Flinch
 * @desc The normal X distance when flinching.
 * @default 12
 *
 * @param FlinchDistanceY:num
 * @text Flinch Distance Y
 * @parent Flinch
 * @desc The normal Y distance when flinching.
 * @default 0
 *
 * @param FlinchDuration:num
 * @text Flinch Duration
 * @parent Flinch
 * @desc The number of frames for a flinch to complete.
 * @default 6
 *
 * @param ShakeFlinch:eval
 * @text Shake Flinch
 * @parent Flinch
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Perform a shake flinch when taking damage?
 * @default false
 *
 * @param ShakeFlinchDuration:num
 * @text Max Duration
 * @parent ShakeFlinch:eval
 * @type number
 * @min 1
 * @desc Maximum duration a shake flinch can have.
 * This is reduced relative to the amount of damage taken.
 * @default 24
 *
 * @param ShakeFlinchPower:num
 * @text Max Power
 * @parent ShakeFlinch:eval
 * @type number
 * @min 1
 * @desc The power rating of a shake flinch at full damage.
 * This is reduced relative to the amount of damage taken.
 * @default 48
 *
 * @param FvBattlers
 * @text Frontview Battlers
 * 
 * @param FvPortraitAni
 * @text Portrait Animations
 * @parent FvBattlers
 *
 * @param FvAniEachTarget:eval
 * @text Each Target
 * @parent FvPortraitAni
 * @type boolean
 * @on On Top
 * @off Behind
 * @desc Place animations on top for "Each Target" display types?
 * Does not apply to MV animations.
 * @default true
 *
 * @param FvAniCenterAll:eval
 * @text Center of All
 * @parent FvPortraitAni
 * @type boolean
 * @on On Top
 * @off Behind
 * @desc Place animations on top for "Center of All" display types?
 * Does not apply to MV animations.
 * @default true
 *
 * @param FvAniCenterScreen:eval
 * @text Center of Screen
 * @parent FvPortraitAni
 * @type boolean
 * @on On Top
 * @off Behind
 * @desc Place animations on top for "Center of Screen" display types?
 * Does not apply to MV animations.
 * @default false
 *
 * @param SvBattlers
 * @text Sideview Battlers
 * 
 * @param SvAnchor
 * @text Anchor
 * @parent SvBattlers
 *
 * @param AnchorX:num
 * @text Anchor: X
 * @parent SvAnchor
 * @desc Default X anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 0.5
 *
 * @param AnchorY:num
 * @text Anchor: Y
 * @parent SvAnchor
 * @desc Default Y anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 1.0
 *
 * @param ChantStyle:eval
 * @text Chant Style
 * @parent SvBattlers
 * @type boolean
 * @on Magical Hit Type
 * @off Magical Skill Type
 * @desc What determines the chant motion?
 * Hit type or skill type?
 * @default true
 *
 * @param MotionSpeed:num
 * @text Motion Speed
 * @parent SvBattlers
 * @type number
 * @min 1
 * @desc The number of frames in between each motion.
 * @default 12
 * 
 * @param SvPosition
 * @text Position
 * @parent SvBattlers
 *
 * @param OffsetX:num
 * @text Offset: X
 * @parent SvPosition
 * @desc Offsets X position where actor is positioned.
 * Negative values go left. Positive values go right.
 * @default 0
 *
 * @param OffsetY:num
 * @text Offset: Y
 * @parent SvPosition
 * @desc Offsets Y position where actor is positioned.
 * Negative values go up. Positive values go down.
 * @default 0
 *
 * @param PrioritySortActive:eval
 * @text Priority: Active
 * @parent SvBattlers
 * @type boolean
 * @on Active Actor over All Else
 * @off Active Actor is Sorted Normally
 * @desc Place the active actor on top of actor and enemy sprites.
 * @default false
 *
 * @param PrioritySortActors:eval
 * @text Priority: Actors
 * @parent SvBattlers
 * @type boolean
 * @on Actors over Enemies
 * @off Sort by Y Position
 * @desc Prioritize actors over enemies when placing sprites on top
 * of each other.
 * @default true
 *
 * @param Shadow:eval
 * @text Shadow Visible
 * @parent SvBattlers
 * @type boolean
 * @on Visible
 * @off Hidden
 * @desc Show or hide the shadow for Sideview Battlers.
 * @default true
 * 
 * @param SvStateOverlay
 * @text State Overlay
 * @parent SvBattlers
 *
 * @param StateOverlayOffsetX:num
 * @text Offset: X
 * @parent SvStateOverlay
 * @desc Offsets X position for state overlay on actor.
 * Negative values go left. Positive values go right.
 * @default 0
 *
 * @param StateOverlayOffsetY:num
 * @text Offset: Y
 * @parent SvStateOverlay
 * @desc Offsets Y position for state overlay on actor.
 * Negative values go up. Positive values go down.
 * @default 0
 *
 * @param SmoothImage:eval
 * @text Smooth Image
 * @parent SvBattlers
 * @type boolean
 * @on Smooth
 * @off Pixelated
 * @desc Smooth out the battler images or pixelate them?
 * @default false
 *
 * @param HomePosJS:func
 * @text JS: Home Position
 * @parent SvBattlers
 * @type note
 * @desc Code used to calculate the home position of actors.
 * @default "// Declare Constants\nconst sprite = this;\nconst actor = this._actor;\nconst index = arguments[0];\n\n// Make Calculations\nlet x = Math.round((Graphics.width / 2) + 192)\nx -= Math.floor((Graphics.width - Graphics.boxWidth) / 2);\nx += index * 32;\nlet y = (Graphics.height - 200) - ($gameParty.maxBattleMembers() * 48);\ny -= Math.floor((Graphics.height - Graphics.boxHeight) / 2);\ny += index * 48;\n\n// Home Position Offsets\nconst offsetNote = /<SIDEVIEW HOME OFFSET:[ ]([\\+\\-]\\d+),[ ]([\\+\\-]\\d+)>/i;\nconst xOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$1) : 0));\nconst yOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$2) : 0));\nx = xOffsets.reduce((r, offset) => r + offset, x);\ny = yOffsets.reduce((r, offset) => r + offset, y);\n\n// Set Home Position\nthis.setHome(x, y);"
 *
 */
/* ----------------------------------------------------------------------------
 * Enemy Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Enemy:
 *
 * @param Visual
 *
 * @param AttackAnimation:num
 * @text Attack Animation
 * @parent Visual
 * @type animation
 * @desc Default attack animation used for enemies.
 * Use <Attack Animation: x> for custom animations.
 * @default 1
 *
 * @param EmergeText:eval
 * @text Emerge Text
 * @parent Visual
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show or hide the 'Enemy emerges!' text at the start of battle.
 * @default false
 *
 * @param OffsetX:num
 * @text Offset: X
 * @parent Visual
 * @desc Offsets X position where enemy is positioned.
 * Negative values go left. Positive values go right.
 * @default 0
 *
 * @param OffsetY:num
 * @text Offset: Y
 * @parent Visual
 * @desc Offsets Y position where enemy is positioned.
 * Negative values go up. Positive values go down.
 * @default 0
 *
 * @param SmoothImage:eval
 * @text Smooth Image
 * @parent Visual
 * @type boolean
 * @on Smooth
 * @off Pixelated
 * @desc Smooth out the battler images or pixelate them?
 * @default true
 *
 * @param SelectWindow
 * @text Select Window
 *
 * @param LastSelected:eval
 * @text Any: Last Selected
 * @parent SelectWindow
 * @type boolean
 * @on Last Selected
 * @off FV/SV Priority
 * @desc Prioritize last selected enemy over front view or sideview settings?
 * @default true
 *
 * @param FrontViewSelect:eval
 * @text FV: Right Priority
 * @parent SelectWindow
 * @type boolean
 * @on Right
 * @off Normal
 * @desc If using frontview, auto select the enemy furthest right.
 * @default false
 *
 * @param SideviewSelect:eval
 * @text SV: Right Priority
 * @parent SelectWindow
 * @type boolean
 * @on Right
 * @off Normal
 * @desc If using sideview, auto select the enemy furthest right.
 * @default true
 * 
 * @param Name
 *
 * @param NameLegacy:eval
 * @text Legacy Option
 * @parent Name
 * @type boolean
 * @on Legacy Version
 * @off New Version (Sprite)
 * @desc Use the legacy version (window) or new version (sprite).
 * WARNING: Legacy version is no longer supported for bugs.
 * @default false
 *
 * @param NameFontSize:num
 * @text Font Size
 * @parent Name
 * @desc Font size used for enemy names.
 * @default 22
 * 
 * @param NamePosition
 * @text Name Position
 * @parent Name
 *
 * @param NameOffsetX:num
 * @text Offset X
 * @parent NamePosition
 * @desc Offset the enemy name's X position by this much.
 * Negative goes left. Positive goes right.
 * @default 0
 *
 * @param NameOffsetY:num
 * @text Offset Y
 * @parent NamePosition
 * @desc Offset the enemy name's Y position by this much.
 * Negative goes up. Positive goes down.
 * @default 0
 *
 * @param NameAttachStateIcon:eval
 * @text Attach States
 * @parent Name
 * @type boolean
 * @on Attach
 * @off Normal Position
 * @desc Attach the enemy's state icon to the enemy name?
 * @default false
 *
 * @param AttachStateOffsetX:num
 * @text Attach: Offset X
 * @parent NameAttachStateIcon:eval
 * @desc How much to offset the attached icon's X position by?
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param AttachStateOffsetY:num
 * @text Attach: Offset Y
 * @parent NameAttachStateIcon:eval
 * @desc How much to offset the attached icon's Y position by?
 * Negative goes up. Positive goes down.
 * @default +0
 * 
 * @param NameVisibility
 * @text Name Visibility
 * @parent Name
 *
 * @param NameAlwaysHidden:eval
 * @text Always Hidden
 * @parent NameVisibility
 * @type boolean
 * @on Always Hidden
 * @off No Priority
 * @desc Determines if the enemy name will always be visible.
 * Highest priority.
 * @default false
 *
 * @param NameAlwaysVisible:eval
 * @text Always Visible
 * @parent NameVisibility
 * @type boolean
 * @on Always Visible
 * @off Hide when Unselected
 * @desc Determines if the enemy name will always be visible.
 * Medium priority.
 * @default false
 *
 * @param NameAsTarget:eval
 * @text As Target
 * @parent NameVisibility
 * @type boolean
 * @on Visible As Target
 * @off No Priority
 * @desc Shows enemy name when enemy is a target.
 * Medium priority.
 * @default true
 *
 * @param NameAlwaysSelectOnly:eval
 * @text By Selection?
 * @parent NameVisibility
 * @type boolean
 * @on Visible when Selected
 * @off Visible when Targeting
 * @desc Determines the conditions for enemy name visibility.
 * Lowest priority.
 * @default false
 *
 * @param NameDamageVisibility:num
 * @text Temporary Visibility
 * @parent NameVisibility
 * @type number
 * @desc Number of frames enemy's name temporarily visible after
 * taking an action effect in battle. 60 frames = 1 second.
 * @default 0
 *
 * @param SvBattlers
 * @text Sideview Battlers
 *
 * @param AllowCollapse:eval
 * @text Allow Collapse
 * @parent SvBattlers
 * @type boolean
 * @on Allow
 * @off Don't
 * @desc Causes defeated enemies with SV Battler graphics
 * to "fade away" when defeated?
 * @default false
 *
 * @param AnchorX:num
 * @text Anchor: X
 * @parent SvBattlers
 * @desc Default X anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 0.5
 *
 * @param AnchorY:num
 * @text Anchor: Y
 * @parent SvBattlers
 * @desc Default Y anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 1.0
 *
 * @param MotionIdle:str
 * @text Motion: Idle
 * @parent SvBattlers
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Sets default idle animation used by Sideview Battlers.
 * @default walk
 *
 * @param Shadow:eval
 * @text Shadow Visible
 * @parent SvBattlers
 * @type boolean
 * @on Visible
 * @off Hidden
 * @desc Show or hide the shadow for Sideview Battlers.
 * @default true
 *
 * @param Width:num
 * @text Size: Width
 * @parent SvBattlers
 * @type number
 * @min 1
 * @desc Default width for enemies that use Sideview Battlers.
 * @default 64
 *
 * @param Height:num
 * @text Size: Height
 * @parent SvBattlers
 * @type number
 * @min 1
 * @desc Default height for enemies that use Sideview Battlers.
 * @default 64
 *
 * @param WtypeId:num
 * @text Weapon Type
 * @parent SvBattlers
 * @type number
 * @min 0
 * @desc Sets default weapon type used by Sideview Battlers.
 * Use 0 for Bare Hands.
 * @default 0
 *
 * @param Aspect
 * @text Aspect Defaults
 *
 * @param AspectNameFmt:str
 * @text Name Format
 * @parent Aspect
 * @desc Default name aspect format.
 * %1 - Original Enemy Name
 * @default %1 Aspect
 *
 * @param AspectColor:str
 * @text Name Color
 * @parent Aspect
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 2
 *
 * @param AspectIcon:num
 * @text Icon
 * @parent Aspect
 * @desc Default icon used for aspect.
 * Use <Aspect Icon: x> to change icon.
 * @default 26
 *
 */
/* ----------------------------------------------------------------------------
 * HP Gauge Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~HpGauge:
 *
 * @param Display
 * @text Show Gauges For
 *
 * @param ShowActorGauge:eval
 * @text Actors
 * @parent Display
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show HP Gauges over the actor sprites' heads?
 * Requires SV Actors to be visible.
 * @default true
 *
 * @param ShowEnemyGauge:eval
 * @text Enemies
 * @parent Display
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show HP Gauges over the enemy sprites' heads?
 * Can be bypassed with <Hide HP Gauge> notetag.
 * @default true
 *
 * @param RequiresDefeat:eval
 * @text Requires Defeat?
 * @parent ShowEnemyGauge:eval
 * @type boolean
 * @on Require Defeat First
 * @off No Requirement
 * @desc Requires defeating the enemy once to show HP Gauge?
 * Can be bypassed with <Show HP Gauge> notetag.
 * @default true
 *
 * @param BTestBypass:eval
 * @text Battle Test Bypass?
 * @parent RequiresDefeat:eval
 * @type boolean
 * @on Bypass
 * @off Don't Bypass
 * @desc Bypass the defeat requirement in battle test?
 * @default true
 *
 * @param Settings
 *
 * @param AniDuration:num
 * @text Animation Duration
 * @parent Settings
 * @type number
 * @min 1
 * @desc How many frames should gauges animate themselves?
 * Default: 20 frames.
 * @default 20
 *
 * @param AnchorX:num
 * @text Anchor X
 * @parent Settings
 * @desc Where do you want the HP Gauge sprite's anchor X to be?
 * Use values between 0 and 1 to be safe.
 * @default 0.5
 *
 * @param AnchorY:num
 * @text Anchor Y
 * @parent Settings
 * @desc Where do you want the HP Gauge sprite's anchor Y to be?
 * Use values between 0 and 1 to be safe.
 * @default 1.0
 *
 * @param Scale:num
 * @text Scale
 * @parent Settings
 * @desc How large/small do you want the HP Gauge to be scaled?
 * @default 0.5
 *
 * @param OffsetX:num
 * @text Offset X
 * @parent Settings
 * @desc How many pixels to offset the HP Gauge's X by?
 * @default 0
 *
 * @param OffsetY:num
 * @text Offset Y
 * @parent Settings
 * @desc How many pixels to offset the HP Gauge's Y by?
 * @default -3
 *
 * @param Options
 * @text Options
 *
 * @param AddHpGaugeOption:eval
 * @text Add Option?
 * @parent Options
 * @type boolean
 * @on Add
 * @off Don't Add
 * @desc Add the 'Show HP Gauge' option to the Options menu?
 * @default true
 *
 * @param AdjustRect:eval
 * @text Adjust Window Height
 * @parent Options
 * @type boolean
 * @on Adjust
 * @off Don't
 * @desc Automatically adjust the options window height?
 * @default true
 *
 * @param Name:str
 * @text Option Name
 * @parent Options
 * @desc Command name of the option.
 * @default Show HP Gauge
 *
 */
/* ----------------------------------------------------------------------------
 * Action Sequence Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ActionSequence:
 *
 * @param AutoSequences
 * @text Automatic Sequences
 *
 * @param AutoMeleeSolo:eval
 * @text Melee Single Target
 * @parent AutoSequences
 * @type boolean
 * @on Allow
 * @off Ignore
 * @desc Allow this auto sequence for physical, single target actions?
 * @default true
 *
 * @param AutoMeleeAoE:eval
 * @text Melee Multi Target
 * @parent AutoSequences
 * @type boolean
 * @on Allow
 * @off Ignore
 * @desc Allow this auto sequence for physical, multi-target actions?
 * @default true
 *
 * @param QoL
 * @text Quality of Life
 *
 * @param AutoNotetag:eval
 * @text Auto Notetag
 * @parent QoL
 * @type boolean
 * @on Automatic
 * @off Manual
 * @desc Automatically apply the <Custom Action Sequence> notetag
 * effect to any item or skill that has a Common Event?
 * @default false
 *
 * @param CastAnimations
 * @text Cast Animations
 *
 * @param CastCertain:num
 * @text Certain Hit
 * @parent CastAnimations
 * @type animation
 * @desc Cast animation for Certain Hit skills.
 * @default 120
 *
 * @param CastPhysical:num
 * @text Physical
 * @parent CastAnimations
 * @type animation
 * @desc Cast animation for Physical skills.
 * @default 52
 *
 * @param CastMagical:num
 * @text Magical
 * @parent CastAnimations
 * @type animation
 * @desc Cast animation for Magical skills.
 * @default 51
 *
 * @param CounterReflection
 * @text Counter/Reflect
 *
 * @param CounterPlayback:eval
 * @text Counter Back
 * @parent CounterReflection
 * @type boolean
 * @on Play Back
 * @off Ignore
 * @desc Play back the attack animation used?
 * @default true
 *
 * @param ReflectAnimation:num
 * @text Reflect Animation
 * @parent CounterReflection
 * @type animation
 * @desc Animation played when an action is reflected.
 * @default 53
 *
 * @param ReflectPlayback:eval
 * @text Reflect Back
 * @parent CounterReflection
 * @type boolean
 * @on Play Back
 * @off Ignore
 * @desc Play back the attack animation used?
 * @default true
 *
 * @param Stepping
 *
 * @param MeleeDistance:num
 * @text Melee Distance
 * @parent Stepping
 * @desc Minimum distance in pixels for Movement Action Sequences.
 * @default 24
 *
 * @param StepDistanceX:num
 * @text Step Distance X
 * @parent Stepping
 * @desc The normal X distance when stepping forward.
 * @default 48
 *
 * @param StepDistanceY:num
 * @text Step Distance Y
 * @parent Stepping
 * @desc The normal Y distance when stepping forward.
 * @default 0
 *
 * @param StepDuration:num
 * @text Step Duration
 * @parent Stepping
 * @desc The number of frames for a stepping action to complete.
 * @default 12
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Start Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileStart:
 * 
 * @param Type:str
 * @text Type
 * @type select
 * @option Target - Start from battler target(s)
 * @value target
 * @option Point - Start from a point on the screen
 * @value point
 * @desc Select where the projectile should start from.
 * @default target
 * 
 * @param Targets:arraystr
 * @text Target(s)
 * @parent Type:str
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to start the projectile from.
 * @default ["user"]
 * 
 * @param TargetCenter:eval
 * @text Centralize
 * @parent Targets:arraystr
 * @type boolean
 * @on Center Projectile
 * @off Create Each
 * @desc Create one projectile at the center of the targets?
 * Or create a projectile for each target?
 * @default false
 * 
 * @param TargetLocation:str
 * @text Target Location
 * @parent Targets:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part of the target to send the projectile from.
 * @default middle center
 * 
 * @param PointX:eval
 * @text Point X
 * @parent Type:str
 * @desc Insert the X coordinate to start the projectile at.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @param PointY:eval
 * @text Point Y
 * @parent Type:str
 * @desc Insert the Y coordinate to start the projectile at.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 * 
 * @param OffsetX:eval
 * @text Offset X
 * @desc Insert how many pixels to offset the X coordinate by.
 * You may use JavaScript code.
 * @default +0
 * 
 * @param OffsetY:eval
 * @text Offset Y
 * @desc Insert how many pixels to offset the Y coordinate by.
 * You may use JavaScript code.
 * @default +0
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Goal Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileGoal:
 * 
 * @param Type:str
 * @text Type
 * @type select
 * @option Target - Goal is battler target(s)
 * @value target
 * @option Point - Goal is a point on the screen
 * @value point
 * @desc Select where the projectile should go to.
 * @default target
 * 
 * @param Targets:arraystr
 * @text Target(s)
 * @parent Type:str
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) for projectile to go to.
 * @default ["all targets"]
 * 
 * @param TargetCenter:eval
 * @text Centralize
 * @parent Targets:arraystr
 * @type boolean
 * @on Center Projectile
 * @off Create Each
 * @desc Set goal in the center of targets?
 * Or create a projectile to go to each target?
 * @default false
 * 
 * @param TargetLocation:str
 * @text Target Location
 * @parent Targets:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part of the target to send the projectile at.
 * @default middle center
 * 
 * @param PointX:eval
 * @text Point X
 * @parent Type:str
 * @desc Insert the X coordinate to send the projectile to.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @param PointY:eval
 * @text Point Y
 * @parent Type:str
 * @desc Insert the Y coordinate to send the projectile to.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 * 
 * @param OffsetX:eval
 * @text Offset X
 * @desc Insert how many pixels to offset the X coordinate by.
 * You may use JavaScript code.
 * @default +0
 * 
 * @param OffsetY:eval
 * @text Offset Y
 * @desc Insert how many pixels to offset the Y coordinate by.
 * You may use JavaScript code.
 * @default +0
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Extra Animation Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileExAni:
 * 
 * @param AutoAngle:eval
 * @text Auto Angle?
 * @parent Settings
 * @type boolean
 * @on Automatically Angle
 * @off Normal
 * @desc Automatically angle the projectile to tilt the direction it's moving?
 * @default true
 * 
 * @param AngleOffset:eval
 * @text Angle Offset
 * @desc Alter the projectile's tilt by this many degrees.
 * @default +0
 * 
 * @param Arc:eval
 * @text Arc Peak
 * @parent Settings
 * @desc This is the height of the projectile's trajectory arc
 * in pixels.
 * @default 0
 *
 * @param EasingType:str
 * @text Easing
 * @parent Settings
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type to apply to the projectile's trajectory.
 * @default Linear
 * 
 * @param Spin:eval
 * @text Spin Speed
 * @parent Settings
 * @desc Determine how much angle the projectile spins per frame.
 * Does not work well with "Auto Angle".
 * @default +0.0
 * 
 * @param Emulate
 * @text Effect Emulation
 * 
 * @param EmulateActionEffect:eval
 * @text Action Effect?
 * @parent Emulate
 * @type boolean
 * @on Emulate
 * @off Don't Emulate
 * @desc Emulate current Action Effect when projectile reaches
 * target? Only works with start/goal targets.
 * @default false
 * 
 * @param EmulateItemEffect:eval
 * @text Item Effect ID
 * @parent Emulate
 * @type item
 * @desc Emulate an Item Effect when projectile reaches target?
 * Use 0 to not use. Only works with start/goal targets.
 * @default 0
 * 
 * @param EmulateSkillEffect:eval
 * @text Skill Effect ID
 * @parent Emulate
 * @type skill
 * @desc Emulate a Skill Effect when projectile reaches target?
 * Use 0 to not use. Only works with start/goal targets.
 * @default 0
 *
 * @param OnceParallel:num
 * @text Common Event ID
 * @parent Emulate
 * @type common_event
 * @desc Plays a Once Parallel Common Event upon reaching target.
 * Use 0 to not use. Works regardless of start/goal targets.
 * @default 0
 * 
 * @param EndAnimationID:eval
 * @text End Animation ID
 * @type animation
 * @desc Plays an animation when projectile reaches target.
 * Use 0 to not use. Requires ActSeqProjectiles v1.09+.
 * @default 0
 *
 * @param EndAnimationMirror:eval
 * @text Mirror Animation
 * @parent EndAnimationID:eval
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the effect animation?
 * Requires VisuMZ_3_ActSeqProjectiles version 1.09+.
 * @default false
 *
 * @param EndAnimationMute:eval
 * @text Mute Animation
 * @parent EndAnimationID:eval
 * @type boolean
 * @on Mute
 * @off Normal
 * @desc Mute the effect animation?
 * Requires VisuMZ_3_ActSeqProjectiles version 1.09+.
 * @default false
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Extra Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileExtra:
 * 
 * @param AutoAngle:eval
 * @text Auto Angle?
 * @parent Settings
 * @type boolean
 * @on Automatically Angle
 * @off Normal
 * @desc Automatically angle the projectile to tilt the direction it's moving?
 * @default true
 * 
 * @param AngleOffset:eval
 * @text Angle Offset
 * @desc Alter the projectile's tilt by this many degrees.
 * @default +0
 * 
 * @param Arc:eval
 * @text Arc Peak
 * @parent Settings
 * @desc This is the height of the projectile's trajectory arc
 * in pixels.
 * @default 0
 *
 * @param BlendMode:num
 * @text Blend Mode
 * @type select
 * @option 0 - Normal
 * @value 0
 * @option 1 - Additive
 * @value 1
 * @option 2 - Multiply
 * @value 2
 * @option 3 - Screen
 * @value 3
 * @desc What kind of blend mode do you wish to apply to the projectile?
 * @default 0
 *
 * @param EasingType:str
 * @text Easing
 * @parent Settings
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type to apply to the projectile's trajectory.
 * @default Linear
 * 
 * @param Hue:eval
 * @text Hue
 * @parent Settings
 * @desc Adjust the hue of the projectile.
 * Insert a number between 0 and 360.
 * @default 0
 * 
 * @param Scale:eval
 * @text Scale
 * @parent Settings
 * @desc Adjust the size scaling of the projectile.
 * Use decimals for exact control.
 * @default 1.0
 * 
 * @param Spin:eval
 * @text Spin Speed
 * @parent Settings
 * @desc Determine how much angle the projectile spins per frame.
 * Does not work well with "Auto Angle".
 * @default +0.0
 * 
 * @param Emulate
 * @text Effect Emulation
 * 
 * @param EmulateActionEffect:eval
 * @text Action Effect?
 * @parent Emulate
 * @type boolean
 * @on Emulate
 * @off Don't Emulate
 * @desc Emulate current Action Effect when projectile reaches
 * target? Only works with start/goal targets.
 * @default false
 * 
 * @param EmulateItemEffect:eval
 * @text Item Effect ID
 * @parent Emulate
 * @type item
 * @desc Emulate an Item Effect when projectile reaches target?
 * Use 0 to not use. Only works with start/goal targets.
 * @default 0
 * 
 * @param EmulateSkillEffect:eval
 * @text Skill Effect ID
 * @parent Emulate
 * @type skill
 * @desc Emulate a Skill Effect when projectile reaches target?
 * Use 0 to not use. Only works with start/goal targets.
 * @default 0
 *
 * @param OnceParallel:num
 * @text Common Event ID
 * @parent Emulate
 * @type common_event
 * @desc Plays a Once Parallel Common Event upon reaching target.
 * Use 0 to not use. Works regardless of start/goal targets.
 * @default 0
 * 
 * @param EndAnimationID:eval
 * @text End Animation ID
 * @type animation
 * @desc Plays an animation when projectile reaches target.
 * Use 0 to not use. Requires ActSeqProjectiles v1.09+.
 * @default 0
 *
 * @param EndAnimationMirror:eval
 * @text Mirror Animation
 * @parent EndAnimationID:eval
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the effect animation?
 * Requires VisuMZ_3_ActSeqProjectiles version 1.09+.
 * @default false
 *
 * @param EndAnimationMute:eval
 * @text Mute Animation
 * @parent EndAnimationID:eval
 * @type boolean
 * @on Mute
 * @off Normal
 * @desc Mute the effect animation?
 * Requires VisuMZ_3_ActSeqProjectiles version 1.09+.
 * @default false
 *
 */
/* ----------------------------------------------------------------------------
 * Visual Cutin Effect Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~VisualCutinEffect:
 *
 * @param Transition
 * 
 * @param enterDuration:num
 * @text Entrance Duration
 * @parent Transition
 * @type number
 * @desc How many frames does it take to fully enter?
 * Used when a Visual Cutin Effect starts.
 * @default 12
 * 
 * @param exitDuration:num
 * @text Exit Duration
 * @parent Transition
 * @type number
 * @desc How many frames does it take to fully exit?
 * Used when a Visual Cutin Effect ends.
 * @default 12
 *
 * @param Cutin
 * @text Cutin Settings
 *
 * @param bgShow:eval
 * @text Show BG Color?
 * @parent Cutin
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Add a background color for this cutin?
 * Background colors appear behind the parallax.
 * @default true
 *
 * @param outlineShow:eval
 * @text Show Outline?
 * @parent Cutin
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show the cutin outline?
 * @default true
 *
 * @param Portrait
 * @text Portrait Settings
 *
 * @param PortraitBase
 * @text Base Properties
 * @parent Portrait
 * 
 * @param portraitAnchorX:num
 * @text Anchor X
 * @parent PortraitBase
 * @desc Determines the sprite anchor X alignment.
 * 0.0: Left, 0.5: Center, 1.0: Right.
 * @default 0.5
 * 
 * @param portraitAnchorY:num
 * @text Anchor Y
 * @parent PortraitBase
 * @desc Determines the sprite anchor Y alignment.
 * 0.0: Top, 0.5: Middle, 1.0: Bottom.
 * @default 0.5
 *
 * @param portraitHue:num
 * @text Hue
 * @parent PortraitBase
 * @type number
 * @min 0
 * @max 360
 * @desc Do you wish to adjust this cutin's portrait hue?
 * @default 0
 * 
 * @param portraitOpacity:num
 * @text Opacity
 * @parent PortraitBase
 * @type number
 * @max 255
 * @desc What is the opacity level of this cutin's portrait?
 * @default 255
 * 
 * @param portraitOffsetX:num
 * @text Offset X
 * @parent PortraitBase
 * @desc Offsets the cutin portrait's X location.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @param portraitOffsetY:num
 * @text Offset Y
 * @parent PortraitBase
 * @desc Offsets the cutin portrait's Y location.
 * Negative: up. Positive: down.
 * @default +0
 *
 * @param PortraitEnter
 * @text Entrance Properties
 * @parent Portrait
 * 
 * @param portraitEnterX:num
 * @text Entrance X
 * @parent PortraitEnter
 * @desc Sets the cutin portrait's X entrance.
 * Negative: from left. Positive: from right.
 * @default +0
 * 
 * @param portraitEnterY:num
 * @text Entrance Y
 * @parent PortraitEnter
 * @desc Sets the cutin portrait's Y entrance.
 * Negative: from up. Positive: from down.
 * @default +0
 *
 * @param portraitEnterEasingType:str
 * @text Entrance Easing
 * @parent PortraitEnter
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default InOutSine
 *
 * @param PortraitExit
 * @text Exit Properties
 * @parent Portrait
 * 
 * @param portraitExitX:num
 * @text Exit X
 * @parent PortraitExit
 * @desc Sets the cutin portrait's X exit.
 * Negative: to left. Positive: to right.
 * @default +0
 * 
 * @param portraitExitY:num
 * @text Exit Y
 * @parent PortraitExit
 * @desc Sets the cutin portrait's Y exit.
 * Negative: to up. Positive: to down.
 * @default +0
 *
 * @param portraitExitEasingType:str
 * @text Exit Easing
 * @parent PortraitExit
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default InOutSine
 *
 * @param PortraitFlip
 * @text Flip Properties
 * @parent Portrait
 *
 * @param portraitFlipHorz:eval
 * @text Flip Horizontally?
 * @parent PortraitFlip
 * @type boolean
 * @on Flip
 * @off Don't Flip
 * @desc Flip the cutin portrait horizontally?
 * @default false
 *
 * @param portraitFlipVert:eval
 * @text Flip Vertically?
 * @parent PortraitFlip
 * @type boolean
 * @on Flip
 * @off Don't Flip
 * @desc Flip the cutin portrait vertically?
 * @default false
 *
 * @param PortraitScale
 * @text Scaling Properties
 * @parent Portrait
 * 
 * @param portraitForcedScale:num
 * @text Forced Scaling
 * @parent PortraitScale
 * @desc Do you want to force a scaling ratio?
 * Leave as 0 for none. Disables "Fit to Scale?".
 * @default 0.0
 *
 * @param portraitScaleToFit:eval
 * @text Fit to Scale?
 * @parent PortraitScale
 * @type boolean
 * @on Fit to Scale
 * @off Don't Scale
 * @desc Scale the cutin portrait to fit the cutin style?
 * Cannot be used with "Forced Scaling".
 * @default true
 *
 * @param portraitScaleMax:eval
 * @text Scale Max?
 * @parent portraitScaleToFit:eval
 * @type boolean
 * @on Scale Maximum
 * @off Scale Minimum
 * @desc Scale the cutin portrait to the maximum fit or
 * scale the cutin portrait to the minimum fit.
 * @default false
 *
 * @param PortraitAni
 * @text Animated Portraits
 * @parent Portrait
 *
 * @param animatedPortraitLooping:eval
 * @text Loop?
 * @parent PortraitAni
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Will loop back to beginning once ended.
 * Requires VisuMZ_4_AnimatedPictures!
 * @default true
 *
 * @param animatedPortraitWaitFrames:num
 * @text Wait Frames
 * @parent PortraitAni
 * @type number
 * @min 1
 * @desc Frames to wait before moving to next cell.
 * Requires VisuMZ_4_AnimatedPictures!
 * @default 4
 *
 * @param Parallax
 * @text Parallax Settings
 *
 * @param ParallaxBase
 * @text Base Settings
 * @parent Parallax
 *
 * @param parallaxBlendMode:num
 * @text Blend Mode
 * @parent ParallaxBase
 * @type select
 * @option 0 - Normal
 * @value 0
 * @option 1 - Additive
 * @value 1
 * @option 2 - Multiply
 * @value 2
 * @option 3 - Screen
 * @value 3
 * @desc What kind of blend mode do you wish to apply to the cutin?
 * @default 0
 *
 * @param parallaxHue:num
 * @text Hue
 * @parent ParallaxBase
 * @type number
 * @min 0
 * @max 360
 * @desc Do you wish to adjust this cutin's parallax hue?
 * @default 0
 *
 * @param parallaxHueEnemyModifier:num
 * @text Enemy Modifier
 * @parent parallaxHue:num
 * @desc Adjust the hue value by this if the cutin target is an enemy.
 * @default +0
 * 
 * @param parallaxOpacity:num
 * @text Opacity
 * @parent ParallaxBase
 * @type number
 * @max 255
 * @desc What is the opacity level of this cutin's parallax?
 * @default 255
 *
 * @param ParallaxScroll
 * @text Scrolling Settings
 * @parent Parallax
 * 
 * @param parallaxOffsetX:num
 * @text Offset X
 * @parent ParallaxScroll
 * @desc Offsets the cutin parallax's X location.
 * Negative: left. Positive: right.
 * @default +0.0
 * 
 * @param parallaxOffsetY:num
 * @text Offset Y
 * @parent ParallaxScroll
 * @desc Offsets the cutin parallax's Y location.
 * Negative: up. Positive: down.
 * @default +0.0
 * 
 * @param parallaxScrollX:num
 * @text Scroll X
 * @parent ParallaxScroll
 * @desc How many pixels does the parallax scroll horizontally?
 * Negative: Scroll to right. Positive: Scroll to left.
 * @default +0.0
 *
 * @param parallaxScrollXinvertEnemy:eval
 * @text Invert for Enemy?
 * @parent parallaxScrollX:num
 * @type boolean
 * @on Invert
 * @off Don't Invert
 * @desc Invert the X scroll direction if the cutin target is an enemy?
 * @default false
 * 
 * @param parallaxScrollY:num
 * @text Scroll Y
 * @parent ParallaxScroll
 * @desc How many pixels does the parallax scroll vertically?
 * Negative: Scroll to down. Positive: Scroll to up.
 * @default +0.0
 *
 * @param parallaxScrollYinvertEnemy:eval
 * @text Invert for Enemy?
 * @parent parallaxScrollY:num
 * @type boolean
 * @on Invert
 * @off Don't Invert
 * @desc Invert the Y scroll direction if the cutin target is an enemy?
 * @default false
 *
 */
//=============================================================================

const _0x2dcaec=_0x4e7d;(function(_0x59f387,_0x59515e){const _0x1315b9=_0x4e7d,_0x4cfa4e=_0x59f387();while(!![]){try{const _0x117bc2=-parseInt(_0x1315b9(0x2f3))/0x1+-parseInt(_0x1315b9(0x160))/0x2*(parseInt(_0x1315b9(0x61b))/0x3)+-parseInt(_0x1315b9(0x90e))/0x4+-parseInt(_0x1315b9(0xc40))/0x5*(parseInt(_0x1315b9(0x991))/0x6)+-parseInt(_0x1315b9(0x175))/0x7+parseInt(_0x1315b9(0xa4c))/0x8*(-parseInt(_0x1315b9(0x3de))/0x9)+parseInt(_0x1315b9(0x798))/0xa*(parseInt(_0x1315b9(0x543))/0xb);if(_0x117bc2===_0x59515e)break;else _0x4cfa4e['push'](_0x4cfa4e['shift']());}catch(_0x3e54f3){_0x4cfa4e['push'](_0x4cfa4e['shift']());}}}(_0x2f13,0xc9704));var label=_0x2dcaec(0xae3),tier=tier||0x0,dependencies=[],pluginData=$plugins['filter'](function(_0x71d39){const _0x2efd82=_0x2dcaec;return _0x71d39[_0x2efd82(0x747)]&&_0x71d39['description'][_0x2efd82(0x7f2)]('['+label+']');})[0x0];VisuMZ[label]['Settings']=VisuMZ[label]['Settings']||{},VisuMZ[_0x2dcaec(0x44f)]=function(_0x2f533f,_0x52d8c3){const _0x558d9d=_0x2dcaec;for(const _0x35c61a in _0x52d8c3){if(_0x35c61a[_0x558d9d(0xb9e)](/(.*):(.*)/i)){const _0x4d068d=String(RegExp['$1']),_0x5f49fe=String(RegExp['$2'])[_0x558d9d(0xb9f)]()[_0x558d9d(0x651)]();let _0x4f1423,_0x5c65e2,_0x185572;switch(_0x5f49fe){case _0x558d9d(0xa27):_0x4f1423=_0x52d8c3[_0x35c61a]!==''?Number(_0x52d8c3[_0x35c61a]):0x0;break;case'ARRAYNUM':_0x5c65e2=_0x52d8c3[_0x35c61a]!==''?JSON['parse'](_0x52d8c3[_0x35c61a]):[],_0x4f1423=_0x5c65e2[_0x558d9d(0xc20)](_0x2081c0=>Number(_0x2081c0));break;case _0x558d9d(0xa64):_0x4f1423=_0x52d8c3[_0x35c61a]!==''?eval(_0x52d8c3[_0x35c61a]):null;break;case'ARRAYEVAL':_0x5c65e2=_0x52d8c3[_0x35c61a]!==''?JSON['parse'](_0x52d8c3[_0x35c61a]):[],_0x4f1423=_0x5c65e2['map'](_0x49b855=>eval(_0x49b855));break;case'JSON':_0x4f1423=_0x52d8c3[_0x35c61a]!==''?JSON['parse'](_0x52d8c3[_0x35c61a]):'';break;case _0x558d9d(0xc6a):_0x5c65e2=_0x52d8c3[_0x35c61a]!==''?JSON[_0x558d9d(0x135)](_0x52d8c3[_0x35c61a]):[],_0x4f1423=_0x5c65e2[_0x558d9d(0xc20)](_0x192a1c=>JSON[_0x558d9d(0x135)](_0x192a1c));break;case _0x558d9d(0x146):_0x4f1423=_0x52d8c3[_0x35c61a]!==''?new Function(JSON['parse'](_0x52d8c3[_0x35c61a])):new Function(_0x558d9d(0xb10));break;case'ARRAYFUNC':_0x5c65e2=_0x52d8c3[_0x35c61a]!==''?JSON[_0x558d9d(0x135)](_0x52d8c3[_0x35c61a]):[],_0x4f1423=_0x5c65e2[_0x558d9d(0xc20)](_0x5495f5=>new Function(JSON[_0x558d9d(0x135)](_0x5495f5)));break;case'STR':_0x4f1423=_0x52d8c3[_0x35c61a]!==''?String(_0x52d8c3[_0x35c61a]):'';break;case'ARRAYSTR':_0x5c65e2=_0x52d8c3[_0x35c61a]!==''?JSON[_0x558d9d(0x135)](_0x52d8c3[_0x35c61a]):[],_0x4f1423=_0x5c65e2['map'](_0x595c68=>String(_0x595c68));break;case _0x558d9d(0x2d0):_0x185572=_0x52d8c3[_0x35c61a]!==''?JSON['parse'](_0x52d8c3[_0x35c61a]):{},_0x2f533f[_0x4d068d]={},VisuMZ['ConvertParams'](_0x2f533f[_0x4d068d],_0x185572);continue;case _0x558d9d(0x279):_0x5c65e2=_0x52d8c3[_0x35c61a]!==''?JSON[_0x558d9d(0x135)](_0x52d8c3[_0x35c61a]):[],_0x4f1423=_0x5c65e2[_0x558d9d(0xc20)](_0x16a615=>VisuMZ[_0x558d9d(0x44f)]({},JSON[_0x558d9d(0x135)](_0x16a615)));break;default:continue;}_0x2f533f[_0x4d068d]=_0x4f1423;}}return _0x2f533f;},(_0x367351=>{const _0x4dd964=_0x2dcaec,_0xe0eb99=_0x367351[_0x4dd964(0x321)];for(const _0x18b510 of dependencies){if(!Imported[_0x18b510]){alert(_0x4dd964(0xb95)[_0x4dd964(0xb60)](_0xe0eb99,_0x18b510)),SceneManager[_0x4dd964(0x33f)]();break;}}const _0x14c77d=_0x367351[_0x4dd964(0x7c3)];if(_0x14c77d[_0x4dd964(0xb9e)](/\[Version[ ](.*?)\]/i)){const _0x1958e8=Number(RegExp['$1']);_0x1958e8!==VisuMZ[label][_0x4dd964(0x620)]&&(alert(_0x4dd964(0x2c7)[_0x4dd964(0xb60)](_0xe0eb99,_0x1958e8)),SceneManager['exit']());}if(_0x14c77d[_0x4dd964(0xb9e)](/\[Tier[ ](\d+)\]/i)){const _0x4c3287=Number(RegExp['$1']);_0x4c3287<tier?(alert(_0x4dd964(0xade)[_0x4dd964(0xb60)](_0xe0eb99,_0x4c3287,tier)),SceneManager[_0x4dd964(0x33f)]()):tier=Math['max'](_0x4c3287,tier);}VisuMZ['ConvertParams'](VisuMZ[label][_0x4dd964(0xbeb)],_0x367351[_0x4dd964(0x718)]);})(pluginData),VisuMZ[_0x2dcaec(0x77f)]=function(_0x4cf98){const _0x15931e=_0x2dcaec;let _0x44dfa8=[];for(const _0x2b5b8c of _0x4cf98){_0x44dfa8=_0x44dfa8[_0x15931e(0xa5b)](VisuMZ[_0x15931e(0x7b4)](_0x2b5b8c));}return _0x44dfa8[_0x15931e(0x5ed)](_0x1affe7=>_0x1affe7);},VisuMZ['ConvertActionSequenceTarget']=function(_0x5cfac9){const _0x458132=_0x2dcaec,_0x1f16e0=BattleManager[_0x458132(0xb96)]()[_0x458132(0x5ed)](_0x1c5bc5=>_0x1c5bc5&&_0x1c5bc5[_0x458132(0x6a6)]()),_0x465900=BattleManager[_0x458132(0x173)],_0x3f1ff6=BattleManager[_0x458132(0xc39)],_0x4d3c68=BattleManager['_allTargets']?BattleManager['_allTargets'][_0x458132(0xa5e)](0x0):_0x1f16e0;_0x5cfac9=_0x5cfac9[_0x458132(0x918)]()[_0x458132(0x651)]();if(_0x5cfac9===_0x458132(0x17e))return[_0x465900];else{if(_0x5cfac9==='current\x20target')return[_0x3f1ff6];else{if(_0x5cfac9===_0x458132(0x32f)){if(_0x3f1ff6){const _0x2246cb=_0x4d3c68[_0x458132(0x7bc)](_0x3f1ff6);return _0x2246cb>=0x0?[_0x4d3c68[_0x2246cb-0x1]||_0x3f1ff6]:[_0x3f1ff6];}}else{if(_0x5cfac9===_0x458132(0x216)){if(_0x3f1ff6){const _0x3379c9=_0x4d3c68[_0x458132(0x7bc)](_0x3f1ff6);return _0x3379c9>=0x0?[_0x4d3c68[_0x3379c9+0x1]||_0x3f1ff6]:[_0x3f1ff6];}}else{if(_0x5cfac9===_0x458132(0x35e))return _0x4d3c68;else{if(_0x5cfac9===_0x458132(0x8af))return[_0x465900][_0x458132(0xa5b)](_0x4d3c68);else{if(_0x5cfac9===_0x458132(0xa49))return _0x1f16e0['filter'](_0xbba76a=>_0xbba76a!==_0x465900&&!_0x4d3c68[_0x458132(0x7f2)](_0xbba76a)&&_0xbba76a[_0x458132(0x864)]());else{if(_0x5cfac9==='special')return[VisuMZ[_0x458132(0x72d)]()];else{if(_0x5cfac9[_0x458132(0xb9e)](/SPECIAL (.*)>/i)){const _0x1a47ca=String(RegExp['$1'])[_0x458132(0x13b)](',')[_0x458132(0xc20)](_0x2731e9=>_0x2731e9[_0x458132(0x651)]());return[VisuMZ['GetActionSequenceSpecialTargetWithFlags'](_0x1a47ca)];}}}}}}}}}if(_0x465900){if(_0x5cfac9===_0x458132(0x29e))return _0x465900['friendsUnit']()['aliveMembers']();else{if(_0x5cfac9===_0x458132(0x2d5))return _0x465900[_0x458132(0x630)]()[_0x458132(0x9ef)]()[_0x458132(0x5ed)](_0x55ea28=>_0x55ea28!==_0x465900);else{if(_0x5cfac9===_0x458132(0x54b))return _0x465900[_0x458132(0x630)]()[_0x458132(0x9ef)]()[_0x458132(0x5ed)](_0x22c6ee=>_0x22c6ee!==_0x3f1ff6);else{if(_0x5cfac9===_0x458132(0x3bd))return _0x465900[_0x458132(0x630)]()[_0x458132(0x7ba)]();else{if(_0x5cfac9[_0x458132(0xb9e)](/FRIEND INDEX (\d+)/i)){const _0x4e4867=Number(RegExp['$1']);return[_0x465900[_0x458132(0x630)]()[_0x458132(0x963)]()[_0x4e4867]];}}}}}if(_0x5cfac9===_0x458132(0xb4e))return _0x465900[_0x458132(0x2f2)]()[_0x458132(0x9ef)]();else{if(_0x5cfac9===_0x458132(0x1ca))return _0x465900['opponentsUnit']()['aliveMembers']()['filter'](_0x77cf89=>_0x77cf89!==_0x3f1ff6);else{if(_0x5cfac9===_0x458132(0x3f7))return _0x465900['opponentsUnit']()['deadMembers']();else{if(_0x5cfac9[_0x458132(0xb9e)](/OPPONENT INDEX (\d+)/i)){const _0x1fc194=Number(RegExp['$1']);return[_0x465900[_0x458132(0x2f2)]()[_0x458132(0x963)]()[_0x1fc194]];}}}}}if(_0x5cfac9==='alive\x20actors')return $gameParty[_0x458132(0x9ef)]();else{if(_0x5cfac9===_0x458132(0x82c))return $gameParty['aliveMembers']()[_0x458132(0x5ed)](_0x4ea746=>_0x4ea746!==_0x465900);else{if(_0x5cfac9==='alive\x20actors\x20not\x20target')return $gameParty['aliveMembers']()[_0x458132(0x5ed)](_0x36f707=>_0x36f707!==_0x3f1ff6);else{if(_0x5cfac9===_0x458132(0x9bc))return $gameParty[_0x458132(0x7ba)]();else{if(_0x5cfac9[_0x458132(0xb9e)](/ACTOR INDEX (\d+)/i)){const _0x10a34f=Number(RegExp['$1']);return[$gameParty['members']()[_0x10a34f]];}else{if(_0x5cfac9[_0x458132(0xb9e)](/ACTOR ID (\d+)/i)){const _0x120735=Number(RegExp['$1']);return[$gameActors[_0x458132(0x3fc)](_0x120735)];}}}}}}if(_0x5cfac9===_0x458132(0xa15))return $gameTroop[_0x458132(0x9ef)]();else{if(_0x5cfac9===_0x458132(0xa01))return $gameTroop[_0x458132(0x9ef)]()[_0x458132(0x5ed)](_0x29870d=>_0x29870d!==_0x465900);else{if(_0x5cfac9==='alive\x20enemies\x20not\x20target')return $gameTroop[_0x458132(0x9ef)]()['filter'](_0x286cb8=>_0x286cb8!==_0x3f1ff6);else{if(_0x5cfac9===_0x458132(0x5ff))return $gameTroop[_0x458132(0x7ba)]();else{if(_0x5cfac9[_0x458132(0xb9e)](/ENEMY INDEX (\d+)/i)){const _0x2d7996=Number(RegExp['$1']);return[$gameTroop['members']()[_0x2d7996]];}else{if(_0x5cfac9[_0x458132(0xb9e)](/ENEMY ID (\d+)/i)){const _0x1bb565=Number(RegExp['$1']);return $gameTroop[_0x458132(0x9ef)]()['filter'](_0x533234=>_0x533234['enemyId']()===_0x1bb565);}}}}}}if(_0x5cfac9===_0x458132(0x660))return _0x1f16e0[_0x458132(0x5ed)](_0x1dce88=>_0x1dce88[_0x458132(0x2b5)]());else{if(_0x5cfac9==='alive\x20battlers\x20not\x20user')return _0x1f16e0['filter'](_0x41f26e=>_0x41f26e[_0x458132(0x2b5)]()&&_0x41f26e!==_0x465900);else{if(_0x5cfac9==='alive\x20battlers\x20not\x20target')return _0x1f16e0['filter'](_0x58d6c7=>_0x58d6c7['isAlive']()&&_0x58d6c7!==_0x3f1ff6);else{if(_0x5cfac9===_0x458132(0x47a))return _0x1f16e0[_0x458132(0x5ed)](_0x41d795=>_0x41d795[_0x458132(0x1f5)]());}}}return[];},VisuMZ[_0x2dcaec(0x72d)]=function(){return BattleManager['_target'];},VisuMZ[_0x2dcaec(0x9b1)]=function(_0x1adf45){const _0x19c200=_0x2dcaec;return BattleManager[_0x19c200(0xc39)];},PluginManager[_0x2dcaec(0x1a8)](pluginData['name'],_0x2dcaec(0x46a),_0x13fa98=>{const _0x1cdacc=_0x2dcaec;if(!SceneManager[_0x1cdacc(0xa2b)]())return;VisuMZ[_0x1cdacc(0x44f)](_0x13fa98,_0x13fa98);const _0x145dd5=$gameTemp[_0x1cdacc(0x9c5)](),_0x56715c=BattleManager[_0x1cdacc(0x151)],_0x59a177=BattleManager[_0x1cdacc(0x173)],_0x2e93d5=BattleManager['_allTargets']?BattleManager[_0x1cdacc(0x180)][_0x1cdacc(0xa5e)](0x0):[],_0x1409ff=BattleManager[_0x1cdacc(0x9a7)];if(!_0x145dd5||!_0x56715c||!_0x59a177)return;if(!_0x56715c['item']())return;if(_0x13fa98['DisplayAction'])_0x1409ff['displayAction'](_0x59a177,_0x56715c[_0x1cdacc(0x719)]());_0x13fa98[_0x1cdacc(0x290)]&&_0x1409ff[_0x1cdacc(0x190)](_0x1cdacc(0x822),_0x59a177,_0x2e93d5,!![]);if(_0x13fa98[_0x1cdacc(0x1e3)])_0x1409ff[_0x1cdacc(0x190)]('performActionStart',_0x59a177,_0x56715c);if(_0x13fa98['WaitForMovement'])_0x1409ff[_0x1cdacc(0x190)]('waitForMovement');if(_0x13fa98[_0x1cdacc(0x40f)])_0x1409ff[_0x1cdacc(0x190)](_0x1cdacc(0x65e),_0x59a177,_0x56715c);if(_0x13fa98['WaitForAnimation'])_0x1409ff[_0x1cdacc(0x190)]('waitForAnimation');_0x145dd5[_0x1cdacc(0x415)]('battlelog');}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],'ActSeq_Set_WholeActionSet',_0x4c7389=>{const _0xbf98fe=_0x2dcaec;if(!SceneManager[_0xbf98fe(0xa2b)]())return;VisuMZ[_0xbf98fe(0x44f)](_0x4c7389,_0x4c7389);const _0x4a4e53=$gameTemp[_0xbf98fe(0x9c5)](),_0x10b148=BattleManager['_action'],_0xea7ea2=BattleManager[_0xbf98fe(0x173)],_0x422b83=BattleManager[_0xbf98fe(0x180)]?BattleManager[_0xbf98fe(0x180)]['slice'](0x0):[],_0x55609e=BattleManager['_logWindow'],_0x29b00f=_0x4c7389[_0xbf98fe(0x6f6)]??![];if(!_0x4a4e53||!_0x10b148||!_0xea7ea2)return;if(!_0x10b148[_0xbf98fe(0x719)]())return;let _0x2df51b=_0x29b00f?_0x55609e['getDualWieldTimes'](_0xea7ea2):0x1;for(let _0x49c1f1=0x0;_0x49c1f1<_0x2df51b;_0x49c1f1++){_0x29b00f&&_0xea7ea2[_0xbf98fe(0x8d6)]()&&_0x55609e[_0xbf98fe(0x190)]('setActiveWeaponSet',_0xea7ea2,_0x49c1f1);if(_0x4c7389['PerformAction'])_0x55609e[_0xbf98fe(0x190)](_0xbf98fe(0x79c),_0xea7ea2,_0x10b148);if(_0x4c7389[_0xbf98fe(0x1ea)]>0x0)_0x55609e['push'](_0xbf98fe(0x4f3),_0x4c7389['WaitCount']);if(_0x4c7389[_0xbf98fe(0xc59)])_0x55609e['push']('showAnimation',_0xea7ea2,_0x422b83,_0x10b148['item']()[_0xbf98fe(0x9fc)]);if(_0x4c7389['WaitForAnimation'])_0x55609e['push'](_0xbf98fe(0x2c2));for(const _0x441d09 of _0x422b83){if(!_0x441d09)continue;if(_0x4c7389[_0xbf98fe(0x3d4)])_0x55609e[_0xbf98fe(0x190)](_0xbf98fe(0xc1b),_0xea7ea2,_0x441d09);}}_0x29b00f&&_0xea7ea2[_0xbf98fe(0x8d6)]()&&_0x55609e['push'](_0xbf98fe(0x2ab),_0xea7ea2);if(_0x4c7389[_0xbf98fe(0x290)])_0x55609e[_0xbf98fe(0x190)](_0xbf98fe(0x822),_0xea7ea2,_0x422b83,![]);_0x4a4e53[_0xbf98fe(0x415)]('battlelog');}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x46e),_0x25b33c=>{const _0x6519d2=_0x2dcaec;if(!SceneManager[_0x6519d2(0xa2b)]())return;VisuMZ[_0x6519d2(0x44f)](_0x25b33c,_0x25b33c);const _0x1f948b=$gameTemp[_0x6519d2(0x9c5)](),_0x18bd9c=BattleManager['_action'],_0x4b8f32=BattleManager[_0x6519d2(0x173)],_0x6620d4=BattleManager[_0x6519d2(0x180)]?BattleManager[_0x6519d2(0x180)][_0x6519d2(0xa5e)](0x0):[],_0x10d7f8=BattleManager[_0x6519d2(0x9a7)],_0x59a6a8=_0x25b33c[_0x6519d2(0x6f6)]??![];if(!_0x1f948b||!_0x18bd9c||!_0x4b8f32)return;if(!_0x18bd9c[_0x6519d2(0x719)]())return;let _0x12e83f=_0x59a6a8?_0x10d7f8[_0x6519d2(0x18d)](_0x4b8f32):0x1;for(let _0x43e690=0x0;_0x43e690<_0x12e83f;_0x43e690++){for(const _0x8863ab of _0x6620d4){if(!_0x8863ab)continue;_0x59a6a8&&_0x4b8f32[_0x6519d2(0x8d6)]()&&_0x10d7f8['push']('setActiveWeaponSet',_0x4b8f32,_0x43e690);if(_0x25b33c['PerformAction'])_0x10d7f8[_0x6519d2(0x190)](_0x6519d2(0x79c),_0x4b8f32,_0x18bd9c);if(_0x25b33c['WaitCount1']>0x0)_0x10d7f8['push'](_0x6519d2(0x4f3),_0x25b33c[_0x6519d2(0x665)]);if(_0x25b33c[_0x6519d2(0xc59)])_0x10d7f8[_0x6519d2(0x190)](_0x6519d2(0x735),_0x4b8f32,[_0x8863ab],_0x18bd9c[_0x6519d2(0x719)]()[_0x6519d2(0x9fc)]);if(_0x25b33c[_0x6519d2(0xa46)]>0x0)_0x10d7f8[_0x6519d2(0x190)](_0x6519d2(0x4f3),_0x25b33c['WaitCount2']);if(_0x25b33c[_0x6519d2(0x3d4)])_0x10d7f8['push'](_0x6519d2(0xc1b),_0x4b8f32,_0x8863ab);}}_0x59a6a8&&_0x4b8f32[_0x6519d2(0x8d6)]()&&_0x10d7f8[_0x6519d2(0x190)](_0x6519d2(0x2ab),_0x4b8f32);if(_0x25b33c[_0x6519d2(0x290)])_0x10d7f8[_0x6519d2(0x190)](_0x6519d2(0x822),_0x4b8f32,_0x6620d4,![]);_0x1f948b[_0x6519d2(0x415)](_0x6519d2(0xbd0));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x891),_0x136047=>{const _0x30427b=_0x2dcaec;if(!SceneManager[_0x30427b(0xa2b)]())return;VisuMZ[_0x30427b(0x44f)](_0x136047,_0x136047);const _0x260093=$gameTemp[_0x30427b(0x9c5)](),_0x279abb=BattleManager['_action'],_0x33eb93=BattleManager[_0x30427b(0x173)],_0x3e2990=BattleManager[_0x30427b(0x180)]?BattleManager[_0x30427b(0x180)][_0x30427b(0xa5e)](0x0):[],_0x4b63b7=BattleManager[_0x30427b(0x9a7)];if(!_0x260093||!_0x279abb||!_0x33eb93)return;if(!_0x279abb['item']())return;if(_0x136047[_0x30427b(0x290)])_0x4b63b7[_0x30427b(0x190)](_0x30427b(0x822),_0x33eb93,_0x3e2990,![]);if(_0x136047[_0x30427b(0x2bf)])_0x4b63b7[_0x30427b(0x190)](_0x30427b(0xbbd));if(_0x136047[_0x30427b(0x4db)])_0x4b63b7[_0x30427b(0x190)]('waitForEffect');if(_0x136047[_0x30427b(0x850)])_0x4b63b7[_0x30427b(0x190)](_0x30427b(0xb7e));if(_0x136047[_0x30427b(0x1dc)])_0x4b63b7['push'](_0x30427b(0xa57),_0x33eb93);if(_0x136047['WaitForMovement'])_0x4b63b7[_0x30427b(0x190)](_0x30427b(0xbd4));_0x260093['setWaitMode'](_0x30427b(0xbd0));}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x52b),_0x533cbd=>{const _0x1d9171=_0x2dcaec;if(!SceneManager[_0x1d9171(0xa2b)]())return;if(!Imported[_0x1d9171(0x161)])return;VisuMZ[_0x1d9171(0x44f)](_0x533cbd,_0x533cbd);const _0x5dfef4=$gameTemp[_0x1d9171(0x9c5)](),_0x142100=_0x533cbd[_0x1d9171(0xa2c)];if(!_0x5dfef4)return;$gameScreen['setBattleAngle'](_0x533cbd[_0x1d9171(0x34a)],_0x533cbd[_0x1d9171(0x603)],_0x533cbd[_0x1d9171(0x9cf)]);if(_0x142100)_0x5dfef4[_0x1d9171(0x415)](_0x1d9171(0x3c4));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],'ActSeq_Angle_Reset',_0x5e756e=>{const _0x2bd81a=_0x2dcaec;if(!SceneManager[_0x2bd81a(0xa2b)]())return;if(!Imported['VisuMZ_3_ActSeqCamera'])return;VisuMZ[_0x2bd81a(0x44f)](_0x5e756e,_0x5e756e);const _0x5798ea=$gameTemp['getLastPluginCommandInterpreter'](),_0x4daf40=_0x5e756e['WaitForAngle'];if(!_0x5798ea)return;$gameScreen[_0x2bd81a(0x378)](0x0,_0x5e756e[_0x2bd81a(0x603)],_0x5e756e['EasingType']);if(_0x4daf40)_0x5798ea[_0x2bd81a(0x415)](_0x2bd81a(0x3c4));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0xb27),_0x44d9c7=>{const _0x2a7dba=_0x2dcaec;if(!SceneManager[_0x2a7dba(0xa2b)]())return;if(!Imported[_0x2a7dba(0x161)])return;const _0x3c7b83=$gameTemp['getLastPluginCommandInterpreter']();if(!_0x3c7b83)return;_0x3c7b83['setWaitMode'](_0x2a7dba(0x3c4));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0xa10),_0x10569a=>{const _0x1ed671=_0x2dcaec;if(!SceneManager[_0x1ed671(0xa2b)]())return;VisuMZ['ConvertParams'](_0x10569a,_0x10569a);const _0x36de68=$gameTemp[_0x1ed671(0x9c5)](),_0x48ecf6=BattleManager[_0x1ed671(0x151)],_0x121912=BattleManager['_subject'],_0x5b2fb6=VisuMZ[_0x1ed671(0x77f)](_0x10569a[_0x1ed671(0xad6)]),_0x2f0ac9=_0x10569a[_0x1ed671(0x68b)],_0x3d071a=BattleManager[_0x1ed671(0x9a7)];if(!_0x36de68||!_0x48ecf6||!_0x121912)return;if(!_0x48ecf6[_0x1ed671(0x719)]())return;let _0x28613e=_0x48ecf6[_0x1ed671(0x719)]()[_0x1ed671(0x9fc)];if(_0x28613e<0x0)_0x28613e=_0x121912[_0x1ed671(0xb66)]();$gameTemp[_0x1ed671(0x819)](_0x5b2fb6,_0x28613e,_0x2f0ac9),_0x10569a[_0x1ed671(0x8fe)]&&_0x36de68[_0x1ed671(0x415)]('battleAnimation');}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x9c3),_0x4fda05=>{const _0x4c28ae=_0x2dcaec;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x4c28ae(0x44f)](_0x4fda05,_0x4fda05);const _0x3c9762=$gameTemp['getLastPluginCommandInterpreter'](),_0x5cf08e=BattleManager['_subject'],_0x17d71e=VisuMZ['CreateActionSequenceTargets'](_0x4fda05['Targets']),_0xc889f7=_0x4fda05[_0x4c28ae(0x68b)],_0x1e932d=BattleManager[_0x4c28ae(0x9a7)];if(!_0x3c9762||!_0x5cf08e)return;const _0x3c459b=_0x5cf08e[_0x4c28ae(0xb66)]();$gameTemp[_0x4c28ae(0x819)](_0x17d71e,_0x3c459b,_0xc889f7),_0x4fda05[_0x4c28ae(0x8fe)]&&_0x3c9762['setWaitMode'](_0x4c28ae(0x14f));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0xafc),_0x12585f=>{const _0x22b84c=_0x2dcaec;if(!SceneManager[_0x22b84c(0xa2b)]())return;VisuMZ[_0x22b84c(0x44f)](_0x12585f,_0x12585f);const _0xa65621=_0x11cfed[_0x22b84c(0x92b)](_0x12585f['Slot']);if(_0xa65621<=0x0)return;const _0x412077=$gameTemp[_0x22b84c(0x9c5)](),_0x11cfed=BattleManager['_subject'],_0x171a1a=VisuMZ[_0x22b84c(0x77f)](_0x12585f[_0x22b84c(0xad6)]),_0x10ada1=_0x12585f['Mirror'],_0x1c5458=BattleManager[_0x22b84c(0x9a7)];if(!_0x412077||!_0x11cfed)return;$gameTemp[_0x22b84c(0x819)](_0x171a1a,_0xa65621,_0x10ada1),_0x12585f[_0x22b84c(0x8fe)]&&_0x412077[_0x22b84c(0x415)](_0x22b84c(0x14f));}),PluginManager[_0x2dcaec(0x1a8)](pluginData['name'],'ActSeq_Animation_BalloonAnimation',_0x18d301=>{const _0xa12864=_0x2dcaec;if(!SceneManager[_0xa12864(0xa2b)]())return;VisuMZ[_0xa12864(0x44f)](_0x18d301,_0x18d301);const _0x710f79=$gameTemp[_0xa12864(0x9c5)](),_0x842a57=VisuMZ[_0xa12864(0x77f)](_0x18d301[_0xa12864(0xad6)]),_0x1ae253=_0x18d301['Balloon'];let _0x45f0ae=0x0;switch(_0x1ae253[_0xa12864(0xb9f)]()['trim']()){case'!':case _0xa12864(0x239):_0x45f0ae=0x1;break;case'?':case _0xa12864(0x661):_0x45f0ae=0x2;break;case _0xa12864(0x754):case _0xa12864(0x371):case _0xa12864(0x58a):case'MUSIC-NOTE':case _0xa12864(0x75d):_0x45f0ae=0x3;break;case'HEART':case _0xa12864(0x911):_0x45f0ae=0x4;break;case _0xa12864(0xc7c):case _0xa12864(0x7ae):_0x45f0ae=0x5;break;case _0xa12864(0x2cc):_0x45f0ae=0x6;break;case _0xa12864(0x2d4):case _0xa12864(0xb3b):case _0xa12864(0xbdc):_0x45f0ae=0x7;break;case _0xa12864(0x7fd):case _0xa12864(0xa5a):_0x45f0ae=0x8;break;case'LIGHT':case _0xa12864(0x4a0):case _0xa12864(0x57d):case'LIGHT-BULB':case _0xa12864(0x307):_0x45f0ae=0x9;break;case'Z':case'ZZ':case _0xa12864(0xa60):case _0xa12864(0xc17):_0x45f0ae=0xa;break;case _0xa12864(0x20c):_0x45f0ae=0xb;break;case'USER-DEFINED\x202':_0x45f0ae=0xc;break;case _0xa12864(0x4a4):_0x45f0ae=0xd;break;case _0xa12864(0x1b8):_0x45f0ae=0xe;break;case _0xa12864(0x532):_0x45f0ae=0xf;break;}for(const _0x5b2f22 of _0x842a57){if(!_0x5b2f22)continue;$gameTemp[_0xa12864(0xc0c)](_0x5b2f22,_0x45f0ae);}_0x18d301[_0xa12864(0x4ea)]&&_0x710f79&&(_0x710f79['wait'](0x1),_0x710f79[_0xa12864(0x415)](_0xa12864(0x998)));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],'ActSeq_Animation_BalloonIcon',_0x2293fc=>{const _0x91c8c8=_0x2dcaec;if(!SceneManager[_0x91c8c8(0xa2b)]())return;if(!Imported[_0x91c8c8(0x827)])return;VisuMZ[_0x91c8c8(0x44f)](_0x2293fc,_0x2293fc);const _0x559497=$gameTemp[_0x91c8c8(0x9c5)](),_0x1b4c47=VisuMZ['CreateActionSequenceTargets'](_0x2293fc[_0x91c8c8(0xad6)]),_0x3efe14=_0x2293fc[_0x91c8c8(0x990)];for(const _0x55039f of _0x1b4c47){if(!_0x55039f)continue;$gameTemp[_0x91c8c8(0xc0c)](_0x55039f,[_0x3efe14]);}_0x2293fc[_0x91c8c8(0x4ea)]&&_0x559497&&(_0x559497['wait'](0x1),_0x559497['setWaitMode']('battleBalloon'));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],'ActSeq_Animation_BalloonIconRange',_0xf3e61=>{const _0x16fcb0=_0x2dcaec;if(!SceneManager[_0x16fcb0(0xa2b)]())return;if(!Imported['VisuMZ_4_IconBalloons'])return;VisuMZ[_0x16fcb0(0x44f)](_0xf3e61,_0xf3e61);const _0x517b2c=$gameTemp[_0x16fcb0(0x9c5)](),_0x2eb96d=VisuMZ[_0x16fcb0(0x77f)](_0xf3e61[_0x16fcb0(0xad6)]),_0x1d87e9=Math[_0x16fcb0(0xaf1)](Number(_0xf3e61[_0x16fcb0(0x210)]||0x0),Number(_0xf3e61[_0x16fcb0(0x8df)]||0x0)),_0xef3dfd=Math[_0x16fcb0(0x959)](Number(_0xf3e61[_0x16fcb0(0x210)]||0x0),Number(_0xf3e61[_0x16fcb0(0x8df)]||0x0)),_0x4aebdf=[];for(let _0x9c5774=_0x1d87e9;_0x9c5774<=_0xef3dfd;_0x9c5774++){_0x4aebdf[_0x16fcb0(0x190)](_0x9c5774);}for(const _0x10ee5b of _0x2eb96d){if(!_0x10ee5b)continue;$gameTemp[_0x16fcb0(0xc0c)](_0x10ee5b,_0x4aebdf);}_0xf3e61[_0x16fcb0(0x4ea)]&&_0x517b2c&&(_0x517b2c[_0x16fcb0(0x275)](0x1),_0x517b2c[_0x16fcb0(0x415)](_0x16fcb0(0x998)));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x677),_0x2e3f72=>{const _0x3dda8c=_0x2dcaec;if(!SceneManager[_0x3dda8c(0xa2b)]())return;if(!Imported[_0x3dda8c(0x827)])return;VisuMZ[_0x3dda8c(0x44f)](_0x2e3f72,_0x2e3f72);const _0x313c03=$gameTemp['getLastPluginCommandInterpreter'](),_0x110463=VisuMZ[_0x3dda8c(0x77f)](_0x2e3f72[_0x3dda8c(0xad6)]),_0x506b3d=_0x2e3f72['icons'];for(const _0x3f0a30 of _0x110463){if(!_0x3f0a30)continue;$gameTemp[_0x3dda8c(0xc0c)](_0x3f0a30,_0x506b3d);}_0x2e3f72['WaitComplete']&&_0x313c03&&(_0x313c03[_0x3dda8c(0x275)](0x1),_0x313c03[_0x3dda8c(0x415)]('battleBalloon'));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x559),_0x368766=>{const _0x5b0c40=_0x2dcaec;if(!SceneManager['isSceneBattle']())return;VisuMZ['ConvertParams'](_0x368766,_0x368766);const _0x372cf3=$gameTemp['getLastPluginCommandInterpreter'](),_0x25de6b=BattleManager[_0x5b0c40(0x151)],_0xa6a2c2=_0x368766[_0x5b0c40(0x68b)],_0x878afc=VisuMZ[_0x5b0c40(0x77f)](_0x368766[_0x5b0c40(0xad6)]);if(!_0x372cf3||!_0x25de6b)return;if(!_0x25de6b[_0x5b0c40(0x719)]())return;for(const _0x32fd3 of _0x878afc){if(!_0x32fd3)continue;_0x32fd3[_0x5b0c40(0x65e)](_0x25de6b,_0xa6a2c2);}if(_0x368766[_0x5b0c40(0x8fe)])_0x372cf3[_0x5b0c40(0x415)](_0x5b0c40(0x14f));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x68a),_0x32ab69=>{const _0x788a74=_0x2dcaec;VisuMZ[_0x788a74(0x44f)](_0x32ab69,_0x32ab69);const _0x2cf62d=$gameTemp[_0x788a74(0x9c5)](),_0x37ec1f=VisuMZ[_0x788a74(0x77f)](_0x32ab69[_0x788a74(0xad6)]),_0x1097e0=_0x32ab69[_0x788a74(0x40d)];if(!_0x1097e0)return;for(const _0xd91f1b of _0x37ec1f){if(!_0xd91f1b)continue;if(!_0xd91f1b[_0x788a74(0x8d6)]())continue;_0xd91f1b[_0x788a74(0x688)](_0x1097e0);}}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x497),_0x240445=>{const _0x377523=_0x2dcaec;VisuMZ[_0x377523(0x44f)](_0x240445,_0x240445);const _0x35ce3c=_0x240445['ActorJS'](),_0x5f4881=$gameActors[_0x377523(0x3fc)](_0x35ce3c)||null;if(!_0x5f4881){console['log'](_0x377523(0x668));return;}const _0x160b7c=_0x240445['FilenameJS']();_0x5f4881[_0x377523(0x688)](_0x160b7c);}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x57c),_0x524d6a=>{const _0x31e621=_0x2dcaec;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x31e621(0x44f)](_0x524d6a,_0x524d6a);const _0x1d0549=$gameTemp['getLastPluginCommandInterpreter'](),_0xceb1c8=BattleManager[_0x31e621(0x173)],_0x2c6c05=VisuMZ[_0x31e621(0x77f)](_0x524d6a[_0x31e621(0xad6)]),_0x1422ee=_0x524d6a[_0x31e621(0x68b)];if(!_0x1d0549||!_0xceb1c8)return;const _0x274d8e=$dataSkilles[_0xceb1c8[_0x31e621(0xc2c)]()],_0x29b657=_0x274d8e[_0x31e621(0x9fc)];$gameTemp[_0x31e621(0x819)](_0x2c6c05,_0x29b657,_0x1422ee),_0x524d6a[_0x31e621(0x8fe)]&&_0x1d0549['setWaitMode'](_0x31e621(0x14f));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0xa34),_0x155ea8=>{const _0xf910de=_0x2dcaec;if(!SceneManager[_0xf910de(0xa2b)]())return;VisuMZ[_0xf910de(0x44f)](_0x155ea8,_0x155ea8);const _0x321d21=$gameTemp[_0xf910de(0x9c5)](),_0x357fcc=VisuMZ[_0xf910de(0x77f)](_0x155ea8[_0xf910de(0xad6)]),_0x3718ee=Number(_0x155ea8['ItemID']||0x1),_0x536124=$dataItems[_0x3718ee],_0x115192=_0x155ea8['Mirror'];if(!_0x321d21)return;if(!_0x536124)return;let _0x2ed2da=_0x536124[_0xf910de(0x9fc)];$gameTemp[_0xf910de(0x819)](_0x357fcc,_0x2ed2da,_0x115192),_0x155ea8['WaitForAnimation']&&_0x321d21[_0xf910de(0x415)](_0xf910de(0x14f));}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],'ActSeq_Animation_PlayAtCoordinate',_0x39d356=>{const _0x5287de=_0x2dcaec;if(!SceneManager[_0x5287de(0x496)])return;if(!SceneManager[_0x5287de(0x496)][_0x5287de(0x2a3)])return;if(!Imported[_0x5287de(0x6d3)])return;VisuMZ[_0x5287de(0x44f)](_0x39d356,_0x39d356);const _0x38aef1=$gameTemp[_0x5287de(0x9c5)](),_0x165aef=Math[_0x5287de(0x976)](_0x39d356[_0x5287de(0x17c)]),_0x583c4e=Math['round'](_0x39d356[_0x5287de(0x777)]);$gameTemp[_0x5287de(0x196)](_0x165aef,_0x583c4e,_0x39d356[_0x5287de(0xb9b)],_0x39d356[_0x5287de(0x68b)],_0x39d356[_0x5287de(0x5f1)]),_0x39d356['WaitComplete']&&_0x38aef1&&(SceneManager[_0x5287de(0x496)]['_spriteset'][_0x5287de(0x736)](),_0x38aef1[_0x5287de(0x415)](_0x5287de(0x14f)));}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x1c2),_0x42413c=>{const _0x30df73=_0x2dcaec;if(!SceneManager['isSceneBattle']())return;VisuMZ['ConvertParams'](_0x42413c,_0x42413c);const _0x598a16=$gameTemp[_0x30df73(0x9c5)](),_0x1c761c=VisuMZ[_0x30df73(0x77f)](_0x42413c[_0x30df73(0xad6)]),_0x4b53a=_0x42413c['AnimationID'],_0x20b189=_0x42413c[_0x30df73(0x68b)];if(!_0x598a16)return;$gameTemp['requestAnimation'](_0x1c761c,_0x4b53a,_0x20b189);if(_0x42413c[_0x30df73(0x8fe)])_0x598a16[_0x30df73(0x415)](_0x30df73(0x14f));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x9e8),_0x3a3695=>{const _0x351995=_0x2dcaec;if(!SceneManager[_0x351995(0xa2b)]())return;VisuMZ['ConvertParams'](_0x3a3695,_0x3a3695);const _0x1dd412=$gameTemp[_0x351995(0x9c5)](),_0xc4787b=VisuMZ['CreateActionSequenceTargets'](_0x3a3695[_0x351995(0xad6)]),_0x428f2d=Number(_0x3a3695['AnimationID'])||0x1,_0x4c259d=_0x3a3695['Mirror'];if(!_0x1dd412)return;$gameTemp[_0x351995(0x819)](_0xc4787b,_0x428f2d,_0x4c259d);if(_0x3a3695['WaitForAnimation'])_0x1dd412[_0x351995(0x415)](_0x351995(0x14f));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x602),_0xc3947f=>{const _0x5e49c9=_0x2dcaec;if(!SceneManager[_0x5e49c9(0xa2b)]())return;VisuMZ[_0x5e49c9(0x44f)](_0xc3947f,_0xc3947f);const _0x2882e9=$gameTemp[_0x5e49c9(0x9c5)](),_0x193f31=VisuMZ[_0x5e49c9(0x77f)](_0xc3947f['Targets']),_0xe334b7=Number(_0xc3947f[_0x5e49c9(0xa0a)]||0x1),_0x490906=$dataSkills[_0xe334b7],_0x2f40ff=_0xc3947f['Mirror'];if(!_0x2882e9)return;if(!_0x490906)return;let _0x5a7e35=_0x490906[_0x5e49c9(0x9fc)];$gameTemp[_0x5e49c9(0x819)](_0x193f31,_0x5a7e35,_0x2f40ff),_0xc3947f[_0x5e49c9(0x8fe)]&&_0x2882e9[_0x5e49c9(0x415)]('battleAnimation');}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0xb59),_0x2111d6=>{const _0x733529=_0x2dcaec;if(!SceneManager[_0x733529(0xa2b)]())return;const _0x55c51a=$gameTemp[_0x733529(0x9c5)]();if(!_0x55c51a)return;_0x55c51a[_0x733529(0x415)](_0x733529(0x14f));}),PluginManager['registerCommand'](pluginData['name'],_0x2dcaec(0x830),_0x1ee5c6=>{const _0x24d76=_0x2dcaec;if(!SceneManager[_0x24d76(0xa2b)]())return;VisuMZ[_0x24d76(0x44f)](_0x1ee5c6,_0x1ee5c6);const _0x2ce06f=BattleManager['_logWindow'],_0x5a8520=_0x1ee5c6[_0x24d76(0x3fd)]&&Imported[_0x24d76(0xb89)];_0x2ce06f['addText'](_0x1ee5c6[_0x24d76(0x6b0)]),_0x5a8520&&Imported[_0x24d76(0xb89)]&&$gameSystem[_0x24d76(0x72b)](_0x1ee5c6[_0x24d76(0x6b0)]||'',_0x1ee5c6[_0x24d76(0x201)]||0x0);}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x139),_0x5b607c=>{if(!SceneManager['isSceneBattle']())return;const _0x4260a0=BattleManager['_logWindow'];_0x4260a0['clear']();}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x1a0),_0x545245=>{const _0x5dc1df=_0x2dcaec;if(!SceneManager['isSceneBattle']())return;const _0x1c2907=$gameTemp[_0x5dc1df(0x9c5)](),_0x570780=BattleManager[_0x5dc1df(0x151)],_0x3400f8=BattleManager[_0x5dc1df(0x173)],_0x15ece8=BattleManager['_logWindow'];if(!_0x1c2907||!_0x570780||!_0x3400f8)return;if(!_0x570780['item']())return;_0x15ece8[_0x5dc1df(0x189)](_0x3400f8,_0x570780[_0x5dc1df(0x719)]()),_0x1c2907['setWaitMode'](_0x5dc1df(0xbd0));}),PluginManager['registerCommand'](pluginData['name'],'ActSeq_BattleLog_PopBaseLine',_0x4ca92b=>{const _0x5e4cea=_0x2dcaec;if(!SceneManager[_0x5e4cea(0xa2b)]())return;const _0x312979=BattleManager['_logWindow'];_0x312979[_0x5e4cea(0x3ee)]();}),PluginManager[_0x2dcaec(0x1a8)](pluginData['name'],_0x2dcaec(0x68e),_0x329388=>{const _0x3fd54d=_0x2dcaec;if(!SceneManager[_0x3fd54d(0xa2b)]())return;const _0x47e379=BattleManager[_0x3fd54d(0x9a7)];_0x47e379[_0x3fd54d(0x328)]();}),PluginManager[_0x2dcaec(0x1a8)](pluginData['name'],_0x2dcaec(0x6dd),_0x45e4bc=>{const _0x233296=_0x2dcaec;if(!SceneManager[_0x233296(0xa2b)]())return;const _0x1bbf72=BattleManager[_0x233296(0x9a7)];_0x1bbf72[_0x233296(0xbc9)]();}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x540),_0x4a70e4=>{const _0x3ef67a=_0x2dcaec;if(!SceneManager[_0x3ef67a(0xa2b)]())return;VisuMZ['ConvertParams'](_0x4a70e4,_0x4a70e4),SceneManager[_0x3ef67a(0x496)][_0x3ef67a(0x51e)](_0x4a70e4[_0x3ef67a(0x39a)]);}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0xb52),_0x4e2a6e=>{const _0x31a30f=_0x2dcaec;if(!SceneManager['isSceneBattle']())return;const _0x345555=$gameTemp[_0x31a30f(0x9c5)]();_0x345555[_0x31a30f(0x415)](_0x31a30f(0xbd0));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0xaad),_0x1c2c71=>{const _0x1adb65=_0x2dcaec;if(!SceneManager[_0x1adb65(0xa2b)]())return;const _0x4e971c=$gameTemp[_0x1adb65(0x9c5)](),_0x3cbb7f=BattleManager[_0x1adb65(0x9a7)];_0x3cbb7f[_0x1adb65(0xbbd)](),_0x4e971c['setWaitMode'](_0x1adb65(0xbd0));}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x7f0),_0x7795ae=>{const _0x11516a=_0x2dcaec;if(!SceneManager[_0x11516a(0xa2b)]())return;if(!Imported[_0x11516a(0x161)])return;VisuMZ[_0x11516a(0x44f)](_0x7795ae,_0x7795ae);const _0x6c3365=$gameScreen[_0x11516a(0x41f)]();_0x6c3365[_0x11516a(0xaa7)]=_0x7795ae[_0x11516a(0xbaa)];}),PluginManager[_0x2dcaec(0x1a8)](pluginData['name'],'ActSeq_Camera_FocusPoint',_0x5bd9c0=>{const _0x52b142=_0x2dcaec;if(!SceneManager[_0x52b142(0xa2b)]())return;if(!Imported[_0x52b142(0x161)])return;VisuMZ['ConvertParams'](_0x5bd9c0,_0x5bd9c0);const _0x5069fd=$gameTemp[_0x52b142(0x9c5)](),_0x4c2c60=_0x5bd9c0['WaitForCamera'];$gameScreen['setBattleCameraPoint'](_0x5bd9c0[_0x52b142(0x94a)],_0x5bd9c0['FocusY'],_0x5bd9c0[_0x52b142(0x603)],_0x5bd9c0[_0x52b142(0x9cf)]);if(_0x4c2c60)_0x5069fd[_0x52b142(0x415)](_0x52b142(0xa75));}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0xc07),_0x150a79=>{const _0x5cedfd=_0x2dcaec;if(!SceneManager[_0x5cedfd(0xa2b)]())return;if(!Imported[_0x5cedfd(0x161)])return;VisuMZ['ConvertParams'](_0x150a79,_0x150a79);const _0x53e150=$gameTemp[_0x5cedfd(0x9c5)](),_0x5b50e3=VisuMZ['CreateActionSequenceTargets'](_0x150a79[_0x5cedfd(0xad6)]),_0x15da46=_0x150a79[_0x5cedfd(0x882)];$gameScreen['setBattleCameraTargets'](_0x5b50e3,_0x150a79[_0x5cedfd(0x603)],_0x150a79[_0x5cedfd(0x9cf)]);if(_0x15da46)_0x53e150[_0x5cedfd(0x415)](_0x5cedfd(0xa75));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0xb8b),_0x2275a1=>{const _0x50d9e5=_0x2dcaec;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x50d9e5(0x161)])return;VisuMZ[_0x50d9e5(0x44f)](_0x2275a1,_0x2275a1);const _0x25ea13=$gameTemp['getLastPluginCommandInterpreter'](),_0x45387a=_0x2275a1[_0x50d9e5(0x882)];$gameScreen[_0x50d9e5(0x432)](_0x2275a1['OffsetX'],_0x2275a1[_0x50d9e5(0x53d)],_0x2275a1['Duration'],_0x2275a1['EasingType']);if(_0x45387a)_0x25ea13[_0x50d9e5(0x415)](_0x50d9e5(0xa75));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x549),_0x1b4dd8=>{const _0xa0b34c=_0x2dcaec;if(!SceneManager[_0xa0b34c(0xa2b)]())return;if(!Imported[_0xa0b34c(0x161)])return;VisuMZ[_0xa0b34c(0x44f)](_0x1b4dd8,_0x1b4dd8);const _0x4d38ee=$gameTemp['getLastPluginCommandInterpreter'](),_0x4ff6d0=_0x1b4dd8[_0xa0b34c(0x303)],_0x90cdd5=_0x1b4dd8[_0xa0b34c(0x8f2)],_0x2874a9=_0x1b4dd8[_0xa0b34c(0x882)];if(_0x4ff6d0){const _0x34dc82=Math[_0xa0b34c(0x976)](Graphics[_0xa0b34c(0x64b)]/0x2),_0x4fbf60=Math['round'](Graphics[_0xa0b34c(0x75c)]/0x2);$gameScreen[_0xa0b34c(0x564)](_0x34dc82,_0x4fbf60,_0x1b4dd8[_0xa0b34c(0x603)],_0x1b4dd8['EasingType']);}_0x90cdd5&&$gameScreen[_0xa0b34c(0x432)](0x0,0x0,_0x1b4dd8[_0xa0b34c(0x603)],_0x1b4dd8[_0xa0b34c(0x9cf)]);if(_0x2874a9)_0x4d38ee[_0xa0b34c(0x415)](_0xa0b34c(0xa75));}),PluginManager[_0x2dcaec(0x1a8)](pluginData['name'],'ActSeq_Camera_WaitForCamera',_0x44d542=>{const _0x24bd21=_0x2dcaec;if(!SceneManager[_0x24bd21(0xa2b)]())return;if(!Imported[_0x24bd21(0x161)])return;const _0x27c252=$gameTemp[_0x24bd21(0x9c5)]();if(!_0x27c252)return;_0x27c252[_0x24bd21(0x415)]('battleCamera');}),VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x8a5)]=function(_0x21a0a7){const _0x4efcda=_0x2dcaec;_0x21a0a7[_0x4efcda(0x58b)]='';const _0x2610c0=VisuMZ['VisualCutinEffect'][_0x4efcda(0x8a5)](_0x21a0a7),_0x5d2d6a=VisuMZ['CreateActionSequenceTargets'](_0x21a0a7[_0x4efcda(0xad6)])[0x0]||null;return _0x5d2d6a&&(_0x2610c0['portraitFilename']=_0x5d2d6a['visualCutinPortraitFilename'](),_0x2610c0[_0x4efcda(0x3e5)]=_0x5d2d6a['visualCutinPortraitIndex'](),_0x2610c0[_0x4efcda(0xb01)]=_0x5d2d6a[_0x4efcda(0x92c)](),_0x2610c0['portraitType']=_0x5d2d6a[_0x4efcda(0x8ff)](),_0x5d2d6a[_0x4efcda(0x5d1)]()&&(_0x5d2d6a[_0x4efcda(0xaf9)]()&&(_0x2610c0[_0x4efcda(0x2ba)]=!_0x2610c0[_0x4efcda(0x2ba)]),_0x5d2d6a[_0x4efcda(0xa78)]()&&(_0x2610c0[_0x4efcda(0x509)]=!_0x2610c0['portraitFlipVert']),_0x2610c0['portraitType']===_0x4efcda(0x43d)&&(_0x2610c0[_0x4efcda(0x2ba)]=!_0x2610c0['portraitFlipHorz']),_0x21a0a7[_0x4efcda(0x391)][_0x4efcda(0x6ce)]&&(_0x2610c0['parallaxScrollX']*=-0x1),_0x21a0a7['ExtraSettings'][_0x4efcda(0x7f4)]&&(_0x2610c0[_0x4efcda(0x182)]*=-0x1),_0x2610c0[_0x4efcda(0x614)]+=_0x21a0a7[_0x4efcda(0x391)][_0x4efcda(0x952)]??0x0)),_0x2610c0;},PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x2bc),_0x341db5=>{const _0x56236f=_0x2dcaec;if(!SceneManager[_0x56236f(0xa2b)]())return;if(!Imported[_0x56236f(0xc1e)])return;VisuMZ['ConvertParams'](_0x341db5,_0x341db5);const _0x43a52f=VisuMZ[_0x56236f(0xae3)][_0x56236f(0x8a5)](_0x341db5);SceneManager[_0x56236f(0x496)][_0x56236f(0x209)](_0x43a52f);const _0x409ccf=$gameTemp[_0x56236f(0x9c5)]();_0x409ccf&&_0x341db5[_0x56236f(0x333)]&&_0x409ccf[_0x56236f(0x415)](_0x56236f(0xbd7));}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x704),_0x19e638=>{const _0x2dc753=_0x2dcaec;if(!SceneManager[_0x2dc753(0xa2b)]())return;if(!Imported[_0x2dc753(0xc1e)])return;VisuMZ['ConvertParams'](_0x19e638,_0x19e638),SceneManager[_0x2dc753(0x496)][_0x2dc753(0xa73)]();const _0x155f26=$gameTemp[_0x2dc753(0x9c5)]();_0x155f26&&_0x19e638[_0x2dc753(0x304)]&&_0x155f26[_0x2dc753(0x415)](_0x2dc753(0x896));}),PluginManager[_0x2dcaec(0x1a8)](pluginData['name'],'ActSeq_Cutin_EndVisualCutinEffectType',_0x4cdb95=>{const _0x311bdf=_0x2dcaec;if(!SceneManager[_0x311bdf(0xa2b)]())return;if(!Imported['VisuMZ_3_VisualCutinEffect'])return;VisuMZ['ConvertParams'](_0x4cdb95,_0x4cdb95);const _0x47dbcd=_0x4cdb95[_0x311bdf(0x134)][_0x311bdf(0x918)]()[_0x311bdf(0x651)]();SceneManager[_0x311bdf(0x496)][_0x311bdf(0x705)](_0x47dbcd);const _0x35fd72=$gameTemp[_0x311bdf(0x9c5)]();_0x35fd72&&_0x4cdb95[_0x311bdf(0x304)]&&_0x35fd72[_0x311bdf(0x415)](_0x311bdf(0x896));}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x5c3),_0x4f27e8=>{const _0x3cc11b=_0x2dcaec;if(!SceneManager[_0x3cc11b(0xa2b)]())return;if(!Imported['VisuMZ_3_VisualCutinEffect'])return;const _0x29dff8=$gameTemp[_0x3cc11b(0x9c5)]();_0x29dff8[_0x3cc11b(0x415)]('cutinEnter');}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x22e),_0x252298=>{const _0x318012=_0x2dcaec;if(!SceneManager[_0x318012(0xa2b)]())return;if(!Imported[_0x318012(0xc1e)])return;const _0xd513bc=$gameTemp[_0x318012(0x9c5)]();_0xd513bc[_0x318012(0x415)](_0x318012(0x896));}),PluginManager['registerCommand'](pluginData['name'],_0x2dcaec(0xb6d),_0x287a6a=>{const _0x84ba71=_0x2dcaec;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x84ba71(0x9e3)])return;VisuMZ['ConvertParams'](_0x287a6a,_0x287a6a);const _0x6c6549=VisuMZ['CreateActionSequenceTargets'](_0x287a6a[_0x84ba71(0xad6)]),_0x2dd5e5=_0x287a6a['MotionAni'][_0x84ba71(0x918)]()[_0x84ba71(0x651)]();for(const _0xdd9ff0 of _0x6c6549){if(!_0xdd9ff0)continue;_0xdd9ff0['requestDragonbonesAnimation'](_0x2dd5e5);}}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x74f),_0x37d9b3=>{const _0x530ba9=_0x2dcaec;if(!SceneManager[_0x530ba9(0xa2b)]())return;if(!Imported[_0x530ba9(0x9e3)])return;VisuMZ[_0x530ba9(0x44f)](_0x37d9b3,_0x37d9b3);const _0x45c9d1=VisuMZ[_0x530ba9(0x77f)](_0x37d9b3[_0x530ba9(0xad6)]),_0x953676=_0x37d9b3[_0x530ba9(0x8c7)];for(const _0x39e38a of _0x45c9d1){if(!_0x39e38a)continue;_0x39e38a['dragonbonesData']()['timeScale']=_0x953676;}}),PluginManager[_0x2dcaec(0x1a8)](pluginData['name'],_0x2dcaec(0x5fe),_0x129f2c=>{const _0x3885b8=_0x2dcaec;if(!SceneManager[_0x3885b8(0xa2b)]())return;if(!Imported[_0x3885b8(0xa6c)])return;VisuMZ[_0x3885b8(0x44f)](_0x129f2c,_0x129f2c);const _0x847d38=BattleManager['_action'],_0x4ed2b7=_0x129f2c[_0x3885b8(0x8dd)];if(!_0x847d38)return;_0x847d38['_battleCoreAddedElements']=_0x4ed2b7;}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],'ActSeq_Element_Clear',_0x570694=>{const _0x118d4f=_0x2dcaec;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x118d4f(0xa6c)])return;const _0x1be796=BattleManager[_0x118d4f(0x151)];if(!_0x1be796)return;_0x1be796[_0x118d4f(0x53a)]();}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x6f0),_0x1e6816=>{const _0xed2e5d=_0x2dcaec;if(!SceneManager[_0xed2e5d(0xa2b)]())return;if(!Imported['VisuMZ_1_ElementStatusCore'])return;VisuMZ['ConvertParams'](_0x1e6816,_0x1e6816);const _0x5b7199=BattleManager[_0xed2e5d(0x151)],_0x52ad53=_0x1e6816[_0xed2e5d(0x8dd)];if(!_0x5b7199)return;_0x5b7199[_0xed2e5d(0xac8)]=_0x52ad53;}),PluginManager[_0x2dcaec(0x1a8)](pluginData['name'],_0x2dcaec(0x573),_0x8607c0=>{const _0x34f872=_0x2dcaec;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x34f872(0xa6c)])return;const _0x3be258=BattleManager['_action'];if(!_0x3be258)return;_0x3be258[_0x34f872(0x8cf)]=!![];}),PluginManager[_0x2dcaec(0x1a8)](pluginData['name'],'ActSeq_Grid_ActionAnimationAtNode',_0x1c1700=>{const _0x4e365d=_0x2dcaec;VisuMZ[_0x4e365d(0x2f8)][_0x4e365d(0xc13)](_0x1c1700);}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x428),_0x3ccde1=>{const _0x2f5241=_0x2dcaec;VisuMZ[_0x2f5241(0x2f8)][_0x2f5241(0x428)](_0x3ccde1);}),PluginManager[_0x2dcaec(0x1a8)](pluginData['name'],_0x2dcaec(0x28f),_0x32bef2=>{const _0x2a0f51=_0x2dcaec;VisuMZ[_0x2a0f51(0x2f8)][_0x2a0f51(0x28f)](_0x32bef2);}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x76a),_0x5e84b8=>{const _0x4a41ce=_0x2dcaec;VisuMZ[_0x4a41ce(0x2f8)][_0x4a41ce(0x28f)](_0x5e84b8);}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x1a4),_0x41d8f0=>{const _0x19a943=_0x2dcaec;VisuMZ[_0x19a943(0x2f8)]['ActSeq_Grid_AnimationIDAtNode'](_0x41d8f0);}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x869),_0x3ef9a8=>{const _0x714a5=_0x2dcaec;VisuMZ[_0x714a5(0x2f8)][_0x714a5(0x869)](_0x3ef9a8);}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x280),_0x571ea8=>{const _0x2c34f3=_0x2dcaec;VisuMZ[_0x2c34f3(0x2f8)][_0x2c34f3(0x280)](_0x571ea8);}),PluginManager[_0x2dcaec(0x1a8)](pluginData['name'],_0x2dcaec(0x4c2),_0x363c9a=>{const _0x39dffb=_0x2dcaec;VisuMZ[_0x39dffb(0x2f8)][_0x39dffb(0x4c2)](_0x363c9a);}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],'ActSeq_Grid_MoveTargetsInDirection',_0x387aa5=>{const _0x151ebc=_0x2dcaec;VisuMZ[_0x151ebc(0x2f8)][_0x151ebc(0x5e2)](_0x387aa5);}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],'ActSeq_Grid_PullToTargetNode',_0x468e47=>{const _0x751248=_0x2dcaec;VisuMZ[_0x751248(0x2f8)][_0x751248(0xabb)](_0x468e47);}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x234),_0x5652bf=>{const _0x10f147=_0x2dcaec;VisuMZ[_0x10f147(0x2f8)][_0x10f147(0x234)](_0x5652bf);}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x2da),_0x1c4a23=>{const _0x125668=_0x2dcaec;VisuMZ[_0x125668(0x2f8)][_0x125668(0x2da)](_0x1c4a23);}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0xbb8),_0x1e8deb=>{const _0x4b916=_0x2dcaec;VisuMZ[_0x4b916(0x2f8)][_0x4b916(0xbb8)](_0x1e8deb);}),PluginManager['registerCommand'](pluginData['name'],'ActSeq_Grid_TeleportToNode',_0x458fd2=>{const _0x11e7e9=_0x2dcaec;VisuMZ[_0x11e7e9(0x2f8)][_0x11e7e9(0x7fa)](_0x458fd2);}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0xb62),_0x1922d0=>{VisuMZ['BattleGridSystem']['ActSeq_Grid_TraverseToNode'](_0x1922d0);}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0xafa),_0x49094a=>{const _0x3765fd=_0x2dcaec;if(!Imported[_0x3765fd(0x44a)])return;if(!SceneManager[_0x3765fd(0xa2b)]())return;VisuMZ['ConvertParams'](_0x49094a,_0x49094a);const _0x5da430=VisuMZ[_0x3765fd(0x77f)](_0x49094a[_0x3765fd(0xad6)]);for(const _0x5557b2 of _0x5da430){if(!_0x5557b2)continue;_0x5557b2[_0x3765fd(0x1c3)](_0x3765fd(0x99e)),_0x5557b2[_0x3765fd(0x1c3)](_0x3765fd(0x7ed)),_0x5557b2['removeHorrorEffect']('tv'),_0x5557b2[_0x3765fd(0xb1f)]();}$gamePlayer[_0x3765fd(0xbc9)]();}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],'ActSeq_Horror_GlitchCreate',_0x29f2be=>{const _0x55f4f6=_0x2dcaec;if(!Imported[_0x55f4f6(0x44a)])return;if(!SceneManager[_0x55f4f6(0xa2b)]())return;VisuMZ['ConvertParams'](_0x29f2be,_0x29f2be);const _0x3e7992=VisuMZ['CreateActionSequenceTargets'](_0x29f2be['Targets']),_0x24e624=_0x55f4f6(0x7ed);_0x29f2be[_0x55f4f6(0xb76)]=Math[_0x55f4f6(0xbd6)](_0x29f2be[_0x55f4f6(0x582)]/0x2),_0x29f2be['sliceMax']=_0x29f2be[_0x55f4f6(0x582)],_0x29f2be[_0x55f4f6(0x561)]=!![];for(const _0x41992e of _0x3e7992){if(!_0x41992e)continue;_0x41992e[_0x55f4f6(0x85a)](_0x24e624,_0x29f2be);}$gamePlayer[_0x55f4f6(0xbc9)]();}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x1d0),_0x5fceeb=>{const _0x220329=_0x2dcaec;if(!Imported[_0x220329(0x44a)])return;if(!SceneManager[_0x220329(0xa2b)]())return;VisuMZ[_0x220329(0x44f)](_0x5fceeb,_0x5fceeb);const _0x319548=VisuMZ['CreateActionSequenceTargets'](_0x5fceeb[_0x220329(0xad6)]);for(const _0xd7e80b of _0x319548){if(!_0xd7e80b)continue;_0xd7e80b['removeHorrorEffect'](_0x220329(0x7ed));}$gamePlayer[_0x220329(0xbc9)]();}),PluginManager[_0x2dcaec(0x1a8)](pluginData['name'],'ActSeq_Horror_NoiseCreate',_0x92759c=>{const _0x379338=_0x2dcaec;if(!Imported['VisuMZ_2_HorrorEffects'])return;if(!SceneManager[_0x379338(0xa2b)]())return;VisuMZ[_0x379338(0x44f)](_0x92759c,_0x92759c);const _0x2b4e2f=VisuMZ[_0x379338(0x77f)](_0x92759c[_0x379338(0xad6)]),_0x870102=_0x379338(0x99e);for(const _0x4a25c0 of _0x2b4e2f){if(!_0x4a25c0)continue;_0x4a25c0['setHorrorEffectSettings'](_0x870102,_0x92759c);}$gamePlayer[_0x379338(0xbc9)]();}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],'ActSeq_Horror_NoiseRemove',_0x18e7a5=>{const _0x436382=_0x2dcaec;if(!Imported[_0x436382(0x44a)])return;if(!SceneManager[_0x436382(0xa2b)]())return;VisuMZ[_0x436382(0x44f)](_0x18e7a5,_0x18e7a5);const _0x45ed5c=VisuMZ[_0x436382(0x77f)](_0x18e7a5[_0x436382(0xad6)]);for(const _0x3c09b8 of _0x45ed5c){if(!_0x3c09b8)continue;_0x3c09b8['removeHorrorEffect'](_0x436382(0x99e));}$gamePlayer[_0x436382(0xbc9)]();}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],'ActSeq_Horror_TVCreate',_0x211b9f=>{const _0x26242a=_0x2dcaec;if(!Imported[_0x26242a(0x44a)])return;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x26242a(0x44f)](_0x211b9f,_0x211b9f);const _0x1db8ec=VisuMZ[_0x26242a(0x77f)](_0x211b9f['Targets']),_0x2e78f1='tv';for(const _0x4a02dd of _0x1db8ec){if(!_0x4a02dd)continue;_0x4a02dd['setHorrorEffectSettings'](_0x2e78f1,_0x211b9f);}$gamePlayer['refresh']();}),PluginManager['registerCommand'](pluginData['name'],_0x2dcaec(0x1cc),_0x354acc=>{const _0x2615a9=_0x2dcaec;if(!Imported[_0x2615a9(0x44a)])return;if(!SceneManager[_0x2615a9(0xa2b)]())return;VisuMZ[_0x2615a9(0x44f)](_0x354acc,_0x354acc);const _0x11107c=VisuMZ[_0x2615a9(0x77f)](_0x354acc['Targets']);for(const _0x27e0b0 of _0x11107c){if(!_0x27e0b0)continue;_0x27e0b0[_0x2615a9(0x1c3)]('tv');}$gamePlayer['refresh']();}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0xb69),_0x43422c=>{const _0x4f0b06=_0x2dcaec;if(!Imported[_0x4f0b06(0x277)])return;const _0x26730c=SceneManager['_scene']['_spriteset'];if(!_0x26730c)return;if(VisuMZ[_0x4f0b06(0x6f8)][_0x4f0b06(0x620)]<=1.04){alert(_0x4f0b06(0x44d)),SceneManager[_0x4f0b06(0x33f)]();return;}VisuMZ[_0x4f0b06(0x44f)](_0x43422c,_0x43422c);const _0x109f0f=_0x43422c[_0x4f0b06(0x9af)];_0x26730c[_0x4f0b06(0x315)](_0x109f0f);}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x849),_0x3c2a45=>{const _0x132741=_0x2dcaec;if(!SceneManager[_0x132741(0xa2b)]())return;if(!Imported['VisuMZ_3_ActSeqImpact'])return;const _0x27c91e=SceneManager[_0x132741(0x496)][_0x132741(0x2a3)];if(!_0x27c91e)return;VisuMZ['ConvertParams'](_0x3c2a45,_0x3c2a45);const _0x2bb45b=_0x3c2a45['Intensity']||0x1,_0xdf659b=_0x3c2a45[_0x132741(0x603)]||0x1,_0x2f771b=_0x3c2a45['EasingType']||'Linear';_0x27c91e['setupRgbSplitImpactFilter'](_0x2bb45b,_0xdf659b,_0x2f771b);}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x982),_0x268a94=>{const _0x21228e=_0x2dcaec;if(!Imported['VisuMZ_3_ActSeqImpact'])return;const _0x4bd61f=SceneManager[_0x21228e(0x496)]['_spriteset'];if(!_0x4bd61f)return;if(VisuMZ[_0x21228e(0x6f8)][_0x21228e(0x620)]<=1.04){alert('Action\x20Sequence\x20Impact\x20needs\x20an\x20update!'),SceneManager['exit']();return;}VisuMZ['ConvertParams'](_0x268a94,_0x268a94);const _0xe57c35=_0x268a94[_0x21228e(0x9af)];_0x4bd61f[_0x21228e(0x48f)](_0xe57c35);}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0xa6d),_0x2b622c=>{const _0x3a270b=_0x2dcaec;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x3a270b(0x277)])return;const _0x1cea71=SceneManager['_scene']['_spriteset'];if(!_0x1cea71)return;VisuMZ['ConvertParams'](_0x2b622c,_0x2b622c);const _0x3218ed=Number(_0x2b622c[_0x3a270b(0x34a)])||0x0,_0xb8eff3=Number(_0x2b622c['Rate']),_0x2b6e2e=_0x2b622c['Duration']||0x1,_0x2f2d47=_0x2b622c[_0x3a270b(0x9cf)]||_0x3a270b(0x41d);_0x1cea71[_0x3a270b(0xb5d)](_0x3218ed,_0xb8eff3,_0x2b6e2e,_0x2f2d47);}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x2ae),_0x407c49=>{const _0x277483=_0x2dcaec;if(!SceneManager['isSceneBattle']())return;if(!Imported['VisuMZ_3_ActSeqImpact'])return;const _0x42c570=SceneManager[_0x277483(0x496)][_0x277483(0x2a3)];if(!_0x42c570)return;VisuMZ['ConvertParams'](_0x407c49,_0x407c49);const _0x233ed6=Number(_0x407c49['Angle'])||0x0,_0x39c582=Number(_0x407c49[_0x277483(0xb43)]),_0x3197f4=_0x407c49[_0x277483(0x603)]||0x1,_0x21fec7=_0x407c49['EasingType']||_0x277483(0x41d),_0x4c02ad=VisuMZ[_0x277483(0x77f)](_0x407c49[_0x277483(0xad6)]);for(const _0x1740a1 of _0x4c02ad){if(!_0x1740a1)continue;if(!_0x1740a1[_0x277483(0xbc2)]())continue;_0x1740a1[_0x277483(0xbc2)]()[_0x277483(0xb5d)](_0x233ed6,_0x39c582,_0x3197f4,_0x21fec7);}}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x4fc),_0x279adb=>{const _0x1ba6fb=_0x2dcaec;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x1ba6fb(0x277)])return;VisuMZ[_0x1ba6fb(0x44f)](_0x279adb,_0x279adb);const _0x46fa92={'delay':_0x279adb[_0x1ba6fb(0xa32)],'duration':_0x279adb[_0x1ba6fb(0x8d8)],'hue':_0x279adb[_0x1ba6fb(0x9cd)],'opacityStart':_0x279adb[_0x1ba6fb(0xa5f)],'tone':_0x279adb[_0x1ba6fb(0xb81)],'visible':!![]},_0x3bb015=VisuMZ[_0x1ba6fb(0x77f)](_0x279adb['Targets']);for(const _0x285193 of _0x3bb015){if(!_0x285193)continue;_0x285193[_0x1ba6fb(0x763)](_0x46fa92);}}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x931),_0x10872c=>{const _0x33d57c=_0x2dcaec;if(!SceneManager['isSceneBattle']())return;if(!Imported['VisuMZ_3_ActSeqImpact'])return;VisuMZ[_0x33d57c(0x44f)](_0x10872c,_0x10872c);const _0x23a7f7=VisuMZ[_0x33d57c(0x77f)](_0x10872c[_0x33d57c(0xad6)]);for(const _0x448cbd of _0x23a7f7){if(!_0x448cbd)continue;_0x448cbd[_0x33d57c(0x143)]();}}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0xc2b),_0x1cb356=>{const _0x11415a=_0x2dcaec;if(!Imported['VisuMZ_3_ActSeqImpact'])return;const _0x25cfe4=SceneManager[_0x11415a(0x496)][_0x11415a(0x2a3)];if(!_0x25cfe4)return;if(VisuMZ[_0x11415a(0x6f8)]['version']<=1.04){alert(_0x11415a(0x44d)),SceneManager[_0x11415a(0x33f)]();return;}VisuMZ[_0x11415a(0x44f)](_0x1cb356,_0x1cb356);const _0x3ad317=_0x1cb356[_0x11415a(0x9af)];_0x25cfe4['setupNegativeImpactFilter'](_0x3ad317);}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],'ActSeq_Impact_Oversaturate',_0x3135db=>{const _0x1b8f94=_0x2dcaec;if(!Imported[_0x1b8f94(0x277)])return;const _0x15778c=SceneManager[_0x1b8f94(0x496)]['_spriteset'];if(!_0x15778c)return;if(VisuMZ['ActSeqImpact'][_0x1b8f94(0x620)]<=1.04){alert(_0x1b8f94(0x44d)),SceneManager['exit']();return;}VisuMZ[_0x1b8f94(0x44f)](_0x3135db,_0x3135db);const _0x2b5854=_0x3135db[_0x1b8f94(0x9af)];_0x15778c[_0x1b8f94(0x43f)](_0x2b5854);}),PluginManager['registerCommand'](pluginData['name'],_0x2dcaec(0x1be),_0x11a155=>{const _0x231706=_0x2dcaec;if(!Imported[_0x231706(0x277)])return;const _0x1ec304=SceneManager[_0x231706(0x496)][_0x231706(0x2a3)];if(!_0x1ec304)return;VisuMZ[_0x231706(0x44f)](_0x11a155,_0x11a155);const _0xc2e4fb=_0x11a155['X']||0x0,_0x557714=_0x11a155['Y']||0x0,_0x3b7474=_0x11a155[_0x231706(0x2f1)]||0x0,_0x4e6eac=_0x11a155[_0x231706(0x26f)]||0x0,_0xdaa3a4=_0x11a155[_0x231706(0x603)]||0x1;_0x1ec304[_0x231706(0x45e)](_0xc2e4fb,_0x557714,_0x3b7474,_0x4e6eac,_0xdaa3a4);}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],'ActSeq_Impact_ShockwaveEachTargets',_0x3956a2=>{const _0x149adf=_0x2dcaec;if(!SceneManager[_0x149adf(0xa2b)]())return;if(!Imported['VisuMZ_3_ActSeqImpact'])return;const _0x2279b9=SceneManager[_0x149adf(0x496)][_0x149adf(0x2a3)];if(!_0x2279b9)return;VisuMZ['ConvertParams'](_0x3956a2,_0x3956a2);const _0x542a7d=VisuMZ[_0x149adf(0x77f)](_0x3956a2[_0x149adf(0xad6)]),_0x4bd048=_0x3956a2[_0x149adf(0x750)],_0x14dbe1=_0x3956a2['OffsetX']||0x0,_0x170f61=_0x3956a2[_0x149adf(0x53d)]||0x0,_0x479c08=_0x3956a2[_0x149adf(0x2f1)]||0x0,_0x50faf9=_0x3956a2[_0x149adf(0x26f)]||0x0,_0x5b8e69=_0x3956a2['Duration']||0x1;for(const _0x4815c1 of _0x542a7d){if(!_0x4815c1)continue;if(!_0x4815c1[_0x149adf(0xbc2)]())continue;const _0x3c13ca=_0x4815c1[_0x149adf(0xbc2)]();let _0x3aaed4=_0x3c13ca[_0x149adf(0xae9)],_0x50389=_0x3c13ca[_0x149adf(0xa19)];_0x3aaed4+=(Graphics[_0x149adf(0x64b)]-Graphics[_0x149adf(0x555)])/0x2,_0x50389+=(Graphics[_0x149adf(0x75c)]-Graphics[_0x149adf(0xab4)])/0x2;if(_0x4bd048[_0x149adf(0xb9e)](/front/i))_0x3aaed4+=(_0x4815c1[_0x149adf(0x5d1)]()?0x1:-0x1)*_0x3c13ca['mainSpriteWidth']()/0x2;else _0x4bd048[_0x149adf(0xb9e)](/back/i)&&(_0x3aaed4+=(_0x4815c1[_0x149adf(0x5d1)]()?-0x1:0x1)*_0x3c13ca[_0x149adf(0x74d)]()/0x2);if(_0x4bd048['match'](/head/i))_0x50389-=_0x3c13ca[_0x149adf(0x3c2)]();else _0x4bd048[_0x149adf(0xb9e)](/center/i)&&(_0x50389-=_0x3c13ca['mainSpriteHeight']()/0x2);_0x3aaed4+=_0x14dbe1,_0x50389+=_0x170f61,_0x2279b9['setupShockwaveImpactFilter'](_0x3aaed4,_0x50389,_0x479c08,_0x50faf9,_0x5b8e69);}}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x613),_0x5d1e24=>{const _0x9221e6=_0x2dcaec;if(!SceneManager[_0x9221e6(0xa2b)]())return;if(!Imported[_0x9221e6(0x277)])return;const _0x43ddb5=SceneManager[_0x9221e6(0x496)][_0x9221e6(0x2a3)];if(!_0x43ddb5)return;VisuMZ['ConvertParams'](_0x5d1e24,_0x5d1e24);const _0x49ca1f=VisuMZ[_0x9221e6(0x77f)](_0x5d1e24[_0x9221e6(0xad6)]),_0x4c12d9=_0x5d1e24[_0x9221e6(0x750)],_0x4e3825=_0x5d1e24[_0x9221e6(0x842)]||0x0,_0x50768d=_0x5d1e24['OffsetY']||0x0,_0x50a7e5=_0x5d1e24['Amp']||0x0,_0x27093e=_0x5d1e24[_0x9221e6(0x26f)]||0x0,_0x2e3453=_0x5d1e24[_0x9221e6(0x603)]||0x1,_0x30d76b=Math[_0x9221e6(0xaf1)](..._0x49ca1f[_0x9221e6(0xc20)](_0x2a5d86=>_0x2a5d86['battler']()[_0x9221e6(0xae9)]-_0x2a5d86[_0x9221e6(0xbc2)]()[_0x9221e6(0x74d)]()/0x2)),_0x24d769=Math[_0x9221e6(0x959)](..._0x49ca1f[_0x9221e6(0xc20)](_0x4dbd4a=>_0x4dbd4a[_0x9221e6(0xbc2)]()[_0x9221e6(0xae9)]+_0x4dbd4a['battler']()[_0x9221e6(0x74d)]()/0x2)),_0x452b98=Math[_0x9221e6(0xaf1)](..._0x49ca1f[_0x9221e6(0xc20)](_0x3c06ab=>_0x3c06ab['battler']()[_0x9221e6(0xa19)]-_0x3c06ab[_0x9221e6(0xbc2)]()['mainSpriteHeight']())),_0x4b2417=Math[_0x9221e6(0x959)](..._0x49ca1f[_0x9221e6(0xc20)](_0x18bfa5=>_0x18bfa5[_0x9221e6(0xbc2)]()[_0x9221e6(0xa19)])),_0x9977e0=_0x49ca1f[_0x9221e6(0x5ed)](_0x5a6846=>_0x5a6846[_0x9221e6(0x8d6)]())[_0x9221e6(0x7ce)],_0x3db39d=_0x49ca1f[_0x9221e6(0x5ed)](_0xa24746=>_0xa24746[_0x9221e6(0x5d1)]())['length'];let _0x18e6b9=0x0,_0x52172b=0x0;if(_0x4c12d9[_0x9221e6(0xb9e)](/front/i))_0x18e6b9=_0x9977e0>=_0x3db39d?_0x30d76b:_0x24d769;else{if(_0x4c12d9[_0x9221e6(0xb9e)](/middle/i))_0x18e6b9=(_0x30d76b+_0x24d769)/0x2,melee=-0x1;else _0x4c12d9[_0x9221e6(0xb9e)](/back/i)&&(_0x18e6b9=_0x9977e0>=_0x3db39d?_0x24d769:_0x30d76b);}if(_0x4c12d9['match'](/head/i))_0x52172b=_0x452b98;else{if(_0x4c12d9[_0x9221e6(0xb9e)](/center/i))_0x52172b=(_0x452b98+_0x4b2417)/0x2;else _0x4c12d9[_0x9221e6(0xb9e)](/base/i)&&(_0x52172b=_0x4b2417);}_0x18e6b9+=(Graphics[_0x9221e6(0x64b)]-Graphics['boxWidth'])/0x2,_0x52172b+=(Graphics[_0x9221e6(0x75c)]-Graphics[_0x9221e6(0xab4)])/0x2,_0x18e6b9+=_0x4e3825,_0x52172b+=_0x50768d,_0x43ddb5[_0x9221e6(0x45e)](_0x18e6b9,_0x52172b,_0x50a7e5,_0x27093e,_0x2e3453);}),PluginManager[_0x2dcaec(0x1a8)](pluginData['name'],_0x2dcaec(0xadd),_0x2df8dd=>{const _0x150820=_0x2dcaec;if(!Imported[_0x150820(0x277)])return;const _0x223504=SceneManager[_0x150820(0x496)]['_spriteset'];if(!_0x223504)return;if(VisuMZ[_0x150820(0x6f8)][_0x150820(0x620)]<=1.04){alert(_0x150820(0x44d)),SceneManager[_0x150820(0x33f)]();return;}VisuMZ[_0x150820(0x44f)](_0x2df8dd,_0x2df8dd);const _0x70914a=$gameTemp[_0x150820(0x9c5)](),_0x4a1c85=Math[_0x150820(0x959)](0.01,_0x2df8dd[_0x150820(0x3f6)]);$gameTemp[_0x150820(0x70a)](_0x4a1c85,_0x70914a);}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x757),_0x151809=>{const _0xcb4b59=_0x2dcaec;if(!Imported[_0xcb4b59(0x277)])return;const _0x2ef014=SceneManager[_0xcb4b59(0x496)][_0xcb4b59(0x2a3)];if(!_0x2ef014)return;if(VisuMZ[_0xcb4b59(0x6f8)]['version']<=1.04){alert('Action\x20Sequence\x20Impact\x20needs\x20an\x20update!'),SceneManager['exit']();return;}VisuMZ['ConvertParams'](_0x151809,_0x151809);const _0x50e69e=$gameTemp[_0xcb4b59(0x9c5)](),_0x2fa112=_0x151809['ms']||0x1;VisuMZ[_0xcb4b59(0x6f8)]['freezeTime'](_0x2fa112,_0x50e69e);}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x7db),_0x54f548=>{const _0x2225ac=_0x2dcaec;if(!Imported[_0x2225ac(0x277)])return;const _0x2dbdcd=SceneManager[_0x2225ac(0x496)][_0x2225ac(0x2a3)];if(!_0x2dbdcd)return;VisuMZ[_0x2225ac(0x44f)](_0x54f548,_0x54f548);const _0x54fc98=_0x54f548['X']||0x0,_0x1f1264=_0x54f548['Y']||0x0,_0x1b65b7=_0x54f548[_0x2225ac(0xb39)]||0x0,_0x5f3ea1=_0x54f548[_0x2225ac(0xa11)]||0x0,_0x231514=_0x54f548[_0x2225ac(0x603)]||0x1,_0x243795=_0x54f548[_0x2225ac(0x9cf)]||'Linear';_0x2dbdcd[_0x2225ac(0x751)](_0x1b65b7,_0x54fc98,_0x1f1264,_0x5f3ea1,_0x231514,_0x243795);}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],'ActSeq_Impact_ZoomBlurTargetCenter',_0x5965bc=>{const _0x3b9669=_0x2dcaec;if(!Imported[_0x3b9669(0x277)])return;const _0x231a48=SceneManager[_0x3b9669(0x496)][_0x3b9669(0x2a3)];if(!_0x231a48)return;VisuMZ[_0x3b9669(0x44f)](_0x5965bc,_0x5965bc);const _0x54673b=VisuMZ[_0x3b9669(0x77f)](_0x5965bc[_0x3b9669(0xad6)]),_0x1a6e22=_0x5965bc[_0x3b9669(0x750)],_0x5a7567=_0x5965bc['OffsetX']||0x0,_0x133a4d=_0x5965bc['OffsetY']||0x0,_0xf529b3=_0x5965bc[_0x3b9669(0xb39)]||0x0,_0x548ce3=_0x5965bc['Radius']||0x0,_0x39c7aa=_0x5965bc[_0x3b9669(0x603)]||0x1,_0x2bb7c1=_0x5965bc['EasingType']||_0x3b9669(0x41d),_0xae4062=Math[_0x3b9669(0xaf1)](..._0x54673b['map'](_0x1aa7e0=>_0x1aa7e0['battler']()[_0x3b9669(0xae9)]-_0x1aa7e0[_0x3b9669(0xbc2)]()[_0x3b9669(0x74d)]()/0x2)),_0x4c5a48=Math[_0x3b9669(0x959)](..._0x54673b[_0x3b9669(0xc20)](_0x15cf8e=>_0x15cf8e[_0x3b9669(0xbc2)]()[_0x3b9669(0xae9)]+_0x15cf8e[_0x3b9669(0xbc2)]()['mainSpriteWidth']()/0x2)),_0x158aeb=Math[_0x3b9669(0xaf1)](..._0x54673b['map'](_0x5fd54c=>_0x5fd54c['battler']()[_0x3b9669(0xa19)]-_0x5fd54c['battler']()[_0x3b9669(0x3c2)]())),_0xb978ff=Math['max'](..._0x54673b['map'](_0x1dbc39=>_0x1dbc39['battler']()['_baseY'])),_0x2942cf=_0x54673b[_0x3b9669(0x5ed)](_0x317500=>_0x317500[_0x3b9669(0x8d6)]())[_0x3b9669(0x7ce)],_0x18673c=_0x54673b[_0x3b9669(0x5ed)](_0xd32477=>_0xd32477[_0x3b9669(0x5d1)]())[_0x3b9669(0x7ce)];let _0x7f8150=0x0,_0x38f31f=0x0;if(_0x1a6e22['match'](/front/i))_0x7f8150=_0x2942cf>=_0x18673c?_0xae4062:_0x4c5a48;else{if(_0x1a6e22[_0x3b9669(0xb9e)](/middle/i))_0x7f8150=(_0xae4062+_0x4c5a48)/0x2,melee=-0x1;else _0x1a6e22[_0x3b9669(0xb9e)](/back/i)&&(_0x7f8150=_0x2942cf>=_0x18673c?_0x4c5a48:_0xae4062);}if(_0x1a6e22[_0x3b9669(0xb9e)](/head/i))_0x38f31f=_0x158aeb;else{if(_0x1a6e22['match'](/center/i))_0x38f31f=(_0x158aeb+_0xb978ff)/0x2;else _0x1a6e22[_0x3b9669(0xb9e)](/base/i)&&(_0x38f31f=_0xb978ff);}_0x7f8150+=(Graphics[_0x3b9669(0x64b)]-Graphics[_0x3b9669(0x555)])/0x2,_0x38f31f+=(Graphics['height']-Graphics[_0x3b9669(0xab4)])/0x2,_0x7f8150+=_0x5a7567,_0x38f31f+=_0x133a4d,_0x231a48[_0x3b9669(0x751)](_0xf529b3,_0x7f8150,_0x38f31f,_0x548ce3,_0x39c7aa,_0x2bb7c1);}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x5f7),_0x214887=>{const _0x357711=_0x2dcaec;if(!Imported[_0x357711(0x277)])return;const _0x169ed2=SceneManager[_0x357711(0x496)]['_spriteset'];if(!_0x169ed2)return;if(VisuMZ[_0x357711(0x6f8)][_0x357711(0x620)]<=1.05){alert(_0x357711(0x44d)),SceneManager[_0x357711(0x33f)]();return;}VisuMZ[_0x357711(0x44f)](_0x214887,_0x214887);const _0x512a2e=VisuMZ['CreateActionSequenceTargets'](_0x214887[_0x357711(0xad6)]),_0x74a242={'filename':_0x214887[_0x357711(0x40d)],'horzCells':_0x214887[_0x357711(0xc03)]||0x1,'vertCells':_0x214887['vertCells']||0x1,'frameDelay':_0x214887[_0x357711(0x68f)]||0x1,'smooth':_0x214887[_0x357711(0xb61)]||![],'anchorX':_0x214887[_0x357711(0x647)]||0x0,'anchorY':_0x214887[_0x357711(0x962)]||0x0,'offsetX':_0x214887[_0x357711(0xab5)]||0x0,'offsetY':_0x214887['offsetY']||0x0};for(const _0x5c8319 of _0x512a2e){if(!_0x5c8319)continue;if(!_0x5c8319[_0x357711(0xbc2)]())continue;_0x5c8319['battler']()[_0x357711(0xa9b)](_0x74a242);}const _0x2c2ed8=$gameTemp[_0x357711(0x9c5)]();_0x2c2ed8&&_0x2c2ed8['setWaitMode'](_0x357711(0x397));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0xa7b),_0x550667=>{const _0x4f31b8=_0x2dcaec;if(!Imported[_0x4f31b8(0x277)])return;const _0x2d0767=SceneManager[_0x4f31b8(0x496)][_0x4f31b8(0x2a3)];if(!_0x2d0767)return;if(VisuMZ[_0x4f31b8(0x6f8)][_0x4f31b8(0x620)]<=1.05){alert(_0x4f31b8(0x44d)),SceneManager[_0x4f31b8(0x33f)]();return;}VisuMZ['ConvertParams'](_0x550667,_0x550667);const _0x1aeea7=VisuMZ[_0x4f31b8(0x77f)](_0x550667[_0x4f31b8(0xad6)]);for(const _0x54a2e0 of _0x1aeea7){if(!_0x54a2e0)continue;if(!_0x54a2e0[_0x4f31b8(0xbc2)]())continue;_0x54a2e0['battler']()[_0x4f31b8(0x8d0)]();}}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0xa2d),_0x17acd3=>{const _0x33c48a=_0x2dcaec;if(!Imported[_0x33c48a(0x277)])return;const _0x1474e6=SceneManager[_0x33c48a(0x496)][_0x33c48a(0x2a3)];if(!_0x1474e6)return;if(VisuMZ[_0x33c48a(0x6f8)]['version']<=1.05){alert(_0x33c48a(0x44d)),SceneManager[_0x33c48a(0x33f)]();return;}VisuMZ[_0x33c48a(0x44f)](_0x17acd3,_0x17acd3);const _0x4e8180=VisuMZ[_0x33c48a(0x77f)](_0x17acd3[_0x33c48a(0xad6)]),_0x491caf=_0x17acd3[_0x33c48a(0xc52)];for(const _0x9f767 of _0x4e8180){if(!_0x9f767)continue;if(!_0x9f767[_0x33c48a(0xbc2)]())continue;_0x9f767[_0x33c48a(0xbc2)]()[_0x33c48a(0xb49)](_0x491caf);}}),PluginManager['registerCommand'](pluginData['name'],_0x2dcaec(0x5b1),_0x5ccb27=>{const _0x3eadef=_0x2dcaec;if(!SceneManager[_0x3eadef(0xa2b)]())return;const _0xa11c5d=$gameTemp[_0x3eadef(0x9c5)]();if(!_0xa11c5d)return;_0xa11c5d[_0x3eadef(0x415)]('battleInjectAni');}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x72a),_0x41932c=>{const _0x5a39b4=_0x2dcaec;if(!SceneManager[_0x5a39b4(0xa2b)]())return;VisuMZ[_0x5a39b4(0x44f)](_0x41932c,_0x41932c);const _0x2d5144=$gameTemp['getLastPluginCommandInterpreter'](),_0x7da2b8=BattleManager[_0x5a39b4(0x151)],_0x1f2bf3=BattleManager['_subject'],_0x5ad3b2=BattleManager['_logWindow'];if(!_0x2d5144||!_0x7da2b8||!_0x1f2bf3)return;if(!_0x7da2b8[_0x5a39b4(0x719)]())return;const _0x17d1dd=VisuMZ[_0x5a39b4(0x77f)](_0x41932c[_0x5a39b4(0xad6)]);for(const _0x2ea6eb of _0x17d1dd){if(!_0x2ea6eb)continue;_0x5ad3b2[_0x5a39b4(0x190)]('actionEffect',_0x1f2bf3,_0x2ea6eb);}_0x2d5144['setWaitMode'](_0x5a39b4(0xbd0));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x165),_0x3cecaf=>{const _0x55150b=_0x2dcaec;if(!SceneManager[_0x55150b(0xa2b)]())return;if(!Imported[_0x55150b(0x622)])return;$gameTemp[_0x55150b(0xc7d)]=!![];}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x935),_0x3dd2c5=>{const _0x2a27b6=_0x2dcaec;if(!SceneManager[_0x2a27b6(0xa2b)]())return;VisuMZ[_0x2a27b6(0x44f)](_0x3dd2c5,_0x3dd2c5);const _0x453162=[_0x2a27b6(0x547),_0x2a27b6(0x4c5),_0x2a27b6(0x82f),_0x2a27b6(0xa0b),_0x2a27b6(0x34d),_0x2a27b6(0xb20),_0x2a27b6(0xa06),'LUK'],_0x167c68=_0x3dd2c5[_0x2a27b6(0xbf4)],_0x3ec8bd=_0x3dd2c5['Debuffs'],_0x9409f9=_0x3dd2c5[_0x2a27b6(0x37c)],_0x2b0b67=VisuMZ[_0x2a27b6(0x77f)](_0x3dd2c5[_0x2a27b6(0xad6)]);for(const _0x1cff49 of _0x2b0b67){if(!_0x1cff49)continue;for(const _0x38c0e3 of _0x167c68){const _0x3c76d2=_0x453162['indexOf'](_0x38c0e3['toUpperCase']()[_0x2a27b6(0x651)]());_0x3c76d2>=0x0&&_0x3c76d2<=0x7&&_0x1cff49[_0x2a27b6(0x3d2)](_0x3c76d2,_0x9409f9);}for(const _0x66d540 of _0x3ec8bd){const _0x1464bf=_0x453162[_0x2a27b6(0x7bc)](_0x66d540[_0x2a27b6(0xb9f)]()['trim']());_0x1464bf>=0x0&&_0x1464bf<=0x7&&_0x1cff49[_0x2a27b6(0x7a3)](_0x1464bf,_0x9409f9);}}}),PluginManager[_0x2dcaec(0x1a8)](pluginData['name'],_0x2dcaec(0xc02),_0xe87ed0=>{const _0x43390d=_0x2dcaec;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x43390d(0x44f)](_0xe87ed0,_0xe87ed0);const _0x4e7afa=_0xe87ed0[_0x43390d(0x403)],_0x6c5ae1=VisuMZ[_0x43390d(0x77f)](_0xe87ed0['Targets']);for(const _0x32b68a of _0x6c5ae1){if(!_0x32b68a)continue;for(const _0x1bd734 of _0x4e7afa){_0x32b68a[_0x43390d(0x846)](_0x1bd734);}}}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],'ActSeq_Mechanics_ArmorPenetration',_0x38d2f8=>{const _0x31f490=_0x2dcaec;if(!SceneManager[_0x31f490(0xa2b)]())return;VisuMZ[_0x31f490(0x44f)](_0x38d2f8,_0x38d2f8);const _0x5b19d7=BattleManager[_0x31f490(0x151)],_0x5796ab={'arPenRate':_0x38d2f8['ArPenRate'],'arPenFlat':_0x38d2f8[_0x31f490(0x4f8)],'arRedRate':_0x38d2f8[_0x31f490(0x71f)],'arRedFlat':_0x38d2f8[_0x31f490(0x447)]};_0x5b19d7[_0x31f490(0x48a)]=_0x5796ab;}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x9a5),_0x313984=>{const _0x1091bf=_0x2dcaec;if(!SceneManager[_0x1091bf(0xa2b)]())return;if(!Imported['VisuMZ_3_WeaknessDisplay'])return;VisuMZ[_0x1091bf(0x44f)](_0x313984,_0x313984);const _0x4451b3=VisuMZ[_0x1091bf(0x77f)](_0x313984[_0x1091bf(0xad6)]),_0x255908=_0x313984['Reveal']||0x1;for(const _0x16e2ab of _0x4451b3){if(!_0x16e2ab)continue;if(!_0x16e2ab['isEnemy']())continue;_0x16e2ab[_0x1091bf(0x499)](_0x255908);}}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0xb65),_0x940aa5=>{const _0x5e5ae9=_0x2dcaec;if(!SceneManager[_0x5e5ae9(0xa2b)]())return;if(!Imported[_0x5e5ae9(0x2a5)])return;if(!BattleManager[_0x5e5ae9(0xa4b)]())return;VisuMZ[_0x5e5ae9(0x44f)](_0x940aa5,_0x940aa5);const _0x67e865=VisuMZ[_0x5e5ae9(0x77f)](_0x940aa5[_0x5e5ae9(0xad6)]),_0x3b465f=_0x940aa5['ChargeRate'],_0x2c8e29=_0x940aa5[_0x5e5ae9(0x728)],_0x217bc7=_0x940aa5[_0x5e5ae9(0xbd5)];for(const _0x48b1fc of _0x67e865){if(!_0x48b1fc)continue;if(_0x48b1fc[_0x5e5ae9(0x9e6)]())_0x48b1fc['changeAtbChargeTime'](_0x3b465f);else{if(_0x48b1fc[_0x5e5ae9(0xb93)]()){_0x48b1fc[_0x5e5ae9(0x93e)](_0x2c8e29);if(_0x217bc7)_0x48b1fc[_0x5e5ae9(0x7f7)]();}}}}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],'ActSeq_Mechanics_BoostPointsChange',_0x97dc18=>{const _0xeda186=_0x2dcaec;if(!SceneManager[_0xeda186(0xa2b)]())return;if(!Imported['VisuMZ_3_BoostAction'])return;VisuMZ[_0xeda186(0x44f)](_0x97dc18,_0x97dc18);const _0x1e7df0=VisuMZ[_0xeda186(0x77f)](_0x97dc18[_0xeda186(0xad6)]),_0x354f35=_0x97dc18[_0xeda186(0xba1)];for(const _0x4af1c2 of _0x1e7df0){if(!_0x4af1c2)continue;_0x4af1c2[_0xeda186(0x90a)](_0x354f35);}}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x552),_0x5dfec3=>{const _0x2ce932=_0x2dcaec;if(!SceneManager['isSceneBattle']())return;if(!Imported['VisuMZ_3_BoostAction'])return;if(!BattleManager[_0x2ce932(0x173)])return;VisuMZ['ConvertParams'](_0x5dfec3,_0x5dfec3);const _0x11de0b=_0x5dfec3['VariableID'];$gameVariables[_0x2ce932(0xa8a)](_0x11de0b,BattleManager['_subject'][_0x2ce932(0x74a)]());}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x55d),_0x26964a=>{const _0x5564b2=_0x2dcaec;if(!SceneManager[_0x5564b2(0xa2b)]())return;if(!Imported[_0x5564b2(0x59c)])return;VisuMZ[_0x5564b2(0x44f)](_0x26964a,_0x26964a);const _0x3832d3=VisuMZ[_0x5564b2(0x77f)](_0x26964a[_0x5564b2(0xad6)]),_0x2190cb=_0x26964a['BreakShields'];for(const _0x22f566 of _0x3832d3){if(!_0x22f566)continue;if(_0x22f566['isBreakStunned']())continue;if(!_0x22f566['isAffectedByBreakShield']())continue;_0x22f566[_0x5564b2(0x4d9)](_0x2190cb);}}),PluginManager['registerCommand'](pluginData['name'],_0x2dcaec(0xc09),_0xffc21d=>{const _0xf127f8=_0x2dcaec;if(!SceneManager[_0xf127f8(0xa2b)]())return;if(!Imported[_0xf127f8(0x59c)])return;VisuMZ['ConvertParams'](_0xffc21d,_0xffc21d);const _0x4e1bd1=VisuMZ['CreateActionSequenceTargets'](_0xffc21d[_0xf127f8(0xad6)]);for(const _0x2b90d3 of _0x4e1bd1){if(!_0x2b90d3)continue;if(_0x2b90d3['isBreakStunned']())continue;if(!_0x2b90d3[_0xf127f8(0x575)]())continue;_0x2b90d3['resetBreakShield']();}}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x542),_0x2cba5e=>{const _0x4d9130=_0x2dcaec;if(!SceneManager[_0x4d9130(0xa2b)]())return;if(!Imported[_0x4d9130(0x611)])return;if(!BattleManager[_0x4d9130(0x336)]())return;VisuMZ[_0x4d9130(0x44f)](_0x2cba5e,_0x2cba5e);const _0xd77d4=VisuMZ[_0x4d9130(0x77f)](_0x2cba5e[_0x4d9130(0xad6)]),_0x32de6c=_0x2cba5e[_0x4d9130(0x43a)];for(const _0x5ee870 of _0xd77d4){if(!_0x5ee870)continue;_0x5ee870[_0x4d9130(0xa69)](_0x32de6c);}}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x25a),_0x5d9fa5=>{const _0x5f2851=_0x2dcaec;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x5f2851(0x44f)](_0x5d9fa5,_0x5d9fa5);const _0x47ac2f=$gameTemp[_0x5f2851(0x9c5)](),_0x367405=BattleManager[_0x5f2851(0x151)],_0x34b78f=BattleManager['_subject'];if(!_0x47ac2f||!_0x367405||!_0x34b78f)return;if(!_0x367405[_0x5f2851(0x719)]())return;const _0x22434d=VisuMZ[_0x5f2851(0x77f)](_0x5d9fa5[_0x5f2851(0xad6)]);for(const _0x5389bf of _0x22434d){if(!_0x5389bf)continue;_0x5d9fa5['ForceDeath']&&(_0x5389bf[_0x5f2851(0xb5e)](),_0x5389bf[_0x5f2851(0x846)](_0x5389bf[_0x5f2851(0x636)]())),_0x5389bf['isDeathStateAffected']()&&_0x5389bf[_0x5f2851(0x8b7)]();}_0x47ac2f[_0x5f2851(0x415)]('battleEffect');}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0xa7a),_0x36b344=>{const _0x30ca8f=_0x2dcaec;if(!SceneManager[_0x30ca8f(0xa2b)]())return;if(!Imported[_0x30ca8f(0xb0e)])return;if(!BattleManager[_0x30ca8f(0x6ec)]())return;VisuMZ[_0x30ca8f(0x44f)](_0x36b344,_0x36b344);const _0x3ffc11=VisuMZ['CreateActionSequenceTargets'](_0x36b344['Targets']),_0x16834e=_0x36b344[_0x30ca8f(0xabd)];for(const _0xd10af8 of _0x3ffc11){if(!_0xd10af8)continue;_0xd10af8[_0x30ca8f(0x9d3)](_0x16834e);}}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],'ActSeq_Mechanics_CtbSpeed',_0x22ced7=>{const _0x235573=_0x2dcaec;if(!SceneManager[_0x235573(0xa2b)]())return;if(!Imported[_0x235573(0xb0e)])return;if(!BattleManager[_0x235573(0x6ec)]())return;VisuMZ[_0x235573(0x44f)](_0x22ced7,_0x22ced7);const _0x24ee40=VisuMZ[_0x235573(0x77f)](_0x22ced7[_0x235573(0xad6)]),_0x54e91d=_0x22ced7['ChargeRate'],_0x4cd0ee=_0x22ced7[_0x235573(0x728)];for(const _0xaeaec5 of _0x24ee40){if(!_0xaeaec5)continue;if(_0xaeaec5[_0x235573(0x36b)]===_0x235573(0x4c6))_0xaeaec5[_0x235573(0x1da)](_0x54e91d);else _0xaeaec5[_0x235573(0x36b)]==='casting'&&_0xaeaec5['changeCtbCastTime'](_0x4cd0ee);}}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0xb77),_0x3063b2=>{const _0xeb0d1f=_0x2dcaec;if(!SceneManager['isSceneBattle']())return;VisuMZ['ConvertParams'](_0x3063b2,_0x3063b2);const _0x48be56=BattleManager['_action'];if(!_0x48be56)return;let _0x10b8ed=_0x3063b2[_0xeb0d1f(0x89f)];_0x48be56[_0xeb0d1f(0xa90)](_0x10b8ed);}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x1ce),_0x93d80=>{const _0xbeb31e=_0x2dcaec;if(!SceneManager[_0xbeb31e(0xa2b)]())return;VisuMZ[_0xbeb31e(0x44f)](_0x93d80,_0x93d80);const _0x4a87bc=VisuMZ[_0xbeb31e(0x77f)](_0x93d80[_0xbeb31e(0xad6)]);for(const _0x1db2ab of _0x4a87bc){if(!_0x1db2ab)continue;if(_0x1db2ab[_0xbeb31e(0x870)]())_0x1db2ab[_0xbeb31e(0x3a0)]();}}),PluginManager[_0x2dcaec(0x1a8)](pluginData['name'],_0x2dcaec(0x948),_0x42bc64=>{const _0x45c40c=_0x2dcaec;if(!SceneManager[_0x45c40c(0xa2b)]())return;VisuMZ['ConvertParams'](_0x42bc64,_0x42bc64);const _0x58cd33=$gameTemp[_0x45c40c(0x9c5)](),_0x181b36=BattleManager[_0x45c40c(0x173)],_0x3b7065=_0x42bc64['JumpToLabel'];if(!_0x58cd33)return;if(!_0x181b36)return;_0x181b36&&_0x181b36[_0x45c40c(0x1f5)]()&&_0x3b7065['toUpperCase']()[_0x45c40c(0x651)]()!=='UNTITLED'&&_0x58cd33['command119']([_0x3b7065]);}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],'ActSeq_Mechanics_EmulateAttackEffect',_0x3978e2=>{const _0x1a8b91=_0x2dcaec;if(!SceneManager[_0x1a8b91(0xa2b)]())return;VisuMZ[_0x1a8b91(0x44f)](_0x3978e2,_0x3978e2);const _0x26720e=$gameTemp[_0x1a8b91(0x9c5)](),_0x23f374=BattleManager['_logWindow'];if(!_0x26720e)return;const _0x198f06=VisuMZ['CreateActionSequenceTargets'](_0x3978e2[_0x1a8b91(0x42e)]),_0x5b2fe6=VisuMZ[_0x1a8b91(0x77f)](_0x3978e2[_0x1a8b91(0xad6)]);for(const _0x3c3fec of _0x198f06){for(const _0x448fd6 of _0x5b2fe6){if(!_0x448fd6)continue;const _0x3b3234=$dataSkills[_0x3c3fec[_0x1a8b91(0x435)]()];_0x23f374['push'](_0x1a8b91(0xb09),_0x3c3fec,_0x448fd6,_0x3b3234);}}_0x26720e['setWaitMode'](_0x1a8b91(0xbd0));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],'ActSeq_Mechanics_EmulateGuardEffect',_0x5037a2=>{const _0x2b966e=_0x2dcaec;if(!SceneManager[_0x2b966e(0xa2b)]())return;VisuMZ[_0x2b966e(0x44f)](_0x5037a2,_0x5037a2);const _0x25673b=$gameTemp[_0x2b966e(0x9c5)](),_0xcb24f1=BattleManager[_0x2b966e(0x9a7)];if(!_0x25673b)return;const _0x83643=VisuMZ[_0x2b966e(0x77f)](_0x5037a2['Users']),_0x5ac7cb=VisuMZ[_0x2b966e(0x77f)](_0x5037a2[_0x2b966e(0xad6)]);for(const _0x150285 of _0x83643){for(const _0x1dd7b4 of _0x5ac7cb){if(!_0x1dd7b4)continue;const _0x1bbef3=$dataSkills[_0x150285[_0x2b966e(0xc2c)]()];_0xcb24f1[_0x2b966e(0x190)](_0x2b966e(0xb09),_0x150285,_0x1dd7b4,_0x1bbef3);}}_0x25673b[_0x2b966e(0x415)](_0x2b966e(0xbd0));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x83d),_0x5d5cb7=>{const _0x33912f=_0x2dcaec;if(!SceneManager[_0x33912f(0xa2b)]())return;VisuMZ['ConvertParams'](_0x5d5cb7,_0x5d5cb7);const _0x3ca01d=$gameTemp['getLastPluginCommandInterpreter'](),_0x2bc921=BattleManager[_0x33912f(0x9a7)],_0x5d405d=Number(_0x5d5cb7[_0x33912f(0x3df)]||0x1),_0x1d9331=$dataItems[_0x5d405d];if(!_0x3ca01d)return;if(!_0x1d9331)return;const _0xb863e2=VisuMZ[_0x33912f(0x77f)](_0x5d5cb7['Users']),_0x1cbabc=VisuMZ[_0x33912f(0x77f)](_0x5d5cb7[_0x33912f(0xad6)]);for(const _0x5ed646 of _0xb863e2){for(const _0x12ab65 of _0x1cbabc){if(!_0x12ab65)continue;_0x2bc921[_0x33912f(0x190)](_0x33912f(0xb09),_0x5ed646,_0x12ab65,_0x1d9331);}}_0x3ca01d[_0x33912f(0x415)](_0x33912f(0xbd0));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0xbc8),_0x46c395=>{const _0x3d8db6=_0x2dcaec;if(!SceneManager[_0x3d8db6(0xa2b)]())return;VisuMZ['ConvertParams'](_0x46c395,_0x46c395);let _0xc6f035=Number(_0x46c395['SkillID']||0x0);if(_0xc6f035<=0x0){const _0x44fb7c=BattleManager[_0x3d8db6(0x151)];if(_0x44fb7c&&_0x44fb7c[_0x3d8db6(0x37d)]())_0xc6f035=_0x44fb7c[_0x3d8db6(0x719)]()['id'];else return;}const _0x9ebc34=$dataSkills[_0xc6f035];if(!_0x9ebc34)return;const _0x35bec7=VisuMZ['CreateActionSequenceTargets'](_0x46c395[_0x3d8db6(0x42e)]);for(const _0x5f5d7c of _0x35bec7){_0x5f5d7c[_0x3d8db6(0x96e)](_0x9ebc34);}}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0xc18),_0x12e48e=>{const _0x38a242=_0x2dcaec;if(!SceneManager[_0x38a242(0xa2b)]())return;VisuMZ[_0x38a242(0x44f)](_0x12e48e,_0x12e48e);const _0x234348=$gameTemp['getLastPluginCommandInterpreter'](),_0x1b37af=BattleManager[_0x38a242(0x9a7)],_0x2debf8=Number(_0x12e48e[_0x38a242(0xa0a)]||0x1),_0xff9198=$dataSkills[_0x2debf8];if(!_0x234348)return;if(!_0xff9198)return;const _0xbb9a83=VisuMZ[_0x38a242(0x77f)](_0x12e48e[_0x38a242(0x42e)]),_0x69c9d1=VisuMZ[_0x38a242(0x77f)](_0x12e48e['Targets']);for(const _0x76239e of _0xbb9a83){for(const _0x791af3 of _0x69c9d1){if(!_0x791af3)continue;_0x1b37af[_0x38a242(0x190)](_0x38a242(0xb09),_0x76239e,_0x791af3,_0xff9198);}}_0x234348[_0x38a242(0x415)](_0x38a242(0xbd0));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0xbe2),_0x183f92=>{const _0x43f7fe=_0x2dcaec;if(!SceneManager[_0x43f7fe(0xa2b)]())return;VisuMZ[_0x43f7fe(0x44f)](_0x183f92,_0x183f92);const _0x2b03ce=VisuMZ[_0x43f7fe(0x77f)](_0x183f92[_0x43f7fe(0xad6)]);for(const _0x15e195 of _0x2b03ce){if(!_0x15e195)continue;if(!_0x15e195[_0x43f7fe(0x5d1)]())continue;_0x15e195[_0x43f7fe(0x5b0)]();}}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x6c9),_0x29e5d4=>{const _0x39f912=_0x2dcaec;if(!SceneManager[_0x39f912(0xa2b)]())return;if(!Imported[_0x39f912(0x5a7)])return;if(!BattleManager[_0x39f912(0x356)]())return;VisuMZ[_0x39f912(0x44f)](_0x29e5d4,_0x29e5d4);const _0x2064f4=_0x29e5d4['ActionCount'];BattleManager[_0x39f912(0x173)]&&BattleManager[_0x39f912(0x173)]['friendsUnit']()[_0x39f912(0x2ec)](_0x2064f4);}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x7c5),_0xcb642b=>{const _0x14279c=_0x2dcaec;if(!SceneManager[_0x14279c(0xa2b)]())return;if(!Imported[_0x14279c(0x2fe)])return;if(!BattleManager[_0x14279c(0x80c)]())return;VisuMZ['ConvertParams'](_0xcb642b,_0xcb642b);const _0x5a09d9=_0xcb642b[_0x14279c(0xb9d)];BattleManager['_subject']&&BattleManager[_0x14279c(0x173)][_0x14279c(0x630)]()[_0x14279c(0x5ee)](_0x5a09d9);}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x80d),_0x102fac=>{const _0x3f59ad=_0x2dcaec;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x3f59ad(0x44f)](_0x102fac,_0x102fac);const _0x2d9754=VisuMZ[_0x3f59ad(0x77f)](_0x102fac['Targets']),_0x3d3d2b=_0x102fac[_0x3f59ad(0x9f7)],_0x118f53=_0x102fac[_0x3f59ad(0x872)],_0x2eb675=_0x102fac['MP_Rate'],_0x3270c3=_0x102fac[_0x3f59ad(0x6c4)],_0x500aef=_0x102fac[_0x3f59ad(0x6cf)],_0x54c5c6=_0x102fac['TP_Flat'],_0x19f4e8=_0x102fac[_0x3f59ad(0x8bb)];for(const _0x3f49e6 of _0x2d9754){if(!_0x3f49e6)continue;const _0x5377d5=_0x3f49e6[_0x3f59ad(0x2b5)](),_0x598ce5=Math[_0x3f59ad(0x976)](_0x3d3d2b*_0x3f49e6['mhp']+_0x118f53),_0x297fd3=Math[_0x3f59ad(0x976)](_0x2eb675*_0x3f49e6['mmp']+_0x3270c3),_0xab6e66=Math[_0x3f59ad(0x976)](_0x500aef*_0x3f49e6[_0x3f59ad(0x7e5)]()+_0x54c5c6);if(_0x598ce5!==0x0)_0x3f49e6[_0x3f59ad(0xc73)](_0x598ce5);if(_0x297fd3!==0x0)_0x3f49e6[_0x3f59ad(0x77c)](_0x297fd3);if(_0xab6e66!==0x0)_0x3f49e6['gainTp'](_0xab6e66);if(_0x19f4e8)_0x3f49e6[_0x3f59ad(0x3a0)]();_0x5377d5&&_0x3f49e6[_0x3f59ad(0x1f5)]()&&_0x3f49e6[_0x3f59ad(0x8b7)]();}}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],'ActSeq_Mechanics_Immortal',_0x29316e=>{const _0x44646c=_0x2dcaec;if(!SceneManager[_0x44646c(0xa2b)]())return;VisuMZ[_0x44646c(0x44f)](_0x29316e,_0x29316e);const _0x4c04c9=VisuMZ['CreateActionSequenceTargets'](_0x29316e[_0x44646c(0xad6)]);for(const _0x1ad77c of _0x4c04c9){if(!_0x1ad77c)continue;_0x1ad77c[_0x44646c(0x44c)](_0x29316e[_0x44646c(0x17b)]);}}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x71d),_0x11e277=>{const _0x536027=_0x2dcaec;if(!SceneManager[_0x536027(0xa2b)]())return;VisuMZ[_0x536027(0x44f)](_0x11e277,_0x11e277);const _0x472278=BattleManager[_0x536027(0x151)],_0x36d4d1={'criticalHitRate':_0x11e277['CriticalHitRate'],'criticalHitFlat':_0x11e277['CriticalHitFlat'],'criticalDmgRate':_0x11e277[_0x536027(0x6d6)],'criticalDmgFlat':_0x11e277[_0x536027(0x8ef)],'damageRate':_0x11e277['DamageRate'],'damageFlat':_0x11e277['DamageFlat'],'hitRate':_0x11e277[_0x536027(0x692)],'hitFlat':_0x11e277[_0x536027(0x633)]};_0x472278[_0x536027(0x865)]=_0x36d4d1;}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x813),_0x420a7d=>{const _0x4c8a9d=_0x2dcaec;if(!SceneManager[_0x4c8a9d(0xa2b)]())return;VisuMZ[_0x4c8a9d(0x44f)](_0x420a7d,_0x420a7d);const _0x239f99=_0x420a7d[_0x4c8a9d(0x7a6)];SceneManager[_0x4c8a9d(0x496)]['playOnceParallelInterpreter'](_0x239f99);}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x455),_0x32669e=>{const _0x33318a=_0x2dcaec;if(!SceneManager[_0x33318a(0xa2b)]())return;if(!Imported['VisuMZ_2_BattleSystemOTB'])return;if(!BattleManager['isOTB']())return;VisuMZ[_0x33318a(0x44f)](_0x32669e,_0x32669e);const _0x158ec0=VisuMZ['CreateActionSequenceTargets'](_0x32669e[_0x33318a(0xad6)]);for(const _0x36ff15 of _0x158ec0){if(!_0x36ff15)continue;let _0x25bc9e=_0x32669e[_0x33318a(0x62f)],_0x10b47f=_0x32669e[_0x33318a(0xadf)],_0x57cf2d=_0x32669e['FollowTurn'];BattleManager[_0x33318a(0x43e)][_0x33318a(0x7f2)](_0x36ff15)?_0x25bc9e+=_0x57cf2d:_0x10b47f+=_0x57cf2d,BattleManager['turnOrderChangeOTB'](_0x36ff15,-_0x25bc9e,![]),BattleManager[_0x33318a(0x63b)](_0x36ff15,-_0x10b47f,!![]);}}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x774),_0x4860eb=>{const _0x17c6f=_0x2dcaec;if(!SceneManager[_0x17c6f(0xa2b)]())return;if(!Imported['VisuMZ_2_BattleSystemPTB'])return;if(!BattleManager[_0x17c6f(0x776)]())return;VisuMZ[_0x17c6f(0x44f)](_0x4860eb,_0x4860eb);const _0x461750=BattleManager['_subject'][_0x17c6f(0x630)](),_0x37f8ec=_0x4860eb[_0x17c6f(0xb79)],_0x5f4fb6=_0x4860eb[_0x17c6f(0x737)]||_0x17c6f(0x362),_0x347108=_0x4860eb[_0x17c6f(0xa39)]||_0x17c6f(0x362),_0x1e907f=_0x4860eb[_0x17c6f(0x355)]||0x0,_0x27c678=_0x4860eb[_0x17c6f(0xc68)]||0x0;(_0x461750[_0x17c6f(0x1eb)]()||_0x37f8ec)&&(_0x37f8ec&&(_0x461750[_0x17c6f(0x6e1)]=_0x461750[_0x17c6f(0x6e1)]||{},_0x461750['_ptbActionCost'][_0x17c6f(0x50d)]=0x0),_0x461750[_0x17c6f(0x405)](_0x5f4fb6,_0x347108,_0x1e907f,_0x27c678));}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x157),_0x57b569=>{const _0x23ae0d=_0x2dcaec;if(!SceneManager[_0x23ae0d(0xa2b)]())return;if(!Imported[_0x23ae0d(0x358)])return;if(!BattleManager['isPTB']())return;VisuMZ[_0x23ae0d(0x44f)](_0x57b569,_0x57b569);const _0x4432be=BattleManager[_0x23ae0d(0x173)][_0x23ae0d(0x630)]();let _0x109668=Math['max'](_0x57b569[_0x23ae0d(0x472)],0x0),_0x4e5d36=_0x4432be['getFullActionsPTB'](),_0x49daef=_0x4432be['getHalfActionsPTB']();while(_0x109668--){if(_0x4e5d36<=0x0&&_0x49daef<=0x0)break;else _0x4e5d36>0x0?(_0x4e5d36--,_0x49daef++):_0x49daef--;}_0x4432be[_0x23ae0d(0xa93)](_0x4e5d36),_0x4432be['setHalfActionsPTB'](_0x49daef);}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x1de),_0xcb3b54=>{const _0x58fbe1=_0x2dcaec;if(!SceneManager[_0x58fbe1(0xa2b)]())return;if(!Imported[_0x58fbe1(0x358)])return;if(!BattleManager[_0x58fbe1(0x776)]())return;VisuMZ[_0x58fbe1(0x44f)](_0xcb3b54,_0xcb3b54);const _0x295ab7=BattleManager[_0x58fbe1(0x173)][_0x58fbe1(0x630)]();let _0x302596=_0xcb3b54[_0x58fbe1(0x9ed)],_0x52d2d3=_0xcb3b54[_0x58fbe1(0x344)];_0x295ab7['gainFullActionsPTB'](_0x302596),_0x295ab7['gainHalfActionsPTB'](_0x52d2d3);}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0xc28),_0x44a18c=>{const _0x56943d=_0x2dcaec;if(!SceneManager[_0x56943d(0xa2b)]())return;VisuMZ['ConvertParams'](_0x44a18c,_0x44a18c);const _0x187afb=[_0x56943d(0x547),_0x56943d(0x4c5),_0x56943d(0x82f),'DEF','MAT','MDF',_0x56943d(0xa06),'LUK'],_0x56d251=_0x44a18c['Buffs'],_0x1974c7=_0x44a18c[_0x56943d(0x484)],_0x1c2b1d=VisuMZ['CreateActionSequenceTargets'](_0x44a18c[_0x56943d(0xad6)]);for(const _0x544c5a of _0x1c2b1d){if(!_0x544c5a)continue;for(const _0x3a82f6 of _0x56d251){const _0x572e23=_0x187afb[_0x56943d(0x7bc)](_0x3a82f6[_0x56943d(0xb9f)]()[_0x56943d(0x651)]());_0x572e23>=0x0&&_0x572e23<=0x7&&_0x544c5a['isBuffAffected'](_0x572e23)&&_0x544c5a[_0x56943d(0x968)](_0x572e23);}for(const _0x1c6aaf of _0x1974c7){const _0x12bd1d=_0x187afb[_0x56943d(0x7bc)](_0x1c6aaf['toUpperCase']()[_0x56943d(0x651)]());_0x12bd1d>=0x0&&_0x12bd1d<=0x7&&_0x544c5a[_0x56943d(0x91a)](_0x12bd1d)&&_0x544c5a[_0x56943d(0x968)](_0x12bd1d);}}}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x84e),_0x29cbba=>{const _0x58bf89=_0x2dcaec;if(!SceneManager[_0x58bf89(0xa2b)]())return;VisuMZ[_0x58bf89(0x44f)](_0x29cbba,_0x29cbba);const _0x40a7c8=_0x29cbba[_0x58bf89(0x403)],_0x3ddc07=VisuMZ['CreateActionSequenceTargets'](_0x29cbba[_0x58bf89(0xad6)]);for(const _0x2554e0 of _0x3ddc07){if(!_0x2554e0)continue;for(const _0x584bd0 of _0x40a7c8){_0x2554e0[_0x58bf89(0x338)](_0x584bd0);}}}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],'ActSeq_Mechanics_StateTurnsChangeBy',_0x5c1b77=>{const _0x1b66e0=_0x2dcaec;if(!SceneManager[_0x1b66e0(0xa2b)]())return;if(!Imported['VisuMZ_1_SkillsStatesCore'])return;VisuMZ[_0x1b66e0(0x44f)](_0x5c1b77,_0x5c1b77);const _0x374be6=VisuMZ['CreateActionSequenceTargets'](_0x5c1b77[_0x1b66e0(0xad6)]),_0x22c309=Number(_0x5c1b77[_0x1b66e0(0xb94)]),_0x1979a2=Number(_0x5c1b77[_0x1b66e0(0x37c)]),_0x206f14=_0x5c1b77[_0x1b66e0(0x985)];for(const _0x3eacb7 of _0x374be6){if(!_0x3eacb7)continue;_0x206f14&&!_0x3eacb7['isStateAffected'](_0x22c309)?(_0x3eacb7[_0x1b66e0(0x846)](_0x22c309),_0x3eacb7['setStateTurns'](_0x22c309,_0x1979a2)):_0x3eacb7[_0x1b66e0(0xaa9)](_0x22c309,_0x1979a2);}}),PluginManager[_0x2dcaec(0x1a8)](pluginData['name'],_0x2dcaec(0x6a5),_0x529ff7=>{const _0x300108=_0x2dcaec;if(!SceneManager[_0x300108(0xa2b)]())return;if(!Imported[_0x300108(0xb3c)])return;VisuMZ['ConvertParams'](_0x529ff7,_0x529ff7);const _0xcb59e3=VisuMZ[_0x300108(0x77f)](_0x529ff7[_0x300108(0xad6)]),_0x3b28ec=Number(_0x529ff7[_0x300108(0xb94)]),_0x30cb7b=Math[_0x300108(0x959)](Number(_0x529ff7[_0x300108(0x37c)]),0x0),_0x3be4c2=_0x529ff7[_0x300108(0x985)];for(const _0x135fc6 of _0xcb59e3){if(!_0x135fc6)continue;_0x3be4c2&&!_0x135fc6[_0x300108(0x485)](_0x3b28ec)&&_0x135fc6[_0x300108(0x846)](_0x3b28ec),_0x135fc6[_0x300108(0xb8f)](_0x3b28ec,_0x30cb7b);}}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x8de),_0x4f4a6b=>{const _0x133e2e=_0x2dcaec;if(!SceneManager[_0x133e2e(0xa2b)]())return;if(!Imported[_0x133e2e(0xb16)])return;if(!BattleManager[_0x133e2e(0x502)]())return;VisuMZ[_0x133e2e(0x44f)](_0x4f4a6b,_0x4f4a6b);const _0x275c78=_0x4f4a6b[_0x133e2e(0x85b)],_0x576623=VisuMZ['CreateActionSequenceTargets'](_0x4f4a6b[_0x133e2e(0xad6)]),_0x4d6af8=_0x4f4a6b['ForceExploited'],_0x5854dd=_0x4f4a6b[_0x133e2e(0x9a4)],_0x56cbee=_0x4f4a6b[_0x133e2e(0xc60)],_0x25cea5=BattleManager[_0x133e2e(0x151)];if(_0x275c78)for(const _0x26be74 of _0x576623){if(!_0x26be74)continue;if(_0x26be74===BattleManager[_0x133e2e(0x173)])continue;if(_0x4d6af8)_0x26be74['setSTBExploited'](![]);_0x26be74[_0x133e2e(0x8d5)](BattleManager[_0x133e2e(0x173)],_0x25cea5);}if(_0x5854dd&&BattleManager[_0x133e2e(0x173)]){if(_0x56cbee)BattleManager[_0x133e2e(0x173)][_0x133e2e(0x834)](![]);const _0xe67468=_0x576623[0x0];BattleManager[_0x133e2e(0x173)][_0x133e2e(0x788)](_0xe67468,_0x25cea5);}}),PluginManager[_0x2dcaec(0x1a8)](pluginData['name'],_0x2dcaec(0x900),_0x1c96b0=>{const _0x52876a=_0x2dcaec;if(!SceneManager[_0x52876a(0xa2b)]())return;if(!Imported[_0x52876a(0xb16)])return;if(!BattleManager[_0x52876a(0x502)]())return;VisuMZ[_0x52876a(0x44f)](_0x1c96b0,_0x1c96b0);const _0x2c2a94=_0x1c96b0[_0x52876a(0x6ea)];BattleManager[_0x52876a(0x173)]&&BattleManager[_0x52876a(0x173)][_0x52876a(0x567)](_0x2c2a94);}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x787),_0x1848ff=>{const _0x202bcc=_0x2dcaec;if(!SceneManager[_0x202bcc(0xa2b)]())return;if(!Imported[_0x202bcc(0xb16)])return;if(!BattleManager['isSTB']())return;VisuMZ[_0x202bcc(0x44f)](_0x1848ff,_0x1848ff);let _0x57a6d0=_0x1848ff[_0x202bcc(0x6ea)];if(BattleManager[_0x202bcc(0x173)]){BattleManager[_0x202bcc(0x173)][_0x202bcc(0xaa2)]=BattleManager[_0x202bcc(0x173)][_0x202bcc(0xaa2)]||[];while(_0x57a6d0--){if(BattleManager[_0x202bcc(0x173)][_0x202bcc(0xaa2)][_0x202bcc(0x7ce)]<=0x0)break;BattleManager[_0x202bcc(0x173)][_0x202bcc(0xaa2)][_0x202bcc(0xa0f)]();}}}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0xbe5),_0x5675a1=>{const _0x2e0809=_0x2dcaec;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x2e0809(0x5a1)])return;VisuMZ[_0x2e0809(0x44f)](_0x5675a1,_0x5675a1);const _0x4fcc7c=VisuMZ[_0x2e0809(0x77f)](_0x5675a1[_0x2e0809(0xad6)]),_0x3de2ce=_0x5675a1[_0x2e0809(0xc3e)];for(const _0x4810cd of _0x4fcc7c){if(!_0x4810cd)continue;if(!_0x4810cd[_0x2e0809(0x8d6)]())continue;_0x4810cd[_0x2e0809(0xa44)](_0x3de2ce);}}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],'ActSeq_Mechanics_TextPopup',_0x50bcff=>{const _0x44e8e8=_0x2dcaec;if(!SceneManager[_0x44e8e8(0xa2b)]())return;VisuMZ[_0x44e8e8(0x44f)](_0x50bcff,_0x50bcff);const _0x168890=VisuMZ[_0x44e8e8(0x77f)](_0x50bcff['Targets']),_0x1e7fe6=_0x50bcff['Text'],_0x35be73={'textColor':ColorManager[_0x44e8e8(0x49e)](_0x50bcff[_0x44e8e8(0x5b4)]),'flashColor':_0x50bcff['FlashColor'],'flashDuration':_0x50bcff[_0x44e8e8(0x723)]};for(const _0x26d352 of _0x168890){if(!_0x26d352)continue;_0x26d352[_0x44e8e8(0x495)](_0x1e7fe6,_0x35be73);}}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0xaff),_0x54b007=>{const _0x4cc2b3=_0x2dcaec;if(!SceneManager[_0x4cc2b3(0xa2b)]())return;VisuMZ['ConvertParams'](_0x54b007,_0x54b007);const _0x5d824d=VisuMZ[_0x4cc2b3(0x77f)](_0x54b007['Targets']);let _0x2178db=$gameVariables[_0x4cc2b3(0x2df)](_0x54b007[_0x4cc2b3(0x20e)]);Imported[_0x4cc2b3(0x6d3)]&&_0x54b007['DigitGrouping']&&(_0x2178db=VisuMZ[_0x4cc2b3(0x86f)](_0x2178db));const _0x2c38e6=String(_0x2178db),_0x19bcbe={'textColor':ColorManager[_0x4cc2b3(0x49e)](_0x54b007[_0x4cc2b3(0x5b4)]),'flashColor':_0x54b007['FlashColor'],'flashDuration':_0x54b007['FlashDuration']};for(const _0x1b012c of _0x5d824d){if(!_0x1b012c)continue;_0x1b012c['setupTextPopup'](_0x2c38e6,_0x19bcbe);}}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x348),_0x3a42af=>{const _0x1f8f01=_0x2dcaec;if(!SceneManager[_0x1f8f01(0xa2b)]())return;const _0x41f8b4=$gameTemp[_0x1f8f01(0x9c5)]();if(!_0x41f8b4)return;_0x41f8b4[_0x1f8f01(0x415)](_0x1f8f01(0x2c1));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x22f),_0x1c1534=>{const _0xa092c9=_0x2dcaec;if(!SceneManager[_0xa092c9(0xa2b)]())return;VisuMZ[_0xa092c9(0x44f)](_0x1c1534,_0x1c1534);const _0x1956a9=VisuMZ[_0xa092c9(0x77f)](_0x1c1534[_0xa092c9(0xad6)]);for(const _0x400d95 of _0x1956a9){if(!_0x400d95)continue;_0x400d95[_0xa092c9(0x20d)]();}}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0xae1),_0xf98ded=>{const _0x3c3f10=_0x2dcaec;if(!SceneManager[_0x3c3f10(0xa2b)]())return;VisuMZ['ConvertParams'](_0xf98ded,_0xf98ded);const _0x4b1627=VisuMZ[_0x3c3f10(0x77f)](_0xf98ded[_0x3c3f10(0xad6)]),_0x550309=_0xf98ded[_0x3c3f10(0x212)]['toLowerCase']()['trim']();let _0x11eb9b=_0xf98ded[_0x3c3f10(0x406)];const _0x2b6501=_0xf98ded[_0x3c3f10(0x1ab)];![_0x3c3f10(0x75a),'thrust','swing',_0x3c3f10(0x17a)][_0x3c3f10(0x7f2)](_0x550309)&&(_0x11eb9b=![]);for(const _0xee11f0 of _0x4b1627){if(!_0xee11f0)continue;_0xee11f0[_0x3c3f10(0xafd)](_0x550309,_0x11eb9b,_0x2b6501);}}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],'ActSeq_Motion_MotionType',_0x965648=>{const _0x4c8ff8=_0x2dcaec;if(!SceneManager[_0x4c8ff8(0xa2b)]())return;VisuMZ['ConvertParams'](_0x965648,_0x965648);const _0x5e10ae=VisuMZ[_0x4c8ff8(0x77f)](_0x965648['Targets']),_0x265d5e=_0x965648[_0x4c8ff8(0x212)]['toLowerCase']()['trim'](),_0xab2071=_0x965648[_0x4c8ff8(0x406)];for(const _0x438d61 of _0x5e10ae){if(!_0x438d61)continue;_0x438d61['_showWeapon']=_0xab2071;if(_0x265d5e['match'](/ATTACK[ ](\d+)/i))_0x438d61[_0x4c8ff8(0x731)](Number(RegExp['$1']));else _0x265d5e===_0x4c8ff8(0x75a)?_0x438d61[_0x4c8ff8(0xa83)]():_0x438d61[_0x4c8ff8(0x4a5)](_0x265d5e);if(!_0xab2071)_0x438d61['startWeaponAnimation'](0x0);else{if(_0xab2071&&['thrust',_0x4c8ff8(0x5ea),_0x4c8ff8(0x369)][_0x4c8ff8(0x7f2)](_0x265d5e)){}}_0x438d61[_0x4c8ff8(0x560)]=undefined;}}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x276),_0x4f3c68=>{const _0x3e3e28=_0x2dcaec;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x3e3e28(0x44f)](_0x4f3c68,_0x4f3c68);const _0x48858f=BattleManager[_0x3e3e28(0x151)];if(!_0x48858f)return;if(!_0x48858f['item']())return;const _0x3b0011=VisuMZ['CreateActionSequenceTargets'](_0x4f3c68[_0x3e3e28(0xad6)]);for(const _0x1aff7c of _0x3b0011){if(!_0x1aff7c)continue;_0x1aff7c[_0x3e3e28(0x79c)](_0x48858f);}}),PluginManager[_0x2dcaec(0x1a8)](pluginData['name'],_0x2dcaec(0x764),_0x696e49=>{const _0xa48eab=_0x2dcaec;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0xa48eab(0x44f)](_0x696e49,_0x696e49);const _0x2d401d=VisuMZ[_0xa48eab(0x77f)](_0x696e49[_0xa48eab(0xad6)]);for(const _0x24515d of _0x2d401d){if(!_0x24515d)continue;if(!_0x24515d['battler']())continue;_0x24515d[_0xa48eab(0xbc2)]()[_0xa48eab(0x5a4)]();}}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0xb31),_0x5d6f1d=>{const _0x26a020=_0x2dcaec;if(!SceneManager[_0x26a020(0xa2b)]())return;VisuMZ[_0x26a020(0x44f)](_0x5d6f1d,_0x5d6f1d);const _0x362705=$gameTemp[_0x26a020(0x9c5)](),_0x4903f9=_0x5d6f1d[_0x26a020(0xc77)]*Sprite_Battler[_0x26a020(0x526)];_0x362705[_0x26a020(0x275)](_0x4903f9);}),PluginManager[_0x2dcaec(0x1a8)](pluginData['name'],_0x2dcaec(0x60a),_0x51b8f5=>{const _0x539188=_0x2dcaec;if(!SceneManager[_0x539188(0xa2b)]())return;VisuMZ[_0x539188(0x44f)](_0x51b8f5,_0x51b8f5);const _0xfb2975=$gameTemp['getLastPluginCommandInterpreter'](),_0x3055d0=BattleManager[_0x539188(0x151)];if(!_0xfb2975||!_0x3055d0)return;if(!_0x3055d0['item']())return;const _0x11114f=VisuMZ['CreateActionSequenceTargets'](_0x51b8f5[_0x539188(0xad6)]);for(const _0x5d6219 of _0x11114f){if(!_0x5d6219)continue;_0x5d6219[_0x539188(0x9fe)](_0x3055d0);}if(_0x51b8f5[_0x539188(0x372)])_0xfb2975[_0x539188(0x415)](_0x539188(0x1ee));}),PluginManager['registerCommand'](pluginData['name'],_0x2dcaec(0x71c),_0x1da674=>{const _0x581995=_0x2dcaec;if(!SceneManager[_0x581995(0xa2b)]())return;if(!$gameSystem[_0x581995(0x334)]())return;VisuMZ['ConvertParams'](_0x1da674,_0x1da674);const _0x69d532=$gameTemp[_0x581995(0x9c5)](),_0x38ca07=VisuMZ[_0x581995(0x77f)](_0x1da674[_0x581995(0xad6)]),_0x58d835=_0x1da674[_0x581995(0x4d8)],_0x2d25dc=_0x1da674[_0x581995(0x6ab)],_0x337019=_0x1da674[_0x581995(0xc66)],_0x545e38=_0x1da674[_0x581995(0x603)],_0x5cff79=_0x1da674['FaceDirection'],_0x3d4dd1=_0x1da674[_0x581995(0x9cf)],_0x2b80e4=_0x1da674[_0x581995(0x212)],_0x102f9c=_0x1da674[_0x581995(0x372)];if(!_0x69d532)return;for(const _0x2325cd of _0x38ca07){if(!_0x2325cd)continue;let _0x36893f=_0x2d25dc,_0x4972e6=_0x337019;if(_0x58d835[_0x581995(0xb9e)](/horz/i))_0x36893f*=_0x2325cd[_0x581995(0x8d6)]()?-0x1:0x1;if(_0x58d835['match'](/vert/i))_0x4972e6*=_0x2325cd[_0x581995(0x8d6)]()?-0x1:0x1;_0x2325cd[_0x581995(0x821)](_0x36893f,_0x4972e6,_0x545e38,_0x5cff79,_0x3d4dd1),_0x2325cd[_0x581995(0x4a5)](_0x2b80e4);}if(_0x102f9c)_0x69d532[_0x581995(0x415)](_0x581995(0x1ee));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],'ActSeq_Movement_HomeMoveToJsPoint',_0x473a3b=>{const _0x2a5794=_0x2dcaec;if(!SceneManager[_0x2a5794(0xa2b)]())return;if(!$gameSystem['isSideView']())return;VisuMZ[_0x2a5794(0x44f)](_0x473a3b,_0x473a3b);const _0x464944=$gameTemp[_0x2a5794(0x9c5)](),_0x26d899=VisuMZ['CreateActionSequenceTargets'](_0x473a3b[_0x2a5794(0xad6)]),_0x2e4605=_0x473a3b[_0x2a5794(0x25f)],_0x1db2fa=_0x473a3b['OffsetX'],_0x5ebf14=_0x473a3b[_0x2a5794(0x53d)],_0x538bcc=_0x473a3b[_0x2a5794(0x603)],_0x556698=_0x473a3b[_0x2a5794(0x375)],_0x167df4=_0x473a3b[_0x2a5794(0x9cf)],_0x8a27cf=_0x473a3b['MotionType'],_0x49f11a=_0x473a3b[_0x2a5794(0x372)];if(!_0x464944)return;for(const _0x18fa40 of _0x26d899){if(!_0x18fa40)continue;const _0x57624b=_0x473a3b[_0x2a5794(0x8ce)](_0x18fa40)||{'x':0x0,'y':0x0};let _0x3ed4b9=_0x57624b['x'],_0x2d3645=_0x57624b['y'];if(_0x2e4605[_0x2a5794(0xb9e)](/none/i))_0x3ed4b9+=_0x1db2fa,_0x2d3645+=_0x5ebf14;else{if(_0x2e4605['match'](/horz/i)&&_0x2e4605[_0x2a5794(0xb9e)](/vert/i))_0x3ed4b9+=_0x18fa40[_0x2a5794(0x8d6)]()?-_0x1db2fa:_0x1db2fa,_0x2d3645+=_0x18fa40[_0x2a5794(0x8d6)]()?-_0x5ebf14:_0x5ebf14;else{if(_0x2e4605[_0x2a5794(0xb9e)](/horz/i))_0x3ed4b9+=_0x18fa40[_0x2a5794(0x8d6)]()?-_0x1db2fa:_0x1db2fa,_0x2d3645+=_0x5ebf14;else _0x2e4605[_0x2a5794(0xb9e)](/vert/i)&&(_0x3ed4b9+=_0x1db2fa,_0x2d3645+=_0x18fa40[_0x2a5794(0x8d6)]()?-_0x5ebf14:_0x5ebf14);}}_0x18fa40[_0x2a5794(0x7dd)](_0x3ed4b9,_0x2d3645,_0x538bcc,_0x556698,_0x167df4,-0x1),_0x18fa40['requestMotion'](_0x8a27cf);}if(_0x49f11a)_0x464944[_0x2a5794(0x415)](_0x2a5794(0x1ee));}),PluginManager['registerCommand'](pluginData['name'],_0x2dcaec(0x669),_0x4cb2f0=>{const _0x42ce50=_0x2dcaec;if(!SceneManager['isSceneBattle']())return;if(!$gameSystem[_0x42ce50(0x334)]())return;VisuMZ[_0x42ce50(0x44f)](_0x4cb2f0,_0x4cb2f0);const _0x39b742=$gameTemp[_0x42ce50(0x9c5)](),_0x1c64cb=VisuMZ[_0x42ce50(0x77f)](_0x4cb2f0[_0x42ce50(0xad6)]),_0x1f50c0=_0x4cb2f0[_0x42ce50(0x3a1)],_0x453cea=_0x4cb2f0[_0x42ce50(0x25f)],_0x1476c2=_0x4cb2f0['OffsetX'],_0x12cee8=_0x4cb2f0[_0x42ce50(0x53d)],_0x42c27e=_0x4cb2f0[_0x42ce50(0x603)],_0x2979fd=_0x4cb2f0[_0x42ce50(0x375)],_0x20a024=_0x4cb2f0[_0x42ce50(0x9cf)],_0x9aeac6=_0x4cb2f0[_0x42ce50(0x212)],_0x59fe96=_0x4cb2f0[_0x42ce50(0x372)];if(!_0x39b742)return;for(const _0x5eab7b of _0x1c64cb){if(!_0x5eab7b)continue;let _0x2af205=_0x5eab7b[_0x42ce50(0xbc2)]()[_0x42ce50(0xae9)],_0x152cc9=_0x5eab7b[_0x42ce50(0xbc2)]()[_0x42ce50(0xa19)];if(_0x1f50c0['match'](/home/i))_0x2af205=_0x5eab7b[_0x42ce50(0xbc2)]()[_0x42ce50(0x5a6)],_0x152cc9=_0x5eab7b[_0x42ce50(0xbc2)]()['_homeY'];else{if(_0x1f50c0[_0x42ce50(0xb9e)](/center/i))_0x2af205=Graphics[_0x42ce50(0x555)]/0x2,_0x152cc9=Graphics[_0x42ce50(0xab4)]/0x2;else _0x1f50c0[_0x42ce50(0xb9e)](/point (\d+), (\d+)/i)&&(_0x2af205=Number(RegExp['$1']),_0x152cc9=Number(RegExp['$2']));}if(_0x453cea['match'](/none/i))_0x2af205+=_0x1476c2,_0x152cc9+=_0x12cee8;else{if(_0x453cea[_0x42ce50(0xb9e)](/horz/i)&&_0x453cea[_0x42ce50(0xb9e)](/vert/i))_0x2af205+=_0x5eab7b[_0x42ce50(0x8d6)]()?-_0x1476c2:_0x1476c2,_0x152cc9+=_0x5eab7b[_0x42ce50(0x8d6)]()?-_0x12cee8:_0x12cee8;else{if(_0x453cea['match'](/horz/i))_0x2af205+=_0x5eab7b[_0x42ce50(0x8d6)]()?-_0x1476c2:_0x1476c2,_0x152cc9+=_0x12cee8;else _0x453cea['match'](/vert/i)&&(_0x2af205+=_0x1476c2,_0x152cc9+=_0x5eab7b['isActor']()?-_0x12cee8:_0x12cee8);}}_0x5eab7b[_0x42ce50(0x7dd)](_0x2af205,_0x152cc9,_0x42c27e,_0x2979fd,_0x20a024,-0x1),_0x5eab7b[_0x42ce50(0x4a5)](_0x9aeac6);}if(_0x59fe96)_0x39b742[_0x42ce50(0x415)](_0x42ce50(0x1ee));}),PluginManager['registerCommand'](pluginData['name'],_0x2dcaec(0x87b),_0x23fba0=>{const _0x4ec7c3=_0x2dcaec;if(!SceneManager[_0x4ec7c3(0xa2b)]())return;if(!$gameSystem[_0x4ec7c3(0x334)]())return;VisuMZ[_0x4ec7c3(0x44f)](_0x23fba0,_0x23fba0);const _0x2edb10=$gameTemp[_0x4ec7c3(0x9c5)](),_0x34ae76=VisuMZ[_0x4ec7c3(0x77f)](_0x23fba0[_0x4ec7c3(0x81b)]),_0x38dc18=VisuMZ[_0x4ec7c3(0x77f)](_0x23fba0['Targets2']),_0x17c6cb=_0x23fba0[_0x4ec7c3(0x750)];let _0x556f9b=_0x23fba0[_0x4ec7c3(0x859)];const _0x534304=_0x23fba0[_0x4ec7c3(0x25f)],_0x5db2f8=_0x23fba0[_0x4ec7c3(0x842)],_0x1a8bea=_0x23fba0['OffsetY'],_0x37ca9b=_0x23fba0[_0x4ec7c3(0x603)],_0x721466=_0x23fba0[_0x4ec7c3(0x375)],_0x385379=_0x23fba0[_0x4ec7c3(0x9cf)],_0x2ec792=_0x23fba0[_0x4ec7c3(0x212)],_0x433bcd=_0x23fba0[_0x4ec7c3(0x372)],_0x1a5e0d=Math[_0x4ec7c3(0xaf1)](..._0x38dc18[_0x4ec7c3(0xc20)](_0x35f47e=>_0x35f47e[_0x4ec7c3(0xbc2)]()['_baseX']-_0x35f47e[_0x4ec7c3(0xbc2)]()[_0x4ec7c3(0x74d)]()/0x2)),_0x109887=Math['max'](..._0x38dc18['map'](_0x4e03e2=>_0x4e03e2[_0x4ec7c3(0xbc2)]()[_0x4ec7c3(0xae9)]+_0x4e03e2[_0x4ec7c3(0xbc2)]()['mainSpriteWidth']()/0x2)),_0x17d6f1=Math[_0x4ec7c3(0xaf1)](..._0x38dc18['map'](_0x1baac4=>_0x1baac4[_0x4ec7c3(0xbc2)]()[_0x4ec7c3(0xa19)]-_0x1baac4[_0x4ec7c3(0xbc2)]()[_0x4ec7c3(0x3c2)]())),_0x3e98f1=Math[_0x4ec7c3(0x959)](..._0x38dc18[_0x4ec7c3(0xc20)](_0xd2d8ea=>_0xd2d8ea[_0x4ec7c3(0xbc2)]()[_0x4ec7c3(0xa19)])),_0x3b1dec=_0x38dc18[_0x4ec7c3(0x5ed)](_0x415967=>_0x415967[_0x4ec7c3(0x8d6)]())['length'],_0x8fe62f=_0x38dc18[_0x4ec7c3(0x5ed)](_0x41957c=>_0x41957c['isEnemy']())[_0x4ec7c3(0x7ce)];let _0x4b1786=0x0,_0x3f7d14=0x0;if(_0x17c6cb['match'](/front/i))_0x4b1786=_0x3b1dec>=_0x8fe62f?_0x1a5e0d:_0x109887;else{if(_0x17c6cb[_0x4ec7c3(0xb9e)](/middle/i))_0x4b1786=(_0x1a5e0d+_0x109887)/0x2,_0x556f9b=-0x1;else _0x17c6cb[_0x4ec7c3(0xb9e)](/back/i)&&(_0x4b1786=_0x3b1dec>=_0x8fe62f?_0x109887:_0x1a5e0d);}if(_0x17c6cb[_0x4ec7c3(0xb9e)](/head/i))_0x3f7d14=_0x17d6f1;else{if(_0x17c6cb['match'](/center/i))_0x3f7d14=(_0x17d6f1+_0x3e98f1)/0x2;else _0x17c6cb[_0x4ec7c3(0xb9e)](/base/i)&&(_0x3f7d14=_0x3e98f1);}if(!_0x2edb10)return;for(const _0x19ef72 of _0x34ae76){if(!_0x19ef72)continue;let _0x1d7c23=_0x4b1786,_0x2e2b13=_0x3f7d14;if(_0x534304[_0x4ec7c3(0xb9e)](/none/i))_0x1d7c23+=_0x5db2f8,_0x2e2b13+=_0x1a8bea;else{if(_0x534304[_0x4ec7c3(0xb9e)](/horz/i)&&_0x534304['match'](/vert/i))_0x1d7c23+=_0x19ef72[_0x4ec7c3(0x8d6)]()?-_0x5db2f8:_0x5db2f8,_0x2e2b13+=_0x19ef72[_0x4ec7c3(0x8d6)]()?-_0x1a8bea:_0x1a8bea;else{if(_0x534304['match'](/horz/i))_0x1d7c23+=_0x19ef72['isActor']()?-_0x5db2f8:_0x5db2f8,_0x2e2b13+=_0x1a8bea;else _0x534304[_0x4ec7c3(0xb9e)](/vert/i)&&(_0x1d7c23+=_0x5db2f8,_0x2e2b13+=_0x19ef72[_0x4ec7c3(0x8d6)]()?-_0x1a8bea:_0x1a8bea);}}_0x19ef72[_0x4ec7c3(0x7dd)](_0x1d7c23,_0x2e2b13,_0x37ca9b,_0x721466,_0x385379,_0x556f9b),_0x19ef72[_0x4ec7c3(0x4a5)](_0x2ec792);}if(_0x433bcd)_0x2edb10[_0x4ec7c3(0x415)](_0x4ec7c3(0x1ee));}),PluginManager['registerCommand'](pluginData['name'],_0x2dcaec(0xa29),_0xc5525b=>{const _0x144941=_0x2dcaec;if(!SceneManager[_0x144941(0xa2b)]())return;if(!$gameSystem[_0x144941(0x334)]())return;VisuMZ[_0x144941(0x44f)](_0xc5525b,_0xc5525b);const _0x13d4fb=VisuMZ[_0x144941(0x77f)](_0xc5525b[_0x144941(0xad6)]);let _0x41db0b=_0xc5525b[_0x144941(0x5f3)][_0x144941(0xb9e)](/back/i);for(const _0x493f2d of _0x13d4fb){if(!_0x493f2d)continue;if(_0xc5525b[_0x144941(0x5f3)]['match'](/rand/i))_0x41db0b=Math[_0x144941(0xb44)](0x2);_0x493f2d[_0x144941(0x5bd)](!!_0x41db0b);}}),PluginManager[_0x2dcaec(0x1a8)](pluginData['name'],_0x2dcaec(0x1e2),_0x5a4db4=>{const _0x451af5=_0x2dcaec;if(!SceneManager[_0x451af5(0xa2b)]())return;if(!$gameSystem[_0x451af5(0x334)]())return;VisuMZ[_0x451af5(0x44f)](_0x5a4db4,_0x5a4db4);const _0x2e587d=VisuMZ[_0x451af5(0x77f)](_0x5a4db4[_0x451af5(0xad6)]),_0x13fdde=_0x5a4db4[_0x451af5(0x93f)];for(const _0x505ebb of _0x2e587d){if(!_0x505ebb)continue;const _0x5784f4=_0x5a4db4[_0x451af5(0x96b)](_0x505ebb)||{'x':0x0,'y':0x0};let _0x46076a=_0x5784f4['x'],_0x33c157=_0x5784f4['y'];_0x505ebb[_0x451af5(0xb0b)](Math[_0x451af5(0x976)](_0x46076a),Math[_0x451af5(0x976)](_0x33c157),!!_0x13fdde);}}),PluginManager[_0x2dcaec(0x1a8)](pluginData['name'],_0x2dcaec(0x46c),_0x2e0204=>{const _0x437577=_0x2dcaec;if(!SceneManager['isSceneBattle']())return;if(!$gameSystem[_0x437577(0x334)]())return;VisuMZ[_0x437577(0x44f)](_0x2e0204,_0x2e0204);const _0x58fa0a=VisuMZ['CreateActionSequenceTargets'](_0x2e0204[_0x437577(0xad6)]);let _0x1a39b4=_0x2e0204[_0x437577(0x3ea)];const _0xb13213=_0x2e0204['FaceAway'];for(const _0x11d785 of _0x58fa0a){if(!_0x11d785)continue;let _0x51042c=_0x11d785['battler']()[_0x437577(0xae9)],_0x991baf=_0x11d785[_0x437577(0xbc2)]()[_0x437577(0xa19)];if(_0x1a39b4['match'](/home/i))_0x51042c=_0x11d785[_0x437577(0xbc2)]()['_homeX'],_0x991baf=_0x11d785['battler']()[_0x437577(0x94d)];else{if(_0x1a39b4['match'](/center/i))_0x51042c=Graphics[_0x437577(0x555)]/0x2,_0x991baf=Graphics[_0x437577(0xab4)]/0x2;else _0x1a39b4[_0x437577(0xb9e)](/point (\d+), (\d+)/i)&&(_0x51042c=Number(RegExp['$1']),_0x991baf=Number(RegExp['$2']));}_0x11d785[_0x437577(0xb0b)](Math[_0x437577(0x976)](_0x51042c),Math['round'](_0x991baf),!!_0xb13213);}}),PluginManager[_0x2dcaec(0x1a8)](pluginData['name'],'ActSeq_Movement_FaceTarget',_0x18c382=>{const _0x758496=_0x2dcaec;if(!SceneManager['isSceneBattle']())return;if(!$gameSystem[_0x758496(0x334)]())return;VisuMZ[_0x758496(0x44f)](_0x18c382,_0x18c382);const _0x531695=VisuMZ[_0x758496(0x77f)](_0x18c382[_0x758496(0x81b)]),_0x3d1c41=VisuMZ[_0x758496(0x77f)](_0x18c382[_0x758496(0x883)]),_0x19c472=_0x3d1c41[_0x758496(0xc20)](_0x56d31a=>_0x56d31a&&_0x56d31a[_0x758496(0xbc2)]()?_0x56d31a['battler']()[_0x758496(0xae9)]:0x0)/(_0x3d1c41[_0x758496(0x7ce)]||0x1),_0x3f8dc9=_0x3d1c41[_0x758496(0xc20)](_0x4607bb=>_0x4607bb&&_0x4607bb[_0x758496(0xbc2)]()?_0x4607bb[_0x758496(0xbc2)]()[_0x758496(0xa19)]:0x0)/(_0x3d1c41['length']||0x1),_0x29c489=_0x18c382[_0x758496(0x93f)];for(const _0x5d99b7 of _0x531695){if(!_0x5d99b7)continue;_0x5d99b7['setBattlerFacePoint'](Math['round'](_0x19c472),Math[_0x758496(0x976)](_0x3f8dc9),!!_0x29c489);}}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0xa67),_0x1543f4=>{const _0x3f290f=_0x2dcaec;if(!SceneManager[_0x3f290f(0xa2b)]())return;VisuMZ['ConvertParams'](_0x1543f4,_0x1543f4);const _0x23148e=$gameTemp[_0x3f290f(0x9c5)](),_0xb8952b=VisuMZ[_0x3f290f(0x77f)](_0x1543f4[_0x3f290f(0xad6)]),_0x32029b=_0x1543f4[_0x3f290f(0x364)],_0x34bb7b=_0x1543f4['Duration'],_0x382e3d=_0x1543f4[_0x3f290f(0x9cf)],_0x57af79=_0x1543f4[_0x3f290f(0x530)];if(!_0x23148e)return;for(const _0x22f177 of _0xb8952b){if(!_0x22f177)continue;_0x22f177['floatBattler'](_0x32029b,_0x34bb7b,_0x382e3d);}if(_0x57af79)_0x23148e[_0x3f290f(0x415)]('battleFloat');}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x607),_0x3f7ead=>{const _0x55b1b7=_0x2dcaec;if(!SceneManager['isSceneBattle']())return;VisuMZ['ConvertParams'](_0x3f7ead,_0x3f7ead);const _0x11a43b=$gameTemp['getLastPluginCommandInterpreter']();if(!_0x11a43b)return;const _0x1d4cc2=VisuMZ[_0x55b1b7(0x77f)](_0x3f7ead[_0x55b1b7(0xad6)]);for(const _0x380bcc of _0x1d4cc2){if(!_0x380bcc)continue;_0x380bcc['performActionEndMembers']();}BattleManager['_subject']&&BattleManager[_0x55b1b7(0x173)]['performActionEnd']();if(_0x3f7ead[_0x55b1b7(0x372)])_0x11a43b[_0x55b1b7(0x415)]('battleMove');}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x8ca),_0x1168e6=>{const _0x55ce06=_0x2dcaec;if(!SceneManager[_0x55ce06(0xa2b)]())return;VisuMZ[_0x55ce06(0x44f)](_0x1168e6,_0x1168e6);const _0x2b4e5c=$gameTemp[_0x55ce06(0x9c5)](),_0x188e42=VisuMZ[_0x55ce06(0x77f)](_0x1168e6[_0x55ce06(0xad6)]),_0x40aabe=_0x1168e6['Height'],_0x56419e=_0x1168e6[_0x55ce06(0x603)],_0x41c0d0=_0x1168e6[_0x55ce06(0x23c)];if(!_0x2b4e5c)return;for(const _0x2b893b of _0x188e42){if(!_0x2b893b)continue;_0x2b893b['jumpBattler'](_0x40aabe,_0x56419e);}if(_0x41c0d0)_0x2b4e5c['setWaitMode'](_0x55ce06(0x418));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x9bd),_0x36b85a=>{const _0x121123=_0x2dcaec;if(!SceneManager['isSceneBattle']())return;if(!$gameSystem['isSideView']())return;VisuMZ[_0x121123(0x44f)](_0x36b85a,_0x36b85a);const _0x33581a=$gameTemp[_0x121123(0x9c5)](),_0x2d8a35=VisuMZ[_0x121123(0x77f)](_0x36b85a['Targets']),_0x348a61=_0x36b85a[_0x121123(0x4d8)],_0x5627da=_0x36b85a['DistanceX'],_0x439dc6=_0x36b85a['DistanceY'],_0x4254c1=_0x36b85a[_0x121123(0x603)],_0x4d2e65=_0x36b85a[_0x121123(0x375)],_0x1ee841=_0x36b85a[_0x121123(0x9cf)],_0x228985=_0x36b85a[_0x121123(0x212)],_0x485187=_0x36b85a[_0x121123(0x372)];if(!_0x33581a)return;for(const _0x42b53d of _0x2d8a35){if(!_0x42b53d)continue;let _0x1e1bab=_0x5627da,_0x1ea1eb=_0x439dc6;if(_0x348a61[_0x121123(0xb9e)](/horz/i))_0x1e1bab*=_0x42b53d['isActor']()?-0x1:0x1;if(_0x348a61[_0x121123(0xb9e)](/vert/i))_0x1ea1eb*=_0x42b53d[_0x121123(0x8d6)]()?-0x1:0x1;_0x42b53d[_0x121123(0x39e)](_0x1e1bab,_0x1ea1eb,_0x4254c1,_0x4d2e65,_0x1ee841),_0x42b53d['requestMotion'](_0x228985);}if(_0x485187)_0x33581a['setWaitMode']('battleMove');}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x442),_0x9673ca=>{const _0x599c3d=_0x2dcaec;if(!SceneManager['isSceneBattle']())return;if(!$gameSystem[_0x599c3d(0x334)]())return;VisuMZ[_0x599c3d(0x44f)](_0x9673ca,_0x9673ca);const _0x181bc1=$gameTemp[_0x599c3d(0x9c5)](),_0x25a13c=VisuMZ[_0x599c3d(0x77f)](_0x9673ca[_0x599c3d(0xad6)]),_0x287be3=_0x9673ca['OffsetAdjust'],_0x3d40ba=_0x9673ca['OffsetX'],_0x5c4f73=_0x9673ca['OffsetY'],_0x3246b2=_0x9673ca[_0x599c3d(0x603)],_0x4fa7b9=_0x9673ca['FaceDirection'],_0x1bee78=_0x9673ca['EasingType'],_0x56077c=_0x9673ca['MotionType'],_0x507f5a=_0x9673ca['WaitForMovement'];if(!_0x181bc1)return;for(const _0x4aa1a5 of _0x25a13c){if(!_0x4aa1a5)continue;const _0x5b570e=_0x9673ca[_0x599c3d(0x8ce)](_0x4aa1a5)||{'x':0x0,'y':0x0};let _0x2d1b8b=_0x5b570e['x'],_0x234c3=_0x5b570e['y'];if(_0x287be3[_0x599c3d(0xb9e)](/none/i))_0x2d1b8b+=_0x3d40ba,_0x234c3+=_0x5c4f73;else{if(_0x287be3[_0x599c3d(0xb9e)](/horz/i)&&_0x287be3['match'](/vert/i))_0x2d1b8b+=_0x4aa1a5[_0x599c3d(0x8d6)]()?-_0x3d40ba:_0x3d40ba,_0x234c3+=_0x4aa1a5['isActor']()?-_0x5c4f73:_0x5c4f73;else{if(_0x287be3[_0x599c3d(0xb9e)](/horz/i))_0x2d1b8b+=_0x4aa1a5[_0x599c3d(0x8d6)]()?-_0x3d40ba:_0x3d40ba,_0x234c3+=_0x5c4f73;else _0x287be3['match'](/vert/i)&&(_0x2d1b8b+=_0x3d40ba,_0x234c3+=_0x4aa1a5['isActor']()?-_0x5c4f73:_0x5c4f73);}}_0x4aa1a5[_0x599c3d(0x241)](_0x2d1b8b,_0x234c3,_0x3246b2,_0x4fa7b9,_0x1bee78,-0x1),_0x4aa1a5['requestMotion'](_0x56077c);}if(_0x507f5a)_0x181bc1[_0x599c3d(0x415)](_0x599c3d(0x1ee));}),PluginManager[_0x2dcaec(0x1a8)](pluginData['name'],_0x2dcaec(0x64d),_0x72003e=>{const _0x24ea5b=_0x2dcaec;if(!SceneManager['isSceneBattle']())return;if(!$gameSystem[_0x24ea5b(0x334)]())return;VisuMZ[_0x24ea5b(0x44f)](_0x72003e,_0x72003e);const _0x35e91e=$gameTemp[_0x24ea5b(0x9c5)](),_0x5b7915=VisuMZ[_0x24ea5b(0x77f)](_0x72003e[_0x24ea5b(0xad6)]),_0x175939=_0x72003e[_0x24ea5b(0x3a1)],_0x54b521=_0x72003e[_0x24ea5b(0x25f)],_0x2eecbd=_0x72003e[_0x24ea5b(0x842)],_0x205f82=_0x72003e[_0x24ea5b(0x53d)],_0x19df0c=_0x72003e['Duration'],_0x4d5ca4=_0x72003e[_0x24ea5b(0x375)],_0x394d7e=_0x72003e[_0x24ea5b(0x9cf)],_0x155699=_0x72003e[_0x24ea5b(0x212)],_0x910d3=_0x72003e['WaitForMovement'];if(!_0x35e91e)return;for(const _0x548adb of _0x5b7915){if(!_0x548adb)continue;let _0x10f428=_0x548adb[_0x24ea5b(0xbc2)]()[_0x24ea5b(0xae9)],_0x3838e9=_0x548adb['battler']()[_0x24ea5b(0xa19)];if(_0x175939[_0x24ea5b(0xb9e)](/home/i))_0x10f428=_0x548adb['battler']()[_0x24ea5b(0x5a6)],_0x3838e9=_0x548adb[_0x24ea5b(0xbc2)]()[_0x24ea5b(0x94d)];else{if(_0x175939['match'](/center/i))_0x10f428=Graphics['boxWidth']/0x2,_0x3838e9=Graphics[_0x24ea5b(0xab4)]/0x2;else _0x175939[_0x24ea5b(0xb9e)](/point (\d+), (\d+)/i)&&(_0x10f428=Number(RegExp['$1']),_0x3838e9=Number(RegExp['$2']));}if(_0x54b521[_0x24ea5b(0xb9e)](/none/i))_0x10f428+=_0x2eecbd,_0x3838e9+=_0x205f82;else{if(_0x54b521[_0x24ea5b(0xb9e)](/horz/i)&&_0x54b521[_0x24ea5b(0xb9e)](/vert/i))_0x10f428+=_0x548adb[_0x24ea5b(0x8d6)]()?-_0x2eecbd:_0x2eecbd,_0x3838e9+=_0x548adb[_0x24ea5b(0x8d6)]()?-_0x205f82:_0x205f82;else{if(_0x54b521[_0x24ea5b(0xb9e)](/horz/i))_0x10f428+=_0x548adb[_0x24ea5b(0x8d6)]()?-_0x2eecbd:_0x2eecbd,_0x3838e9+=_0x205f82;else _0x54b521['match'](/vert/i)&&(_0x10f428+=_0x2eecbd,_0x3838e9+=_0x548adb['isActor']()?-_0x205f82:_0x205f82);}}_0x548adb[_0x24ea5b(0x241)](_0x10f428,_0x3838e9,_0x19df0c,_0x4d5ca4,_0x394d7e,-0x1),_0x548adb[_0x24ea5b(0x4a5)](_0x155699);}if(_0x910d3)_0x35e91e[_0x24ea5b(0x415)](_0x24ea5b(0x1ee));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x70e),_0x17b11e=>{const _0x4c99e8=_0x2dcaec;if(!SceneManager[_0x4c99e8(0xa2b)]())return;if(!$gameSystem[_0x4c99e8(0x334)]())return;VisuMZ[_0x4c99e8(0x44f)](_0x17b11e,_0x17b11e);const _0xe45de=$gameTemp['getLastPluginCommandInterpreter'](),_0x4905dc=VisuMZ[_0x4c99e8(0x77f)](_0x17b11e['Targets1']),_0x5c1265=VisuMZ[_0x4c99e8(0x77f)](_0x17b11e['Targets2']),_0x2bc661=_0x17b11e['TargetLocation'];let _0x58b224=_0x17b11e[_0x4c99e8(0x859)];const _0x544363=_0x17b11e[_0x4c99e8(0x25f)],_0x38781f=_0x17b11e[_0x4c99e8(0x842)],_0x4dde77=_0x17b11e['OffsetY'],_0x33fe19=_0x17b11e[_0x4c99e8(0x603)],_0x3d93dd=_0x17b11e[_0x4c99e8(0x375)],_0x297e2e=_0x17b11e[_0x4c99e8(0x9cf)],_0x416174=_0x17b11e[_0x4c99e8(0x212)],_0x4d53a7=_0x17b11e[_0x4c99e8(0x372)],_0x127bb6=Math[_0x4c99e8(0xaf1)](..._0x5c1265[_0x4c99e8(0xc20)](_0x56bc53=>_0x56bc53[_0x4c99e8(0xbc2)]()[_0x4c99e8(0xae9)]-_0x56bc53['battler']()[_0x4c99e8(0x74d)]()/0x2)),_0x354172=Math[_0x4c99e8(0x959)](..._0x5c1265[_0x4c99e8(0xc20)](_0x5c7ff2=>_0x5c7ff2[_0x4c99e8(0xbc2)]()[_0x4c99e8(0xae9)]+_0x5c7ff2[_0x4c99e8(0xbc2)]()[_0x4c99e8(0x74d)]()/0x2)),_0x3c12da=Math[_0x4c99e8(0xaf1)](..._0x5c1265['map'](_0x30fb8d=>_0x30fb8d['battler']()[_0x4c99e8(0xa19)]-_0x30fb8d[_0x4c99e8(0xbc2)]()[_0x4c99e8(0x3c2)]())),_0x5d3861=Math[_0x4c99e8(0x959)](..._0x5c1265[_0x4c99e8(0xc20)](_0x50d2a1=>_0x50d2a1[_0x4c99e8(0xbc2)]()[_0x4c99e8(0xa19)])),_0xf38525=_0x5c1265[_0x4c99e8(0x5ed)](_0x17985f=>_0x17985f[_0x4c99e8(0x8d6)]())['length'],_0x5b4172=_0x5c1265[_0x4c99e8(0x5ed)](_0x48b103=>_0x48b103[_0x4c99e8(0x5d1)]())[_0x4c99e8(0x7ce)];let _0x50e1a8=0x0,_0x5db03e=0x0;if(_0x2bc661[_0x4c99e8(0xb9e)](/front/i))_0x50e1a8=_0xf38525>=_0x5b4172?_0x127bb6:_0x354172;else{if(_0x2bc661[_0x4c99e8(0xb9e)](/middle/i))_0x50e1a8=(_0x127bb6+_0x354172)/0x2,_0x58b224=-0x1;else _0x2bc661[_0x4c99e8(0xb9e)](/back/i)&&(_0x50e1a8=_0xf38525>=_0x5b4172?_0x354172:_0x127bb6);}if(_0x2bc661[_0x4c99e8(0xb9e)](/head/i))_0x5db03e=_0x3c12da;else{if(_0x2bc661['match'](/center/i))_0x5db03e=(_0x3c12da+_0x5d3861)/0x2;else _0x2bc661[_0x4c99e8(0xb9e)](/base/i)&&(_0x5db03e=_0x5d3861);}if(!_0xe45de)return;for(const _0x4806c7 of _0x4905dc){if(!_0x4806c7)continue;let _0x28bd7d=_0x50e1a8,_0x6449e1=_0x5db03e;if(_0x544363[_0x4c99e8(0xb9e)](/none/i))_0x28bd7d+=_0x38781f,_0x6449e1+=_0x4dde77;else{if(_0x544363['match'](/horz/i)&&_0x544363[_0x4c99e8(0xb9e)](/vert/i))_0x28bd7d+=_0x4806c7[_0x4c99e8(0x8d6)]()?-_0x38781f:_0x38781f,_0x6449e1+=_0x4806c7['isActor']()?-_0x4dde77:_0x4dde77;else{if(_0x544363['match'](/horz/i))_0x28bd7d+=_0x4806c7[_0x4c99e8(0x8d6)]()?-_0x38781f:_0x38781f,_0x6449e1+=_0x4dde77;else _0x544363['match'](/vert/i)&&(_0x28bd7d+=_0x38781f,_0x6449e1+=_0x4806c7[_0x4c99e8(0x8d6)]()?-_0x4dde77:_0x4dde77);}}_0x4806c7[_0x4c99e8(0x241)](_0x28bd7d,_0x6449e1,_0x33fe19,_0x3d93dd,_0x297e2e,_0x58b224),_0x4806c7[_0x4c99e8(0x4a5)](_0x416174);}if(_0x4d53a7)_0xe45de[_0x4c99e8(0x415)](_0x4c99e8(0x1ee));}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x56b),_0x3eb8e4=>{const _0x55b213=_0x2dcaec;if(!SceneManager['isSceneBattle']())return;VisuMZ['ConvertParams'](_0x3eb8e4,_0x3eb8e4);const _0x3f086b=$gameTemp[_0x55b213(0x9c5)](),_0x43dc5d=VisuMZ[_0x55b213(0x77f)](_0x3eb8e4['Targets']),_0x3e483b=_0x3eb8e4['Opacity'],_0x26f616=_0x3eb8e4['Duration'],_0x5d8c72=_0x3eb8e4['EasingType'],_0xceaaae=_0x3eb8e4[_0x55b213(0xbb3)];if(!_0x3f086b)return;for(const _0x51390d of _0x43dc5d){if(!_0x51390d)continue;_0x51390d[_0x55b213(0x7cf)](_0x3e483b,_0x26f616,_0x5d8c72);}if(_0xceaaae)_0x3f086b[_0x55b213(0x415)](_0x55b213(0x6e6));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0xa59),_0x40ea03=>{const _0x2001fa=_0x2dcaec;if(!SceneManager[_0x2001fa(0xa2b)]())return;VisuMZ[_0x2001fa(0x44f)](_0x40ea03,_0x40ea03);const _0x3c2e94=$gameTemp[_0x2001fa(0x9c5)](),_0x20b1a3=VisuMZ[_0x2001fa(0x77f)](_0x40ea03['Targets']),_0x5e7636=_0x40ea03[_0x2001fa(0x5c2)],_0x55701e=_0x40ea03[_0x2001fa(0x141)],_0x131c65=_0x40ea03[_0x2001fa(0x603)],_0x4b76f9=_0x40ea03[_0x2001fa(0x9cf)],_0x5dcb90=_0x40ea03['WaitForScale'];if(!_0x3c2e94)return;for(const _0x216e3a of _0x20b1a3){if(!_0x216e3a)continue;_0x216e3a[_0x2001fa(0x6ff)](_0x5e7636,_0x55701e,_0x131c65,_0x4b76f9);}if(_0x5dcb90)_0x3c2e94[_0x2001fa(0x415)]('battleGrow');}),PluginManager[_0x2dcaec(0x1a8)](pluginData['name'],_0x2dcaec(0x726),_0x7af4d8=>{const _0x38c37a=_0x2dcaec;if(!SceneManager[_0x38c37a(0xa2b)]())return;VisuMZ[_0x38c37a(0x44f)](_0x7af4d8,_0x7af4d8);const _0x2bc183=$gameTemp[_0x38c37a(0x9c5)](),_0x7aa06c=VisuMZ[_0x38c37a(0x77f)](_0x7af4d8['Targets']),_0x3436a9=_0x7af4d8[_0x38c37a(0x863)],_0x4d48ce=_0x7af4d8[_0x38c37a(0xae0)],_0x1e4e72=_0x7af4d8[_0x38c37a(0x603)],_0x12c0e8=_0x7af4d8['EasingType'],_0x43bed9=_0x7af4d8[_0x38c37a(0x366)];if(!_0x2bc183)return;for(const _0x57eac1 of _0x7aa06c){if(!_0x57eac1)continue;_0x57eac1[_0x38c37a(0x928)](_0x3436a9,_0x4d48ce,_0x1e4e72,_0x12c0e8);}if(_0x43bed9)_0x2bc183['setWaitMode'](_0x38c37a(0x27e));}),PluginManager[_0x2dcaec(0x1a8)](pluginData['name'],_0x2dcaec(0xb87),_0xc15895=>{const _0x1bb9fc=_0x2dcaec;if(!SceneManager[_0x1bb9fc(0xa2b)]())return;VisuMZ[_0x1bb9fc(0x44f)](_0xc15895,_0xc15895);const _0x41df9e=$gameTemp[_0x1bb9fc(0x9c5)](),_0x4b3542=VisuMZ[_0x1bb9fc(0x77f)](_0xc15895[_0x1bb9fc(0xad6)]),_0x3abd5f=_0xc15895[_0x1bb9fc(0x34a)],_0x5e488f=_0xc15895[_0x1bb9fc(0x603)],_0x2af609=_0xc15895[_0x1bb9fc(0x9cf)],_0x1a8f76=_0xc15895[_0x1bb9fc(0x7d7)],_0x108cfc=_0xc15895['WaitForSpin'];if(!_0x41df9e)return;for(const _0x3cf4f2 of _0x4b3542){if(!_0x3cf4f2)continue;_0x3cf4f2[_0x1bb9fc(0x538)](_0x3abd5f,_0x5e488f,_0x2af609,_0x1a8f76);}if(_0x108cfc)_0x41df9e[_0x1bb9fc(0x415)](_0x1bb9fc(0x8a8));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x1fd),_0x84512e=>{const _0x2db58a=_0x2dcaec;if(!SceneManager[_0x2db58a(0xa2b)]())return;const _0x7ae488=$gameTemp['getLastPluginCommandInterpreter']();if(!_0x7ae488)return;_0x7ae488[_0x2db58a(0x415)](_0x2db58a(0x6cb));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x243),_0x35745c=>{const _0x5ca8f8=_0x2dcaec;if(!SceneManager[_0x5ca8f8(0xa2b)]())return;const _0xe5f0d5=$gameTemp[_0x5ca8f8(0x9c5)]();if(!_0xe5f0d5)return;_0xe5f0d5['setWaitMode'](_0x5ca8f8(0x418));}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x81d),_0x4fbbd9=>{const _0x317576=_0x2dcaec;if(!SceneManager[_0x317576(0xa2b)]())return;const _0x16f673=$gameTemp[_0x317576(0x9c5)]();if(!_0x16f673)return;_0x16f673[_0x317576(0x415)](_0x317576(0x1ee));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0xb9c),_0x33d00f=>{const _0x4aa5d1=_0x2dcaec;if(!SceneManager[_0x4aa5d1(0xa2b)]())return;const _0x368b8c=$gameTemp[_0x4aa5d1(0x9c5)]();if(!_0x368b8c)return;_0x368b8c[_0x4aa5d1(0x415)]('battleOpacity');}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],'ActSeq_Movement_WaitForScale',_0x41d0c6=>{const _0x4d20cd=_0x2dcaec;if(!SceneManager['isSceneBattle']())return;const _0x30bb1d=$gameTemp[_0x4d20cd(0x9c5)]();if(!_0x30bb1d)return;_0x30bb1d[_0x4d20cd(0x415)](_0x4d20cd(0x19f));}),PluginManager['registerCommand'](pluginData['name'],_0x2dcaec(0x9c1),_0x16837c=>{const _0x1aa40e=_0x2dcaec;if(!SceneManager[_0x1aa40e(0xa2b)]())return;const _0x59422d=$gameTemp[_0x1aa40e(0x9c5)]();if(!_0x59422d)return;_0x59422d['setWaitMode'](_0x1aa40e(0x27e));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x420),_0x2cbe4b=>{const _0x2cf739=_0x2dcaec;if(!SceneManager[_0x2cf739(0xa2b)]())return;const _0x322df2=$gameTemp[_0x2cf739(0x9c5)]();if(!_0x322df2)return;_0x322df2[_0x2cf739(0x415)](_0x2cf739(0x8a8));}),VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x519)]=function(){const _0x59fe83=_0x2dcaec;if(!Imported[_0x59fe83(0x801)])return;if(VisuMZ[_0x59fe83(0xb86)][_0x59fe83(0x620)]<1.08){let _0x393457='';_0x393457+='VisuMZ_3_ActSeqProjectiles\x20needs\x20to\x20be\x20updated\x20',_0x393457+=_0x59fe83(0x24e),alert(_0x393457),SceneManager['exit']();}},PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0xb08),_0xa5a1d3=>{const _0xd5a64e=_0x2dcaec;if(!SceneManager[_0xd5a64e(0xa2b)]())return;if(!Imported[_0xd5a64e(0x801)])return;VisuMZ[_0xd5a64e(0x44f)](_0xa5a1d3,_0xa5a1d3),VisuMZ[_0xd5a64e(0xae3)][_0xd5a64e(0x519)]();const _0x141dae=$gameTemp['getLastPluginCommandInterpreter'](),_0x1168ea=_0xa5a1d3[_0xd5a64e(0x9ab)];if(!_0x141dae)return;const _0x355d84=BattleManager[_0xd5a64e(0x2a3)];if(!_0x355d84)return;_0x355d84[_0xd5a64e(0x628)](_0xa5a1d3);if(_0x1168ea)_0x141dae[_0xd5a64e(0x415)](_0xd5a64e(0x5e5));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x667),_0x2bbb55=>{const _0x1b678a=_0x2dcaec;if(!SceneManager[_0x1b678a(0xa2b)]())return;if(!Imported[_0x1b678a(0x801)])return;VisuMZ[_0x1b678a(0x44f)](_0x2bbb55,_0x2bbb55),VisuMZ[_0x1b678a(0xae3)][_0x1b678a(0x519)]();const _0x488602=$gameTemp[_0x1b678a(0x9c5)](),_0x222c2f=_0x2bbb55['WaitForProjectile'];if(!_0x488602)return;const _0x43e8e6=BattleManager[_0x1b678a(0x2a3)];if(!_0x43e8e6)return;_0x43e8e6['createActionSequenceProjectile'](_0x2bbb55);if(_0x222c2f)_0x488602[_0x1b678a(0x415)](_0x1b678a(0x5e5));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x860),_0xcf3f34=>{const _0x14389e=_0x2dcaec;if(!SceneManager[_0x14389e(0xa2b)]())return;if(!Imported[_0x14389e(0x801)])return;VisuMZ[_0x14389e(0x44f)](_0xcf3f34,_0xcf3f34),VisuMZ[_0x14389e(0xae3)]['CheckActSeqProjectileVersion']();const _0x40eae1=$gameTemp['getLastPluginCommandInterpreter'](),_0x2a0b2a=_0xcf3f34[_0x14389e(0x9ab)];if(!_0x40eae1)return;const _0x3bac78=BattleManager[_0x14389e(0x2a3)];if(!_0x3bac78)return;_0x3bac78[_0x14389e(0x628)](_0xcf3f34);if(_0x2a0b2a)_0x40eae1[_0x14389e(0x415)](_0x14389e(0x5e5));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x7bf),_0x31bd49=>{const _0x4085a6=_0x2dcaec;if(!SceneManager[_0x4085a6(0xa2b)]())return;if(!Imported[_0x4085a6(0x161)])return;VisuMZ['ConvertParams'](_0x31bd49,_0x31bd49);const _0x4db7b7=$gameTemp[_0x4085a6(0x9c5)](),_0x12bde9=_0x31bd49[_0x4085a6(0x366)];if(!_0x4db7b7)return;$gameScreen['setBattleSkew'](_0x31bd49[_0x4085a6(0x863)],_0x31bd49[_0x4085a6(0xae0)],_0x31bd49['Duration'],_0x31bd49[_0x4085a6(0x9cf)]);if(_0x12bde9)_0x4db7b7[_0x4085a6(0x415)](_0x4085a6(0x839));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x8d3),_0x49ccb4=>{const _0x264bfb=_0x2dcaec;if(!SceneManager[_0x264bfb(0xa2b)]())return;if(!Imported[_0x264bfb(0x161)])return;VisuMZ[_0x264bfb(0x44f)](_0x49ccb4,_0x49ccb4);const _0x2dd74a=$gameTemp[_0x264bfb(0x9c5)](),_0x2ee0ee=_0x49ccb4[_0x264bfb(0x366)];if(!_0x2dd74a)return;$gameScreen['setBattleSkew'](0x0,0x0,_0x49ccb4[_0x264bfb(0x603)],_0x49ccb4[_0x264bfb(0x9cf)]);if(_0x2ee0ee)_0x2dd74a[_0x264bfb(0x415)]('battleSkew');}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x4a2),_0xde71c7=>{const _0x54c367=_0x2dcaec;if(!SceneManager[_0x54c367(0xa2b)]())return;if(!Imported['VisuMZ_3_ActSeqCamera'])return;const _0x59595a=$gameTemp['getLastPluginCommandInterpreter']();if(!_0x59595a)return;_0x59595a[_0x54c367(0x415)](_0x54c367(0x839));}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x36e),_0x290f87=>{const _0x5a2f31=_0x2dcaec;if(!SceneManager[_0x5a2f31(0xa2b)]())return;VisuMZ[_0x5a2f31(0x44f)](_0x290f87,_0x290f87);const _0x2cb971=$gameTemp['getLastPluginCommandInterpreter'](),_0x21245c=_0x290f87['Index'],_0x2d84f2=_0x290f87[_0x5a2f31(0x1ba)];if(!_0x2cb971)return;BattleManager[_0x5a2f31(0xc26)]=_0x21245c,BattleManager[_0x5a2f31(0xc39)]=BattleManager[_0x5a2f31(0x180)]?BattleManager['_allTargets'][BattleManager[_0x5a2f31(0xc26)]]||null:null;if(window[_0x5a2f31(0x8e7)])BattleManager[_0x5a2f31(0xbac)]();BattleManager[_0x5a2f31(0xc39)]&&_0x2d84f2['toUpperCase']()[_0x5a2f31(0x651)]()!==_0x5a2f31(0xc51)&&_0x2cb971['command119']([_0x2d84f2]);}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],'ActSeq_Target_NextTarget',_0x4b5ca3=>{const _0x2630b4=_0x2dcaec;if(!SceneManager[_0x2630b4(0xa2b)]())return;VisuMZ[_0x2630b4(0x44f)](_0x4b5ca3,_0x4b5ca3);const _0x3f5f4b=$gameTemp['getLastPluginCommandInterpreter'](),_0x44c6ea=_0x4b5ca3[_0x2630b4(0x1ba)];if(!_0x3f5f4b)return;BattleManager[_0x2630b4(0xc26)]++,BattleManager[_0x2630b4(0xc39)]=BattleManager['_allTargets'][BattleManager['_targetIndex']]||null;if(window[_0x2630b4(0x8e7)])BattleManager['updateBattleVariables']();BattleManager[_0x2630b4(0xc39)]&&_0x44c6ea[_0x2630b4(0xb9f)]()[_0x2630b4(0x651)]()!=='UNTITLED'&&_0x3f5f4b[_0x2630b4(0x8a4)]([_0x44c6ea]);}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],'ActSeq_Target_PrevTarget',_0xe2fdc2=>{const _0x47e0c9=_0x2dcaec;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x47e0c9(0x44f)](_0xe2fdc2,_0xe2fdc2);const _0xf7ab22=$gameTemp['getLastPluginCommandInterpreter'](),_0x587c58=_0xe2fdc2[_0x47e0c9(0x1ba)];if(!_0xf7ab22)return;BattleManager['_targetIndex']--,BattleManager[_0x47e0c9(0xc39)]=BattleManager['_allTargets'][BattleManager['_targetIndex']]||null;if(window[_0x47e0c9(0x8e7)])BattleManager[_0x47e0c9(0xbac)]();BattleManager[_0x47e0c9(0xc39)]&&_0x587c58['toUpperCase']()['trim']()!==_0x47e0c9(0xc51)&&_0xf7ab22[_0x47e0c9(0x8a4)]([_0x587c58]);}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x946),_0x5ac7f5=>{const _0x334c17=_0x2dcaec;if(!SceneManager[_0x334c17(0xa2b)]())return;VisuMZ[_0x334c17(0x44f)](_0x5ac7f5,_0x5ac7f5);const _0x240251=$gameTemp['getLastPluginCommandInterpreter'](),_0x4df3f1=_0x5ac7f5[_0x334c17(0xb50)],_0x53ba43=_0x5ac7f5[_0x334c17(0x1ba)];if(!_0x240251)return;const _0x19ce0a=BattleManager[_0x334c17(0xc26)];for(;;){BattleManager[_0x334c17(0xc26)]=Math[_0x334c17(0xb44)](BattleManager[_0x334c17(0x180)][_0x334c17(0x7ce)]);if(!_0x4df3f1)break;if(BattleManager[_0x334c17(0xc26)]!==_0x19ce0a)break;if(BattleManager['_allTargets'][_0x334c17(0x7ce)]<=0x1){BattleManager[_0x334c17(0xc26)]=0x0;break;}}BattleManager['_target']=BattleManager['_allTargets'][BattleManager[_0x334c17(0xc26)]]||null;if(window[_0x334c17(0x8e7)])BattleManager['updateBattleVariables']();BattleManager[_0x334c17(0xc39)]&&_0x53ba43['toUpperCase']()[_0x334c17(0x651)]()!==_0x334c17(0xc51)&&_0x240251[_0x334c17(0x8a4)]([_0x53ba43]);}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x5c5),_0x22076c=>{const _0x3db084=_0x2dcaec;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x3db084(0x269)])return;if(!ConfigManager[_0x3db084(0xbb5)])return;VisuMZ['ConvertParams'](_0x22076c,_0x22076c);const _0x11494a=VisuMZ[_0x3db084(0x77f)](_0x22076c[_0x3db084(0xad6)]);let _0x3c561f=_0x22076c[_0x3db084(0x7b5)]||'';for(const _0x4a6169 of _0x11494a){if(!_0x4a6169)continue;_0x4a6169[_0x3db084(0x771)](_0x3c561f);}}),PluginManager[_0x2dcaec(0x1a8)](pluginData['name'],_0x2dcaec(0x717),_0x375452=>{const _0x5c91b3=_0x2dcaec;if(!SceneManager[_0x5c91b3(0xa2b)]())return;if(!Imported[_0x5c91b3(0x269)])return;if(!ConfigManager[_0x5c91b3(0xbb5)])return;VisuMZ[_0x5c91b3(0x44f)](_0x375452,_0x375452);const _0x1382f0=VisuMZ[_0x5c91b3(0x77f)](_0x375452[_0x5c91b3(0xad6)]);let _0x27beac=(_0x375452[_0x5c91b3(0x260)]||'')+(_0x375452[_0x5c91b3(0xa52)]||'');for(const _0x1c76f9 of _0x1382f0){if(!_0x1c76f9)continue;_0x1c76f9[_0x5c91b3(0x771)](_0x27beac);}}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x7d9),_0x5b9e26=>{const _0x1582b9=_0x2dcaec;if(!SceneManager[_0x1582b9(0xa2b)]())return;VisuMZ[_0x1582b9(0x44f)](_0x5b9e26,_0x5b9e26);const _0x5d4231=VisuMZ[_0x1582b9(0x77f)](_0x5b9e26[_0x1582b9(0xad6)]);for(const _0x27ba69 of _0x5d4231){if(!_0x27ba69)continue;if(!_0x27ba69[_0x1582b9(0x8d6)]())continue;_0x27ba69[_0x1582b9(0x64e)]();}}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x617),_0x437bf7=>{const _0x31ddc9=_0x2dcaec;if(!SceneManager[_0x31ddc9(0xa2b)]())return;VisuMZ[_0x31ddc9(0x44f)](_0x437bf7,_0x437bf7);const _0x23d587=$gameTemp[_0x31ddc9(0x9c5)]();let _0x5d5051=![];const _0x107638=_0x437bf7['JumpToLabel'],_0x4f85fb=VisuMZ[_0x31ddc9(0x77f)](_0x437bf7[_0x31ddc9(0xad6)]);for(const _0x2c0315 of _0x4f85fb){if(!_0x2c0315)continue;if(!_0x2c0315[_0x31ddc9(0x8d6)]())continue;_0x2c0315['nextActiveWeaponSlot'](),_0x2c0315['weapons']()[_0x31ddc9(0x7ce)]>0x0?_0x5d5051=!![]:_0x2c0315[_0x31ddc9(0x64e)]();}_0x5d5051&&_0x107638[_0x31ddc9(0xb9f)]()[_0x31ddc9(0x651)]()!==_0x31ddc9(0xc51)&&_0x23d587['command119']([_0x107638]);}),PluginManager[_0x2dcaec(0x1a8)](pluginData['name'],_0x2dcaec(0xb0c),_0xacea8f=>{const _0x154f3f=_0x2dcaec;if(!SceneManager[_0x154f3f(0xa2b)]())return;VisuMZ[_0x154f3f(0x44f)](_0xacea8f,_0xacea8f);let _0x5a8fb7=_0xacea8f[_0x154f3f(0x191)];_0x5a8fb7--,_0x5a8fb7=Math[_0x154f3f(0x959)](_0x5a8fb7,0x0);const _0xafd8b=VisuMZ[_0x154f3f(0x77f)](_0xacea8f[_0x154f3f(0xad6)]);for(const _0x9fe1bf of _0xafd8b){if(!_0x9fe1bf)continue;if(!_0x9fe1bf[_0x154f3f(0x8d6)]())continue;_0x9fe1bf[_0x154f3f(0x51c)](_0x5a8fb7);}}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x632),_0x2d0f01=>{const _0x2730dd=_0x2dcaec;if(!SceneManager[_0x2730dd(0xa2b)]())return;if(!Imported[_0x2730dd(0x161)])return;VisuMZ['ConvertParams'](_0x2d0f01,_0x2d0f01);const _0x3efc71=$gameTemp[_0x2730dd(0x9c5)](),_0x2b9a5a=_0x2d0f01[_0x2730dd(0x7ee)];if(!_0x3efc71)return;$gameScreen['setBattleZoom'](_0x2d0f01[_0x2730dd(0x3f6)],_0x2d0f01[_0x2730dd(0x603)],_0x2d0f01[_0x2730dd(0x9cf)]);if(_0x2b9a5a)_0x3efc71[_0x2730dd(0x415)](_0x2730dd(0x6aa));}),PluginManager['registerCommand'](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x82a),_0x461049=>{const _0x10b7a8=_0x2dcaec;if(!SceneManager[_0x10b7a8(0xa2b)]())return;if(!Imported[_0x10b7a8(0x161)])return;VisuMZ[_0x10b7a8(0x44f)](_0x461049,_0x461049);const _0x487a81=$gameTemp[_0x10b7a8(0x9c5)](),_0x55cae2=_0x461049[_0x10b7a8(0x7ee)];if(!_0x487a81)return;$gameScreen[_0x10b7a8(0x3ba)](0x1,_0x461049[_0x10b7a8(0x603)],_0x461049['EasingType']);if(_0x55cae2)_0x487a81[_0x10b7a8(0x415)]('battleZoom');}),PluginManager[_0x2dcaec(0x1a8)](pluginData[_0x2dcaec(0x321)],_0x2dcaec(0x5be),_0x2b7b3a=>{const _0x18c429=_0x2dcaec;if(!SceneManager[_0x18c429(0xa2b)]())return;if(!Imported[_0x18c429(0x161)])return;const _0x56f769=$gameTemp[_0x18c429(0x9c5)]();if(!_0x56f769)return;_0x56f769['setWaitMode'](_0x18c429(0x6aa));}),VisuMZ['BattleCore'][_0x2dcaec(0x32a)]=Scene_Boot[_0x2dcaec(0xaf6)][_0x2dcaec(0xa50)],Scene_Boot[_0x2dcaec(0xaf6)][_0x2dcaec(0xa50)]=function(){const _0x33947b=_0x2dcaec;this[_0x33947b(0x3c8)](),this[_0x33947b(0x368)](),this[_0x33947b(0xb8e)](),this['process_VisuMZ_BattleCore_CreateRegExp'](),VisuMZ[_0x33947b(0xae3)][_0x33947b(0x32a)][_0x33947b(0x390)](this),this[_0x33947b(0xbdb)](),this[_0x33947b(0x1ec)](),this[_0x33947b(0x2aa)](),this[_0x33947b(0xab8)]();},Scene_Boot[_0x2dcaec(0xaf6)]['process_VisuMZ_BattleCore_Notetags']=function(){const _0x4d83b0=_0x2dcaec;if(VisuMZ['ParseAllNotetags'])return;this[_0x4d83b0(0x3e9)](),this[_0x4d83b0(0x421)](),this[_0x4d83b0(0x81a)]();},Scene_Boot[_0x2dcaec(0xaf6)][_0x2dcaec(0x3c8)]=function(){const _0x4f8aee=_0x2dcaec,_0x3d45df=$dataSystem[_0x4f8aee(0x670)][_0x4f8aee(0x7ce)];for(let _0x30b3b2=0x0;_0x30b3b2<_0x3d45df;_0x30b3b2++){const _0x59560c=$dataSystem[_0x4f8aee(0x861)][_0x30b3b2];if(_0x59560c)continue;$dataSystem[_0x4f8aee(0x861)][_0x30b3b2]={'type':0x1,'weaponImageId':0x1};}},Scene_Boot['prototype']['process_VisuMZ_BattleCore_PluginParams']=function(){const _0x477b83=_0x2dcaec,_0x58a613=VisuMZ['BattleCore'][_0x477b83(0xbeb)];_0x58a613[_0x477b83(0x53c)][_0x477b83(0xbc3)]===undefined&&(_0x58a613['Damage']['PopupPosition']=_0x477b83(0xb6c)),_0x58a613[_0x477b83(0x46b)][_0x477b83(0xacf)]===undefined&&(_0x58a613[_0x477b83(0x46b)][_0x477b83(0xacf)]=![]),_0x58a613[_0x477b83(0xc36)]['SmoothImage']===undefined&&(_0x58a613[_0x477b83(0xc36)][_0x477b83(0xacf)]=!![]),_0x58a613['Actor'][_0x477b83(0xb26)]===undefined&&(_0x58a613[_0x477b83(0x46b)][_0x477b83(0xb26)]=![]),_0x58a613[_0x477b83(0x46b)][_0x477b83(0x76e)]===undefined&&(_0x58a613[_0x477b83(0x46b)][_0x477b83(0x76e)]=!![]);},VisuMZ[_0x2dcaec(0x4c1)]={},Scene_Boot['prototype'][_0x2dcaec(0xb8e)]=function(){const _0x49cb2c=_0x2dcaec;for(const _0x5051ec of VisuMZ[_0x49cb2c(0xae3)][_0x49cb2c(0xbeb)][_0x49cb2c(0x53c)][_0x49cb2c(0x31d)]){if(!_0x5051ec)continue;const _0x2b326b=_0x5051ec['Name'][_0x49cb2c(0xb9f)]()[_0x49cb2c(0x651)]();VisuMZ[_0x49cb2c(0x4c1)][_0x2b326b]=_0x5051ec;}},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0xaea)]={'jsAccuracy':/<JS (?:ACCURACY|ACC|HIT|EVA)>\s*([\s\S]*?)\s*<\/JS (?:ACCURACY|ACC|HIT|EVA)>/i,'jsAccuracyAsUser':/<JS (?:ACCURACY|ACC|HIT|EVA) AS USER>\s*([\s\S]*?)\s*<\/JS (?:ACCURACY|ACC|HIT|EVA) AS USER>/i,'jsAccuracyAsTarget':/<JS (?:ACCURACY|ACC|HIT|EVA) AS TARGET>\s*([\s\S]*?)\s*<\/JS (?:ACCURACY|ACC|HIT|EVA) AS TARGET>/i,'jsCritRateAsUser':/<JS (?:CRITICAL RATE|CRI) AS USER>\s*([\s\S]*?)\s*<\/JS (?:CRITICAL RATE|CRI) AS USER>/i,'jsCritRateAsTarget':/<JS (?:CRITICAL RATE|CRI) AS TARGET>\s*([\s\S]*?)\s*<\/JS (?:CRITICAL RATE|CRI) AS TARGET>/i},Scene_Boot[_0x2dcaec(0xaf6)][_0x2dcaec(0x780)]=function(){const _0x273fcf=_0x2dcaec,_0x37254d=VisuMZ[_0x273fcf(0xae3)][_0x273fcf(0xaea)],_0x16a698=_0x273fcf(0x8d1),_0x8dd50d=[[_0x273fcf(0xa22),_0x273fcf(0x794)],[_0x273fcf(0x95f),'POST-']],_0x5cd131=[[_0x273fcf(0xb3e),'JS\x20%1APPLY\x20%2'],[_0x273fcf(0xbcb),_0x273fcf(0x6de)]],_0x3b3370=[['',''],[_0x273fcf(0xb91),'AS\x20USER'],[_0x273fcf(0x7d0),_0x273fcf(0xa5c)]];for(const _0xff6d83 of _0x5cd131){for(const _0x3cde82 of _0x3b3370){for(const _0xcfe690 of _0x8dd50d){const _0x3cbb8a=_0xff6d83[0x0][_0x273fcf(0xb60)](_0xcfe690[0x0],_0x3cde82[0x0]),_0x418d20=_0xff6d83[0x1][_0x273fcf(0xb60)](_0xcfe690[0x1],_0x3cde82[0x1])[_0x273fcf(0x651)](),_0x47f730=new RegExp(_0x16a698['format'](_0x418d20),'i');_0x37254d[_0x3cbb8a]=_0x47f730;}}}const _0x550a27=[[_0x273fcf(0x99c),_0x273fcf(0x50a)],[_0x273fcf(0x706),_0x273fcf(0x987)]];for(const _0x11b587 of _0x550a27){for(const _0x2d7e45 of _0x8dd50d){const _0x5e7b16=_0x11b587[0x0]['format'](_0x2d7e45[0x0]),_0x511dba=_0x11b587[0x1][_0x273fcf(0xb60)](_0x2d7e45[0x1]),_0x1b36a4=new RegExp(_0x16a698[_0x273fcf(0xb60)](_0x511dba),'i');_0x37254d[_0x5e7b16]=_0x1b36a4;}}const _0x3a6eaf=[['%1StartBattleJS',_0x273fcf(0x2b9)],['%1EndBattleJS',_0x273fcf(0xb37)],[_0x273fcf(0xa62),'JS\x20BATTLE\x20VICTORY'],['BattleDefeatJS',_0x273fcf(0x60f)],[_0x273fcf(0x578),_0x273fcf(0x583)],['EscapeFailureJS',_0x273fcf(0x61c)],[_0x273fcf(0x308),_0x273fcf(0x8c3)],[_0x273fcf(0x169),_0x273fcf(0x75f)],[_0x273fcf(0xb58),_0x273fcf(0x722)]];for(const _0x2249b5 of _0x3a6eaf){for(const _0x1230ca of _0x8dd50d){const _0x273c41=_0x2249b5[0x0][_0x273fcf(0xb60)](_0x1230ca[0x0]),_0x3409ea=_0x2249b5[0x1][_0x273fcf(0xb60)](_0x1230ca[0x1]),_0x1ba63a=new RegExp(_0x16a698[_0x273fcf(0xb60)](_0x3409ea),'i');_0x37254d[_0x273c41]=_0x1ba63a;}}},Scene_Boot[_0x2dcaec(0xaf6)][_0x2dcaec(0x3e9)]=function(){const _0x3635e6=_0x2dcaec,_0x230f0e=$dataSkills[_0x3635e6(0xa5b)]($dataItems);for(const _0x2f95a1 of _0x230f0e){if(!_0x2f95a1)continue;VisuMZ[_0x3635e6(0xae3)]['Parse_Notetags_Action'](_0x2f95a1);}},Scene_Boot[_0x2dcaec(0xaf6)][_0x2dcaec(0x421)]=function(){const _0x2169dc=_0x2dcaec,_0x12aace=$dataActors[_0x2169dc(0xa5b)]($dataClasses,$dataWeapons,$dataArmors,$dataEnemies,$dataStates);for(const _0xf90a41 of _0x12aace){if(!_0xf90a41)continue;VisuMZ[_0x2169dc(0xae3)][_0x2169dc(0x9aa)](_0xf90a41),_0xf90a41[_0x2169dc(0x48d)]!==undefined&&VisuMZ[_0x2169dc(0xae3)][_0x2169dc(0x802)](_0xf90a41);}},Scene_Boot[_0x2dcaec(0xaf6)]['process_VisuMZ_BattleCore_BaseTroops']=function(){const _0x4f0ab6=_0x2dcaec,_0x4f8a66=VisuMZ[_0x4f0ab6(0xae3)]['Settings'][_0x4f0ab6(0x41e)]['BaseTroopIDs'],_0x532b10=[];for(const _0x3ad70e of _0x4f8a66){const _0x473e21=$dataTroops[_0x3ad70e];if(_0x473e21)_0x532b10['push'](JsonEx[_0x4f0ab6(0xa12)](_0x473e21));}for(const _0x1ebac4 of $dataTroops){if(!_0x1ebac4)continue;for(const _0x19ff40 of _0x532b10){if(_0x19ff40['id']===_0x1ebac4['id'])continue;_0x1ebac4['pages']=_0x1ebac4[_0x4f0ab6(0x459)]['concat'](_0x19ff40[_0x4f0ab6(0x459)]);}}},Scene_Boot['prototype'][_0x2dcaec(0x2aa)]=function(){const _0x2c6c83=_0x2dcaec,_0x150296=VisuMZ[_0x2c6c83(0xae3)]['Settings']['Mechanics'];if(_0x150296['BattleStartEvent']>0x0&&$dataCommonEvents[_0x150296[_0x2c6c83(0x745)]]){const _0x20d617=$dataCommonEvents[_0x150296[_0x2c6c83(0x745)]],_0x59bacb=_0x20d617[_0x2c6c83(0x97c)][_0x2c6c83(0x7ce)]-0x2,_0x5dd0bf=_0x20d617[_0x2c6c83(0x97c)][_0x59bacb];if(_0x5dd0bf&&_0x5dd0bf[_0x2c6c83(0x812)]!==0xe6){const _0x569201={'code':0xe6,'indent':0x0,'parameters':[0x1]},_0x2b1e03=_0x20d617['list'][_0x2c6c83(0x8ed)]();_0x20d617[_0x2c6c83(0x97c)][_0x2c6c83(0xc48)](_0x569201),_0x20d617[_0x2c6c83(0x97c)][_0x2c6c83(0xc48)](_0x2b1e03);}}},Scene_Boot[_0x2dcaec(0xaf6)][_0x2dcaec(0xab8)]=function(){const _0x581ebf=_0x2dcaec;VisuMZ[_0x581ebf(0xae3)][_0x581ebf(0x899)](),VisuMZ['BattleCore'][_0x581ebf(0x93d)]($dataSkills),VisuMZ[_0x581ebf(0xae3)][_0x581ebf(0x93d)]($dataItems);},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x899)]=function(){const _0x2e9282=_0x2dcaec;VisuMZ[_0x2e9282(0xae3)]['_commonEventKey']={};for(const _0x333135 of $dataCommonEvents){if(!_0x333135)continue;if(_0x333135[_0x2e9282(0x321)][_0x2e9282(0xb9e)](/\[(.*)\]/i)){let _0x56eb71=String(RegExp['$1'])[_0x2e9282(0x1d3)](/,/g,'')[_0x2e9282(0xb9f)]()[_0x2e9282(0x651)]();VisuMZ[_0x2e9282(0xae3)][_0x2e9282(0x3b9)][_0x56eb71]=_0x333135['id'];}}},VisuMZ[_0x2dcaec(0xae3)]['BindCommonEventKeysForGroup']=function(_0x1386b0){const _0x386252=_0x2dcaec;for(const _0x1f8dc8 of _0x1386b0){if(!_0x1f8dc8)continue;VisuMZ[_0x386252(0xae3)][_0x386252(0x874)](_0x1f8dc8);}},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x874)]=function(_0xef9d64){const _0x54c537=_0x2dcaec;if(!_0xef9d64)return;if(!_0xef9d64['effects'])return;VisuMZ[_0x54c537(0xae3)][_0x54c537(0x3b9)]=VisuMZ[_0x54c537(0xae3)][_0x54c537(0x3b9)]||{};const _0x308414=/<COMMON EVENT (?:KEY|KEYS):[ ](.*)>/gi,_0x59f2ee=/<COMMON EVENT (?:KEY|KEYS)>\s*([\s\S]*)\s*<\/COMMON EVENT (?:KEY|KEYS)>/i;let _0x5eee66=[];const _0x2322b2=_0xef9d64[_0x54c537(0x795)]['match'](_0x308414);if(_0x2322b2){for(const _0x1b327a of _0x2322b2){_0x1b327a[_0x54c537(0xb9e)](_0x308414);const _0x345abd=String(RegExp['$1'])['split'](',')[_0x54c537(0xc20)](_0x3fcca1=>String(_0x3fcca1)[_0x54c537(0xb9f)]()['trim']());_0x5eee66=_0x5eee66['concat'](_0x345abd);}!_0xef9d64[_0x54c537(0x795)][_0x54c537(0xb9e)](/<CUSTOM ACTION SEQUENCE>/i)&&(_0xef9d64[_0x54c537(0x795)]+=_0x54c537(0x78a));;}if(_0xef9d64[_0x54c537(0x795)][_0x54c537(0xb9e)](_0x59f2ee)){const _0x34216f=String(RegExp['$1'])[_0x54c537(0x13b)](/[\r\n]+/)[_0x54c537(0xc20)](_0x144cc6=>String(_0x144cc6)[_0x54c537(0xb9f)]()['trim']());_0x5eee66=_0x5eee66[_0x54c537(0xa5b)](_0x34216f);!_0xef9d64['note'][_0x54c537(0xb9e)](/<CUSTOM ACTION SEQUENCE>/i)&&(_0xef9d64[_0x54c537(0x795)]+='<CUSTOM\x20ACTION\x20SEQUENCE>');;}for(const _0x5de9f5 of _0x5eee66){if(VisuMZ[_0x54c537(0xae3)][_0x54c537(0x3b9)][_0x5de9f5]){const _0x1bd4fd=VisuMZ[_0x54c537(0xae3)][_0x54c537(0x3b9)][_0x5de9f5],_0xf02fdc={'code':0x2c,'dataId':_0x1bd4fd,'value1':0x1,'value2':0x0};_0xef9d64[_0x54c537(0xb29)][_0x54c537(0x190)](_0xf02fdc);}}},Scene_Boot[_0x2dcaec(0xaf6)][_0x2dcaec(0x81a)]=function(){const _0x52f71c=_0x2dcaec,_0x725baa=$dataSkills[_0x52f71c(0xa5b)]($dataItems);for(const _0x3a446c of _0x725baa){if(!_0x3a446c)continue;VisuMZ[_0x52f71c(0xae3)][_0x52f71c(0xb99)](_0x3a446c);}},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x456)]=VisuMZ['ParseActorNotetags'],VisuMZ[_0x2dcaec(0x456)]=function(_0x34feef){const _0x134b70=_0x2dcaec;VisuMZ[_0x134b70(0xae3)][_0x134b70(0x456)]&&VisuMZ[_0x134b70(0xae3)][_0x134b70(0x456)][_0x134b70(0x390)](this,_0x34feef),VisuMZ[_0x134b70(0xae3)][_0x134b70(0x9aa)](_0x34feef);},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x638)]=VisuMZ[_0x2dcaec(0x638)],VisuMZ[_0x2dcaec(0x638)]=function(_0x911503){const _0x4c1f47=_0x2dcaec;VisuMZ[_0x4c1f47(0xae3)][_0x4c1f47(0x638)]&&VisuMZ[_0x4c1f47(0xae3)][_0x4c1f47(0x638)][_0x4c1f47(0x390)](this,_0x911503),VisuMZ[_0x4c1f47(0xae3)][_0x4c1f47(0x9aa)](_0x911503);},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x8bd)]=VisuMZ[_0x2dcaec(0x8bd)],VisuMZ[_0x2dcaec(0x8bd)]=function(_0x279328){const _0x13c712=_0x2dcaec;VisuMZ[_0x13c712(0xae3)]['ParseSkillNotetags']&&VisuMZ['BattleCore'][_0x13c712(0x8bd)][_0x13c712(0x390)](this,_0x279328),VisuMZ['BattleCore'][_0x13c712(0xae4)](_0x279328),VisuMZ[_0x13c712(0xae3)][_0x13c712(0xb99)](_0x279328);},VisuMZ['BattleCore'][_0x2dcaec(0x9ba)]=VisuMZ['ParseItemNotetags'],VisuMZ['ParseItemNotetags']=function(_0x2889c0){const _0x21ee93=_0x2dcaec;VisuMZ[_0x21ee93(0xae3)][_0x21ee93(0x9ba)]&&VisuMZ[_0x21ee93(0xae3)][_0x21ee93(0x9ba)][_0x21ee93(0x390)](this,_0x2889c0),VisuMZ[_0x21ee93(0xae3)]['Parse_Notetags_Action'](_0x2889c0),VisuMZ[_0x21ee93(0xae3)]['Parse_Notetags_Targets'](_0x2889c0);},VisuMZ[_0x2dcaec(0xae3)]['ParseWeaponNotetags']=VisuMZ[_0x2dcaec(0x42b)],VisuMZ[_0x2dcaec(0x42b)]=function(_0x5cabbf){const _0x3c2146=_0x2dcaec;VisuMZ[_0x3c2146(0xae3)][_0x3c2146(0x42b)]&&VisuMZ[_0x3c2146(0xae3)][_0x3c2146(0x42b)][_0x3c2146(0x390)](this,_0x5cabbf),VisuMZ[_0x3c2146(0xae3)][_0x3c2146(0x9aa)](_0x5cabbf);},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x479)]=VisuMZ[_0x2dcaec(0x479)],VisuMZ[_0x2dcaec(0x479)]=function(_0x2bdc02){const _0x4210ed=_0x2dcaec;VisuMZ['BattleCore']['ParseArmorNotetags']&&VisuMZ[_0x4210ed(0xae3)]['ParseArmorNotetags'][_0x4210ed(0x390)](this,_0x2bdc02),VisuMZ['BattleCore'][_0x4210ed(0x9aa)](_0x2bdc02);},VisuMZ[_0x2dcaec(0xae3)]['ParseEnemyNotetags']=VisuMZ[_0x2dcaec(0x66b)],VisuMZ[_0x2dcaec(0x66b)]=function(_0x42cb54){const _0x4334ac=_0x2dcaec;VisuMZ['BattleCore']['ParseEnemyNotetags']&&VisuMZ[_0x4334ac(0xae3)][_0x4334ac(0x66b)][_0x4334ac(0x390)](this,_0x42cb54),VisuMZ[_0x4334ac(0xae3)][_0x4334ac(0x9aa)](_0x42cb54);},VisuMZ[_0x2dcaec(0xae3)]['ParseStateNotetags']=VisuMZ[_0x2dcaec(0x52c)],VisuMZ['ParseStateNotetags']=function(_0x3da83e){const _0x2cd58f=_0x2dcaec;VisuMZ[_0x2cd58f(0xae3)][_0x2cd58f(0x52c)]&&VisuMZ[_0x2cd58f(0xae3)][_0x2cd58f(0x52c)][_0x2cd58f(0x390)](this,_0x3da83e),VisuMZ[_0x2cd58f(0xae3)][_0x2cd58f(0x9aa)](_0x3da83e),VisuMZ['BattleCore']['Parse_Notetags_HelpDescription'](_0x3da83e);},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0xae4)]=function(_0xe2455d){const _0x1da03d=_0x2dcaec,_0x39745f=[_0x1da03d(0x259),'PostApplyJS',_0x1da03d(0x15e),_0x1da03d(0x9fa),_0x1da03d(0xb3f),_0x1da03d(0x3ac),_0x1da03d(0xa89),_0x1da03d(0x14e)];for(const _0x2ad4ba of _0x39745f){VisuMZ['BattleCore'][_0x1da03d(0x3c1)](_0xe2455d,_0x2ad4ba);}const _0x4a404c=_0xe2455d[_0x1da03d(0x795)];_0x4a404c[_0x1da03d(0xb9e)](/<ALWAYS CRITICAL/i)&&(_0xe2455d[_0x1da03d(0x63e)][_0x1da03d(0x73b)]=!![]),_0x4a404c[_0x1da03d(0xb9e)](/<(?:REPEAT|REPEATS|REPEAT HITS):[ ](\d+)/i)&&(_0xe2455d[_0x1da03d(0x5a5)]=Math[_0x1da03d(0x959)](0x1,Number(RegExp['$1']))),_0x4a404c[_0x1da03d(0xb9e)](/<TARGET:[ ](.*)>/i)&&(_0xe2455d[_0x1da03d(0x147)]=String(RegExp['$1'])[_0x1da03d(0xb9f)]()[_0x1da03d(0x651)]());},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x9aa)]=function(_0x5dfdce){const _0x17d2a7=_0x2dcaec,_0x57e5b7=[_0x17d2a7(0x492),_0x17d2a7(0x730),'PreDamageAsUserJS',_0x17d2a7(0x4b3),_0x17d2a7(0xba8),_0x17d2a7(0x288),_0x17d2a7(0x989),'PostDamageAsTargetJS',_0x17d2a7(0xb3f),'PostStartActionJS',_0x17d2a7(0xa89),'PostEndActionJS',_0x17d2a7(0x9ad),_0x17d2a7(0xa53),'PreEndBattleJS',_0x17d2a7(0x227),_0x17d2a7(0xa62),_0x17d2a7(0x3b7),_0x17d2a7(0x578),_0x17d2a7(0xaeb),_0x17d2a7(0x892),_0x17d2a7(0x29f),_0x17d2a7(0xb14),_0x17d2a7(0x531),_0x17d2a7(0xa24),_0x17d2a7(0x653)];for(const _0x558dd5 of _0x57e5b7){VisuMZ[_0x17d2a7(0xae3)][_0x17d2a7(0x3c1)](_0x5dfdce,_0x558dd5);}const _0x128570=['jsAccuracy',_0x17d2a7(0x24d),'jsAccuracyAsTarget',_0x17d2a7(0x438),_0x17d2a7(0x809)];for(const _0x15363f of _0x128570){VisuMZ['BattleCore'][_0x17d2a7(0x1bc)](_0x5dfdce,_0x15363f);}},VisuMZ['BattleCore']['Parse_Notetags_Targets']=function(_0x5b747a){const _0x50a9b7=_0x2dcaec,_0x1d8c5a=_0x5b747a[_0x50a9b7(0x795)];if(_0x1d8c5a[_0x50a9b7(0xb9e)](/<JS TARGETS>\s*([\s\S]*)\s*<\/JS TARGETS>/i)){const _0x5b318d=String(RegExp['$1']),_0x49b31c=VisuMZ[_0x50a9b7(0xae3)][_0x50a9b7(0x2a1)](_0x5b747a,_0x50a9b7(0xad6));VisuMZ['BattleCore'][_0x50a9b7(0x50e)](_0x5b318d,_0x49b31c);}if(_0x1d8c5a[_0x50a9b7(0xb9e)](/<JS COMMAND (?:VISIBLE|SHOW|HIDE)>\s*([\s\S]*)\s*<\/JS COMMAND (?:VISIBLE|SHOW|HIDE)>/i)){const _0x3f15af=String(RegExp['$1']),_0x306035=VisuMZ[_0x50a9b7(0xae3)][_0x50a9b7(0x2a1)](_0x5b747a,_0x50a9b7(0x7e2));VisuMZ[_0x50a9b7(0xae3)][_0x50a9b7(0x2b6)](_0x3f15af,_0x306035);}},VisuMZ[_0x2dcaec(0xae3)]['JS']={},VisuMZ['BattleCore'][_0x2dcaec(0x3c1)]=function(_0x461feb,_0x4bbc0f){const _0x2f4177=_0x2dcaec,_0x23190a=_0x461feb[_0x2f4177(0x795)];if(_0x23190a[_0x2f4177(0xb9e)](VisuMZ['BattleCore']['RegExp'][_0x4bbc0f])){const _0x169c23=RegExp['$1'],_0x30625c=_0x2f4177(0xc2f)[_0x2f4177(0xb60)](_0x169c23),_0x29b16a=VisuMZ[_0x2f4177(0xae3)]['createKeyJS'](_0x461feb,_0x4bbc0f);VisuMZ['BattleCore']['JS'][_0x29b16a]=new Function(_0x30625c);}},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x2a1)]=function(_0x518411,_0x1aeadf){const _0x14b770=_0x2dcaec;if(VisuMZ[_0x14b770(0x2a1)])return VisuMZ['createKeyJS'](_0x518411,_0x1aeadf);let _0xeb8ab5='';if($dataActors[_0x14b770(0x7f2)](_0x518411))_0xeb8ab5='Actor-%1-%2'[_0x14b770(0xb60)](_0x518411['id'],_0x1aeadf);if($dataClasses[_0x14b770(0x7f2)](_0x518411))_0xeb8ab5=_0x14b770(0x7f9)[_0x14b770(0xb60)](_0x518411['id'],_0x1aeadf);if($dataSkills[_0x14b770(0x7f2)](_0x518411))_0xeb8ab5=_0x14b770(0xac1)['format'](_0x518411['id'],_0x1aeadf);if($dataItems[_0x14b770(0x7f2)](_0x518411))_0xeb8ab5='Item-%1-%2'[_0x14b770(0xb60)](_0x518411['id'],_0x1aeadf);if($dataWeapons[_0x14b770(0x7f2)](_0x518411))_0xeb8ab5=_0x14b770(0x140)[_0x14b770(0xb60)](_0x518411['id'],_0x1aeadf);if($dataArmors[_0x14b770(0x7f2)](_0x518411))_0xeb8ab5=_0x14b770(0xc6e)[_0x14b770(0xb60)](_0x518411['id'],_0x1aeadf);if($dataEnemies[_0x14b770(0x7f2)](_0x518411))_0xeb8ab5=_0x14b770(0x534)[_0x14b770(0xb60)](_0x518411['id'],_0x1aeadf);if($dataStates[_0x14b770(0x7f2)](_0x518411))_0xeb8ab5=_0x14b770(0xb67)[_0x14b770(0xb60)](_0x518411['id'],_0x1aeadf);return _0xeb8ab5;},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x50e)]=function(_0x1bae86,_0x5626df){const _0x1bd5ac=_0x2dcaec,_0x597974=_0x1bd5ac(0x979)[_0x1bd5ac(0xb60)](_0x1bae86);VisuMZ[_0x1bd5ac(0xae3)]['JS'][_0x5626df]=new Function(_0x597974);},VisuMZ['BattleCore'][_0x2dcaec(0x2b6)]=function(_0xfec423,_0x46cba2){const _0x476ad8=_0x2dcaec,_0xf84a1d=_0x476ad8(0x199)['format'](_0xfec423);VisuMZ[_0x476ad8(0xae3)]['JS'][_0x46cba2]=new Function(_0xf84a1d);},VisuMZ['BattleCore'][_0x2dcaec(0x1bc)]=function(_0x204a53,_0xeebafe){const _0x4088a3=_0x2dcaec,_0x448044=_0x204a53[_0x4088a3(0x795)];if(_0x448044[_0x4088a3(0xb9e)](VisuMZ[_0x4088a3(0xae3)][_0x4088a3(0xaea)][_0xeebafe])){const _0x14af06=RegExp['$1'],_0x5426eb=_0x4088a3(0x8eb)[_0x4088a3(0xb60)](_0x14af06),_0x4329a8=VisuMZ['BattleCore'][_0x4088a3(0x2a1)](_0x204a53,_0xeebafe);VisuMZ['BattleCore']['JS'][_0x4329a8]=new Function(_0x5426eb);}},VisuMZ[_0x2dcaec(0xae3)]['Parse_Notetags_HelpDescription']=function(_0x146f43){const _0x8149ab=_0x2dcaec;_0x146f43[_0x8149ab(0x7c3)]='-';const _0x585639=_0x146f43['note'];_0x585639[_0x8149ab(0xb9e)](/<(?:HELP|HELP DESCRIPTION|DESCRIPTION)>\s*([\s\S]*)\s*<\/(?:HELP|HELP DESCRIPTION|DESCRIPTION)>/i)&&(_0x146f43[_0x8149ab(0x7c3)]=String(RegExp['$1'])['trim']()),_0x585639['match'](/<(?:IN-BATTLE |)STATUS DESCRIPTION>\s*([\s\S]*)\s*<\/(?:IN-BATTLE |)STATUS DESCRIPTION>/i)&&(_0x146f43[_0x8149ab(0xa14)]=String(RegExp['$1'])[_0x8149ab(0x651)]()),_0x585639[_0x8149ab(0xb9e)](/<EXCLUDE FROM (?:HELP|STATUS|STATUS LIST|LISTING|STATUS LISTING)>/i)&&(_0x146f43[_0x8149ab(0x56a)]=!![]);},TextManager['autoBattle']=VisuMZ[_0x2dcaec(0xae3)]['Settings'][_0x2dcaec(0x586)][_0x2dcaec(0xc27)],TextManager['autoBattleStart']=VisuMZ[_0x2dcaec(0xae3)]['Settings'][_0x2dcaec(0xaec)][_0x2dcaec(0x843)],TextManager['autoBattleStyle']=VisuMZ['BattleCore']['Settings']['AutoBattle'][_0x2dcaec(0x89c)],TextManager[_0x2dcaec(0x4ce)]=VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0xbeb)][_0x2dcaec(0x2bb)][_0x2dcaec(0x3e0)],ColorManager['getColor']=function(_0x47689d){const _0x2c101=_0x2dcaec;return _0x47689d=String(_0x47689d),_0x47689d[_0x2c101(0xb9e)](/#(.*)/i)?_0x2c101(0x687)['format'](String(RegExp['$1'])):this[_0x2c101(0x33d)](Number(_0x47689d));},DataManager[_0x2dcaec(0x47f)]=function(_0x275330){const _0x4fe736=_0x2dcaec;if(_0x275330['note'][_0x4fe736(0xb9e)](/<DAMAGE STYLE:[ ](.*)>/i)){const _0x202f4b=String(RegExp['$1'])[_0x4fe736(0xb9f)]()[_0x4fe736(0x651)]();if(_0x202f4b==='MANUAL')return _0x4fe736(0x45d);if(VisuMZ['DamageStyles'][_0x202f4b])return _0x202f4b;}const _0x5d7217=VisuMZ[_0x4fe736(0xae3)]['Settings'][_0x4fe736(0x53c)][_0x4fe736(0x481)][_0x4fe736(0xb9f)]()[_0x4fe736(0x651)]();if(VisuMZ['DamageStyles'][_0x5d7217])return _0x5d7217;return'MANUAL';},DataManager[_0x2dcaec(0x51b)]=function(_0x246d80){const _0x52eafe=_0x2dcaec;_0x246d80=_0x246d80['toUpperCase']()['trim'](),this[_0x52eafe(0x98b)]=this[_0x52eafe(0x98b)]||{};if(this[_0x52eafe(0x98b)][_0x246d80])return this['_stypeIDs'][_0x246d80];for(let _0x4ed696=0x1;_0x4ed696<0x64;_0x4ed696++){if(!$dataSystem[_0x52eafe(0xa55)][_0x4ed696])continue;let _0x20967e=$dataSystem[_0x52eafe(0xa55)][_0x4ed696][_0x52eafe(0xb9f)]()[_0x52eafe(0x651)]();_0x20967e=_0x20967e[_0x52eafe(0x1d3)](/\x1I\[(\d+)\]/gi,''),_0x20967e=_0x20967e['replace'](/\\I\[(\d+)\]/gi,''),this[_0x52eafe(0x98b)][_0x20967e]=_0x4ed696;}return this[_0x52eafe(0x98b)][_0x246d80]||0x0;},DataManager['getSkillIdWithName']=function(_0x49268e){const _0x48dc47=_0x2dcaec;_0x49268e=_0x49268e[_0x48dc47(0xb9f)]()['trim'](),this['_skillIDs']=this[_0x48dc47(0x1f0)]||{};if(this['_skillIDs'][_0x49268e])return this['_skillIDs'][_0x49268e];for(const _0x3b0079 of $dataSkills){if(!_0x3b0079)continue;this[_0x48dc47(0x1f0)][_0x3b0079[_0x48dc47(0x321)]['toUpperCase']()[_0x48dc47(0x651)]()]=_0x3b0079['id'];}return this[_0x48dc47(0x1f0)][_0x49268e]||0x0;},DataManager[_0x2dcaec(0xc5a)]=function(_0x1e939a){const _0x1a1960=_0x2dcaec;_0x1e939a=_0x1e939a[_0x1a1960(0xb9f)]()['trim'](),this[_0x1a1960(0x30d)]=this[_0x1a1960(0x30d)]||{};if(this['_enemyIDs'][_0x1e939a])return this['_enemyIDs'][_0x1e939a];for(const _0x20b546 of $dataEnemies){if(!_0x20b546)continue;this[_0x1a1960(0x30d)][_0x20b546[_0x1a1960(0x321)][_0x1a1960(0xb9f)]()[_0x1a1960(0x651)]()]=_0x20b546['id'];}return this[_0x1a1960(0x30d)][_0x1e939a]||0x0;},DataManager[_0x2dcaec(0xac6)]=function(_0x5044e4){const _0x4ad8d0=_0x2dcaec;_0x5044e4=_0x5044e4[_0x4ad8d0(0xb9f)]()[_0x4ad8d0(0x651)](),this[_0x4ad8d0(0x33c)]=this['_wtypeIDs']||{};if(this['_wtypeIDs'][_0x5044e4])return this[_0x4ad8d0(0x33c)][_0x5044e4];for(let _0x3956a6=0x1;_0x3956a6<0x64;_0x3956a6++){if(!$dataSystem[_0x4ad8d0(0x670)][_0x3956a6])continue;let _0x346696=$dataSystem[_0x4ad8d0(0x670)][_0x3956a6][_0x4ad8d0(0xb9f)]()['trim']();_0x346696=_0x346696[_0x4ad8d0(0x1d3)](/\x1I\[(\d+)\]/gi,''),_0x346696=_0x346696['replace'](/\\I\[(\d+)\]/gi,''),this[_0x4ad8d0(0x33c)][_0x346696]=_0x3956a6;}return this[_0x4ad8d0(0x33c)][_0x4ad8d0(0x477)]=0x0,this[_0x4ad8d0(0x33c)][_0x5044e4]||0x0;},DataManager[_0x2dcaec(0x376)]=function(_0x807003){const _0xb067e0=_0x2dcaec,_0x2853db=_0xb067e0(0xa8b);let _0x2abaf8=_0x807003[_0xb067e0(0x448)],_0x13357e=_0x807003['name'];const _0x5f36f3=_0x807003[_0xb067e0(0x795)];return _0x5f36f3[_0xb067e0(0xb9e)](/<DISPLAY ICON: (\d+)>/i)&&(_0x2abaf8=Number(RegExp['$1'])),_0x5f36f3[_0xb067e0(0xb9e)](/<DISPLAY TEXT: (.*)>/i)&&(_0x13357e=String(RegExp['$1'])),_0x2853db[_0xb067e0(0xb60)](_0x2abaf8,_0x13357e);},DataManager[_0x2dcaec(0x7b6)]=function(_0xe4cf8){const _0x24e43d=_0x2dcaec;return _0xe4cf8[_0x24e43d(0x795)][_0x24e43d(0xb9e)](/<COMMAND TEXT: (.*)>/i)?String(RegExp['$1']):_0xe4cf8[_0x24e43d(0x321)];},DataManager[_0x2dcaec(0x8ad)]=function(_0x3a70db){const _0x2cc6fe=_0x2dcaec;return _0x3a70db[_0x2cc6fe(0x795)][_0x2cc6fe(0xb9e)](/<COMMAND ICON: (\d+)>/i)?Number(RegExp['$1']):_0x3a70db[_0x2cc6fe(0x448)];},DataManager[_0x2dcaec(0x6cd)]=function(_0x291b73){const _0x1faac5=_0x2dcaec,_0x2cdfde=$dataEnemies[_0x291b73];if(_0x2cdfde){if(_0x2cdfde['note'][_0x1faac5(0xb9e)](/<SWAP ENEMIES>\s*([\s\S]*)\s*<\/SWAP ENEMIES>/i)){const _0x2f7084=String(RegExp['$1'])[_0x1faac5(0x13b)](/[\r\n]+/)[_0x1faac5(0xb8d)](''),_0x142920=this[_0x1faac5(0x3ae)](_0x2f7084);_0x291b73=this[_0x1faac5(0xc5a)](_0x142920)||_0x291b73,_0x291b73=DataManager[_0x1faac5(0x6cd)](_0x291b73);}}return _0x291b73;},DataManager[_0x2dcaec(0x3ae)]=function(_0x2973e0){const _0x1d068a=_0x2dcaec;let _0x465604=0x0;const _0x12d047={};for(const _0x52f5ff of _0x2973e0){if(_0x52f5ff['match'](/(.*):[ ](\d+)/i)){const _0x6bc7ac=String(RegExp['$1'])[_0x1d068a(0x651)](),_0x335f04=Number(RegExp['$2']);_0x12d047[_0x6bc7ac]=_0x335f04,_0x465604+=_0x335f04;}else{if(_0x52f5ff[_0x1d068a(0xb9e)](/(.*):[ ](\d+\.?\d+)/i)){const _0x442d8d=String(RegExp['$1'])[_0x1d068a(0x651)](),_0x50b8d2=Number(RegExp['$2']);_0x12d047[_0x442d8d]=_0x50b8d2,_0x465604+=_0x50b8d2;}else _0x52f5ff!==''&&(_0x12d047[_0x52f5ff]=0x1,_0x465604++);}}if(_0x465604<=0x0)return'';let _0x597b50=Math[_0x1d068a(0x7af)]()*_0x465604;for(const _0x5effb3 in _0x12d047){_0x597b50-=_0x12d047[_0x5effb3];if(_0x597b50<=0x0)return _0x5effb3;}return'';},DataManager[_0x2dcaec(0xb75)]=function(_0x2045b2){const _0x4088da=_0x2dcaec;if(!_0x2045b2)return![];if(!VisuMZ[_0x4088da(0xae3)][_0x4088da(0xbeb)][_0x4088da(0x709)][_0x4088da(0x96c)])return![];if(_0x2045b2['note'][_0x4088da(0xb9e)](/<AUTO ACTION SEQUENCE>/i))return![];if(_0x2045b2[_0x4088da(0x795)][_0x4088da(0xb9e)](/<COMMON (?:EVENT|EVENTS):[ ](.*)>/gi))return!![];for(const _0x247e81 of _0x2045b2[_0x4088da(0xb29)]){if(!_0x247e81)continue;if(_0x247e81['code']===Game_Action['EFFECT_COMMON_EVENT'])return!![];}return![];},DataManager[_0x2dcaec(0x2f7)]=function(_0x14ddd2){const _0x36bd05=_0x2dcaec,_0x3b75b1=$dataTroops[_0x14ddd2];if(!_0x3b75b1)return'';let _0x43d3c3='';_0x43d3c3+=_0x3b75b1[_0x36bd05(0x321)];for(const _0x3c7707 of _0x3b75b1['pages']){for(const _0x43f2db of _0x3c7707[_0x36bd05(0x97c)]){[0x6c,0x198][_0x36bd05(0x7f2)](_0x43f2db[_0x36bd05(0x812)])&&(_0x43d3c3+='\x0a',_0x43d3c3+=_0x43f2db[_0x36bd05(0x718)][0x0]);}}return _0x43d3c3;},ConfigManager[_0x2dcaec(0x7ff)]=ConfigManager[_0x2dcaec(0x7ff)]??![],ConfigManager[_0x2dcaec(0xbe9)]=ConfigManager[_0x2dcaec(0xbe9)]??![],ConfigManager[_0x2dcaec(0x4ce)]=ConfigManager[_0x2dcaec(0x4ce)]??!![],VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0xbe8)]=ConfigManager[_0x2dcaec(0x13f)],ConfigManager[_0x2dcaec(0x13f)]=function(){const _0x7d5f2b=_0x2dcaec,_0x17f635=VisuMZ[_0x7d5f2b(0xae3)][_0x7d5f2b(0xbe8)]['call'](this);return _0x17f635[_0x7d5f2b(0x7ff)]=this[_0x7d5f2b(0x7ff)],_0x17f635['autoBattleUseSkills']=this[_0x7d5f2b(0xbe9)],_0x17f635[_0x7d5f2b(0x4ce)]=this[_0x7d5f2b(0x4ce)],_0x17f635;},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x9bf)]=ConfigManager[_0x2dcaec(0x9b6)],ConfigManager[_0x2dcaec(0x9b6)]=function(_0x52c09d){const _0x9f9508=_0x2dcaec;VisuMZ[_0x9f9508(0xae3)]['ConfigManager_applyData'][_0x9f9508(0x390)](this,_0x52c09d),_0x9f9508(0x7ff)in _0x52c09d?this['autoBattleAtStart']=_0x52c09d[_0x9f9508(0x7ff)]:this['autoBattleAtStart']=![],_0x9f9508(0xbe9)in _0x52c09d?this[_0x9f9508(0xbe9)]=_0x52c09d[_0x9f9508(0xbe9)]:this[_0x9f9508(0xbe9)]=![],_0x9f9508(0x4ce)in _0x52c09d?this[_0x9f9508(0x4ce)]=_0x52c09d[_0x9f9508(0x4ce)]:this[_0x9f9508(0x4ce)]=!![];},ImageManager[_0x2dcaec(0x890)]=ImageManager[_0x2dcaec(0x890)]||0x9,ImageManager['svActorVertCells']=ImageManager[_0x2dcaec(0x4b8)]||0x6,VisuMZ['BattleCore'][_0x2dcaec(0x9a9)]=BattleManager[_0x2dcaec(0xb15)],BattleManager[_0x2dcaec(0xb15)]=function(_0x2bfdcd,_0xe11894,_0x46bd94){const _0x2fd7ea=_0x2dcaec;VisuMZ[_0x2fd7ea(0xae3)][_0x2fd7ea(0x9a9)][_0x2fd7ea(0x390)](this,_0x2bfdcd,_0xe11894,_0x46bd94),this[_0x2fd7ea(0xb64)]={};},VisuMZ[_0x2dcaec(0xae3)]['BattleManager_initMembers']=BattleManager[_0x2dcaec(0xaab)],BattleManager[_0x2dcaec(0xaab)]=function(){const _0x3ed822=_0x2dcaec;VisuMZ[_0x3ed822(0xae3)][_0x3ed822(0x927)][_0x3ed822(0x390)](this),this[_0x3ed822(0x9f8)]=[];},BattleManager[_0x2dcaec(0xbac)]=function(){const _0x1020e6=_0x2dcaec;$subject=this['_subject'],$targets=this[_0x1020e6(0xa28)],$target=this[_0x1020e6(0xc39)]||this['_targets'][this[_0x1020e6(0xc26)]||0x0];},BattleManager[_0x2dcaec(0xc7b)]=function(){const _0x1bbcd0=_0x2dcaec;if(!SceneManager[_0x1bbcd0(0xa2b)]())return;const _0x74307b=SceneManager[_0x1bbcd0(0x496)][_0x1bbcd0(0x300)];if(_0x74307b)_0x74307b['requestRefresh']();},BattleManager['battleSys']=function(){const _0x2df873=_0x2dcaec;if(BattleManager[_0x2df873(0x17f)]())return'TPB';return'DTB';},BattleManager[_0x2dcaec(0x8ab)]=function(_0x57a43e){const _0x19d401=_0x2dcaec;return _0x57a43e=_0x57a43e[_0x19d401(0xb9f)]()[_0x19d401(0x651)](),this['battleSys']()===_0x57a43e;},BattleManager[_0x2dcaec(0x98a)]=function(){const _0x3c81f3=_0x2dcaec;return this[_0x3c81f3(0x8ab)]('DTB');},BattleManager['isTurnBased']=function(){const _0x282c87=_0x2dcaec;return this[_0x282c87(0x98a)]();},BattleManager[_0x2dcaec(0x5ec)]=function(){const _0x32d06a=_0x2dcaec;return!this[_0x32d06a(0x921)]();},BattleManager[_0x2dcaec(0x1cb)]=function(){const _0x3cb163=_0x2dcaec;return!this['isTurnBased']()&&!this[_0x3cb163(0x5ec)]();},BattleManager[_0x2dcaec(0x501)]=function(_0x2bb574){const _0x52753d=_0x2dcaec;this[_0x52753d(0xb64)]=this['_battlerKeyCache']||{};if(this[_0x52753d(0xb64)][_0x2bb574]!==undefined)return this['_battlerKeyCache'][_0x2bb574];this[_0x52753d(0xb64)][_0x2bb574]=null;const _0x12647e=this[_0x52753d(0xb96)](),_0x3842c5=_0x12647e['find'](_0x2b0044=>_0x2b0044['battlerKey']()===_0x2bb574);if(_0x3842c5)this['_battlerKeyCache'][_0x2bb574]=_0x3842c5;return this['_battlerKeyCache'][_0x2bb574];},Game_BattlerBase[_0x2dcaec(0xaf6)][_0x2dcaec(0x233)]=function(){const _0xbb251d=_0x2dcaec;return _0xbb251d(0x1d6)[_0xbb251d(0xb60)](this[_0xbb251d(0x8d6)]()?_0xbb251d(0x3fc):'enemy',this[_0xbb251d(0x321)]()+'-'+(this[_0xbb251d(0x8d6)]()?this[_0xbb251d(0x8f3)]():this[_0xbb251d(0x6fc)]()));},Game_Action['prototype'][_0x2dcaec(0x200)]=function(_0x2250a3){const _0x388752=_0x2dcaec;if(this[_0x388752(0x274)]!=='')return;typeof _0x2250a3==='string'?this['_targetBattlerKey']=_0x2250a3['toLowerCase']()[_0x388752(0x651)]():this[_0x388752(0x274)]=_0x2250a3[_0x388752(0x233)]();},Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x325)]=function(){const _0x1cda0c=_0x2dcaec;return[this[_0x1cda0c(0x5c1)]()];},Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x5c1)]=function(){const _0xf7c0ff=_0x2dcaec,_0x1f9fd5=this[_0xf7c0ff(0x274)]||'',_0x588c20=BattleManager['getBattlerFromKey'](_0x1f9fd5);if(!_0x588c20)return this[_0xf7c0ff(0x748)]();if(!_0x588c20[_0xf7c0ff(0x2b5)]())return this[_0xf7c0ff(0x748)]();return _0x588c20;},Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x748)]=function(){const _0x45780a=_0x2dcaec,_0x5482dd=this[_0x45780a(0x274)];return _0x5482dd[_0x45780a(0xb9e)](/ACTOR/i)?this[_0x45780a(0x630)]()[_0x45780a(0xada)]():this[_0x45780a(0x2f2)]()[_0x45780a(0xada)]();},BattleManager[_0x2dcaec(0x78c)]=function(){const _0x1d922d=_0x2dcaec;return this['allBattleMembers']()[_0x1d922d(0x5ed)](_0x359750=>_0x359750[_0x1d922d(0x72c)]());},BattleManager['processBattleCoreJS']=function(_0x3299c5){const _0x37017f=_0x2dcaec;_0x3299c5===_0x37017f(0xa62)&&(this['_endingBattle']=!![]),$gameParty[_0x37017f(0xbd1)](_0x3299c5),$gameTroop[_0x37017f(0xbd1)](_0x3299c5);},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x22b)]=BattleManager[_0x2dcaec(0x453)],BattleManager[_0x2dcaec(0x453)]=function(){const _0x40e836=_0x2dcaec;this['_endBattle']=![],this[_0x40e836(0x91c)]=ConfigManager['autoBattleAtStart'],this['_endingBattle']=![],this[_0x40e836(0xbd1)](_0x40e836(0x9ad)),VisuMZ[_0x40e836(0xae3)]['BattleManager_startBattle']['call'](this),this[_0x40e836(0xbd1)](_0x40e836(0xa53));},BattleManager['processPostBattleCommonEvents']=function(_0x520e46){const _0x472e58=_0x2dcaec,_0x2fbd5b=VisuMZ['BattleCore'][_0x472e58(0xbeb)]['Mechanics'];_0x520e46!==_0x472e58(0x4da)&&_0x2fbd5b[_0x472e58(0x8fa)]&&VisuMZ['BattleCore']['CheckMapBattleEventValid'](_0x2fbd5b[_0x472e58(0x8fa)])&&$gameTemp[_0x472e58(0x72f)](_0x2fbd5b['BattleEndEvent']);const _0x54d395=_0x472e58(0xbcd)[_0x472e58(0xb60)](_0x520e46);_0x2fbd5b[_0x54d395]&&VisuMZ[_0x472e58(0xae3)][_0x472e58(0x53b)](_0x2fbd5b[_0x54d395])&&$gameTemp['reserveCommonEvent'](_0x2fbd5b[_0x54d395]);},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x616)]=BattleManager[_0x2dcaec(0x168)],BattleManager[_0x2dcaec(0x168)]=function(){const _0x16cab4=_0x2dcaec;VisuMZ['BattleCore'][_0x16cab4(0x616)]['call'](this),SceneManager['isSceneBattle']()&&BattleManager[_0x16cab4(0x6a7)]();},VisuMZ['BattleCore'][_0x2dcaec(0x548)]=BattleManager['checkBattleEnd'],BattleManager['checkBattleEnd']=function(){const _0x174acf=_0x2dcaec;if(this[_0x174acf(0x584)]===_0x174acf(0x5d3)){if($gameTemp[_0x174acf(0x29c)]())return![];}return VisuMZ['BattleCore'][_0x174acf(0x548)]['call'](this);},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x350)]=BattleManager['processVictory'],BattleManager['processVictory']=function(){const _0x12dc59=_0x2dcaec;this[_0x12dc59(0x4a7)]=!![],this[_0x12dc59(0xbd1)](_0x12dc59(0xa62)),VisuMZ['BattleCore'][_0x12dc59(0x350)][_0x12dc59(0x390)](this),this['processPostBattleCommonEvents'](_0x12dc59(0x572));},VisuMZ[_0x2dcaec(0xae3)]['BattleManager_processAbort']=BattleManager[_0x2dcaec(0x930)],BattleManager['processAbort']=function(){const _0x2fdcb7=_0x2dcaec;this['_endingBattle']=!![],VisuMZ[_0x2fdcb7(0xae3)]['BattleManager_processAbort']['call'](this);},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0xc57)]=BattleManager[_0x2dcaec(0x2e7)],BattleManager['processDefeat']=function(){const _0x4636cb=_0x2dcaec;this['_endingBattle']=!![],this['processBattleCoreJS'](_0x4636cb(0x3b7)),VisuMZ[_0x4636cb(0xae3)][_0x4636cb(0xc57)]['call'](this),this[_0x4636cb(0x49a)](_0x4636cb(0x2dc));},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x2f4)]=BattleManager[_0x2dcaec(0x28a)],BattleManager['endBattle']=function(_0x5c18ca){const _0x291efd=_0x2dcaec;this[_0x291efd(0x434)]=!![],this[_0x291efd(0x91c)]=![],this[_0x291efd(0xbd1)](_0x291efd(0x61e)),VisuMZ[_0x291efd(0xae3)][_0x291efd(0x2f4)][_0x291efd(0x390)](this,_0x5c18ca),this[_0x291efd(0xbd1)](_0x291efd(0x227));},VisuMZ['BattleCore'][_0x2dcaec(0x903)]=BattleManager[_0x2dcaec(0x749)],BattleManager[_0x2dcaec(0x749)]=function(){const _0x2645dd=_0x2dcaec;if(this[_0x2645dd(0x921)]())this[_0x2645dd(0xbd1)](_0x2645dd(0x892));VisuMZ[_0x2645dd(0xae3)][_0x2645dd(0x903)]['call'](this);if(this[_0x2645dd(0x921)]())this[_0x2645dd(0xbd1)]('PostStartTurnJS');},BattleManager['processTurn']=function(){const _0xe74c2e=_0x2dcaec,_0xa7f3bf=this[_0xe74c2e(0x173)],_0x374543=_0xa7f3bf[_0xe74c2e(0x3ab)]();_0x374543?(_0x374543['prepare'](),_0x374543['isValid']()?(this[_0xe74c2e(0xa42)](),_0xa7f3bf[_0xe74c2e(0x5e3)]()):(_0xa7f3bf[_0xe74c2e(0x5e3)](),this[_0xe74c2e(0x773)]())):(this['endAction'](),this['_subject']=null);},VisuMZ[_0x2dcaec(0xae3)]['BattleManager_startAction']=BattleManager['startAction'],BattleManager['startAction']=function(){const _0x25be08=_0x2dcaec,_0x531526=this['_subject'][_0x25be08(0x3ab)](),_0x4648fc=this[_0x25be08(0x173)];_0x531526&&_0x531526['subject']()===_0x4648fc&&_0x531526[_0x25be08(0x6f1)]('PreStartActionJS'),VisuMZ[_0x25be08(0xae3)][_0x25be08(0x99a)][_0x25be08(0x390)](this),_0x531526&&_0x531526[_0x25be08(0xafb)]()===_0x4648fc&&_0x531526['actionBattleCoreJS'](_0x25be08(0x3ac));},VisuMZ['BattleCore'][_0x2dcaec(0x261)]=BattleManager['endAction'],BattleManager['endAction']=function(){const _0xa9f472=_0x2dcaec,_0x4dcd71=this[_0xa9f472(0x151)],_0x56486e=this[_0xa9f472(0x173)];_0x4dcd71&&_0x4dcd71!==this[_0xa9f472(0x546)]&&_0x4dcd71[_0xa9f472(0xafb)]()===_0x56486e&&_0x4dcd71[_0xa9f472(0x6f1)](_0xa9f472(0xa89)),this[_0xa9f472(0x173)]?VisuMZ[_0xa9f472(0xae3)]['BattleManager_endAction'][_0xa9f472(0x390)](this):this[_0xa9f472(0x584)]=_0xa9f472(0x5d3),_0x4dcd71&&_0x4dcd71!==this[_0xa9f472(0x546)]&&_0x4dcd71['subject']()===_0x56486e&&_0x4dcd71[_0xa9f472(0x6f1)]('PostEndActionJS'),this[_0xa9f472(0xbde)](this[_0xa9f472(0xb96)]()),this[_0xa9f472(0x546)]=this[_0xa9f472(0x151)];},BattleManager['refreshBattlerMotions']=function(_0x3763d9){const _0x8a4b48=_0x2dcaec;for(const _0x418d1b of _0x3763d9){if(!_0x418d1b)continue;if(!_0x418d1b[_0x8a4b48(0xbc2)]())continue;_0x418d1b['battler']()[_0x8a4b48(0x5a4)]();}},BattleManager[_0x2dcaec(0x7e0)]=function(){const _0x71ed81=_0x2dcaec;!this[_0x71ed81(0x9a7)][_0x71ed81(0x4c7)]()&&this['endAction']();},Game_Battler[_0x2dcaec(0xaf6)][_0x2dcaec(0x248)]=function(){const _0xbbc0fa=_0x2dcaec;this[_0xbbc0fa(0x85f)]();if(Imported[_0xbbc0fa(0xb3c)]){const _0x3f83ae=VisuMZ[_0xbbc0fa(0xc24)][_0xbbc0fa(0xbeb)][_0xbbc0fa(0x403)];_0x3f83ae&&_0x3f83ae[_0xbbc0fa(0x1a3)]===![]&&this[_0xbbc0fa(0x36f)](0x1);}else this['removeStatesAuto'](0x1);this['removeBuffsAuto']();},VisuMZ['BattleCore'][_0x2dcaec(0x1d5)]=BattleManager[_0x2dcaec(0x70d)],BattleManager['invokeCounterAttack']=function(_0x97675f,_0x4feaae){const _0x54e196=_0x2dcaec;this[_0x54e196(0xc7e)]=!![],VisuMZ['BattleCore']['BattleManager_invokeCounterAttack'][_0x54e196(0x390)](this,_0x97675f,_0x4feaae),this[_0x54e196(0xc7e)]=undefined;},BattleManager[_0x2dcaec(0x3ca)]=function(){const _0x2f2eab=_0x2dcaec;this[_0x2f2eab(0x9f1)]=VisuMZ[_0x2f2eab(0xae3)][_0x2f2eab(0xbeb)][_0x2f2eab(0x41e)]['CalcEscapeRatioJS'][_0x2f2eab(0x390)](this);},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x606)]=BattleManager[_0x2dcaec(0x778)],BattleManager[_0x2dcaec(0x778)]=function(){const _0x31822d=_0x2dcaec;this[_0x31822d(0xbd1)](_0x31822d(0x578)),BattleManager[_0x31822d(0x2a3)][_0x31822d(0x84c)](),VisuMZ[_0x31822d(0xae3)][_0x31822d(0x606)]['call'](this),this['processPostBattleCommonEvents'](_0x31822d(0x5eb));},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x6c3)]=BattleManager[_0x2dcaec(0x54e)],BattleManager[_0x2dcaec(0x54e)]=function(){const _0x335b37=_0x2dcaec;this[_0x335b37(0xbd1)]('EscapeFailureJS');const _0x11a0aa=this[_0x335b37(0x9f1)];VisuMZ['BattleCore'][_0x335b37(0x6c3)][_0x335b37(0x390)](this),this[_0x335b37(0x9f1)]=_0x11a0aa+VisuMZ[_0x335b37(0xae3)][_0x335b37(0xbeb)]['Mechanics'][_0x335b37(0x80f)]['call'](this),this[_0x335b37(0x4b9)]=![],this[_0x335b37(0x49a)](_0x335b37(0x4da));},BattleManager[_0x2dcaec(0x3c3)]=function(){const _0x42725e=_0x2dcaec;let _0x2732df=![];if(this[_0x42725e(0x6b2)]())for(const _0x437985 of $gameTroop[_0x42725e(0x8b0)]()){this[_0x42725e(0x9a7)][_0x42725e(0x190)](_0x42725e(0x59f),TextManager[_0x42725e(0x232)][_0x42725e(0xb60)](_0x437985)),this[_0x42725e(0x9a7)][_0x42725e(0x190)](_0x42725e(0x275)),_0x2732df=!![];}if(this[_0x42725e(0xb48)])this['_logWindow'][_0x42725e(0x190)](_0x42725e(0x59f),TextManager[_0x42725e(0x219)][_0x42725e(0xb60)]($gameParty['name']())),this[_0x42725e(0x9a7)][_0x42725e(0x190)]('wait');else this[_0x42725e(0xc1a)]&&(this['_logWindow'][_0x42725e(0x190)]('addText',TextManager[_0x42725e(0xc22)][_0x42725e(0xb60)]($gameParty[_0x42725e(0x321)]())),this[_0x42725e(0x9a7)][_0x42725e(0x190)]('wait'));_0x2732df&&(this['_logWindow'][_0x42725e(0x190)](_0x42725e(0x275)),this[_0x42725e(0x9a7)][_0x42725e(0x190)](_0x42725e(0xb7e))),this['isTpb']()&&this[_0x42725e(0x73f)]()&&(this[_0x42725e(0x4f9)]=![]);},BattleManager[_0x2dcaec(0x6b2)]=function(){const _0x263124=_0x2dcaec;if(BattleManager[_0x263124(0x91c)])return![];return VisuMZ[_0x263124(0xae3)][_0x263124(0xbeb)][_0x263124(0xc36)][_0x263124(0xba5)];},VisuMZ['BattleCore']['BattleManager_startInput']=BattleManager[_0x2dcaec(0xc72)],BattleManager[_0x2dcaec(0xc72)]=function(){const _0x4a9cfe=_0x2dcaec;VisuMZ[_0x4a9cfe(0xae3)][_0x4a9cfe(0x1c8)]['call'](this),this[_0x4a9cfe(0x98a)]()&&this[_0x4a9cfe(0x73f)]()&&!this[_0x4a9cfe(0xc1a)]&&$gameParty[_0x4a9cfe(0xc01)]()&&this['selectNextCommand']();},BattleManager['isSkipPartyCommandWindow']=function(){const _0x24fbf2=_0x2dcaec;return VisuMZ[_0x24fbf2(0xae3)][_0x24fbf2(0xbeb)][_0x24fbf2(0x586)]['SkipPartyCmd'];},BattleManager[_0x2dcaec(0x34b)]=function(){const _0x10cb6b=_0x2dcaec;this['isPartyTpbInputtable']()&&this[_0x10cb6b(0x66c)]();},VisuMZ['BattleCore'][_0x2dcaec(0x463)]=Scene_Battle[_0x2dcaec(0xaf6)][_0x2dcaec(0x287)],Scene_Battle[_0x2dcaec(0xaf6)][_0x2dcaec(0x287)]=function(){const _0x42cdb4=_0x2dcaec;VisuMZ[_0x42cdb4(0xae3)][_0x42cdb4(0x463)][_0x42cdb4(0x390)](this),BattleManager[_0x42cdb4(0x17f)]()&&BattleManager[_0x42cdb4(0x4f9)]&&(BattleManager[_0x42cdb4(0x4f9)]=![],this[_0x42cdb4(0xac0)]());},BattleManager['emulateAction']=function(_0x7ee23e,_0x4673ff,_0x2807c1){const _0x2a0fbe=_0x2dcaec;if(!_0x2807c1)return;if(!_0x7ee23e)return;if(!_0x4673ff)return;const _0x2ce761=this[_0x2a0fbe(0x151)];this[_0x2a0fbe(0x151)]=new Game_Action(_0x7ee23e);if(DataManager[_0x2a0fbe(0x408)](_0x2807c1))this['_action'][_0x2a0fbe(0x235)](_0x2807c1['id']);if(DataManager[_0x2a0fbe(0x37d)](_0x2807c1))this[_0x2a0fbe(0x151)][_0x2a0fbe(0xa16)](_0x2807c1['id']);if(this[_0x2a0fbe(0x151)][_0x2a0fbe(0x719)]())BattleManager[_0x2a0fbe(0x254)](_0x7ee23e,_0x4673ff);this[_0x2a0fbe(0x151)]=_0x2ce761;},BattleManager[_0x2dcaec(0x1c7)]=function(_0x19eece,_0x32e902){const _0x1bbf44=_0x2dcaec;this[_0x1bbf44(0x151)][_0x1bbf44(0xaf4)]=_0x32e902,this[_0x1bbf44(0x9a7)][_0x1bbf44(0x71b)](_0x32e902),this[_0x1bbf44(0x9a7)][_0x1bbf44(0x913)](_0x19eece,this[_0x1bbf44(0x151)]),this[_0x1bbf44(0x151)][_0x1bbf44(0xb68)](_0x19eece),this[_0x1bbf44(0x9a7)][_0x1bbf44(0x58f)](_0x19eece,_0x19eece);},VisuMZ[_0x2dcaec(0xae3)]['BattleManager_makeActionOrders']=BattleManager[_0x2dcaec(0x37e)],BattleManager[_0x2dcaec(0x37e)]=function(){const _0x47b276=_0x2dcaec;VisuMZ[_0x47b276(0xae3)][_0x47b276(0x95c)]['call'](this),this[_0x47b276(0x43e)]=this[_0x47b276(0x43e)]['filter'](_0x4c4e93=>_0x4c4e93&&_0x4c4e93['isAppeared']());},VisuMZ[_0x2dcaec(0xae3)]['BattleManager_updatePhase']=BattleManager[_0x2dcaec(0x1af)],BattleManager[_0x2dcaec(0x1af)]=function(_0x26a40b){const _0x24e611=_0x2dcaec;if(this['_phase']==='custom')this['updateCustomActionSequence']();else this['_phase']==='forceAction'?this[_0x24e611(0x825)]():VisuMZ[_0x24e611(0xae3)]['BattleManager_updatePhase']['call'](this,_0x26a40b);},BattleManager['prepareCustomActionSequence']=function(){const _0x1cad0b=_0x2dcaec;this['_allTargets']=this[_0x1cad0b(0xa28)][_0x1cad0b(0xa5e)](0x0),this[_0x1cad0b(0xc26)]=0x0,this[_0x1cad0b(0xc39)]=this['_allTargets'][0x0]||null,this[_0x1cad0b(0x584)]=_0x1cad0b(0xa81);},BattleManager[_0x2dcaec(0x398)]=function(){const _0x1d5da5=_0x2dcaec;!this[_0x1d5da5(0x95d)]()&&!this[_0x1d5da5(0x9a7)]['isBusy']()&&(this['_phase']='action');},BattleManager[_0x2dcaec(0x713)]=function(_0x4c9a86){const _0xd99df3=_0x2dcaec;this[_0xd99df3(0x43e)][_0xd99df3(0xb8d)](_0x4c9a86);if(_0x4c9a86===this[_0xd99df3(0x173)])return;const _0x27afda=JsonEx[_0xd99df3(0xa12)](_0x4c9a86[_0xd99df3(0x3ab)]());this[_0xd99df3(0x9f8)][_0xd99df3(0x190)]([_0x4c9a86,_0x27afda]);},BattleManager[_0x2dcaec(0x4fd)]=function(){},BattleManager['updateStart']=function(){const _0x5ce788=_0x2dcaec;if(this['isTpb']())this[_0x5ce788(0x584)]=_0x5ce788(0x5d3);else this[_0x5ce788(0x9f8)][_0x5ce788(0x7ce)]>0x0?this[_0x5ce788(0x584)]=_0x5ce788(0x5d3):this[_0x5ce788(0xc72)]();},BattleManager['getNextSubject']=function(){const _0x24a135=_0x2dcaec,_0x986c8f=this[_0x24a135(0x173)];_0x986c8f&&this['isTpb']()&&_0x986c8f['setActionState']('undecided');for(;;){const _0x5965dc=this['getNextSubjectFromPool']();if(!_0x5965dc)return null;if(_0x5965dc[_0x24a135(0x19e)]()&&_0x5965dc[_0x24a135(0x2b5)]())return _0x5965dc;}},BattleManager['getNextSubjectFromPool']=function(){const _0xd76499=_0x2dcaec;if(this[_0xd76499(0x9f8)][_0xd76499(0x7ce)]>0x0){const _0x2829c0=this[_0xd76499(0x9f8)]['shift'](),_0x317b28=_0x2829c0[0x0];return _0x317b28[_0xd76499(0xaa2)]=_0x317b28[_0xd76499(0xaa2)]||[],_0x317b28[_0xd76499(0xaa2)][0x0]=_0x2829c0[0x1],_0x317b28;}else return this[_0xd76499(0x43e)][_0xd76499(0xa0f)]();},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x35f)]=Game_Battler[_0x2dcaec(0xaf6)][_0x2dcaec(0x713)],Game_Battler['prototype'][_0x2dcaec(0x713)]=function(_0x5100da,_0x4b0fde){const _0x38e077=_0x2dcaec;VisuMZ[_0x38e077(0xae3)]['Game_Battler_forceAction']['call'](this,_0x5100da,_0x4b0fde),this[_0x38e077(0xaa2)][this[_0x38e077(0xaa2)][_0x38e077(0x7ce)]-0x1][_0x38e077(0x206)]=!![];},Game_Interpreter[_0x2dcaec(0xaf6)][_0x2dcaec(0x947)]=function(_0x5e7bb8){const _0x33ea9a=_0x2dcaec;return this[_0x33ea9a(0x5cf)](_0x5e7bb8[0x0],_0x5e7bb8[0x1],_0x51b1fe=>{const _0x2f91ec=_0x33ea9a;!_0x51b1fe['isDeathStateAffected']()&&(_0x51b1fe[_0x2f91ec(0x713)](_0x5e7bb8[0x2],_0x5e7bb8[0x3]),BattleManager['forceAction'](_0x51b1fe));}),!![];},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0xa71)]=Game_Battler[_0x2dcaec(0xaf6)][_0x2dcaec(0x79a)],Game_Battler[_0x2dcaec(0xaf6)][_0x2dcaec(0x79a)]=function(){const _0x4d9007=_0x2dcaec;VisuMZ['BattleCore']['Game_Battler_makeSpeed']['call'](this),this[_0x4d9007(0xaa2)][_0x4d9007(0x7ce)]<=0x0&&(this[_0x4d9007(0x671)]=Number[_0x4d9007(0x833)]);},BattleManager['shouldHideBattleEndPopups']=function(){const _0x34de71=_0x2dcaec;if(VisuMZ['BattleCore']['Settings'][_0x34de71(0x53c)]['EndBattlePopups']??!![])return![];return SceneManager[_0x34de71(0xa2b)]()&&this['_endingBattle'];},VisuMZ['BattleCore'][_0x2dcaec(0xa38)]=BattleManager[_0x2dcaec(0x66c)],BattleManager[_0x2dcaec(0x66c)]=function(){const _0x301a29=_0x2dcaec;this[_0x301a29(0x17f)]()?this[_0x301a29(0x6a8)]():VisuMZ[_0x301a29(0xae3)][_0x301a29(0xa38)][_0x301a29(0x390)](this);},BattleManager[_0x2dcaec(0x6a8)]=function(){const _0x4e9918=_0x2dcaec;if(this[_0x4e9918(0xc49)]){if(this[_0x4e9918(0xc49)][_0x4e9918(0x66c)]())return;this[_0x4e9918(0xbf5)](),this[_0x4e9918(0xa25)](),!this[_0x4e9918(0x173)]&&!this['_currentActor']&&SceneManager[_0x4e9918(0x496)][_0x4e9918(0x2a2)]();}else!this['_subject']&&this['selectNextActor']();},BattleManager[_0x2dcaec(0xa25)]=function(){const _0x5b2398=_0x2dcaec;(!this['isPartyTpbInputtable']()||this['needsActorInputCancel']())&&(this['_tpbSceneChangeCacheActor']&&(!$gameParty['battleMembers']()['includes'](this[_0x5b2398(0x8e2)])&&(this[_0x5b2398(0x8e2)]=null)),!this['_tpbSceneChangeCacheActor']?(this[_0x5b2398(0x3e4)](),this[_0x5b2398(0xc49)]=null,this[_0x5b2398(0x4b9)]=![]):this['revertTpbCachedActor']());},BattleManager[_0x2dcaec(0xa54)]=function(){const _0x3fdfa9=_0x2dcaec;!$gameParty['battleMembers']()[_0x3fdfa9(0x7f2)](this[_0x3fdfa9(0x8e2)])&&(this[_0x3fdfa9(0x8e2)]=null),this[_0x3fdfa9(0x8e2)]?(this['_currentActor']=this['_tpbSceneChangeCacheActor'],this[_0x3fdfa9(0xc49)][_0x3fdfa9(0x36b)]=_0x3fdfa9(0x55a),this[_0x3fdfa9(0x4b9)]=!![],this[_0x3fdfa9(0x8e2)]=null):(this['cancelActorInput'](),this[_0x3fdfa9(0xc49)]=null,this[_0x3fdfa9(0x4b9)]=![]);},VisuMZ[_0x2dcaec(0xae3)]['BattleManager_isTpbMainPhase']=BattleManager[_0x2dcaec(0x4b4)],BattleManager['isTpbMainPhase']=function(){const _0x249d15=_0x2dcaec;return this[_0x249d15(0x584)]==='custom'?this[_0x249d15(0xb1e)]():VisuMZ[_0x249d15(0xae3)][_0x249d15(0xbed)][_0x249d15(0x390)](this);},BattleManager[_0x2dcaec(0xb1e)]=function(){const _0x53ab65=_0x2dcaec;return this[_0x53ab65(0x9b0)]();},VisuMZ['BattleCore']['BattleManager_cancelActorInput']=BattleManager['cancelActorInput'],BattleManager[_0x2dcaec(0x3e4)]=function(){const _0x128f2d=_0x2dcaec;this['isTpb']()&&this[_0x128f2d(0x584)]===_0x128f2d(0xb71)&&(this[_0x128f2d(0xc49)]=null),VisuMZ[_0x128f2d(0xae3)][_0x128f2d(0x956)][_0x128f2d(0x390)](this);},VisuMZ[_0x2dcaec(0xae3)]['BattleManager_inputtingAction']=BattleManager[_0x2dcaec(0x524)],BattleManager['inputtingAction']=function(){const _0x2ca0e2=_0x2dcaec,_0x314927=this[_0x2ca0e2(0xc49)];if(_0x314927&&!_0x314927['inputtingAction']()){const _0xd8f954=_0x314927[_0x2ca0e2(0x8cd)];_0x314927[_0x2ca0e2(0xaa2)][_0xd8f954]=new Game_Action(_0x314927);}return VisuMZ['BattleCore'][_0x2ca0e2(0x7ef)][_0x2ca0e2(0x390)](this);},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x52e)]=BattleManager[_0x2dcaec(0xc5b)],BattleManager[_0x2dcaec(0xc5b)]=function(_0x570fea){const _0x7ed7bc=_0x2dcaec;if(this['_action'][_0x7ed7bc(0x25b)]())return![];return VisuMZ[_0x7ed7bc(0xae3)]['BattleManager_checkSubstitute']['call'](this,_0x570fea);},SceneManager['isSceneBattle']=function(){const _0x14536c=_0x2dcaec;return this[_0x14536c(0x496)]&&this[_0x14536c(0x496)][_0x14536c(0x61d)]===Scene_Battle;},SceneManager['isBattleFlipped']=function(){const _0x27676d=_0x2dcaec;return Spriteset_Battle['prototype'][_0x27676d(0x4d3)]();},SceneManager['isPreviousSceneBattleTransitionable']=function(){const _0x47c750=_0x2dcaec;if(SceneManager[_0x47c750(0xc29)](Scene_Options))return!![];return![];},SceneManager[_0x2dcaec(0xbfe)]=function(){if(SceneManager['isNextScene'](Scene_Options))return!![];return![];},SceneManager[_0x2dcaec(0x4e1)]=function(_0xec0065){const _0x202669=_0x2dcaec;if(!SceneManager[_0x202669(0xa2b)]())return!![];const _0x2e45ce=[_0x202669(0x515),_0x202669(0x505),_0x202669(0xbf9)];return _0x2e45ce[_0x202669(0x7f2)](_0xec0065[_0x202669(0x321)]);},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0xa66)]=SceneManager[_0x2dcaec(0x190)],SceneManager[_0x2dcaec(0x190)]=function(_0x51dd6a){const _0x2ebf59=_0x2dcaec;if(!SceneManager[_0x2ebf59(0x4e1)](_0x51dd6a))return this['displayBattleCoreTransitionErrorMsg'](_0x51dd6a);VisuMZ[_0x2ebf59(0xae3)][_0x2ebf59(0xa66)][_0x2ebf59(0x390)](this,_0x51dd6a);},SceneManager[_0x2dcaec(0x231)]=function(_0xce71fb){const _0x4f061c=_0x2dcaec;if(!$gameTemp['isPlaytest']())return;if(this[_0x4f061c(0x905)])return;this[_0x4f061c(0x905)]=!![];let _0x2188cc='';_0x2188cc+=_0x4f061c(0xb8a),_0x2188cc+=_0x4f061c(0x89b)[_0x4f061c(0xb60)](_0xce71fb['name']),alert(_0x2188cc);},VisuMZ[_0x2dcaec(0xae3)]['Game_Temp_initialize']=Game_Temp[_0x2dcaec(0xaf6)]['initialize'],Game_Temp[_0x2dcaec(0xaf6)][_0x2dcaec(0x970)]=function(){const _0x53279a=_0x2dcaec;VisuMZ[_0x53279a(0xae3)][_0x53279a(0xa9f)][_0x53279a(0x390)](this),this[_0x53279a(0x853)]=[];},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x317)]=Game_Temp['prototype'][_0x2dcaec(0x819)],Game_Temp['prototype']['requestAnimation']=function(_0x4cffaa,_0x5ba9b3,_0x2416d7){const _0x501bce=_0x2dcaec;_0x4cffaa=_0x4cffaa[_0x501bce(0x5ed)]((_0xe6ba8,_0x114cb3,_0x5c20e9)=>_0x5c20e9['indexOf'](_0xe6ba8)===_0x114cb3);SceneManager['isSceneBattle']()&&SceneManager[_0x501bce(0x78b)]()&&(_0x2416d7=!_0x2416d7);VisuMZ[_0x501bce(0xae3)][_0x501bce(0x317)][_0x501bce(0x390)](this,_0x4cffaa,_0x5ba9b3,_0x2416d7);SceneManager[_0x501bce(0xa2b)]()&&BattleManager[_0x501bce(0x2a3)][_0x501bce(0xc64)]();for(const _0x10966b of _0x4cffaa){_0x10966b&&_0x10966b[_0x501bce(0x5d1)]&&_0x10966b[_0x501bce(0x5d1)]()&&_0x10966b[_0x501bce(0x237)]();}},Game_Temp['prototype']['setLastPluginCommandInterpreter']=function(_0x30d83f){const _0x49a395=_0x2dcaec;this[_0x49a395(0x1f1)]=_0x30d83f;},Game_Temp[_0x2dcaec(0xaf6)][_0x2dcaec(0x9c5)]=function(){const _0x47cf01=_0x2dcaec;return this[_0x47cf01(0x1f1)];},Game_Temp['prototype']['clearForcedGameTroopSettingsBattleCore']=function(){const _0x39de3d=_0x2dcaec;this[_0x39de3d(0x85d)]=undefined;},Game_Temp[_0x2dcaec(0xaf6)][_0x2dcaec(0x8dc)]=function(_0xc45965){const _0x279d04=_0x2dcaec;$gameMap&&$dataMap&&$dataMap[_0x279d04(0x795)]&&this['parseForcedGameTroopSettingsBattleCore']($dataMap[_0x279d04(0x795)]);const _0x54df17=$dataTroops[_0xc45965];if(_0x54df17){let _0x4b0a49=DataManager['createTroopNote'](_0x54df17['id']);this['parseForcedGameTroopSettingsBattleCore'](_0x4b0a49);}},Game_Temp[_0x2dcaec(0xaf6)][_0x2dcaec(0x98e)]=function(_0x37b42b){const _0x280652=_0x2dcaec;if(!_0x37b42b)return;if(_0x37b42b[_0x280652(0xb9e)](/<(?:BATTLELAYOUT|BATTLE LAYOUT|LAYOUT):[ ](.*?)>/i)){const _0x229f1b=String(RegExp['$1']);if(_0x229f1b['match'](/DEFAULT/i))this[_0x280652(0x85d)]=_0x280652(0x30e);else{if(_0x229f1b[_0x280652(0xb9e)](/LIST/i))this[_0x280652(0x85d)]=_0x280652(0x97c);else{if(_0x229f1b['match'](/XP/i))this['_forcedBattleLayout']='xp';else{if(_0x229f1b[_0x280652(0xb9e)](/PORTRAIT/i))this['_forcedBattleLayout']=_0x280652(0x3ec);else{if(_0x229f1b['match'](/BORDER/i))this['_forcedBattleLayout']=_0x280652(0x541);else{if(_0x229f1b[_0x280652(0xb9e)](/(?:SIDEVIEW UI|SIDEVIEW)/i))Imported[_0x280652(0x78f)]?this['_forcedBattleLayout']=_0x280652(0x226):this[_0x280652(0x85d)]=_0x280652(0x30e);else _0x229f1b[_0x280652(0xb9e)](/(?:FRONTVIEW UI|FRONTVIEW)/i)&&(Imported[_0x280652(0x4d6)]?this[_0x280652(0x85d)]=_0x280652(0x6af):this[_0x280652(0x85d)]=_0x280652(0x30e));}}}}}}},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x77e)]=Game_Temp[_0x2dcaec(0xaf6)][_0x2dcaec(0x365)],Game_Temp[_0x2dcaec(0xaf6)]['requestBalloon']=function(_0x5b7452,_0x44f947){const _0x23bd6d=_0x2dcaec;SceneManager['isSceneBattle']()?this[_0x23bd6d(0xc0c)](_0x5b7452,_0x44f947):VisuMZ[_0x23bd6d(0xae3)][_0x23bd6d(0x77e)][_0x23bd6d(0x390)](this,_0x5b7452,_0x44f947);},Game_Temp[_0x2dcaec(0xaf6)][_0x2dcaec(0xc0c)]=function(_0x3c8dcc,_0x52ad11){const _0x38855c=_0x2dcaec,_0x5d1d9d={'target':_0x3c8dcc,'balloonId':_0x52ad11};this[_0x38855c(0x853)]=this['_battleBalloonQueue']||[],this[_0x38855c(0x853)][_0x38855c(0x190)](_0x5d1d9d);},Game_Temp[_0x2dcaec(0xaf6)][_0x2dcaec(0x949)]=function(){const _0x1a4253=_0x2dcaec;return this[_0x1a4253(0x853)]=this[_0x1a4253(0x853)]||[],this[_0x1a4253(0x853)]['shift']();},Game_Temp[_0x2dcaec(0xaf6)]['clearBattleBalloons']=function(){const _0xcc7067=_0x2dcaec;this[_0xcc7067(0x853)]=[];},Spriteset_Battle[_0x2dcaec(0xaf6)][_0x2dcaec(0x5f8)]=function(){const _0x57c477=_0x2dcaec;this[_0x57c477(0x533)]===undefined&&(this[_0x57c477(0x533)]=[]);for(const _0x47c969 of this[_0x57c477(0x533)]){!_0x47c969[_0x57c477(0x383)]()&&this['removeBattleBalloon'](_0x47c969);}this['processBattleBalloonRequests']();},Spriteset_Battle['prototype'][_0x2dcaec(0x679)]=function(){const _0x1f6950=_0x2dcaec;for(;;){const _0xf932a=$gameTemp[_0x1f6950(0x949)]();if(_0xf932a)this[_0x1f6950(0x2e8)](_0xf932a);else break;}},Spriteset_Battle[_0x2dcaec(0xaf6)][_0x2dcaec(0x2e8)]=function(_0x1d0f7e){const _0x5e24de=_0x2dcaec,_0x18eddd=this[_0x5e24de(0x2c5)](_0x1d0f7e[_0x5e24de(0x4ae)]);if(_0x18eddd){let _0x3ad168=null;Imported['VisuMZ_4_IconBalloons']&&Array[_0x5e24de(0xb63)](_0x1d0f7e[_0x5e24de(0x960)])?_0x3ad168=new Sprite_IconBalloon():_0x3ad168=new Sprite_Balloon(),_0x3ad168[_0x5e24de(0x462)]=_0x1d0f7e['target'],_0x3ad168[_0x5e24de(0xc39)]=_0x18eddd,_0x3ad168[_0x5e24de(0xc39)][_0x5e24de(0x443)]=_0x18eddd,_0x3ad168['setup'](_0x18eddd,_0x1d0f7e[_0x5e24de(0x960)]),BattleManager[_0x5e24de(0x1d4)](_0x3ad168),this['_battleBalloonSprites'][_0x5e24de(0x190)](_0x3ad168);}},Spriteset_Battle[_0x2dcaec(0xaf6)][_0x2dcaec(0x6e8)]=function(_0x246963){const _0x114e40=_0x2dcaec;this[_0x114e40(0x533)][_0x114e40(0xb8d)](_0x246963),BattleManager[_0x114e40(0x641)](_0x246963),_0x246963[_0x114e40(0x221)]();},Sprite_Battler[_0x2dcaec(0xaf6)][_0x2dcaec(0x30c)]=function(_0x10f070,_0x5e8086){},Sprite_Battler[_0x2dcaec(0xaf6)]['isSpriteVS8dir']=function(){return![];},Spriteset_Battle[_0x2dcaec(0xaf6)][_0x2dcaec(0x59a)]=function(){const _0x2e7db0=_0x2dcaec;return this[_0x2e7db0(0x533)]=this[_0x2e7db0(0x533)]||[],this[_0x2e7db0(0x533)][_0x2e7db0(0x7ce)]>0x0;},VisuMZ['BattleCore'][_0x2dcaec(0x86c)]=Game_System[_0x2dcaec(0xaf6)]['initialize'],Game_System[_0x2dcaec(0xaf6)][_0x2dcaec(0x970)]=function(){const _0x38bf26=_0x2dcaec;VisuMZ[_0x38bf26(0xae3)][_0x38bf26(0x86c)][_0x38bf26(0x390)](this),this[_0x38bf26(0x469)]();},Game_System['prototype']['initBattleCore']=function(){const _0x19b84c=_0x2dcaec;this[_0x19b84c(0xc75)]=this[_0x19b84c(0xc75)]||[];},Game_System['prototype'][_0x2dcaec(0x8b4)]=function(){const _0x5e78db=_0x2dcaec;if(this[_0x5e78db(0xc75)]===undefined)this[_0x5e78db(0x469)]();return this[_0x5e78db(0xc75)];},Game_System[_0x2dcaec(0xaf6)][_0x2dcaec(0x5bb)]=function(_0x1009dc){const _0x41aeb5=_0x2dcaec;if(this[_0x41aeb5(0xc75)]===undefined)this[_0x41aeb5(0x469)]();if(!_0x1009dc)return;if(this[_0x41aeb5(0xc75)][_0x41aeb5(0x7f2)](_0x1009dc))return;this['_defeatedEnemies'][_0x41aeb5(0x190)](_0x1009dc),this['_defeatedEnemies']['sort']((_0x2bd580,_0x354a80)=>_0x2bd580-_0x354a80);},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x4ac)]=Game_BattlerBase[_0x2dcaec(0xaf6)][_0x2dcaec(0x4e3)],Game_BattlerBase[_0x2dcaec(0xaf6)][_0x2dcaec(0x4e3)]=function(_0x187049){const _0x1a778b=_0x2dcaec,_0x5f92a4=this[_0x1a778b(0x2b5)](),_0x4b56a4=this[_0x1a778b(0x79f)]();VisuMZ[_0x1a778b(0xae3)][_0x1a778b(0x4ac)][_0x1a778b(0x390)](this,_0x187049),this[_0x1a778b(0x5d1)]()&&_0x5f92a4&&this[_0x1a778b(0x1f5)]()&&(this[_0x1a778b(0x257)]=!this[_0x1a778b(0x5fc)](),$gameSystem[_0x1a778b(0x5bb)](this[_0x1a778b(0xab2)]())),SceneManager[_0x1a778b(0xa2b)]()&&_0x4b56a4!==this[_0x1a778b(0x79f)]()&&(this[_0x1a778b(0xbc2)]()&&this[_0x1a778b(0xbc2)]()[_0x1a778b(0x5a4)]());},Game_Enemy[_0x2dcaec(0xaf6)][_0x2dcaec(0x5fc)]=function(){const _0x45922c=_0x2dcaec;return $gameSystem[_0x45922c(0x8b4)]()['includes'](this[_0x45922c(0x535)]);},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0xa1a)]=Game_BattlerBase['prototype'][_0x2dcaec(0x752)],Game_BattlerBase[_0x2dcaec(0xaf6)]['eraseState']=function(_0xbee7e){const _0x34c7de=_0x2dcaec,_0x1b1202=this['_states']['includes'](_0xbee7e),_0x24876c=this[_0x34c7de(0x79f)]();VisuMZ[_0x34c7de(0xae3)][_0x34c7de(0xa1a)][_0x34c7de(0x390)](this,_0xbee7e),this[_0x34c7de(0x5d1)]()&&_0xbee7e===this[_0x34c7de(0x636)]()&&this[_0x34c7de(0x2b5)]()&&(this[_0x34c7de(0x257)]=![]),!this[_0x34c7de(0x3ff)]&&!this[_0x34c7de(0x97d)]&&SceneManager[_0x34c7de(0xa2b)]()&&(_0x1b1202&&!this[_0x34c7de(0xa7f)][_0x34c7de(0x7f2)](_0xbee7e)&&this[_0x34c7de(0xb03)](),_0x24876c!==this['stateMotionIndex']()&&(this[_0x34c7de(0xbc2)]()&&this['battler']()[_0x34c7de(0x5a4)]()));},VisuMZ[_0x2dcaec(0xae3)]['Game_Action_clear']=Game_Action['prototype']['clear'],Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0xb7e)]=function(){const _0xa4faac=_0x2dcaec;VisuMZ[_0xa4faac(0xae3)][_0xa4faac(0x4d7)][_0xa4faac(0x390)](this),this['_armorPenetration']={'arPenRate':0x0,'arPenFlat':0x0,'arRedRate':0x0,'arRedFlat':0x0},this['_multipliers']={'criticalHitRate':0x1,'criticalHitFlat':0x0,'criticalDmgRate':0x1,'criticalDmgFlat':0x0,'damageRate':0x1,'damageFlat':0x0,'hitRate':0x1,'hitFlat':0x0},this['_customDamageFormula']=_0xa4faac(0x30e),this[_0xa4faac(0x569)]();},Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x569)]=function(){this['_targetBattlerKey']='';},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x8d7)]=Game_Action['prototype'][_0x2dcaec(0xaee)],Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0xaee)]=function(_0x2d771c){const _0x21a3a3=_0x2dcaec;VisuMZ[_0x21a3a3(0xae3)][_0x21a3a3(0x8d7)][_0x21a3a3(0x390)](this,_0x2d771c),this[_0x21a3a3(0x569)]();},VisuMZ['BattleCore'][_0x2dcaec(0xbf3)]=Game_Action['prototype'][_0x2dcaec(0xa16)],Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0xa16)]=function(_0x2b118c){const _0x575a3d=_0x2dcaec;VisuMZ[_0x575a3d(0xae3)][_0x575a3d(0xbf3)][_0x575a3d(0x390)](this,_0x2b118c),this[_0x575a3d(0x569)]();},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x7e6)]=Game_Action[_0x2dcaec(0xaf6)]['setItem'],Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x235)]=function(_0x335c3f){const _0x5920e0=_0x2dcaec;VisuMZ['BattleCore'][_0x5920e0(0x7e6)][_0x5920e0(0x390)](this,_0x335c3f),this[_0x5920e0(0x569)]();},Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x673)]=function(_0x52057a,_0x52331b){const _0x4fd665=_0x2dcaec;return VisuMZ[_0x4fd665(0xae3)][_0x4fd665(0xbeb)][_0x4fd665(0x53c)][_0x4fd665(0xc4f)][_0x4fd665(0x390)](this,_0x52057a,_0x52331b);},Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x1bd)]=function(_0x19bc34,_0x29a82e){const _0x1aeb13=_0x2dcaec;return VisuMZ['BattleCore'][_0x1aeb13(0xbeb)][_0x1aeb13(0x53c)][_0x1aeb13(0x5fd)][_0x1aeb13(0x390)](this,_0x19bc34,_0x29a82e);},Game_Action[_0x2dcaec(0xaf6)]['applyGuard']=function(_0x569802,_0x53eb74){const _0x2228c5=_0x2dcaec;return VisuMZ[_0x2228c5(0xae3)][_0x2228c5(0xbeb)][_0x2228c5(0x53c)][_0x2228c5(0x88e)][_0x2228c5(0x390)](this,_0x569802,_0x53eb74);},VisuMZ[_0x2dcaec(0xae3)]['Game_Action_itemHit']=Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x217)],Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x217)]=function(_0x1b08e2){const _0x3fc7ac=_0x2dcaec,_0x106e1d=this[_0x3fc7ac(0x719)]()[_0x3fc7ac(0x795)];if(_0x106e1d[_0x3fc7ac(0xb9e)](/<ALWAYS HIT>/i))return 0x1;else{if(_0x106e1d['match'](/<ALWAYS HIT RATE: (\d+)([%％])>/i))return Number(RegExp['$1'])/0x64;else{let _0x449700=VisuMZ[_0x3fc7ac(0xae3)][_0x3fc7ac(0x8a1)]['call'](this,_0x1b08e2);return _0x449700=this[_0x3fc7ac(0x865)]['hitRate']*_0x449700+this[_0x3fc7ac(0x865)]['hitFlat'],$gameParty[_0x3fc7ac(0x208)]()&&(_0x449700=this['applyBattleCoreHitRateJS'](_0x449700,_0x1b08e2)),_0x449700;}}},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x8c5)]=Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x9cc)],Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x9cc)]=function(_0x257ea7){const _0x5b5428=_0x2dcaec;this[_0x5b5428(0x148)]=!![],VisuMZ[_0x5b5428(0xae3)]['Game_Action_updateLastTarget'][_0x5b5428(0x390)](this,_0x257ea7),this[_0x5b5428(0x148)]=undefined;},Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x457)]=function(_0x37b96f){const _0x135d73=_0x2dcaec;window[_0x135d73(0x691)]=this,window['a']=this[_0x135d73(0xafb)](),window['b']=_0x37b96f,window[_0x135d73(0x17e)]=this[_0x135d73(0xafb)](),window['target']=_0x37b96f,window[_0x135d73(0x255)]=this[_0x135d73(0x719)](),window['skill']=this[_0x135d73(0x719)](),window[_0x135d73(0x719)]=this[_0x135d73(0x719)]();},Game_Action[_0x2dcaec(0xaf6)]['clearGlobalVariables']=function(_0x3ce1fb){const _0x392af8=_0x2dcaec;window[_0x392af8(0x691)]=undefined,window['a']=undefined,window['b']=undefined,window[_0x392af8(0x17e)]=undefined,window[_0x392af8(0x4ae)]=undefined,window[_0x392af8(0x255)]=undefined,window[_0x392af8(0x7d5)]=undefined,window[_0x392af8(0x719)]=undefined;},Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x7c7)]=function(_0x441213,_0x415b9c){const _0x4c1b9b=_0x2dcaec;if(this[_0x4c1b9b(0x148)])return _0x441213;this[_0x4c1b9b(0x457)](_0x415b9c);if(this[_0x4c1b9b(0x719)]()){let _0x4cb34d=VisuMZ[_0x4c1b9b(0xae3)]['createKeyJS'](this[_0x4c1b9b(0x719)](),'jsAccuracy');VisuMZ[_0x4c1b9b(0xae3)]['JS'][_0x4cb34d]&&(_0x441213=VisuMZ[_0x4c1b9b(0xae3)]['JS'][_0x4cb34d][_0x4c1b9b(0x390)](this,this['subject'](),_0x415b9c,this[_0x4c1b9b(0x719)](),_0x441213));}for(const _0x2bc82c of this['subject']()['traitObjects']()){if(!_0x2bc82c)continue;key=VisuMZ[_0x4c1b9b(0xae3)]['createKeyJS'](_0x2bc82c,_0x4c1b9b(0x24d)),VisuMZ[_0x4c1b9b(0xae3)]['JS'][key]&&(_0x441213=VisuMZ['BattleCore']['JS'][key]['call'](this,this[_0x4c1b9b(0xafb)](),_0x415b9c,this[_0x4c1b9b(0x719)](),_0x441213));}for(const _0x321326 of _0x415b9c['traitObjects']()){if(!_0x321326)continue;key=VisuMZ[_0x4c1b9b(0xae3)][_0x4c1b9b(0x2a1)](_0x321326,_0x4c1b9b(0x4be)),VisuMZ[_0x4c1b9b(0xae3)]['JS'][key]&&(_0x441213=VisuMZ[_0x4c1b9b(0xae3)]['JS'][key]['call'](this,this[_0x4c1b9b(0xafb)](),_0x415b9c,this[_0x4c1b9b(0x719)](),_0x441213));}return this[_0x4c1b9b(0x30f)](_0x415b9c),_0x441213;},Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x488)]=function(_0x1ec503){const _0x340fc5=_0x2dcaec;if(!this[_0x340fc5(0x719)]()[_0x340fc5(0x63e)][_0x340fc5(0x73b)])return 0x0;let _0x3a2d80=VisuMZ['BattleCore'][_0x340fc5(0xbeb)][_0x340fc5(0x53c)]['CriticalHitRateJS']['call'](this,_0x1ec503);return _0x3a2d80=this[_0x340fc5(0x865)][_0x340fc5(0xb32)]*_0x3a2d80+this[_0x340fc5(0x865)][_0x340fc5(0x2ff)],$gameParty['inBattle']()&&(_0x3a2d80=this[_0x340fc5(0x67b)](_0x3a2d80,_0x1ec503)),_0x3a2d80;},Game_Action[_0x2dcaec(0xaf6)]['applyBattleCoreCriticalHitRateJS']=function(_0x252b57,_0x136550){const _0x2c82be=_0x2dcaec;this['declareGlobalVariables'](_0x136550),window['rate']=_0x252b57;{const _0x67accc=this[_0x2c82be(0xafb)]()[_0x2c82be(0x517)]();for(const _0x4a2f6f of _0x67accc){if(!_0x4a2f6f)continue;if(_0x4a2f6f['note'][_0x2c82be(0xb9e)](/<JS (?:CRITICAL RATE|CRI) AS USER>\s*([\s\S]*?)\s*<\/JS (?:CRITICAL RATE|CRI) AS USER>/i)){const _0xa56663=String(RegExp['$1']);try{eval(_0xa56663);}catch(_0x1dfc1d){if($gameTemp[_0x2c82be(0x5b6)]())console[_0x2c82be(0x1e4)](_0x1dfc1d);}}}}{const _0x1a9b67=_0x136550[_0x2c82be(0x517)]();for(const _0x4844c6 of _0x1a9b67){if(!_0x4844c6)continue;if(_0x4844c6[_0x2c82be(0x795)][_0x2c82be(0xb9e)](/<JS (?:CRITICAL RATE|CRI) AS TARGET>\s*([\s\S]*?)\s*<\/JS (?:CRITICAL RATE|CRI) AS TARGET>/i)){const _0x1b904e=String(RegExp['$1']);try{eval(_0x1b904e);}catch(_0x6d5871){if($gameTemp['isPlaytest']())console[_0x2c82be(0x1e4)](_0x6d5871);}}}}return _0x252b57=window['rate'],this[_0x2c82be(0x30f)](_0x136550),_0x252b57;},Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x67b)]=function(_0x15f7c6,_0x109bf7){const _0x3e24ab=_0x2dcaec;this['declareGlobalVariables'](_0x109bf7);for(const _0x36ccff of this[_0x3e24ab(0xafb)]()[_0x3e24ab(0x517)]()){if(!_0x36ccff)continue;key=VisuMZ[_0x3e24ab(0xae3)]['createKeyJS'](_0x36ccff,_0x3e24ab(0x438)),VisuMZ[_0x3e24ab(0xae3)]['JS'][key]&&(_0x15f7c6=VisuMZ['BattleCore']['JS'][key]['call'](this,this['subject'](),_0x109bf7,this[_0x3e24ab(0x719)](),_0x15f7c6));}for(const _0x5495f0 of _0x109bf7[_0x3e24ab(0x517)]()){if(!_0x5495f0)continue;key=VisuMZ['BattleCore'][_0x3e24ab(0x2a1)](_0x5495f0,_0x3e24ab(0x809)),VisuMZ[_0x3e24ab(0xae3)]['JS'][key]&&(_0x15f7c6=VisuMZ[_0x3e24ab(0xae3)]['JS'][key][_0x3e24ab(0x390)](this,this[_0x3e24ab(0xafb)](),_0x109bf7,this[_0x3e24ab(0x719)](),_0x15f7c6));}return this['clearGlobalVariables'](_0x109bf7),_0x15f7c6;},Game_Action[_0x2dcaec(0xaf6)]['applyCritical']=function(_0x4e31d3){const _0x16f36c=_0x2dcaec;return _0x4e31d3=VisuMZ[_0x16f36c(0xae3)][_0x16f36c(0xbeb)]['Damage']['CriticalHitMultiplier'][_0x16f36c(0x390)](this,_0x4e31d3),_0x4e31d3=this['_multipliers'][_0x16f36c(0x1e1)]*_0x4e31d3+this[_0x16f36c(0x865)][_0x16f36c(0x770)],_0x4e31d3;},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x2b0)]=Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x91f)],Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x91f)]=function(_0x282d65){const _0x2c5972=_0x2dcaec;if(this[_0x2c5972(0x342)]!==_0x2c5972(0x30e))return this[_0x2c5972(0x35a)](_0x282d65);else return DataManager['getDamageStyle'](this['item']())==='MANUAL'?VisuMZ[_0x2c5972(0xae3)][_0x2c5972(0x2b0)][_0x2c5972(0x390)](this,_0x282d65):this[_0x2c5972(0x3e8)](_0x282d65);},Game_Action['prototype']['setCustomDamageFormula']=function(_0x11c86b){const _0x53a07c=_0x2dcaec;this[_0x53a07c(0x342)]=_0x11c86b;},Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x35a)]=function(_0x1f16e1){const _0x4ea5b6=_0x2dcaec,_0x57ac75=this['item'](),_0x2e3f9e=_0x57ac75[_0x4ea5b6(0x63e)][_0x4ea5b6(0x30b)];_0x57ac75[_0x4ea5b6(0x63e)]['formula']=this['_customDamageFormula'];let _0x11dc40=VisuMZ[_0x4ea5b6(0xae3)][_0x4ea5b6(0x2b0)][_0x4ea5b6(0x390)](this,_0x1f16e1);return _0x57ac75['damage'][_0x4ea5b6(0x30b)]=_0x2e3f9e,_0x11dc40;},Game_Action['prototype']['damageStyle']=function(){const _0x50b3d5=_0x2dcaec;if(this[_0x50b3d5(0x719)]()['note'][_0x50b3d5(0xb9e)](/<DAMAGE STYLE:[ ](.*)>/i)){const _0x4c0a22=String(RegExp['$1'])[_0x50b3d5(0xb9f)]()['trim']();return _0x4c0a22;}return _0x50b3d5(0x45d);},Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x3e8)]=function(_0x229ddc){const _0x1d76cd=_0x2dcaec,_0x19eae7=DataManager[_0x1d76cd(0x47f)](this[_0x1d76cd(0x719)]()),_0x3683a9=VisuMZ['DamageStyles'][_0x19eae7];try{return _0x3683a9[_0x1d76cd(0x89f)]['call'](this,_0x229ddc);}catch(_0x235f63){if($gameTemp[_0x1d76cd(0x5b6)]())console[_0x1d76cd(0x1e4)](_0x235f63);return VisuMZ[_0x1d76cd(0xae3)][_0x1d76cd(0x2b0)][_0x1d76cd(0x390)](this);}},Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x6a1)]=function(_0x11fc7d,_0x25b0fb){const _0x49a638=_0x2dcaec;if(this[_0x49a638(0x9eb)]())return _0x25b0fb;const _0x1af14a=this[_0x49a638(0xafb)](),_0x4af14f=_0x11fc7d;let _0x63e1fb=[],_0x190053=[];_0x63e1fb['push'](this[_0x49a638(0x48a)][_0x49a638(0x684)],this[_0x49a638(0x48a)][_0x49a638(0xb74)]),_0x190053[_0x49a638(0x190)](this[_0x49a638(0x48a)]['arPenRate'],this[_0x49a638(0x48a)][_0x49a638(0xbce)]);const _0x4c147b=this[_0x49a638(0x835)]()?/<ARMOR REDUCTION:[ ](\d+\.?\d*)>/i:/<MAGIC REDUCTION:[ ](\d+\.?\d*)>/i,_0x1e661e=this[_0x49a638(0x835)]()?/<ARMOR REDUCTION:[ ](\d+\.?\d*)([%％])>/i:/<MAGIC REDUCTION:[ ](\d+\.?\d*)([%％])>/i,_0x485496=this[_0x49a638(0x835)]()?/<ARMOR PENETRATION:[ ](\d+\.?\d*)>/i:/<MAGIC PENETRATION:[ ](\d+\.?\d*)>/i,_0x465a64=this[_0x49a638(0x835)]()?/<ARMOR PENETRATION:[ ](\d+\.?\d*)([%％])>/i:/<MAGIC PENETRATION:[ ](\d+\.?\d*)([%％])>/i;return _0x63e1fb=_0x63e1fb[_0x49a638(0xa5b)](_0x4af14f[_0x49a638(0x517)]()[_0x49a638(0xc20)](_0x3805a4=>_0x3805a4&&_0x3805a4['note'][_0x49a638(0xb9e)](_0x4c147b)?Number(RegExp['$1']):0x0)),_0x190053=_0x190053[_0x49a638(0xa5b)](_0x4af14f[_0x49a638(0x517)]()[_0x49a638(0xc20)](_0x5d3155=>_0x5d3155&&_0x5d3155[_0x49a638(0x795)][_0x49a638(0xb9e)](_0x1e661e)?Number(RegExp['$1'])/0x64:0x0)),_0x63e1fb=_0x63e1fb['concat'](_0x1af14a[_0x49a638(0x517)]()[_0x49a638(0xc20)](_0xbec4dd=>_0xbec4dd&&_0xbec4dd[_0x49a638(0x795)][_0x49a638(0xb9e)](_0x485496)?Number(RegExp['$1']):0x0)),_0x190053=_0x190053['concat'](_0x1af14a[_0x49a638(0x517)]()[_0x49a638(0xc20)](_0x450bd9=>_0x450bd9&&_0x450bd9[_0x49a638(0x795)][_0x49a638(0xb9e)](_0x465a64)?Number(RegExp['$1'])/0x64:0x0)),this[_0x49a638(0x719)]()[_0x49a638(0x795)][_0x49a638(0xb9e)](_0x485496)&&_0x63e1fb[_0x49a638(0x190)](Number(RegExp['$1'])),this['item']()[_0x49a638(0x795)][_0x49a638(0xb9e)](_0x465a64)&&_0x190053['push'](Number(RegExp['$1'])),_0x25b0fb=_0x63e1fb['reduce']((_0x266ae9,_0xf7a22e)=>_0x266ae9-_0xf7a22e,_0x25b0fb),_0x25b0fb>0x0&&(_0x25b0fb=_0x190053[_0x49a638(0xbc0)]((_0x2bad55,_0x3d885f)=>_0x2bad55*(0x1-_0x3d885f),_0x25b0fb)),_0x25b0fb;},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x2d1)]=Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x3f9)],Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x3f9)]=function(_0x3f6972,_0x380b66){const _0x1ac430=_0x2dcaec;_0x380b66=_0x380b66*this[_0x1ac430(0x865)][_0x1ac430(0xa74)],_0x380b66+=this[_0x1ac430(0x865)][_0x1ac430(0x6a3)]*(_0x380b66>=0x0?0x1:-0x1),_0x380b66=this[_0x1ac430(0x2cb)](_0x1ac430(0xb7c),_0x3f6972,_0x380b66,![]),_0x380b66=this[_0x1ac430(0xb5c)](_0x380b66),_0x380b66>0x0?_0x380b66=Math[_0x1ac430(0xbd6)](_0x380b66):_0x380b66=Math[_0x1ac430(0x6eb)](_0x380b66),this[_0x1ac430(0xb7f)]=_0x380b66,this[_0x1ac430(0x6c6)]=this[_0x1ac430(0x6c6)]||0x0,this[_0x1ac430(0x6c6)]+=_0x380b66,VisuMZ['BattleCore'][_0x1ac430(0x2d1)][_0x1ac430(0x390)](this,_0x3f6972,_0x380b66),this[_0x1ac430(0x2cb)](_0x1ac430(0x171),_0x3f6972,_0x380b66,!![]);},Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0xb5c)]=function(_0x30a35c){const _0x19a56c=_0x2dcaec;if(this[_0x19a56c(0x4d0)]())return _0x30a35c;return _0x30a35c=this[_0x19a56c(0x45a)](_0x30a35c),_0x30a35c=this['applyHardDamageCap'](_0x30a35c),_0x30a35c;},Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x4d0)]=function(){const _0x5b04ed=_0x2dcaec,_0x311e1b=/<BYPASS DAMAGE CAP>/i;if(this[_0x5b04ed(0x719)]()['note'][_0x5b04ed(0xb9e)](_0x311e1b))return!![];if(this[_0x5b04ed(0xafb)]()[_0x5b04ed(0x517)]()[_0x5b04ed(0x624)](_0x3b951f=>_0x3b951f&&_0x3b951f[_0x5b04ed(0x795)][_0x5b04ed(0xb9e)](_0x311e1b)))return!![];return!VisuMZ[_0x5b04ed(0xae3)][_0x5b04ed(0xbeb)][_0x5b04ed(0x53c)][_0x5b04ed(0x4b5)];},Game_Action['prototype']['applySoftDamageCap']=function(_0x24c8a4){const _0x1ae089=_0x2dcaec;if(!VisuMZ[_0x1ae089(0xae3)][_0x1ae089(0xbeb)][_0x1ae089(0x53c)][_0x1ae089(0xae8)])return _0x24c8a4;const _0x595b8e=/<BYPASS SOFT DAMAGE CAP>/i;if(this[_0x1ae089(0x719)]()[_0x1ae089(0x795)]['match'](_0x595b8e))return _0x24c8a4;if(this[_0x1ae089(0xafb)]()[_0x1ae089(0x517)]()['some'](_0x5b5e3c=>_0x5b5e3c&&_0x5b5e3c[_0x1ae089(0x795)]['match'](_0x595b8e)))return _0x24c8a4;const _0x3dc345=_0x24c8a4<0x0?-0x1:0x1;_0x24c8a4=Math[_0x1ae089(0x2ac)](_0x24c8a4);let _0x8da850=this[_0x1ae089(0xafb)]()[_0x1ae089(0x490)]();this[_0x1ae089(0x719)]()[_0x1ae089(0x795)][_0x1ae089(0xb9e)](/<SOFT DAMAGE CAP:[ ]([\+\-]\d+)([%％])>/i)&&(_0x8da850+=Number(RegExp['$1'])/0x64);_0x8da850=_0x8da850[_0x1ae089(0xc50)](0.01,0x1);const _0x4b7b7a=this['getHardDamageCap'](),_0xd16a84=_0x8da850*_0x4b7b7a;if(_0x24c8a4>_0xd16a84&&_0x4b7b7a>_0xd16a84){_0x24c8a4-=_0xd16a84;const _0x35aaad=VisuMZ[_0x1ae089(0xae3)][_0x1ae089(0xbeb)][_0x1ae089(0x53c)]['DefaultSoftScaler'],_0x1b116b=Math[_0x1ae089(0x959)](0x1-_0x24c8a4/((_0x4b7b7a-_0xd16a84)*_0x35aaad+_0x24c8a4),0.01);_0x24c8a4*=_0x1b116b,_0x24c8a4+=_0xd16a84;}return _0x24c8a4*_0x3dc345;},Game_Action['prototype']['getHardDamageCap']=function(){const _0xd2ae4b=_0x2dcaec;return this[_0xd2ae4b(0x719)]()[_0xd2ae4b(0x795)][_0xd2ae4b(0xb9e)](/<DAMAGE CAP:[ ](\d+)>/i)?Number(RegExp['$1']):this[_0xd2ae4b(0xafb)]()[_0xd2ae4b(0xb38)]();},Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x381)]=function(_0x246fa6){const _0x34ca3d=_0x2dcaec;let _0xe03f28=this[_0x34ca3d(0x353)]();return _0x246fa6[_0x34ca3d(0xc50)](-_0xe03f28,_0xe03f28);},Game_Action['prototype'][_0x2dcaec(0x346)]=function(){const _0x4aa22e=_0x2dcaec;if(!this[_0x4aa22e(0x719)]())return![];if(!$gameParty[_0x4aa22e(0x208)]())return![];return(this[_0x4aa22e(0x719)]()[_0x4aa22e(0x795)]||'')[_0x4aa22e(0xb9e)](/<DISPERSE DAMAGE>/i);},Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x67e)]=function(_0x11bc9e){const _0x5ec1ca=_0x2dcaec;if(this['shouldDisperseDamage']()){let _0x483f46=BattleManager['_targets'];_0x11bc9e/=_0x483f46[_0x5ec1ca(0x7ce)],this[_0x5ec1ca(0x920)]()&&(_0x11bc9e*=this[_0x5ec1ca(0xafb)]()[_0x5ec1ca(0xa05)]()+0x1),_0x11bc9e=_0x11bc9e>0x0?Math['ceil'](_0x11bc9e):Math[_0x5ec1ca(0x6eb)](_0x11bc9e);}return _0x11bc9e;},VisuMZ[_0x2dcaec(0xae3)]['Game_Action_makeDamageValueDisperse']=Game_Action['prototype'][_0x2dcaec(0x673)],Game_Action['prototype'][_0x2dcaec(0x673)]=function(_0x1cd73e,_0x5d79e6){const _0x3c23e7=_0x2dcaec;let _0x52158f=VisuMZ[_0x3c23e7(0xae3)][_0x3c23e7(0x5df)]['call'](this,_0x1cd73e,_0x5d79e6);return this['disperseDamage'](_0x52158f);},Game_Action['prototype']['itemEffectRecoverHp']=function(_0x5232aa,_0x59c92a){const _0x47475a=_0x2dcaec;let _0x3832f2=(_0x5232aa[_0x47475a(0x74e)]*_0x59c92a[_0x47475a(0x6d0)]+_0x59c92a[_0x47475a(0x862)])*_0x5232aa[_0x47475a(0x3b5)];_0x3832f2=this[_0x47475a(0x67e)](_0x3832f2),this[_0x47475a(0x408)]()&&(_0x3832f2*=this[_0x47475a(0xafb)]()['pha']),_0x3832f2=Math[_0x47475a(0x6eb)](_0x3832f2),_0x3832f2!==0x0&&(_0x5232aa['gainHp'](_0x3832f2),this['makeSuccess'](_0x5232aa));},Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x1c6)]=function(_0x203927,_0x4df1db){const _0x3e5d8e=_0x2dcaec;let _0x4f2120=(_0x203927[_0x3e5d8e(0xaa1)]*_0x4df1db[_0x3e5d8e(0x6d0)]+_0x4df1db[_0x3e5d8e(0x862)])*_0x203927[_0x3e5d8e(0x3b5)];_0x4f2120=this[_0x3e5d8e(0x67e)](_0x4f2120),this['isItem']()&&(_0x4f2120*=this[_0x3e5d8e(0xafb)]()[_0x3e5d8e(0x803)]),_0x4f2120=Math[_0x3e5d8e(0x6eb)](_0x4f2120),_0x4f2120!==0x0&&(_0x203927[_0x3e5d8e(0x77c)](_0x4f2120),this[_0x3e5d8e(0x753)](_0x203927));},Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x621)]=function(_0x295d0d,_0x41384b){const _0x33c6bc=_0x2dcaec;let _0x5a5e0c=Math['floor'](_0x41384b['value1']);_0x5a5e0c=this[_0x33c6bc(0x67e)](_0x5a5e0c),_0x5a5e0c!==0x0&&(_0x295d0d[_0x33c6bc(0x9df)](_0x5a5e0c),this[_0x33c6bc(0x753)](_0x295d0d));},VisuMZ[_0x2dcaec(0xae3)]['Game_Action_apply']=Game_Action['prototype'][_0x2dcaec(0xb68)],Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0xb68)]=function(_0x45bc37){const _0x421679=_0x2dcaec;if(_0x45bc37&&_0x45bc37[_0x421679(0x5d1)]())_0x45bc37[_0x421679(0x237)]();this[_0x421679(0x2cb)](_0x421679(0x69e),_0x45bc37,0x0,!![]),VisuMZ[_0x421679(0xae3)][_0x421679(0x9e4)]['call'](this,_0x45bc37),this['applyBattleCoreJS'](_0x421679(0x648),_0x45bc37,this[_0x421679(0xb7f)]||0x0,!![]),this[_0x421679(0x454)](_0x45bc37);},Game_Action[_0x2dcaec(0xaf6)]['applyBattleCoreJS']=function(_0x4f4f25,_0x185a7a,_0x2a1f43,_0x2fa8be){const _0x3d9644=_0x2dcaec;if(this['_tempBattler']||this['_tempActor'])return;_0x2a1f43=_0x2a1f43||0x0;const _0x924ad7=_0x2a1f43,_0xee43b8=VisuMZ[_0x3d9644(0xae3)][_0x3d9644(0xbeb)]['Mechanics'],_0xd6bbf0=_0x4f4f25[_0x3d9644(0xb60)]('');if(_0xee43b8[_0xd6bbf0]){_0x2a1f43=_0xee43b8[_0xd6bbf0]['call'](this,_0x2a1f43,_0x185a7a);if(_0x2fa8be)_0x2a1f43=_0x924ad7;}let _0x32acde=VisuMZ[_0x3d9644(0xae3)][_0x3d9644(0x2a1)](this[_0x3d9644(0x719)](),_0x4f4f25[_0x3d9644(0xb60)](''));if(VisuMZ[_0x3d9644(0xae3)]['JS'][_0x32acde]){_0x2a1f43=VisuMZ[_0x3d9644(0xae3)]['JS'][_0x32acde][_0x3d9644(0x390)](this,this[_0x3d9644(0xafb)](),_0x185a7a,this[_0x3d9644(0x719)](),_0x2a1f43);if(_0x2fa8be)_0x2a1f43=_0x924ad7;}for(const _0x271c6 of this['subject']()['traitObjects']()){if(!_0x271c6)continue;_0x32acde=VisuMZ['BattleCore'][_0x3d9644(0x2a1)](_0x271c6,_0x4f4f25[_0x3d9644(0xb60)](_0x3d9644(0xb91)));if(VisuMZ[_0x3d9644(0xae3)]['JS'][_0x32acde]){_0x2a1f43=VisuMZ['BattleCore']['JS'][_0x32acde][_0x3d9644(0x390)](this,this['subject'](),_0x185a7a,_0x271c6,_0x2a1f43);if(_0x2fa8be)_0x2a1f43=_0x924ad7;}}for(const _0x380755 of _0x185a7a['traitObjects']()){if(!_0x380755)continue;_0x32acde=VisuMZ[_0x3d9644(0xae3)][_0x3d9644(0x2a1)](_0x380755,_0x4f4f25[_0x3d9644(0xb60)]('AsTarget'));if(VisuMZ[_0x3d9644(0xae3)]['JS'][_0x32acde]){_0x2a1f43=VisuMZ[_0x3d9644(0xae3)]['JS'][_0x32acde][_0x3d9644(0x390)](this,this[_0x3d9644(0xafb)](),_0x185a7a,_0x380755,_0x2a1f43);if(_0x2fa8be)_0x2a1f43=_0x924ad7;}}return _0x2a1f43;},Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x6f1)]=function(_0x3a5952){const _0x20a18c=_0x2dcaec,_0x750f6e=this['_totalValue']||0x0,_0x3b713c=VisuMZ[_0x20a18c(0xae3)][_0x20a18c(0xbeb)][_0x20a18c(0x41e)],_0x482373=_0x3a5952[_0x20a18c(0xb60)]('');_0x3b713c[_0x482373]&&_0x3b713c[_0x482373][_0x20a18c(0x390)](this,_0x750f6e);let _0x5e469a=VisuMZ[_0x20a18c(0xae3)][_0x20a18c(0x2a1)](this[_0x20a18c(0x719)](),_0x3a5952);VisuMZ[_0x20a18c(0xae3)]['JS'][_0x5e469a]&&VisuMZ['BattleCore']['JS'][_0x5e469a][_0x20a18c(0x390)](this,this[_0x20a18c(0xafb)](),this['subject'](),this[_0x20a18c(0x719)](),_0x750f6e);for(const _0x4fe7d6 of this[_0x20a18c(0xafb)]()[_0x20a18c(0x517)]()){if(!_0x4fe7d6)continue;_0x5e469a=VisuMZ[_0x20a18c(0xae3)][_0x20a18c(0x2a1)](_0x4fe7d6,_0x3a5952),VisuMZ['BattleCore']['JS'][_0x5e469a]&&VisuMZ[_0x20a18c(0xae3)]['JS'][_0x5e469a][_0x20a18c(0x390)](this,this[_0x20a18c(0xafb)](),this[_0x20a18c(0xafb)](),_0x4fe7d6,_0x750f6e);}},Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x15f)]=function(){const _0x49b28c=_0x2dcaec;return VisuMZ['BattleCore'][_0x49b28c(0xbeb)][_0x49b28c(0x41e)]['CalcActionSpeedJS'][_0x49b28c(0x390)](this);},Game_Action[_0x2dcaec(0xaf6)]['allowRandomSpeed']=function(){const _0x48391c=_0x2dcaec;return VisuMZ[_0x48391c(0xae3)]['Settings'][_0x48391c(0x41e)][_0x48391c(0x236)];},Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0xa8f)]=function(){const _0x410ad7=_0x2dcaec;if(this[_0x410ad7(0x274)]==='all\x20actors')return![];if(this[_0x410ad7(0x274)]===_0x410ad7(0x6a4))return![];if(!this['item']())return![];return this[_0x410ad7(0x719)]()[_0x410ad7(0x795)]['match'](/<JS TARGETS>/i);},Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x9c8)]=function(){const _0xbaf0b8=_0x2dcaec;if(this[_0xbaf0b8(0x274)]==='all\x20actors')return![];if(this['_targetBattlerKey']===_0xbaf0b8(0x6a4))return![];if(!this[_0xbaf0b8(0x29a)]&&this[_0xbaf0b8(0xafb)]()[_0xbaf0b8(0x66e)]())return![];if(this[_0xbaf0b8(0xa8f)]())return!![];if(!this[_0xbaf0b8(0x719)]())return![];return typeof this[_0xbaf0b8(0x719)]()[_0xbaf0b8(0x147)]===_0xbaf0b8(0x3b3);},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x57e)]=Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0xa1f)],Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0xa1f)]=function(){const _0x22736e=_0x2dcaec;if(this[_0x22736e(0x274)]===_0x22736e(0x7d3))return![];if(this[_0x22736e(0x274)]===_0x22736e(0x6a4))return!![];return this[_0x22736e(0x9c8)]()&&!this['isCustomBattleScope']()?this[_0x22736e(0xc3a)]():VisuMZ[_0x22736e(0xae3)]['Game_Action_isForOpponent'][_0x22736e(0x390)](this);},Game_Action[_0x2dcaec(0xaf6)]['isForOpponentBattleCore']=function(){const _0x533a15=_0x2dcaec,_0xe89472=String(this[_0x533a15(0x719)]()[_0x533a15(0x147)]);if(_0xe89472['match'](/ANY/i))return!![];return _0xe89472[_0x533a15(0xb9e)](/(?:ENEMY|ENEMIES|FOE|FOES)/i);},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x439)]=Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x25b)],Game_Action['prototype'][_0x2dcaec(0x25b)]=function(){const _0x5a6354=_0x2dcaec;if(this[_0x5a6354(0x274)]===_0x5a6354(0x7d3))return!![];if(this[_0x5a6354(0x274)]===_0x5a6354(0x6a4))return![];return this['isBattleCoreTargetScope']()&&!this[_0x5a6354(0xa8f)]()?this[_0x5a6354(0x98d)]():VisuMZ[_0x5a6354(0xae3)][_0x5a6354(0x439)][_0x5a6354(0x390)](this);},Game_Action['prototype'][_0x2dcaec(0x98d)]=function(){const _0x5d7a86=_0x2dcaec,_0x184466=String(this[_0x5d7a86(0x719)]()[_0x5d7a86(0x147)]);return _0x184466[_0x5d7a86(0xb9e)](/(?:ALLY|ALLIES|FRIEND|FRIENDS)/i);},Game_Action['prototype']['isForAnyone']=function(){const _0x272cb5=_0x2dcaec;if(this[_0x272cb5(0x9c8)]()&&!this[_0x272cb5(0xa8f)]()){const _0x1308fe=String(this['item']()[_0x272cb5(0x147)]);return _0x1308fe[_0x272cb5(0xb9e)](/(?:ENEMY|FOE)/i)&&_0x1308fe[_0x272cb5(0xb9e)](/OR/i)&&_0x1308fe[_0x272cb5(0xb9e)](/(?:ALLY|FRIEND)/i);}else return![];},Game_Action[_0x2dcaec(0xaf6)]['isForAnyoneFocusFriends']=function(){const _0x3e6e22=_0x2dcaec;if(this[_0x3e6e22(0xb17)]()){const _0x4ea056=String(this[_0x3e6e22(0x719)]()[_0x3e6e22(0x147)]);if(_0x4ea056[_0x3e6e22(0xb9e)](/(?:ALLY|FRIEND) OR (?:ENEMY|FOE)/i))return!![];}return![];},Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x94c)]=function(){const _0x196b99=_0x2dcaec;if(this[_0x196b99(0xb17)]()){const _0x12a2aa=String(this[_0x196b99(0x719)]()['scope']);if(_0x12a2aa[_0x196b99(0xb9e)](/(?:ENEMY|FOE) OR (?:ALLY|FRIEND)/i))return!![];}return![];},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x400)]=Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x4ad)],Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x4ad)]=function(){const _0x3c2eb7=_0x2dcaec;if(this[_0x3c2eb7(0x274)]==='all\x20actors')return!![];return this[_0x3c2eb7(0x9c8)]()&&!this['isCustomBattleScope']()?this[_0x3c2eb7(0x936)]():VisuMZ[_0x3c2eb7(0xae3)][_0x3c2eb7(0x400)]['call'](this);},VisuMZ['BattleCore']['Game_Action_isForDeadFriend']=Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x2ca)],Game_Action[_0x2dcaec(0xaf6)]['isForDeadFriend']=function(){const _0xea1287=_0x2dcaec;if(this[_0xea1287(0x274)]===_0xea1287(0x7d3))return VisuMZ[_0xea1287(0xae3)][_0xea1287(0x9a0)][_0xea1287(0x390)](this);return VisuMZ[_0xea1287(0xae3)][_0xea1287(0x9a0)][_0xea1287(0x390)](this);},Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x936)]=function(){const _0x1c6a95=_0x2dcaec;if(this[_0x1c6a95(0xb17)]())return!![];return![];},Game_Action['prototype'][_0x2dcaec(0x3a4)]=function(){const _0x4c8f4c=_0x2dcaec;return this[_0x4c8f4c(0x719)]()&&this['item']()[_0x4c8f4c(0x795)][_0x4c8f4c(0xb9e)](/<CANNOT TARGET (?:USER|SELF)>/i);},VisuMZ['BattleCore'][_0x2dcaec(0x619)]=Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x22c)],Game_Action['prototype'][_0x2dcaec(0x22c)]=function(){const _0x35ce14=_0x2dcaec;if(this['_targetBattlerKey']===_0x35ce14(0x7d3))return![];if(this[_0x35ce14(0x274)]===_0x35ce14(0x6a4))return![];return this['isBattleCoreTargetScope']()&&!this['isCustomBattleScope']()?this['isForOneBattleCore']():VisuMZ[_0x35ce14(0xae3)][_0x35ce14(0x619)][_0x35ce14(0x390)](this);},Game_Action['prototype'][_0x2dcaec(0x380)]=function(){const _0x5193eb=_0x2dcaec;if(this[_0x5193eb(0xb17)]())return!![];return![];},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x618)]=Game_Action['prototype'][_0x2dcaec(0xc62)],Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0xc62)]=function(){const _0xfbbdf6=_0x2dcaec;if(this[_0xfbbdf6(0x274)]===_0xfbbdf6(0x7d3))return![];if(this[_0xfbbdf6(0x274)]===_0xfbbdf6(0x6a4))return![];return this[_0xfbbdf6(0x9c8)]()&&!this[_0xfbbdf6(0xa8f)]()?this[_0xfbbdf6(0xaf0)]():VisuMZ[_0xfbbdf6(0xae3)][_0xfbbdf6(0x618)]['call'](this);},Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0xaf0)]=function(){const _0x36442e=_0x2dcaec,_0x4d872d=String(this['item']()[_0x36442e(0x147)]);return _0x4d872d[_0x36442e(0xb9e)](/(?:RAND|RANDOM)/i);},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x49d)]=Game_Action[_0x2dcaec(0xaf6)]['isForAll'],Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x377)]=function(){const _0x18655f=_0x2dcaec;if(this[_0x18655f(0x274)]===_0x18655f(0x7d3))return!![];if(this['_targetBattlerKey']==='all\x20enemies')return!![];return VisuMZ[_0x18655f(0xae3)][_0x18655f(0x49d)][_0x18655f(0x390)](this);},Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x8fc)]=function(){const _0x4c8372=_0x2dcaec;if(!this[_0x4c8372(0x719)]())return![];if(this[_0x4c8372(0x2ca)]())return![];return(this['item']()['note']||'')[_0x4c8372(0xb9e)](/<SINGLE OR MULTIPLE SELECT>/i);},VisuMZ[_0x2dcaec(0xae3)]['Game_Action_testApply']=Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x34c)],Game_Action[_0x2dcaec(0xaf6)]['testApply']=function(_0x244de5){const _0x46b330=_0x2dcaec;if(this['isForNotUser']()&&_0x244de5===this[_0x46b330(0xafb)]())return![];return VisuMZ[_0x46b330(0xae3)][_0x46b330(0x203)]['call'](this,_0x244de5);},VisuMZ['BattleCore'][_0x2dcaec(0x483)]=Game_Action[_0x2dcaec(0xaf6)]['itemTargetCandidates'],Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x4c9)]=function(){const _0x53ce6e=_0x2dcaec,_0x141092=VisuMZ[_0x53ce6e(0xae3)][_0x53ce6e(0x483)][_0x53ce6e(0x390)](this);if(this['isForNotUser']())_0x141092['remove'](this['subject']());return _0x141092;},VisuMZ['BattleCore'][_0x2dcaec(0x1d2)]=Game_Action['prototype'][_0x2dcaec(0x7cd)],Game_Action[_0x2dcaec(0xaf6)]['needsSelection']=function(){const _0x4b39b3=_0x2dcaec;return this['isBattleCoreTargetScope']()&&!this['isCustomBattleScope']()?this[_0x4b39b3(0x9db)]():VisuMZ[_0x4b39b3(0xae3)]['Game_Action_needsSelection']['call'](this);},Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x9db)]=function(){const _0x2e3246=_0x2dcaec,_0x5edddb=String(this['item']()[_0x2e3246(0x147)]);if(_0x5edddb['match'](/RANDOM/i))return![];if(_0x5edddb[_0x2e3246(0xb9e)](/ALL (?:ALLY|ALLIES|FRIEND|FRIENDS)/i))return![];if(_0x5edddb[_0x2e3246(0xb9e)](/ALL (?:ENEMY|ENEMIES|FOE|FOES)/i))return![];if(_0x5edddb[_0x2e3246(0xb9e)](/(?:ENEMY|FOE) OR (?:ALLY|FRIEND)/i))return!![];if(_0x5edddb[_0x2e3246(0xb9e)](/(?:ALLY|FRIEND) OR (?:ENEMY|FOE)/i))return!![];return VisuMZ['BattleCore']['Game_Action_needsSelection'][_0x2e3246(0x390)](this);},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x50c)]=Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x6b5)],Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x6b5)]=function(){const _0x4eeb84=_0x2dcaec;let _0x69e3a9=[];return this['isBattleCoreTargetScope']()?this['isCustomBattleScope']()?_0x69e3a9=this[_0x4eeb84(0x3ef)]():_0x69e3a9=this['makeTargetsBattleCore']():_0x69e3a9=VisuMZ['BattleCore'][_0x4eeb84(0x50c)][_0x4eeb84(0x390)](this),_0x69e3a9=this[_0x4eeb84(0x7e1)](_0x69e3a9),_0x69e3a9;},Game_Action[_0x2dcaec(0xaf6)]['isSubjectValidForAnyoneSelect']=function(){const _0x3b05d6=_0x2dcaec;return this[_0x3b05d6(0xafb)]()['isActor']()&&!this[_0x3b05d6(0xafb)]()[_0x3b05d6(0x576)]();},Game_Action[_0x2dcaec(0xaf6)]['makeTargetsBattleCoreJS']=function(){const _0x381235=_0x2dcaec,_0x32b557=VisuMZ[_0x381235(0xae3)]['createKeyJS'](this['item'](),_0x381235(0xad6));if(VisuMZ[_0x381235(0xae3)]['JS'][_0x32b557]){targets=VisuMZ[_0x381235(0xae3)][_0x381235(0x50c)][_0x381235(0x390)](this);const _0x58c47d=VisuMZ[_0x381235(0xae3)]['createKeyJS'](this[_0x381235(0x719)](),'Targets');return targets=VisuMZ[_0x381235(0xae3)]['JS'][_0x58c47d]['call'](this,this[_0x381235(0xafb)](),targets),this[_0x381235(0x5cd)](targets);}return this[_0x381235(0x5c6)]();},Game_Action['prototype'][_0x2dcaec(0x5c6)]=function(){const _0x4599a3=_0x2dcaec;let _0xd2394a=[];const _0x3767a2=String(this[_0x4599a3(0x719)]()[_0x4599a3(0x147)]);if(this['isForAnyoneFocusOpponents']())return this['isSubjectValidForAnyoneSelect']()?(_0xd2394a=this[_0x4599a3(0x325)](),this[_0x4599a3(0x5cd)](_0xd2394a)):(this['_targetIndex']=-0x1,_0xd2394a[_0x4599a3(0x190)](...this[_0x4599a3(0xa6b)]()),this['repeatTargets'](_0xd2394a));if(this[_0x4599a3(0x5b5)]()){if(this[_0x4599a3(0x9c7)]())return _0xd2394a=this[_0x4599a3(0x325)](),this[_0x4599a3(0x5cd)](_0xd2394a);else{if(Imported[_0x4599a3(0x808)]){if(VisuMZ['BattleAI'][_0x4599a3(0x620)]<1.19){let _0x4755ce='';_0x4755ce+=_0x4599a3(0x5a0),_0x4755ce+=_0x4599a3(0x9e0),_0x4755ce+=_0x4599a3(0x461),alert(_0x4755ce),SceneManager[_0x4599a3(0x33f)]();}}return this[_0x4599a3(0xc26)]=-0x1,_0xd2394a[_0x4599a3(0x190)](...this[_0x4599a3(0xc5c)]()),this[_0x4599a3(0x5cd)](_0xd2394a);}}if(_0x3767a2[_0x4599a3(0xb9e)](/(\d+) RANDOM ANY/i)){let _0x384b50=Number(RegExp['$1']);while(_0x384b50--){const _0x5cf35e=Math[_0x4599a3(0xb44)](0x2)===0x0?this[_0x4599a3(0x2f2)]():this[_0x4599a3(0x630)]();_0xd2394a[_0x4599a3(0x190)](_0x5cf35e[_0x4599a3(0xada)]());}return this['repeatTargets'](_0xd2394a);}if(_0x3767a2['match'](/(\d+) RANDOM (?:ENEMY|ENEMIES|FOE|FOES)/i)){let _0x19ae55=Number(RegExp['$1']);while(_0x19ae55--){_0xd2394a['push'](this[_0x4599a3(0x2f2)]()[_0x4599a3(0xada)]());}return this[_0x4599a3(0x5cd)](_0xd2394a);}if(_0x3767a2['match'](/(\d+) RANDOM (?:ALLY|ALLIES|FRIEND|FRIENDS)/i)){let _0x49ea67=Number(RegExp['$1']);while(_0x49ea67--){_0xd2394a[_0x4599a3(0x190)](this[_0x4599a3(0x630)]()['trueRandomTarget']());}return this[_0x4599a3(0x5cd)](_0xd2394a);}if(_0x3767a2[_0x4599a3(0xb9e)](/ALL (?:ALLY|ALLIES|FRIEND|FRIENDS) (?:BUT|EXCEPT) (?:USER|SELF)/i))return _0xd2394a[_0x4599a3(0x190)](...this[_0x4599a3(0x630)]()[_0x4599a3(0x9ef)]()['filter'](_0x56569f=>_0x56569f!==this['subject']())),this[_0x4599a3(0x5cd)](_0xd2394a);return VisuMZ[_0x4599a3(0xae3)][_0x4599a3(0x50c)][_0x4599a3(0x390)](this);},Game_Action['prototype']['randomTargets']=function(_0x1fa02e){const _0x1a49ed=_0x2dcaec,_0x2812ab=[];for(let _0x22e0bf=0x0;_0x22e0bf<this[_0x1a49ed(0x7ca)]();_0x22e0bf++){_0x2812ab['push'](_0x1fa02e[_0x1a49ed(0xada)]());}return _0x2812ab;},Game_Action[_0x2dcaec(0xaf6)]['applyTargetFilters']=function(_0x1256e9){const _0x4dd66=_0x2dcaec;if(!this[_0x4dd66(0x719)]())return _0x1256e9;const _0x4e9f24=this[_0x4dd66(0x719)]()[_0x4dd66(0x795)];if(this[_0x4dd66(0x3a4)]()){this[_0x4dd66(0x377)]()&&_0x1256e9['remove'](this[_0x4dd66(0xafb)]());if(_0x1256e9['includes'](this[_0x4dd66(0xafb)]())){const _0x341609=this[_0x4dd66(0x630)]()['aliveMembers']()[_0x4dd66(0xb8d)](this[_0x4dd66(0xafb)]());if(_0x341609['length']>0x0){_0x341609[_0x4dd66(0x6bb)]((_0x5b1792,_0x538805)=>_0x5b1792['hpRate']()-_0x538805[_0x4dd66(0x2e2)]());while(_0x1256e9['includes'](this[_0x4dd66(0xafb)]())){const _0x4569d4=_0x1256e9[_0x4dd66(0x7bc)](this[_0x4dd66(0xafb)]());_0x1256e9[_0x4569d4]=_0x341609[Math[_0x4dd66(0xb44)](_0x341609['length'])];}}else _0x1256e9['remove'](this[_0x4dd66(0xafb)]());}}return _0x1256e9;},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x266)]=Game_Action[_0x2dcaec(0xaf6)]['itemEffectAddAttackState'],Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x8c2)]=function(_0x47b0e1,_0x65454b){const _0x24723e=_0x2dcaec;VisuMZ[_0x24723e(0xae3)][_0x24723e(0x266)][_0x24723e(0x390)](this,_0x47b0e1,_0x65454b);if(!_0x47b0e1[_0x24723e(0x634)]())return;for(const _0xc0a68 of this['subject']()[_0x24723e(0x992)]()){if(_0xc0a68===_0x47b0e1[_0x24723e(0x636)]()){let _0x57cb4e=_0x65454b['value1'];_0x57cb4e*=_0x47b0e1['stateRate'](_0xc0a68),_0x57cb4e*=this['subject']()[_0x24723e(0x955)](_0xc0a68),_0x57cb4e*=this[_0x24723e(0x9c0)](_0x47b0e1),Math[_0x24723e(0x7af)]()<_0x57cb4e&&(_0x47b0e1[_0x24723e(0x5e7)]=!![],this[_0x24723e(0x753)](_0x47b0e1));}}},VisuMZ[_0x2dcaec(0xae3)]['Game_Action_itemEffectAddNormalState']=Game_Action['prototype'][_0x2dcaec(0xa26)],Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0xa26)]=function(_0xe41c36,_0x45347a){const _0x337327=_0x2dcaec;VisuMZ['BattleCore'][_0x337327(0xb4d)][_0x337327(0x390)](this,_0xe41c36,_0x45347a);if(!_0xe41c36[_0x337327(0x634)]())return;if(_0x45347a[_0x337327(0x91d)]!==_0xe41c36[_0x337327(0x636)]())return;let _0x4a2b71=_0x45347a['value1'];!this[_0x337327(0x9eb)]()&&(_0x4a2b71*=_0xe41c36[_0x337327(0x2a6)](_0x45347a[_0x337327(0x91d)]),_0x4a2b71*=this[_0x337327(0x9c0)](_0xe41c36)),Math['random']()<_0x4a2b71&&(_0xe41c36['_deathStateApplied']=!![],this[_0x337327(0x753)](_0xe41c36));},VisuMZ[_0x2dcaec(0xae3)]['Game_Action_applyGlobal']=Game_Action[_0x2dcaec(0xaf6)]['applyGlobal'],Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x329)]=function(){const _0x8c347c=_0x2dcaec;VisuMZ[_0x8c347c(0xae3)][_0x8c347c(0x6db)][_0x8c347c(0x390)](this),this['applyGlobalCommonEventNotetags'](),this[_0x8c347c(0x539)]();},Game_Action['prototype'][_0x2dcaec(0x341)]=function(){const _0x17b76e=_0x2dcaec;if(!SceneManager[_0x17b76e(0xa2b)]())return;const _0x71fba4=/<COMMON (?:EVENT|EVENTS):[ ](.*)>/gi,_0x43ec18=this[_0x17b76e(0x719)]()['note']['match'](_0x71fba4);if(_0x43ec18)for(const _0x2d3c1e of _0x43ec18){if(!_0x2d3c1e)continue;_0x2d3c1e[_0x17b76e(0xb9e)](_0x71fba4);const _0x31d269=String(RegExp['$1'])[_0x17b76e(0x13b)](',')[_0x17b76e(0xc20)](_0x3e6424=>String(_0x3e6424)[_0x17b76e(0x651)]()),_0x975eca=_0x31d269[_0x17b76e(0xc20)](_0x3ce9d4=>DataManager['getCommonEventIdWithName'](_0x3ce9d4));for(const _0x2dcf9c of _0x975eca){const _0x1f0cf9=$dataCommonEvents[_0x2dcf9c];_0x1f0cf9&&$gameTemp[_0x17b76e(0x72f)](_0x2dcf9c);}}},DataManager['getCommonEventIdWithName']=function(_0x511ab2){const _0x467223=_0x2dcaec;_0x511ab2=_0x511ab2['toUpperCase']()[_0x467223(0x651)](),this[_0x467223(0x1a2)]=this[_0x467223(0x1a2)]||{};if(this[_0x467223(0x1a2)][_0x511ab2])return this[_0x467223(0x1a2)][_0x511ab2];for(const _0x5aa906 of $dataCommonEvents){if(!_0x5aa906)continue;let _0x4812f2=_0x5aa906[_0x467223(0x321)];_0x4812f2=_0x4812f2[_0x467223(0x1d3)](/\x1I\[(\d+)\]/gi,''),_0x4812f2=_0x4812f2[_0x467223(0x1d3)](/\\I\[(\d+)\]/gi,''),this[_0x467223(0x1a2)][_0x4812f2[_0x467223(0xb9f)]()['trim']()]=_0x5aa906['id'];}return this[_0x467223(0x1a2)][_0x511ab2]||0x0;},Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x539)]=function(){const _0x167fea=_0x2dcaec;if(!SceneManager[_0x167fea(0xa2b)]())return;const _0x256c42=VisuMZ[_0x167fea(0xae3)][_0x167fea(0xbeb)][_0x167fea(0x41e)];_0x256c42['SwitchCritical']&&$gameSwitches['setValue'](_0x256c42[_0x167fea(0x211)],![]),_0x256c42[_0x167fea(0x87d)]&&$gameSwitches[_0x167fea(0xa8a)](_0x256c42[_0x167fea(0x87d)],![]),_0x256c42[_0x167fea(0xc1d)]&&$gameVariables[_0x167fea(0xa8a)](_0x256c42['VariableDmg'],0x0),_0x256c42[_0x167fea(0x878)]&&$gameVariables[_0x167fea(0xa8a)](_0x256c42[_0x167fea(0x878)],0x0);},Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x454)]=function(_0x4ed87c){const _0x31734e=_0x2dcaec;if(!SceneManager[_0x31734e(0xa2b)]())return;if(!_0x4ed87c)return;const _0x53453b=_0x4ed87c['result'](),_0xb96412=VisuMZ[_0x31734e(0xae3)][_0x31734e(0xbeb)][_0x31734e(0x41e)];_0xb96412[_0x31734e(0x211)]&&_0x53453b[_0x31734e(0x73b)]&&$gameSwitches['setValue'](_0xb96412[_0x31734e(0x211)],!![]);_0xb96412['SwitchMissEvade']&&(_0x53453b[_0x31734e(0x2ef)]||_0x53453b['evaded'])&&$gameSwitches['setValue'](_0xb96412[_0x31734e(0x87d)],!![]);if(_0xb96412[_0x31734e(0xc1d)]){let _0x3977e5=$gameVariables[_0x31734e(0x2df)](_0xb96412[_0x31734e(0xc1d)]);_0x53453b[_0x31734e(0x414)]>0x0&&(_0x3977e5+=Math[_0x31734e(0x2ac)](_0x53453b[_0x31734e(0x414)])),$gameVariables[_0x31734e(0xa8a)](_0xb96412[_0x31734e(0xc1d)],_0x3977e5);}if(_0xb96412[_0x31734e(0x878)]){let _0xea77f9=$gameVariables[_0x31734e(0x2df)](_0xb96412[_0x31734e(0x878)]);_0x53453b[_0x31734e(0x414)]<0x0&&(_0xea77f9+=Math[_0x31734e(0x2ac)](_0x53453b[_0x31734e(0x414)])),$gameVariables[_0x31734e(0xa8a)](_0xb96412[_0x31734e(0x878)],_0xea77f9);}},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x8d2)]={'lifeSteaItem':/<(.*?) (?:LIFE|MANA) STEAL:[ ](\d+)([%％])>/gi,'lifeStealTrait':/<(.*?) (?:LIFE|MANA) STEAL (.*?):[ ]([\+\-]\d+)([%％])>/gi,'cancelLifeSteal':/<CANCEL LIFE STEAL>/i,'cancelHpLifeSteal':/<CANCEL HP LIFE STEAL>/i,'cancelMpLifeSteal':/<CANCEL MP LIFE STEAL>/i,'guardLifeSteal':/<GUARD LIFE STEAL>/i,'guardHpLifeSteal':/<GUARD HP LIFE STEAL>/i,'guardMpLifeSteal':/<GUARD MP LIFE STEAL>/i,'disarmLifeSteal':/<DISARM LIFE STEAL>/i,'disarmHpLifeSteal':/<DISARM HP LIFE STEAL>/i,'disarmMpLifeSteal':/<DISARM MP LIFE STEAL>/i,'negativeLifeSteal':/<REVERSE LIFE STEAL>/i,'negativeHpLifeSteal':/<REVERSE HP LIFE STEAL>/i,'negativeMpLifeSteal':/<REVERSE MP LIFE STEAL>/i},VisuMZ[_0x2dcaec(0xae3)]['Game_Action_executeHpDamage']=Game_Action[_0x2dcaec(0xaf6)]['executeHpDamage'],Game_Action[_0x2dcaec(0xaf6)]['executeHpDamage']=function(_0x3d53df,_0x209bef){const _0x5762ad=_0x2dcaec;VisuMZ[_0x5762ad(0xae3)][_0x5762ad(0x1f2)][_0x5762ad(0x390)](this,_0x3d53df,_0x209bef);!this['isDrain']()&&_0x3d53df&&_0x3d53df[_0x5762ad(0x1b5)]()[_0x5762ad(0x414)]>0x0&&this[_0x5762ad(0x528)]('HP',_0x3d53df,_0x3d53df[_0x5762ad(0x1b5)]()[_0x5762ad(0x414)]);if(_0x3d53df){this[_0x5762ad(0x73c)]=this[_0x5762ad(0x73c)]||{};const _0x2a7b82=_0x3d53df['battlerKey']();this['_executeHpDamage'][_0x2a7b82]=_0x209bef;}},Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x871)]=function(_0x4cedd8){const _0x5770c3=_0x2dcaec;this[_0x5770c3(0x73c)]=this['_executeHpDamage']||{};const _0x450d23=_0x4cedd8[_0x5770c3(0x233)]();return this[_0x5770c3(0x73c)][_0x450d23]||0x0;},VisuMZ[_0x2dcaec(0xae3)][_0x2dcaec(0x337)]=Game_Action[_0x2dcaec(0xaf6)][_0x2dcaec(0x9ce)],Game_Action['prototype'][_0x2dcaec(0x9ce)]=function(_0x10265a,_0x4e7db6){const _0x2f59cc=_0x2dcaec;VisuMZ[_0x2f59cc(0xae3)][_0x2f59cc(0x337)][_0x2f59cc(0x390)](this,_0x10265a,_0x4e7db6),!this[_0x2f59cc(0x5f0)]()&&_0x10265a&&_0x10265a['result']()[_0x2f59cc(0x790)]>0x0&&this['performLifeSteal']('MP',_0x10265a,_0x10265a[_0x2f59cc(0x1b5)]()['mpDamage']);},Game_Action[_0x2dcaec(0xaf6)]['performLifeSteal']=function(_0x2a5563,_0xd5c67f,_0x7a14de){const _0x14de2c=_0x2dcaec;_0x2a5563=_0x2a5563[_0x14de2c(0xb9f)]()[_0x14de2c(0x651)]();const _0x3f236f=this[_0x14de2c(0x9b8)](_0x2a5563,_0xd5c67f);if(_0x3f236f<=0x0)return;const _0x161278=Math[_0x14de2c(0x976)](_0x7a14de*_0x3f236f);if(_0x161278<=0x0)return;let _0xdd2d39=this[_0x14de2c(0xafb)]();if(this[_0x14de2c(0xaf4)])_0xdd2d39=this['_reflectionTarget'];const _0x42aa7f=_0xd5c67f['isNegativeLifeSteal'](_0x2a5563)?-0x1:0x1;if(_0x2a5563==='HP')_0xdd2d39[_0x14de2c(0xc73)](_0x42aa7f*_0x161278);if(_0x2a5563==='MP')_0xdd2d39[_0x14de2c(0x77c)](_0x42aa7f*_0x161278);},Game_Action['prototype'][_0x2dcaec(0x9b8)]=function(_0x2d18b0,_0x4c438e){const _0x2a5a43=_0x2dcaec;if(this[_0x2a5a43(0xad1)](_0x2d18b0))return 0x0;if(this['subject']()[_0x2a5a43(0x2b1)](_0x2d18b0))return 0x0;if(_0x4c438e[_0x2a5a43(0xacc)](_0x2d18b0))return 0x0;let _0x4fbb41=0x0;return _0x4fbb41+=this[_0x2a5a43(0x245)](_0x2d18b0),_0x4fbb41+=this[_0x2a5a43(0xafb)]()[_0x2a5a43(0x9b8)](_0x2d18b0,this[_0x2a5a43(0x719)]()[_0x2a5a43(0x95b)]),_0x4fbb41['clamp'](0x0,0x1);},Game_Action[_0x2dcaec(0xaf6)]['isCancelLifeSteal']=function(_0xb43917){const _0x88e2a9=_0x2dcaec;_0xb43917=_0xb43917[_0x88e2a9(0xb9f)]()[_0x88e2a9(0x651)]();const _0x4a4a18=VisuMZ[_0x88e2a9(0xae3)][_0x88e2a9(0x8d2)],_0x8bd764=this[_0x88e2a9(0x719)]()[_0x88e2a9(0x795)]||'';if(_0x8bd764[_0x88e2a9(0xb9e)](_0x4a4a18[_0x88e2a9(0x2c9)]))r